/*
** Zabbix
** Copyright (C) 2001-2025 Zabbix SIA
**
** Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
** documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
** rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
** permit persons to whom the Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in all copies or substantial portions
** of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
** WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
** COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
** SOFTWARE.
**/

package log

import (
	"testing"

	"github.com/google/go-cmp/cmp"
)

//nolint:paralleltest
func TestCheckLogLevel(t *testing.T) {
	type fields struct {
		logLevel int
	}

	type args struct {
		level int
	}

	tests := []struct {
		name   string
		fields fields
		args   args
		want   bool
	}{
		{
			"+valid",
			fields{logLevel: 3},
			args{level: 2},
			true,
		},
		{
			"+validDecreasedVerbosity",
			fields{logLevel: 3},
			args{level: 5},
			false,
		},
		{
			"+validEqual",
			fields{logLevel: 3},
			args{level: 3},
			true,
		},
		{
			"-empty",
			fields{},
			args{},
			true,
		},
	}
	for _, tt := range tests { //nolint:paralleltest
		t.Run(tt.name, func(t *testing.T) {
			logLevel = tt.fields.logLevel

			got := CheckLogLevel(tt.args.level)
			if diff := cmp.Diff(tt.want, got); diff != "" {
				t.Fatalf("CheckLogLevel() missmatch (-want +got):\n%s", diff)
			}
		})
	}
}
