/// <reference types="react" />
/**
 * Executes the initializer function once and saves its result into a ref.
 *
 * ```js
 * const ref = useLazyRef(() => 10);
 * ```
 *
 * @param initializer
 */
export default function useLazyRef<T>(initializer: () => T): React.MutableRefObject<T>;
