// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// CreateClusterReader is a Reader for the CreateCluster structure.
type CreateClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateClusterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateClusterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateClusterOK creates a CreateClusterOK with default headers values
func NewCreateClusterOK() *CreateClusterOK {
	return &CreateClusterOK{}
}

/*
CreateClusterOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateClusterOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215CreateClusterResponse
}

// IsSuccess returns true when this create cluster o k response has a 2xx status code
func (o *CreateClusterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create cluster o k response has a 3xx status code
func (o *CreateClusterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create cluster o k response has a 4xx status code
func (o *CreateClusterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create cluster o k response has a 5xx status code
func (o *CreateClusterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create cluster o k response a status code equal to that given
func (o *CreateClusterOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create cluster o k response
func (o *CreateClusterOK) Code() int {
	return 200
}

func (o *CreateClusterOK) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] createClusterOK  %+v", 200, o.Payload)
}

func (o *CreateClusterOK) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] createClusterOK  %+v", 200, o.Payload)
}

func (o *CreateClusterOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215CreateClusterResponse {
	return o.Payload
}

func (o *CreateClusterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215CreateClusterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateClusterDefault creates a CreateClusterDefault with default headers values
func NewCreateClusterDefault(code int) *CreateClusterDefault {
	return &CreateClusterDefault{
		_statusCode: code,
	}
}

/*
CreateClusterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateClusterDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this create cluster default response has a 2xx status code
func (o *CreateClusterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create cluster default response has a 3xx status code
func (o *CreateClusterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create cluster default response has a 4xx status code
func (o *CreateClusterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create cluster default response has a 5xx status code
func (o *CreateClusterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create cluster default response a status code equal to that given
func (o *CreateClusterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create cluster default response
func (o *CreateClusterDefault) Code() int {
	return o._statusCode
}

func (o *CreateClusterDefault) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] CreateCluster default  %+v", o._statusCode, o.Payload)
}

func (o *CreateClusterDefault) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] CreateCluster default  %+v", o._statusCode, o.Payload)
}

func (o *CreateClusterDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *CreateClusterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreateClusterBody create cluster body
swagger:model CreateClusterBody
*/
type CreateClusterBody struct {

	// consul_access_level is an optional field to configure the access level that
	// CCM will have to manage the Consul cluster. When unspecified, it will
	// default to a value depending on how other request parameters; most likely
	// GLOBAL_READ_WRITE, since GLOBAL_READ_ONLY needs to be specifically indicated
	ConsulAccessLevel *models.HashicorpCloudGlobalNetworkManager20220215ClusterConsulAccessLevel `json:"consul_access_level,omitempty"`

	// existing_cluster indicates whether or not the cluster existed before creation (for linking)
	ExistingCluster bool `json:"existing_cluster,omitempty"`

	// id is the user settable GNM cluster name
	ID string `json:"id,omitempty"`

	// location
	Location *CreateClusterParamsBodyLocation `json:"location,omitempty"`

	// management_token is an optional field to set a user-submitted management
	// token that CCM will use manage the Consul cluster. When empty, we will
	// auto-generate a management token for the cluster
	ManagementToken string `json:"management_token,omitempty"`

	// source is the runtime type for the cluster
	Source *models.HashicorpCloudGlobalNetworkManager20220215ClusterSource `json:"source,omitempty"`
}

// Validate validates this create cluster body
func (o *CreateClusterBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConsulAccessLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateClusterBody) validateConsulAccessLevel(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsulAccessLevel) { // not required
		return nil
	}

	if o.ConsulAccessLevel != nil {
		if err := o.ConsulAccessLevel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "consul_access_level")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "consul_access_level")
			}
			return err
		}
	}

	return nil
}

func (o *CreateClusterBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *CreateClusterBody) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create cluster body based on the context it is used
func (o *CreateClusterBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConsulAccessLevel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateClusterBody) contextValidateConsulAccessLevel(ctx context.Context, formats strfmt.Registry) error {

	if o.ConsulAccessLevel != nil {

		if swag.IsZero(o.ConsulAccessLevel) { // not required
			return nil
		}

		if err := o.ConsulAccessLevel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "consul_access_level")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "consul_access_level")
			}
			return err
		}
	}

	return nil
}

func (o *CreateClusterBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *CreateClusterBody) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {

		if swag.IsZero(o.Source) { // not required
			return nil
		}

		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateClusterBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateClusterBody) UnmarshalBinary(b []byte) error {
	var res CreateClusterBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreateClusterParamsBodyLocation location is the location of the cluster with an optional provider and region
swagger:model CreateClusterParamsBodyLocation
*/
type CreateClusterParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this create cluster params body location
func (o *CreateClusterParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateClusterParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create cluster params body location based on the context it is used
func (o *CreateClusterParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateClusterParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateClusterParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateClusterParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreateClusterParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
