import * as React from "react";
import useQueryParams from "./useQueryParams";
function withQueryParams(paramConfigMap, WrappedComponent) {
  const Component = (props) => {
    const [query, setQuery] = useQueryParams(paramConfigMap);
    return /* @__PURE__ */ React.createElement(WrappedComponent, {
      query,
      setQuery,
      ...props
    });
  };
  Component.displayName = `withQueryParams(${WrappedComponent.displayName || WrappedComponent.name || "Component"})`;
  return Component;
}
var withQueryParams_default = withQueryParams;
function withQueryParamsMapped(paramConfigMap, mapToProps, WrappedComponent) {
  const Component = (props) => {
    const [query, setQuery] = useQueryParams(paramConfigMap);
    const propsToAdd = mapToProps(query, setQuery, props);
    return /* @__PURE__ */ React.createElement(WrappedComponent, {
      ...propsToAdd,
      ...props
    });
  };
  Component.displayName = `withQueryParams(${WrappedComponent.displayName || WrappedComponent.name || "Component"})`;
  return Component;
}
export {
  withQueryParams_default as default,
  withQueryParams,
  withQueryParamsMapped
};
//# sourceMappingURL=withQueryParams.js.map
