
mod aruco_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::aruco::EstimateParameters,
		cv_PtrLcv_aruco_EstimateParametersG_new_null_const, cv_PtrLcv_aruco_EstimateParametersG_delete, cv_PtrLcv_aruco_EstimateParametersG_getInnerPtr_const, cv_PtrLcv_aruco_EstimateParametersG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::aruco::EstimateParameters, cv_PtrLcv_aruco_EstimateParametersG_new_const_EstimateParameters }
	impl core::Ptr<crate::aruco::EstimateParameters> {
		#[inline] pub fn as_raw_PtrOfEstimateParameters(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEstimateParameters(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::aruco::EstimateParametersTraitConst for core::Ptr<crate::aruco::EstimateParameters> {
		#[inline] fn as_raw_EstimateParameters(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::aruco::EstimateParametersTrait for core::Ptr<crate::aruco::EstimateParameters> {
		#[inline] fn as_raw_mut_EstimateParameters(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::aruco::EstimateParameters> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEstimateParameters")
				.field("pattern", &crate::aruco::EstimateParametersTraitConst::pattern(self))
				.field("use_extrinsic_guess", &crate::aruco::EstimateParametersTraitConst::use_extrinsic_guess(self))
				.field("solve_pnp_method", &crate::aruco::EstimateParametersTraitConst::solve_pnp_method(self))
				.finish()
		}
	}

}
pub use aruco_types::*;

mod bgsegm_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::bgsegm::BackgroundSubtractorCNT,
		cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_new_null_const, cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_delete, cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_getInnerPtr_const, cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_getInnerPtrMut
	}

	impl core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline] pub fn as_raw_PtrOfBackgroundSubtractorCNT(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBackgroundSubtractorCNT(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bgsegm::BackgroundSubtractorCNTTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline] fn as_raw_BackgroundSubtractorCNT(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bgsegm::BackgroundSubtractorCNTTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline] fn as_raw_mut_BackgroundSubtractorCNT(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorCNT>, core::Ptr<core::Algorithm>, cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorCNT>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::bgsegm::BackgroundSubtractorCNT> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBackgroundSubtractorCNT")
				.finish()
		}
	}

	ptr_extern! { crate::bgsegm::BackgroundSubtractorGMG,
		cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_new_null_const, cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_delete, cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_getInnerPtr_const, cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_getInnerPtrMut
	}

	impl core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline] pub fn as_raw_PtrOfBackgroundSubtractorGMG(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBackgroundSubtractorGMG(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bgsegm::BackgroundSubtractorGMGTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline] fn as_raw_BackgroundSubtractorGMG(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bgsegm::BackgroundSubtractorGMGTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline] fn as_raw_mut_BackgroundSubtractorGMG(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorGMG>, core::Ptr<core::Algorithm>, cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorGMG>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::bgsegm::BackgroundSubtractorGMG> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBackgroundSubtractorGMG")
				.finish()
		}
	}

	ptr_extern! { crate::bgsegm::BackgroundSubtractorGSOC,
		cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_new_null_const, cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_delete, cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_getInnerPtr_const, cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_getInnerPtrMut
	}

	impl core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline] pub fn as_raw_PtrOfBackgroundSubtractorGSOC(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBackgroundSubtractorGSOC(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bgsegm::BackgroundSubtractorGSOCTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline] fn as_raw_BackgroundSubtractorGSOC(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bgsegm::BackgroundSubtractorGSOCTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline] fn as_raw_mut_BackgroundSubtractorGSOC(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC>, core::Ptr<core::Algorithm>, cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::bgsegm::BackgroundSubtractorGSOC> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBackgroundSubtractorGSOC")
				.finish()
		}
	}

	ptr_extern! { crate::bgsegm::BackgroundSubtractorLSBP,
		cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_new_null_const, cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_delete, cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_getInnerPtr_const, cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_getInnerPtrMut
	}

	impl core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline] pub fn as_raw_PtrOfBackgroundSubtractorLSBP(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBackgroundSubtractorLSBP(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bgsegm::BackgroundSubtractorLSBPTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline] fn as_raw_BackgroundSubtractorLSBP(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bgsegm::BackgroundSubtractorLSBPTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline] fn as_raw_mut_BackgroundSubtractorLSBP(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP>, core::Ptr<core::Algorithm>, cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::bgsegm::BackgroundSubtractorLSBP> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBackgroundSubtractorLSBP")
				.finish()
		}
	}

	ptr_extern! { crate::bgsegm::BackgroundSubtractorMOG,
		cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_new_null_const, cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_delete, cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_getInnerPtr_const, cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_getInnerPtrMut
	}

	impl core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline] pub fn as_raw_PtrOfBackgroundSubtractorMOG(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBackgroundSubtractorMOG(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bgsegm::BackgroundSubtractorMOGTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline] fn as_raw_BackgroundSubtractorMOG(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bgsegm::BackgroundSubtractorMOGTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline] fn as_raw_mut_BackgroundSubtractorMOG(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorMOG>, core::Ptr<core::Algorithm>, cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::BackgroundSubtractorMOG>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::bgsegm::BackgroundSubtractorMOG> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBackgroundSubtractorMOG")
				.finish()
		}
	}

	ptr_extern! { crate::bgsegm::SyntheticSequenceGenerator,
		cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_new_null_const, cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_delete, cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_getInnerPtr_const, cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::bgsegm::SyntheticSequenceGenerator, cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_new_const_SyntheticSequenceGenerator }
	impl core::Ptr<crate::bgsegm::SyntheticSequenceGenerator> {
		#[inline] pub fn as_raw_PtrOfSyntheticSequenceGenerator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSyntheticSequenceGenerator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bgsegm::SyntheticSequenceGeneratorTraitConst for core::Ptr<crate::bgsegm::SyntheticSequenceGenerator> {
		#[inline] fn as_raw_SyntheticSequenceGenerator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bgsegm::SyntheticSequenceGeneratorTrait for core::Ptr<crate::bgsegm::SyntheticSequenceGenerator> {
		#[inline] fn as_raw_mut_SyntheticSequenceGenerator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bgsegm::SyntheticSequenceGenerator> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bgsegm::SyntheticSequenceGenerator> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bgsegm::SyntheticSequenceGenerator>, core::Ptr<core::Algorithm>, cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::bgsegm::SyntheticSequenceGenerator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSyntheticSequenceGenerator")
				.finish()
		}
	}

}
pub use bgsegm_types::*;

mod bioinspired_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::bioinspired::Retina,
		cv_PtrLcv_bioinspired_RetinaG_new_null_const, cv_PtrLcv_bioinspired_RetinaG_delete, cv_PtrLcv_bioinspired_RetinaG_getInnerPtr_const, cv_PtrLcv_bioinspired_RetinaG_getInnerPtrMut
	}

	impl core::Ptr<crate::bioinspired::Retina> {
		#[inline] pub fn as_raw_PtrOfRetina(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRetina(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bioinspired::RetinaTraitConst for core::Ptr<crate::bioinspired::Retina> {
		#[inline] fn as_raw_Retina(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bioinspired::RetinaTrait for core::Ptr<crate::bioinspired::Retina> {
		#[inline] fn as_raw_mut_Retina(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bioinspired::Retina> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bioinspired::Retina> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bioinspired::Retina>, core::Ptr<core::Algorithm>, cv_PtrLcv_bioinspired_RetinaG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::bioinspired::Retina> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRetina")
				.finish()
		}
	}

	ptr_extern! { crate::bioinspired::RetinaFastToneMapping,
		cv_PtrLcv_bioinspired_RetinaFastToneMappingG_new_null_const, cv_PtrLcv_bioinspired_RetinaFastToneMappingG_delete, cv_PtrLcv_bioinspired_RetinaFastToneMappingG_getInnerPtr_const, cv_PtrLcv_bioinspired_RetinaFastToneMappingG_getInnerPtrMut
	}

	impl core::Ptr<crate::bioinspired::RetinaFastToneMapping> {
		#[inline] pub fn as_raw_PtrOfRetinaFastToneMapping(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRetinaFastToneMapping(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bioinspired::RetinaFastToneMappingTraitConst for core::Ptr<crate::bioinspired::RetinaFastToneMapping> {
		#[inline] fn as_raw_RetinaFastToneMapping(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bioinspired::RetinaFastToneMappingTrait for core::Ptr<crate::bioinspired::RetinaFastToneMapping> {
		#[inline] fn as_raw_mut_RetinaFastToneMapping(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bioinspired::RetinaFastToneMapping> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bioinspired::RetinaFastToneMapping> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bioinspired::RetinaFastToneMapping>, core::Ptr<core::Algorithm>, cv_PtrLcv_bioinspired_RetinaFastToneMappingG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::bioinspired::RetinaFastToneMapping> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRetinaFastToneMapping")
				.finish()
		}
	}

	ptr_extern! { crate::bioinspired::TransientAreasSegmentationModule,
		cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_new_null_const, cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_delete, cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_getInnerPtr_const, cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_getInnerPtrMut
	}

	impl core::Ptr<crate::bioinspired::TransientAreasSegmentationModule> {
		#[inline] pub fn as_raw_PtrOfTransientAreasSegmentationModule(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTransientAreasSegmentationModule(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::bioinspired::TransientAreasSegmentationModuleTraitConst for core::Ptr<crate::bioinspired::TransientAreasSegmentationModule> {
		#[inline] fn as_raw_TransientAreasSegmentationModule(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::bioinspired::TransientAreasSegmentationModuleTrait for core::Ptr<crate::bioinspired::TransientAreasSegmentationModule> {
		#[inline] fn as_raw_mut_TransientAreasSegmentationModule(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::bioinspired::TransientAreasSegmentationModule> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::bioinspired::TransientAreasSegmentationModule> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::bioinspired::TransientAreasSegmentationModule>, core::Ptr<core::Algorithm>, cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::bioinspired::TransientAreasSegmentationModule> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTransientAreasSegmentationModule")
				.finish()
		}
	}

}
pub use bioinspired_types::*;

mod calib3d_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::calib3d::LMSolver,
		cv_PtrLcv_LMSolverG_new_null_const, cv_PtrLcv_LMSolverG_delete, cv_PtrLcv_LMSolverG_getInnerPtr_const, cv_PtrLcv_LMSolverG_getInnerPtrMut
	}

	impl core::Ptr<crate::calib3d::LMSolver> {
		#[inline] pub fn as_raw_PtrOfLMSolver(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLMSolver(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::calib3d::LMSolverTraitConst for core::Ptr<crate::calib3d::LMSolver> {
		#[inline] fn as_raw_LMSolver(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::LMSolverTrait for core::Ptr<crate::calib3d::LMSolver> {
		#[inline] fn as_raw_mut_LMSolver(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::calib3d::LMSolver> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::calib3d::LMSolver> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::calib3d::LMSolver>, core::Ptr<core::Algorithm>, cv_PtrLcv_LMSolverG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::calib3d::LMSolver> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLMSolver")
				.finish()
		}
	}

	ptr_extern! { crate::calib3d::LMSolver_Callback,
		cv_PtrLcv_LMSolver_CallbackG_new_null_const, cv_PtrLcv_LMSolver_CallbackG_delete, cv_PtrLcv_LMSolver_CallbackG_getInnerPtr_const, cv_PtrLcv_LMSolver_CallbackG_getInnerPtrMut
	}

	impl core::Ptr<crate::calib3d::LMSolver_Callback> {
		#[inline] pub fn as_raw_PtrOfLMSolver_Callback(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLMSolver_Callback(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::calib3d::LMSolver_CallbackTraitConst for core::Ptr<crate::calib3d::LMSolver_Callback> {
		#[inline] fn as_raw_LMSolver_Callback(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::LMSolver_CallbackTrait for core::Ptr<crate::calib3d::LMSolver_Callback> {
		#[inline] fn as_raw_mut_LMSolver_Callback(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::calib3d::LMSolver_Callback> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLMSolver_Callback")
				.finish()
		}
	}

	ptr_extern! { crate::calib3d::StereoBM,
		cv_PtrLcv_StereoBMG_new_null_const, cv_PtrLcv_StereoBMG_delete, cv_PtrLcv_StereoBMG_getInnerPtr_const, cv_PtrLcv_StereoBMG_getInnerPtrMut
	}

	impl core::Ptr<crate::calib3d::StereoBM> {
		#[inline] pub fn as_raw_PtrOfStereoBM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStereoBM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::calib3d::StereoBMTraitConst for core::Ptr<crate::calib3d::StereoBM> {
		#[inline] fn as_raw_StereoBM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoBMTrait for core::Ptr<crate::calib3d::StereoBM> {
		#[inline] fn as_raw_mut_StereoBM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::calib3d::StereoBM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::calib3d::StereoBM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::calib3d::StereoBM>, core::Ptr<core::Algorithm>, cv_PtrLcv_StereoBMG_to_PtrOfAlgorithm }

	impl crate::calib3d::StereoMatcherTraitConst for core::Ptr<crate::calib3d::StereoBM> {
		#[inline] fn as_raw_StereoMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoMatcherTrait for core::Ptr<crate::calib3d::StereoBM> {
		#[inline] fn as_raw_mut_StereoMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::calib3d::StereoBM>, core::Ptr<crate::calib3d::StereoMatcher>, cv_PtrLcv_StereoBMG_to_PtrOfStereoMatcher }

	impl std::fmt::Debug for core::Ptr<crate::calib3d::StereoBM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStereoBM")
				.finish()
		}
	}

	ptr_extern! { crate::calib3d::StereoMatcher,
		cv_PtrLcv_StereoMatcherG_new_null_const, cv_PtrLcv_StereoMatcherG_delete, cv_PtrLcv_StereoMatcherG_getInnerPtr_const, cv_PtrLcv_StereoMatcherG_getInnerPtrMut
	}

	impl core::Ptr<crate::calib3d::StereoMatcher> {
		#[inline] pub fn as_raw_PtrOfStereoMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStereoMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::calib3d::StereoMatcherTraitConst for core::Ptr<crate::calib3d::StereoMatcher> {
		#[inline] fn as_raw_StereoMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoMatcherTrait for core::Ptr<crate::calib3d::StereoMatcher> {
		#[inline] fn as_raw_mut_StereoMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::calib3d::StereoMatcher> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::calib3d::StereoMatcher> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::calib3d::StereoMatcher>, core::Ptr<core::Algorithm>, cv_PtrLcv_StereoMatcherG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::calib3d::StereoMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStereoMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::calib3d::StereoSGBM,
		cv_PtrLcv_StereoSGBMG_new_null_const, cv_PtrLcv_StereoSGBMG_delete, cv_PtrLcv_StereoSGBMG_getInnerPtr_const, cv_PtrLcv_StereoSGBMG_getInnerPtrMut
	}

	impl core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline] pub fn as_raw_PtrOfStereoSGBM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStereoSGBM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::calib3d::StereoSGBMTraitConst for core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline] fn as_raw_StereoSGBM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoSGBMTrait for core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline] fn as_raw_mut_StereoSGBM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::calib3d::StereoSGBM>, core::Ptr<core::Algorithm>, cv_PtrLcv_StereoSGBMG_to_PtrOfAlgorithm }

	impl crate::calib3d::StereoMatcherTraitConst for core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline] fn as_raw_StereoMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoMatcherTrait for core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline] fn as_raw_mut_StereoMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::calib3d::StereoSGBM>, core::Ptr<crate::calib3d::StereoMatcher>, cv_PtrLcv_StereoSGBMG_to_PtrOfStereoMatcher }

	impl std::fmt::Debug for core::Ptr<crate::calib3d::StereoSGBM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStereoSGBM")
				.finish()
		}
	}

}
pub use calib3d_types::*;

mod ccalib_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::ccalib::CustomPattern,
		cv_PtrLcv_ccalib_CustomPatternG_new_null_const, cv_PtrLcv_ccalib_CustomPatternG_delete, cv_PtrLcv_ccalib_CustomPatternG_getInnerPtr_const, cv_PtrLcv_ccalib_CustomPatternG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::ccalib::CustomPattern, cv_PtrLcv_ccalib_CustomPatternG_new_const_CustomPattern }
	impl core::Ptr<crate::ccalib::CustomPattern> {
		#[inline] pub fn as_raw_PtrOfCustomPattern(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCustomPattern(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ccalib::CustomPatternTraitConst for core::Ptr<crate::ccalib::CustomPattern> {
		#[inline] fn as_raw_CustomPattern(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ccalib::CustomPatternTrait for core::Ptr<crate::ccalib::CustomPattern> {
		#[inline] fn as_raw_mut_CustomPattern(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ccalib::CustomPattern> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ccalib::CustomPattern> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ccalib::CustomPattern>, core::Ptr<core::Algorithm>, cv_PtrLcv_ccalib_CustomPatternG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::ccalib::CustomPattern> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCustomPattern")
				.finish()
		}
	}

}
pub use ccalib_types::*;

mod core_types {
	use crate::{mod_prelude::*, core, types, sys};

	impl core::GpuMat_AllocatorTraitConst for types::AbstractRefMut<'static, core::GpuMat_Allocator> {
		#[inline] fn as_raw_GpuMat_Allocator(&self) -> extern_send!(Self) { self.as_raw() }
	}

	impl core::GpuMat_AllocatorTrait for types::AbstractRefMut<'static, core::GpuMat_Allocator> {
		#[inline] fn as_raw_mut_GpuMat_Allocator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	ptr_extern! { core::Algorithm,
		cv_PtrLcv_AlgorithmG_new_null_const, cv_PtrLcv_AlgorithmG_delete, cv_PtrLcv_AlgorithmG_getInnerPtr_const, cv_PtrLcv_AlgorithmG_getInnerPtrMut
	}

	ptr_extern_ctor! { core::Algorithm, cv_PtrLcv_AlgorithmG_new_const_Algorithm }
	impl core::Ptr<core::Algorithm> {
		#[inline] pub fn as_raw_PtrOfAlgorithm(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAlgorithm(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<core::Algorithm> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<core::Algorithm> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::Algorithm> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAlgorithm")
				.finish()
		}
	}

	ptr_extern! { core::ConjGradSolver,
		cv_PtrLcv_ConjGradSolverG_new_null_const, cv_PtrLcv_ConjGradSolverG_delete, cv_PtrLcv_ConjGradSolverG_getInnerPtr_const, cv_PtrLcv_ConjGradSolverG_getInnerPtrMut
	}

	impl core::Ptr<core::ConjGradSolver> {
		#[inline] pub fn as_raw_PtrOfConjGradSolver(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfConjGradSolver(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::ConjGradSolverTraitConst for core::Ptr<core::ConjGradSolver> {
		#[inline] fn as_raw_ConjGradSolver(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::ConjGradSolverTrait for core::Ptr<core::ConjGradSolver> {
		#[inline] fn as_raw_mut_ConjGradSolver(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<core::ConjGradSolver> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<core::ConjGradSolver> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<core::ConjGradSolver>, core::Ptr<core::Algorithm>, cv_PtrLcv_ConjGradSolverG_to_PtrOfAlgorithm }

	impl core::MinProblemSolverTraitConst for core::Ptr<core::ConjGradSolver> {
		#[inline] fn as_raw_MinProblemSolver(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::MinProblemSolverTrait for core::Ptr<core::ConjGradSolver> {
		#[inline] fn as_raw_mut_MinProblemSolver(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<core::ConjGradSolver>, core::Ptr<core::MinProblemSolver>, cv_PtrLcv_ConjGradSolverG_to_PtrOfMinProblemSolver }

	impl std::fmt::Debug for core::Ptr<core::ConjGradSolver> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfConjGradSolver")
				.finish()
		}
	}

	ptr_extern! { core::DownhillSolver,
		cv_PtrLcv_DownhillSolverG_new_null_const, cv_PtrLcv_DownhillSolverG_delete, cv_PtrLcv_DownhillSolverG_getInnerPtr_const, cv_PtrLcv_DownhillSolverG_getInnerPtrMut
	}

	impl core::Ptr<core::DownhillSolver> {
		#[inline] pub fn as_raw_PtrOfDownhillSolver(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDownhillSolver(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::DownhillSolverTraitConst for core::Ptr<core::DownhillSolver> {
		#[inline] fn as_raw_DownhillSolver(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::DownhillSolverTrait for core::Ptr<core::DownhillSolver> {
		#[inline] fn as_raw_mut_DownhillSolver(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<core::DownhillSolver> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<core::DownhillSolver> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<core::DownhillSolver>, core::Ptr<core::Algorithm>, cv_PtrLcv_DownhillSolverG_to_PtrOfAlgorithm }

	impl core::MinProblemSolverTraitConst for core::Ptr<core::DownhillSolver> {
		#[inline] fn as_raw_MinProblemSolver(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::MinProblemSolverTrait for core::Ptr<core::DownhillSolver> {
		#[inline] fn as_raw_mut_MinProblemSolver(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<core::DownhillSolver>, core::Ptr<core::MinProblemSolver>, cv_PtrLcv_DownhillSolverG_to_PtrOfMinProblemSolver }

	impl std::fmt::Debug for core::Ptr<core::DownhillSolver> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDownhillSolver")
				.finish()
		}
	}

	ptr_extern! { core::FileStorage,
		cv_PtrLcv_FileStorageG_new_null_const, cv_PtrLcv_FileStorageG_delete, cv_PtrLcv_FileStorageG_getInnerPtr_const, cv_PtrLcv_FileStorageG_getInnerPtrMut
	}

	ptr_extern_ctor! { core::FileStorage, cv_PtrLcv_FileStorageG_new_const_FileStorage }
	impl core::Ptr<core::FileStorage> {
		#[inline] pub fn as_raw_PtrOfFileStorage(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFileStorage(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::FileStorageTraitConst for core::Ptr<core::FileStorage> {
		#[inline] fn as_raw_FileStorage(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::FileStorageTrait for core::Ptr<core::FileStorage> {
		#[inline] fn as_raw_mut_FileStorage(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::FileStorage> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFileStorage")
				.field("state", &core::FileStorageTraitConst::state(self))
				.field("elname", &core::FileStorageTraitConst::elname(self))
				.finish()
		}
	}

	ptr_extern! { core::Formatted,
		cv_PtrLcv_FormattedG_new_null_const, cv_PtrLcv_FormattedG_delete, cv_PtrLcv_FormattedG_getInnerPtr_const, cv_PtrLcv_FormattedG_getInnerPtrMut
	}

	impl core::Ptr<core::Formatted> {
		#[inline] pub fn as_raw_PtrOfFormatted(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFormatted(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::FormattedTraitConst for core::Ptr<core::Formatted> {
		#[inline] fn as_raw_Formatted(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::FormattedTrait for core::Ptr<core::Formatted> {
		#[inline] fn as_raw_mut_Formatted(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::Formatted> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFormatted")
				.finish()
		}
	}

	ptr_extern! { core::Formatter,
		cv_PtrLcv_FormatterG_new_null_const, cv_PtrLcv_FormatterG_delete, cv_PtrLcv_FormatterG_getInnerPtr_const, cv_PtrLcv_FormatterG_getInnerPtrMut
	}

	impl core::Ptr<core::Formatter> {
		#[inline] pub fn as_raw_PtrOfFormatter(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFormatter(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::FormatterTraitConst for core::Ptr<core::Formatter> {
		#[inline] fn as_raw_Formatter(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::FormatterTrait for core::Ptr<core::Formatter> {
		#[inline] fn as_raw_mut_Formatter(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::Formatter> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFormatter")
				.finish()
		}
	}

	ptr_extern! { core::GpuMat_Allocator,
		cv_PtrLcv_cuda_GpuMat_AllocatorG_new_null_const, cv_PtrLcv_cuda_GpuMat_AllocatorG_delete, cv_PtrLcv_cuda_GpuMat_AllocatorG_getInnerPtr_const, cv_PtrLcv_cuda_GpuMat_AllocatorG_getInnerPtrMut
	}

	impl core::Ptr<core::GpuMat_Allocator> {
		#[inline] pub fn as_raw_PtrOfGpuMat_Allocator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGpuMat_Allocator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::GpuMat_AllocatorTraitConst for core::Ptr<core::GpuMat_Allocator> {
		#[inline] fn as_raw_GpuMat_Allocator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::GpuMat_AllocatorTrait for core::Ptr<core::GpuMat_Allocator> {
		#[inline] fn as_raw_mut_GpuMat_Allocator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::GpuMat_Allocator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGpuMat_Allocator")
				.finish()
		}
	}

	ptr_extern! { core::KeyPoint,
		cv_PtrLcv_KeyPointG_new_null_const, cv_PtrLcv_KeyPointG_delete, cv_PtrLcv_KeyPointG_getInnerPtr_const, cv_PtrLcv_KeyPointG_getInnerPtrMut
	}

	ptr_extern_ctor! { core::KeyPoint, cv_PtrLcv_KeyPointG_new_const_KeyPoint }
	impl core::Ptr<core::KeyPoint> {
		#[inline] pub fn as_raw_PtrOfKeyPoint(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKeyPoint(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::KeyPointTraitConst for core::Ptr<core::KeyPoint> {
		#[inline] fn as_raw_KeyPoint(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::KeyPointTrait for core::Ptr<core::KeyPoint> {
		#[inline] fn as_raw_mut_KeyPoint(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::KeyPoint> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKeyPoint")
				.finish()
		}
	}

	ptr_extern! { core::MinProblemSolver,
		cv_PtrLcv_MinProblemSolverG_new_null_const, cv_PtrLcv_MinProblemSolverG_delete, cv_PtrLcv_MinProblemSolverG_getInnerPtr_const, cv_PtrLcv_MinProblemSolverG_getInnerPtrMut
	}

	impl core::Ptr<core::MinProblemSolver> {
		#[inline] pub fn as_raw_PtrOfMinProblemSolver(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMinProblemSolver(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::MinProblemSolverTraitConst for core::Ptr<core::MinProblemSolver> {
		#[inline] fn as_raw_MinProblemSolver(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::MinProblemSolverTrait for core::Ptr<core::MinProblemSolver> {
		#[inline] fn as_raw_mut_MinProblemSolver(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<core::MinProblemSolver> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<core::MinProblemSolver> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<core::MinProblemSolver>, core::Ptr<core::Algorithm>, cv_PtrLcv_MinProblemSolverG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<core::MinProblemSolver> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMinProblemSolver")
				.finish()
		}
	}

	ptr_extern! { core::MinProblemSolver_Function,
		cv_PtrLcv_MinProblemSolver_FunctionG_new_null_const, cv_PtrLcv_MinProblemSolver_FunctionG_delete, cv_PtrLcv_MinProblemSolver_FunctionG_getInnerPtr_const, cv_PtrLcv_MinProblemSolver_FunctionG_getInnerPtrMut
	}

	impl core::Ptr<core::MinProblemSolver_Function> {
		#[inline] pub fn as_raw_PtrOfMinProblemSolver_Function(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMinProblemSolver_Function(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::MinProblemSolver_FunctionTraitConst for core::Ptr<core::MinProblemSolver_Function> {
		#[inline] fn as_raw_MinProblemSolver_Function(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::MinProblemSolver_FunctionTrait for core::Ptr<core::MinProblemSolver_Function> {
		#[inline] fn as_raw_mut_MinProblemSolver_Function(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::MinProblemSolver_Function> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMinProblemSolver_Function")
				.finish()
		}
	}

	ptr_extern! { core::OriginalClassName,
		cv_PtrLcv_utils_nested_OriginalClassNameG_new_null_const, cv_PtrLcv_utils_nested_OriginalClassNameG_delete, cv_PtrLcv_utils_nested_OriginalClassNameG_getInnerPtr_const, cv_PtrLcv_utils_nested_OriginalClassNameG_getInnerPtrMut
	}

	ptr_extern_ctor! { core::OriginalClassName, cv_PtrLcv_utils_nested_OriginalClassNameG_new_const_OriginalClassName }
	impl core::Ptr<core::OriginalClassName> {
		#[inline] pub fn as_raw_PtrOfOriginalClassName(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfOriginalClassName(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::OriginalClassNameTraitConst for core::Ptr<core::OriginalClassName> {
		#[inline] fn as_raw_OriginalClassName(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::OriginalClassNameTrait for core::Ptr<core::OriginalClassName> {
		#[inline] fn as_raw_mut_OriginalClassName(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<core::OriginalClassName> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfOriginalClassName")
				.finish()
		}
	}

	ptr_extern! { f32,
		cv_PtrLfloatG_new_null_const, cv_PtrLfloatG_delete, cv_PtrLfloatG_getInnerPtr_const, cv_PtrLfloatG_getInnerPtrMut
	}

	ptr_extern_ctor! { f32, cv_PtrLfloatG_new_const_float }
	impl core::Ptr<f32> {
		#[inline] pub fn as_raw_PtrOff32(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOff32(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::Tuple<(core::Point2i, core::Point2i)> {
		pub fn as_raw_TupleOfPoint2i_Point2i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfPoint2i_Point2i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (core::Point2i, core::Point2i),
		std_pairLcv_Point2i__cv_Point2iG_new_const_Point2i_Point2i, std_pairLcv_Point2i__cv_Point2iG_delete,
		0 = arg: core::Point2i, get_0 via std_pairLcv_Point2i__cv_Point2iG_get_0_const,
		1 = arg_1: core::Point2i, get_1 via std_pairLcv_Point2i__cv_Point2iG_get_1_const
	}

	impl core::Tuple<(core::Rect, i32)> {
		pub fn as_raw_TupleOfRect_i32(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfRect_i32(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (core::Rect, i32),
		std_pairLcv_Rect__intG_new_const_Rect_int, std_pairLcv_Rect__intG_delete,
		0 = arg: core::Rect, get_0 via std_pairLcv_Rect__intG_get_0_const,
		1 = arg_1: i32, get_1 via std_pairLcv_Rect__intG_get_1_const
	}

	impl core::Tuple<(core::UMat, u8)> {
		pub fn as_raw_TupleOfUMat_u8(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfUMat_u8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (core::UMat, u8),
		std_pairLcv_UMat__unsigned_charG_new_const_UMat_unsigned_char, std_pairLcv_UMat__unsigned_charG_delete,
		0 = arg: core::UMat, get_0 via std_pairLcv_UMat__unsigned_charG_get_0_const,
		1 = arg_1: u8, get_1 via std_pairLcv_UMat__unsigned_charG_get_1_const
	}

	impl core::Tuple<(i32, f32)> {
		pub fn as_raw_TupleOfi32_f32(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfi32_f32(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (i32, f32),
		std_pairLint__floatG_new_const_int_float, std_pairLint__floatG_delete,
		0 = arg: i32, get_0 via std_pairLint__floatG_get_0_const,
		1 = arg_1: f32, get_1 via std_pairLint__floatG_get_1_const
	}

	impl core::Tuple<(i32, f64)> {
		pub fn as_raw_TupleOfi32_f64(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfi32_f64(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (i32, f64),
		std_pairLint__doubleG_new_const_int_double, std_pairLint__doubleG_delete,
		0 = arg: i32, get_0 via std_pairLint__doubleG_get_0_const,
		1 = arg_1: f64, get_1 via std_pairLint__doubleG_get_1_const
	}

	impl core::Vector<core::DMatch> {
		pub fn as_raw_VectorOfDMatch(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDMatch(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::DMatch,
		std_vectorLcv_DMatchG_new_const, std_vectorLcv_DMatchG_delete,
		std_vectorLcv_DMatchG_len_const, std_vectorLcv_DMatchG_isEmpty_const,
		std_vectorLcv_DMatchG_capacity_const, std_vectorLcv_DMatchG_shrinkToFit,
		std_vectorLcv_DMatchG_reserve_size_t, std_vectorLcv_DMatchG_remove_size_t,
		std_vectorLcv_DMatchG_swap_size_t_size_t, std_vectorLcv_DMatchG_clear,
		std_vectorLcv_DMatchG_get_const_size_t, std_vectorLcv_DMatchG_set_size_t_const_DMatch,
		std_vectorLcv_DMatchG_push_const_DMatch, std_vectorLcv_DMatchG_insert_size_t_const_DMatch,
	}

	vector_copy_non_bool! { core::DMatch,
		std_vectorLcv_DMatchG_data_const, std_vectorLcv_DMatchG_dataMut, cv_fromSlice_const_const_DMatchX_size_t,
		std_vectorLcv_DMatchG_clone_const,
	}


	impl core::Vector<core::GpuMat> {
		pub fn as_raw_VectorOfGpuMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGpuMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::GpuMat,
		std_vectorLcv_cuda_GpuMatG_new_const, std_vectorLcv_cuda_GpuMatG_delete,
		std_vectorLcv_cuda_GpuMatG_len_const, std_vectorLcv_cuda_GpuMatG_isEmpty_const,
		std_vectorLcv_cuda_GpuMatG_capacity_const, std_vectorLcv_cuda_GpuMatG_shrinkToFit,
		std_vectorLcv_cuda_GpuMatG_reserve_size_t, std_vectorLcv_cuda_GpuMatG_remove_size_t,
		std_vectorLcv_cuda_GpuMatG_swap_size_t_size_t, std_vectorLcv_cuda_GpuMatG_clear,
		std_vectorLcv_cuda_GpuMatG_get_const_size_t, std_vectorLcv_cuda_GpuMatG_set_size_t_const_GpuMat,
		std_vectorLcv_cuda_GpuMatG_push_const_GpuMat, std_vectorLcv_cuda_GpuMatG_insert_size_t_const_GpuMat,
	}

	vector_non_copy_or_bool! { clone core::GpuMat }

	vector_boxed_ref! { core::GpuMat }

	vector_extern! { BoxedRef<'t, core::GpuMat>,
		std_vectorLcv_cuda_GpuMatG_new_const, std_vectorLcv_cuda_GpuMatG_delete,
		std_vectorLcv_cuda_GpuMatG_len_const, std_vectorLcv_cuda_GpuMatG_isEmpty_const,
		std_vectorLcv_cuda_GpuMatG_capacity_const, std_vectorLcv_cuda_GpuMatG_shrinkToFit,
		std_vectorLcv_cuda_GpuMatG_reserve_size_t, std_vectorLcv_cuda_GpuMatG_remove_size_t,
		std_vectorLcv_cuda_GpuMatG_swap_size_t_size_t, std_vectorLcv_cuda_GpuMatG_clear,
		std_vectorLcv_cuda_GpuMatG_get_const_size_t, std_vectorLcv_cuda_GpuMatG_set_size_t_const_GpuMat,
		std_vectorLcv_cuda_GpuMatG_push_const_GpuMat, std_vectorLcv_cuda_GpuMatG_insert_size_t_const_GpuMat,
	}


	impl core::Vector<core::KeyPoint> {
		pub fn as_raw_VectorOfKeyPoint(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfKeyPoint(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::KeyPoint,
		std_vectorLcv_KeyPointG_new_const, std_vectorLcv_KeyPointG_delete,
		std_vectorLcv_KeyPointG_len_const, std_vectorLcv_KeyPointG_isEmpty_const,
		std_vectorLcv_KeyPointG_capacity_const, std_vectorLcv_KeyPointG_shrinkToFit,
		std_vectorLcv_KeyPointG_reserve_size_t, std_vectorLcv_KeyPointG_remove_size_t,
		std_vectorLcv_KeyPointG_swap_size_t_size_t, std_vectorLcv_KeyPointG_clear,
		std_vectorLcv_KeyPointG_get_const_size_t, std_vectorLcv_KeyPointG_set_size_t_const_KeyPoint,
		std_vectorLcv_KeyPointG_push_const_KeyPoint, std_vectorLcv_KeyPointG_insert_size_t_const_KeyPoint,
	}

	vector_non_copy_or_bool! { clone core::KeyPoint }

	vector_boxed_ref! { core::KeyPoint }

	vector_extern! { BoxedRef<'t, core::KeyPoint>,
		std_vectorLcv_KeyPointG_new_const, std_vectorLcv_KeyPointG_delete,
		std_vectorLcv_KeyPointG_len_const, std_vectorLcv_KeyPointG_isEmpty_const,
		std_vectorLcv_KeyPointG_capacity_const, std_vectorLcv_KeyPointG_shrinkToFit,
		std_vectorLcv_KeyPointG_reserve_size_t, std_vectorLcv_KeyPointG_remove_size_t,
		std_vectorLcv_KeyPointG_swap_size_t_size_t, std_vectorLcv_KeyPointG_clear,
		std_vectorLcv_KeyPointG_get_const_size_t, std_vectorLcv_KeyPointG_set_size_t_const_KeyPoint,
		std_vectorLcv_KeyPointG_push_const_KeyPoint, std_vectorLcv_KeyPointG_insert_size_t_const_KeyPoint,
	}


	impl core::Vector<core::Mat> {
		pub fn as_raw_VectorOfMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Mat,
		std_vectorLcv_MatG_new_const, std_vectorLcv_MatG_delete,
		std_vectorLcv_MatG_len_const, std_vectorLcv_MatG_isEmpty_const,
		std_vectorLcv_MatG_capacity_const, std_vectorLcv_MatG_shrinkToFit,
		std_vectorLcv_MatG_reserve_size_t, std_vectorLcv_MatG_remove_size_t,
		std_vectorLcv_MatG_swap_size_t_size_t, std_vectorLcv_MatG_clear,
		std_vectorLcv_MatG_get_const_size_t, std_vectorLcv_MatG_set_size_t_const_Mat,
		std_vectorLcv_MatG_push_const_Mat, std_vectorLcv_MatG_insert_size_t_const_Mat,
	}

	vector_non_copy_or_bool! { clone core::Mat }

	vector_boxed_ref! { core::Mat }

	vector_extern! { BoxedRef<'t, core::Mat>,
		std_vectorLcv_MatG_new_const, std_vectorLcv_MatG_delete,
		std_vectorLcv_MatG_len_const, std_vectorLcv_MatG_isEmpty_const,
		std_vectorLcv_MatG_capacity_const, std_vectorLcv_MatG_shrinkToFit,
		std_vectorLcv_MatG_reserve_size_t, std_vectorLcv_MatG_remove_size_t,
		std_vectorLcv_MatG_swap_size_t_size_t, std_vectorLcv_MatG_clear,
		std_vectorLcv_MatG_get_const_size_t, std_vectorLcv_MatG_set_size_t_const_Mat,
		std_vectorLcv_MatG_push_const_Mat, std_vectorLcv_MatG_insert_size_t_const_Mat,
	}


	impl core::Vector<core::PlatformInfo> {
		pub fn as_raw_VectorOfPlatformInfo(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPlatformInfo(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::PlatformInfo,
		std_vectorLcv_ocl_PlatformInfoG_new_const, std_vectorLcv_ocl_PlatformInfoG_delete,
		std_vectorLcv_ocl_PlatformInfoG_len_const, std_vectorLcv_ocl_PlatformInfoG_isEmpty_const,
		std_vectorLcv_ocl_PlatformInfoG_capacity_const, std_vectorLcv_ocl_PlatformInfoG_shrinkToFit,
		std_vectorLcv_ocl_PlatformInfoG_reserve_size_t, std_vectorLcv_ocl_PlatformInfoG_remove_size_t,
		std_vectorLcv_ocl_PlatformInfoG_swap_size_t_size_t, std_vectorLcv_ocl_PlatformInfoG_clear,
		std_vectorLcv_ocl_PlatformInfoG_get_const_size_t, std_vectorLcv_ocl_PlatformInfoG_set_size_t_const_PlatformInfo,
		std_vectorLcv_ocl_PlatformInfoG_push_const_PlatformInfo, std_vectorLcv_ocl_PlatformInfoG_insert_size_t_const_PlatformInfo,
	}

	vector_non_copy_or_bool! { core::PlatformInfo }

	vector_boxed_ref! { core::PlatformInfo }

	vector_extern! { BoxedRef<'t, core::PlatformInfo>,
		std_vectorLcv_ocl_PlatformInfoG_new_const, std_vectorLcv_ocl_PlatformInfoG_delete,
		std_vectorLcv_ocl_PlatformInfoG_len_const, std_vectorLcv_ocl_PlatformInfoG_isEmpty_const,
		std_vectorLcv_ocl_PlatformInfoG_capacity_const, std_vectorLcv_ocl_PlatformInfoG_shrinkToFit,
		std_vectorLcv_ocl_PlatformInfoG_reserve_size_t, std_vectorLcv_ocl_PlatformInfoG_remove_size_t,
		std_vectorLcv_ocl_PlatformInfoG_swap_size_t_size_t, std_vectorLcv_ocl_PlatformInfoG_clear,
		std_vectorLcv_ocl_PlatformInfoG_get_const_size_t, std_vectorLcv_ocl_PlatformInfoG_set_size_t_const_PlatformInfo,
		std_vectorLcv_ocl_PlatformInfoG_push_const_PlatformInfo, std_vectorLcv_ocl_PlatformInfoG_insert_size_t_const_PlatformInfo,
	}


	impl core::Vector<core::Point> {
		pub fn as_raw_VectorOfPoint(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPoint(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Point,
		std_vectorLcv_PointG_new_const, std_vectorLcv_PointG_delete,
		std_vectorLcv_PointG_len_const, std_vectorLcv_PointG_isEmpty_const,
		std_vectorLcv_PointG_capacity_const, std_vectorLcv_PointG_shrinkToFit,
		std_vectorLcv_PointG_reserve_size_t, std_vectorLcv_PointG_remove_size_t,
		std_vectorLcv_PointG_swap_size_t_size_t, std_vectorLcv_PointG_clear,
		std_vectorLcv_PointG_get_const_size_t, std_vectorLcv_PointG_set_size_t_const_Point,
		std_vectorLcv_PointG_push_const_Point, std_vectorLcv_PointG_insert_size_t_const_Point,
	}

	vector_copy_non_bool! { core::Point,
		std_vectorLcv_PointG_data_const, std_vectorLcv_PointG_dataMut, cv_fromSlice_const_const_PointX_size_t,
		std_vectorLcv_PointG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Point> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_PointG_inputArray_const(self.as_raw_VectorOfPoint(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Point> }

	impl ToOutputArray for core::Vector<core::Point> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_PointG_outputArray(self.as_raw_mut_VectorOfPoint(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Point> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_PointG_inputOutputArray(self.as_raw_mut_VectorOfPoint(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Point> }

	impl core::Vector<core::Point2d> {
		pub fn as_raw_VectorOfPoint2d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPoint2d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Point2d,
		std_vectorLcv_Point2dG_new_const, std_vectorLcv_Point2dG_delete,
		std_vectorLcv_Point2dG_len_const, std_vectorLcv_Point2dG_isEmpty_const,
		std_vectorLcv_Point2dG_capacity_const, std_vectorLcv_Point2dG_shrinkToFit,
		std_vectorLcv_Point2dG_reserve_size_t, std_vectorLcv_Point2dG_remove_size_t,
		std_vectorLcv_Point2dG_swap_size_t_size_t, std_vectorLcv_Point2dG_clear,
		std_vectorLcv_Point2dG_get_const_size_t, std_vectorLcv_Point2dG_set_size_t_const_Point2d,
		std_vectorLcv_Point2dG_push_const_Point2d, std_vectorLcv_Point2dG_insert_size_t_const_Point2d,
	}

	vector_copy_non_bool! { core::Point2d,
		std_vectorLcv_Point2dG_data_const, std_vectorLcv_Point2dG_dataMut, cv_fromSlice_const_const_Point2dX_size_t,
		std_vectorLcv_Point2dG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Point2d> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point2dG_inputArray_const(self.as_raw_VectorOfPoint2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Point2d> }

	impl ToOutputArray for core::Vector<core::Point2d> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point2dG_outputArray(self.as_raw_mut_VectorOfPoint2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Point2d> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point2dG_inputOutputArray(self.as_raw_mut_VectorOfPoint2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Point2d> }

	impl core::Vector<core::Point2f> {
		pub fn as_raw_VectorOfPoint2f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPoint2f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Point2f,
		std_vectorLcv_Point2fG_new_const, std_vectorLcv_Point2fG_delete,
		std_vectorLcv_Point2fG_len_const, std_vectorLcv_Point2fG_isEmpty_const,
		std_vectorLcv_Point2fG_capacity_const, std_vectorLcv_Point2fG_shrinkToFit,
		std_vectorLcv_Point2fG_reserve_size_t, std_vectorLcv_Point2fG_remove_size_t,
		std_vectorLcv_Point2fG_swap_size_t_size_t, std_vectorLcv_Point2fG_clear,
		std_vectorLcv_Point2fG_get_const_size_t, std_vectorLcv_Point2fG_set_size_t_const_Point2f,
		std_vectorLcv_Point2fG_push_const_Point2f, std_vectorLcv_Point2fG_insert_size_t_const_Point2f,
	}

	vector_copy_non_bool! { core::Point2f,
		std_vectorLcv_Point2fG_data_const, std_vectorLcv_Point2fG_dataMut, cv_fromSlice_const_const_Point2fX_size_t,
		std_vectorLcv_Point2fG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Point2f> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point2fG_inputArray_const(self.as_raw_VectorOfPoint2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Point2f> }

	impl ToOutputArray for core::Vector<core::Point2f> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point2fG_outputArray(self.as_raw_mut_VectorOfPoint2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Point2f> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point2fG_inputOutputArray(self.as_raw_mut_VectorOfPoint2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Point2f> }

	impl core::Vector<core::Point3d> {
		pub fn as_raw_VectorOfPoint3d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPoint3d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Point3d,
		std_vectorLcv_Point3dG_new_const, std_vectorLcv_Point3dG_delete,
		std_vectorLcv_Point3dG_len_const, std_vectorLcv_Point3dG_isEmpty_const,
		std_vectorLcv_Point3dG_capacity_const, std_vectorLcv_Point3dG_shrinkToFit,
		std_vectorLcv_Point3dG_reserve_size_t, std_vectorLcv_Point3dG_remove_size_t,
		std_vectorLcv_Point3dG_swap_size_t_size_t, std_vectorLcv_Point3dG_clear,
		std_vectorLcv_Point3dG_get_const_size_t, std_vectorLcv_Point3dG_set_size_t_const_Point3d,
		std_vectorLcv_Point3dG_push_const_Point3d, std_vectorLcv_Point3dG_insert_size_t_const_Point3d,
	}

	vector_copy_non_bool! { core::Point3d,
		std_vectorLcv_Point3dG_data_const, std_vectorLcv_Point3dG_dataMut, cv_fromSlice_const_const_Point3dX_size_t,
		std_vectorLcv_Point3dG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Point3d> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3dG_inputArray_const(self.as_raw_VectorOfPoint3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Point3d> }

	impl ToOutputArray for core::Vector<core::Point3d> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3dG_outputArray(self.as_raw_mut_VectorOfPoint3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Point3d> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3dG_inputOutputArray(self.as_raw_mut_VectorOfPoint3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Point3d> }

	impl core::Vector<core::Point3f> {
		pub fn as_raw_VectorOfPoint3f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPoint3f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Point3f,
		std_vectorLcv_Point3fG_new_const, std_vectorLcv_Point3fG_delete,
		std_vectorLcv_Point3fG_len_const, std_vectorLcv_Point3fG_isEmpty_const,
		std_vectorLcv_Point3fG_capacity_const, std_vectorLcv_Point3fG_shrinkToFit,
		std_vectorLcv_Point3fG_reserve_size_t, std_vectorLcv_Point3fG_remove_size_t,
		std_vectorLcv_Point3fG_swap_size_t_size_t, std_vectorLcv_Point3fG_clear,
		std_vectorLcv_Point3fG_get_const_size_t, std_vectorLcv_Point3fG_set_size_t_const_Point3f,
		std_vectorLcv_Point3fG_push_const_Point3f, std_vectorLcv_Point3fG_insert_size_t_const_Point3f,
	}

	vector_copy_non_bool! { core::Point3f,
		std_vectorLcv_Point3fG_data_const, std_vectorLcv_Point3fG_dataMut, cv_fromSlice_const_const_Point3fX_size_t,
		std_vectorLcv_Point3fG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Point3f> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3fG_inputArray_const(self.as_raw_VectorOfPoint3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Point3f> }

	impl ToOutputArray for core::Vector<core::Point3f> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3fG_outputArray(self.as_raw_mut_VectorOfPoint3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Point3f> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3fG_inputOutputArray(self.as_raw_mut_VectorOfPoint3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Point3f> }

	impl core::Vector<core::Point3i> {
		pub fn as_raw_VectorOfPoint3i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPoint3i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Point3i,
		std_vectorLcv_Point3iG_new_const, std_vectorLcv_Point3iG_delete,
		std_vectorLcv_Point3iG_len_const, std_vectorLcv_Point3iG_isEmpty_const,
		std_vectorLcv_Point3iG_capacity_const, std_vectorLcv_Point3iG_shrinkToFit,
		std_vectorLcv_Point3iG_reserve_size_t, std_vectorLcv_Point3iG_remove_size_t,
		std_vectorLcv_Point3iG_swap_size_t_size_t, std_vectorLcv_Point3iG_clear,
		std_vectorLcv_Point3iG_get_const_size_t, std_vectorLcv_Point3iG_set_size_t_const_Point3i,
		std_vectorLcv_Point3iG_push_const_Point3i, std_vectorLcv_Point3iG_insert_size_t_const_Point3i,
	}

	vector_copy_non_bool! { core::Point3i,
		std_vectorLcv_Point3iG_data_const, std_vectorLcv_Point3iG_dataMut, cv_fromSlice_const_const_Point3iX_size_t,
		std_vectorLcv_Point3iG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Point3i> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3iG_inputArray_const(self.as_raw_VectorOfPoint3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Point3i> }

	impl ToOutputArray for core::Vector<core::Point3i> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3iG_outputArray(self.as_raw_mut_VectorOfPoint3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Point3i> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Point3iG_inputOutputArray(self.as_raw_mut_VectorOfPoint3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Point3i> }

	impl core::Vector<core::Range> {
		pub fn as_raw_VectorOfRange(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfRange(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Range,
		std_vectorLcv_RangeG_new_const, std_vectorLcv_RangeG_delete,
		std_vectorLcv_RangeG_len_const, std_vectorLcv_RangeG_isEmpty_const,
		std_vectorLcv_RangeG_capacity_const, std_vectorLcv_RangeG_shrinkToFit,
		std_vectorLcv_RangeG_reserve_size_t, std_vectorLcv_RangeG_remove_size_t,
		std_vectorLcv_RangeG_swap_size_t_size_t, std_vectorLcv_RangeG_clear,
		std_vectorLcv_RangeG_get_const_size_t, std_vectorLcv_RangeG_set_size_t_const_Range,
		std_vectorLcv_RangeG_push_const_Range, std_vectorLcv_RangeG_insert_size_t_const_Range,
	}

	vector_non_copy_or_bool! { core::Range }

	vector_boxed_ref! { core::Range }

	vector_extern! { BoxedRef<'t, core::Range>,
		std_vectorLcv_RangeG_new_const, std_vectorLcv_RangeG_delete,
		std_vectorLcv_RangeG_len_const, std_vectorLcv_RangeG_isEmpty_const,
		std_vectorLcv_RangeG_capacity_const, std_vectorLcv_RangeG_shrinkToFit,
		std_vectorLcv_RangeG_reserve_size_t, std_vectorLcv_RangeG_remove_size_t,
		std_vectorLcv_RangeG_swap_size_t_size_t, std_vectorLcv_RangeG_clear,
		std_vectorLcv_RangeG_get_const_size_t, std_vectorLcv_RangeG_set_size_t_const_Range,
		std_vectorLcv_RangeG_push_const_Range, std_vectorLcv_RangeG_insert_size_t_const_Range,
	}


	impl core::Vector<core::Rect> {
		pub fn as_raw_VectorOfRect(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfRect(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Rect,
		std_vectorLcv_RectG_new_const, std_vectorLcv_RectG_delete,
		std_vectorLcv_RectG_len_const, std_vectorLcv_RectG_isEmpty_const,
		std_vectorLcv_RectG_capacity_const, std_vectorLcv_RectG_shrinkToFit,
		std_vectorLcv_RectG_reserve_size_t, std_vectorLcv_RectG_remove_size_t,
		std_vectorLcv_RectG_swap_size_t_size_t, std_vectorLcv_RectG_clear,
		std_vectorLcv_RectG_get_const_size_t, std_vectorLcv_RectG_set_size_t_const_Rect,
		std_vectorLcv_RectG_push_const_Rect, std_vectorLcv_RectG_insert_size_t_const_Rect,
	}

	vector_copy_non_bool! { core::Rect,
		std_vectorLcv_RectG_data_const, std_vectorLcv_RectG_dataMut, cv_fromSlice_const_const_RectX_size_t,
		std_vectorLcv_RectG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Rect> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_RectG_inputArray_const(self.as_raw_VectorOfRect(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Rect> }

	impl ToOutputArray for core::Vector<core::Rect> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_RectG_outputArray(self.as_raw_mut_VectorOfRect(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Rect> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_RectG_inputOutputArray(self.as_raw_mut_VectorOfRect(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Rect> }

	impl core::Vector<core::Rect2d> {
		pub fn as_raw_VectorOfRect2d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfRect2d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Rect2d,
		std_vectorLcv_Rect2dG_new_const, std_vectorLcv_Rect2dG_delete,
		std_vectorLcv_Rect2dG_len_const, std_vectorLcv_Rect2dG_isEmpty_const,
		std_vectorLcv_Rect2dG_capacity_const, std_vectorLcv_Rect2dG_shrinkToFit,
		std_vectorLcv_Rect2dG_reserve_size_t, std_vectorLcv_Rect2dG_remove_size_t,
		std_vectorLcv_Rect2dG_swap_size_t_size_t, std_vectorLcv_Rect2dG_clear,
		std_vectorLcv_Rect2dG_get_const_size_t, std_vectorLcv_Rect2dG_set_size_t_const_Rect2d,
		std_vectorLcv_Rect2dG_push_const_Rect2d, std_vectorLcv_Rect2dG_insert_size_t_const_Rect2d,
	}

	vector_copy_non_bool! { core::Rect2d,
		std_vectorLcv_Rect2dG_data_const, std_vectorLcv_Rect2dG_dataMut, cv_fromSlice_const_const_Rect2dX_size_t,
		std_vectorLcv_Rect2dG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Rect2d> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Rect2dG_inputArray_const(self.as_raw_VectorOfRect2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Rect2d> }

	impl ToOutputArray for core::Vector<core::Rect2d> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Rect2dG_outputArray(self.as_raw_mut_VectorOfRect2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Rect2d> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Rect2dG_inputOutputArray(self.as_raw_mut_VectorOfRect2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Rect2d> }

	impl core::Vector<core::RotatedRect> {
		pub fn as_raw_VectorOfRotatedRect(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfRotatedRect(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::RotatedRect,
		std_vectorLcv_RotatedRectG_new_const, std_vectorLcv_RotatedRectG_delete,
		std_vectorLcv_RotatedRectG_len_const, std_vectorLcv_RotatedRectG_isEmpty_const,
		std_vectorLcv_RotatedRectG_capacity_const, std_vectorLcv_RotatedRectG_shrinkToFit,
		std_vectorLcv_RotatedRectG_reserve_size_t, std_vectorLcv_RotatedRectG_remove_size_t,
		std_vectorLcv_RotatedRectG_swap_size_t_size_t, std_vectorLcv_RotatedRectG_clear,
		std_vectorLcv_RotatedRectG_get_const_size_t, std_vectorLcv_RotatedRectG_set_size_t_const_RotatedRect,
		std_vectorLcv_RotatedRectG_push_const_RotatedRect, std_vectorLcv_RotatedRectG_insert_size_t_const_RotatedRect,
	}

	vector_copy_non_bool! { core::RotatedRect,
		std_vectorLcv_RotatedRectG_data_const, std_vectorLcv_RotatedRectG_dataMut, cv_fromSlice_const_const_RotatedRectX_size_t,
		std_vectorLcv_RotatedRectG_clone_const,
	}


	impl core::Vector<core::Scalar> {
		pub fn as_raw_VectorOfScalar(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfScalar(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Scalar,
		std_vectorLcv_ScalarG_new_const, std_vectorLcv_ScalarG_delete,
		std_vectorLcv_ScalarG_len_const, std_vectorLcv_ScalarG_isEmpty_const,
		std_vectorLcv_ScalarG_capacity_const, std_vectorLcv_ScalarG_shrinkToFit,
		std_vectorLcv_ScalarG_reserve_size_t, std_vectorLcv_ScalarG_remove_size_t,
		std_vectorLcv_ScalarG_swap_size_t_size_t, std_vectorLcv_ScalarG_clear,
		std_vectorLcv_ScalarG_get_const_size_t, std_vectorLcv_ScalarG_set_size_t_const_Scalar,
		std_vectorLcv_ScalarG_push_const_Scalar, std_vectorLcv_ScalarG_insert_size_t_const_Scalar,
	}

	vector_copy_non_bool! { core::Scalar,
		std_vectorLcv_ScalarG_data_const, std_vectorLcv_ScalarG_dataMut, cv_fromSlice_const_const_ScalarX_size_t,
		std_vectorLcv_ScalarG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Scalar> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_ScalarG_inputArray_const(self.as_raw_VectorOfScalar(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Scalar> }

	impl ToOutputArray for core::Vector<core::Scalar> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_ScalarG_outputArray(self.as_raw_mut_VectorOfScalar(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Scalar> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_ScalarG_inputOutputArray(self.as_raw_mut_VectorOfScalar(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Scalar> }

	impl core::Vector<core::Size> {
		pub fn as_raw_VectorOfSize(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfSize(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Size,
		std_vectorLcv_SizeG_new_const, std_vectorLcv_SizeG_delete,
		std_vectorLcv_SizeG_len_const, std_vectorLcv_SizeG_isEmpty_const,
		std_vectorLcv_SizeG_capacity_const, std_vectorLcv_SizeG_shrinkToFit,
		std_vectorLcv_SizeG_reserve_size_t, std_vectorLcv_SizeG_remove_size_t,
		std_vectorLcv_SizeG_swap_size_t_size_t, std_vectorLcv_SizeG_clear,
		std_vectorLcv_SizeG_get_const_size_t, std_vectorLcv_SizeG_set_size_t_const_Size,
		std_vectorLcv_SizeG_push_const_Size, std_vectorLcv_SizeG_insert_size_t_const_Size,
	}

	vector_copy_non_bool! { core::Size,
		std_vectorLcv_SizeG_data_const, std_vectorLcv_SizeG_dataMut, cv_fromSlice_const_const_SizeX_size_t,
		std_vectorLcv_SizeG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Size> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_SizeG_inputArray_const(self.as_raw_VectorOfSize(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Size> }

	impl ToOutputArray for core::Vector<core::Size> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_SizeG_outputArray(self.as_raw_mut_VectorOfSize(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Size> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_SizeG_inputOutputArray(self.as_raw_mut_VectorOfSize(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Size> }

	impl core::Vector<String> {
		pub fn as_raw_VectorOfString(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfString(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { String,
		std_vectorLcv_StringG_new_const, std_vectorLcv_StringG_delete,
		std_vectorLcv_StringG_len_const, std_vectorLcv_StringG_isEmpty_const,
		std_vectorLcv_StringG_capacity_const, std_vectorLcv_StringG_shrinkToFit,
		std_vectorLcv_StringG_reserve_size_t, std_vectorLcv_StringG_remove_size_t,
		std_vectorLcv_StringG_swap_size_t_size_t, std_vectorLcv_StringG_clear,
		std_vectorLcv_StringG_get_const_size_t, std_vectorLcv_StringG_set_size_t_const_String,
		std_vectorLcv_StringG_push_const_String, std_vectorLcv_StringG_insert_size_t_const_String,
	}

	vector_non_copy_or_bool! { String }


	impl core::Vector<core::Tuple<(core::Point2i, core::Point2i)>> {
		pub fn as_raw_VectorOfTupleOfPoint2i_Point2i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfTupleOfPoint2i_Point2i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Tuple<(core::Point2i, core::Point2i)>,
		std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_new_const, std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_delete,
		std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_len_const, std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_isEmpty_const,
		std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_capacity_const, std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_shrinkToFit,
		std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_reserve_size_t, std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_remove_size_t,
		std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_swap_size_t_size_t, std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_clear,
		std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_get_const_size_t, std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_set_size_t_const_pairLcv_Point2i__cv_Point2iG,
		std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_push_const_pairLcv_Point2i__cv_Point2iG, std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_insert_size_t_const_pairLcv_Point2i__cv_Point2iG,
	}

	vector_non_copy_or_bool! { core::Tuple<(core::Point2i, core::Point2i)> }


	impl core::Vector<core::Tuple<(core::UMat, u8)>> {
		pub fn as_raw_VectorOfTupleOfUMat_u8(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfTupleOfUMat_u8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Tuple<(core::UMat, u8)>,
		std_vectorLstd_pairLcv_UMat__unsigned_charGG_new_const, std_vectorLstd_pairLcv_UMat__unsigned_charGG_delete,
		std_vectorLstd_pairLcv_UMat__unsigned_charGG_len_const, std_vectorLstd_pairLcv_UMat__unsigned_charGG_isEmpty_const,
		std_vectorLstd_pairLcv_UMat__unsigned_charGG_capacity_const, std_vectorLstd_pairLcv_UMat__unsigned_charGG_shrinkToFit,
		std_vectorLstd_pairLcv_UMat__unsigned_charGG_reserve_size_t, std_vectorLstd_pairLcv_UMat__unsigned_charGG_remove_size_t,
		std_vectorLstd_pairLcv_UMat__unsigned_charGG_swap_size_t_size_t, std_vectorLstd_pairLcv_UMat__unsigned_charGG_clear,
		std_vectorLstd_pairLcv_UMat__unsigned_charGG_get_const_size_t, std_vectorLstd_pairLcv_UMat__unsigned_charGG_set_size_t_const_pairLcv_UMat__unsigned_charG,
		std_vectorLstd_pairLcv_UMat__unsigned_charGG_push_const_pairLcv_UMat__unsigned_charG, std_vectorLstd_pairLcv_UMat__unsigned_charGG_insert_size_t_const_pairLcv_UMat__unsigned_charG,
	}

	vector_non_copy_or_bool! { core::Tuple<(core::UMat, u8)> }


	impl core::Vector<core::Tuple<(i32, f64)>> {
		pub fn as_raw_VectorOfTupleOfi32_f64(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfTupleOfi32_f64(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Tuple<(i32, f64)>,
		std_vectorLstd_pairLint__doubleGG_new_const, std_vectorLstd_pairLint__doubleGG_delete,
		std_vectorLstd_pairLint__doubleGG_len_const, std_vectorLstd_pairLint__doubleGG_isEmpty_const,
		std_vectorLstd_pairLint__doubleGG_capacity_const, std_vectorLstd_pairLint__doubleGG_shrinkToFit,
		std_vectorLstd_pairLint__doubleGG_reserve_size_t, std_vectorLstd_pairLint__doubleGG_remove_size_t,
		std_vectorLstd_pairLint__doubleGG_swap_size_t_size_t, std_vectorLstd_pairLint__doubleGG_clear,
		std_vectorLstd_pairLint__doubleGG_get_const_size_t, std_vectorLstd_pairLint__doubleGG_set_size_t_const_pairLint__doubleG,
		std_vectorLstd_pairLint__doubleGG_push_const_pairLint__doubleG, std_vectorLstd_pairLint__doubleGG_insert_size_t_const_pairLint__doubleG,
	}

	vector_non_copy_or_bool! { core::Tuple<(i32, f64)> }


	impl core::Vector<core::UMat> {
		pub fn as_raw_VectorOfUMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfUMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::UMat,
		std_vectorLcv_UMatG_new_const, std_vectorLcv_UMatG_delete,
		std_vectorLcv_UMatG_len_const, std_vectorLcv_UMatG_isEmpty_const,
		std_vectorLcv_UMatG_capacity_const, std_vectorLcv_UMatG_shrinkToFit,
		std_vectorLcv_UMatG_reserve_size_t, std_vectorLcv_UMatG_remove_size_t,
		std_vectorLcv_UMatG_swap_size_t_size_t, std_vectorLcv_UMatG_clear,
		std_vectorLcv_UMatG_get_const_size_t, std_vectorLcv_UMatG_set_size_t_const_UMat,
		std_vectorLcv_UMatG_push_const_UMat, std_vectorLcv_UMatG_insert_size_t_const_UMat,
	}

	vector_non_copy_or_bool! { clone core::UMat }

	vector_boxed_ref! { core::UMat }

	vector_extern! { BoxedRef<'t, core::UMat>,
		std_vectorLcv_UMatG_new_const, std_vectorLcv_UMatG_delete,
		std_vectorLcv_UMatG_len_const, std_vectorLcv_UMatG_isEmpty_const,
		std_vectorLcv_UMatG_capacity_const, std_vectorLcv_UMatG_shrinkToFit,
		std_vectorLcv_UMatG_reserve_size_t, std_vectorLcv_UMatG_remove_size_t,
		std_vectorLcv_UMatG_swap_size_t_size_t, std_vectorLcv_UMatG_clear,
		std_vectorLcv_UMatG_get_const_size_t, std_vectorLcv_UMatG_set_size_t_const_UMat,
		std_vectorLcv_UMatG_push_const_UMat, std_vectorLcv_UMatG_insert_size_t_const_UMat,
	}


	impl core::Vector<core::Vec2d> {
		pub fn as_raw_VectorOfVec2d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec2d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec2d,
		std_vectorLcv_Vec2dG_new_const, std_vectorLcv_Vec2dG_delete,
		std_vectorLcv_Vec2dG_len_const, std_vectorLcv_Vec2dG_isEmpty_const,
		std_vectorLcv_Vec2dG_capacity_const, std_vectorLcv_Vec2dG_shrinkToFit,
		std_vectorLcv_Vec2dG_reserve_size_t, std_vectorLcv_Vec2dG_remove_size_t,
		std_vectorLcv_Vec2dG_swap_size_t_size_t, std_vectorLcv_Vec2dG_clear,
		std_vectorLcv_Vec2dG_get_const_size_t, std_vectorLcv_Vec2dG_set_size_t_const_Vec2d,
		std_vectorLcv_Vec2dG_push_const_Vec2d, std_vectorLcv_Vec2dG_insert_size_t_const_Vec2d,
	}

	vector_copy_non_bool! { core::Vec2d,
		std_vectorLcv_Vec2dG_data_const, std_vectorLcv_Vec2dG_dataMut, cv_fromSlice_const_const_Vec2dX_size_t,
		std_vectorLcv_Vec2dG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec2d> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2dG_inputArray_const(self.as_raw_VectorOfVec2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec2d> }

	impl ToOutputArray for core::Vector<core::Vec2d> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2dG_outputArray(self.as_raw_mut_VectorOfVec2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec2d> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2dG_inputOutputArray(self.as_raw_mut_VectorOfVec2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec2d> }

	impl core::Vector<core::Vec2f> {
		pub fn as_raw_VectorOfVec2f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec2f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec2f,
		std_vectorLcv_Vec2fG_new_const, std_vectorLcv_Vec2fG_delete,
		std_vectorLcv_Vec2fG_len_const, std_vectorLcv_Vec2fG_isEmpty_const,
		std_vectorLcv_Vec2fG_capacity_const, std_vectorLcv_Vec2fG_shrinkToFit,
		std_vectorLcv_Vec2fG_reserve_size_t, std_vectorLcv_Vec2fG_remove_size_t,
		std_vectorLcv_Vec2fG_swap_size_t_size_t, std_vectorLcv_Vec2fG_clear,
		std_vectorLcv_Vec2fG_get_const_size_t, std_vectorLcv_Vec2fG_set_size_t_const_Vec2f,
		std_vectorLcv_Vec2fG_push_const_Vec2f, std_vectorLcv_Vec2fG_insert_size_t_const_Vec2f,
	}

	vector_copy_non_bool! { core::Vec2f,
		std_vectorLcv_Vec2fG_data_const, std_vectorLcv_Vec2fG_dataMut, cv_fromSlice_const_const_Vec2fX_size_t,
		std_vectorLcv_Vec2fG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec2f> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2fG_inputArray_const(self.as_raw_VectorOfVec2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec2f> }

	impl ToOutputArray for core::Vector<core::Vec2f> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2fG_outputArray(self.as_raw_mut_VectorOfVec2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec2f> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2fG_inputOutputArray(self.as_raw_mut_VectorOfVec2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec2f> }

	impl core::Vector<core::Vec2i> {
		pub fn as_raw_VectorOfVec2i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec2i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec2i,
		std_vectorLcv_Vec2iG_new_const, std_vectorLcv_Vec2iG_delete,
		std_vectorLcv_Vec2iG_len_const, std_vectorLcv_Vec2iG_isEmpty_const,
		std_vectorLcv_Vec2iG_capacity_const, std_vectorLcv_Vec2iG_shrinkToFit,
		std_vectorLcv_Vec2iG_reserve_size_t, std_vectorLcv_Vec2iG_remove_size_t,
		std_vectorLcv_Vec2iG_swap_size_t_size_t, std_vectorLcv_Vec2iG_clear,
		std_vectorLcv_Vec2iG_get_const_size_t, std_vectorLcv_Vec2iG_set_size_t_const_Vec2i,
		std_vectorLcv_Vec2iG_push_const_Vec2i, std_vectorLcv_Vec2iG_insert_size_t_const_Vec2i,
	}

	vector_copy_non_bool! { core::Vec2i,
		std_vectorLcv_Vec2iG_data_const, std_vectorLcv_Vec2iG_dataMut, cv_fromSlice_const_const_Vec2iX_size_t,
		std_vectorLcv_Vec2iG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec2i> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2iG_inputArray_const(self.as_raw_VectorOfVec2i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec2i> }

	impl ToOutputArray for core::Vector<core::Vec2i> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2iG_outputArray(self.as_raw_mut_VectorOfVec2i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec2i> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec2iG_inputOutputArray(self.as_raw_mut_VectorOfVec2i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec2i> }

	impl core::Vector<core::Vec3d> {
		pub fn as_raw_VectorOfVec3d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec3d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec3d,
		std_vectorLcv_Vec3dG_new_const, std_vectorLcv_Vec3dG_delete,
		std_vectorLcv_Vec3dG_len_const, std_vectorLcv_Vec3dG_isEmpty_const,
		std_vectorLcv_Vec3dG_capacity_const, std_vectorLcv_Vec3dG_shrinkToFit,
		std_vectorLcv_Vec3dG_reserve_size_t, std_vectorLcv_Vec3dG_remove_size_t,
		std_vectorLcv_Vec3dG_swap_size_t_size_t, std_vectorLcv_Vec3dG_clear,
		std_vectorLcv_Vec3dG_get_const_size_t, std_vectorLcv_Vec3dG_set_size_t_const_Vec3d,
		std_vectorLcv_Vec3dG_push_const_Vec3d, std_vectorLcv_Vec3dG_insert_size_t_const_Vec3d,
	}

	vector_copy_non_bool! { core::Vec3d,
		std_vectorLcv_Vec3dG_data_const, std_vectorLcv_Vec3dG_dataMut, cv_fromSlice_const_const_Vec3dX_size_t,
		std_vectorLcv_Vec3dG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec3d> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3dG_inputArray_const(self.as_raw_VectorOfVec3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec3d> }

	impl ToOutputArray for core::Vector<core::Vec3d> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3dG_outputArray(self.as_raw_mut_VectorOfVec3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec3d> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3dG_inputOutputArray(self.as_raw_mut_VectorOfVec3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec3d> }

	impl core::Vector<core::Vec3f> {
		pub fn as_raw_VectorOfVec3f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec3f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec3f,
		std_vectorLcv_Vec3fG_new_const, std_vectorLcv_Vec3fG_delete,
		std_vectorLcv_Vec3fG_len_const, std_vectorLcv_Vec3fG_isEmpty_const,
		std_vectorLcv_Vec3fG_capacity_const, std_vectorLcv_Vec3fG_shrinkToFit,
		std_vectorLcv_Vec3fG_reserve_size_t, std_vectorLcv_Vec3fG_remove_size_t,
		std_vectorLcv_Vec3fG_swap_size_t_size_t, std_vectorLcv_Vec3fG_clear,
		std_vectorLcv_Vec3fG_get_const_size_t, std_vectorLcv_Vec3fG_set_size_t_const_Vec3f,
		std_vectorLcv_Vec3fG_push_const_Vec3f, std_vectorLcv_Vec3fG_insert_size_t_const_Vec3f,
	}

	vector_copy_non_bool! { core::Vec3f,
		std_vectorLcv_Vec3fG_data_const, std_vectorLcv_Vec3fG_dataMut, cv_fromSlice_const_const_Vec3fX_size_t,
		std_vectorLcv_Vec3fG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec3f> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3fG_inputArray_const(self.as_raw_VectorOfVec3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec3f> }

	impl ToOutputArray for core::Vector<core::Vec3f> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3fG_outputArray(self.as_raw_mut_VectorOfVec3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec3f> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3fG_inputOutputArray(self.as_raw_mut_VectorOfVec3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec3f> }

	impl core::Vector<core::Vec3i> {
		pub fn as_raw_VectorOfVec3i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec3i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec3i,
		std_vectorLcv_Vec3iG_new_const, std_vectorLcv_Vec3iG_delete,
		std_vectorLcv_Vec3iG_len_const, std_vectorLcv_Vec3iG_isEmpty_const,
		std_vectorLcv_Vec3iG_capacity_const, std_vectorLcv_Vec3iG_shrinkToFit,
		std_vectorLcv_Vec3iG_reserve_size_t, std_vectorLcv_Vec3iG_remove_size_t,
		std_vectorLcv_Vec3iG_swap_size_t_size_t, std_vectorLcv_Vec3iG_clear,
		std_vectorLcv_Vec3iG_get_const_size_t, std_vectorLcv_Vec3iG_set_size_t_const_Vec3i,
		std_vectorLcv_Vec3iG_push_const_Vec3i, std_vectorLcv_Vec3iG_insert_size_t_const_Vec3i,
	}

	vector_copy_non_bool! { core::Vec3i,
		std_vectorLcv_Vec3iG_data_const, std_vectorLcv_Vec3iG_dataMut, cv_fromSlice_const_const_Vec3iX_size_t,
		std_vectorLcv_Vec3iG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec3i> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3iG_inputArray_const(self.as_raw_VectorOfVec3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec3i> }

	impl ToOutputArray for core::Vector<core::Vec3i> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3iG_outputArray(self.as_raw_mut_VectorOfVec3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec3i> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec3iG_inputOutputArray(self.as_raw_mut_VectorOfVec3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec3i> }

	impl core::Vector<core::Vec4f> {
		pub fn as_raw_VectorOfVec4f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec4f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec4f,
		std_vectorLcv_Vec4fG_new_const, std_vectorLcv_Vec4fG_delete,
		std_vectorLcv_Vec4fG_len_const, std_vectorLcv_Vec4fG_isEmpty_const,
		std_vectorLcv_Vec4fG_capacity_const, std_vectorLcv_Vec4fG_shrinkToFit,
		std_vectorLcv_Vec4fG_reserve_size_t, std_vectorLcv_Vec4fG_remove_size_t,
		std_vectorLcv_Vec4fG_swap_size_t_size_t, std_vectorLcv_Vec4fG_clear,
		std_vectorLcv_Vec4fG_get_const_size_t, std_vectorLcv_Vec4fG_set_size_t_const_Vec4f,
		std_vectorLcv_Vec4fG_push_const_Vec4f, std_vectorLcv_Vec4fG_insert_size_t_const_Vec4f,
	}

	vector_copy_non_bool! { core::Vec4f,
		std_vectorLcv_Vec4fG_data_const, std_vectorLcv_Vec4fG_dataMut, cv_fromSlice_const_const_Vec4fX_size_t,
		std_vectorLcv_Vec4fG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec4f> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec4fG_inputArray_const(self.as_raw_VectorOfVec4f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec4f> }

	impl ToOutputArray for core::Vector<core::Vec4f> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec4fG_outputArray(self.as_raw_mut_VectorOfVec4f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec4f> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec4fG_inputOutputArray(self.as_raw_mut_VectorOfVec4f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec4f> }

	impl core::Vector<core::Vec4i> {
		pub fn as_raw_VectorOfVec4i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec4i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec4i,
		std_vectorLcv_Vec4iG_new_const, std_vectorLcv_Vec4iG_delete,
		std_vectorLcv_Vec4iG_len_const, std_vectorLcv_Vec4iG_isEmpty_const,
		std_vectorLcv_Vec4iG_capacity_const, std_vectorLcv_Vec4iG_shrinkToFit,
		std_vectorLcv_Vec4iG_reserve_size_t, std_vectorLcv_Vec4iG_remove_size_t,
		std_vectorLcv_Vec4iG_swap_size_t_size_t, std_vectorLcv_Vec4iG_clear,
		std_vectorLcv_Vec4iG_get_const_size_t, std_vectorLcv_Vec4iG_set_size_t_const_Vec4i,
		std_vectorLcv_Vec4iG_push_const_Vec4i, std_vectorLcv_Vec4iG_insert_size_t_const_Vec4i,
	}

	vector_copy_non_bool! { core::Vec4i,
		std_vectorLcv_Vec4iG_data_const, std_vectorLcv_Vec4iG_dataMut, cv_fromSlice_const_const_Vec4iX_size_t,
		std_vectorLcv_Vec4iG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec4i> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec4iG_inputArray_const(self.as_raw_VectorOfVec4i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec4i> }

	impl ToOutputArray for core::Vector<core::Vec4i> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec4iG_outputArray(self.as_raw_mut_VectorOfVec4i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec4i> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec4iG_inputOutputArray(self.as_raw_mut_VectorOfVec4i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec4i> }

	impl core::Vector<core::Vec6f> {
		pub fn as_raw_VectorOfVec6f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVec6f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vec6f,
		std_vectorLcv_Vec6fG_new_const, std_vectorLcv_Vec6fG_delete,
		std_vectorLcv_Vec6fG_len_const, std_vectorLcv_Vec6fG_isEmpty_const,
		std_vectorLcv_Vec6fG_capacity_const, std_vectorLcv_Vec6fG_shrinkToFit,
		std_vectorLcv_Vec6fG_reserve_size_t, std_vectorLcv_Vec6fG_remove_size_t,
		std_vectorLcv_Vec6fG_swap_size_t_size_t, std_vectorLcv_Vec6fG_clear,
		std_vectorLcv_Vec6fG_get_const_size_t, std_vectorLcv_Vec6fG_set_size_t_const_Vec6f,
		std_vectorLcv_Vec6fG_push_const_Vec6f, std_vectorLcv_Vec6fG_insert_size_t_const_Vec6f,
	}

	vector_copy_non_bool! { core::Vec6f,
		std_vectorLcv_Vec6fG_data_const, std_vectorLcv_Vec6fG_dataMut, cv_fromSlice_const_const_Vec6fX_size_t,
		std_vectorLcv_Vec6fG_clone_const,
	}

	impl ToInputArray for core::Vector<core::Vec6f> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec6fG_inputArray_const(self.as_raw_VectorOfVec6f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vec6f> }

	impl ToOutputArray for core::Vector<core::Vec6f> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec6fG_outputArray(self.as_raw_mut_VectorOfVec6f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vec6f> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcv_Vec6fG_inputOutputArray(self.as_raw_mut_VectorOfVec6f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vec6f> }

	impl core::Vector<core::Vector<core::DMatch>> {
		pub fn as_raw_VectorOfVectorOfDMatch(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfDMatch(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::DMatch>,
		std_vectorLstd_vectorLcv_DMatchGG_new_const, std_vectorLstd_vectorLcv_DMatchGG_delete,
		std_vectorLstd_vectorLcv_DMatchGG_len_const, std_vectorLstd_vectorLcv_DMatchGG_isEmpty_const,
		std_vectorLstd_vectorLcv_DMatchGG_capacity_const, std_vectorLstd_vectorLcv_DMatchGG_shrinkToFit,
		std_vectorLstd_vectorLcv_DMatchGG_reserve_size_t, std_vectorLstd_vectorLcv_DMatchGG_remove_size_t,
		std_vectorLstd_vectorLcv_DMatchGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_DMatchGG_clear,
		std_vectorLstd_vectorLcv_DMatchGG_get_const_size_t, std_vectorLstd_vectorLcv_DMatchGG_set_size_t_const_vectorLDMatchG,
		std_vectorLstd_vectorLcv_DMatchGG_push_const_vectorLDMatchG, std_vectorLstd_vectorLcv_DMatchGG_insert_size_t_const_vectorLDMatchG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::DMatch> }


	impl core::Vector<core::Vector<core::KeyPoint>> {
		pub fn as_raw_VectorOfVectorOfKeyPoint(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfKeyPoint(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::KeyPoint>,
		std_vectorLstd_vectorLcv_KeyPointGG_new_const, std_vectorLstd_vectorLcv_KeyPointGG_delete,
		std_vectorLstd_vectorLcv_KeyPointGG_len_const, std_vectorLstd_vectorLcv_KeyPointGG_isEmpty_const,
		std_vectorLstd_vectorLcv_KeyPointGG_capacity_const, std_vectorLstd_vectorLcv_KeyPointGG_shrinkToFit,
		std_vectorLstd_vectorLcv_KeyPointGG_reserve_size_t, std_vectorLstd_vectorLcv_KeyPointGG_remove_size_t,
		std_vectorLstd_vectorLcv_KeyPointGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_KeyPointGG_clear,
		std_vectorLstd_vectorLcv_KeyPointGG_get_const_size_t, std_vectorLstd_vectorLcv_KeyPointGG_set_size_t_const_vectorLKeyPointG,
		std_vectorLstd_vectorLcv_KeyPointGG_push_const_vectorLKeyPointG, std_vectorLstd_vectorLcv_KeyPointGG_insert_size_t_const_vectorLKeyPointG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::KeyPoint> }


	impl core::Vector<core::Vector<core::Mat>> {
		pub fn as_raw_VectorOfVectorOfMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Mat>,
		std_vectorLstd_vectorLcv_MatGG_new_const, std_vectorLstd_vectorLcv_MatGG_delete,
		std_vectorLstd_vectorLcv_MatGG_len_const, std_vectorLstd_vectorLcv_MatGG_isEmpty_const,
		std_vectorLstd_vectorLcv_MatGG_capacity_const, std_vectorLstd_vectorLcv_MatGG_shrinkToFit,
		std_vectorLstd_vectorLcv_MatGG_reserve_size_t, std_vectorLstd_vectorLcv_MatGG_remove_size_t,
		std_vectorLstd_vectorLcv_MatGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_MatGG_clear,
		std_vectorLstd_vectorLcv_MatGG_get_const_size_t, std_vectorLstd_vectorLcv_MatGG_set_size_t_const_vectorLMatG,
		std_vectorLstd_vectorLcv_MatGG_push_const_vectorLMatG, std_vectorLstd_vectorLcv_MatGG_insert_size_t_const_vectorLMatG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Mat> }


	impl core::Vector<core::Vector<core::Point>> {
		pub fn as_raw_VectorOfVectorOfPoint(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfPoint(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Point>,
		std_vectorLstd_vectorLcv_PointGG_new_const, std_vectorLstd_vectorLcv_PointGG_delete,
		std_vectorLstd_vectorLcv_PointGG_len_const, std_vectorLstd_vectorLcv_PointGG_isEmpty_const,
		std_vectorLstd_vectorLcv_PointGG_capacity_const, std_vectorLstd_vectorLcv_PointGG_shrinkToFit,
		std_vectorLstd_vectorLcv_PointGG_reserve_size_t, std_vectorLstd_vectorLcv_PointGG_remove_size_t,
		std_vectorLstd_vectorLcv_PointGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_PointGG_clear,
		std_vectorLstd_vectorLcv_PointGG_get_const_size_t, std_vectorLstd_vectorLcv_PointGG_set_size_t_const_vectorLPointG,
		std_vectorLstd_vectorLcv_PointGG_push_const_vectorLPointG, std_vectorLstd_vectorLcv_PointGG_insert_size_t_const_vectorLPointG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Point> }

	impl ToInputArray for core::Vector<core::Vector<core::Point>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_PointGG_inputArray_const(self.as_raw_VectorOfVectorOfPoint(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Point>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Point>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_PointGG_outputArray(self.as_raw_mut_VectorOfVectorOfPoint(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Point>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_PointGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfPoint(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Point>> }

	impl core::Vector<core::Vector<core::Point2d>> {
		pub fn as_raw_VectorOfVectorOfPoint2d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfPoint2d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Point2d>,
		std_vectorLstd_vectorLcv_Point2dGG_new_const, std_vectorLstd_vectorLcv_Point2dGG_delete,
		std_vectorLstd_vectorLcv_Point2dGG_len_const, std_vectorLstd_vectorLcv_Point2dGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Point2dGG_capacity_const, std_vectorLstd_vectorLcv_Point2dGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Point2dGG_reserve_size_t, std_vectorLstd_vectorLcv_Point2dGG_remove_size_t,
		std_vectorLstd_vectorLcv_Point2dGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Point2dGG_clear,
		std_vectorLstd_vectorLcv_Point2dGG_get_const_size_t, std_vectorLstd_vectorLcv_Point2dGG_set_size_t_const_vectorLPoint2dG,
		std_vectorLstd_vectorLcv_Point2dGG_push_const_vectorLPoint2dG, std_vectorLstd_vectorLcv_Point2dGG_insert_size_t_const_vectorLPoint2dG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Point2d> }

	impl ToInputArray for core::Vector<core::Vector<core::Point2d>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point2dGG_inputArray_const(self.as_raw_VectorOfVectorOfPoint2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Point2d>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Point2d>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point2dGG_outputArray(self.as_raw_mut_VectorOfVectorOfPoint2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Point2d>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point2dGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfPoint2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Point2d>> }

	impl core::Vector<core::Vector<core::Point2f>> {
		pub fn as_raw_VectorOfVectorOfPoint2f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfPoint2f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Point2f>,
		std_vectorLstd_vectorLcv_Point2fGG_new_const, std_vectorLstd_vectorLcv_Point2fGG_delete,
		std_vectorLstd_vectorLcv_Point2fGG_len_const, std_vectorLstd_vectorLcv_Point2fGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Point2fGG_capacity_const, std_vectorLstd_vectorLcv_Point2fGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Point2fGG_reserve_size_t, std_vectorLstd_vectorLcv_Point2fGG_remove_size_t,
		std_vectorLstd_vectorLcv_Point2fGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Point2fGG_clear,
		std_vectorLstd_vectorLcv_Point2fGG_get_const_size_t, std_vectorLstd_vectorLcv_Point2fGG_set_size_t_const_vectorLPoint2fG,
		std_vectorLstd_vectorLcv_Point2fGG_push_const_vectorLPoint2fG, std_vectorLstd_vectorLcv_Point2fGG_insert_size_t_const_vectorLPoint2fG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Point2f> }

	impl ToInputArray for core::Vector<core::Vector<core::Point2f>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point2fGG_inputArray_const(self.as_raw_VectorOfVectorOfPoint2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Point2f>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Point2f>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point2fGG_outputArray(self.as_raw_mut_VectorOfVectorOfPoint2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Point2f>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point2fGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfPoint2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Point2f>> }

	impl core::Vector<core::Vector<core::Point3d>> {
		pub fn as_raw_VectorOfVectorOfPoint3d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfPoint3d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Point3d>,
		std_vectorLstd_vectorLcv_Point3dGG_new_const, std_vectorLstd_vectorLcv_Point3dGG_delete,
		std_vectorLstd_vectorLcv_Point3dGG_len_const, std_vectorLstd_vectorLcv_Point3dGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Point3dGG_capacity_const, std_vectorLstd_vectorLcv_Point3dGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Point3dGG_reserve_size_t, std_vectorLstd_vectorLcv_Point3dGG_remove_size_t,
		std_vectorLstd_vectorLcv_Point3dGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Point3dGG_clear,
		std_vectorLstd_vectorLcv_Point3dGG_get_const_size_t, std_vectorLstd_vectorLcv_Point3dGG_set_size_t_const_vectorLPoint3dG,
		std_vectorLstd_vectorLcv_Point3dGG_push_const_vectorLPoint3dG, std_vectorLstd_vectorLcv_Point3dGG_insert_size_t_const_vectorLPoint3dG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Point3d> }

	impl ToInputArray for core::Vector<core::Vector<core::Point3d>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3dGG_inputArray_const(self.as_raw_VectorOfVectorOfPoint3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Point3d>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Point3d>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3dGG_outputArray(self.as_raw_mut_VectorOfVectorOfPoint3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Point3d>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3dGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfPoint3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Point3d>> }

	impl core::Vector<core::Vector<core::Point3f>> {
		pub fn as_raw_VectorOfVectorOfPoint3f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfPoint3f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Point3f>,
		std_vectorLstd_vectorLcv_Point3fGG_new_const, std_vectorLstd_vectorLcv_Point3fGG_delete,
		std_vectorLstd_vectorLcv_Point3fGG_len_const, std_vectorLstd_vectorLcv_Point3fGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Point3fGG_capacity_const, std_vectorLstd_vectorLcv_Point3fGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Point3fGG_reserve_size_t, std_vectorLstd_vectorLcv_Point3fGG_remove_size_t,
		std_vectorLstd_vectorLcv_Point3fGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Point3fGG_clear,
		std_vectorLstd_vectorLcv_Point3fGG_get_const_size_t, std_vectorLstd_vectorLcv_Point3fGG_set_size_t_const_vectorLPoint3fG,
		std_vectorLstd_vectorLcv_Point3fGG_push_const_vectorLPoint3fG, std_vectorLstd_vectorLcv_Point3fGG_insert_size_t_const_vectorLPoint3fG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Point3f> }

	impl ToInputArray for core::Vector<core::Vector<core::Point3f>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3fGG_inputArray_const(self.as_raw_VectorOfVectorOfPoint3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Point3f>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Point3f>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3fGG_outputArray(self.as_raw_mut_VectorOfVectorOfPoint3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Point3f>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3fGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfPoint3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Point3f>> }

	impl core::Vector<core::Vector<core::Point3i>> {
		pub fn as_raw_VectorOfVectorOfPoint3i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfPoint3i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Point3i>,
		std_vectorLstd_vectorLcv_Point3iGG_new_const, std_vectorLstd_vectorLcv_Point3iGG_delete,
		std_vectorLstd_vectorLcv_Point3iGG_len_const, std_vectorLstd_vectorLcv_Point3iGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Point3iGG_capacity_const, std_vectorLstd_vectorLcv_Point3iGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Point3iGG_reserve_size_t, std_vectorLstd_vectorLcv_Point3iGG_remove_size_t,
		std_vectorLstd_vectorLcv_Point3iGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Point3iGG_clear,
		std_vectorLstd_vectorLcv_Point3iGG_get_const_size_t, std_vectorLstd_vectorLcv_Point3iGG_set_size_t_const_vectorLPoint3iG,
		std_vectorLstd_vectorLcv_Point3iGG_push_const_vectorLPoint3iG, std_vectorLstd_vectorLcv_Point3iGG_insert_size_t_const_vectorLPoint3iG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Point3i> }

	impl ToInputArray for core::Vector<core::Vector<core::Point3i>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3iGG_inputArray_const(self.as_raw_VectorOfVectorOfPoint3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Point3i>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Point3i>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3iGG_outputArray(self.as_raw_mut_VectorOfVectorOfPoint3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Point3i>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Point3iGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfPoint3i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Point3i>> }

	impl core::Vector<core::Vector<core::Range>> {
		pub fn as_raw_VectorOfVectorOfRange(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfRange(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Range>,
		std_vectorLstd_vectorLcv_RangeGG_new_const, std_vectorLstd_vectorLcv_RangeGG_delete,
		std_vectorLstd_vectorLcv_RangeGG_len_const, std_vectorLstd_vectorLcv_RangeGG_isEmpty_const,
		std_vectorLstd_vectorLcv_RangeGG_capacity_const, std_vectorLstd_vectorLcv_RangeGG_shrinkToFit,
		std_vectorLstd_vectorLcv_RangeGG_reserve_size_t, std_vectorLstd_vectorLcv_RangeGG_remove_size_t,
		std_vectorLstd_vectorLcv_RangeGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_RangeGG_clear,
		std_vectorLstd_vectorLcv_RangeGG_get_const_size_t, std_vectorLstd_vectorLcv_RangeGG_set_size_t_const_vectorLRangeG,
		std_vectorLstd_vectorLcv_RangeGG_push_const_vectorLRangeG, std_vectorLstd_vectorLcv_RangeGG_insert_size_t_const_vectorLRangeG,
	}

	vector_non_copy_or_bool! { core::Vector<core::Range> }


	impl core::Vector<core::Vector<core::Vec2d>> {
		pub fn as_raw_VectorOfVectorOfVec2d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfVec2d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Vec2d>,
		std_vectorLstd_vectorLcv_Vec2dGG_new_const, std_vectorLstd_vectorLcv_Vec2dGG_delete,
		std_vectorLstd_vectorLcv_Vec2dGG_len_const, std_vectorLstd_vectorLcv_Vec2dGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Vec2dGG_capacity_const, std_vectorLstd_vectorLcv_Vec2dGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Vec2dGG_reserve_size_t, std_vectorLstd_vectorLcv_Vec2dGG_remove_size_t,
		std_vectorLstd_vectorLcv_Vec2dGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Vec2dGG_clear,
		std_vectorLstd_vectorLcv_Vec2dGG_get_const_size_t, std_vectorLstd_vectorLcv_Vec2dGG_set_size_t_const_vectorLVec2dG,
		std_vectorLstd_vectorLcv_Vec2dGG_push_const_vectorLVec2dG, std_vectorLstd_vectorLcv_Vec2dGG_insert_size_t_const_vectorLVec2dG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Vec2d> }

	impl ToInputArray for core::Vector<core::Vector<core::Vec2d>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2dGG_inputArray_const(self.as_raw_VectorOfVectorOfVec2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Vec2d>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Vec2d>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2dGG_outputArray(self.as_raw_mut_VectorOfVectorOfVec2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Vec2d>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2dGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfVec2d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Vec2d>> }

	impl core::Vector<core::Vector<core::Vec2f>> {
		pub fn as_raw_VectorOfVectorOfVec2f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfVec2f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Vec2f>,
		std_vectorLstd_vectorLcv_Vec2fGG_new_const, std_vectorLstd_vectorLcv_Vec2fGG_delete,
		std_vectorLstd_vectorLcv_Vec2fGG_len_const, std_vectorLstd_vectorLcv_Vec2fGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Vec2fGG_capacity_const, std_vectorLstd_vectorLcv_Vec2fGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Vec2fGG_reserve_size_t, std_vectorLstd_vectorLcv_Vec2fGG_remove_size_t,
		std_vectorLstd_vectorLcv_Vec2fGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Vec2fGG_clear,
		std_vectorLstd_vectorLcv_Vec2fGG_get_const_size_t, std_vectorLstd_vectorLcv_Vec2fGG_set_size_t_const_vectorLVec2fG,
		std_vectorLstd_vectorLcv_Vec2fGG_push_const_vectorLVec2fG, std_vectorLstd_vectorLcv_Vec2fGG_insert_size_t_const_vectorLVec2fG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Vec2f> }

	impl ToInputArray for core::Vector<core::Vector<core::Vec2f>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2fGG_inputArray_const(self.as_raw_VectorOfVectorOfVec2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Vec2f>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Vec2f>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2fGG_outputArray(self.as_raw_mut_VectorOfVectorOfVec2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Vec2f>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2fGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfVec2f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Vec2f>> }

	impl core::Vector<core::Vector<core::Vec2i>> {
		pub fn as_raw_VectorOfVectorOfVec2i(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfVec2i(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Vec2i>,
		std_vectorLstd_vectorLcv_Vec2iGG_new_const, std_vectorLstd_vectorLcv_Vec2iGG_delete,
		std_vectorLstd_vectorLcv_Vec2iGG_len_const, std_vectorLstd_vectorLcv_Vec2iGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Vec2iGG_capacity_const, std_vectorLstd_vectorLcv_Vec2iGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Vec2iGG_reserve_size_t, std_vectorLstd_vectorLcv_Vec2iGG_remove_size_t,
		std_vectorLstd_vectorLcv_Vec2iGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Vec2iGG_clear,
		std_vectorLstd_vectorLcv_Vec2iGG_get_const_size_t, std_vectorLstd_vectorLcv_Vec2iGG_set_size_t_const_vectorLVec2iG,
		std_vectorLstd_vectorLcv_Vec2iGG_push_const_vectorLVec2iG, std_vectorLstd_vectorLcv_Vec2iGG_insert_size_t_const_vectorLVec2iG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Vec2i> }

	impl ToInputArray for core::Vector<core::Vector<core::Vec2i>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2iGG_inputArray_const(self.as_raw_VectorOfVectorOfVec2i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Vec2i>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Vec2i>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2iGG_outputArray(self.as_raw_mut_VectorOfVectorOfVec2i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Vec2i>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec2iGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfVec2i(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Vec2i>> }

	impl core::Vector<core::Vector<core::Vec3d>> {
		pub fn as_raw_VectorOfVectorOfVec3d(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfVec3d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Vec3d>,
		std_vectorLstd_vectorLcv_Vec3dGG_new_const, std_vectorLstd_vectorLcv_Vec3dGG_delete,
		std_vectorLstd_vectorLcv_Vec3dGG_len_const, std_vectorLstd_vectorLcv_Vec3dGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Vec3dGG_capacity_const, std_vectorLstd_vectorLcv_Vec3dGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Vec3dGG_reserve_size_t, std_vectorLstd_vectorLcv_Vec3dGG_remove_size_t,
		std_vectorLstd_vectorLcv_Vec3dGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Vec3dGG_clear,
		std_vectorLstd_vectorLcv_Vec3dGG_get_const_size_t, std_vectorLstd_vectorLcv_Vec3dGG_set_size_t_const_vectorLVec3dG,
		std_vectorLstd_vectorLcv_Vec3dGG_push_const_vectorLVec3dG, std_vectorLstd_vectorLcv_Vec3dGG_insert_size_t_const_vectorLVec3dG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Vec3d> }

	impl ToInputArray for core::Vector<core::Vector<core::Vec3d>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec3dGG_inputArray_const(self.as_raw_VectorOfVectorOfVec3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Vec3d>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Vec3d>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec3dGG_outputArray(self.as_raw_mut_VectorOfVectorOfVec3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Vec3d>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec3dGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfVec3d(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Vec3d>> }

	impl core::Vector<core::Vector<core::Vec3f>> {
		pub fn as_raw_VectorOfVectorOfVec3f(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfVec3f(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<core::Vec3f>,
		std_vectorLstd_vectorLcv_Vec3fGG_new_const, std_vectorLstd_vectorLcv_Vec3fGG_delete,
		std_vectorLstd_vectorLcv_Vec3fGG_len_const, std_vectorLstd_vectorLcv_Vec3fGG_isEmpty_const,
		std_vectorLstd_vectorLcv_Vec3fGG_capacity_const, std_vectorLstd_vectorLcv_Vec3fGG_shrinkToFit,
		std_vectorLstd_vectorLcv_Vec3fGG_reserve_size_t, std_vectorLstd_vectorLcv_Vec3fGG_remove_size_t,
		std_vectorLstd_vectorLcv_Vec3fGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_Vec3fGG_clear,
		std_vectorLstd_vectorLcv_Vec3fGG_get_const_size_t, std_vectorLstd_vectorLcv_Vec3fGG_set_size_t_const_vectorLVec3fG,
		std_vectorLstd_vectorLcv_Vec3fGG_push_const_vectorLVec3fG, std_vectorLstd_vectorLcv_Vec3fGG_insert_size_t_const_vectorLVec3fG,
	}

	vector_non_copy_or_bool! { clone core::Vector<core::Vec3f> }

	impl ToInputArray for core::Vector<core::Vector<core::Vec3f>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec3fGG_inputArray_const(self.as_raw_VectorOfVectorOfVec3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<core::Vec3f>> }

	impl ToOutputArray for core::Vector<core::Vector<core::Vec3f>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec3fGG_outputArray(self.as_raw_mut_VectorOfVectorOfVec3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<core::Vec3f>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLcv_Vec3fGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfVec3f(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<core::Vec3f>> }

	impl core::Vector<core::Vector<c_char>> {
		pub fn as_raw_VectorOfVectorOfc_char(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfc_char(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::Vector<core::Vector<f32>> {
		pub fn as_raw_VectorOfVectorOff32(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOff32(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<f32>,
		std_vectorLstd_vectorLfloatGG_new_const, std_vectorLstd_vectorLfloatGG_delete,
		std_vectorLstd_vectorLfloatGG_len_const, std_vectorLstd_vectorLfloatGG_isEmpty_const,
		std_vectorLstd_vectorLfloatGG_capacity_const, std_vectorLstd_vectorLfloatGG_shrinkToFit,
		std_vectorLstd_vectorLfloatGG_reserve_size_t, std_vectorLstd_vectorLfloatGG_remove_size_t,
		std_vectorLstd_vectorLfloatGG_swap_size_t_size_t, std_vectorLstd_vectorLfloatGG_clear,
		std_vectorLstd_vectorLfloatGG_get_const_size_t, std_vectorLstd_vectorLfloatGG_set_size_t_const_vectorLfloatG,
		std_vectorLstd_vectorLfloatGG_push_const_vectorLfloatG, std_vectorLstd_vectorLfloatGG_insert_size_t_const_vectorLfloatG,
	}

	vector_non_copy_or_bool! { clone core::Vector<f32> }

	impl ToInputArray for core::Vector<core::Vector<f32>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLfloatGG_inputArray_const(self.as_raw_VectorOfVectorOff32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<f32>> }

	impl ToOutputArray for core::Vector<core::Vector<f32>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLfloatGG_outputArray(self.as_raw_mut_VectorOfVectorOff32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<f32>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLfloatGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOff32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<f32>> }

	impl core::Vector<core::Vector<f64>> {
		pub fn as_raw_VectorOfVectorOff64(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOff64(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<f64>,
		std_vectorLstd_vectorLdoubleGG_new_const, std_vectorLstd_vectorLdoubleGG_delete,
		std_vectorLstd_vectorLdoubleGG_len_const, std_vectorLstd_vectorLdoubleGG_isEmpty_const,
		std_vectorLstd_vectorLdoubleGG_capacity_const, std_vectorLstd_vectorLdoubleGG_shrinkToFit,
		std_vectorLstd_vectorLdoubleGG_reserve_size_t, std_vectorLstd_vectorLdoubleGG_remove_size_t,
		std_vectorLstd_vectorLdoubleGG_swap_size_t_size_t, std_vectorLstd_vectorLdoubleGG_clear,
		std_vectorLstd_vectorLdoubleGG_get_const_size_t, std_vectorLstd_vectorLdoubleGG_set_size_t_const_vectorLdoubleG,
		std_vectorLstd_vectorLdoubleGG_push_const_vectorLdoubleG, std_vectorLstd_vectorLdoubleGG_insert_size_t_const_vectorLdoubleG,
	}

	vector_non_copy_or_bool! { clone core::Vector<f64> }

	impl ToInputArray for core::Vector<core::Vector<f64>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLdoubleGG_inputArray_const(self.as_raw_VectorOfVectorOff64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<f64>> }

	impl ToOutputArray for core::Vector<core::Vector<f64>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLdoubleGG_outputArray(self.as_raw_mut_VectorOfVectorOff64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<f64>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLdoubleGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOff64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<f64>> }

	impl core::Vector<core::Vector<i32>> {
		pub fn as_raw_VectorOfVectorOfi32(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfi32(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<i32>,
		std_vectorLstd_vectorLintGG_new_const, std_vectorLstd_vectorLintGG_delete,
		std_vectorLstd_vectorLintGG_len_const, std_vectorLstd_vectorLintGG_isEmpty_const,
		std_vectorLstd_vectorLintGG_capacity_const, std_vectorLstd_vectorLintGG_shrinkToFit,
		std_vectorLstd_vectorLintGG_reserve_size_t, std_vectorLstd_vectorLintGG_remove_size_t,
		std_vectorLstd_vectorLintGG_swap_size_t_size_t, std_vectorLstd_vectorLintGG_clear,
		std_vectorLstd_vectorLintGG_get_const_size_t, std_vectorLstd_vectorLintGG_set_size_t_const_vectorLintG,
		std_vectorLstd_vectorLintGG_push_const_vectorLintG, std_vectorLstd_vectorLintGG_insert_size_t_const_vectorLintG,
	}

	vector_non_copy_or_bool! { clone core::Vector<i32> }

	impl ToInputArray for core::Vector<core::Vector<i32>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLintGG_inputArray_const(self.as_raw_VectorOfVectorOfi32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<i32>> }

	impl ToOutputArray for core::Vector<core::Vector<i32>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLintGG_outputArray(self.as_raw_mut_VectorOfVectorOfi32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<i32>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLintGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfi32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<i32>> }

	impl core::Vector<core::Vector<i8>> {
		pub fn as_raw_VectorOfVectorOfi8(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfi8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<i8>,
		std_vectorLstd_vectorLsigned_charGG_new_const, std_vectorLstd_vectorLsigned_charGG_delete,
		std_vectorLstd_vectorLsigned_charGG_len_const, std_vectorLstd_vectorLsigned_charGG_isEmpty_const,
		std_vectorLstd_vectorLsigned_charGG_capacity_const, std_vectorLstd_vectorLsigned_charGG_shrinkToFit,
		std_vectorLstd_vectorLsigned_charGG_reserve_size_t, std_vectorLstd_vectorLsigned_charGG_remove_size_t,
		std_vectorLstd_vectorLsigned_charGG_swap_size_t_size_t, std_vectorLstd_vectorLsigned_charGG_clear,
		std_vectorLstd_vectorLsigned_charGG_get_const_size_t, std_vectorLstd_vectorLsigned_charGG_set_size_t_const_vectorLsigned_charG,
		std_vectorLstd_vectorLsigned_charGG_push_const_vectorLsigned_charG, std_vectorLstd_vectorLsigned_charGG_insert_size_t_const_vectorLsigned_charG,
	}

	vector_non_copy_or_bool! { clone core::Vector<i8> }


	impl core::Vector<core::Vector<u8>> {
		pub fn as_raw_VectorOfVectorOfu8(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfu8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<u8>,
		std_vectorLstd_vectorLuint8_tGG_new_const, std_vectorLstd_vectorLuint8_tGG_delete,
		std_vectorLstd_vectorLuint8_tGG_len_const, std_vectorLstd_vectorLuint8_tGG_isEmpty_const,
		std_vectorLstd_vectorLuint8_tGG_capacity_const, std_vectorLstd_vectorLuint8_tGG_shrinkToFit,
		std_vectorLstd_vectorLuint8_tGG_reserve_size_t, std_vectorLstd_vectorLuint8_tGG_remove_size_t,
		std_vectorLstd_vectorLuint8_tGG_swap_size_t_size_t, std_vectorLstd_vectorLuint8_tGG_clear,
		std_vectorLstd_vectorLuint8_tGG_get_const_size_t, std_vectorLstd_vectorLuint8_tGG_set_size_t_const_vectorLuint8_tG,
		std_vectorLstd_vectorLuint8_tGG_push_const_vectorLuint8_tG, std_vectorLstd_vectorLuint8_tGG_insert_size_t_const_vectorLuint8_tG,
	}

	vector_non_copy_or_bool! { clone core::Vector<u8> }

	impl ToInputArray for core::Vector<core::Vector<u8>> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLuint8_tGG_inputArray_const(self.as_raw_VectorOfVectorOfu8(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<core::Vector<u8>> }

	impl ToOutputArray for core::Vector<core::Vector<u8>> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLuint8_tGG_outputArray(self.as_raw_mut_VectorOfVectorOfu8(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<core::Vector<u8>> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLstd_vectorLuint8_tGG_inputOutputArray(self.as_raw_mut_VectorOfVectorOfu8(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<core::Vector<u8>> }

	impl core::Vector<bool> {
		pub fn as_raw_VectorOfbool(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfbool(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { bool,
		std_vectorLboolG_new_const, std_vectorLboolG_delete,
		std_vectorLboolG_len_const, std_vectorLboolG_isEmpty_const,
		std_vectorLboolG_capacity_const, std_vectorLboolG_shrinkToFit,
		std_vectorLboolG_reserve_size_t, std_vectorLboolG_remove_size_t,
		std_vectorLboolG_swap_size_t_size_t, std_vectorLboolG_clear,
		std_vectorLboolG_get_const_size_t, std_vectorLboolG_set_size_t_const_bool,
		std_vectorLboolG_push_const_bool, std_vectorLboolG_insert_size_t_const_bool,
	}

	vector_non_copy_or_bool! { clone bool }

	impl ToInputArray for core::Vector<bool> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLboolG_inputArray_const(self.as_raw_VectorOfbool(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<bool> }

	impl core::Vector<c_char> {
		pub fn as_raw_VectorOfc_char(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfc_char(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::Vector<f32> {
		pub fn as_raw_VectorOff32(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOff32(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { f32,
		std_vectorLfloatG_new_const, std_vectorLfloatG_delete,
		std_vectorLfloatG_len_const, std_vectorLfloatG_isEmpty_const,
		std_vectorLfloatG_capacity_const, std_vectorLfloatG_shrinkToFit,
		std_vectorLfloatG_reserve_size_t, std_vectorLfloatG_remove_size_t,
		std_vectorLfloatG_swap_size_t_size_t, std_vectorLfloatG_clear,
		std_vectorLfloatG_get_const_size_t, std_vectorLfloatG_set_size_t_const_float,
		std_vectorLfloatG_push_const_float, std_vectorLfloatG_insert_size_t_const_float,
	}

	vector_copy_non_bool! { f32,
		std_vectorLfloatG_data_const, std_vectorLfloatG_dataMut, cv_fromSlice_const_const_floatX_size_t,
		std_vectorLfloatG_clone_const,
	}

	impl ToInputArray for core::Vector<f32> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLfloatG_inputArray_const(self.as_raw_VectorOff32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<f32> }

	impl ToOutputArray for core::Vector<f32> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLfloatG_outputArray(self.as_raw_mut_VectorOff32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<f32> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLfloatG_inputOutputArray(self.as_raw_mut_VectorOff32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<f32> }

	impl core::Vector<f64> {
		pub fn as_raw_VectorOff64(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOff64(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { f64,
		std_vectorLdoubleG_new_const, std_vectorLdoubleG_delete,
		std_vectorLdoubleG_len_const, std_vectorLdoubleG_isEmpty_const,
		std_vectorLdoubleG_capacity_const, std_vectorLdoubleG_shrinkToFit,
		std_vectorLdoubleG_reserve_size_t, std_vectorLdoubleG_remove_size_t,
		std_vectorLdoubleG_swap_size_t_size_t, std_vectorLdoubleG_clear,
		std_vectorLdoubleG_get_const_size_t, std_vectorLdoubleG_set_size_t_const_double,
		std_vectorLdoubleG_push_const_double, std_vectorLdoubleG_insert_size_t_const_double,
	}

	vector_copy_non_bool! { f64,
		std_vectorLdoubleG_data_const, std_vectorLdoubleG_dataMut, cv_fromSlice_const_const_doubleX_size_t,
		std_vectorLdoubleG_clone_const,
	}

	impl ToInputArray for core::Vector<f64> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLdoubleG_inputArray_const(self.as_raw_VectorOff64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<f64> }

	impl ToOutputArray for core::Vector<f64> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLdoubleG_outputArray(self.as_raw_mut_VectorOff64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<f64> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLdoubleG_inputOutputArray(self.as_raw_mut_VectorOff64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<f64> }

	impl core::Vector<i32> {
		pub fn as_raw_VectorOfi32(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfi32(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { i32,
		std_vectorLintG_new_const, std_vectorLintG_delete,
		std_vectorLintG_len_const, std_vectorLintG_isEmpty_const,
		std_vectorLintG_capacity_const, std_vectorLintG_shrinkToFit,
		std_vectorLintG_reserve_size_t, std_vectorLintG_remove_size_t,
		std_vectorLintG_swap_size_t_size_t, std_vectorLintG_clear,
		std_vectorLintG_get_const_size_t, std_vectorLintG_set_size_t_const_int,
		std_vectorLintG_push_const_int, std_vectorLintG_insert_size_t_const_int,
	}

	vector_copy_non_bool! { i32,
		std_vectorLintG_data_const, std_vectorLintG_dataMut, cv_fromSlice_const_const_intX_size_t,
		std_vectorLintG_clone_const,
	}

	impl ToInputArray for core::Vector<i32> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLintG_inputArray_const(self.as_raw_VectorOfi32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<i32> }

	impl ToOutputArray for core::Vector<i32> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLintG_outputArray(self.as_raw_mut_VectorOfi32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<i32> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLintG_inputOutputArray(self.as_raw_mut_VectorOfi32(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<i32> }

	impl core::Vector<i8> {
		pub fn as_raw_VectorOfi8(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfi8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { i8,
		std_vectorLsigned_charG_new_const, std_vectorLsigned_charG_delete,
		std_vectorLsigned_charG_len_const, std_vectorLsigned_charG_isEmpty_const,
		std_vectorLsigned_charG_capacity_const, std_vectorLsigned_charG_shrinkToFit,
		std_vectorLsigned_charG_reserve_size_t, std_vectorLsigned_charG_remove_size_t,
		std_vectorLsigned_charG_swap_size_t_size_t, std_vectorLsigned_charG_clear,
		std_vectorLsigned_charG_get_const_size_t, std_vectorLsigned_charG_set_size_t_const_signed_char,
		std_vectorLsigned_charG_push_const_signed_char, std_vectorLsigned_charG_insert_size_t_const_signed_char,
	}

	vector_copy_non_bool! { i8,
		std_vectorLsigned_charG_data_const, std_vectorLsigned_charG_dataMut, cv_fromSlice_const_const_signed_charX_size_t,
		std_vectorLsigned_charG_clone_const,
	}


	impl core::Vector<size_t> {
		pub fn as_raw_VectorOfsize_t(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfsize_t(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { size_t,
		std_vectorLsize_tG_new_const, std_vectorLsize_tG_delete,
		std_vectorLsize_tG_len_const, std_vectorLsize_tG_isEmpty_const,
		std_vectorLsize_tG_capacity_const, std_vectorLsize_tG_shrinkToFit,
		std_vectorLsize_tG_reserve_size_t, std_vectorLsize_tG_remove_size_t,
		std_vectorLsize_tG_swap_size_t_size_t, std_vectorLsize_tG_clear,
		std_vectorLsize_tG_get_const_size_t, std_vectorLsize_tG_set_size_t_const_size_t,
		std_vectorLsize_tG_push_const_size_t, std_vectorLsize_tG_insert_size_t_const_size_t,
	}

	vector_copy_non_bool! { size_t,
		std_vectorLsize_tG_data_const, std_vectorLsize_tG_dataMut, cv_fromSlice_const_const_size_tX_size_t,
		std_vectorLsize_tG_clone_const,
	}


	impl core::Vector<u64> {
		pub fn as_raw_VectorOfu64(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfu64(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { u64,
		std_vectorLuint64_tG_new_const, std_vectorLuint64_tG_delete,
		std_vectorLuint64_tG_len_const, std_vectorLuint64_tG_isEmpty_const,
		std_vectorLuint64_tG_capacity_const, std_vectorLuint64_tG_shrinkToFit,
		std_vectorLuint64_tG_reserve_size_t, std_vectorLuint64_tG_remove_size_t,
		std_vectorLuint64_tG_swap_size_t_size_t, std_vectorLuint64_tG_clear,
		std_vectorLuint64_tG_get_const_size_t, std_vectorLuint64_tG_set_size_t_const_uint64_t,
		std_vectorLuint64_tG_push_const_uint64_t, std_vectorLuint64_tG_insert_size_t_const_uint64_t,
	}

	vector_copy_non_bool! { u64,
		std_vectorLuint64_tG_data_const, std_vectorLuint64_tG_dataMut, cv_fromSlice_const_const_uint64_tX_size_t,
		std_vectorLuint64_tG_clone_const,
	}

	#[cfg(ocvrs_opencv_branch_5)]
	impl ToInputArray for core::Vector<u64> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLuint64_tG_inputArray_const(self.as_raw_VectorOfu64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	#[cfg(ocvrs_opencv_branch_5)]
	input_array_ref_forward! { core::Vector<u64> }

	#[cfg(ocvrs_opencv_branch_5)]
	impl ToOutputArray for core::Vector<u64> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLuint64_tG_outputArray(self.as_raw_mut_VectorOfu64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	#[cfg(ocvrs_opencv_branch_5)]
	impl ToInputOutputArray for core::Vector<u64> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLuint64_tG_inputOutputArray(self.as_raw_mut_VectorOfu64(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	#[cfg(ocvrs_opencv_branch_5)]
	output_array_ref_forward! { core::Vector<u64> }

	impl core::Vector<u8> {
		pub fn as_raw_VectorOfu8(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfu8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { u8,
		std_vectorLuint8_tG_new_const, std_vectorLuint8_tG_delete,
		std_vectorLuint8_tG_len_const, std_vectorLuint8_tG_isEmpty_const,
		std_vectorLuint8_tG_capacity_const, std_vectorLuint8_tG_shrinkToFit,
		std_vectorLuint8_tG_reserve_size_t, std_vectorLuint8_tG_remove_size_t,
		std_vectorLuint8_tG_swap_size_t_size_t, std_vectorLuint8_tG_clear,
		std_vectorLuint8_tG_get_const_size_t, std_vectorLuint8_tG_set_size_t_const_uint8_t,
		std_vectorLuint8_tG_push_const_uint8_t, std_vectorLuint8_tG_insert_size_t_const_uint8_t,
	}

	vector_copy_non_bool! { u8,
		std_vectorLuint8_tG_data_const, std_vectorLuint8_tG_dataMut, cv_fromSlice_const_const_uint8_tX_size_t,
		std_vectorLuint8_tG_clone_const,
	}

	impl ToInputArray for core::Vector<u8> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLuint8_tG_inputArray_const(self.as_raw_VectorOfu8(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	input_array_ref_forward! { core::Vector<u8> }

	impl ToOutputArray for core::Vector<u8> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLuint8_tG_outputArray(self.as_raw_mut_VectorOfu8(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	impl ToInputOutputArray for core::Vector<u8> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLuint8_tG_inputOutputArray(self.as_raw_mut_VectorOfu8(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	output_array_ref_forward! { core::Vector<u8> }

	impl core::MatOpTraitConst for types::AbstractRefMut<'static, core::MatOp> {
		#[inline] fn as_raw_MatOp(&self) -> extern_send!(Self) { self.as_raw() }
	}

	impl core::MatOpTrait for types::AbstractRefMut<'static, core::MatOp> {
		#[inline] fn as_raw_mut_MatOp(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

}
pub use core_types::*;

mod cudaarithm_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudaarithm::Convolution,
		cv_PtrLcv_cuda_ConvolutionG_new_null_const, cv_PtrLcv_cuda_ConvolutionG_delete, cv_PtrLcv_cuda_ConvolutionG_getInnerPtr_const, cv_PtrLcv_cuda_ConvolutionG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaarithm::Convolution> {
		#[inline] pub fn as_raw_PtrOfConvolution(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfConvolution(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaarithm::ConvolutionTraitConst for core::Ptr<crate::cudaarithm::Convolution> {
		#[inline] fn as_raw_Convolution(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaarithm::ConvolutionTrait for core::Ptr<crate::cudaarithm::Convolution> {
		#[inline] fn as_raw_mut_Convolution(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaarithm::Convolution> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaarithm::Convolution> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaarithm::Convolution>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_ConvolutionG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaarithm::Convolution> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfConvolution")
				.finish()
		}
	}

	ptr_extern! { crate::cudaarithm::DFT,
		cv_PtrLcv_cuda_DFTG_new_null_const, cv_PtrLcv_cuda_DFTG_delete, cv_PtrLcv_cuda_DFTG_getInnerPtr_const, cv_PtrLcv_cuda_DFTG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaarithm::DFT> {
		#[inline] pub fn as_raw_PtrOfDFT(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDFT(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaarithm::DFTTraitConst for core::Ptr<crate::cudaarithm::DFT> {
		#[inline] fn as_raw_DFT(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaarithm::DFTTrait for core::Ptr<crate::cudaarithm::DFT> {
		#[inline] fn as_raw_mut_DFT(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaarithm::DFT> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaarithm::DFT> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaarithm::DFT>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_DFTG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaarithm::DFT> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDFT")
				.finish()
		}
	}

	ptr_extern! { crate::cudaarithm::LookUpTable,
		cv_PtrLcv_cuda_LookUpTableG_new_null_const, cv_PtrLcv_cuda_LookUpTableG_delete, cv_PtrLcv_cuda_LookUpTableG_getInnerPtr_const, cv_PtrLcv_cuda_LookUpTableG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaarithm::LookUpTable> {
		#[inline] pub fn as_raw_PtrOfLookUpTable(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLookUpTable(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaarithm::LookUpTableTraitConst for core::Ptr<crate::cudaarithm::LookUpTable> {
		#[inline] fn as_raw_LookUpTable(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaarithm::LookUpTableTrait for core::Ptr<crate::cudaarithm::LookUpTable> {
		#[inline] fn as_raw_mut_LookUpTable(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaarithm::LookUpTable> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaarithm::LookUpTable> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaarithm::LookUpTable>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_LookUpTableG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaarithm::LookUpTable> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLookUpTable")
				.finish()
		}
	}

}
pub use cudaarithm_types::*;

mod cudabgsegm_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudabgsegm::CUDA_BackgroundSubtractorMOG,
		cv_PtrLcv_cuda_BackgroundSubtractorMOGG_new_null_const, cv_PtrLcv_cuda_BackgroundSubtractorMOGG_delete, cv_PtrLcv_cuda_BackgroundSubtractorMOGG_getInnerPtr_const, cv_PtrLcv_cuda_BackgroundSubtractorMOGG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline] pub fn as_raw_PtrOfCUDA_BackgroundSubtractorMOG(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_BackgroundSubtractorMOG(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudabgsegm::CUDA_BackgroundSubtractorMOGTraitConst for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline] fn as_raw_CUDA_BackgroundSubtractorMOG(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudabgsegm::CUDA_BackgroundSubtractorMOGTrait for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline] fn as_raw_mut_CUDA_BackgroundSubtractorMOG(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_BackgroundSubtractorMOGG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_cuda_BackgroundSubtractorMOGG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_BackgroundSubtractorMOG")
				.finish()
		}
	}

	ptr_extern! { crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2,
		cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_new_null_const, cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_delete, cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_getInnerPtr_const, cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_getInnerPtrMut
	}

	impl core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] pub fn as_raw_PtrOfCUDA_BackgroundSubtractorMOG2(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_BackgroundSubtractorMOG2(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2TraitConst for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_CUDA_BackgroundSubtractorMOG2(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2Trait for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_mut_CUDA_BackgroundSubtractorMOG2(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_to_PtrOfBackgroundSubtractor }

	impl crate::video::BackgroundSubtractorMOG2TraitConst for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_BackgroundSubtractorMOG2(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorMOG2Trait for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline] fn as_raw_mut_BackgroundSubtractorMOG2(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2>, core::Ptr<crate::video::BackgroundSubtractorMOG2>, cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_to_PtrOfBackgroundSubtractorMOG2 }

	impl std::fmt::Debug for core::Ptr<crate::cudabgsegm::CUDA_BackgroundSubtractorMOG2> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_BackgroundSubtractorMOG2")
				.finish()
		}
	}

}
pub use cudabgsegm_types::*;

mod cudacodec_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudacodec::CUDA_EncoderCallback,
		cv_PtrLcv_cudacodec_EncoderCallbackG_new_null_const, cv_PtrLcv_cudacodec_EncoderCallbackG_delete, cv_PtrLcv_cudacodec_EncoderCallbackG_getInnerPtr_const, cv_PtrLcv_cudacodec_EncoderCallbackG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudacodec::CUDA_EncoderCallback> {
		#[inline] pub fn as_raw_PtrOfCUDA_EncoderCallback(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_EncoderCallback(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudacodec::CUDA_EncoderCallbackTraitConst for core::Ptr<crate::cudacodec::CUDA_EncoderCallback> {
		#[inline] fn as_raw_CUDA_EncoderCallback(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudacodec::CUDA_EncoderCallbackTrait for core::Ptr<crate::cudacodec::CUDA_EncoderCallback> {
		#[inline] fn as_raw_mut_CUDA_EncoderCallback(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::cudacodec::CUDA_EncoderCallback> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_EncoderCallback")
				.finish()
		}
	}

	ptr_extern! { crate::cudacodec::CUDA_NVSurfaceToColorConverter,
		cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_new_null_const, cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_delete, cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_getInnerPtr_const, cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudacodec::CUDA_NVSurfaceToColorConverter> {
		#[inline] pub fn as_raw_PtrOfCUDA_NVSurfaceToColorConverter(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_NVSurfaceToColorConverter(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudacodec::CUDA_NVSurfaceToColorConverterTraitConst for core::Ptr<crate::cudacodec::CUDA_NVSurfaceToColorConverter> {
		#[inline] fn as_raw_CUDA_NVSurfaceToColorConverter(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudacodec::CUDA_NVSurfaceToColorConverterTrait for core::Ptr<crate::cudacodec::CUDA_NVSurfaceToColorConverter> {
		#[inline] fn as_raw_mut_CUDA_NVSurfaceToColorConverter(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::cudacodec::CUDA_NVSurfaceToColorConverter> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_NVSurfaceToColorConverter")
				.finish()
		}
	}

	ptr_extern! { crate::cudacodec::CUDA_RawVideoSource,
		cv_PtrLcv_cudacodec_RawVideoSourceG_new_null_const, cv_PtrLcv_cudacodec_RawVideoSourceG_delete, cv_PtrLcv_cudacodec_RawVideoSourceG_getInnerPtr_const, cv_PtrLcv_cudacodec_RawVideoSourceG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudacodec::CUDA_RawVideoSource> {
		#[inline] pub fn as_raw_PtrOfCUDA_RawVideoSource(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_RawVideoSource(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudacodec::CUDA_RawVideoSourceTraitConst for core::Ptr<crate::cudacodec::CUDA_RawVideoSource> {
		#[inline] fn as_raw_CUDA_RawVideoSource(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudacodec::CUDA_RawVideoSourceTrait for core::Ptr<crate::cudacodec::CUDA_RawVideoSource> {
		#[inline] fn as_raw_mut_CUDA_RawVideoSource(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::cudacodec::CUDA_RawVideoSource> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_RawVideoSource")
				.finish()
		}
	}

	ptr_extern! { crate::cudacodec::CUDA_VideoReader,
		cv_PtrLcv_cudacodec_VideoReaderG_new_null_const, cv_PtrLcv_cudacodec_VideoReaderG_delete, cv_PtrLcv_cudacodec_VideoReaderG_getInnerPtr_const, cv_PtrLcv_cudacodec_VideoReaderG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudacodec::CUDA_VideoReader> {
		#[inline] pub fn as_raw_PtrOfCUDA_VideoReader(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_VideoReader(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudacodec::CUDA_VideoReaderTraitConst for core::Ptr<crate::cudacodec::CUDA_VideoReader> {
		#[inline] fn as_raw_CUDA_VideoReader(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudacodec::CUDA_VideoReaderTrait for core::Ptr<crate::cudacodec::CUDA_VideoReader> {
		#[inline] fn as_raw_mut_CUDA_VideoReader(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::cudacodec::CUDA_VideoReader> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_VideoReader")
				.finish()
		}
	}

	ptr_extern! { crate::cudacodec::CUDA_VideoWriter,
		cv_PtrLcv_cudacodec_VideoWriterG_new_null_const, cv_PtrLcv_cudacodec_VideoWriterG_delete, cv_PtrLcv_cudacodec_VideoWriterG_getInnerPtr_const, cv_PtrLcv_cudacodec_VideoWriterG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudacodec::CUDA_VideoWriter> {
		#[inline] pub fn as_raw_PtrOfCUDA_VideoWriter(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_VideoWriter(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudacodec::CUDA_VideoWriterTraitConst for core::Ptr<crate::cudacodec::CUDA_VideoWriter> {
		#[inline] fn as_raw_CUDA_VideoWriter(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudacodec::CUDA_VideoWriterTrait for core::Ptr<crate::cudacodec::CUDA_VideoWriter> {
		#[inline] fn as_raw_mut_CUDA_VideoWriter(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::cudacodec::CUDA_VideoWriter> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_VideoWriter")
				.finish()
		}
	}

}
pub use cudacodec_types::*;

mod cudafeatures2d_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudafeatures2d::CUDA_DescriptorMatcher,
		cv_PtrLcv_cuda_DescriptorMatcherG_new_null_const, cv_PtrLcv_cuda_DescriptorMatcherG_delete, cv_PtrLcv_cuda_DescriptorMatcherG_getInnerPtr_const, cv_PtrLcv_cuda_DescriptorMatcherG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudafeatures2d::CUDA_DescriptorMatcher> {
		#[inline] pub fn as_raw_PtrOfCUDA_DescriptorMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_DescriptorMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudafeatures2d::CUDA_DescriptorMatcherTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_DescriptorMatcher> {
		#[inline] fn as_raw_CUDA_DescriptorMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudafeatures2d::CUDA_DescriptorMatcherTrait for core::Ptr<crate::cudafeatures2d::CUDA_DescriptorMatcher> {
		#[inline] fn as_raw_mut_CUDA_DescriptorMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_DescriptorMatcher> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudafeatures2d::CUDA_DescriptorMatcher> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_DescriptorMatcher>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_DescriptorMatcherG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudafeatures2d::CUDA_DescriptorMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_DescriptorMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::cudafeatures2d::CUDA_FastFeatureDetector,
		cv_PtrLcv_cuda_FastFeatureDetectorG_new_null_const, cv_PtrLcv_cuda_FastFeatureDetectorG_delete, cv_PtrLcv_cuda_FastFeatureDetectorG_getInnerPtr_const, cv_PtrLcv_cuda_FastFeatureDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] pub fn as_raw_PtrOfCUDA_FastFeatureDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_FastFeatureDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudafeatures2d::CUDA_FastFeatureDetectorTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_CUDA_FastFeatureDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudafeatures2d::CUDA_FastFeatureDetectorTrait for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_mut_CUDA_FastFeatureDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_FastFeatureDetectorG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_cuda_FastFeatureDetectorG_to_PtrOfFeature2D }

	impl crate::cudafeatures2d::CUDA_Feature2DAsyncTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_CUDA_Feature2DAsync(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudafeatures2d::CUDA_Feature2DAsyncTrait for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline] fn as_raw_mut_CUDA_Feature2DAsync(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector>, core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync>, cv_PtrLcv_cuda_FastFeatureDetectorG_to_PtrOfCUDA_Feature2DAsync }

	impl std::fmt::Debug for core::Ptr<crate::cudafeatures2d::CUDA_FastFeatureDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_FastFeatureDetector")
				.finish()
		}
	}

	ptr_extern! { crate::cudafeatures2d::CUDA_Feature2DAsync,
		cv_PtrLcv_cuda_Feature2DAsyncG_new_null_const, cv_PtrLcv_cuda_Feature2DAsyncG_delete, cv_PtrLcv_cuda_Feature2DAsyncG_getInnerPtr_const, cv_PtrLcv_cuda_Feature2DAsyncG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline] pub fn as_raw_PtrOfCUDA_Feature2DAsync(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_Feature2DAsync(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudafeatures2d::CUDA_Feature2DAsyncTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline] fn as_raw_CUDA_Feature2DAsync(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudafeatures2d::CUDA_Feature2DAsyncTrait for core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline] fn as_raw_mut_CUDA_Feature2DAsync(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_Feature2DAsyncG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_cuda_Feature2DAsyncG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_Feature2DAsync")
				.finish()
		}
	}

	ptr_extern! { crate::cudafeatures2d::CUDA_ORB,
		cv_PtrLcv_cuda_ORBG_new_null_const, cv_PtrLcv_cuda_ORBG_delete, cv_PtrLcv_cuda_ORBG_getInnerPtr_const, cv_PtrLcv_cuda_ORBG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] pub fn as_raw_PtrOfCUDA_ORB(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_ORB(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudafeatures2d::CUDA_ORBTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_CUDA_ORB(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudafeatures2d::CUDA_ORBTrait for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_mut_CUDA_ORB(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_ORB>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_ORBG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_ORB>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_cuda_ORBG_to_PtrOfFeature2D }

	impl crate::cudafeatures2d::CUDA_Feature2DAsyncTraitConst for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_CUDA_Feature2DAsync(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudafeatures2d::CUDA_Feature2DAsyncTrait for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline] fn as_raw_mut_CUDA_Feature2DAsync(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafeatures2d::CUDA_ORB>, core::Ptr<crate::cudafeatures2d::CUDA_Feature2DAsync>, cv_PtrLcv_cuda_ORBG_to_PtrOfCUDA_Feature2DAsync }

	impl std::fmt::Debug for core::Ptr<crate::cudafeatures2d::CUDA_ORB> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_ORB")
				.finish()
		}
	}

}
pub use cudafeatures2d_types::*;

mod cudafilters_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudafilters::Filter,
		cv_PtrLcv_cuda_FilterG_new_null_const, cv_PtrLcv_cuda_FilterG_delete, cv_PtrLcv_cuda_FilterG_getInnerPtr_const, cv_PtrLcv_cuda_FilterG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudafilters::Filter> {
		#[inline] pub fn as_raw_PtrOfFilter(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFilter(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudafilters::FilterTraitConst for core::Ptr<crate::cudafilters::Filter> {
		#[inline] fn as_raw_Filter(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudafilters::FilterTrait for core::Ptr<crate::cudafilters::Filter> {
		#[inline] fn as_raw_mut_Filter(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudafilters::Filter> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudafilters::Filter> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudafilters::Filter>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_FilterG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudafilters::Filter> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFilter")
				.finish()
		}
	}

}
pub use cudafilters_types::*;

mod cudaimgproc_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudaimgproc::CUDA_CLAHE,
		cv_PtrLcv_cuda_CLAHEG_new_null_const, cv_PtrLcv_cuda_CLAHEG_delete, cv_PtrLcv_cuda_CLAHEG_getInnerPtr_const, cv_PtrLcv_cuda_CLAHEG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline] pub fn as_raw_PtrOfCUDA_CLAHE(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_CLAHE(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_CLAHETraitConst for core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline] fn as_raw_CUDA_CLAHE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_CLAHETrait for core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline] fn as_raw_mut_CUDA_CLAHE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_CLAHE>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_CLAHEG_to_PtrOfAlgorithm }

	impl crate::imgproc::CLAHETraitConst for core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline] fn as_raw_CLAHE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::CLAHETrait for core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline] fn as_raw_mut_CLAHE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_CLAHE>, core::Ptr<crate::imgproc::CLAHE>, cv_PtrLcv_cuda_CLAHEG_to_PtrOfCLAHE }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_CLAHE> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_CLAHE")
				.finish()
		}
	}

	ptr_extern! { crate::cudaimgproc::CUDA_CannyEdgeDetector,
		cv_PtrLcv_cuda_CannyEdgeDetectorG_new_null_const, cv_PtrLcv_cuda_CannyEdgeDetectorG_delete, cv_PtrLcv_cuda_CannyEdgeDetectorG_getInnerPtr_const, cv_PtrLcv_cuda_CannyEdgeDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_CannyEdgeDetector> {
		#[inline] pub fn as_raw_PtrOfCUDA_CannyEdgeDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_CannyEdgeDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_CannyEdgeDetectorTraitConst for core::Ptr<crate::cudaimgproc::CUDA_CannyEdgeDetector> {
		#[inline] fn as_raw_CUDA_CannyEdgeDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_CannyEdgeDetectorTrait for core::Ptr<crate::cudaimgproc::CUDA_CannyEdgeDetector> {
		#[inline] fn as_raw_mut_CUDA_CannyEdgeDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_CannyEdgeDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_CannyEdgeDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_CannyEdgeDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_CannyEdgeDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_CannyEdgeDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_CannyEdgeDetector")
				.finish()
		}
	}

	ptr_extern! { crate::cudaimgproc::CUDA_CornernessCriteria,
		cv_PtrLcv_cuda_CornernessCriteriaG_new_null_const, cv_PtrLcv_cuda_CornernessCriteriaG_delete, cv_PtrLcv_cuda_CornernessCriteriaG_getInnerPtr_const, cv_PtrLcv_cuda_CornernessCriteriaG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_CornernessCriteria> {
		#[inline] pub fn as_raw_PtrOfCUDA_CornernessCriteria(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_CornernessCriteria(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_CornernessCriteriaTraitConst for core::Ptr<crate::cudaimgproc::CUDA_CornernessCriteria> {
		#[inline] fn as_raw_CUDA_CornernessCriteria(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_CornernessCriteriaTrait for core::Ptr<crate::cudaimgproc::CUDA_CornernessCriteria> {
		#[inline] fn as_raw_mut_CUDA_CornernessCriteria(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_CornernessCriteria> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_CornernessCriteria> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_CornernessCriteria>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_CornernessCriteriaG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_CornernessCriteria> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_CornernessCriteria")
				.finish()
		}
	}

	ptr_extern! { crate::cudaimgproc::CUDA_CornersDetector,
		cv_PtrLcv_cuda_CornersDetectorG_new_null_const, cv_PtrLcv_cuda_CornersDetectorG_delete, cv_PtrLcv_cuda_CornersDetectorG_getInnerPtr_const, cv_PtrLcv_cuda_CornersDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_CornersDetector> {
		#[inline] pub fn as_raw_PtrOfCUDA_CornersDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_CornersDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_CornersDetectorTraitConst for core::Ptr<crate::cudaimgproc::CUDA_CornersDetector> {
		#[inline] fn as_raw_CUDA_CornersDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_CornersDetectorTrait for core::Ptr<crate::cudaimgproc::CUDA_CornersDetector> {
		#[inline] fn as_raw_mut_CUDA_CornersDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_CornersDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_CornersDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_CornersDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_CornersDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_CornersDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_CornersDetector")
				.finish()
		}
	}

	ptr_extern! { crate::cudaimgproc::CUDA_HoughCirclesDetector,
		cv_PtrLcv_cuda_HoughCirclesDetectorG_new_null_const, cv_PtrLcv_cuda_HoughCirclesDetectorG_delete, cv_PtrLcv_cuda_HoughCirclesDetectorG_getInnerPtr_const, cv_PtrLcv_cuda_HoughCirclesDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_HoughCirclesDetector> {
		#[inline] pub fn as_raw_PtrOfCUDA_HoughCirclesDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_HoughCirclesDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_HoughCirclesDetectorTraitConst for core::Ptr<crate::cudaimgproc::CUDA_HoughCirclesDetector> {
		#[inline] fn as_raw_CUDA_HoughCirclesDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_HoughCirclesDetectorTrait for core::Ptr<crate::cudaimgproc::CUDA_HoughCirclesDetector> {
		#[inline] fn as_raw_mut_CUDA_HoughCirclesDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_HoughCirclesDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_HoughCirclesDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_HoughCirclesDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_HoughCirclesDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_HoughCirclesDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_HoughCirclesDetector")
				.finish()
		}
	}

	ptr_extern! { crate::cudaimgproc::CUDA_HoughLinesDetector,
		cv_PtrLcv_cuda_HoughLinesDetectorG_new_null_const, cv_PtrLcv_cuda_HoughLinesDetectorG_delete, cv_PtrLcv_cuda_HoughLinesDetectorG_getInnerPtr_const, cv_PtrLcv_cuda_HoughLinesDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_HoughLinesDetector> {
		#[inline] pub fn as_raw_PtrOfCUDA_HoughLinesDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_HoughLinesDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_HoughLinesDetectorTraitConst for core::Ptr<crate::cudaimgproc::CUDA_HoughLinesDetector> {
		#[inline] fn as_raw_CUDA_HoughLinesDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_HoughLinesDetectorTrait for core::Ptr<crate::cudaimgproc::CUDA_HoughLinesDetector> {
		#[inline] fn as_raw_mut_CUDA_HoughLinesDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_HoughLinesDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_HoughLinesDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_HoughLinesDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_HoughLinesDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_HoughLinesDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_HoughLinesDetector")
				.finish()
		}
	}

	ptr_extern! { crate::cudaimgproc::CUDA_HoughSegmentDetector,
		cv_PtrLcv_cuda_HoughSegmentDetectorG_new_null_const, cv_PtrLcv_cuda_HoughSegmentDetectorG_delete, cv_PtrLcv_cuda_HoughSegmentDetectorG_getInnerPtr_const, cv_PtrLcv_cuda_HoughSegmentDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_HoughSegmentDetector> {
		#[inline] pub fn as_raw_PtrOfCUDA_HoughSegmentDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_HoughSegmentDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_HoughSegmentDetectorTraitConst for core::Ptr<crate::cudaimgproc::CUDA_HoughSegmentDetector> {
		#[inline] fn as_raw_CUDA_HoughSegmentDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_HoughSegmentDetectorTrait for core::Ptr<crate::cudaimgproc::CUDA_HoughSegmentDetector> {
		#[inline] fn as_raw_mut_CUDA_HoughSegmentDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_HoughSegmentDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_HoughSegmentDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_HoughSegmentDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_HoughSegmentDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_HoughSegmentDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_HoughSegmentDetector")
				.finish()
		}
	}

	ptr_extern! { crate::cudaimgproc::CUDA_TemplateMatching,
		cv_PtrLcv_cuda_TemplateMatchingG_new_null_const, cv_PtrLcv_cuda_TemplateMatchingG_delete, cv_PtrLcv_cuda_TemplateMatchingG_getInnerPtr_const, cv_PtrLcv_cuda_TemplateMatchingG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaimgproc::CUDA_TemplateMatching> {
		#[inline] pub fn as_raw_PtrOfCUDA_TemplateMatching(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_TemplateMatching(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaimgproc::CUDA_TemplateMatchingTraitConst for core::Ptr<crate::cudaimgproc::CUDA_TemplateMatching> {
		#[inline] fn as_raw_CUDA_TemplateMatching(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaimgproc::CUDA_TemplateMatchingTrait for core::Ptr<crate::cudaimgproc::CUDA_TemplateMatching> {
		#[inline] fn as_raw_mut_CUDA_TemplateMatching(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaimgproc::CUDA_TemplateMatching> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaimgproc::CUDA_TemplateMatching> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaimgproc::CUDA_TemplateMatching>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_TemplateMatchingG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaimgproc::CUDA_TemplateMatching> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_TemplateMatching")
				.finish()
		}
	}

}
pub use cudaimgproc_types::*;

mod cudalegacy_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudalegacy::CUDA_BackgroundSubtractorFGD,
		cv_PtrLcv_cuda_BackgroundSubtractorFGDG_new_null_const, cv_PtrLcv_cuda_BackgroundSubtractorFGDG_delete, cv_PtrLcv_cuda_BackgroundSubtractorFGDG_getInnerPtr_const, cv_PtrLcv_cuda_BackgroundSubtractorFGDG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline] pub fn as_raw_PtrOfCUDA_BackgroundSubtractorFGD(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_BackgroundSubtractorFGD(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudalegacy::CUDA_BackgroundSubtractorFGDTraitConst for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline] fn as_raw_CUDA_BackgroundSubtractorFGD(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudalegacy::CUDA_BackgroundSubtractorFGDTrait for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline] fn as_raw_mut_CUDA_BackgroundSubtractorFGD(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_BackgroundSubtractorFGDG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_cuda_BackgroundSubtractorFGDG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorFGD> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_BackgroundSubtractorFGD")
				.finish()
		}
	}

	ptr_extern! { crate::cudalegacy::CUDA_BackgroundSubtractorGMG,
		cv_PtrLcv_cuda_BackgroundSubtractorGMGG_new_null_const, cv_PtrLcv_cuda_BackgroundSubtractorGMGG_delete, cv_PtrLcv_cuda_BackgroundSubtractorGMGG_getInnerPtr_const, cv_PtrLcv_cuda_BackgroundSubtractorGMGG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline] pub fn as_raw_PtrOfCUDA_BackgroundSubtractorGMG(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_BackgroundSubtractorGMG(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudalegacy::CUDA_BackgroundSubtractorGMGTraitConst for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline] fn as_raw_CUDA_BackgroundSubtractorGMG(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudalegacy::CUDA_BackgroundSubtractorGMGTrait for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline] fn as_raw_mut_CUDA_BackgroundSubtractorGMG(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_BackgroundSubtractorGMGG_to_PtrOfAlgorithm }

	impl crate::video::BackgroundSubtractorTraitConst for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline] fn as_raw_BackgroundSubtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::BackgroundSubtractorTrait for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline] fn as_raw_mut_BackgroundSubtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG>, core::Ptr<crate::video::BackgroundSubtractor>, cv_PtrLcv_cuda_BackgroundSubtractorGMGG_to_PtrOfBackgroundSubtractor }

	impl std::fmt::Debug for core::Ptr<crate::cudalegacy::CUDA_BackgroundSubtractorGMG> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_BackgroundSubtractorGMG")
				.finish()
		}
	}

	ptr_extern! { crate::cudalegacy::CUDA_ImagePyramid,
		cv_PtrLcv_cuda_ImagePyramidG_new_null_const, cv_PtrLcv_cuda_ImagePyramidG_delete, cv_PtrLcv_cuda_ImagePyramidG_getInnerPtr_const, cv_PtrLcv_cuda_ImagePyramidG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudalegacy::CUDA_ImagePyramid> {
		#[inline] pub fn as_raw_PtrOfCUDA_ImagePyramid(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_ImagePyramid(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudalegacy::CUDA_ImagePyramidTraitConst for core::Ptr<crate::cudalegacy::CUDA_ImagePyramid> {
		#[inline] fn as_raw_CUDA_ImagePyramid(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudalegacy::CUDA_ImagePyramidTrait for core::Ptr<crate::cudalegacy::CUDA_ImagePyramid> {
		#[inline] fn as_raw_mut_CUDA_ImagePyramid(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudalegacy::CUDA_ImagePyramid> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudalegacy::CUDA_ImagePyramid> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudalegacy::CUDA_ImagePyramid>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_ImagePyramidG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudalegacy::CUDA_ImagePyramid> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_ImagePyramid")
				.finish()
		}
	}

}
pub use cudalegacy_types::*;

mod cudaobjdetect_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudaobjdetect::CUDA_CascadeClassifier,
		cv_PtrLcv_cuda_CascadeClassifierG_new_null_const, cv_PtrLcv_cuda_CascadeClassifierG_delete, cv_PtrLcv_cuda_CascadeClassifierG_getInnerPtr_const, cv_PtrLcv_cuda_CascadeClassifierG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaobjdetect::CUDA_CascadeClassifier> {
		#[inline] pub fn as_raw_PtrOfCUDA_CascadeClassifier(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_CascadeClassifier(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaobjdetect::CUDA_CascadeClassifierTraitConst for core::Ptr<crate::cudaobjdetect::CUDA_CascadeClassifier> {
		#[inline] fn as_raw_CUDA_CascadeClassifier(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaobjdetect::CUDA_CascadeClassifierTrait for core::Ptr<crate::cudaobjdetect::CUDA_CascadeClassifier> {
		#[inline] fn as_raw_mut_CUDA_CascadeClassifier(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaobjdetect::CUDA_CascadeClassifier> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaobjdetect::CUDA_CascadeClassifier> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaobjdetect::CUDA_CascadeClassifier>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_CascadeClassifierG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaobjdetect::CUDA_CascadeClassifier> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_CascadeClassifier")
				.finish()
		}
	}

	ptr_extern! { crate::cudaobjdetect::CUDA_HOG,
		cv_PtrLcv_cuda_HOGG_new_null_const, cv_PtrLcv_cuda_HOGG_delete, cv_PtrLcv_cuda_HOGG_getInnerPtr_const, cv_PtrLcv_cuda_HOGG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaobjdetect::CUDA_HOG> {
		#[inline] pub fn as_raw_PtrOfCUDA_HOG(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_HOG(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaobjdetect::CUDA_HOGTraitConst for core::Ptr<crate::cudaobjdetect::CUDA_HOG> {
		#[inline] fn as_raw_CUDA_HOG(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaobjdetect::CUDA_HOGTrait for core::Ptr<crate::cudaobjdetect::CUDA_HOG> {
		#[inline] fn as_raw_mut_CUDA_HOG(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaobjdetect::CUDA_HOG> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaobjdetect::CUDA_HOG> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaobjdetect::CUDA_HOG>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_HOGG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaobjdetect::CUDA_HOG> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_HOG")
				.finish()
		}
	}

}
pub use cudaobjdetect_types::*;

mod cudaoptflow_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudaoptflow::CUDA_BroxOpticalFlow,
		cv_PtrLcv_cuda_BroxOpticalFlowG_new_null_const, cv_PtrLcv_cuda_BroxOpticalFlowG_delete, cv_PtrLcv_cuda_BroxOpticalFlowG_getInnerPtr_const, cv_PtrLcv_cuda_BroxOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfCUDA_BroxOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_BroxOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_BroxOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline] fn as_raw_CUDA_BroxOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_BroxOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_BroxOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_BroxOpticalFlowG_to_PtrOfAlgorithm }

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline] fn as_raw_CUDA_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow>, core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow>, cv_PtrLcv_cuda_BroxOpticalFlowG_to_PtrOfCUDA_DenseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_BroxOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_BroxOpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_DenseOpticalFlow,
		cv_PtrLcv_cuda_DenseOpticalFlowG_new_null_const, cv_PtrLcv_cuda_DenseOpticalFlowG_delete, cv_PtrLcv_cuda_DenseOpticalFlowG_getInnerPtr_const, cv_PtrLcv_cuda_DenseOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfCUDA_DenseOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_DenseOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow> {
		#[inline] fn as_raw_CUDA_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_DenseOpticalFlowG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_DenseOpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow,
		cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_new_null_const, cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_delete, cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_getInnerPtr_const, cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfCUDA_DensePyrLKOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_DensePyrLKOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_DensePyrLKOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline] fn as_raw_CUDA_DensePyrLKOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_DensePyrLKOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_DensePyrLKOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_to_PtrOfAlgorithm }

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline] fn as_raw_CUDA_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow>, core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow>, cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_to_PtrOfCUDA_DenseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_DensePyrLKOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_DensePyrLKOpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_FarnebackOpticalFlow,
		cv_PtrLcv_cuda_FarnebackOpticalFlowG_new_null_const, cv_PtrLcv_cuda_FarnebackOpticalFlowG_delete, cv_PtrLcv_cuda_FarnebackOpticalFlowG_getInnerPtr_const, cv_PtrLcv_cuda_FarnebackOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfCUDA_FarnebackOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_FarnebackOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_FarnebackOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline] fn as_raw_CUDA_FarnebackOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_FarnebackOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_FarnebackOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_FarnebackOpticalFlowG_to_PtrOfAlgorithm }

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline] fn as_raw_CUDA_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow>, core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow>, cv_PtrLcv_cuda_FarnebackOpticalFlowG_to_PtrOfCUDA_DenseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_FarnebackOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_FarnebackOpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow,
		cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_new_null_const, cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_delete, cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_getInnerPtr_const, cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfCUDA_NvidiaHWOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_NvidiaHWOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaHWOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow> {
		#[inline] fn as_raw_CUDA_NvidiaHWOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaHWOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_NvidiaHWOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_NvidiaHWOpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0,
		cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_new_null_const, cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_delete, cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_getInnerPtr_const, cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline] pub fn as_raw_PtrOfCUDA_NvidiaOpticalFlow_1_0(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_NvidiaOpticalFlow_1_0(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0TraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline] fn as_raw_CUDA_NvidiaOpticalFlow_1_0(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0Trait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline] fn as_raw_mut_CUDA_NvidiaOpticalFlow_1_0(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_to_PtrOfAlgorithm }

	impl crate::cudaoptflow::CUDA_NvidiaHWOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline] fn as_raw_CUDA_NvidiaHWOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaHWOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline] fn as_raw_mut_CUDA_NvidiaHWOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0>, core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow>, cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_to_PtrOfCUDA_NvidiaHWOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_NvidiaOpticalFlow_1_0")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0,
		cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_new_null_const, cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_delete, cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_getInnerPtr_const, cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline] pub fn as_raw_PtrOfCUDA_NvidiaOpticalFlow_2_0(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_NvidiaOpticalFlow_2_0(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0TraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline] fn as_raw_CUDA_NvidiaOpticalFlow_2_0(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0Trait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline] fn as_raw_mut_CUDA_NvidiaOpticalFlow_2_0(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_to_PtrOfAlgorithm }

	impl crate::cudaoptflow::CUDA_NvidiaHWOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline] fn as_raw_CUDA_NvidiaHWOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_NvidiaHWOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline] fn as_raw_mut_CUDA_NvidiaHWOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0>, core::Ptr<crate::cudaoptflow::CUDA_NvidiaHWOpticalFlow>, cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_to_PtrOfCUDA_NvidiaHWOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_NvidiaOpticalFlow_2_0")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1,
		cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_new_null_const, cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_delete, cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_getInnerPtr_const, cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline] pub fn as_raw_PtrOfCUDA_OpticalFlowDual_TVL1(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_OpticalFlowDual_TVL1(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1TraitConst for core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline] fn as_raw_CUDA_OpticalFlowDual_TVL1(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1Trait for core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline] fn as_raw_mut_CUDA_OpticalFlowDual_TVL1(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_to_PtrOfAlgorithm }

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline] fn as_raw_CUDA_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_DenseOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline] fn as_raw_mut_CUDA_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1>, core::Ptr<crate::cudaoptflow::CUDA_DenseOpticalFlow>, cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_to_PtrOfCUDA_DenseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_OpticalFlowDual_TVL1> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_OpticalFlowDual_TVL1")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_SparseOpticalFlow,
		cv_PtrLcv_cuda_SparseOpticalFlowG_new_null_const, cv_PtrLcv_cuda_SparseOpticalFlowG_delete, cv_PtrLcv_cuda_SparseOpticalFlowG_getInnerPtr_const, cv_PtrLcv_cuda_SparseOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfCUDA_SparseOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_SparseOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_SparseOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow> {
		#[inline] fn as_raw_CUDA_SparseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_SparseOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_SparseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_SparseOpticalFlowG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_SparseOpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow,
		cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_new_null_const, cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_delete, cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_getInnerPtr_const, cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfCUDA_SparsePyrLKOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_SparsePyrLKOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline] fn as_raw_CUDA_SparsePyrLKOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_SparsePyrLKOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_to_PtrOfAlgorithm }

	impl crate::cudaoptflow::CUDA_SparseOpticalFlowTraitConst for core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline] fn as_raw_CUDA_SparseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudaoptflow::CUDA_SparseOpticalFlowTrait for core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline] fn as_raw_mut_CUDA_SparseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow>, core::Ptr<crate::cudaoptflow::CUDA_SparseOpticalFlow>, cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_to_PtrOfCUDA_SparseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::cudaoptflow::CUDA_SparsePyrLKOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_SparsePyrLKOpticalFlow")
				.finish()
		}
	}

}
pub use cudaoptflow_types::*;

mod cudastereo_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::cudastereo::CUDA_DisparityBilateralFilter,
		cv_PtrLcv_cuda_DisparityBilateralFilterG_new_null_const, cv_PtrLcv_cuda_DisparityBilateralFilterG_delete, cv_PtrLcv_cuda_DisparityBilateralFilterG_getInnerPtr_const, cv_PtrLcv_cuda_DisparityBilateralFilterG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudastereo::CUDA_DisparityBilateralFilter> {
		#[inline] pub fn as_raw_PtrOfCUDA_DisparityBilateralFilter(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_DisparityBilateralFilter(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudastereo::CUDA_DisparityBilateralFilterTraitConst for core::Ptr<crate::cudastereo::CUDA_DisparityBilateralFilter> {
		#[inline] fn as_raw_CUDA_DisparityBilateralFilter(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudastereo::CUDA_DisparityBilateralFilterTrait for core::Ptr<crate::cudastereo::CUDA_DisparityBilateralFilter> {
		#[inline] fn as_raw_mut_CUDA_DisparityBilateralFilter(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudastereo::CUDA_DisparityBilateralFilter> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudastereo::CUDA_DisparityBilateralFilter> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_DisparityBilateralFilter>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_DisparityBilateralFilterG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::cudastereo::CUDA_DisparityBilateralFilter> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_DisparityBilateralFilter")
				.finish()
		}
	}

	ptr_extern! { crate::cudastereo::CUDA_StereoBM,
		cv_PtrLcv_cuda_StereoBMG_new_null_const, cv_PtrLcv_cuda_StereoBMG_delete, cv_PtrLcv_cuda_StereoBMG_getInnerPtr_const, cv_PtrLcv_cuda_StereoBMG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] pub fn as_raw_PtrOfCUDA_StereoBM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_StereoBM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudastereo::CUDA_StereoBMTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_CUDA_StereoBM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudastereo::CUDA_StereoBMTrait for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_mut_CUDA_StereoBM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoBM>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_StereoBMG_to_PtrOfAlgorithm }

	impl crate::calib3d::StereoBMTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_StereoBM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoBMTrait for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_mut_StereoBM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoBM>, core::Ptr<crate::calib3d::StereoBM>, cv_PtrLcv_cuda_StereoBMG_to_PtrOfStereoBM }

	impl crate::calib3d::StereoMatcherTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_StereoMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoMatcherTrait for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline] fn as_raw_mut_StereoMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoBM>, core::Ptr<crate::calib3d::StereoMatcher>, cv_PtrLcv_cuda_StereoBMG_to_PtrOfStereoMatcher }

	impl std::fmt::Debug for core::Ptr<crate::cudastereo::CUDA_StereoBM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_StereoBM")
				.finish()
		}
	}

	ptr_extern! { crate::cudastereo::CUDA_StereoBeliefPropagation,
		cv_PtrLcv_cuda_StereoBeliefPropagationG_new_null_const, cv_PtrLcv_cuda_StereoBeliefPropagationG_delete, cv_PtrLcv_cuda_StereoBeliefPropagationG_getInnerPtr_const, cv_PtrLcv_cuda_StereoBeliefPropagationG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline] pub fn as_raw_PtrOfCUDA_StereoBeliefPropagation(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_StereoBeliefPropagation(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudastereo::CUDA_StereoBeliefPropagationTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline] fn as_raw_CUDA_StereoBeliefPropagation(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudastereo::CUDA_StereoBeliefPropagationTrait for core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline] fn as_raw_mut_CUDA_StereoBeliefPropagation(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_StereoBeliefPropagationG_to_PtrOfAlgorithm }

	impl crate::calib3d::StereoMatcherTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline] fn as_raw_StereoMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoMatcherTrait for core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline] fn as_raw_mut_StereoMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation>, core::Ptr<crate::calib3d::StereoMatcher>, cv_PtrLcv_cuda_StereoBeliefPropagationG_to_PtrOfStereoMatcher }

	impl std::fmt::Debug for core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_StereoBeliefPropagation")
				.finish()
		}
	}

	ptr_extern! { crate::cudastereo::CUDA_StereoConstantSpaceBP,
		cv_PtrLcv_cuda_StereoConstantSpaceBPG_new_null_const, cv_PtrLcv_cuda_StereoConstantSpaceBPG_delete, cv_PtrLcv_cuda_StereoConstantSpaceBPG_getInnerPtr_const, cv_PtrLcv_cuda_StereoConstantSpaceBPG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] pub fn as_raw_PtrOfCUDA_StereoConstantSpaceBP(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_StereoConstantSpaceBP(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudastereo::CUDA_StereoConstantSpaceBPTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_CUDA_StereoConstantSpaceBP(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudastereo::CUDA_StereoConstantSpaceBPTrait for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_mut_CUDA_StereoConstantSpaceBP(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_StereoConstantSpaceBPG_to_PtrOfAlgorithm }

	impl crate::calib3d::StereoMatcherTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_StereoMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoMatcherTrait for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_mut_StereoMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP>, core::Ptr<crate::calib3d::StereoMatcher>, cv_PtrLcv_cuda_StereoConstantSpaceBPG_to_PtrOfStereoMatcher }

	impl crate::cudastereo::CUDA_StereoBeliefPropagationTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_CUDA_StereoBeliefPropagation(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudastereo::CUDA_StereoBeliefPropagationTrait for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline] fn as_raw_mut_CUDA_StereoBeliefPropagation(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP>, core::Ptr<crate::cudastereo::CUDA_StereoBeliefPropagation>, cv_PtrLcv_cuda_StereoConstantSpaceBPG_to_PtrOfCUDA_StereoBeliefPropagation }

	impl std::fmt::Debug for core::Ptr<crate::cudastereo::CUDA_StereoConstantSpaceBP> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_StereoConstantSpaceBP")
				.finish()
		}
	}

	ptr_extern! { crate::cudastereo::CUDA_StereoSGM,
		cv_PtrLcv_cuda_StereoSGMG_new_null_const, cv_PtrLcv_cuda_StereoSGMG_delete, cv_PtrLcv_cuda_StereoSGMG_getInnerPtr_const, cv_PtrLcv_cuda_StereoSGMG_getInnerPtrMut
	}

	impl core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] pub fn as_raw_PtrOfCUDA_StereoSGM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCUDA_StereoSGM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::cudastereo::CUDA_StereoSGMTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_CUDA_StereoSGM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::cudastereo::CUDA_StereoSGMTrait for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_mut_CUDA_StereoSGM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoSGM>, core::Ptr<core::Algorithm>, cv_PtrLcv_cuda_StereoSGMG_to_PtrOfAlgorithm }

	impl crate::calib3d::StereoMatcherTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_StereoMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoMatcherTrait for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_mut_StereoMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoSGM>, core::Ptr<crate::calib3d::StereoMatcher>, cv_PtrLcv_cuda_StereoSGMG_to_PtrOfStereoMatcher }

	impl crate::calib3d::StereoSGBMTraitConst for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_StereoSGBM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::calib3d::StereoSGBMTrait for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline] fn as_raw_mut_StereoSGBM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::cudastereo::CUDA_StereoSGM>, core::Ptr<crate::calib3d::StereoSGBM>, cv_PtrLcv_cuda_StereoSGMG_to_PtrOfStereoSGBM }

	impl std::fmt::Debug for core::Ptr<crate::cudastereo::CUDA_StereoSGM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCUDA_StereoSGM")
				.finish()
		}
	}

}
pub use cudastereo_types::*;

mod dnn_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::dnn::AbsLayer,
		cv_PtrLcv_dnn_AbsLayerG_new_null_const, cv_PtrLcv_dnn_AbsLayerG_delete, cv_PtrLcv_dnn_AbsLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AbsLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AbsLayer, cv_PtrLcv_dnn_AbsLayerG_new_const_AbsLayer }
	impl core::Ptr<crate::dnn::AbsLayer> {
		#[inline] pub fn as_raw_PtrOfAbsLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAbsLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AbsLayerTraitConst for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_AbsLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AbsLayerTrait for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_mut_AbsLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AbsLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AbsLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AbsLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_AbsLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AbsLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AbsLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AbsLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AbsLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAbsLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AccumLayer,
		cv_PtrLcv_dnn_AccumLayerG_new_null_const, cv_PtrLcv_dnn_AccumLayerG_delete, cv_PtrLcv_dnn_AccumLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AccumLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AccumLayer, cv_PtrLcv_dnn_AccumLayerG_new_const_AccumLayer }
	impl core::Ptr<crate::dnn::AccumLayer> {
		#[inline] pub fn as_raw_PtrOfAccumLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAccumLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AccumLayerTraitConst for core::Ptr<crate::dnn::AccumLayer> {
		#[inline] fn as_raw_AccumLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AccumLayerTrait for core::Ptr<crate::dnn::AccumLayer> {
		#[inline] fn as_raw_mut_AccumLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AccumLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AccumLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AccumLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AccumLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AccumLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AccumLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AccumLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AccumLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AccumLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAccumLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AcosLayer,
		cv_PtrLcv_dnn_AcosLayerG_new_null_const, cv_PtrLcv_dnn_AcosLayerG_delete, cv_PtrLcv_dnn_AcosLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AcosLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AcosLayer, cv_PtrLcv_dnn_AcosLayerG_new_const_AcosLayer }
	impl core::Ptr<crate::dnn::AcosLayer> {
		#[inline] pub fn as_raw_PtrOfAcosLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAcosLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AcosLayerTraitConst for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_AcosLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AcosLayerTrait for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_mut_AcosLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AcosLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AcosLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AcosLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_AcosLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AcosLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AcosLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AcosLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AcosLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAcosLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AcoshLayer,
		cv_PtrLcv_dnn_AcoshLayerG_new_null_const, cv_PtrLcv_dnn_AcoshLayerG_delete, cv_PtrLcv_dnn_AcoshLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AcoshLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AcoshLayer, cv_PtrLcv_dnn_AcoshLayerG_new_const_AcoshLayer }
	impl core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] pub fn as_raw_PtrOfAcoshLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAcoshLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AcoshLayerTraitConst for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_AcoshLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AcoshLayerTrait for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_mut_AcoshLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AcoshLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AcoshLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AcoshLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_AcoshLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AcoshLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AcoshLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AcoshLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAcoshLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ActivationLayer,
		cv_PtrLcv_dnn_ActivationLayerG_new_null_const, cv_PtrLcv_dnn_ActivationLayerG_delete, cv_PtrLcv_dnn_ActivationLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ActivationLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ActivationLayer, cv_PtrLcv_dnn_ActivationLayerG_new_const_ActivationLayer }
	impl core::Ptr<crate::dnn::ActivationLayer> {
		#[inline] pub fn as_raw_PtrOfActivationLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfActivationLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ActivationLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ActivationLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ActivationLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ActivationLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ActivationLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ActivationLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ActivationLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ActivationLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ActivationLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ActivationLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ActivationLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfActivationLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ActivationLayerInt8,
		cv_PtrLcv_dnn_ActivationLayerInt8G_new_null_const, cv_PtrLcv_dnn_ActivationLayerInt8G_delete, cv_PtrLcv_dnn_ActivationLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_ActivationLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ActivationLayerInt8, cv_PtrLcv_dnn_ActivationLayerInt8G_new_const_ActivationLayerInt8 }
	impl core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] pub fn as_raw_PtrOfActivationLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfActivationLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ActivationLayerInt8TraitConst for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_ActivationLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerInt8Trait for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_mut_ActivationLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ActivationLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ActivationLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ActivationLayerInt8>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ActivationLayerInt8G_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ActivationLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ActivationLayerInt8G_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ActivationLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfActivationLayerInt8")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ArgLayer,
		cv_PtrLcv_dnn_ArgLayerG_new_null_const, cv_PtrLcv_dnn_ArgLayerG_delete, cv_PtrLcv_dnn_ArgLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ArgLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ArgLayer, cv_PtrLcv_dnn_ArgLayerG_new_const_ArgLayer }
	impl core::Ptr<crate::dnn::ArgLayer> {
		#[inline] pub fn as_raw_PtrOfArgLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfArgLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ArgLayerTraitConst for core::Ptr<crate::dnn::ArgLayer> {
		#[inline] fn as_raw_ArgLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ArgLayerTrait for core::Ptr<crate::dnn::ArgLayer> {
		#[inline] fn as_raw_mut_ArgLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ArgLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ArgLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ArgLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ArgLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ArgLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ArgLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ArgLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ArgLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ArgLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfArgLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AsinLayer,
		cv_PtrLcv_dnn_AsinLayerG_new_null_const, cv_PtrLcv_dnn_AsinLayerG_delete, cv_PtrLcv_dnn_AsinLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AsinLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AsinLayer, cv_PtrLcv_dnn_AsinLayerG_new_const_AsinLayer }
	impl core::Ptr<crate::dnn::AsinLayer> {
		#[inline] pub fn as_raw_PtrOfAsinLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAsinLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AsinLayerTraitConst for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_AsinLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AsinLayerTrait for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_mut_AsinLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AsinLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AsinLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AsinLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_AsinLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AsinLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AsinLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AsinLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AsinLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAsinLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AsinhLayer,
		cv_PtrLcv_dnn_AsinhLayerG_new_null_const, cv_PtrLcv_dnn_AsinhLayerG_delete, cv_PtrLcv_dnn_AsinhLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AsinhLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AsinhLayer, cv_PtrLcv_dnn_AsinhLayerG_new_const_AsinhLayer }
	impl core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] pub fn as_raw_PtrOfAsinhLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAsinhLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AsinhLayerTraitConst for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_AsinhLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AsinhLayerTrait for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_mut_AsinhLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AsinhLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AsinhLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AsinhLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_AsinhLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AsinhLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AsinhLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AsinhLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAsinhLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AtanLayer,
		cv_PtrLcv_dnn_AtanLayerG_new_null_const, cv_PtrLcv_dnn_AtanLayerG_delete, cv_PtrLcv_dnn_AtanLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AtanLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AtanLayer, cv_PtrLcv_dnn_AtanLayerG_new_const_AtanLayer }
	impl core::Ptr<crate::dnn::AtanLayer> {
		#[inline] pub fn as_raw_PtrOfAtanLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAtanLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AtanLayerTraitConst for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_AtanLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AtanLayerTrait for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_mut_AtanLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AtanLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AtanLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AtanLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_AtanLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AtanLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AtanLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AtanLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AtanLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAtanLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AtanhLayer,
		cv_PtrLcv_dnn_AtanhLayerG_new_null_const, cv_PtrLcv_dnn_AtanhLayerG_delete, cv_PtrLcv_dnn_AtanhLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AtanhLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AtanhLayer, cv_PtrLcv_dnn_AtanhLayerG_new_const_AtanhLayer }
	impl core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] pub fn as_raw_PtrOfAtanhLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAtanhLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AtanhLayerTraitConst for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_AtanhLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AtanhLayerTrait for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_mut_AtanhLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AtanhLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AtanhLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AtanhLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_AtanhLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AtanhLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AtanhLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AtanhLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAtanhLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::AttentionLayer,
		cv_PtrLcv_dnn_AttentionLayerG_new_null_const, cv_PtrLcv_dnn_AttentionLayerG_delete, cv_PtrLcv_dnn_AttentionLayerG_getInnerPtr_const, cv_PtrLcv_dnn_AttentionLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::AttentionLayer, cv_PtrLcv_dnn_AttentionLayerG_new_const_AttentionLayer }
	impl core::Ptr<crate::dnn::AttentionLayer> {
		#[inline] pub fn as_raw_PtrOfAttentionLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAttentionLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::AttentionLayerTraitConst for core::Ptr<crate::dnn::AttentionLayer> {
		#[inline] fn as_raw_AttentionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::AttentionLayerTrait for core::Ptr<crate::dnn::AttentionLayer> {
		#[inline] fn as_raw_mut_AttentionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::AttentionLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::AttentionLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AttentionLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_AttentionLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::AttentionLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::AttentionLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::AttentionLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_AttentionLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::AttentionLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAttentionLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::BNLLLayer,
		cv_PtrLcv_dnn_BNLLLayerG_new_null_const, cv_PtrLcv_dnn_BNLLLayerG_delete, cv_PtrLcv_dnn_BNLLLayerG_getInnerPtr_const, cv_PtrLcv_dnn_BNLLLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::BNLLLayer, cv_PtrLcv_dnn_BNLLLayerG_new_const_BNLLLayer }
	impl core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] pub fn as_raw_PtrOfBNLLLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBNLLLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::BNLLLayerTraitConst for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_BNLLLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BNLLLayerTrait for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_mut_BNLLLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BNLLLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_BNLLLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BNLLLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_BNLLLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BNLLLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_BNLLLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::BNLLLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBNLLLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::BackendNode,
		cv_PtrLcv_dnn_BackendNodeG_new_null_const, cv_PtrLcv_dnn_BackendNodeG_delete, cv_PtrLcv_dnn_BackendNodeG_getInnerPtr_const, cv_PtrLcv_dnn_BackendNodeG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::BackendNode, cv_PtrLcv_dnn_BackendNodeG_new_const_BackendNode }
	impl core::Ptr<crate::dnn::BackendNode> {
		#[inline] pub fn as_raw_PtrOfBackendNode(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBackendNode(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::BackendNodeTraitConst for core::Ptr<crate::dnn::BackendNode> {
		#[inline] fn as_raw_BackendNode(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BackendNodeTrait for core::Ptr<crate::dnn::BackendNode> {
		#[inline] fn as_raw_mut_BackendNode(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::dnn::BackendNode> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBackendNode")
				.field("backend_id", &crate::dnn::BackendNodeTraitConst::backend_id(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::BackendWrapper,
		cv_PtrLcv_dnn_BackendWrapperG_new_null_const, cv_PtrLcv_dnn_BackendWrapperG_delete, cv_PtrLcv_dnn_BackendWrapperG_getInnerPtr_const, cv_PtrLcv_dnn_BackendWrapperG_getInnerPtrMut
	}

	impl core::Ptr<crate::dnn::BackendWrapper> {
		#[inline] pub fn as_raw_PtrOfBackendWrapper(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBackendWrapper(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::BackendWrapperTraitConst for core::Ptr<crate::dnn::BackendWrapper> {
		#[inline] fn as_raw_BackendWrapper(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BackendWrapperTrait for core::Ptr<crate::dnn::BackendWrapper> {
		#[inline] fn as_raw_mut_BackendWrapper(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::dnn::BackendWrapper> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBackendWrapper")
				.field("backend_id", &crate::dnn::BackendWrapperTraitConst::backend_id(self))
				.field("target_id", &crate::dnn::BackendWrapperTraitConst::target_id(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::BaseConvolutionLayer,
		cv_PtrLcv_dnn_BaseConvolutionLayerG_new_null_const, cv_PtrLcv_dnn_BaseConvolutionLayerG_delete, cv_PtrLcv_dnn_BaseConvolutionLayerG_getInnerPtr_const, cv_PtrLcv_dnn_BaseConvolutionLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::BaseConvolutionLayer, cv_PtrLcv_dnn_BaseConvolutionLayerG_new_const_BaseConvolutionLayer }
	impl core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline] pub fn as_raw_PtrOfBaseConvolutionLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBaseConvolutionLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::BaseConvolutionLayerTraitConst for core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline] fn as_raw_BaseConvolutionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BaseConvolutionLayerTrait for core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline] fn as_raw_mut_BaseConvolutionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BaseConvolutionLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_BaseConvolutionLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BaseConvolutionLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_BaseConvolutionLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::BaseConvolutionLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBaseConvolutionLayer")
				.field("kernel", &crate::dnn::BaseConvolutionLayerTraitConst::kernel(self))
				.field("stride", &crate::dnn::BaseConvolutionLayerTraitConst::stride(self))
				.field("pad", &crate::dnn::BaseConvolutionLayerTraitConst::pad(self))
				.field("dilation", &crate::dnn::BaseConvolutionLayerTraitConst::dilation(self))
				.field("adjust_pad", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pad(self))
				.field("adjust_pads", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pads(self))
				.field("kernel_size", &crate::dnn::BaseConvolutionLayerTraitConst::kernel_size(self))
				.field("strides", &crate::dnn::BaseConvolutionLayerTraitConst::strides(self))
				.field("dilations", &crate::dnn::BaseConvolutionLayerTraitConst::dilations(self))
				.field("pads_begin", &crate::dnn::BaseConvolutionLayerTraitConst::pads_begin(self))
				.field("pads_end", &crate::dnn::BaseConvolutionLayerTraitConst::pads_end(self))
				.field("pad_mode", &crate::dnn::BaseConvolutionLayerTraitConst::pad_mode(self))
				.field("num_output", &crate::dnn::BaseConvolutionLayerTraitConst::num_output(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::BatchNormLayer,
		cv_PtrLcv_dnn_BatchNormLayerG_new_null_const, cv_PtrLcv_dnn_BatchNormLayerG_delete, cv_PtrLcv_dnn_BatchNormLayerG_getInnerPtr_const, cv_PtrLcv_dnn_BatchNormLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::BatchNormLayer, cv_PtrLcv_dnn_BatchNormLayerG_new_const_BatchNormLayer }
	impl core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] pub fn as_raw_PtrOfBatchNormLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBatchNormLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::BatchNormLayerTraitConst for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_BatchNormLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BatchNormLayerTrait for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_mut_BatchNormLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BatchNormLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_BatchNormLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BatchNormLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_BatchNormLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BatchNormLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_BatchNormLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::BatchNormLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBatchNormLayer")
				.field("has_weights", &crate::dnn::BatchNormLayerTraitConst::has_weights(self))
				.field("has_bias", &crate::dnn::BatchNormLayerTraitConst::has_bias(self))
				.field("epsilon", &crate::dnn::BatchNormLayerTraitConst::epsilon(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::BatchNormLayerInt8,
		cv_PtrLcv_dnn_BatchNormLayerInt8G_new_null_const, cv_PtrLcv_dnn_BatchNormLayerInt8G_delete, cv_PtrLcv_dnn_BatchNormLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_BatchNormLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::BatchNormLayerInt8, cv_PtrLcv_dnn_BatchNormLayerInt8G_new_const_BatchNormLayerInt8 }
	impl core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] pub fn as_raw_PtrOfBatchNormLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBatchNormLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::BatchNormLayerInt8TraitConst for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_BatchNormLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BatchNormLayerInt8Trait for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_mut_BatchNormLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BatchNormLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BatchNormLayerInt8>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfActivationLayer }

	impl crate::dnn::BatchNormLayerTraitConst for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_BatchNormLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BatchNormLayerTrait for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_mut_BatchNormLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BatchNormLayerInt8>, core::Ptr<crate::dnn::BatchNormLayer>, cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfBatchNormLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BatchNormLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::BatchNormLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBatchNormLayerInt8")
				.field("input_sc", &crate::dnn::BatchNormLayerInt8TraitConst::input_sc(self))
				.field("output_sc", &crate::dnn::BatchNormLayerInt8TraitConst::output_sc(self))
				.field("input_zp", &crate::dnn::BatchNormLayerInt8TraitConst::input_zp(self))
				.field("output_zp", &crate::dnn::BatchNormLayerInt8TraitConst::output_zp(self))
				.field("has_weights", &crate::dnn::BatchNormLayerTraitConst::has_weights(self))
				.field("has_bias", &crate::dnn::BatchNormLayerTraitConst::has_bias(self))
				.field("epsilon", &crate::dnn::BatchNormLayerTraitConst::epsilon(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::BlankLayer,
		cv_PtrLcv_dnn_BlankLayerG_new_null_const, cv_PtrLcv_dnn_BlankLayerG_delete, cv_PtrLcv_dnn_BlankLayerG_getInnerPtr_const, cv_PtrLcv_dnn_BlankLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::BlankLayer, cv_PtrLcv_dnn_BlankLayerG_new_const_BlankLayer }
	impl core::Ptr<crate::dnn::BlankLayer> {
		#[inline] pub fn as_raw_PtrOfBlankLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBlankLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::BlankLayerTraitConst for core::Ptr<crate::dnn::BlankLayer> {
		#[inline] fn as_raw_BlankLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BlankLayerTrait for core::Ptr<crate::dnn::BlankLayer> {
		#[inline] fn as_raw_mut_BlankLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::BlankLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::BlankLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BlankLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_BlankLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::BlankLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::BlankLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::BlankLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_BlankLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::BlankLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBlankLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CeilLayer,
		cv_PtrLcv_dnn_CeilLayerG_new_null_const, cv_PtrLcv_dnn_CeilLayerG_delete, cv_PtrLcv_dnn_CeilLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CeilLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CeilLayer, cv_PtrLcv_dnn_CeilLayerG_new_const_CeilLayer }
	impl core::Ptr<crate::dnn::CeilLayer> {
		#[inline] pub fn as_raw_PtrOfCeilLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCeilLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CeilLayerTraitConst for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_CeilLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CeilLayerTrait for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_mut_CeilLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CeilLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CeilLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CeilLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_CeilLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CeilLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CeilLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CeilLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CeilLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCeilLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CeluLayer,
		cv_PtrLcv_dnn_CeluLayerG_new_null_const, cv_PtrLcv_dnn_CeluLayerG_delete, cv_PtrLcv_dnn_CeluLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CeluLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CeluLayer, cv_PtrLcv_dnn_CeluLayerG_new_const_CeluLayer }
	impl core::Ptr<crate::dnn::CeluLayer> {
		#[inline] pub fn as_raw_PtrOfCeluLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCeluLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CeluLayerTraitConst for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_CeluLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CeluLayerTrait for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_mut_CeluLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CeluLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CeluLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CeluLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_CeluLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CeluLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CeluLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CeluLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CeluLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCeluLayer")
				.field("alpha", &crate::dnn::CeluLayerTraitConst::alpha(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ChannelsPReLULayer,
		cv_PtrLcv_dnn_ChannelsPReLULayerG_new_null_const, cv_PtrLcv_dnn_ChannelsPReLULayerG_delete, cv_PtrLcv_dnn_ChannelsPReLULayerG_getInnerPtr_const, cv_PtrLcv_dnn_ChannelsPReLULayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ChannelsPReLULayer, cv_PtrLcv_dnn_ChannelsPReLULayerG_new_const_ChannelsPReLULayer }
	impl core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] pub fn as_raw_PtrOfChannelsPReLULayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfChannelsPReLULayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ChannelsPReLULayerTraitConst for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_ChannelsPReLULayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ChannelsPReLULayerTrait for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_mut_ChannelsPReLULayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ChannelsPReLULayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ChannelsPReLULayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ChannelsPReLULayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ChannelsPReLULayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ChannelsPReLULayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ChannelsPReLULayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ChannelsPReLULayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfChannelsPReLULayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CompareLayer,
		cv_PtrLcv_dnn_CompareLayerG_new_null_const, cv_PtrLcv_dnn_CompareLayerG_delete, cv_PtrLcv_dnn_CompareLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CompareLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CompareLayer, cv_PtrLcv_dnn_CompareLayerG_new_const_CompareLayer }
	impl core::Ptr<crate::dnn::CompareLayer> {
		#[inline] pub fn as_raw_PtrOfCompareLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCompareLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CompareLayerTraitConst for core::Ptr<crate::dnn::CompareLayer> {
		#[inline] fn as_raw_CompareLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CompareLayerTrait for core::Ptr<crate::dnn::CompareLayer> {
		#[inline] fn as_raw_mut_CompareLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CompareLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CompareLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CompareLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CompareLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CompareLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CompareLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CompareLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CompareLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CompareLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCompareLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ConcatLayer,
		cv_PtrLcv_dnn_ConcatLayerG_new_null_const, cv_PtrLcv_dnn_ConcatLayerG_delete, cv_PtrLcv_dnn_ConcatLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ConcatLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ConcatLayer, cv_PtrLcv_dnn_ConcatLayerG_new_const_ConcatLayer }
	impl core::Ptr<crate::dnn::ConcatLayer> {
		#[inline] pub fn as_raw_PtrOfConcatLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfConcatLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ConcatLayerTraitConst for core::Ptr<crate::dnn::ConcatLayer> {
		#[inline] fn as_raw_ConcatLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ConcatLayerTrait for core::Ptr<crate::dnn::ConcatLayer> {
		#[inline] fn as_raw_mut_ConcatLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ConcatLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ConcatLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConcatLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ConcatLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ConcatLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ConcatLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConcatLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ConcatLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ConcatLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfConcatLayer")
				.field("axis", &crate::dnn::ConcatLayerTraitConst::axis(self))
				.field("padding", &crate::dnn::ConcatLayerTraitConst::padding(self))
				.field("padding_value", &crate::dnn::ConcatLayerTraitConst::padding_value(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ConstLayer,
		cv_PtrLcv_dnn_ConstLayerG_new_null_const, cv_PtrLcv_dnn_ConstLayerG_delete, cv_PtrLcv_dnn_ConstLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ConstLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ConstLayer, cv_PtrLcv_dnn_ConstLayerG_new_const_ConstLayer }
	impl core::Ptr<crate::dnn::ConstLayer> {
		#[inline] pub fn as_raw_PtrOfConstLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfConstLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ConstLayerTraitConst for core::Ptr<crate::dnn::ConstLayer> {
		#[inline] fn as_raw_ConstLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ConstLayerTrait for core::Ptr<crate::dnn::ConstLayer> {
		#[inline] fn as_raw_mut_ConstLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ConstLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ConstLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConstLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ConstLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ConstLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ConstLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConstLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ConstLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ConstLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfConstLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ConvolutionLayer,
		cv_PtrLcv_dnn_ConvolutionLayerG_new_null_const, cv_PtrLcv_dnn_ConvolutionLayerG_delete, cv_PtrLcv_dnn_ConvolutionLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ConvolutionLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ConvolutionLayer, cv_PtrLcv_dnn_ConvolutionLayerG_new_const_ConvolutionLayer }
	impl core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] pub fn as_raw_PtrOfConvolutionLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfConvolutionLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ConvolutionLayerTraitConst for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_ConvolutionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ConvolutionLayerTrait for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_mut_ConvolutionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConvolutionLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ConvolutionLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::BaseConvolutionLayerTraitConst for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_BaseConvolutionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BaseConvolutionLayerTrait for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_mut_BaseConvolutionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConvolutionLayer>, core::Ptr<crate::dnn::BaseConvolutionLayer>, cv_PtrLcv_dnn_ConvolutionLayerG_to_PtrOfBaseConvolutionLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConvolutionLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ConvolutionLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ConvolutionLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfConvolutionLayer")
				.field("fused_activation", &crate::dnn::ConvolutionLayerTraitConst::fused_activation(self))
				.field("fused_add", &crate::dnn::ConvolutionLayerTraitConst::fused_add(self))
				.field("use_winograd", &crate::dnn::ConvolutionLayerTraitConst::use_winograd(self))
				.field("kernel", &crate::dnn::BaseConvolutionLayerTraitConst::kernel(self))
				.field("stride", &crate::dnn::BaseConvolutionLayerTraitConst::stride(self))
				.field("pad", &crate::dnn::BaseConvolutionLayerTraitConst::pad(self))
				.field("dilation", &crate::dnn::BaseConvolutionLayerTraitConst::dilation(self))
				.field("adjust_pad", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pad(self))
				.field("adjust_pads", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pads(self))
				.field("kernel_size", &crate::dnn::BaseConvolutionLayerTraitConst::kernel_size(self))
				.field("strides", &crate::dnn::BaseConvolutionLayerTraitConst::strides(self))
				.field("dilations", &crate::dnn::BaseConvolutionLayerTraitConst::dilations(self))
				.field("pads_begin", &crate::dnn::BaseConvolutionLayerTraitConst::pads_begin(self))
				.field("pads_end", &crate::dnn::BaseConvolutionLayerTraitConst::pads_end(self))
				.field("pad_mode", &crate::dnn::BaseConvolutionLayerTraitConst::pad_mode(self))
				.field("num_output", &crate::dnn::BaseConvolutionLayerTraitConst::num_output(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ConvolutionLayerInt8,
		cv_PtrLcv_dnn_ConvolutionLayerInt8G_new_null_const, cv_PtrLcv_dnn_ConvolutionLayerInt8G_delete, cv_PtrLcv_dnn_ConvolutionLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_ConvolutionLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ConvolutionLayerInt8, cv_PtrLcv_dnn_ConvolutionLayerInt8G_new_const_ConvolutionLayerInt8 }
	impl core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] pub fn as_raw_PtrOfConvolutionLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfConvolutionLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ConvolutionLayerInt8TraitConst for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_ConvolutionLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ConvolutionLayerInt8Trait for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_mut_ConvolutionLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConvolutionLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ConvolutionLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::BaseConvolutionLayerTraitConst for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_BaseConvolutionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BaseConvolutionLayerTrait for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_mut_BaseConvolutionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConvolutionLayerInt8>, core::Ptr<crate::dnn::BaseConvolutionLayer>, cv_PtrLcv_dnn_ConvolutionLayerInt8G_to_PtrOfBaseConvolutionLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ConvolutionLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ConvolutionLayerInt8G_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ConvolutionLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfConvolutionLayerInt8")
				.field("input_zp", &crate::dnn::ConvolutionLayerInt8TraitConst::input_zp(self))
				.field("output_zp", &crate::dnn::ConvolutionLayerInt8TraitConst::output_zp(self))
				.field("input_sc", &crate::dnn::ConvolutionLayerInt8TraitConst::input_sc(self))
				.field("output_sc", &crate::dnn::ConvolutionLayerInt8TraitConst::output_sc(self))
				.field("per_channel", &crate::dnn::ConvolutionLayerInt8TraitConst::per_channel(self))
				.field("use_winograd", &crate::dnn::ConvolutionLayerInt8TraitConst::use_winograd(self))
				.field("kernel", &crate::dnn::BaseConvolutionLayerTraitConst::kernel(self))
				.field("stride", &crate::dnn::BaseConvolutionLayerTraitConst::stride(self))
				.field("pad", &crate::dnn::BaseConvolutionLayerTraitConst::pad(self))
				.field("dilation", &crate::dnn::BaseConvolutionLayerTraitConst::dilation(self))
				.field("adjust_pad", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pad(self))
				.field("adjust_pads", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pads(self))
				.field("kernel_size", &crate::dnn::BaseConvolutionLayerTraitConst::kernel_size(self))
				.field("strides", &crate::dnn::BaseConvolutionLayerTraitConst::strides(self))
				.field("dilations", &crate::dnn::BaseConvolutionLayerTraitConst::dilations(self))
				.field("pads_begin", &crate::dnn::BaseConvolutionLayerTraitConst::pads_begin(self))
				.field("pads_end", &crate::dnn::BaseConvolutionLayerTraitConst::pads_end(self))
				.field("pad_mode", &crate::dnn::BaseConvolutionLayerTraitConst::pad_mode(self))
				.field("num_output", &crate::dnn::BaseConvolutionLayerTraitConst::num_output(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CorrelationLayer,
		cv_PtrLcv_dnn_CorrelationLayerG_new_null_const, cv_PtrLcv_dnn_CorrelationLayerG_delete, cv_PtrLcv_dnn_CorrelationLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CorrelationLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CorrelationLayer, cv_PtrLcv_dnn_CorrelationLayerG_new_const_CorrelationLayer }
	impl core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline] pub fn as_raw_PtrOfCorrelationLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCorrelationLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CorrelationLayerTraitConst for core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline] fn as_raw_CorrelationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CorrelationLayerTrait for core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline] fn as_raw_mut_CorrelationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CorrelationLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CorrelationLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CorrelationLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CorrelationLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CorrelationLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCorrelationLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CosLayer,
		cv_PtrLcv_dnn_CosLayerG_new_null_const, cv_PtrLcv_dnn_CosLayerG_delete, cv_PtrLcv_dnn_CosLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CosLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CosLayer, cv_PtrLcv_dnn_CosLayerG_new_const_CosLayer }
	impl core::Ptr<crate::dnn::CosLayer> {
		#[inline] pub fn as_raw_PtrOfCosLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCosLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CosLayerTraitConst for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_CosLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CosLayerTrait for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_mut_CosLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CosLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CosLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CosLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_CosLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CosLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CosLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CosLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CosLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCosLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CoshLayer,
		cv_PtrLcv_dnn_CoshLayerG_new_null_const, cv_PtrLcv_dnn_CoshLayerG_delete, cv_PtrLcv_dnn_CoshLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CoshLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CoshLayer, cv_PtrLcv_dnn_CoshLayerG_new_const_CoshLayer }
	impl core::Ptr<crate::dnn::CoshLayer> {
		#[inline] pub fn as_raw_PtrOfCoshLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCoshLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CoshLayerTraitConst for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_CoshLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CoshLayerTrait for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_mut_CoshLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CoshLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CoshLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CoshLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_CoshLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CoshLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CoshLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CoshLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CoshLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCoshLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CropAndResizeLayer,
		cv_PtrLcv_dnn_CropAndResizeLayerG_new_null_const, cv_PtrLcv_dnn_CropAndResizeLayerG_delete, cv_PtrLcv_dnn_CropAndResizeLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CropAndResizeLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CropAndResizeLayer, cv_PtrLcv_dnn_CropAndResizeLayerG_new_const_CropAndResizeLayer }
	impl core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline] pub fn as_raw_PtrOfCropAndResizeLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCropAndResizeLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CropAndResizeLayerTraitConst for core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline] fn as_raw_CropAndResizeLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CropAndResizeLayerTrait for core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline] fn as_raw_mut_CropAndResizeLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CropAndResizeLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CropAndResizeLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CropAndResizeLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CropAndResizeLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CropAndResizeLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCropAndResizeLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CropLayer,
		cv_PtrLcv_dnn_CropLayerG_new_null_const, cv_PtrLcv_dnn_CropLayerG_delete, cv_PtrLcv_dnn_CropLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CropLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CropLayer, cv_PtrLcv_dnn_CropLayerG_new_const_CropLayer }
	impl core::Ptr<crate::dnn::CropLayer> {
		#[inline] pub fn as_raw_PtrOfCropLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCropLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CropLayerTraitConst for core::Ptr<crate::dnn::CropLayer> {
		#[inline] fn as_raw_CropLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CropLayerTrait for core::Ptr<crate::dnn::CropLayer> {
		#[inline] fn as_raw_mut_CropLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CropLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CropLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CropLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CropLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CropLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CropLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CropLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CropLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CropLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCropLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::CumSumLayer,
		cv_PtrLcv_dnn_CumSumLayerG_new_null_const, cv_PtrLcv_dnn_CumSumLayerG_delete, cv_PtrLcv_dnn_CumSumLayerG_getInnerPtr_const, cv_PtrLcv_dnn_CumSumLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::CumSumLayer, cv_PtrLcv_dnn_CumSumLayerG_new_const_CumSumLayer }
	impl core::Ptr<crate::dnn::CumSumLayer> {
		#[inline] pub fn as_raw_PtrOfCumSumLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCumSumLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::CumSumLayerTraitConst for core::Ptr<crate::dnn::CumSumLayer> {
		#[inline] fn as_raw_CumSumLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::CumSumLayerTrait for core::Ptr<crate::dnn::CumSumLayer> {
		#[inline] fn as_raw_mut_CumSumLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::CumSumLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::CumSumLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CumSumLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_CumSumLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::CumSumLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::CumSumLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::CumSumLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_CumSumLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::CumSumLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCumSumLayer")
				.field("exclusive", &crate::dnn::CumSumLayerTraitConst::exclusive(self))
				.field("reverse", &crate::dnn::CumSumLayerTraitConst::reverse(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::DataAugmentationLayer,
		cv_PtrLcv_dnn_DataAugmentationLayerG_new_null_const, cv_PtrLcv_dnn_DataAugmentationLayerG_delete, cv_PtrLcv_dnn_DataAugmentationLayerG_getInnerPtr_const, cv_PtrLcv_dnn_DataAugmentationLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::DataAugmentationLayer, cv_PtrLcv_dnn_DataAugmentationLayerG_new_const_DataAugmentationLayer }
	impl core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline] pub fn as_raw_PtrOfDataAugmentationLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDataAugmentationLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::DataAugmentationLayerTraitConst for core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline] fn as_raw_DataAugmentationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::DataAugmentationLayerTrait for core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline] fn as_raw_mut_DataAugmentationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DataAugmentationLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_DataAugmentationLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DataAugmentationLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_DataAugmentationLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::DataAugmentationLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDataAugmentationLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::DeconvolutionLayer,
		cv_PtrLcv_dnn_DeconvolutionLayerG_new_null_const, cv_PtrLcv_dnn_DeconvolutionLayerG_delete, cv_PtrLcv_dnn_DeconvolutionLayerG_getInnerPtr_const, cv_PtrLcv_dnn_DeconvolutionLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::DeconvolutionLayer, cv_PtrLcv_dnn_DeconvolutionLayerG_new_const_DeconvolutionLayer }
	impl core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] pub fn as_raw_PtrOfDeconvolutionLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDeconvolutionLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::DeconvolutionLayerTraitConst for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_DeconvolutionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::DeconvolutionLayerTrait for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_mut_DeconvolutionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DeconvolutionLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_DeconvolutionLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::BaseConvolutionLayerTraitConst for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_BaseConvolutionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::BaseConvolutionLayerTrait for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_mut_BaseConvolutionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DeconvolutionLayer>, core::Ptr<crate::dnn::BaseConvolutionLayer>, cv_PtrLcv_dnn_DeconvolutionLayerG_to_PtrOfBaseConvolutionLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DeconvolutionLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_DeconvolutionLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::DeconvolutionLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDeconvolutionLayer")
				.field("kernel", &crate::dnn::BaseConvolutionLayerTraitConst::kernel(self))
				.field("stride", &crate::dnn::BaseConvolutionLayerTraitConst::stride(self))
				.field("pad", &crate::dnn::BaseConvolutionLayerTraitConst::pad(self))
				.field("dilation", &crate::dnn::BaseConvolutionLayerTraitConst::dilation(self))
				.field("adjust_pad", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pad(self))
				.field("adjust_pads", &crate::dnn::BaseConvolutionLayerTraitConst::adjust_pads(self))
				.field("kernel_size", &crate::dnn::BaseConvolutionLayerTraitConst::kernel_size(self))
				.field("strides", &crate::dnn::BaseConvolutionLayerTraitConst::strides(self))
				.field("dilations", &crate::dnn::BaseConvolutionLayerTraitConst::dilations(self))
				.field("pads_begin", &crate::dnn::BaseConvolutionLayerTraitConst::pads_begin(self))
				.field("pads_end", &crate::dnn::BaseConvolutionLayerTraitConst::pads_end(self))
				.field("pad_mode", &crate::dnn::BaseConvolutionLayerTraitConst::pad_mode(self))
				.field("num_output", &crate::dnn::BaseConvolutionLayerTraitConst::num_output(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::DepthToSpaceLayer,
		cv_PtrLcv_dnn_DepthToSpaceLayerG_new_null_const, cv_PtrLcv_dnn_DepthToSpaceLayerG_delete, cv_PtrLcv_dnn_DepthToSpaceLayerG_getInnerPtr_const, cv_PtrLcv_dnn_DepthToSpaceLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::DepthToSpaceLayer, cv_PtrLcv_dnn_DepthToSpaceLayerG_new_const_DepthToSpaceLayer }
	impl core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline] pub fn as_raw_PtrOfDepthToSpaceLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDepthToSpaceLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::DepthToSpaceLayerTraitConst for core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline] fn as_raw_DepthToSpaceLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::DepthToSpaceLayerTrait for core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline] fn as_raw_mut_DepthToSpaceLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DepthToSpaceLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_DepthToSpaceLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DepthToSpaceLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_DepthToSpaceLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::DepthToSpaceLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDepthToSpaceLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::DequantizeLayer,
		cv_PtrLcv_dnn_DequantizeLayerG_new_null_const, cv_PtrLcv_dnn_DequantizeLayerG_delete, cv_PtrLcv_dnn_DequantizeLayerG_getInnerPtr_const, cv_PtrLcv_dnn_DequantizeLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::DequantizeLayer, cv_PtrLcv_dnn_DequantizeLayerG_new_const_DequantizeLayer }
	impl core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline] pub fn as_raw_PtrOfDequantizeLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDequantizeLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::DequantizeLayerTraitConst for core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline] fn as_raw_DequantizeLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::DequantizeLayerTrait for core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline] fn as_raw_mut_DequantizeLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DequantizeLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_DequantizeLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DequantizeLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_DequantizeLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::DequantizeLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDequantizeLayer")
				.field("scales", &crate::dnn::DequantizeLayerTraitConst::scales(self))
				.field("zeropoints", &crate::dnn::DequantizeLayerTraitConst::zeropoints(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::DetectionOutputLayer,
		cv_PtrLcv_dnn_DetectionOutputLayerG_new_null_const, cv_PtrLcv_dnn_DetectionOutputLayerG_delete, cv_PtrLcv_dnn_DetectionOutputLayerG_getInnerPtr_const, cv_PtrLcv_dnn_DetectionOutputLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::DetectionOutputLayer, cv_PtrLcv_dnn_DetectionOutputLayerG_new_const_DetectionOutputLayer }
	impl core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline] pub fn as_raw_PtrOfDetectionOutputLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetectionOutputLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::DetectionOutputLayerTraitConst for core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline] fn as_raw_DetectionOutputLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::DetectionOutputLayerTrait for core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline] fn as_raw_mut_DetectionOutputLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DetectionOutputLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_DetectionOutputLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::DetectionOutputLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_DetectionOutputLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::DetectionOutputLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetectionOutputLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ELULayer,
		cv_PtrLcv_dnn_ELULayerG_new_null_const, cv_PtrLcv_dnn_ELULayerG_delete, cv_PtrLcv_dnn_ELULayerG_getInnerPtr_const, cv_PtrLcv_dnn_ELULayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ELULayer, cv_PtrLcv_dnn_ELULayerG_new_const_ELULayer }
	impl core::Ptr<crate::dnn::ELULayer> {
		#[inline] pub fn as_raw_PtrOfELULayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfELULayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ELULayerTraitConst for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_ELULayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ELULayerTrait for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_mut_ELULayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ELULayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ELULayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ELULayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ELULayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ELULayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ELULayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ELULayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ELULayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfELULayer")
				.field("alpha", &crate::dnn::ELULayerTraitConst::alpha(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::EinsumLayer,
		cv_PtrLcv_dnn_EinsumLayerG_new_null_const, cv_PtrLcv_dnn_EinsumLayerG_delete, cv_PtrLcv_dnn_EinsumLayerG_getInnerPtr_const, cv_PtrLcv_dnn_EinsumLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::EinsumLayer, cv_PtrLcv_dnn_EinsumLayerG_new_const_EinsumLayer }
	impl core::Ptr<crate::dnn::EinsumLayer> {
		#[inline] pub fn as_raw_PtrOfEinsumLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEinsumLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::EinsumLayerTraitConst for core::Ptr<crate::dnn::EinsumLayer> {
		#[inline] fn as_raw_EinsumLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::EinsumLayerTrait for core::Ptr<crate::dnn::EinsumLayer> {
		#[inline] fn as_raw_mut_EinsumLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::EinsumLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::EinsumLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::EinsumLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_EinsumLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::EinsumLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::EinsumLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::EinsumLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_EinsumLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::EinsumLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEinsumLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::EltwiseLayer,
		cv_PtrLcv_dnn_EltwiseLayerG_new_null_const, cv_PtrLcv_dnn_EltwiseLayerG_delete, cv_PtrLcv_dnn_EltwiseLayerG_getInnerPtr_const, cv_PtrLcv_dnn_EltwiseLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::EltwiseLayer, cv_PtrLcv_dnn_EltwiseLayerG_new_const_EltwiseLayer }
	impl core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline] pub fn as_raw_PtrOfEltwiseLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEltwiseLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::EltwiseLayerTraitConst for core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline] fn as_raw_EltwiseLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::EltwiseLayerTrait for core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline] fn as_raw_mut_EltwiseLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::EltwiseLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_EltwiseLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::EltwiseLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_EltwiseLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::EltwiseLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEltwiseLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::EltwiseLayerInt8,
		cv_PtrLcv_dnn_EltwiseLayerInt8G_new_null_const, cv_PtrLcv_dnn_EltwiseLayerInt8G_delete, cv_PtrLcv_dnn_EltwiseLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_EltwiseLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::EltwiseLayerInt8, cv_PtrLcv_dnn_EltwiseLayerInt8G_new_const_EltwiseLayerInt8 }
	impl core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline] pub fn as_raw_PtrOfEltwiseLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEltwiseLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::EltwiseLayerInt8TraitConst for core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline] fn as_raw_EltwiseLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::EltwiseLayerInt8Trait for core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline] fn as_raw_mut_EltwiseLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::EltwiseLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_EltwiseLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::EltwiseLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_EltwiseLayerInt8G_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::EltwiseLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEltwiseLayerInt8")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ErfLayer,
		cv_PtrLcv_dnn_ErfLayerG_new_null_const, cv_PtrLcv_dnn_ErfLayerG_delete, cv_PtrLcv_dnn_ErfLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ErfLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ErfLayer, cv_PtrLcv_dnn_ErfLayerG_new_const_ErfLayer }
	impl core::Ptr<crate::dnn::ErfLayer> {
		#[inline] pub fn as_raw_PtrOfErfLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfErfLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ErfLayerTraitConst for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_ErfLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ErfLayerTrait for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_mut_ErfLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ErfLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ErfLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ErfLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ErfLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ErfLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ErfLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ErfLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ErfLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfErfLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ExpLayer,
		cv_PtrLcv_dnn_ExpLayerG_new_null_const, cv_PtrLcv_dnn_ExpLayerG_delete, cv_PtrLcv_dnn_ExpLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ExpLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ExpLayer, cv_PtrLcv_dnn_ExpLayerG_new_const_ExpLayer }
	impl core::Ptr<crate::dnn::ExpLayer> {
		#[inline] pub fn as_raw_PtrOfExpLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfExpLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ExpLayerTraitConst for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_ExpLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ExpLayerTrait for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_mut_ExpLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ExpLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ExpLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ExpLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ExpLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ExpLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ExpLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ExpLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ExpLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfExpLayer")
				.field("base", &crate::dnn::ExpLayerTraitConst::base(self))
				.field("scale", &crate::dnn::ExpLayerTraitConst::scale(self))
				.field("shift", &crate::dnn::ExpLayerTraitConst::shift(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ExpandLayer,
		cv_PtrLcv_dnn_ExpandLayerG_new_null_const, cv_PtrLcv_dnn_ExpandLayerG_delete, cv_PtrLcv_dnn_ExpandLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ExpandLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ExpandLayer, cv_PtrLcv_dnn_ExpandLayerG_new_const_ExpandLayer }
	impl core::Ptr<crate::dnn::ExpandLayer> {
		#[inline] pub fn as_raw_PtrOfExpandLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfExpandLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ExpandLayerTraitConst for core::Ptr<crate::dnn::ExpandLayer> {
		#[inline] fn as_raw_ExpandLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ExpandLayerTrait for core::Ptr<crate::dnn::ExpandLayer> {
		#[inline] fn as_raw_mut_ExpandLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ExpandLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ExpandLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ExpandLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ExpandLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ExpandLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ExpandLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ExpandLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ExpandLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ExpandLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfExpandLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::FlattenLayer,
		cv_PtrLcv_dnn_FlattenLayerG_new_null_const, cv_PtrLcv_dnn_FlattenLayerG_delete, cv_PtrLcv_dnn_FlattenLayerG_getInnerPtr_const, cv_PtrLcv_dnn_FlattenLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::FlattenLayer, cv_PtrLcv_dnn_FlattenLayerG_new_const_FlattenLayer }
	impl core::Ptr<crate::dnn::FlattenLayer> {
		#[inline] pub fn as_raw_PtrOfFlattenLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFlattenLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::FlattenLayerTraitConst for core::Ptr<crate::dnn::FlattenLayer> {
		#[inline] fn as_raw_FlattenLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::FlattenLayerTrait for core::Ptr<crate::dnn::FlattenLayer> {
		#[inline] fn as_raw_mut_FlattenLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::FlattenLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::FlattenLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::FlattenLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_FlattenLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::FlattenLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::FlattenLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::FlattenLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_FlattenLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::FlattenLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFlattenLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::FloorLayer,
		cv_PtrLcv_dnn_FloorLayerG_new_null_const, cv_PtrLcv_dnn_FloorLayerG_delete, cv_PtrLcv_dnn_FloorLayerG_getInnerPtr_const, cv_PtrLcv_dnn_FloorLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::FloorLayer, cv_PtrLcv_dnn_FloorLayerG_new_const_FloorLayer }
	impl core::Ptr<crate::dnn::FloorLayer> {
		#[inline] pub fn as_raw_PtrOfFloorLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFloorLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::FloorLayerTraitConst for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_FloorLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::FloorLayerTrait for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_mut_FloorLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::FloorLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_FloorLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::FloorLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_FloorLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::FloorLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::FloorLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_FloorLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::FloorLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFloorLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::FlowWarpLayer,
		cv_PtrLcv_dnn_FlowWarpLayerG_new_null_const, cv_PtrLcv_dnn_FlowWarpLayerG_delete, cv_PtrLcv_dnn_FlowWarpLayerG_getInnerPtr_const, cv_PtrLcv_dnn_FlowWarpLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::FlowWarpLayer, cv_PtrLcv_dnn_FlowWarpLayerG_new_const_FlowWarpLayer }
	impl core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline] pub fn as_raw_PtrOfFlowWarpLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFlowWarpLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::FlowWarpLayerTraitConst for core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline] fn as_raw_FlowWarpLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::FlowWarpLayerTrait for core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline] fn as_raw_mut_FlowWarpLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::FlowWarpLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_FlowWarpLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::FlowWarpLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_FlowWarpLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::FlowWarpLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFlowWarpLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::GRULayer,
		cv_PtrLcv_dnn_GRULayerG_new_null_const, cv_PtrLcv_dnn_GRULayerG_delete, cv_PtrLcv_dnn_GRULayerG_getInnerPtr_const, cv_PtrLcv_dnn_GRULayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::GRULayer, cv_PtrLcv_dnn_GRULayerG_new_const_GRULayer }
	impl core::Ptr<crate::dnn::GRULayer> {
		#[inline] pub fn as_raw_PtrOfGRULayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGRULayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::GRULayerTraitConst for core::Ptr<crate::dnn::GRULayer> {
		#[inline] fn as_raw_GRULayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::GRULayerTrait for core::Ptr<crate::dnn::GRULayer> {
		#[inline] fn as_raw_mut_GRULayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::GRULayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::GRULayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GRULayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_GRULayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::GRULayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::GRULayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GRULayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_GRULayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::GRULayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGRULayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::GatherElementsLayer,
		cv_PtrLcv_dnn_GatherElementsLayerG_new_null_const, cv_PtrLcv_dnn_GatherElementsLayerG_delete, cv_PtrLcv_dnn_GatherElementsLayerG_getInnerPtr_const, cv_PtrLcv_dnn_GatherElementsLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::GatherElementsLayer, cv_PtrLcv_dnn_GatherElementsLayerG_new_const_GatherElementsLayer }
	impl core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline] pub fn as_raw_PtrOfGatherElementsLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGatherElementsLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::GatherElementsLayerTraitConst for core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline] fn as_raw_GatherElementsLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::GatherElementsLayerTrait for core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline] fn as_raw_mut_GatherElementsLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GatherElementsLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_GatherElementsLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GatherElementsLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_GatherElementsLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::GatherElementsLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGatherElementsLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::GatherLayer,
		cv_PtrLcv_dnn_GatherLayerG_new_null_const, cv_PtrLcv_dnn_GatherLayerG_delete, cv_PtrLcv_dnn_GatherLayerG_getInnerPtr_const, cv_PtrLcv_dnn_GatherLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::GatherLayer, cv_PtrLcv_dnn_GatherLayerG_new_const_GatherLayer }
	impl core::Ptr<crate::dnn::GatherLayer> {
		#[inline] pub fn as_raw_PtrOfGatherLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGatherLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::GatherLayerTraitConst for core::Ptr<crate::dnn::GatherLayer> {
		#[inline] fn as_raw_GatherLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::GatherLayerTrait for core::Ptr<crate::dnn::GatherLayer> {
		#[inline] fn as_raw_mut_GatherLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::GatherLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::GatherLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GatherLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_GatherLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::GatherLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::GatherLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GatherLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_GatherLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::GatherLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGatherLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::GeluApproximationLayer,
		cv_PtrLcv_dnn_GeluApproximationLayerG_new_null_const, cv_PtrLcv_dnn_GeluApproximationLayerG_delete, cv_PtrLcv_dnn_GeluApproximationLayerG_getInnerPtr_const, cv_PtrLcv_dnn_GeluApproximationLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::GeluApproximationLayer, cv_PtrLcv_dnn_GeluApproximationLayerG_new_const_GeluApproximationLayer }
	impl core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] pub fn as_raw_PtrOfGeluApproximationLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGeluApproximationLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::GeluApproximationLayerTraitConst for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_GeluApproximationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::GeluApproximationLayerTrait for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_mut_GeluApproximationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GeluApproximationLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_GeluApproximationLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GeluApproximationLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_GeluApproximationLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GeluApproximationLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_GeluApproximationLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::GeluApproximationLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGeluApproximationLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::GeluLayer,
		cv_PtrLcv_dnn_GeluLayerG_new_null_const, cv_PtrLcv_dnn_GeluLayerG_delete, cv_PtrLcv_dnn_GeluLayerG_getInnerPtr_const, cv_PtrLcv_dnn_GeluLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::GeluLayer, cv_PtrLcv_dnn_GeluLayerG_new_const_GeluLayer }
	impl core::Ptr<crate::dnn::GeluLayer> {
		#[inline] pub fn as_raw_PtrOfGeluLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGeluLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::GeluLayerTraitConst for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_GeluLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::GeluLayerTrait for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_mut_GeluLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GeluLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_GeluLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GeluLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_GeluLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::GeluLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GeluLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_GeluLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::GeluLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGeluLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::GemmLayer,
		cv_PtrLcv_dnn_GemmLayerG_new_null_const, cv_PtrLcv_dnn_GemmLayerG_delete, cv_PtrLcv_dnn_GemmLayerG_getInnerPtr_const, cv_PtrLcv_dnn_GemmLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::GemmLayer, cv_PtrLcv_dnn_GemmLayerG_new_const_GemmLayer }
	impl core::Ptr<crate::dnn::GemmLayer> {
		#[inline] pub fn as_raw_PtrOfGemmLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGemmLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::GemmLayerTraitConst for core::Ptr<crate::dnn::GemmLayer> {
		#[inline] fn as_raw_GemmLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::GemmLayerTrait for core::Ptr<crate::dnn::GemmLayer> {
		#[inline] fn as_raw_mut_GemmLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::GemmLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::GemmLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GemmLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_GemmLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::GemmLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::GemmLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GemmLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_GemmLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::GemmLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGemmLayer")
				.field("trans_a", &crate::dnn::GemmLayerTraitConst::trans_a(self))
				.field("trans_b", &crate::dnn::GemmLayerTraitConst::trans_b(self))
				.field("alpha", &crate::dnn::GemmLayerTraitConst::alpha(self))
				.field("beta", &crate::dnn::GemmLayerTraitConst::beta(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::GroupNormLayer,
		cv_PtrLcv_dnn_GroupNormLayerG_new_null_const, cv_PtrLcv_dnn_GroupNormLayerG_delete, cv_PtrLcv_dnn_GroupNormLayerG_getInnerPtr_const, cv_PtrLcv_dnn_GroupNormLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::GroupNormLayer, cv_PtrLcv_dnn_GroupNormLayerG_new_const_GroupNormLayer }
	impl core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline] pub fn as_raw_PtrOfGroupNormLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGroupNormLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::GroupNormLayerTraitConst for core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline] fn as_raw_GroupNormLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::GroupNormLayerTrait for core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline] fn as_raw_mut_GroupNormLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GroupNormLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_GroupNormLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::GroupNormLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_GroupNormLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::GroupNormLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGroupNormLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::HardSigmoidLayer,
		cv_PtrLcv_dnn_HardSigmoidLayerG_new_null_const, cv_PtrLcv_dnn_HardSigmoidLayerG_delete, cv_PtrLcv_dnn_HardSigmoidLayerG_getInnerPtr_const, cv_PtrLcv_dnn_HardSigmoidLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::HardSigmoidLayer, cv_PtrLcv_dnn_HardSigmoidLayerG_new_const_HardSigmoidLayer }
	impl core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] pub fn as_raw_PtrOfHardSigmoidLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHardSigmoidLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::HardSigmoidLayerTraitConst for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_HardSigmoidLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::HardSigmoidLayerTrait for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_mut_HardSigmoidLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::HardSigmoidLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_HardSigmoidLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::HardSigmoidLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_HardSigmoidLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::HardSigmoidLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_HardSigmoidLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::HardSigmoidLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHardSigmoidLayer")
				.field("alpha", &crate::dnn::HardSigmoidLayerTraitConst::alpha(self))
				.field("beta", &crate::dnn::HardSigmoidLayerTraitConst::beta(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::HardSwishLayer,
		cv_PtrLcv_dnn_HardSwishLayerG_new_null_const, cv_PtrLcv_dnn_HardSwishLayerG_delete, cv_PtrLcv_dnn_HardSwishLayerG_getInnerPtr_const, cv_PtrLcv_dnn_HardSwishLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::HardSwishLayer, cv_PtrLcv_dnn_HardSwishLayerG_new_const_HardSwishLayer }
	impl core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] pub fn as_raw_PtrOfHardSwishLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHardSwishLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::HardSwishLayerTraitConst for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_HardSwishLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::HardSwishLayerTrait for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_mut_HardSwishLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::HardSwishLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_HardSwishLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::HardSwishLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_HardSwishLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::HardSwishLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_HardSwishLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::HardSwishLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHardSwishLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::InnerProductLayer,
		cv_PtrLcv_dnn_InnerProductLayerG_new_null_const, cv_PtrLcv_dnn_InnerProductLayerG_delete, cv_PtrLcv_dnn_InnerProductLayerG_getInnerPtr_const, cv_PtrLcv_dnn_InnerProductLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::InnerProductLayer, cv_PtrLcv_dnn_InnerProductLayerG_new_const_InnerProductLayer }
	impl core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline] pub fn as_raw_PtrOfInnerProductLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfInnerProductLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::InnerProductLayerTraitConst for core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline] fn as_raw_InnerProductLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::InnerProductLayerTrait for core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline] fn as_raw_mut_InnerProductLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InnerProductLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_InnerProductLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InnerProductLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_InnerProductLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::InnerProductLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfInnerProductLayer")
				.field("axis", &crate::dnn::InnerProductLayerTraitConst::axis(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::InnerProductLayerInt8,
		cv_PtrLcv_dnn_InnerProductLayerInt8G_new_null_const, cv_PtrLcv_dnn_InnerProductLayerInt8G_delete, cv_PtrLcv_dnn_InnerProductLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_InnerProductLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::InnerProductLayerInt8, cv_PtrLcv_dnn_InnerProductLayerInt8G_new_const_InnerProductLayerInt8 }
	impl core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] pub fn as_raw_PtrOfInnerProductLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfInnerProductLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::InnerProductLayerInt8TraitConst for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_InnerProductLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::InnerProductLayerInt8Trait for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_mut_InnerProductLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InnerProductLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_InnerProductLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::InnerProductLayerTraitConst for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_InnerProductLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::InnerProductLayerTrait for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_mut_InnerProductLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InnerProductLayerInt8>, core::Ptr<crate::dnn::InnerProductLayer>, cv_PtrLcv_dnn_InnerProductLayerInt8G_to_PtrOfInnerProductLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InnerProductLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_InnerProductLayerInt8G_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::InnerProductLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfInnerProductLayerInt8")
				.field("input_zp", &crate::dnn::InnerProductLayerInt8TraitConst::input_zp(self))
				.field("output_zp", &crate::dnn::InnerProductLayerInt8TraitConst::output_zp(self))
				.field("input_sc", &crate::dnn::InnerProductLayerInt8TraitConst::input_sc(self))
				.field("output_sc", &crate::dnn::InnerProductLayerInt8TraitConst::output_sc(self))
				.field("per_channel", &crate::dnn::InnerProductLayerInt8TraitConst::per_channel(self))
				.field("axis", &crate::dnn::InnerProductLayerTraitConst::axis(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::InstanceNormLayer,
		cv_PtrLcv_dnn_InstanceNormLayerG_new_null_const, cv_PtrLcv_dnn_InstanceNormLayerG_delete, cv_PtrLcv_dnn_InstanceNormLayerG_getInnerPtr_const, cv_PtrLcv_dnn_InstanceNormLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::InstanceNormLayer, cv_PtrLcv_dnn_InstanceNormLayerG_new_const_InstanceNormLayer }
	impl core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline] pub fn as_raw_PtrOfInstanceNormLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfInstanceNormLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::InstanceNormLayerTraitConst for core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline] fn as_raw_InstanceNormLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::InstanceNormLayerTrait for core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline] fn as_raw_mut_InstanceNormLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InstanceNormLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_InstanceNormLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InstanceNormLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_InstanceNormLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::InstanceNormLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfInstanceNormLayer")
				.field("epsilon", &crate::dnn::InstanceNormLayerTraitConst::epsilon(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::InterpLayer,
		cv_PtrLcv_dnn_InterpLayerG_new_null_const, cv_PtrLcv_dnn_InterpLayerG_delete, cv_PtrLcv_dnn_InterpLayerG_getInnerPtr_const, cv_PtrLcv_dnn_InterpLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::InterpLayer, cv_PtrLcv_dnn_InterpLayerG_new_const_InterpLayer }
	impl core::Ptr<crate::dnn::InterpLayer> {
		#[inline] pub fn as_raw_PtrOfInterpLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfInterpLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::InterpLayerTraitConst for core::Ptr<crate::dnn::InterpLayer> {
		#[inline] fn as_raw_InterpLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::InterpLayerTrait for core::Ptr<crate::dnn::InterpLayer> {
		#[inline] fn as_raw_mut_InterpLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::InterpLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::InterpLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InterpLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_InterpLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::InterpLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::InterpLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::InterpLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_InterpLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::InterpLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfInterpLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::LRNLayer,
		cv_PtrLcv_dnn_LRNLayerG_new_null_const, cv_PtrLcv_dnn_LRNLayerG_delete, cv_PtrLcv_dnn_LRNLayerG_getInnerPtr_const, cv_PtrLcv_dnn_LRNLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::LRNLayer, cv_PtrLcv_dnn_LRNLayerG_new_const_LRNLayer }
	impl core::Ptr<crate::dnn::LRNLayer> {
		#[inline] pub fn as_raw_PtrOfLRNLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLRNLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::LRNLayerTraitConst for core::Ptr<crate::dnn::LRNLayer> {
		#[inline] fn as_raw_LRNLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LRNLayerTrait for core::Ptr<crate::dnn::LRNLayer> {
		#[inline] fn as_raw_mut_LRNLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::LRNLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::LRNLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LRNLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_LRNLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::LRNLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::LRNLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LRNLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_LRNLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::LRNLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLRNLayer")
				.field("typ", &crate::dnn::LRNLayerTraitConst::typ(self))
				.field("size", &crate::dnn::LRNLayerTraitConst::size(self))
				.field("alpha", &crate::dnn::LRNLayerTraitConst::alpha(self))
				.field("beta", &crate::dnn::LRNLayerTraitConst::beta(self))
				.field("bias", &crate::dnn::LRNLayerTraitConst::bias(self))
				.field("norm_by_size", &crate::dnn::LRNLayerTraitConst::norm_by_size(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::LSTMLayer,
		cv_PtrLcv_dnn_LSTMLayerG_new_null_const, cv_PtrLcv_dnn_LSTMLayerG_delete, cv_PtrLcv_dnn_LSTMLayerG_getInnerPtr_const, cv_PtrLcv_dnn_LSTMLayerG_getInnerPtrMut
	}

	impl core::Ptr<crate::dnn::LSTMLayer> {
		#[inline] pub fn as_raw_PtrOfLSTMLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLSTMLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::LSTMLayerTraitConst for core::Ptr<crate::dnn::LSTMLayer> {
		#[inline] fn as_raw_LSTMLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LSTMLayerTrait for core::Ptr<crate::dnn::LSTMLayer> {
		#[inline] fn as_raw_mut_LSTMLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::LSTMLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::LSTMLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LSTMLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_LSTMLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::LSTMLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::LSTMLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LSTMLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_LSTMLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::LSTMLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLSTMLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::Layer,
		cv_PtrLcv_dnn_LayerG_new_null_const, cv_PtrLcv_dnn_LayerG_delete, cv_PtrLcv_dnn_LayerG_getInnerPtr_const, cv_PtrLcv_dnn_LayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::Layer, cv_PtrLcv_dnn_LayerG_new_const_Layer }
	impl core::Ptr<crate::dnn::Layer> {
		#[inline] pub fn as_raw_PtrOfLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::Layer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::Layer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::Layer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::Layer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::Layer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_LayerG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::dnn::Layer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::LayerNormLayer,
		cv_PtrLcv_dnn_LayerNormLayerG_new_null_const, cv_PtrLcv_dnn_LayerNormLayerG_delete, cv_PtrLcv_dnn_LayerNormLayerG_getInnerPtr_const, cv_PtrLcv_dnn_LayerNormLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::LayerNormLayer, cv_PtrLcv_dnn_LayerNormLayerG_new_const_LayerNormLayer }
	impl core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline] pub fn as_raw_PtrOfLayerNormLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLayerNormLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::LayerNormLayerTraitConst for core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline] fn as_raw_LayerNormLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerNormLayerTrait for core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline] fn as_raw_mut_LayerNormLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LayerNormLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_LayerNormLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LayerNormLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_LayerNormLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::LayerNormLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLayerNormLayer")
				.field("has_bias", &crate::dnn::LayerNormLayerTraitConst::has_bias(self))
				.field("axis", &crate::dnn::LayerNormLayerTraitConst::axis(self))
				.field("epsilon", &crate::dnn::LayerNormLayerTraitConst::epsilon(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::LogLayer,
		cv_PtrLcv_dnn_LogLayerG_new_null_const, cv_PtrLcv_dnn_LogLayerG_delete, cv_PtrLcv_dnn_LogLayerG_getInnerPtr_const, cv_PtrLcv_dnn_LogLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::LogLayer, cv_PtrLcv_dnn_LogLayerG_new_const_LogLayer }
	impl core::Ptr<crate::dnn::LogLayer> {
		#[inline] pub fn as_raw_PtrOfLogLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLogLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::LogLayerTraitConst for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_LogLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LogLayerTrait for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_mut_LogLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LogLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_LogLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LogLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_LogLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::LogLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::LogLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_LogLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::LogLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLogLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::MVNLayer,
		cv_PtrLcv_dnn_MVNLayerG_new_null_const, cv_PtrLcv_dnn_MVNLayerG_delete, cv_PtrLcv_dnn_MVNLayerG_getInnerPtr_const, cv_PtrLcv_dnn_MVNLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::MVNLayer, cv_PtrLcv_dnn_MVNLayerG_new_const_MVNLayer }
	impl core::Ptr<crate::dnn::MVNLayer> {
		#[inline] pub fn as_raw_PtrOfMVNLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMVNLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::MVNLayerTraitConst for core::Ptr<crate::dnn::MVNLayer> {
		#[inline] fn as_raw_MVNLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::MVNLayerTrait for core::Ptr<crate::dnn::MVNLayer> {
		#[inline] fn as_raw_mut_MVNLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::MVNLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::MVNLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MVNLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_MVNLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::MVNLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::MVNLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MVNLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_MVNLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::MVNLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMVNLayer")
				.field("eps", &crate::dnn::MVNLayerTraitConst::eps(self))
				.field("norm_variance", &crate::dnn::MVNLayerTraitConst::norm_variance(self))
				.field("across_channels", &crate::dnn::MVNLayerTraitConst::across_channels(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::MatMulLayer,
		cv_PtrLcv_dnn_MatMulLayerG_new_null_const, cv_PtrLcv_dnn_MatMulLayerG_delete, cv_PtrLcv_dnn_MatMulLayerG_getInnerPtr_const, cv_PtrLcv_dnn_MatMulLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::MatMulLayer, cv_PtrLcv_dnn_MatMulLayerG_new_const_MatMulLayer }
	impl core::Ptr<crate::dnn::MatMulLayer> {
		#[inline] pub fn as_raw_PtrOfMatMulLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMatMulLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::MatMulLayerTraitConst for core::Ptr<crate::dnn::MatMulLayer> {
		#[inline] fn as_raw_MatMulLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::MatMulLayerTrait for core::Ptr<crate::dnn::MatMulLayer> {
		#[inline] fn as_raw_mut_MatMulLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::MatMulLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::MatMulLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MatMulLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_MatMulLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::MatMulLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::MatMulLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MatMulLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_MatMulLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::MatMulLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMatMulLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::MaxUnpoolLayer,
		cv_PtrLcv_dnn_MaxUnpoolLayerG_new_null_const, cv_PtrLcv_dnn_MaxUnpoolLayerG_delete, cv_PtrLcv_dnn_MaxUnpoolLayerG_getInnerPtr_const, cv_PtrLcv_dnn_MaxUnpoolLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::MaxUnpoolLayer, cv_PtrLcv_dnn_MaxUnpoolLayerG_new_const_MaxUnpoolLayer }
	impl core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline] pub fn as_raw_PtrOfMaxUnpoolLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMaxUnpoolLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::MaxUnpoolLayerTraitConst for core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline] fn as_raw_MaxUnpoolLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::MaxUnpoolLayerTrait for core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline] fn as_raw_mut_MaxUnpoolLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MaxUnpoolLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_MaxUnpoolLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MaxUnpoolLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_MaxUnpoolLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::MaxUnpoolLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMaxUnpoolLayer")
				.field("pool_kernel", &crate::dnn::MaxUnpoolLayerTraitConst::pool_kernel(self))
				.field("pool_pad", &crate::dnn::MaxUnpoolLayerTraitConst::pool_pad(self))
				.field("pool_stride", &crate::dnn::MaxUnpoolLayerTraitConst::pool_stride(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::MishLayer,
		cv_PtrLcv_dnn_MishLayerG_new_null_const, cv_PtrLcv_dnn_MishLayerG_delete, cv_PtrLcv_dnn_MishLayerG_getInnerPtr_const, cv_PtrLcv_dnn_MishLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::MishLayer, cv_PtrLcv_dnn_MishLayerG_new_const_MishLayer }
	impl core::Ptr<crate::dnn::MishLayer> {
		#[inline] pub fn as_raw_PtrOfMishLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMishLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::MishLayerTraitConst for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_MishLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::MishLayerTrait for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_mut_MishLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MishLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_MishLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MishLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_MishLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::MishLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::MishLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_MishLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::MishLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMishLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::NaryEltwiseLayer,
		cv_PtrLcv_dnn_NaryEltwiseLayerG_new_null_const, cv_PtrLcv_dnn_NaryEltwiseLayerG_delete, cv_PtrLcv_dnn_NaryEltwiseLayerG_getInnerPtr_const, cv_PtrLcv_dnn_NaryEltwiseLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::NaryEltwiseLayer, cv_PtrLcv_dnn_NaryEltwiseLayerG_new_const_NaryEltwiseLayer }
	impl core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline] pub fn as_raw_PtrOfNaryEltwiseLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfNaryEltwiseLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::NaryEltwiseLayerTraitConst for core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline] fn as_raw_NaryEltwiseLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::NaryEltwiseLayerTrait for core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline] fn as_raw_mut_NaryEltwiseLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::NaryEltwiseLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_NaryEltwiseLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::NaryEltwiseLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_NaryEltwiseLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::NaryEltwiseLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfNaryEltwiseLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::NormalizeBBoxLayer,
		cv_PtrLcv_dnn_NormalizeBBoxLayerG_new_null_const, cv_PtrLcv_dnn_NormalizeBBoxLayerG_delete, cv_PtrLcv_dnn_NormalizeBBoxLayerG_getInnerPtr_const, cv_PtrLcv_dnn_NormalizeBBoxLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::NormalizeBBoxLayer, cv_PtrLcv_dnn_NormalizeBBoxLayerG_new_const_NormalizeBBoxLayer }
	impl core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline] pub fn as_raw_PtrOfNormalizeBBoxLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfNormalizeBBoxLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::NormalizeBBoxLayerTraitConst for core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline] fn as_raw_NormalizeBBoxLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::NormalizeBBoxLayerTrait for core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline] fn as_raw_mut_NormalizeBBoxLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::NormalizeBBoxLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_NormalizeBBoxLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::NormalizeBBoxLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_NormalizeBBoxLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::NormalizeBBoxLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfNormalizeBBoxLayer")
				.field("pnorm", &crate::dnn::NormalizeBBoxLayerTraitConst::pnorm(self))
				.field("epsilon", &crate::dnn::NormalizeBBoxLayerTraitConst::epsilon(self))
				.field("across_spatial", &crate::dnn::NormalizeBBoxLayerTraitConst::across_spatial(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::NotLayer,
		cv_PtrLcv_dnn_NotLayerG_new_null_const, cv_PtrLcv_dnn_NotLayerG_delete, cv_PtrLcv_dnn_NotLayerG_getInnerPtr_const, cv_PtrLcv_dnn_NotLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::NotLayer, cv_PtrLcv_dnn_NotLayerG_new_const_NotLayer }
	impl core::Ptr<crate::dnn::NotLayer> {
		#[inline] pub fn as_raw_PtrOfNotLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfNotLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::NotLayerTraitConst for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_NotLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::NotLayerTrait for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_mut_NotLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::NotLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_NotLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::NotLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_NotLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::NotLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::NotLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_NotLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::NotLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfNotLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::PaddingLayer,
		cv_PtrLcv_dnn_PaddingLayerG_new_null_const, cv_PtrLcv_dnn_PaddingLayerG_delete, cv_PtrLcv_dnn_PaddingLayerG_getInnerPtr_const, cv_PtrLcv_dnn_PaddingLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::PaddingLayer, cv_PtrLcv_dnn_PaddingLayerG_new_const_PaddingLayer }
	impl core::Ptr<crate::dnn::PaddingLayer> {
		#[inline] pub fn as_raw_PtrOfPaddingLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPaddingLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::PaddingLayerTraitConst for core::Ptr<crate::dnn::PaddingLayer> {
		#[inline] fn as_raw_PaddingLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::PaddingLayerTrait for core::Ptr<crate::dnn::PaddingLayer> {
		#[inline] fn as_raw_mut_PaddingLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::PaddingLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::PaddingLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PaddingLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_PaddingLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::PaddingLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::PaddingLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PaddingLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_PaddingLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::PaddingLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPaddingLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::PermuteLayer,
		cv_PtrLcv_dnn_PermuteLayerG_new_null_const, cv_PtrLcv_dnn_PermuteLayerG_delete, cv_PtrLcv_dnn_PermuteLayerG_getInnerPtr_const, cv_PtrLcv_dnn_PermuteLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::PermuteLayer, cv_PtrLcv_dnn_PermuteLayerG_new_const_PermuteLayer }
	impl core::Ptr<crate::dnn::PermuteLayer> {
		#[inline] pub fn as_raw_PtrOfPermuteLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPermuteLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::PermuteLayerTraitConst for core::Ptr<crate::dnn::PermuteLayer> {
		#[inline] fn as_raw_PermuteLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::PermuteLayerTrait for core::Ptr<crate::dnn::PermuteLayer> {
		#[inline] fn as_raw_mut_PermuteLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::PermuteLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::PermuteLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PermuteLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_PermuteLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::PermuteLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::PermuteLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PermuteLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_PermuteLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::PermuteLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPermuteLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::PoolingLayer,
		cv_PtrLcv_dnn_PoolingLayerG_new_null_const, cv_PtrLcv_dnn_PoolingLayerG_delete, cv_PtrLcv_dnn_PoolingLayerG_getInnerPtr_const, cv_PtrLcv_dnn_PoolingLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::PoolingLayer, cv_PtrLcv_dnn_PoolingLayerG_new_const_PoolingLayer }
	impl core::Ptr<crate::dnn::PoolingLayer> {
		#[inline] pub fn as_raw_PtrOfPoolingLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPoolingLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::PoolingLayerTraitConst for core::Ptr<crate::dnn::PoolingLayer> {
		#[inline] fn as_raw_PoolingLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::PoolingLayerTrait for core::Ptr<crate::dnn::PoolingLayer> {
		#[inline] fn as_raw_mut_PoolingLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::PoolingLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::PoolingLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PoolingLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_PoolingLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::PoolingLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::PoolingLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PoolingLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_PoolingLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::PoolingLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPoolingLayer")
				.field("typ", &crate::dnn::PoolingLayerTraitConst::typ(self))
				.field("kernel_size", &crate::dnn::PoolingLayerTraitConst::kernel_size(self))
				.field("strides", &crate::dnn::PoolingLayerTraitConst::strides(self))
				.field("pads_begin", &crate::dnn::PoolingLayerTraitConst::pads_begin(self))
				.field("pads_end", &crate::dnn::PoolingLayerTraitConst::pads_end(self))
				.field("global_pooling", &crate::dnn::PoolingLayerTraitConst::global_pooling(self))
				.field("is_global_pooling", &crate::dnn::PoolingLayerTraitConst::is_global_pooling(self))
				.field("compute_max_idx", &crate::dnn::PoolingLayerTraitConst::compute_max_idx(self))
				.field("pad_mode", &crate::dnn::PoolingLayerTraitConst::pad_mode(self))
				.field("ceil_mode", &crate::dnn::PoolingLayerTraitConst::ceil_mode(self))
				.field("ave_pool_padded_area", &crate::dnn::PoolingLayerTraitConst::ave_pool_padded_area(self))
				.field("pooled_size", &crate::dnn::PoolingLayerTraitConst::pooled_size(self))
				.field("spatial_scale", &crate::dnn::PoolingLayerTraitConst::spatial_scale(self))
				.field("ps_roi_out_channels", &crate::dnn::PoolingLayerTraitConst::ps_roi_out_channels(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::PoolingLayerInt8,
		cv_PtrLcv_dnn_PoolingLayerInt8G_new_null_const, cv_PtrLcv_dnn_PoolingLayerInt8G_delete, cv_PtrLcv_dnn_PoolingLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_PoolingLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::PoolingLayerInt8, cv_PtrLcv_dnn_PoolingLayerInt8G_new_const_PoolingLayerInt8 }
	impl core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] pub fn as_raw_PtrOfPoolingLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPoolingLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::PoolingLayerInt8TraitConst for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_PoolingLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::PoolingLayerInt8Trait for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_mut_PoolingLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PoolingLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_PoolingLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PoolingLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_PoolingLayerInt8G_to_PtrOfLayer }

	impl crate::dnn::PoolingLayerTraitConst for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_PoolingLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::PoolingLayerTrait for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline] fn as_raw_mut_PoolingLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PoolingLayerInt8>, core::Ptr<crate::dnn::PoolingLayer>, cv_PtrLcv_dnn_PoolingLayerInt8G_to_PtrOfPoolingLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::PoolingLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPoolingLayerInt8")
				.field("input_zp", &crate::dnn::PoolingLayerInt8TraitConst::input_zp(self))
				.field("output_zp", &crate::dnn::PoolingLayerInt8TraitConst::output_zp(self))
				.field("input_sc", &crate::dnn::PoolingLayerInt8TraitConst::input_sc(self))
				.field("output_sc", &crate::dnn::PoolingLayerInt8TraitConst::output_sc(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.field("typ", &crate::dnn::PoolingLayerTraitConst::typ(self))
				.field("kernel_size", &crate::dnn::PoolingLayerTraitConst::kernel_size(self))
				.field("strides", &crate::dnn::PoolingLayerTraitConst::strides(self))
				.field("pads_begin", &crate::dnn::PoolingLayerTraitConst::pads_begin(self))
				.field("pads_end", &crate::dnn::PoolingLayerTraitConst::pads_end(self))
				.field("global_pooling", &crate::dnn::PoolingLayerTraitConst::global_pooling(self))
				.field("is_global_pooling", &crate::dnn::PoolingLayerTraitConst::is_global_pooling(self))
				.field("compute_max_idx", &crate::dnn::PoolingLayerTraitConst::compute_max_idx(self))
				.field("pad_mode", &crate::dnn::PoolingLayerTraitConst::pad_mode(self))
				.field("ceil_mode", &crate::dnn::PoolingLayerTraitConst::ceil_mode(self))
				.field("ave_pool_padded_area", &crate::dnn::PoolingLayerTraitConst::ave_pool_padded_area(self))
				.field("pooled_size", &crate::dnn::PoolingLayerTraitConst::pooled_size(self))
				.field("spatial_scale", &crate::dnn::PoolingLayerTraitConst::spatial_scale(self))
				.field("ps_roi_out_channels", &crate::dnn::PoolingLayerTraitConst::ps_roi_out_channels(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::PowerLayer,
		cv_PtrLcv_dnn_PowerLayerG_new_null_const, cv_PtrLcv_dnn_PowerLayerG_delete, cv_PtrLcv_dnn_PowerLayerG_getInnerPtr_const, cv_PtrLcv_dnn_PowerLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::PowerLayer, cv_PtrLcv_dnn_PowerLayerG_new_const_PowerLayer }
	impl core::Ptr<crate::dnn::PowerLayer> {
		#[inline] pub fn as_raw_PtrOfPowerLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPowerLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::PowerLayerTraitConst for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_PowerLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::PowerLayerTrait for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_mut_PowerLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PowerLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_PowerLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PowerLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_PowerLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::PowerLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PowerLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_PowerLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::PowerLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPowerLayer")
				.field("power", &crate::dnn::PowerLayerTraitConst::power(self))
				.field("scale", &crate::dnn::PowerLayerTraitConst::scale(self))
				.field("shift", &crate::dnn::PowerLayerTraitConst::shift(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::PriorBoxLayer,
		cv_PtrLcv_dnn_PriorBoxLayerG_new_null_const, cv_PtrLcv_dnn_PriorBoxLayerG_delete, cv_PtrLcv_dnn_PriorBoxLayerG_getInnerPtr_const, cv_PtrLcv_dnn_PriorBoxLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::PriorBoxLayer, cv_PtrLcv_dnn_PriorBoxLayerG_new_const_PriorBoxLayer }
	impl core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline] pub fn as_raw_PtrOfPriorBoxLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPriorBoxLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::PriorBoxLayerTraitConst for core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline] fn as_raw_PriorBoxLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::PriorBoxLayerTrait for core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline] fn as_raw_mut_PriorBoxLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PriorBoxLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_PriorBoxLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::PriorBoxLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_PriorBoxLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::PriorBoxLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPriorBoxLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ProposalLayer,
		cv_PtrLcv_dnn_ProposalLayerG_new_null_const, cv_PtrLcv_dnn_ProposalLayerG_delete, cv_PtrLcv_dnn_ProposalLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ProposalLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ProposalLayer, cv_PtrLcv_dnn_ProposalLayerG_new_const_ProposalLayer }
	impl core::Ptr<crate::dnn::ProposalLayer> {
		#[inline] pub fn as_raw_PtrOfProposalLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfProposalLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ProposalLayerTraitConst for core::Ptr<crate::dnn::ProposalLayer> {
		#[inline] fn as_raw_ProposalLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ProposalLayerTrait for core::Ptr<crate::dnn::ProposalLayer> {
		#[inline] fn as_raw_mut_ProposalLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ProposalLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ProposalLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ProposalLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ProposalLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ProposalLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ProposalLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ProposalLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ProposalLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ProposalLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfProposalLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::QuantizeLayer,
		cv_PtrLcv_dnn_QuantizeLayerG_new_null_const, cv_PtrLcv_dnn_QuantizeLayerG_delete, cv_PtrLcv_dnn_QuantizeLayerG_getInnerPtr_const, cv_PtrLcv_dnn_QuantizeLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::QuantizeLayer, cv_PtrLcv_dnn_QuantizeLayerG_new_const_QuantizeLayer }
	impl core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline] pub fn as_raw_PtrOfQuantizeLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQuantizeLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::QuantizeLayerTraitConst for core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline] fn as_raw_QuantizeLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::QuantizeLayerTrait for core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline] fn as_raw_mut_QuantizeLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::QuantizeLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_QuantizeLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::QuantizeLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_QuantizeLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::QuantizeLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQuantizeLayer")
				.field("scales", &crate::dnn::QuantizeLayerTraitConst::scales(self))
				.field("zeropoints", &crate::dnn::QuantizeLayerTraitConst::zeropoints(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::RNNLayer,
		cv_PtrLcv_dnn_RNNLayerG_new_null_const, cv_PtrLcv_dnn_RNNLayerG_delete, cv_PtrLcv_dnn_RNNLayerG_getInnerPtr_const, cv_PtrLcv_dnn_RNNLayerG_getInnerPtrMut
	}

	impl core::Ptr<crate::dnn::RNNLayer> {
		#[inline] pub fn as_raw_PtrOfRNNLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRNNLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::RNNLayerTraitConst for core::Ptr<crate::dnn::RNNLayer> {
		#[inline] fn as_raw_RNNLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::RNNLayerTrait for core::Ptr<crate::dnn::RNNLayer> {
		#[inline] fn as_raw_mut_RNNLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::RNNLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::RNNLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RNNLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_RNNLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::RNNLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::RNNLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RNNLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_RNNLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::RNNLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRNNLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ReLU6Layer,
		cv_PtrLcv_dnn_ReLU6LayerG_new_null_const, cv_PtrLcv_dnn_ReLU6LayerG_delete, cv_PtrLcv_dnn_ReLU6LayerG_getInnerPtr_const, cv_PtrLcv_dnn_ReLU6LayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ReLU6Layer, cv_PtrLcv_dnn_ReLU6LayerG_new_const_ReLU6Layer }
	impl core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] pub fn as_raw_PtrOfReLU6Layer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfReLU6Layer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ReLU6LayerTraitConst for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_ReLU6Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ReLU6LayerTrait for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_mut_ReLU6Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReLU6Layer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ReLU6LayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReLU6Layer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ReLU6LayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReLU6Layer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ReLU6LayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ReLU6Layer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfReLU6Layer")
				.field("min_value", &crate::dnn::ReLU6LayerTraitConst::min_value(self))
				.field("max_value", &crate::dnn::ReLU6LayerTraitConst::max_value(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ReLULayer,
		cv_PtrLcv_dnn_ReLULayerG_new_null_const, cv_PtrLcv_dnn_ReLULayerG_delete, cv_PtrLcv_dnn_ReLULayerG_getInnerPtr_const, cv_PtrLcv_dnn_ReLULayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ReLULayer, cv_PtrLcv_dnn_ReLULayerG_new_const_ReLULayer }
	impl core::Ptr<crate::dnn::ReLULayer> {
		#[inline] pub fn as_raw_PtrOfReLULayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfReLULayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ReLULayerTraitConst for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_ReLULayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ReLULayerTrait for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_mut_ReLULayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReLULayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ReLULayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReLULayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ReLULayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ReLULayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReLULayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ReLULayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ReLULayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfReLULayer")
				.field("negative_slope", &crate::dnn::ReLULayerTraitConst::negative_slope(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ReciprocalLayer,
		cv_PtrLcv_dnn_ReciprocalLayerG_new_null_const, cv_PtrLcv_dnn_ReciprocalLayerG_delete, cv_PtrLcv_dnn_ReciprocalLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ReciprocalLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ReciprocalLayer, cv_PtrLcv_dnn_ReciprocalLayerG_new_const_ReciprocalLayer }
	impl core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] pub fn as_raw_PtrOfReciprocalLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfReciprocalLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ReciprocalLayerTraitConst for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_ReciprocalLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ReciprocalLayerTrait for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_mut_ReciprocalLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReciprocalLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ReciprocalLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReciprocalLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ReciprocalLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReciprocalLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ReciprocalLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ReciprocalLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfReciprocalLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ReduceLayer,
		cv_PtrLcv_dnn_ReduceLayerG_new_null_const, cv_PtrLcv_dnn_ReduceLayerG_delete, cv_PtrLcv_dnn_ReduceLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ReduceLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ReduceLayer, cv_PtrLcv_dnn_ReduceLayerG_new_const_ReduceLayer }
	impl core::Ptr<crate::dnn::ReduceLayer> {
		#[inline] pub fn as_raw_PtrOfReduceLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfReduceLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ReduceLayerTraitConst for core::Ptr<crate::dnn::ReduceLayer> {
		#[inline] fn as_raw_ReduceLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ReduceLayerTrait for core::Ptr<crate::dnn::ReduceLayer> {
		#[inline] fn as_raw_mut_ReduceLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ReduceLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ReduceLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReduceLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ReduceLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ReduceLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ReduceLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReduceLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ReduceLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ReduceLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfReduceLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::RegionLayer,
		cv_PtrLcv_dnn_RegionLayerG_new_null_const, cv_PtrLcv_dnn_RegionLayerG_delete, cv_PtrLcv_dnn_RegionLayerG_getInnerPtr_const, cv_PtrLcv_dnn_RegionLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::RegionLayer, cv_PtrLcv_dnn_RegionLayerG_new_const_RegionLayer }
	impl core::Ptr<crate::dnn::RegionLayer> {
		#[inline] pub fn as_raw_PtrOfRegionLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRegionLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::RegionLayerTraitConst for core::Ptr<crate::dnn::RegionLayer> {
		#[inline] fn as_raw_RegionLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::RegionLayerTrait for core::Ptr<crate::dnn::RegionLayer> {
		#[inline] fn as_raw_mut_RegionLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::RegionLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::RegionLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RegionLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_RegionLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::RegionLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::RegionLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RegionLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_RegionLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::RegionLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRegionLayer")
				.field("nms_threshold", &crate::dnn::RegionLayerTraitConst::nms_threshold(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ReorgLayer,
		cv_PtrLcv_dnn_ReorgLayerG_new_null_const, cv_PtrLcv_dnn_ReorgLayerG_delete, cv_PtrLcv_dnn_ReorgLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ReorgLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ReorgLayer, cv_PtrLcv_dnn_ReorgLayerG_new_const_ReorgLayer }
	impl core::Ptr<crate::dnn::ReorgLayer> {
		#[inline] pub fn as_raw_PtrOfReorgLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfReorgLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ReorgLayerTraitConst for core::Ptr<crate::dnn::ReorgLayer> {
		#[inline] fn as_raw_ReorgLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ReorgLayerTrait for core::Ptr<crate::dnn::ReorgLayer> {
		#[inline] fn as_raw_mut_ReorgLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ReorgLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ReorgLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReorgLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ReorgLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ReorgLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ReorgLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReorgLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ReorgLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ReorgLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfReorgLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::RequantizeLayer,
		cv_PtrLcv_dnn_RequantizeLayerG_new_null_const, cv_PtrLcv_dnn_RequantizeLayerG_delete, cv_PtrLcv_dnn_RequantizeLayerG_getInnerPtr_const, cv_PtrLcv_dnn_RequantizeLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::RequantizeLayer, cv_PtrLcv_dnn_RequantizeLayerG_new_const_RequantizeLayer }
	impl core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline] pub fn as_raw_PtrOfRequantizeLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRequantizeLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::RequantizeLayerTraitConst for core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline] fn as_raw_RequantizeLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::RequantizeLayerTrait for core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline] fn as_raw_mut_RequantizeLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RequantizeLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_RequantizeLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RequantizeLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_RequantizeLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::RequantizeLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRequantizeLayer")
				.field("scale", &crate::dnn::RequantizeLayerTraitConst::scale(self))
				.field("shift", &crate::dnn::RequantizeLayerTraitConst::shift(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ReshapeLayer,
		cv_PtrLcv_dnn_ReshapeLayerG_new_null_const, cv_PtrLcv_dnn_ReshapeLayerG_delete, cv_PtrLcv_dnn_ReshapeLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ReshapeLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ReshapeLayer, cv_PtrLcv_dnn_ReshapeLayerG_new_const_ReshapeLayer }
	impl core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline] pub fn as_raw_PtrOfReshapeLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfReshapeLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ReshapeLayerTraitConst for core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline] fn as_raw_ReshapeLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ReshapeLayerTrait for core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline] fn as_raw_mut_ReshapeLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReshapeLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ReshapeLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ReshapeLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ReshapeLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ReshapeLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfReshapeLayer")
				.field("new_shape_desc", &crate::dnn::ReshapeLayerTraitConst::new_shape_desc(self))
				.field("new_shape_range", &crate::dnn::ReshapeLayerTraitConst::new_shape_range(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ResizeLayer,
		cv_PtrLcv_dnn_ResizeLayerG_new_null_const, cv_PtrLcv_dnn_ResizeLayerG_delete, cv_PtrLcv_dnn_ResizeLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ResizeLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ResizeLayer, cv_PtrLcv_dnn_ResizeLayerG_new_const_ResizeLayer }
	impl core::Ptr<crate::dnn::ResizeLayer> {
		#[inline] pub fn as_raw_PtrOfResizeLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfResizeLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ResizeLayerTraitConst for core::Ptr<crate::dnn::ResizeLayer> {
		#[inline] fn as_raw_ResizeLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ResizeLayerTrait for core::Ptr<crate::dnn::ResizeLayer> {
		#[inline] fn as_raw_mut_ResizeLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ResizeLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ResizeLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ResizeLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ResizeLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ResizeLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ResizeLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ResizeLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ResizeLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ResizeLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfResizeLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::RoundLayer,
		cv_PtrLcv_dnn_RoundLayerG_new_null_const, cv_PtrLcv_dnn_RoundLayerG_delete, cv_PtrLcv_dnn_RoundLayerG_getInnerPtr_const, cv_PtrLcv_dnn_RoundLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::RoundLayer, cv_PtrLcv_dnn_RoundLayerG_new_const_RoundLayer }
	impl core::Ptr<crate::dnn::RoundLayer> {
		#[inline] pub fn as_raw_PtrOfRoundLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRoundLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::RoundLayerTraitConst for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_RoundLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::RoundLayerTrait for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_mut_RoundLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RoundLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_RoundLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RoundLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_RoundLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::RoundLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::RoundLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_RoundLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::RoundLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRoundLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ScaleLayer,
		cv_PtrLcv_dnn_ScaleLayerG_new_null_const, cv_PtrLcv_dnn_ScaleLayerG_delete, cv_PtrLcv_dnn_ScaleLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ScaleLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ScaleLayer, cv_PtrLcv_dnn_ScaleLayerG_new_const_ScaleLayer }
	impl core::Ptr<crate::dnn::ScaleLayer> {
		#[inline] pub fn as_raw_PtrOfScaleLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfScaleLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ScaleLayerTraitConst for core::Ptr<crate::dnn::ScaleLayer> {
		#[inline] fn as_raw_ScaleLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ScaleLayerTrait for core::Ptr<crate::dnn::ScaleLayer> {
		#[inline] fn as_raw_mut_ScaleLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ScaleLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ScaleLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScaleLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ScaleLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ScaleLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ScaleLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScaleLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ScaleLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ScaleLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfScaleLayer")
				.field("has_bias", &crate::dnn::ScaleLayerTraitConst::has_bias(self))
				.field("axis", &crate::dnn::ScaleLayerTraitConst::axis(self))
				.field("mode", &crate::dnn::ScaleLayerTraitConst::mode(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ScaleLayerInt8,
		cv_PtrLcv_dnn_ScaleLayerInt8G_new_null_const, cv_PtrLcv_dnn_ScaleLayerInt8G_delete, cv_PtrLcv_dnn_ScaleLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_ScaleLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ScaleLayerInt8, cv_PtrLcv_dnn_ScaleLayerInt8G_new_const_ScaleLayerInt8 }
	impl core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] pub fn as_raw_PtrOfScaleLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfScaleLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ScaleLayerInt8TraitConst for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_ScaleLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ScaleLayerInt8Trait for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_mut_ScaleLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScaleLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ScaleLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScaleLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ScaleLayerInt8G_to_PtrOfLayer }

	impl crate::dnn::ScaleLayerTraitConst for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_ScaleLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ScaleLayerTrait for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline] fn as_raw_mut_ScaleLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScaleLayerInt8>, core::Ptr<crate::dnn::ScaleLayer>, cv_PtrLcv_dnn_ScaleLayerInt8G_to_PtrOfScaleLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ScaleLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfScaleLayerInt8")
				.field("output_sc", &crate::dnn::ScaleLayerInt8TraitConst::output_sc(self))
				.field("output_zp", &crate::dnn::ScaleLayerInt8TraitConst::output_zp(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.field("has_bias", &crate::dnn::ScaleLayerTraitConst::has_bias(self))
				.field("axis", &crate::dnn::ScaleLayerTraitConst::axis(self))
				.field("mode", &crate::dnn::ScaleLayerTraitConst::mode(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ScatterLayer,
		cv_PtrLcv_dnn_ScatterLayerG_new_null_const, cv_PtrLcv_dnn_ScatterLayerG_delete, cv_PtrLcv_dnn_ScatterLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ScatterLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ScatterLayer, cv_PtrLcv_dnn_ScatterLayerG_new_const_ScatterLayer }
	impl core::Ptr<crate::dnn::ScatterLayer> {
		#[inline] pub fn as_raw_PtrOfScatterLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfScatterLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ScatterLayerTraitConst for core::Ptr<crate::dnn::ScatterLayer> {
		#[inline] fn as_raw_ScatterLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ScatterLayerTrait for core::Ptr<crate::dnn::ScatterLayer> {
		#[inline] fn as_raw_mut_ScatterLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ScatterLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ScatterLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScatterLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ScatterLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ScatterLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ScatterLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScatterLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ScatterLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ScatterLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfScatterLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ScatterNDLayer,
		cv_PtrLcv_dnn_ScatterNDLayerG_new_null_const, cv_PtrLcv_dnn_ScatterNDLayerG_delete, cv_PtrLcv_dnn_ScatterNDLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ScatterNDLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ScatterNDLayer, cv_PtrLcv_dnn_ScatterNDLayerG_new_const_ScatterNDLayer }
	impl core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline] pub fn as_raw_PtrOfScatterNDLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfScatterNDLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ScatterNDLayerTraitConst for core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline] fn as_raw_ScatterNDLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ScatterNDLayerTrait for core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline] fn as_raw_mut_ScatterNDLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScatterNDLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ScatterNDLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ScatterNDLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ScatterNDLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ScatterNDLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfScatterNDLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SeluLayer,
		cv_PtrLcv_dnn_SeluLayerG_new_null_const, cv_PtrLcv_dnn_SeluLayerG_delete, cv_PtrLcv_dnn_SeluLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SeluLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SeluLayer, cv_PtrLcv_dnn_SeluLayerG_new_const_SeluLayer }
	impl core::Ptr<crate::dnn::SeluLayer> {
		#[inline] pub fn as_raw_PtrOfSeluLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSeluLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SeluLayerTraitConst for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_SeluLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SeluLayerTrait for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_mut_SeluLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SeluLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SeluLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SeluLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SeluLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SeluLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SeluLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SeluLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SeluLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSeluLayer")
				.field("alpha", &crate::dnn::SeluLayerTraitConst::alpha(self))
				.field("gamma", &crate::dnn::SeluLayerTraitConst::gamma(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ShiftLayer,
		cv_PtrLcv_dnn_ShiftLayerG_new_null_const, cv_PtrLcv_dnn_ShiftLayerG_delete, cv_PtrLcv_dnn_ShiftLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ShiftLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ShiftLayer, cv_PtrLcv_dnn_ShiftLayerG_new_const_ShiftLayer }
	impl core::Ptr<crate::dnn::ShiftLayer> {
		#[inline] pub fn as_raw_PtrOfShiftLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfShiftLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ShiftLayerTraitConst for core::Ptr<crate::dnn::ShiftLayer> {
		#[inline] fn as_raw_ShiftLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ShiftLayerTrait for core::Ptr<crate::dnn::ShiftLayer> {
		#[inline] fn as_raw_mut_ShiftLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ShiftLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ShiftLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShiftLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ShiftLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ShiftLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ShiftLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShiftLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ShiftLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ShiftLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfShiftLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ShiftLayerInt8,
		cv_PtrLcv_dnn_ShiftLayerInt8G_new_null_const, cv_PtrLcv_dnn_ShiftLayerInt8G_delete, cv_PtrLcv_dnn_ShiftLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_ShiftLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ShiftLayerInt8, cv_PtrLcv_dnn_ShiftLayerInt8G_new_const_ShiftLayerInt8 }
	impl core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline] pub fn as_raw_PtrOfShiftLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfShiftLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ShiftLayerInt8TraitConst for core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline] fn as_raw_ShiftLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ShiftLayerInt8Trait for core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline] fn as_raw_mut_ShiftLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShiftLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ShiftLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShiftLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ShiftLayerInt8G_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ShiftLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfShiftLayerInt8")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ShrinkLayer,
		cv_PtrLcv_dnn_ShrinkLayerG_new_null_const, cv_PtrLcv_dnn_ShrinkLayerG_delete, cv_PtrLcv_dnn_ShrinkLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ShrinkLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ShrinkLayer, cv_PtrLcv_dnn_ShrinkLayerG_new_const_ShrinkLayer }
	impl core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] pub fn as_raw_PtrOfShrinkLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfShrinkLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ShrinkLayerTraitConst for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_ShrinkLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ShrinkLayerTrait for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_mut_ShrinkLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShrinkLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ShrinkLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShrinkLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ShrinkLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShrinkLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ShrinkLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ShrinkLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfShrinkLayer")
				.field("bias", &crate::dnn::ShrinkLayerTraitConst::bias(self))
				.field("lambd", &crate::dnn::ShrinkLayerTraitConst::lambd(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ShuffleChannelLayer,
		cv_PtrLcv_dnn_ShuffleChannelLayerG_new_null_const, cv_PtrLcv_dnn_ShuffleChannelLayerG_delete, cv_PtrLcv_dnn_ShuffleChannelLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ShuffleChannelLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ShuffleChannelLayer, cv_PtrLcv_dnn_ShuffleChannelLayerG_new_const_ShuffleChannelLayer }
	impl core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline] pub fn as_raw_PtrOfShuffleChannelLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfShuffleChannelLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ShuffleChannelLayerTraitConst for core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline] fn as_raw_ShuffleChannelLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ShuffleChannelLayerTrait for core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline] fn as_raw_mut_ShuffleChannelLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShuffleChannelLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ShuffleChannelLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ShuffleChannelLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ShuffleChannelLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ShuffleChannelLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfShuffleChannelLayer")
				.field("group", &crate::dnn::ShuffleChannelLayerTraitConst::group(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SigmoidLayer,
		cv_PtrLcv_dnn_SigmoidLayerG_new_null_const, cv_PtrLcv_dnn_SigmoidLayerG_delete, cv_PtrLcv_dnn_SigmoidLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SigmoidLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SigmoidLayer, cv_PtrLcv_dnn_SigmoidLayerG_new_const_SigmoidLayer }
	impl core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] pub fn as_raw_PtrOfSigmoidLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSigmoidLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SigmoidLayerTraitConst for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_SigmoidLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SigmoidLayerTrait for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_mut_SigmoidLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SigmoidLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SigmoidLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SigmoidLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SigmoidLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SigmoidLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SigmoidLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SigmoidLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSigmoidLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SignLayer,
		cv_PtrLcv_dnn_SignLayerG_new_null_const, cv_PtrLcv_dnn_SignLayerG_delete, cv_PtrLcv_dnn_SignLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SignLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SignLayer, cv_PtrLcv_dnn_SignLayerG_new_const_SignLayer }
	impl core::Ptr<crate::dnn::SignLayer> {
		#[inline] pub fn as_raw_PtrOfSignLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSignLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SignLayerTraitConst for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_SignLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SignLayerTrait for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_mut_SignLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SignLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SignLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SignLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SignLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SignLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SignLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SignLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SignLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSignLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SinLayer,
		cv_PtrLcv_dnn_SinLayerG_new_null_const, cv_PtrLcv_dnn_SinLayerG_delete, cv_PtrLcv_dnn_SinLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SinLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SinLayer, cv_PtrLcv_dnn_SinLayerG_new_const_SinLayer }
	impl core::Ptr<crate::dnn::SinLayer> {
		#[inline] pub fn as_raw_PtrOfSinLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSinLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SinLayerTraitConst for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_SinLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SinLayerTrait for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_mut_SinLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SinLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SinLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SinLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SinLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SinLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SinLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SinLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SinLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSinLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SinhLayer,
		cv_PtrLcv_dnn_SinhLayerG_new_null_const, cv_PtrLcv_dnn_SinhLayerG_delete, cv_PtrLcv_dnn_SinhLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SinhLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SinhLayer, cv_PtrLcv_dnn_SinhLayerG_new_const_SinhLayer }
	impl core::Ptr<crate::dnn::SinhLayer> {
		#[inline] pub fn as_raw_PtrOfSinhLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSinhLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SinhLayerTraitConst for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_SinhLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SinhLayerTrait for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_mut_SinhLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SinhLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SinhLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SinhLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SinhLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SinhLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SinhLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SinhLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SinhLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSinhLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SliceLayer,
		cv_PtrLcv_dnn_SliceLayerG_new_null_const, cv_PtrLcv_dnn_SliceLayerG_delete, cv_PtrLcv_dnn_SliceLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SliceLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SliceLayer, cv_PtrLcv_dnn_SliceLayerG_new_const_SliceLayer }
	impl core::Ptr<crate::dnn::SliceLayer> {
		#[inline] pub fn as_raw_PtrOfSliceLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSliceLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SliceLayerTraitConst for core::Ptr<crate::dnn::SliceLayer> {
		#[inline] fn as_raw_SliceLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SliceLayerTrait for core::Ptr<crate::dnn::SliceLayer> {
		#[inline] fn as_raw_mut_SliceLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SliceLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SliceLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SliceLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SliceLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SliceLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SliceLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SliceLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SliceLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SliceLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSliceLayer")
				.field("slice_ranges", &crate::dnn::SliceLayerTraitConst::slice_ranges(self))
				.field("slice_steps", &crate::dnn::SliceLayerTraitConst::slice_steps(self))
				.field("axis", &crate::dnn::SliceLayerTraitConst::axis(self))
				.field("num_split", &crate::dnn::SliceLayerTraitConst::num_split(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SoftmaxLayer,
		cv_PtrLcv_dnn_SoftmaxLayerG_new_null_const, cv_PtrLcv_dnn_SoftmaxLayerG_delete, cv_PtrLcv_dnn_SoftmaxLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SoftmaxLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SoftmaxLayer, cv_PtrLcv_dnn_SoftmaxLayerG_new_const_SoftmaxLayer }
	impl core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline] pub fn as_raw_PtrOfSoftmaxLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSoftmaxLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SoftmaxLayerTraitConst for core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline] fn as_raw_SoftmaxLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SoftmaxLayerTrait for core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline] fn as_raw_mut_SoftmaxLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftmaxLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SoftmaxLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftmaxLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SoftmaxLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SoftmaxLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSoftmaxLayer")
				.field("log_soft_max", &crate::dnn::SoftmaxLayerTraitConst::log_soft_max(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SoftmaxLayerInt8,
		cv_PtrLcv_dnn_SoftmaxLayerInt8G_new_null_const, cv_PtrLcv_dnn_SoftmaxLayerInt8G_delete, cv_PtrLcv_dnn_SoftmaxLayerInt8G_getInnerPtr_const, cv_PtrLcv_dnn_SoftmaxLayerInt8G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SoftmaxLayerInt8, cv_PtrLcv_dnn_SoftmaxLayerInt8G_new_const_SoftmaxLayerInt8 }
	impl core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] pub fn as_raw_PtrOfSoftmaxLayerInt8(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSoftmaxLayerInt8(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SoftmaxLayerInt8TraitConst for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_SoftmaxLayerInt8(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SoftmaxLayerInt8Trait for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_mut_SoftmaxLayerInt8(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftmaxLayerInt8>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SoftmaxLayerInt8G_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftmaxLayerInt8>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SoftmaxLayerInt8G_to_PtrOfLayer }

	impl crate::dnn::SoftmaxLayerTraitConst for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_SoftmaxLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SoftmaxLayerTrait for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline] fn as_raw_mut_SoftmaxLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftmaxLayerInt8>, core::Ptr<crate::dnn::SoftmaxLayer>, cv_PtrLcv_dnn_SoftmaxLayerInt8G_to_PtrOfSoftmaxLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SoftmaxLayerInt8> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSoftmaxLayerInt8")
				.field("output_sc", &crate::dnn::SoftmaxLayerInt8TraitConst::output_sc(self))
				.field("output_zp", &crate::dnn::SoftmaxLayerInt8TraitConst::output_zp(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.field("log_soft_max", &crate::dnn::SoftmaxLayerTraitConst::log_soft_max(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SoftplusLayer,
		cv_PtrLcv_dnn_SoftplusLayerG_new_null_const, cv_PtrLcv_dnn_SoftplusLayerG_delete, cv_PtrLcv_dnn_SoftplusLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SoftplusLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SoftplusLayer, cv_PtrLcv_dnn_SoftplusLayerG_new_const_SoftplusLayer }
	impl core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] pub fn as_raw_PtrOfSoftplusLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSoftplusLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SoftplusLayerTraitConst for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_SoftplusLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SoftplusLayerTrait for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_mut_SoftplusLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftplusLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SoftplusLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftplusLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SoftplusLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftplusLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SoftplusLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SoftplusLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSoftplusLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SoftsignLayer,
		cv_PtrLcv_dnn_SoftsignLayerG_new_null_const, cv_PtrLcv_dnn_SoftsignLayerG_delete, cv_PtrLcv_dnn_SoftsignLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SoftsignLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SoftsignLayer, cv_PtrLcv_dnn_SoftsignLayerG_new_const_SoftsignLayer }
	impl core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] pub fn as_raw_PtrOfSoftsignLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSoftsignLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SoftsignLayerTraitConst for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_SoftsignLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SoftsignLayerTrait for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_mut_SoftsignLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftsignLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SoftsignLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftsignLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SoftsignLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SoftsignLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SoftsignLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SoftsignLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSoftsignLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SpaceToDepthLayer,
		cv_PtrLcv_dnn_SpaceToDepthLayerG_new_null_const, cv_PtrLcv_dnn_SpaceToDepthLayerG_delete, cv_PtrLcv_dnn_SpaceToDepthLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SpaceToDepthLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SpaceToDepthLayer, cv_PtrLcv_dnn_SpaceToDepthLayerG_new_const_SpaceToDepthLayer }
	impl core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline] pub fn as_raw_PtrOfSpaceToDepthLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSpaceToDepthLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SpaceToDepthLayerTraitConst for core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline] fn as_raw_SpaceToDepthLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SpaceToDepthLayerTrait for core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline] fn as_raw_mut_SpaceToDepthLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SpaceToDepthLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SpaceToDepthLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SpaceToDepthLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SpaceToDepthLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SpaceToDepthLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSpaceToDepthLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SplitLayer,
		cv_PtrLcv_dnn_SplitLayerG_new_null_const, cv_PtrLcv_dnn_SplitLayerG_delete, cv_PtrLcv_dnn_SplitLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SplitLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SplitLayer, cv_PtrLcv_dnn_SplitLayerG_new_const_SplitLayer }
	impl core::Ptr<crate::dnn::SplitLayer> {
		#[inline] pub fn as_raw_PtrOfSplitLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSplitLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SplitLayerTraitConst for core::Ptr<crate::dnn::SplitLayer> {
		#[inline] fn as_raw_SplitLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SplitLayerTrait for core::Ptr<crate::dnn::SplitLayer> {
		#[inline] fn as_raw_mut_SplitLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SplitLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SplitLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SplitLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SplitLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SplitLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SplitLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SplitLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SplitLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SplitLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSplitLayer")
				.field("outputs_count", &crate::dnn::SplitLayerTraitConst::outputs_count(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SqrtLayer,
		cv_PtrLcv_dnn_SqrtLayerG_new_null_const, cv_PtrLcv_dnn_SqrtLayerG_delete, cv_PtrLcv_dnn_SqrtLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SqrtLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SqrtLayer, cv_PtrLcv_dnn_SqrtLayerG_new_const_SqrtLayer }
	impl core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] pub fn as_raw_PtrOfSqrtLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSqrtLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SqrtLayerTraitConst for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_SqrtLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SqrtLayerTrait for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_mut_SqrtLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SqrtLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SqrtLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SqrtLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SqrtLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SqrtLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SqrtLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SqrtLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSqrtLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::SwishLayer,
		cv_PtrLcv_dnn_SwishLayerG_new_null_const, cv_PtrLcv_dnn_SwishLayerG_delete, cv_PtrLcv_dnn_SwishLayerG_getInnerPtr_const, cv_PtrLcv_dnn_SwishLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::SwishLayer, cv_PtrLcv_dnn_SwishLayerG_new_const_SwishLayer }
	impl core::Ptr<crate::dnn::SwishLayer> {
		#[inline] pub fn as_raw_PtrOfSwishLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSwishLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::SwishLayerTraitConst for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_SwishLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::SwishLayerTrait for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_mut_SwishLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SwishLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_SwishLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SwishLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_SwishLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::SwishLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::SwishLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_SwishLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::SwishLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSwishLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::TanHLayer,
		cv_PtrLcv_dnn_TanHLayerG_new_null_const, cv_PtrLcv_dnn_TanHLayerG_delete, cv_PtrLcv_dnn_TanHLayerG_getInnerPtr_const, cv_PtrLcv_dnn_TanHLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::TanHLayer, cv_PtrLcv_dnn_TanHLayerG_new_const_TanHLayer }
	impl core::Ptr<crate::dnn::TanHLayer> {
		#[inline] pub fn as_raw_PtrOfTanHLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTanHLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::TanHLayerTraitConst for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_TanHLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::TanHLayerTrait for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_mut_TanHLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TanHLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_TanHLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TanHLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_TanHLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::TanHLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TanHLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_TanHLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::TanHLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTanHLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::TanLayer,
		cv_PtrLcv_dnn_TanLayerG_new_null_const, cv_PtrLcv_dnn_TanLayerG_delete, cv_PtrLcv_dnn_TanLayerG_getInnerPtr_const, cv_PtrLcv_dnn_TanLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::TanLayer, cv_PtrLcv_dnn_TanLayerG_new_const_TanLayer }
	impl core::Ptr<crate::dnn::TanLayer> {
		#[inline] pub fn as_raw_PtrOfTanLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTanLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::TanLayerTraitConst for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_TanLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::TanLayerTrait for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_mut_TanLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TanLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_TanLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TanLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_TanLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::TanLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TanLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_TanLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::TanLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTanLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::ThresholdedReluLayer,
		cv_PtrLcv_dnn_ThresholdedReluLayerG_new_null_const, cv_PtrLcv_dnn_ThresholdedReluLayerG_delete, cv_PtrLcv_dnn_ThresholdedReluLayerG_getInnerPtr_const, cv_PtrLcv_dnn_ThresholdedReluLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::ThresholdedReluLayer, cv_PtrLcv_dnn_ThresholdedReluLayerG_new_const_ThresholdedReluLayer }
	impl core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] pub fn as_raw_PtrOfThresholdedReluLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfThresholdedReluLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::ThresholdedReluLayerTraitConst for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_ThresholdedReluLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ThresholdedReluLayerTrait for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_mut_ThresholdedReluLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ThresholdedReluLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_ThresholdedReluLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::ActivationLayerTraitConst for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_ActivationLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::ActivationLayerTrait for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_mut_ActivationLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ThresholdedReluLayer>, core::Ptr<crate::dnn::ActivationLayer>, cv_PtrLcv_dnn_ThresholdedReluLayerG_to_PtrOfActivationLayer }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::ThresholdedReluLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_ThresholdedReluLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::ThresholdedReluLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfThresholdedReluLayer")
				.field("alpha", &crate::dnn::ThresholdedReluLayerTraitConst::alpha(self))
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::TileLayer,
		cv_PtrLcv_dnn_TileLayerG_new_null_const, cv_PtrLcv_dnn_TileLayerG_delete, cv_PtrLcv_dnn_TileLayerG_getInnerPtr_const, cv_PtrLcv_dnn_TileLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::TileLayer, cv_PtrLcv_dnn_TileLayerG_new_const_TileLayer }
	impl core::Ptr<crate::dnn::TileLayer> {
		#[inline] pub fn as_raw_PtrOfTileLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTileLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::TileLayerTraitConst for core::Ptr<crate::dnn::TileLayer> {
		#[inline] fn as_raw_TileLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::TileLayerTrait for core::Ptr<crate::dnn::TileLayer> {
		#[inline] fn as_raw_mut_TileLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::TileLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::TileLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TileLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_TileLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::TileLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::TileLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TileLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_TileLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::TileLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTileLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	ptr_extern! { crate::dnn::TopKLayer,
		cv_PtrLcv_dnn_TopKLayerG_new_null_const, cv_PtrLcv_dnn_TopKLayerG_delete, cv_PtrLcv_dnn_TopKLayerG_getInnerPtr_const, cv_PtrLcv_dnn_TopKLayerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn::TopKLayer, cv_PtrLcv_dnn_TopKLayerG_new_const_TopKLayer }
	impl core::Ptr<crate::dnn::TopKLayer> {
		#[inline] pub fn as_raw_PtrOfTopKLayer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTopKLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn::TopKLayerTraitConst for core::Ptr<crate::dnn::TopKLayer> {
		#[inline] fn as_raw_TopKLayer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::TopKLayerTrait for core::Ptr<crate::dnn::TopKLayer> {
		#[inline] fn as_raw_mut_TopKLayer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::dnn::TopKLayer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::dnn::TopKLayer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TopKLayer>, core::Ptr<core::Algorithm>, cv_PtrLcv_dnn_TopKLayerG_to_PtrOfAlgorithm }

	impl crate::dnn::LayerTraitConst for core::Ptr<crate::dnn::TopKLayer> {
		#[inline] fn as_raw_Layer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn::LayerTrait for core::Ptr<crate::dnn::TopKLayer> {
		#[inline] fn as_raw_mut_Layer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::dnn::TopKLayer>, core::Ptr<crate::dnn::Layer>, cv_PtrLcv_dnn_TopKLayerG_to_PtrOfLayer }

	impl std::fmt::Debug for core::Ptr<crate::dnn::TopKLayer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTopKLayer")
				.field("blobs", &crate::dnn::LayerTraitConst::blobs(self))
				.field("name", &crate::dnn::LayerTraitConst::name(self))
				.field("typ", &crate::dnn::LayerTraitConst::typ(self))
				.field("preferable_target", &crate::dnn::LayerTraitConst::preferable_target(self))
				.finish()
		}
	}

	impl core::Tuple<(crate::dnn::Backend, crate::dnn::Target)> {
		pub fn as_raw_TupleOfBackend_Target(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfBackend_Target(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (crate::dnn::Backend, crate::dnn::Target),
		std_pairLcv_dnn_Backend__cv_dnn_TargetG_new_const_Backend_Target, std_pairLcv_dnn_Backend__cv_dnn_TargetG_delete,
		0 = arg: crate::dnn::Backend, get_0 via std_pairLcv_dnn_Backend__cv_dnn_TargetG_get_0_const,
		1 = arg_1: crate::dnn::Target, get_1 via std_pairLcv_dnn_Backend__cv_dnn_TargetG_get_1_const
	}

	impl core::Vector<crate::dnn::MatShape> {
		pub fn as_raw_VectorOfMatShape(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfMatShape(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl core::Vector<core::Ptr<crate::dnn::BackendNode>> {
		pub fn as_raw_VectorOfPtrOfBackendNode(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPtrOfBackendNode(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Ptr<crate::dnn::BackendNode>,
		std_vectorLcv_PtrLcv_dnn_BackendNodeGG_new_const, std_vectorLcv_PtrLcv_dnn_BackendNodeGG_delete,
		std_vectorLcv_PtrLcv_dnn_BackendNodeGG_len_const, std_vectorLcv_PtrLcv_dnn_BackendNodeGG_isEmpty_const,
		std_vectorLcv_PtrLcv_dnn_BackendNodeGG_capacity_const, std_vectorLcv_PtrLcv_dnn_BackendNodeGG_shrinkToFit,
		std_vectorLcv_PtrLcv_dnn_BackendNodeGG_reserve_size_t, std_vectorLcv_PtrLcv_dnn_BackendNodeGG_remove_size_t,
		std_vectorLcv_PtrLcv_dnn_BackendNodeGG_swap_size_t_size_t, std_vectorLcv_PtrLcv_dnn_BackendNodeGG_clear,
		std_vectorLcv_PtrLcv_dnn_BackendNodeGG_get_const_size_t, std_vectorLcv_PtrLcv_dnn_BackendNodeGG_set_size_t_const_PtrLBackendNodeG,
		std_vectorLcv_PtrLcv_dnn_BackendNodeGG_push_const_PtrLBackendNodeG, std_vectorLcv_PtrLcv_dnn_BackendNodeGG_insert_size_t_const_PtrLBackendNodeG,
	}

	vector_non_copy_or_bool! { core::Ptr<crate::dnn::BackendNode> }


	impl core::Vector<core::Ptr<crate::dnn::BackendWrapper>> {
		pub fn as_raw_VectorOfPtrOfBackendWrapper(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPtrOfBackendWrapper(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Ptr<crate::dnn::BackendWrapper>,
		std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_new_const, std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_delete,
		std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_len_const, std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_isEmpty_const,
		std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_capacity_const, std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_shrinkToFit,
		std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_reserve_size_t, std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_remove_size_t,
		std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_swap_size_t_size_t, std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_clear,
		std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_get_const_size_t, std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_set_size_t_const_PtrLBackendWrapperG,
		std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_push_const_PtrLBackendWrapperG, std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_insert_size_t_const_PtrLBackendWrapperG,
	}

	vector_non_copy_or_bool! { core::Ptr<crate::dnn::BackendWrapper> }


	impl core::Vector<core::Ptr<crate::dnn::Layer>> {
		pub fn as_raw_VectorOfPtrOfLayer(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPtrOfLayer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Ptr<crate::dnn::Layer>,
		std_vectorLcv_PtrLcv_dnn_LayerGG_new_const, std_vectorLcv_PtrLcv_dnn_LayerGG_delete,
		std_vectorLcv_PtrLcv_dnn_LayerGG_len_const, std_vectorLcv_PtrLcv_dnn_LayerGG_isEmpty_const,
		std_vectorLcv_PtrLcv_dnn_LayerGG_capacity_const, std_vectorLcv_PtrLcv_dnn_LayerGG_shrinkToFit,
		std_vectorLcv_PtrLcv_dnn_LayerGG_reserve_size_t, std_vectorLcv_PtrLcv_dnn_LayerGG_remove_size_t,
		std_vectorLcv_PtrLcv_dnn_LayerGG_swap_size_t_size_t, std_vectorLcv_PtrLcv_dnn_LayerGG_clear,
		std_vectorLcv_PtrLcv_dnn_LayerGG_get_const_size_t, std_vectorLcv_PtrLcv_dnn_LayerGG_set_size_t_const_PtrLLayerG,
		std_vectorLcv_PtrLcv_dnn_LayerGG_push_const_PtrLLayerG, std_vectorLcv_PtrLcv_dnn_LayerGG_insert_size_t_const_PtrLLayerG,
	}

	vector_non_copy_or_bool! { core::Ptr<crate::dnn::Layer> }


	impl core::Vector<crate::dnn::Target> {
		pub fn as_raw_VectorOfTarget(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfTarget(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::dnn::Target,
		std_vectorLcv_dnn_TargetG_new_const, std_vectorLcv_dnn_TargetG_delete,
		std_vectorLcv_dnn_TargetG_len_const, std_vectorLcv_dnn_TargetG_isEmpty_const,
		std_vectorLcv_dnn_TargetG_capacity_const, std_vectorLcv_dnn_TargetG_shrinkToFit,
		std_vectorLcv_dnn_TargetG_reserve_size_t, std_vectorLcv_dnn_TargetG_remove_size_t,
		std_vectorLcv_dnn_TargetG_swap_size_t_size_t, std_vectorLcv_dnn_TargetG_clear,
		std_vectorLcv_dnn_TargetG_get_const_size_t, std_vectorLcv_dnn_TargetG_set_size_t_const_Target,
		std_vectorLcv_dnn_TargetG_push_const_Target, std_vectorLcv_dnn_TargetG_insert_size_t_const_Target,
	}

	vector_copy_non_bool! { crate::dnn::Target,
		std_vectorLcv_dnn_TargetG_data_const, std_vectorLcv_dnn_TargetG_dataMut, cv_fromSlice_const_const_TargetX_size_t,
		std_vectorLcv_dnn_TargetG_clone_const,
	}


	impl core::Vector<core::Tuple<(crate::dnn::Backend, crate::dnn::Target)>> {
		pub fn as_raw_VectorOfTupleOfBackend_Target(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfTupleOfBackend_Target(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Tuple<(crate::dnn::Backend, crate::dnn::Target)>,
		std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_new_const, std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_delete,
		std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_len_const, std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_isEmpty_const,
		std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_capacity_const, std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_shrinkToFit,
		std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_reserve_size_t, std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_remove_size_t,
		std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_swap_size_t_size_t, std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_clear,
		std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_get_const_size_t, std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_set_size_t_const_pairLcv_dnn_Backend__cv_dnn_TargetG,
		std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_push_const_pairLcv_dnn_Backend__cv_dnn_TargetG, std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_insert_size_t_const_pairLcv_dnn_Backend__cv_dnn_TargetG,
	}

	vector_non_copy_or_bool! { core::Tuple<(crate::dnn::Backend, crate::dnn::Target)> }


	impl core::Vector<core::Vector<crate::dnn::MatShape>> {
		pub fn as_raw_VectorOfVectorOfMatShape(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfMatShape(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<crate::dnn::MatShape>,
		std_vectorLstd_vectorLcv_dnn_MatShapeGG_new_const, std_vectorLstd_vectorLcv_dnn_MatShapeGG_delete,
		std_vectorLstd_vectorLcv_dnn_MatShapeGG_len_const, std_vectorLstd_vectorLcv_dnn_MatShapeGG_isEmpty_const,
		std_vectorLstd_vectorLcv_dnn_MatShapeGG_capacity_const, std_vectorLstd_vectorLcv_dnn_MatShapeGG_shrinkToFit,
		std_vectorLstd_vectorLcv_dnn_MatShapeGG_reserve_size_t, std_vectorLstd_vectorLcv_dnn_MatShapeGG_remove_size_t,
		std_vectorLstd_vectorLcv_dnn_MatShapeGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_dnn_MatShapeGG_clear,
		std_vectorLstd_vectorLcv_dnn_MatShapeGG_get_const_size_t, std_vectorLstd_vectorLcv_dnn_MatShapeGG_set_size_t_const_vectorLMatShapeG,
		std_vectorLstd_vectorLcv_dnn_MatShapeGG_push_const_vectorLMatShapeG, std_vectorLstd_vectorLcv_dnn_MatShapeGG_insert_size_t_const_vectorLMatShapeG,
	}

	vector_non_copy_or_bool! { core::Vector<crate::dnn::MatShape> }


}
pub use dnn_types::*;

mod dnn_superres_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::dnn_superres::DnnSuperResImpl,
		cv_PtrLcv_dnn_superres_DnnSuperResImplG_new_null_const, cv_PtrLcv_dnn_superres_DnnSuperResImplG_delete, cv_PtrLcv_dnn_superres_DnnSuperResImplG_getInnerPtr_const, cv_PtrLcv_dnn_superres_DnnSuperResImplG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::dnn_superres::DnnSuperResImpl, cv_PtrLcv_dnn_superres_DnnSuperResImplG_new_const_DnnSuperResImpl }
	impl core::Ptr<crate::dnn_superres::DnnSuperResImpl> {
		#[inline] pub fn as_raw_PtrOfDnnSuperResImpl(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDnnSuperResImpl(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dnn_superres::DnnSuperResImplTraitConst for core::Ptr<crate::dnn_superres::DnnSuperResImpl> {
		#[inline] fn as_raw_DnnSuperResImpl(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dnn_superres::DnnSuperResImplTrait for core::Ptr<crate::dnn_superres::DnnSuperResImpl> {
		#[inline] fn as_raw_mut_DnnSuperResImpl(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::dnn_superres::DnnSuperResImpl> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDnnSuperResImpl")
				.finish()
		}
	}

}
pub use dnn_superres_types::*;

mod dpm_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::dpm::DPMDetector,
		cv_PtrLcv_dpm_DPMDetectorG_new_null_const, cv_PtrLcv_dpm_DPMDetectorG_delete, cv_PtrLcv_dpm_DPMDetectorG_getInnerPtr_const, cv_PtrLcv_dpm_DPMDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::dpm::DPMDetector> {
		#[inline] pub fn as_raw_PtrOfDPMDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDPMDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::dpm::DPMDetectorTraitConst for core::Ptr<crate::dpm::DPMDetector> {
		#[inline] fn as_raw_DPMDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::dpm::DPMDetectorTrait for core::Ptr<crate::dpm::DPMDetector> {
		#[inline] fn as_raw_mut_DPMDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::dpm::DPMDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDPMDetector")
				.finish()
		}
	}

	impl core::Vector<crate::dpm::DPMDetector_ObjectDetection> {
		pub fn as_raw_VectorOfDPMDetector_ObjectDetection(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDPMDetector_ObjectDetection(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::dpm::DPMDetector_ObjectDetection,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_new_const, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_delete,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_len_const, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_isEmpty_const,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_capacity_const, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_shrinkToFit,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_reserve_size_t, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_remove_size_t,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_swap_size_t_size_t, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_clear,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_get_const_size_t, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_set_size_t_const_ObjectDetection,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_push_const_ObjectDetection, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_insert_size_t_const_ObjectDetection,
	}

	vector_non_copy_or_bool! { crate::dpm::DPMDetector_ObjectDetection }

	vector_boxed_ref! { crate::dpm::DPMDetector_ObjectDetection }

	vector_extern! { BoxedRef<'t, crate::dpm::DPMDetector_ObjectDetection>,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_new_const, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_delete,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_len_const, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_isEmpty_const,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_capacity_const, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_shrinkToFit,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_reserve_size_t, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_remove_size_t,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_swap_size_t_size_t, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_clear,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_get_const_size_t, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_set_size_t_const_ObjectDetection,
		std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_push_const_ObjectDetection, std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_insert_size_t_const_ObjectDetection,
	}


}
pub use dpm_types::*;

mod face_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::face::BIF,
		cv_PtrLcv_face_BIFG_new_null_const, cv_PtrLcv_face_BIFG_delete, cv_PtrLcv_face_BIFG_getInnerPtr_const, cv_PtrLcv_face_BIFG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::BIF> {
		#[inline] pub fn as_raw_PtrOfBIF(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBIF(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::BIFTraitConst for core::Ptr<crate::face::BIF> {
		#[inline] fn as_raw_BIF(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::BIFTrait for core::Ptr<crate::face::BIF> {
		#[inline] fn as_raw_mut_BIF(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::BIF> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::BIF> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::BIF>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_BIFG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::face::BIF> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBIF")
				.finish()
		}
	}

	ptr_extern! { crate::face::BasicFaceRecognizer,
		cv_PtrLcv_face_BasicFaceRecognizerG_new_null_const, cv_PtrLcv_face_BasicFaceRecognizerG_delete, cv_PtrLcv_face_BasicFaceRecognizerG_getInnerPtr_const, cv_PtrLcv_face_BasicFaceRecognizerG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline] pub fn as_raw_PtrOfBasicFaceRecognizer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBasicFaceRecognizer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::BasicFaceRecognizerTraitConst for core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline] fn as_raw_BasicFaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::BasicFaceRecognizerTrait for core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline] fn as_raw_mut_BasicFaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::BasicFaceRecognizer>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_BasicFaceRecognizerG_to_PtrOfAlgorithm }

	impl crate::face::FaceRecognizerTraitConst for core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline] fn as_raw_FaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FaceRecognizerTrait for core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline] fn as_raw_mut_FaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::BasicFaceRecognizer>, core::Ptr<crate::face::FaceRecognizer>, cv_PtrLcv_face_BasicFaceRecognizerG_to_PtrOfFaceRecognizer }

	impl std::fmt::Debug for core::Ptr<crate::face::BasicFaceRecognizer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBasicFaceRecognizer")
				.finish()
		}
	}

	ptr_extern! { crate::face::EigenFaceRecognizer,
		cv_PtrLcv_face_EigenFaceRecognizerG_new_null_const, cv_PtrLcv_face_EigenFaceRecognizerG_delete, cv_PtrLcv_face_EigenFaceRecognizerG_getInnerPtr_const, cv_PtrLcv_face_EigenFaceRecognizerG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] pub fn as_raw_PtrOfEigenFaceRecognizer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEigenFaceRecognizer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::EigenFaceRecognizerTraitConst for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_EigenFaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::EigenFaceRecognizerTrait for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_mut_EigenFaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::EigenFaceRecognizer>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_EigenFaceRecognizerG_to_PtrOfAlgorithm }

	impl crate::face::BasicFaceRecognizerTraitConst for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_BasicFaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::BasicFaceRecognizerTrait for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_mut_BasicFaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::EigenFaceRecognizer>, core::Ptr<crate::face::BasicFaceRecognizer>, cv_PtrLcv_face_EigenFaceRecognizerG_to_PtrOfBasicFaceRecognizer }

	impl crate::face::FaceRecognizerTraitConst for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_FaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FaceRecognizerTrait for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline] fn as_raw_mut_FaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::EigenFaceRecognizer>, core::Ptr<crate::face::FaceRecognizer>, cv_PtrLcv_face_EigenFaceRecognizerG_to_PtrOfFaceRecognizer }

	impl std::fmt::Debug for core::Ptr<crate::face::EigenFaceRecognizer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEigenFaceRecognizer")
				.finish()
		}
	}

	ptr_extern! { crate::face::FaceRecognizer,
		cv_PtrLcv_face_FaceRecognizerG_new_null_const, cv_PtrLcv_face_FaceRecognizerG_delete, cv_PtrLcv_face_FaceRecognizerG_getInnerPtr_const, cv_PtrLcv_face_FaceRecognizerG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::FaceRecognizer> {
		#[inline] pub fn as_raw_PtrOfFaceRecognizer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFaceRecognizer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::FaceRecognizerTraitConst for core::Ptr<crate::face::FaceRecognizer> {
		#[inline] fn as_raw_FaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FaceRecognizerTrait for core::Ptr<crate::face::FaceRecognizer> {
		#[inline] fn as_raw_mut_FaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::FaceRecognizer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::FaceRecognizer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FaceRecognizer>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_FaceRecognizerG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::face::FaceRecognizer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFaceRecognizer")
				.finish()
		}
	}

	ptr_extern! { crate::face::Facemark,
		cv_PtrLcv_face_FacemarkG_new_null_const, cv_PtrLcv_face_FacemarkG_delete, cv_PtrLcv_face_FacemarkG_getInnerPtr_const, cv_PtrLcv_face_FacemarkG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::Facemark> {
		#[inline] pub fn as_raw_PtrOfFacemark(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFacemark(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::FacemarkTraitConst for core::Ptr<crate::face::Facemark> {
		#[inline] fn as_raw_Facemark(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrait for core::Ptr<crate::face::Facemark> {
		#[inline] fn as_raw_mut_Facemark(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::Facemark> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::Facemark> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::Facemark>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_FacemarkG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::face::Facemark> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFacemark")
				.finish()
		}
	}

	ptr_extern! { crate::face::FacemarkAAM,
		cv_PtrLcv_face_FacemarkAAMG_new_null_const, cv_PtrLcv_face_FacemarkAAMG_delete, cv_PtrLcv_face_FacemarkAAMG_getInnerPtr_const, cv_PtrLcv_face_FacemarkAAMG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::FacemarkAAM> {
		#[inline] pub fn as_raw_PtrOfFacemarkAAM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFacemarkAAM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::FacemarkAAMTraitConst for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_FacemarkAAM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkAAMTrait for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_mut_FacemarkAAM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkAAM>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_FacemarkAAMG_to_PtrOfAlgorithm }

	impl crate::face::FacemarkTraitConst for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_Facemark(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrait for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_mut_Facemark(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkAAM>, core::Ptr<crate::face::Facemark>, cv_PtrLcv_face_FacemarkAAMG_to_PtrOfFacemark }

	impl crate::face::FacemarkTrainTraitConst for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_FacemarkTrain(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrainTrait for core::Ptr<crate::face::FacemarkAAM> {
		#[inline] fn as_raw_mut_FacemarkTrain(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkAAM>, core::Ptr<crate::face::FacemarkTrain>, cv_PtrLcv_face_FacemarkAAMG_to_PtrOfFacemarkTrain }

	impl std::fmt::Debug for core::Ptr<crate::face::FacemarkAAM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFacemarkAAM")
				.finish()
		}
	}

	ptr_extern! { crate::face::FacemarkKazemi,
		cv_PtrLcv_face_FacemarkKazemiG_new_null_const, cv_PtrLcv_face_FacemarkKazemiG_delete, cv_PtrLcv_face_FacemarkKazemiG_getInnerPtr_const, cv_PtrLcv_face_FacemarkKazemiG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::FacemarkKazemi> {
		#[inline] pub fn as_raw_PtrOfFacemarkKazemi(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFacemarkKazemi(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::FacemarkKazemiTraitConst for core::Ptr<crate::face::FacemarkKazemi> {
		#[inline] fn as_raw_FacemarkKazemi(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkKazemiTrait for core::Ptr<crate::face::FacemarkKazemi> {
		#[inline] fn as_raw_mut_FacemarkKazemi(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::FacemarkKazemi> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::FacemarkKazemi> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkKazemi>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_FacemarkKazemiG_to_PtrOfAlgorithm }

	impl crate::face::FacemarkTraitConst for core::Ptr<crate::face::FacemarkKazemi> {
		#[inline] fn as_raw_Facemark(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrait for core::Ptr<crate::face::FacemarkKazemi> {
		#[inline] fn as_raw_mut_Facemark(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkKazemi>, core::Ptr<crate::face::Facemark>, cv_PtrLcv_face_FacemarkKazemiG_to_PtrOfFacemark }

	impl std::fmt::Debug for core::Ptr<crate::face::FacemarkKazemi> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFacemarkKazemi")
				.finish()
		}
	}

	ptr_extern! { crate::face::FacemarkLBF,
		cv_PtrLcv_face_FacemarkLBFG_new_null_const, cv_PtrLcv_face_FacemarkLBFG_delete, cv_PtrLcv_face_FacemarkLBFG_getInnerPtr_const, cv_PtrLcv_face_FacemarkLBFG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::FacemarkLBF> {
		#[inline] pub fn as_raw_PtrOfFacemarkLBF(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFacemarkLBF(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::FacemarkLBFTraitConst for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_FacemarkLBF(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkLBFTrait for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_mut_FacemarkLBF(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkLBF>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_FacemarkLBFG_to_PtrOfAlgorithm }

	impl crate::face::FacemarkTraitConst for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_Facemark(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrait for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_mut_Facemark(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkLBF>, core::Ptr<crate::face::Facemark>, cv_PtrLcv_face_FacemarkLBFG_to_PtrOfFacemark }

	impl crate::face::FacemarkTrainTraitConst for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_FacemarkTrain(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrainTrait for core::Ptr<crate::face::FacemarkLBF> {
		#[inline] fn as_raw_mut_FacemarkTrain(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkLBF>, core::Ptr<crate::face::FacemarkTrain>, cv_PtrLcv_face_FacemarkLBFG_to_PtrOfFacemarkTrain }

	impl std::fmt::Debug for core::Ptr<crate::face::FacemarkLBF> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFacemarkLBF")
				.finish()
		}
	}

	ptr_extern! { crate::face::FacemarkTrain,
		cv_PtrLcv_face_FacemarkTrainG_new_null_const, cv_PtrLcv_face_FacemarkTrainG_delete, cv_PtrLcv_face_FacemarkTrainG_getInnerPtr_const, cv_PtrLcv_face_FacemarkTrainG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::FacemarkTrain> {
		#[inline] pub fn as_raw_PtrOfFacemarkTrain(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFacemarkTrain(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::FacemarkTrainTraitConst for core::Ptr<crate::face::FacemarkTrain> {
		#[inline] fn as_raw_FacemarkTrain(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrainTrait for core::Ptr<crate::face::FacemarkTrain> {
		#[inline] fn as_raw_mut_FacemarkTrain(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::FacemarkTrain> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::FacemarkTrain> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkTrain>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_FacemarkTrainG_to_PtrOfAlgorithm }

	impl crate::face::FacemarkTraitConst for core::Ptr<crate::face::FacemarkTrain> {
		#[inline] fn as_raw_Facemark(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FacemarkTrait for core::Ptr<crate::face::FacemarkTrain> {
		#[inline] fn as_raw_mut_Facemark(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FacemarkTrain>, core::Ptr<crate::face::Facemark>, cv_PtrLcv_face_FacemarkTrainG_to_PtrOfFacemark }

	impl std::fmt::Debug for core::Ptr<crate::face::FacemarkTrain> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFacemarkTrain")
				.finish()
		}
	}

	ptr_extern! { crate::face::FisherFaceRecognizer,
		cv_PtrLcv_face_FisherFaceRecognizerG_new_null_const, cv_PtrLcv_face_FisherFaceRecognizerG_delete, cv_PtrLcv_face_FisherFaceRecognizerG_getInnerPtr_const, cv_PtrLcv_face_FisherFaceRecognizerG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] pub fn as_raw_PtrOfFisherFaceRecognizer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFisherFaceRecognizer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::FisherFaceRecognizerTraitConst for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_FisherFaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FisherFaceRecognizerTrait for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_mut_FisherFaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FisherFaceRecognizer>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_FisherFaceRecognizerG_to_PtrOfAlgorithm }

	impl crate::face::BasicFaceRecognizerTraitConst for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_BasicFaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::BasicFaceRecognizerTrait for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_mut_BasicFaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FisherFaceRecognizer>, core::Ptr<crate::face::BasicFaceRecognizer>, cv_PtrLcv_face_FisherFaceRecognizerG_to_PtrOfBasicFaceRecognizer }

	impl crate::face::FaceRecognizerTraitConst for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_FaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FaceRecognizerTrait for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline] fn as_raw_mut_FaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::FisherFaceRecognizer>, core::Ptr<crate::face::FaceRecognizer>, cv_PtrLcv_face_FisherFaceRecognizerG_to_PtrOfFaceRecognizer }

	impl std::fmt::Debug for core::Ptr<crate::face::FisherFaceRecognizer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFisherFaceRecognizer")
				.finish()
		}
	}

	ptr_extern! { crate::face::LBPHFaceRecognizer,
		cv_PtrLcv_face_LBPHFaceRecognizerG_new_null_const, cv_PtrLcv_face_LBPHFaceRecognizerG_delete, cv_PtrLcv_face_LBPHFaceRecognizerG_getInnerPtr_const, cv_PtrLcv_face_LBPHFaceRecognizerG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline] pub fn as_raw_PtrOfLBPHFaceRecognizer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLBPHFaceRecognizer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::LBPHFaceRecognizerTraitConst for core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline] fn as_raw_LBPHFaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::LBPHFaceRecognizerTrait for core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline] fn as_raw_mut_LBPHFaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::LBPHFaceRecognizer>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_LBPHFaceRecognizerG_to_PtrOfAlgorithm }

	impl crate::face::FaceRecognizerTraitConst for core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline] fn as_raw_FaceRecognizer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::FaceRecognizerTrait for core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline] fn as_raw_mut_FaceRecognizer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::LBPHFaceRecognizer>, core::Ptr<crate::face::FaceRecognizer>, cv_PtrLcv_face_LBPHFaceRecognizerG_to_PtrOfFaceRecognizer }

	impl std::fmt::Debug for core::Ptr<crate::face::LBPHFaceRecognizer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLBPHFaceRecognizer")
				.finish()
		}
	}

	ptr_extern! { crate::face::MACE,
		cv_PtrLcv_face_MACEG_new_null_const, cv_PtrLcv_face_MACEG_delete, cv_PtrLcv_face_MACEG_getInnerPtr_const, cv_PtrLcv_face_MACEG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::MACE> {
		#[inline] pub fn as_raw_PtrOfMACE(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMACE(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::MACETraitConst for core::Ptr<crate::face::MACE> {
		#[inline] fn as_raw_MACE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::MACETrait for core::Ptr<crate::face::MACE> {
		#[inline] fn as_raw_mut_MACE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::face::MACE> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::face::MACE> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::MACE>, core::Ptr<core::Algorithm>, cv_PtrLcv_face_MACEG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::face::MACE> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMACE")
				.finish()
		}
	}

	ptr_extern! { crate::face::PredictCollector,
		cv_PtrLcv_face_PredictCollectorG_new_null_const, cv_PtrLcv_face_PredictCollectorG_delete, cv_PtrLcv_face_PredictCollectorG_getInnerPtr_const, cv_PtrLcv_face_PredictCollectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::face::PredictCollector> {
		#[inline] pub fn as_raw_PtrOfPredictCollector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPredictCollector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::PredictCollectorTraitConst for core::Ptr<crate::face::PredictCollector> {
		#[inline] fn as_raw_PredictCollector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::PredictCollectorTrait for core::Ptr<crate::face::PredictCollector> {
		#[inline] fn as_raw_mut_PredictCollector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::face::PredictCollector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPredictCollector")
				.finish()
		}
	}

	ptr_extern! { crate::face::StandardCollector,
		cv_PtrLcv_face_StandardCollectorG_new_null_const, cv_PtrLcv_face_StandardCollectorG_delete, cv_PtrLcv_face_StandardCollectorG_getInnerPtr_const, cv_PtrLcv_face_StandardCollectorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::face::StandardCollector, cv_PtrLcv_face_StandardCollectorG_new_const_StandardCollector }
	impl core::Ptr<crate::face::StandardCollector> {
		#[inline] pub fn as_raw_PtrOfStandardCollector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStandardCollector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::face::StandardCollectorTraitConst for core::Ptr<crate::face::StandardCollector> {
		#[inline] fn as_raw_StandardCollector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::StandardCollectorTrait for core::Ptr<crate::face::StandardCollector> {
		#[inline] fn as_raw_mut_StandardCollector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::face::PredictCollectorTraitConst for core::Ptr<crate::face::StandardCollector> {
		#[inline] fn as_raw_PredictCollector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::face::PredictCollectorTrait for core::Ptr<crate::face::StandardCollector> {
		#[inline] fn as_raw_mut_PredictCollector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::face::StandardCollector>, core::Ptr<crate::face::PredictCollector>, cv_PtrLcv_face_StandardCollectorG_to_PtrOfPredictCollector }

	impl std::fmt::Debug for core::Ptr<crate::face::StandardCollector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStandardCollector")
				.finish()
		}
	}

	impl core::Vector<crate::face::FacemarkAAM_Config> {
		pub fn as_raw_VectorOfFacemarkAAM_Config(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfFacemarkAAM_Config(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::face::FacemarkAAM_Config,
		std_vectorLcv_face_FacemarkAAM_ConfigG_new_const, std_vectorLcv_face_FacemarkAAM_ConfigG_delete,
		std_vectorLcv_face_FacemarkAAM_ConfigG_len_const, std_vectorLcv_face_FacemarkAAM_ConfigG_isEmpty_const,
		std_vectorLcv_face_FacemarkAAM_ConfigG_capacity_const, std_vectorLcv_face_FacemarkAAM_ConfigG_shrinkToFit,
		std_vectorLcv_face_FacemarkAAM_ConfigG_reserve_size_t, std_vectorLcv_face_FacemarkAAM_ConfigG_remove_size_t,
		std_vectorLcv_face_FacemarkAAM_ConfigG_swap_size_t_size_t, std_vectorLcv_face_FacemarkAAM_ConfigG_clear,
		std_vectorLcv_face_FacemarkAAM_ConfigG_get_const_size_t, std_vectorLcv_face_FacemarkAAM_ConfigG_set_size_t_const_Config,
		std_vectorLcv_face_FacemarkAAM_ConfigG_push_const_Config, std_vectorLcv_face_FacemarkAAM_ConfigG_insert_size_t_const_Config,
	}

	vector_non_copy_or_bool! { crate::face::FacemarkAAM_Config }

	vector_boxed_ref! { crate::face::FacemarkAAM_Config }

	vector_extern! { BoxedRef<'t, crate::face::FacemarkAAM_Config>,
		std_vectorLcv_face_FacemarkAAM_ConfigG_new_const, std_vectorLcv_face_FacemarkAAM_ConfigG_delete,
		std_vectorLcv_face_FacemarkAAM_ConfigG_len_const, std_vectorLcv_face_FacemarkAAM_ConfigG_isEmpty_const,
		std_vectorLcv_face_FacemarkAAM_ConfigG_capacity_const, std_vectorLcv_face_FacemarkAAM_ConfigG_shrinkToFit,
		std_vectorLcv_face_FacemarkAAM_ConfigG_reserve_size_t, std_vectorLcv_face_FacemarkAAM_ConfigG_remove_size_t,
		std_vectorLcv_face_FacemarkAAM_ConfigG_swap_size_t_size_t, std_vectorLcv_face_FacemarkAAM_ConfigG_clear,
		std_vectorLcv_face_FacemarkAAM_ConfigG_get_const_size_t, std_vectorLcv_face_FacemarkAAM_ConfigG_set_size_t_const_Config,
		std_vectorLcv_face_FacemarkAAM_ConfigG_push_const_Config, std_vectorLcv_face_FacemarkAAM_ConfigG_insert_size_t_const_Config,
	}


	impl core::Vector<crate::face::FacemarkAAM_Model_Texture> {
		pub fn as_raw_VectorOfFacemarkAAM_Model_Texture(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfFacemarkAAM_Model_Texture(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::face::FacemarkAAM_Model_Texture,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_new_const, std_vectorLcv_face_FacemarkAAM_Model_TextureG_delete,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_len_const, std_vectorLcv_face_FacemarkAAM_Model_TextureG_isEmpty_const,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_capacity_const, std_vectorLcv_face_FacemarkAAM_Model_TextureG_shrinkToFit,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_reserve_size_t, std_vectorLcv_face_FacemarkAAM_Model_TextureG_remove_size_t,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_swap_size_t_size_t, std_vectorLcv_face_FacemarkAAM_Model_TextureG_clear,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_get_const_size_t, std_vectorLcv_face_FacemarkAAM_Model_TextureG_set_size_t_const_Texture,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_push_const_Texture, std_vectorLcv_face_FacemarkAAM_Model_TextureG_insert_size_t_const_Texture,
	}

	vector_non_copy_or_bool! { crate::face::FacemarkAAM_Model_Texture }

	vector_boxed_ref! { crate::face::FacemarkAAM_Model_Texture }

	vector_extern! { BoxedRef<'t, crate::face::FacemarkAAM_Model_Texture>,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_new_const, std_vectorLcv_face_FacemarkAAM_Model_TextureG_delete,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_len_const, std_vectorLcv_face_FacemarkAAM_Model_TextureG_isEmpty_const,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_capacity_const, std_vectorLcv_face_FacemarkAAM_Model_TextureG_shrinkToFit,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_reserve_size_t, std_vectorLcv_face_FacemarkAAM_Model_TextureG_remove_size_t,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_swap_size_t_size_t, std_vectorLcv_face_FacemarkAAM_Model_TextureG_clear,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_get_const_size_t, std_vectorLcv_face_FacemarkAAM_Model_TextureG_set_size_t_const_Texture,
		std_vectorLcv_face_FacemarkAAM_Model_TextureG_push_const_Texture, std_vectorLcv_face_FacemarkAAM_Model_TextureG_insert_size_t_const_Texture,
	}


}
pub use face_types::*;

mod features2d_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::features2d::AKAZE,
		cv_PtrLcv_AKAZEG_new_null_const, cv_PtrLcv_AKAZEG_delete, cv_PtrLcv_AKAZEG_getInnerPtr_const, cv_PtrLcv_AKAZEG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::AKAZE> {
		#[inline] pub fn as_raw_PtrOfAKAZE(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAKAZE(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::AKAZETraitConst for core::Ptr<crate::features2d::AKAZE> {
		#[inline] fn as_raw_AKAZE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::AKAZETrait for core::Ptr<crate::features2d::AKAZE> {
		#[inline] fn as_raw_mut_AKAZE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::AKAZE> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::AKAZE> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::AKAZE>, core::Ptr<core::Algorithm>, cv_PtrLcv_AKAZEG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::AKAZE> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::AKAZE> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::AKAZE>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_AKAZEG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::AKAZE> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAKAZE")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::AffineFeature,
		cv_PtrLcv_AffineFeatureG_new_null_const, cv_PtrLcv_AffineFeatureG_delete, cv_PtrLcv_AffineFeatureG_getInnerPtr_const, cv_PtrLcv_AffineFeatureG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::AffineFeature> {
		#[inline] pub fn as_raw_PtrOfAffineFeature(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAffineFeature(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::AffineFeatureTraitConst for core::Ptr<crate::features2d::AffineFeature> {
		#[inline] fn as_raw_AffineFeature(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::AffineFeatureTrait for core::Ptr<crate::features2d::AffineFeature> {
		#[inline] fn as_raw_mut_AffineFeature(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::AffineFeature> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::AffineFeature> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::AffineFeature>, core::Ptr<core::Algorithm>, cv_PtrLcv_AffineFeatureG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::AffineFeature> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::AffineFeature> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::AffineFeature>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_AffineFeatureG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::AffineFeature> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAffineFeature")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::AgastFeatureDetector,
		cv_PtrLcv_AgastFeatureDetectorG_new_null_const, cv_PtrLcv_AgastFeatureDetectorG_delete, cv_PtrLcv_AgastFeatureDetectorG_getInnerPtr_const, cv_PtrLcv_AgastFeatureDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline] pub fn as_raw_PtrOfAgastFeatureDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAgastFeatureDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::AgastFeatureDetectorTraitConst for core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline] fn as_raw_AgastFeatureDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::AgastFeatureDetectorTrait for core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline] fn as_raw_mut_AgastFeatureDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::AgastFeatureDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_AgastFeatureDetectorG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::AgastFeatureDetector>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_AgastFeatureDetectorG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::AgastFeatureDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAgastFeatureDetector")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::BFMatcher,
		cv_PtrLcv_BFMatcherG_new_null_const, cv_PtrLcv_BFMatcherG_delete, cv_PtrLcv_BFMatcherG_getInnerPtr_const, cv_PtrLcv_BFMatcherG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::features2d::BFMatcher, cv_PtrLcv_BFMatcherG_new_const_BFMatcher }
	impl core::Ptr<crate::features2d::BFMatcher> {
		#[inline] pub fn as_raw_PtrOfBFMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBFMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::BFMatcherTraitConst for core::Ptr<crate::features2d::BFMatcher> {
		#[inline] fn as_raw_BFMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::BFMatcherTrait for core::Ptr<crate::features2d::BFMatcher> {
		#[inline] fn as_raw_mut_BFMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::BFMatcher> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::BFMatcher> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::BFMatcher>, core::Ptr<core::Algorithm>, cv_PtrLcv_BFMatcherG_to_PtrOfAlgorithm }

	impl crate::features2d::DescriptorMatcherTraitConst for core::Ptr<crate::features2d::BFMatcher> {
		#[inline] fn as_raw_DescriptorMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::DescriptorMatcherTrait for core::Ptr<crate::features2d::BFMatcher> {
		#[inline] fn as_raw_mut_DescriptorMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::BFMatcher>, core::Ptr<crate::features2d::DescriptorMatcher>, cv_PtrLcv_BFMatcherG_to_PtrOfDescriptorMatcher }

	impl std::fmt::Debug for core::Ptr<crate::features2d::BFMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBFMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::BRISK,
		cv_PtrLcv_BRISKG_new_null_const, cv_PtrLcv_BRISKG_delete, cv_PtrLcv_BRISKG_getInnerPtr_const, cv_PtrLcv_BRISKG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::BRISK> {
		#[inline] pub fn as_raw_PtrOfBRISK(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBRISK(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::BRISKTraitConst for core::Ptr<crate::features2d::BRISK> {
		#[inline] fn as_raw_BRISK(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::BRISKTrait for core::Ptr<crate::features2d::BRISK> {
		#[inline] fn as_raw_mut_BRISK(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::BRISK> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::BRISK> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::BRISK>, core::Ptr<core::Algorithm>, cv_PtrLcv_BRISKG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::BRISK> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::BRISK> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::BRISK>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_BRISKG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::BRISK> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBRISK")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::DescriptorMatcher,
		cv_PtrLcv_DescriptorMatcherG_new_null_const, cv_PtrLcv_DescriptorMatcherG_delete, cv_PtrLcv_DescriptorMatcherG_getInnerPtr_const, cv_PtrLcv_DescriptorMatcherG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::DescriptorMatcher> {
		#[inline] pub fn as_raw_PtrOfDescriptorMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDescriptorMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::DescriptorMatcherTraitConst for core::Ptr<crate::features2d::DescriptorMatcher> {
		#[inline] fn as_raw_DescriptorMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::DescriptorMatcherTrait for core::Ptr<crate::features2d::DescriptorMatcher> {
		#[inline] fn as_raw_mut_DescriptorMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::DescriptorMatcher> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::DescriptorMatcher> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::DescriptorMatcher>, core::Ptr<core::Algorithm>, cv_PtrLcv_DescriptorMatcherG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::features2d::DescriptorMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDescriptorMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::FastFeatureDetector,
		cv_PtrLcv_FastFeatureDetectorG_new_null_const, cv_PtrLcv_FastFeatureDetectorG_delete, cv_PtrLcv_FastFeatureDetectorG_getInnerPtr_const, cv_PtrLcv_FastFeatureDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline] pub fn as_raw_PtrOfFastFeatureDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFastFeatureDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::FastFeatureDetectorTraitConst for core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline] fn as_raw_FastFeatureDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::FastFeatureDetectorTrait for core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline] fn as_raw_mut_FastFeatureDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::FastFeatureDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_FastFeatureDetectorG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::FastFeatureDetector>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_FastFeatureDetectorG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::FastFeatureDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFastFeatureDetector")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::Feature2D,
		cv_PtrLcv_Feature2DG_new_null_const, cv_PtrLcv_Feature2DG_delete, cv_PtrLcv_Feature2DG_getInnerPtr_const, cv_PtrLcv_Feature2DG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::features2d::Feature2D, cv_PtrLcv_Feature2DG_new_const_Feature2D }
	impl core::Ptr<crate::features2d::Feature2D> {
		#[inline] pub fn as_raw_PtrOfFeature2D(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFeature2D(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::Feature2D> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::Feature2D> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::Feature2D> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::Feature2D> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::Feature2D>, core::Ptr<core::Algorithm>, cv_PtrLcv_Feature2DG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::features2d::Feature2D> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFeature2D")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::FlannBasedMatcher,
		cv_PtrLcv_FlannBasedMatcherG_new_null_const, cv_PtrLcv_FlannBasedMatcherG_delete, cv_PtrLcv_FlannBasedMatcherG_getInnerPtr_const, cv_PtrLcv_FlannBasedMatcherG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::features2d::FlannBasedMatcher, cv_PtrLcv_FlannBasedMatcherG_new_const_FlannBasedMatcher }
	impl core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline] pub fn as_raw_PtrOfFlannBasedMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFlannBasedMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::FlannBasedMatcherTraitConst for core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline] fn as_raw_FlannBasedMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::FlannBasedMatcherTrait for core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline] fn as_raw_mut_FlannBasedMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::FlannBasedMatcher>, core::Ptr<core::Algorithm>, cv_PtrLcv_FlannBasedMatcherG_to_PtrOfAlgorithm }

	impl crate::features2d::DescriptorMatcherTraitConst for core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline] fn as_raw_DescriptorMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::DescriptorMatcherTrait for core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline] fn as_raw_mut_DescriptorMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::FlannBasedMatcher>, core::Ptr<crate::features2d::DescriptorMatcher>, cv_PtrLcv_FlannBasedMatcherG_to_PtrOfDescriptorMatcher }

	impl std::fmt::Debug for core::Ptr<crate::features2d::FlannBasedMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFlannBasedMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::GFTTDetector,
		cv_PtrLcv_GFTTDetectorG_new_null_const, cv_PtrLcv_GFTTDetectorG_delete, cv_PtrLcv_GFTTDetectorG_getInnerPtr_const, cv_PtrLcv_GFTTDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::GFTTDetector> {
		#[inline] pub fn as_raw_PtrOfGFTTDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGFTTDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::GFTTDetectorTraitConst for core::Ptr<crate::features2d::GFTTDetector> {
		#[inline] fn as_raw_GFTTDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::GFTTDetectorTrait for core::Ptr<crate::features2d::GFTTDetector> {
		#[inline] fn as_raw_mut_GFTTDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::GFTTDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::GFTTDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::GFTTDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_GFTTDetectorG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::GFTTDetector> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::GFTTDetector> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::GFTTDetector>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_GFTTDetectorG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::GFTTDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGFTTDetector")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::KAZE,
		cv_PtrLcv_KAZEG_new_null_const, cv_PtrLcv_KAZEG_delete, cv_PtrLcv_KAZEG_getInnerPtr_const, cv_PtrLcv_KAZEG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::KAZE> {
		#[inline] pub fn as_raw_PtrOfKAZE(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKAZE(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::KAZETraitConst for core::Ptr<crate::features2d::KAZE> {
		#[inline] fn as_raw_KAZE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::KAZETrait for core::Ptr<crate::features2d::KAZE> {
		#[inline] fn as_raw_mut_KAZE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::KAZE> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::KAZE> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::KAZE>, core::Ptr<core::Algorithm>, cv_PtrLcv_KAZEG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::KAZE> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::KAZE> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::KAZE>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_KAZEG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::KAZE> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKAZE")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::MSER,
		cv_PtrLcv_MSERG_new_null_const, cv_PtrLcv_MSERG_delete, cv_PtrLcv_MSERG_getInnerPtr_const, cv_PtrLcv_MSERG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::MSER> {
		#[inline] pub fn as_raw_PtrOfMSER(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMSER(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::MSERTraitConst for core::Ptr<crate::features2d::MSER> {
		#[inline] fn as_raw_MSER(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::MSERTrait for core::Ptr<crate::features2d::MSER> {
		#[inline] fn as_raw_mut_MSER(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::MSER> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::MSER> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::MSER>, core::Ptr<core::Algorithm>, cv_PtrLcv_MSERG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::MSER> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::MSER> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::MSER>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_MSERG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::MSER> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMSER")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::ORB,
		cv_PtrLcv_ORBG_new_null_const, cv_PtrLcv_ORBG_delete, cv_PtrLcv_ORBG_getInnerPtr_const, cv_PtrLcv_ORBG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::ORB> {
		#[inline] pub fn as_raw_PtrOfORB(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfORB(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::ORBTraitConst for core::Ptr<crate::features2d::ORB> {
		#[inline] fn as_raw_ORB(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::ORBTrait for core::Ptr<crate::features2d::ORB> {
		#[inline] fn as_raw_mut_ORB(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::ORB> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::ORB> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::ORB>, core::Ptr<core::Algorithm>, cv_PtrLcv_ORBG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::ORB> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::ORB> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::ORB>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_ORBG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::ORB> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfORB")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::SIFT,
		cv_PtrLcv_SIFTG_new_null_const, cv_PtrLcv_SIFTG_delete, cv_PtrLcv_SIFTG_getInnerPtr_const, cv_PtrLcv_SIFTG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::SIFT> {
		#[inline] pub fn as_raw_PtrOfSIFT(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSIFT(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::SIFTTraitConst for core::Ptr<crate::features2d::SIFT> {
		#[inline] fn as_raw_SIFT(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::SIFTTrait for core::Ptr<crate::features2d::SIFT> {
		#[inline] fn as_raw_mut_SIFT(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::SIFT> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::SIFT> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::SIFT>, core::Ptr<core::Algorithm>, cv_PtrLcv_SIFTG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::SIFT> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::SIFT> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::SIFT>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_SIFTG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::SIFT> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSIFT")
				.finish()
		}
	}

	ptr_extern! { crate::features2d::SimpleBlobDetector,
		cv_PtrLcv_SimpleBlobDetectorG_new_null_const, cv_PtrLcv_SimpleBlobDetectorG_delete, cv_PtrLcv_SimpleBlobDetectorG_getInnerPtr_const, cv_PtrLcv_SimpleBlobDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline] pub fn as_raw_PtrOfSimpleBlobDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSimpleBlobDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::features2d::SimpleBlobDetectorTraitConst for core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline] fn as_raw_SimpleBlobDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::SimpleBlobDetectorTrait for core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline] fn as_raw_mut_SimpleBlobDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::SimpleBlobDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_SimpleBlobDetectorG_to_PtrOfAlgorithm }

	impl crate::features2d::Feature2DTraitConst for core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline] fn as_raw_Feature2D(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::features2d::Feature2DTrait for core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline] fn as_raw_mut_Feature2D(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::features2d::SimpleBlobDetector>, core::Ptr<crate::features2d::Feature2D>, cv_PtrLcv_SimpleBlobDetectorG_to_PtrOfFeature2D }

	impl std::fmt::Debug for core::Ptr<crate::features2d::SimpleBlobDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSimpleBlobDetector")
				.finish()
		}
	}

}
pub use features2d_types::*;

mod flann_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::flann::AutotunedIndexParams,
		cv_PtrLcv_flann_AutotunedIndexParamsG_new_null_const, cv_PtrLcv_flann_AutotunedIndexParamsG_delete, cv_PtrLcv_flann_AutotunedIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_AutotunedIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::AutotunedIndexParams, cv_PtrLcv_flann_AutotunedIndexParamsG_new_const_AutotunedIndexParams }
	impl core::Ptr<crate::flann::AutotunedIndexParams> {
		#[inline] pub fn as_raw_PtrOfAutotunedIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAutotunedIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::AutotunedIndexParamsTraitConst for core::Ptr<crate::flann::AutotunedIndexParams> {
		#[inline] fn as_raw_AutotunedIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::AutotunedIndexParamsTrait for core::Ptr<crate::flann::AutotunedIndexParams> {
		#[inline] fn as_raw_mut_AutotunedIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::AutotunedIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::AutotunedIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::AutotunedIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_AutotunedIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::AutotunedIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAutotunedIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::CompositeIndexParams,
		cv_PtrLcv_flann_CompositeIndexParamsG_new_null_const, cv_PtrLcv_flann_CompositeIndexParamsG_delete, cv_PtrLcv_flann_CompositeIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_CompositeIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::CompositeIndexParams, cv_PtrLcv_flann_CompositeIndexParamsG_new_const_CompositeIndexParams }
	impl core::Ptr<crate::flann::CompositeIndexParams> {
		#[inline] pub fn as_raw_PtrOfCompositeIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCompositeIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::CompositeIndexParamsTraitConst for core::Ptr<crate::flann::CompositeIndexParams> {
		#[inline] fn as_raw_CompositeIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::CompositeIndexParamsTrait for core::Ptr<crate::flann::CompositeIndexParams> {
		#[inline] fn as_raw_mut_CompositeIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::CompositeIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::CompositeIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::CompositeIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_CompositeIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::CompositeIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCompositeIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::HierarchicalClusteringIndexParams,
		cv_PtrLcv_flann_HierarchicalClusteringIndexParamsG_new_null_const, cv_PtrLcv_flann_HierarchicalClusteringIndexParamsG_delete, cv_PtrLcv_flann_HierarchicalClusteringIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_HierarchicalClusteringIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::HierarchicalClusteringIndexParams, cv_PtrLcv_flann_HierarchicalClusteringIndexParamsG_new_const_HierarchicalClusteringIndexParams }
	impl core::Ptr<crate::flann::HierarchicalClusteringIndexParams> {
		#[inline] pub fn as_raw_PtrOfHierarchicalClusteringIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHierarchicalClusteringIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::HierarchicalClusteringIndexParamsTraitConst for core::Ptr<crate::flann::HierarchicalClusteringIndexParams> {
		#[inline] fn as_raw_HierarchicalClusteringIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::HierarchicalClusteringIndexParamsTrait for core::Ptr<crate::flann::HierarchicalClusteringIndexParams> {
		#[inline] fn as_raw_mut_HierarchicalClusteringIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::HierarchicalClusteringIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::HierarchicalClusteringIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::HierarchicalClusteringIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_HierarchicalClusteringIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::HierarchicalClusteringIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHierarchicalClusteringIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::IndexParams,
		cv_PtrLcv_flann_IndexParamsG_new_null_const, cv_PtrLcv_flann_IndexParamsG_delete, cv_PtrLcv_flann_IndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_IndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::IndexParams, cv_PtrLcv_flann_IndexParamsG_new_const_IndexParams }
	impl core::Ptr<crate::flann::IndexParams> {
		#[inline] pub fn as_raw_PtrOfIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::IndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::IndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::flann::IndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::KDTreeIndexParams,
		cv_PtrLcv_flann_KDTreeIndexParamsG_new_null_const, cv_PtrLcv_flann_KDTreeIndexParamsG_delete, cv_PtrLcv_flann_KDTreeIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_KDTreeIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::KDTreeIndexParams, cv_PtrLcv_flann_KDTreeIndexParamsG_new_const_KDTreeIndexParams }
	impl core::Ptr<crate::flann::KDTreeIndexParams> {
		#[inline] pub fn as_raw_PtrOfKDTreeIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKDTreeIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::KDTreeIndexParamsTraitConst for core::Ptr<crate::flann::KDTreeIndexParams> {
		#[inline] fn as_raw_KDTreeIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::KDTreeIndexParamsTrait for core::Ptr<crate::flann::KDTreeIndexParams> {
		#[inline] fn as_raw_mut_KDTreeIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::KDTreeIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::KDTreeIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::KDTreeIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_KDTreeIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::KDTreeIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKDTreeIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::KMeansIndexParams,
		cv_PtrLcv_flann_KMeansIndexParamsG_new_null_const, cv_PtrLcv_flann_KMeansIndexParamsG_delete, cv_PtrLcv_flann_KMeansIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_KMeansIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::KMeansIndexParams, cv_PtrLcv_flann_KMeansIndexParamsG_new_const_KMeansIndexParams }
	impl core::Ptr<crate::flann::KMeansIndexParams> {
		#[inline] pub fn as_raw_PtrOfKMeansIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKMeansIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::KMeansIndexParamsTraitConst for core::Ptr<crate::flann::KMeansIndexParams> {
		#[inline] fn as_raw_KMeansIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::KMeansIndexParamsTrait for core::Ptr<crate::flann::KMeansIndexParams> {
		#[inline] fn as_raw_mut_KMeansIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::KMeansIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::KMeansIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::KMeansIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_KMeansIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::KMeansIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKMeansIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::LinearIndexParams,
		cv_PtrLcv_flann_LinearIndexParamsG_new_null_const, cv_PtrLcv_flann_LinearIndexParamsG_delete, cv_PtrLcv_flann_LinearIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_LinearIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::LinearIndexParams, cv_PtrLcv_flann_LinearIndexParamsG_new_const_LinearIndexParams }
	impl core::Ptr<crate::flann::LinearIndexParams> {
		#[inline] pub fn as_raw_PtrOfLinearIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLinearIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::LinearIndexParamsTraitConst for core::Ptr<crate::flann::LinearIndexParams> {
		#[inline] fn as_raw_LinearIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::LinearIndexParamsTrait for core::Ptr<crate::flann::LinearIndexParams> {
		#[inline] fn as_raw_mut_LinearIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::LinearIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::LinearIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::LinearIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_LinearIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::LinearIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLinearIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::LshIndexParams,
		cv_PtrLcv_flann_LshIndexParamsG_new_null_const, cv_PtrLcv_flann_LshIndexParamsG_delete, cv_PtrLcv_flann_LshIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_LshIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::LshIndexParams, cv_PtrLcv_flann_LshIndexParamsG_new_const_LshIndexParams }
	impl core::Ptr<crate::flann::LshIndexParams> {
		#[inline] pub fn as_raw_PtrOfLshIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLshIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::LshIndexParamsTraitConst for core::Ptr<crate::flann::LshIndexParams> {
		#[inline] fn as_raw_LshIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::LshIndexParamsTrait for core::Ptr<crate::flann::LshIndexParams> {
		#[inline] fn as_raw_mut_LshIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::LshIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::LshIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::LshIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_LshIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::LshIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLshIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::SavedIndexParams,
		cv_PtrLcv_flann_SavedIndexParamsG_new_null_const, cv_PtrLcv_flann_SavedIndexParamsG_delete, cv_PtrLcv_flann_SavedIndexParamsG_getInnerPtr_const, cv_PtrLcv_flann_SavedIndexParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::SavedIndexParams, cv_PtrLcv_flann_SavedIndexParamsG_new_const_SavedIndexParams }
	impl core::Ptr<crate::flann::SavedIndexParams> {
		#[inline] pub fn as_raw_PtrOfSavedIndexParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSavedIndexParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::SavedIndexParamsTraitConst for core::Ptr<crate::flann::SavedIndexParams> {
		#[inline] fn as_raw_SavedIndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::SavedIndexParamsTrait for core::Ptr<crate::flann::SavedIndexParams> {
		#[inline] fn as_raw_mut_SavedIndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::SavedIndexParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::SavedIndexParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::SavedIndexParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_SavedIndexParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::SavedIndexParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSavedIndexParams")
				.finish()
		}
	}

	ptr_extern! { crate::flann::SearchParams,
		cv_PtrLcv_flann_SearchParamsG_new_null_const, cv_PtrLcv_flann_SearchParamsG_delete, cv_PtrLcv_flann_SearchParamsG_getInnerPtr_const, cv_PtrLcv_flann_SearchParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::flann::SearchParams, cv_PtrLcv_flann_SearchParamsG_new_const_SearchParams }
	impl core::Ptr<crate::flann::SearchParams> {
		#[inline] pub fn as_raw_PtrOfSearchParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSearchParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::flann::SearchParamsTraitConst for core::Ptr<crate::flann::SearchParams> {
		#[inline] fn as_raw_SearchParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::SearchParamsTrait for core::Ptr<crate::flann::SearchParams> {
		#[inline] fn as_raw_mut_SearchParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::flann::IndexParamsTraitConst for core::Ptr<crate::flann::SearchParams> {
		#[inline] fn as_raw_IndexParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::flann::IndexParamsTrait for core::Ptr<crate::flann::SearchParams> {
		#[inline] fn as_raw_mut_IndexParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::flann::SearchParams>, core::Ptr<crate::flann::IndexParams>, cv_PtrLcv_flann_SearchParamsG_to_PtrOfIndexParams }

	impl std::fmt::Debug for core::Ptr<crate::flann::SearchParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSearchParams")
				.finish()
		}
	}

	impl core::Vector<crate::flann::FeatureIndex> {
		pub fn as_raw_VectorOfFeatureIndex(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfFeatureIndex(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::flann::FeatureIndex,
		std_vectorLcvflann_lsh_FeatureIndexG_new_const, std_vectorLcvflann_lsh_FeatureIndexG_delete,
		std_vectorLcvflann_lsh_FeatureIndexG_len_const, std_vectorLcvflann_lsh_FeatureIndexG_isEmpty_const,
		std_vectorLcvflann_lsh_FeatureIndexG_capacity_const, std_vectorLcvflann_lsh_FeatureIndexG_shrinkToFit,
		std_vectorLcvflann_lsh_FeatureIndexG_reserve_size_t, std_vectorLcvflann_lsh_FeatureIndexG_remove_size_t,
		std_vectorLcvflann_lsh_FeatureIndexG_swap_size_t_size_t, std_vectorLcvflann_lsh_FeatureIndexG_clear,
		std_vectorLcvflann_lsh_FeatureIndexG_get_const_size_t, std_vectorLcvflann_lsh_FeatureIndexG_set_size_t_const_FeatureIndex,
		std_vectorLcvflann_lsh_FeatureIndexG_push_const_FeatureIndex, std_vectorLcvflann_lsh_FeatureIndexG_insert_size_t_const_FeatureIndex,
	}

	vector_copy_non_bool! { crate::flann::FeatureIndex,
		std_vectorLcvflann_lsh_FeatureIndexG_data_const, std_vectorLcvflann_lsh_FeatureIndexG_dataMut, cv_fromSlice_const_const_FeatureIndexX_size_t,
		std_vectorLcvflann_lsh_FeatureIndexG_clone_const,
	}

	#[cfg(ocvrs_opencv_branch_5)]
	impl ToInputArray for core::Vector<crate::flann::FeatureIndex> {
		#[inline]
		fn input_array(&self) -> Result<BoxedRef<core::_InputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcvflann_lsh_FeatureIndexG_inputArray_const(self.as_raw_VectorOfFeatureIndex(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRef::<core::_InputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	#[cfg(ocvrs_opencv_branch_5)]
	input_array_ref_forward! { core::Vector<crate::flann::FeatureIndex> }

	#[cfg(ocvrs_opencv_branch_5)]
	impl ToOutputArray for core::Vector<crate::flann::FeatureIndex> {
		#[inline]
		fn output_array(&mut self) -> Result<BoxedRefMut<core::_OutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcvflann_lsh_FeatureIndexG_outputArray(self.as_raw_mut_VectorOfFeatureIndex(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_OutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	#[cfg(ocvrs_opencv_branch_5)]
	impl ToInputOutputArray for core::Vector<crate::flann::FeatureIndex> {
		#[inline]
		fn input_output_array(&mut self) -> Result<BoxedRefMut<core::_InputOutputArray>> {
			return_send!(via ocvrs_return);
			unsafe { sys::std_vectorLcvflann_lsh_FeatureIndexG_inputOutputArray(self.as_raw_mut_VectorOfFeatureIndex(), ocvrs_return.as_mut_ptr()) };
			return_receive!(ocvrs_return => ret);
			let ret = ret.into_result()?;
			let ret = unsafe { BoxedRefMut::<core::_InputOutputArray>::opencv_from_extern(ret) };
			Ok(ret)
		}

	}

	#[cfg(ocvrs_opencv_branch_5)]
	output_array_ref_forward! { core::Vector<crate::flann::FeatureIndex> }

	impl core::Vector<crate::flann::FlannIndexType> {
		pub fn as_raw_VectorOfFlannIndexType(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfFlannIndexType(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::flann::FlannIndexType,
		std_vectorLcv_flann_FlannIndexTypeG_new_const, std_vectorLcv_flann_FlannIndexTypeG_delete,
		std_vectorLcv_flann_FlannIndexTypeG_len_const, std_vectorLcv_flann_FlannIndexTypeG_isEmpty_const,
		std_vectorLcv_flann_FlannIndexTypeG_capacity_const, std_vectorLcv_flann_FlannIndexTypeG_shrinkToFit,
		std_vectorLcv_flann_FlannIndexTypeG_reserve_size_t, std_vectorLcv_flann_FlannIndexTypeG_remove_size_t,
		std_vectorLcv_flann_FlannIndexTypeG_swap_size_t_size_t, std_vectorLcv_flann_FlannIndexTypeG_clear,
		std_vectorLcv_flann_FlannIndexTypeG_get_const_size_t, std_vectorLcv_flann_FlannIndexTypeG_set_size_t_const_FlannIndexType,
		std_vectorLcv_flann_FlannIndexTypeG_push_const_FlannIndexType, std_vectorLcv_flann_FlannIndexTypeG_insert_size_t_const_FlannIndexType,
	}

	vector_copy_non_bool! { crate::flann::FlannIndexType,
		std_vectorLcv_flann_FlannIndexTypeG_data_const, std_vectorLcv_flann_FlannIndexTypeG_dataMut, cv_fromSlice_const_const_FlannIndexTypeX_size_t,
		std_vectorLcv_flann_FlannIndexTypeG_clone_const,
	}


}
pub use flann_types::*;

mod freetype_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::freetype::FreeType2,
		cv_PtrLcv_freetype_FreeType2G_new_null_const, cv_PtrLcv_freetype_FreeType2G_delete, cv_PtrLcv_freetype_FreeType2G_getInnerPtr_const, cv_PtrLcv_freetype_FreeType2G_getInnerPtrMut
	}

	impl core::Ptr<crate::freetype::FreeType2> {
		#[inline] pub fn as_raw_PtrOfFreeType2(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFreeType2(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::freetype::FreeType2TraitConst for core::Ptr<crate::freetype::FreeType2> {
		#[inline] fn as_raw_FreeType2(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::freetype::FreeType2Trait for core::Ptr<crate::freetype::FreeType2> {
		#[inline] fn as_raw_mut_FreeType2(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::freetype::FreeType2> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::freetype::FreeType2> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::freetype::FreeType2>, core::Ptr<core::Algorithm>, cv_PtrLcv_freetype_FreeType2G_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::freetype::FreeType2> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFreeType2")
				.finish()
		}
	}

}
pub use freetype_types::*;

mod gapi_types {
	use crate::{mod_prelude::*, core, types, sys};

	impl core::Tuple<(crate::gapi::GBackend, crate::gapi::GKernelImpl)> {
		pub fn as_raw_TupleOfGBackend_GKernelImpl(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfGBackend_GKernelImpl(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (crate::gapi::GBackend, crate::gapi::GKernelImpl),
		std_pairLcv_gapi_GBackend__cv_GKernelImplG_new_const_GBackend_GKernelImpl, std_pairLcv_gapi_GBackend__cv_GKernelImplG_delete,
		0 = arg: crate::gapi::GBackend, get_0 via std_pairLcv_gapi_GBackend__cv_GKernelImplG_get_0_const,
		1 = arg_1: crate::gapi::GKernelImpl, get_1 via std_pairLcv_gapi_GBackend__cv_GKernelImplG_get_1_const
	}

	impl core::Tuple<(crate::gapi::GMat, crate::gapi::GMat)> {
		pub fn as_raw_TupleOfGMat_GMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfGMat_GMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (crate::gapi::GMat, crate::gapi::GMat),
		std_tupleLcv_GMat__cv_GMatG_new_const_GMat_GMat, std_tupleLcv_GMat__cv_GMatG_delete,
		0 = arg: crate::gapi::GMat, get_0 via std_tupleLcv_GMat__cv_GMatG_get_0_const,
		1 = arg_1: crate::gapi::GMat, get_1 via std_tupleLcv_GMat__cv_GMatG_get_1_const
	}

	impl core::Tuple<(crate::gapi::GMat, crate::gapi::GMat, crate::gapi::GMat)> {
		pub fn as_raw_TupleOfGMat_GMat_GMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfGMat_GMat_GMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (crate::gapi::GMat, crate::gapi::GMat, crate::gapi::GMat),
		std_tupleLcv_GMat__cv_GMat__cv_GMatG_new_const_GMat_GMat_GMat, std_tupleLcv_GMat__cv_GMat__cv_GMatG_delete,
		0 = arg: crate::gapi::GMat, get_0 via std_tupleLcv_GMat__cv_GMat__cv_GMatG_get_0_const,
		1 = arg_1: crate::gapi::GMat, get_1 via std_tupleLcv_GMat__cv_GMat__cv_GMatG_get_1_const,
		2 = arg_2: crate::gapi::GMat, get_2 via std_tupleLcv_GMat__cv_GMat__cv_GMatG_get_2_const
	}

	impl core::Tuple<(crate::gapi::GMat, crate::gapi::GMat, crate::gapi::GMat, crate::gapi::GMat)> {
		pub fn as_raw_TupleOfGMat_GMat_GMat_GMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfGMat_GMat_GMat_GMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (crate::gapi::GMat, crate::gapi::GMat, crate::gapi::GMat, crate::gapi::GMat),
		std_tupleLcv_GMat__cv_GMat__cv_GMat__cv_GMatG_new_const_GMat_GMat_GMat_GMat, std_tupleLcv_GMat__cv_GMat__cv_GMat__cv_GMatG_delete,
		0 = arg: crate::gapi::GMat, get_0 via std_tupleLcv_GMat__cv_GMat__cv_GMat__cv_GMatG_get_0_const,
		1 = arg_1: crate::gapi::GMat, get_1 via std_tupleLcv_GMat__cv_GMat__cv_GMat__cv_GMatG_get_1_const,
		2 = arg_2: crate::gapi::GMat, get_2 via std_tupleLcv_GMat__cv_GMat__cv_GMat__cv_GMatG_get_2_const,
		3 = arg_3: crate::gapi::GMat, get_3 via std_tupleLcv_GMat__cv_GMat__cv_GMat__cv_GMatG_get_3_const
	}

	impl core::Tuple<(crate::gapi::GMat, crate::gapi::GScalar)> {
		pub fn as_raw_TupleOfGMat_GScalar(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_TupleOfGMat_GScalar(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	tuple_extern! { (crate::gapi::GMat, crate::gapi::GScalar),
		std_tupleLcv_GMat__cv_GScalarG_new_const_GMat_GScalar, std_tupleLcv_GMat__cv_GScalarG_delete,
		0 = arg: crate::gapi::GMat, get_0 via std_tupleLcv_GMat__cv_GScalarG_get_0_const,
		1 = arg_1: crate::gapi::GScalar, get_1 via std_tupleLcv_GMat__cv_GScalarG_get_1_const
	}

	impl core::Vector<crate::gapi::Detail_OpaqueKind> {
		pub fn as_raw_VectorOfDetail_OpaqueKind(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDetail_OpaqueKind(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::Detail_OpaqueKind,
		std_vectorLcv_detail_OpaqueKindG_new_const, std_vectorLcv_detail_OpaqueKindG_delete,
		std_vectorLcv_detail_OpaqueKindG_len_const, std_vectorLcv_detail_OpaqueKindG_isEmpty_const,
		std_vectorLcv_detail_OpaqueKindG_capacity_const, std_vectorLcv_detail_OpaqueKindG_shrinkToFit,
		std_vectorLcv_detail_OpaqueKindG_reserve_size_t, std_vectorLcv_detail_OpaqueKindG_remove_size_t,
		std_vectorLcv_detail_OpaqueKindG_swap_size_t_size_t, std_vectorLcv_detail_OpaqueKindG_clear,
		std_vectorLcv_detail_OpaqueKindG_get_const_size_t, std_vectorLcv_detail_OpaqueKindG_set_size_t_const_OpaqueKind,
		std_vectorLcv_detail_OpaqueKindG_push_const_OpaqueKind, std_vectorLcv_detail_OpaqueKindG_insert_size_t_const_OpaqueKind,
	}

	vector_copy_non_bool! { crate::gapi::Detail_OpaqueKind,
		std_vectorLcv_detail_OpaqueKindG_data_const, std_vectorLcv_detail_OpaqueKindG_dataMut, cv_fromSlice_const_const_OpaqueKindX_size_t,
		std_vectorLcv_detail_OpaqueKindG_clone_const,
	}


	impl core::Vector<crate::gapi::GArg> {
		pub fn as_raw_VectorOfGArg(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGArg(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GArg,
		std_vectorLcv_GArgG_new_const, std_vectorLcv_GArgG_delete,
		std_vectorLcv_GArgG_len_const, std_vectorLcv_GArgG_isEmpty_const,
		std_vectorLcv_GArgG_capacity_const, std_vectorLcv_GArgG_shrinkToFit,
		std_vectorLcv_GArgG_reserve_size_t, std_vectorLcv_GArgG_remove_size_t,
		std_vectorLcv_GArgG_swap_size_t_size_t, std_vectorLcv_GArgG_clear,
		std_vectorLcv_GArgG_get_const_size_t, std_vectorLcv_GArgG_set_size_t_const_GArg,
		std_vectorLcv_GArgG_push_const_GArg, std_vectorLcv_GArgG_insert_size_t_const_GArg,
	}

	vector_non_copy_or_bool! { crate::gapi::GArg }

	vector_boxed_ref! { crate::gapi::GArg }

	vector_extern! { BoxedRef<'t, crate::gapi::GArg>,
		std_vectorLcv_GArgG_new_const, std_vectorLcv_GArgG_delete,
		std_vectorLcv_GArgG_len_const, std_vectorLcv_GArgG_isEmpty_const,
		std_vectorLcv_GArgG_capacity_const, std_vectorLcv_GArgG_shrinkToFit,
		std_vectorLcv_GArgG_reserve_size_t, std_vectorLcv_GArgG_remove_size_t,
		std_vectorLcv_GArgG_swap_size_t_size_t, std_vectorLcv_GArgG_clear,
		std_vectorLcv_GArgG_get_const_size_t, std_vectorLcv_GArgG_set_size_t_const_GArg,
		std_vectorLcv_GArgG_push_const_GArg, std_vectorLcv_GArgG_insert_size_t_const_GArg,
	}


	impl core::Vector<crate::gapi::GBackend> {
		pub fn as_raw_VectorOfGBackend(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGBackend(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GBackend,
		std_vectorLcv_gapi_GBackendG_new_const, std_vectorLcv_gapi_GBackendG_delete,
		std_vectorLcv_gapi_GBackendG_len_const, std_vectorLcv_gapi_GBackendG_isEmpty_const,
		std_vectorLcv_gapi_GBackendG_capacity_const, std_vectorLcv_gapi_GBackendG_shrinkToFit,
		std_vectorLcv_gapi_GBackendG_reserve_size_t, std_vectorLcv_gapi_GBackendG_remove_size_t,
		std_vectorLcv_gapi_GBackendG_swap_size_t_size_t, std_vectorLcv_gapi_GBackendG_clear,
		std_vectorLcv_gapi_GBackendG_get_const_size_t, std_vectorLcv_gapi_GBackendG_set_size_t_const_GBackend,
		std_vectorLcv_gapi_GBackendG_push_const_GBackend, std_vectorLcv_gapi_GBackendG_insert_size_t_const_GBackend,
	}

	vector_non_copy_or_bool! { crate::gapi::GBackend }

	vector_boxed_ref! { crate::gapi::GBackend }

	vector_extern! { BoxedRef<'t, crate::gapi::GBackend>,
		std_vectorLcv_gapi_GBackendG_new_const, std_vectorLcv_gapi_GBackendG_delete,
		std_vectorLcv_gapi_GBackendG_len_const, std_vectorLcv_gapi_GBackendG_isEmpty_const,
		std_vectorLcv_gapi_GBackendG_capacity_const, std_vectorLcv_gapi_GBackendG_shrinkToFit,
		std_vectorLcv_gapi_GBackendG_reserve_size_t, std_vectorLcv_gapi_GBackendG_remove_size_t,
		std_vectorLcv_gapi_GBackendG_swap_size_t_size_t, std_vectorLcv_gapi_GBackendG_clear,
		std_vectorLcv_gapi_GBackendG_get_const_size_t, std_vectorLcv_gapi_GBackendG_set_size_t_const_GBackend,
		std_vectorLcv_gapi_GBackendG_push_const_GBackend, std_vectorLcv_gapi_GBackendG_insert_size_t_const_GBackend,
	}


	impl core::Vector<crate::gapi::GCompileArg> {
		pub fn as_raw_VectorOfGCompileArg(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGCompileArg(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GCompileArg,
		std_vectorLcv_GCompileArgG_new_const, std_vectorLcv_GCompileArgG_delete,
		std_vectorLcv_GCompileArgG_len_const, std_vectorLcv_GCompileArgG_isEmpty_const,
		std_vectorLcv_GCompileArgG_capacity_const, std_vectorLcv_GCompileArgG_shrinkToFit,
		std_vectorLcv_GCompileArgG_reserve_size_t, std_vectorLcv_GCompileArgG_remove_size_t,
		std_vectorLcv_GCompileArgG_swap_size_t_size_t, std_vectorLcv_GCompileArgG_clear,
		std_vectorLcv_GCompileArgG_get_const_size_t, std_vectorLcv_GCompileArgG_set_size_t_const_GCompileArg,
		std_vectorLcv_GCompileArgG_push_const_GCompileArg, std_vectorLcv_GCompileArgG_insert_size_t_const_GCompileArg,
	}

	vector_non_copy_or_bool! { crate::gapi::GCompileArg }

	vector_boxed_ref! { crate::gapi::GCompileArg }

	vector_extern! { BoxedRef<'t, crate::gapi::GCompileArg>,
		std_vectorLcv_GCompileArgG_new_const, std_vectorLcv_GCompileArgG_delete,
		std_vectorLcv_GCompileArgG_len_const, std_vectorLcv_GCompileArgG_isEmpty_const,
		std_vectorLcv_GCompileArgG_capacity_const, std_vectorLcv_GCompileArgG_shrinkToFit,
		std_vectorLcv_GCompileArgG_reserve_size_t, std_vectorLcv_GCompileArgG_remove_size_t,
		std_vectorLcv_GCompileArgG_swap_size_t_size_t, std_vectorLcv_GCompileArgG_clear,
		std_vectorLcv_GCompileArgG_get_const_size_t, std_vectorLcv_GCompileArgG_set_size_t_const_GCompileArg,
		std_vectorLcv_GCompileArgG_push_const_GCompileArg, std_vectorLcv_GCompileArgG_insert_size_t_const_GCompileArg,
	}


	impl core::Vector<crate::gapi::GMat> {
		pub fn as_raw_VectorOfGMat(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGMat(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GMat,
		std_vectorLcv_GMatG_new_const, std_vectorLcv_GMatG_delete,
		std_vectorLcv_GMatG_len_const, std_vectorLcv_GMatG_isEmpty_const,
		std_vectorLcv_GMatG_capacity_const, std_vectorLcv_GMatG_shrinkToFit,
		std_vectorLcv_GMatG_reserve_size_t, std_vectorLcv_GMatG_remove_size_t,
		std_vectorLcv_GMatG_swap_size_t_size_t, std_vectorLcv_GMatG_clear,
		std_vectorLcv_GMatG_get_const_size_t, std_vectorLcv_GMatG_set_size_t_const_GMat,
		std_vectorLcv_GMatG_push_const_GMat, std_vectorLcv_GMatG_insert_size_t_const_GMat,
	}

	vector_non_copy_or_bool! { clone crate::gapi::GMat }

	vector_boxed_ref! { crate::gapi::GMat }

	vector_extern! { BoxedRef<'t, crate::gapi::GMat>,
		std_vectorLcv_GMatG_new_const, std_vectorLcv_GMatG_delete,
		std_vectorLcv_GMatG_len_const, std_vectorLcv_GMatG_isEmpty_const,
		std_vectorLcv_GMatG_capacity_const, std_vectorLcv_GMatG_shrinkToFit,
		std_vectorLcv_GMatG_reserve_size_t, std_vectorLcv_GMatG_remove_size_t,
		std_vectorLcv_GMatG_swap_size_t_size_t, std_vectorLcv_GMatG_clear,
		std_vectorLcv_GMatG_get_const_size_t, std_vectorLcv_GMatG_set_size_t_const_GMat,
		std_vectorLcv_GMatG_push_const_GMat, std_vectorLcv_GMatG_insert_size_t_const_GMat,
	}


	impl core::Vector<crate::gapi::GRunArg> {
		pub fn as_raw_VectorOfGRunArg(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGRunArg(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GRunArg,
		std_vectorLcv_GRunArgG_new_const, std_vectorLcv_GRunArgG_delete,
		std_vectorLcv_GRunArgG_len_const, std_vectorLcv_GRunArgG_isEmpty_const,
		std_vectorLcv_GRunArgG_capacity_const, std_vectorLcv_GRunArgG_shrinkToFit,
		std_vectorLcv_GRunArgG_reserve_size_t, std_vectorLcv_GRunArgG_remove_size_t,
		std_vectorLcv_GRunArgG_swap_size_t_size_t, std_vectorLcv_GRunArgG_clear,
		std_vectorLcv_GRunArgG_get_const_size_t, std_vectorLcv_GRunArgG_set_size_t_const_GRunArg,
		std_vectorLcv_GRunArgG_push_const_GRunArg, std_vectorLcv_GRunArgG_insert_size_t_const_GRunArg,
	}

	vector_non_copy_or_bool! { crate::gapi::GRunArg }

	vector_boxed_ref! { crate::gapi::GRunArg }

	vector_extern! { BoxedRef<'t, crate::gapi::GRunArg>,
		std_vectorLcv_GRunArgG_new_const, std_vectorLcv_GRunArgG_delete,
		std_vectorLcv_GRunArgG_len_const, std_vectorLcv_GRunArgG_isEmpty_const,
		std_vectorLcv_GRunArgG_capacity_const, std_vectorLcv_GRunArgG_shrinkToFit,
		std_vectorLcv_GRunArgG_reserve_size_t, std_vectorLcv_GRunArgG_remove_size_t,
		std_vectorLcv_GRunArgG_swap_size_t_size_t, std_vectorLcv_GRunArgG_clear,
		std_vectorLcv_GRunArgG_get_const_size_t, std_vectorLcv_GRunArgG_set_size_t_const_GRunArg,
		std_vectorLcv_GRunArgG_push_const_GRunArg, std_vectorLcv_GRunArgG_insert_size_t_const_GRunArg,
	}


	impl core::Vector<crate::gapi::GShape> {
		pub fn as_raw_VectorOfGShape(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGShape(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GShape,
		std_vectorLcv_GShapeG_new_const, std_vectorLcv_GShapeG_delete,
		std_vectorLcv_GShapeG_len_const, std_vectorLcv_GShapeG_isEmpty_const,
		std_vectorLcv_GShapeG_capacity_const, std_vectorLcv_GShapeG_shrinkToFit,
		std_vectorLcv_GShapeG_reserve_size_t, std_vectorLcv_GShapeG_remove_size_t,
		std_vectorLcv_GShapeG_swap_size_t_size_t, std_vectorLcv_GShapeG_clear,
		std_vectorLcv_GShapeG_get_const_size_t, std_vectorLcv_GShapeG_set_size_t_const_GShape,
		std_vectorLcv_GShapeG_push_const_GShape, std_vectorLcv_GShapeG_insert_size_t_const_GShape,
	}

	vector_copy_non_bool! { crate::gapi::GShape,
		std_vectorLcv_GShapeG_data_const, std_vectorLcv_GShapeG_dataMut, cv_fromSlice_const_const_GShapeX_size_t,
		std_vectorLcv_GShapeG_clone_const,
	}


	impl core::Vector<crate::gapi::GTransform> {
		pub fn as_raw_VectorOfGTransform(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGTransform(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GTransform,
		std_vectorLcv_GTransformG_new_const, std_vectorLcv_GTransformG_delete,
		std_vectorLcv_GTransformG_len_const, std_vectorLcv_GTransformG_isEmpty_const,
		std_vectorLcv_GTransformG_capacity_const, std_vectorLcv_GTransformG_shrinkToFit,
		std_vectorLcv_GTransformG_reserve_size_t, std_vectorLcv_GTransformG_remove_size_t,
		std_vectorLcv_GTransformG_swap_size_t_size_t, std_vectorLcv_GTransformG_clear,
		std_vectorLcv_GTransformG_get_const_size_t, std_vectorLcv_GTransformG_set_size_t_const_GTransform,
		std_vectorLcv_GTransformG_push_const_GTransform, std_vectorLcv_GTransformG_insert_size_t_const_GTransform,
	}

	vector_non_copy_or_bool! { crate::gapi::GTransform }

	vector_boxed_ref! { crate::gapi::GTransform }

	vector_extern! { BoxedRef<'t, crate::gapi::GTransform>,
		std_vectorLcv_GTransformG_new_const, std_vectorLcv_GTransformG_delete,
		std_vectorLcv_GTransformG_len_const, std_vectorLcv_GTransformG_isEmpty_const,
		std_vectorLcv_GTransformG_capacity_const, std_vectorLcv_GTransformG_shrinkToFit,
		std_vectorLcv_GTransformG_reserve_size_t, std_vectorLcv_GTransformG_remove_size_t,
		std_vectorLcv_GTransformG_swap_size_t_size_t, std_vectorLcv_GTransformG_clear,
		std_vectorLcv_GTransformG_get_const_size_t, std_vectorLcv_GTransformG_set_size_t_const_GTransform,
		std_vectorLcv_GTransformG_push_const_GTransform, std_vectorLcv_GTransformG_insert_size_t_const_GTransform,
	}


	impl core::Vector<crate::gapi::GTypeInfo> {
		pub fn as_raw_VectorOfGTypeInfo(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGTypeInfo(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::gapi::GTypeInfo,
		std_vectorLcv_GTypeInfoG_new_const, std_vectorLcv_GTypeInfoG_delete,
		std_vectorLcv_GTypeInfoG_len_const, std_vectorLcv_GTypeInfoG_isEmpty_const,
		std_vectorLcv_GTypeInfoG_capacity_const, std_vectorLcv_GTypeInfoG_shrinkToFit,
		std_vectorLcv_GTypeInfoG_reserve_size_t, std_vectorLcv_GTypeInfoG_remove_size_t,
		std_vectorLcv_GTypeInfoG_swap_size_t_size_t, std_vectorLcv_GTypeInfoG_clear,
		std_vectorLcv_GTypeInfoG_get_const_size_t, std_vectorLcv_GTypeInfoG_set_size_t_const_GTypeInfo,
		std_vectorLcv_GTypeInfoG_push_const_GTypeInfo, std_vectorLcv_GTypeInfoG_insert_size_t_const_GTypeInfo,
	}

	vector_non_copy_or_bool! { clone crate::gapi::GTypeInfo }

	vector_boxed_ref! { crate::gapi::GTypeInfo }

	vector_extern! { BoxedRef<'t, crate::gapi::GTypeInfo>,
		std_vectorLcv_GTypeInfoG_new_const, std_vectorLcv_GTypeInfoG_delete,
		std_vectorLcv_GTypeInfoG_len_const, std_vectorLcv_GTypeInfoG_isEmpty_const,
		std_vectorLcv_GTypeInfoG_capacity_const, std_vectorLcv_GTypeInfoG_shrinkToFit,
		std_vectorLcv_GTypeInfoG_reserve_size_t, std_vectorLcv_GTypeInfoG_remove_size_t,
		std_vectorLcv_GTypeInfoG_swap_size_t_size_t, std_vectorLcv_GTypeInfoG_clear,
		std_vectorLcv_GTypeInfoG_get_const_size_t, std_vectorLcv_GTypeInfoG_set_size_t_const_GTypeInfo,
		std_vectorLcv_GTypeInfoG_push_const_GTypeInfo, std_vectorLcv_GTypeInfoG_insert_size_t_const_GTypeInfo,
	}


}
pub use gapi_types::*;

mod hdf_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::hdf::HDF5,
		cv_PtrLcv_hdf_HDF5G_new_null_const, cv_PtrLcv_hdf_HDF5G_delete, cv_PtrLcv_hdf_HDF5G_getInnerPtr_const, cv_PtrLcv_hdf_HDF5G_getInnerPtrMut
	}

	impl core::Ptr<crate::hdf::HDF5> {
		#[inline] pub fn as_raw_PtrOfHDF5(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHDF5(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::hdf::HDF5TraitConst for core::Ptr<crate::hdf::HDF5> {
		#[inline] fn as_raw_HDF5(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::hdf::HDF5Trait for core::Ptr<crate::hdf::HDF5> {
		#[inline] fn as_raw_mut_HDF5(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::hdf::HDF5> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHDF5")
				.finish()
		}
	}

}
pub use hdf_types::*;

mod hfs_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::hfs::HfsSegment,
		cv_PtrLcv_hfs_HfsSegmentG_new_null_const, cv_PtrLcv_hfs_HfsSegmentG_delete, cv_PtrLcv_hfs_HfsSegmentG_getInnerPtr_const, cv_PtrLcv_hfs_HfsSegmentG_getInnerPtrMut
	}

	impl core::Ptr<crate::hfs::HfsSegment> {
		#[inline] pub fn as_raw_PtrOfHfsSegment(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHfsSegment(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::hfs::HfsSegmentTraitConst for core::Ptr<crate::hfs::HfsSegment> {
		#[inline] fn as_raw_HfsSegment(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::hfs::HfsSegmentTrait for core::Ptr<crate::hfs::HfsSegment> {
		#[inline] fn as_raw_mut_HfsSegment(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::hfs::HfsSegment> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::hfs::HfsSegment> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::hfs::HfsSegment>, core::Ptr<core::Algorithm>, cv_PtrLcv_hfs_HfsSegmentG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::hfs::HfsSegment> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHfsSegment")
				.finish()
		}
	}

}
pub use hfs_types::*;

mod img_hash_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::img_hash::AverageHash,
		cv_PtrLcv_img_hash_AverageHashG_new_null_const, cv_PtrLcv_img_hash_AverageHashG_delete, cv_PtrLcv_img_hash_AverageHashG_getInnerPtr_const, cv_PtrLcv_img_hash_AverageHashG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::img_hash::AverageHash, cv_PtrLcv_img_hash_AverageHashG_new_const_AverageHash }
	impl core::Ptr<crate::img_hash::AverageHash> {
		#[inline] pub fn as_raw_PtrOfAverageHash(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAverageHash(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::img_hash::AverageHashTraitConst for core::Ptr<crate::img_hash::AverageHash> {
		#[inline] fn as_raw_AverageHash(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::AverageHashTrait for core::Ptr<crate::img_hash::AverageHash> {
		#[inline] fn as_raw_mut_AverageHash(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::img_hash::AverageHash> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::img_hash::AverageHash> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::AverageHash>, core::Ptr<core::Algorithm>, cv_PtrLcv_img_hash_AverageHashG_to_PtrOfAlgorithm }

	impl crate::img_hash::ImgHashBaseTraitConst for core::Ptr<crate::img_hash::AverageHash> {
		#[inline] fn as_raw_ImgHashBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ImgHashBaseTrait for core::Ptr<crate::img_hash::AverageHash> {
		#[inline] fn as_raw_mut_ImgHashBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::AverageHash>, core::Ptr<crate::img_hash::ImgHashBase>, cv_PtrLcv_img_hash_AverageHashG_to_PtrOfImgHashBase }

	impl std::fmt::Debug for core::Ptr<crate::img_hash::AverageHash> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAverageHash")
				.finish()
		}
	}

	ptr_extern! { crate::img_hash::BlockMeanHash,
		cv_PtrLcv_img_hash_BlockMeanHashG_new_null_const, cv_PtrLcv_img_hash_BlockMeanHashG_delete, cv_PtrLcv_img_hash_BlockMeanHashG_getInnerPtr_const, cv_PtrLcv_img_hash_BlockMeanHashG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::img_hash::BlockMeanHash, cv_PtrLcv_img_hash_BlockMeanHashG_new_const_BlockMeanHash }
	impl core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline] pub fn as_raw_PtrOfBlockMeanHash(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBlockMeanHash(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::img_hash::BlockMeanHashTraitConst for core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline] fn as_raw_BlockMeanHash(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::BlockMeanHashTrait for core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline] fn as_raw_mut_BlockMeanHash(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::BlockMeanHash>, core::Ptr<core::Algorithm>, cv_PtrLcv_img_hash_BlockMeanHashG_to_PtrOfAlgorithm }

	impl crate::img_hash::ImgHashBaseTraitConst for core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline] fn as_raw_ImgHashBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ImgHashBaseTrait for core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline] fn as_raw_mut_ImgHashBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::BlockMeanHash>, core::Ptr<crate::img_hash::ImgHashBase>, cv_PtrLcv_img_hash_BlockMeanHashG_to_PtrOfImgHashBase }

	impl std::fmt::Debug for core::Ptr<crate::img_hash::BlockMeanHash> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBlockMeanHash")
				.finish()
		}
	}

	ptr_extern! { crate::img_hash::ColorMomentHash,
		cv_PtrLcv_img_hash_ColorMomentHashG_new_null_const, cv_PtrLcv_img_hash_ColorMomentHashG_delete, cv_PtrLcv_img_hash_ColorMomentHashG_getInnerPtr_const, cv_PtrLcv_img_hash_ColorMomentHashG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::img_hash::ColorMomentHash, cv_PtrLcv_img_hash_ColorMomentHashG_new_const_ColorMomentHash }
	impl core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline] pub fn as_raw_PtrOfColorMomentHash(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfColorMomentHash(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::img_hash::ColorMomentHashTraitConst for core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline] fn as_raw_ColorMomentHash(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ColorMomentHashTrait for core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline] fn as_raw_mut_ColorMomentHash(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::ColorMomentHash>, core::Ptr<core::Algorithm>, cv_PtrLcv_img_hash_ColorMomentHashG_to_PtrOfAlgorithm }

	impl crate::img_hash::ImgHashBaseTraitConst for core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline] fn as_raw_ImgHashBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ImgHashBaseTrait for core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline] fn as_raw_mut_ImgHashBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::ColorMomentHash>, core::Ptr<crate::img_hash::ImgHashBase>, cv_PtrLcv_img_hash_ColorMomentHashG_to_PtrOfImgHashBase }

	impl std::fmt::Debug for core::Ptr<crate::img_hash::ColorMomentHash> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfColorMomentHash")
				.finish()
		}
	}

	ptr_extern! { crate::img_hash::ImgHashBase,
		cv_PtrLcv_img_hash_ImgHashBaseG_new_null_const, cv_PtrLcv_img_hash_ImgHashBaseG_delete, cv_PtrLcv_img_hash_ImgHashBaseG_getInnerPtr_const, cv_PtrLcv_img_hash_ImgHashBaseG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::img_hash::ImgHashBase, cv_PtrLcv_img_hash_ImgHashBaseG_new_const_ImgHashBase }
	impl core::Ptr<crate::img_hash::ImgHashBase> {
		#[inline] pub fn as_raw_PtrOfImgHashBase(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfImgHashBase(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::img_hash::ImgHashBaseTraitConst for core::Ptr<crate::img_hash::ImgHashBase> {
		#[inline] fn as_raw_ImgHashBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ImgHashBaseTrait for core::Ptr<crate::img_hash::ImgHashBase> {
		#[inline] fn as_raw_mut_ImgHashBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::img_hash::ImgHashBase> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::img_hash::ImgHashBase> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::ImgHashBase>, core::Ptr<core::Algorithm>, cv_PtrLcv_img_hash_ImgHashBaseG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::img_hash::ImgHashBase> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfImgHashBase")
				.finish()
		}
	}

	ptr_extern! { crate::img_hash::MarrHildrethHash,
		cv_PtrLcv_img_hash_MarrHildrethHashG_new_null_const, cv_PtrLcv_img_hash_MarrHildrethHashG_delete, cv_PtrLcv_img_hash_MarrHildrethHashG_getInnerPtr_const, cv_PtrLcv_img_hash_MarrHildrethHashG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::img_hash::MarrHildrethHash, cv_PtrLcv_img_hash_MarrHildrethHashG_new_const_MarrHildrethHash }
	impl core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline] pub fn as_raw_PtrOfMarrHildrethHash(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMarrHildrethHash(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::img_hash::MarrHildrethHashTraitConst for core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline] fn as_raw_MarrHildrethHash(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::MarrHildrethHashTrait for core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline] fn as_raw_mut_MarrHildrethHash(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::MarrHildrethHash>, core::Ptr<core::Algorithm>, cv_PtrLcv_img_hash_MarrHildrethHashG_to_PtrOfAlgorithm }

	impl crate::img_hash::ImgHashBaseTraitConst for core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline] fn as_raw_ImgHashBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ImgHashBaseTrait for core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline] fn as_raw_mut_ImgHashBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::MarrHildrethHash>, core::Ptr<crate::img_hash::ImgHashBase>, cv_PtrLcv_img_hash_MarrHildrethHashG_to_PtrOfImgHashBase }

	impl std::fmt::Debug for core::Ptr<crate::img_hash::MarrHildrethHash> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMarrHildrethHash")
				.finish()
		}
	}

	ptr_extern! { crate::img_hash::PHash,
		cv_PtrLcv_img_hash_PHashG_new_null_const, cv_PtrLcv_img_hash_PHashG_delete, cv_PtrLcv_img_hash_PHashG_getInnerPtr_const, cv_PtrLcv_img_hash_PHashG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::img_hash::PHash, cv_PtrLcv_img_hash_PHashG_new_const_PHash }
	impl core::Ptr<crate::img_hash::PHash> {
		#[inline] pub fn as_raw_PtrOfPHash(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPHash(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::img_hash::PHashTraitConst for core::Ptr<crate::img_hash::PHash> {
		#[inline] fn as_raw_PHash(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::PHashTrait for core::Ptr<crate::img_hash::PHash> {
		#[inline] fn as_raw_mut_PHash(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::img_hash::PHash> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::img_hash::PHash> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::PHash>, core::Ptr<core::Algorithm>, cv_PtrLcv_img_hash_PHashG_to_PtrOfAlgorithm }

	impl crate::img_hash::ImgHashBaseTraitConst for core::Ptr<crate::img_hash::PHash> {
		#[inline] fn as_raw_ImgHashBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ImgHashBaseTrait for core::Ptr<crate::img_hash::PHash> {
		#[inline] fn as_raw_mut_ImgHashBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::PHash>, core::Ptr<crate::img_hash::ImgHashBase>, cv_PtrLcv_img_hash_PHashG_to_PtrOfImgHashBase }

	impl std::fmt::Debug for core::Ptr<crate::img_hash::PHash> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPHash")
				.finish()
		}
	}

	ptr_extern! { crate::img_hash::RadialVarianceHash,
		cv_PtrLcv_img_hash_RadialVarianceHashG_new_null_const, cv_PtrLcv_img_hash_RadialVarianceHashG_delete, cv_PtrLcv_img_hash_RadialVarianceHashG_getInnerPtr_const, cv_PtrLcv_img_hash_RadialVarianceHashG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::img_hash::RadialVarianceHash, cv_PtrLcv_img_hash_RadialVarianceHashG_new_const_RadialVarianceHash }
	impl core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline] pub fn as_raw_PtrOfRadialVarianceHash(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRadialVarianceHash(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::img_hash::RadialVarianceHashTraitConst for core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline] fn as_raw_RadialVarianceHash(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::RadialVarianceHashTrait for core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline] fn as_raw_mut_RadialVarianceHash(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::RadialVarianceHash>, core::Ptr<core::Algorithm>, cv_PtrLcv_img_hash_RadialVarianceHashG_to_PtrOfAlgorithm }

	impl crate::img_hash::ImgHashBaseTraitConst for core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline] fn as_raw_ImgHashBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::img_hash::ImgHashBaseTrait for core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline] fn as_raw_mut_ImgHashBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::img_hash::RadialVarianceHash>, core::Ptr<crate::img_hash::ImgHashBase>, cv_PtrLcv_img_hash_RadialVarianceHashG_to_PtrOfImgHashBase }

	impl std::fmt::Debug for core::Ptr<crate::img_hash::RadialVarianceHash> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRadialVarianceHash")
				.finish()
		}
	}

}
pub use img_hash_types::*;

mod imgproc_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::imgproc::CLAHE,
		cv_PtrLcv_CLAHEG_new_null_const, cv_PtrLcv_CLAHEG_delete, cv_PtrLcv_CLAHEG_getInnerPtr_const, cv_PtrLcv_CLAHEG_getInnerPtrMut
	}

	impl core::Ptr<crate::imgproc::CLAHE> {
		#[inline] pub fn as_raw_PtrOfCLAHE(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCLAHE(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::imgproc::CLAHETraitConst for core::Ptr<crate::imgproc::CLAHE> {
		#[inline] fn as_raw_CLAHE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::CLAHETrait for core::Ptr<crate::imgproc::CLAHE> {
		#[inline] fn as_raw_mut_CLAHE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::imgproc::CLAHE> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::imgproc::CLAHE> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::imgproc::CLAHE>, core::Ptr<core::Algorithm>, cv_PtrLcv_CLAHEG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::imgproc::CLAHE> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCLAHE")
				.finish()
		}
	}

	ptr_extern! { crate::imgproc::GeneralizedHough,
		cv_PtrLcv_GeneralizedHoughG_new_null_const, cv_PtrLcv_GeneralizedHoughG_delete, cv_PtrLcv_GeneralizedHoughG_getInnerPtr_const, cv_PtrLcv_GeneralizedHoughG_getInnerPtrMut
	}

	impl core::Ptr<crate::imgproc::GeneralizedHough> {
		#[inline] pub fn as_raw_PtrOfGeneralizedHough(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGeneralizedHough(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::imgproc::GeneralizedHoughTraitConst for core::Ptr<crate::imgproc::GeneralizedHough> {
		#[inline] fn as_raw_GeneralizedHough(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::GeneralizedHoughTrait for core::Ptr<crate::imgproc::GeneralizedHough> {
		#[inline] fn as_raw_mut_GeneralizedHough(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::imgproc::GeneralizedHough> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::imgproc::GeneralizedHough> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::imgproc::GeneralizedHough>, core::Ptr<core::Algorithm>, cv_PtrLcv_GeneralizedHoughG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::imgproc::GeneralizedHough> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGeneralizedHough")
				.finish()
		}
	}

	ptr_extern! { crate::imgproc::GeneralizedHoughBallard,
		cv_PtrLcv_GeneralizedHoughBallardG_new_null_const, cv_PtrLcv_GeneralizedHoughBallardG_delete, cv_PtrLcv_GeneralizedHoughBallardG_getInnerPtr_const, cv_PtrLcv_GeneralizedHoughBallardG_getInnerPtrMut
	}

	impl core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline] pub fn as_raw_PtrOfGeneralizedHoughBallard(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGeneralizedHoughBallard(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::imgproc::GeneralizedHoughBallardTraitConst for core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline] fn as_raw_GeneralizedHoughBallard(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::GeneralizedHoughBallardTrait for core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline] fn as_raw_mut_GeneralizedHoughBallard(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::imgproc::GeneralizedHoughBallard>, core::Ptr<core::Algorithm>, cv_PtrLcv_GeneralizedHoughBallardG_to_PtrOfAlgorithm }

	impl crate::imgproc::GeneralizedHoughTraitConst for core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline] fn as_raw_GeneralizedHough(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::GeneralizedHoughTrait for core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline] fn as_raw_mut_GeneralizedHough(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::imgproc::GeneralizedHoughBallard>, core::Ptr<crate::imgproc::GeneralizedHough>, cv_PtrLcv_GeneralizedHoughBallardG_to_PtrOfGeneralizedHough }

	impl std::fmt::Debug for core::Ptr<crate::imgproc::GeneralizedHoughBallard> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGeneralizedHoughBallard")
				.finish()
		}
	}

	ptr_extern! { crate::imgproc::GeneralizedHoughGuil,
		cv_PtrLcv_GeneralizedHoughGuilG_new_null_const, cv_PtrLcv_GeneralizedHoughGuilG_delete, cv_PtrLcv_GeneralizedHoughGuilG_getInnerPtr_const, cv_PtrLcv_GeneralizedHoughGuilG_getInnerPtrMut
	}

	impl core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline] pub fn as_raw_PtrOfGeneralizedHoughGuil(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGeneralizedHoughGuil(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::imgproc::GeneralizedHoughGuilTraitConst for core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline] fn as_raw_GeneralizedHoughGuil(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::GeneralizedHoughGuilTrait for core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline] fn as_raw_mut_GeneralizedHoughGuil(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::imgproc::GeneralizedHoughGuil>, core::Ptr<core::Algorithm>, cv_PtrLcv_GeneralizedHoughGuilG_to_PtrOfAlgorithm }

	impl crate::imgproc::GeneralizedHoughTraitConst for core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline] fn as_raw_GeneralizedHough(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::GeneralizedHoughTrait for core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline] fn as_raw_mut_GeneralizedHough(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::imgproc::GeneralizedHoughGuil>, core::Ptr<crate::imgproc::GeneralizedHough>, cv_PtrLcv_GeneralizedHoughGuilG_to_PtrOfGeneralizedHough }

	impl std::fmt::Debug for core::Ptr<crate::imgproc::GeneralizedHoughGuil> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGeneralizedHoughGuil")
				.finish()
		}
	}

	ptr_extern! { crate::imgproc::LineSegmentDetector,
		cv_PtrLcv_LineSegmentDetectorG_new_null_const, cv_PtrLcv_LineSegmentDetectorG_delete, cv_PtrLcv_LineSegmentDetectorG_getInnerPtr_const, cv_PtrLcv_LineSegmentDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::imgproc::LineSegmentDetector> {
		#[inline] pub fn as_raw_PtrOfLineSegmentDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLineSegmentDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::imgproc::LineSegmentDetectorTraitConst for core::Ptr<crate::imgproc::LineSegmentDetector> {
		#[inline] fn as_raw_LineSegmentDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::imgproc::LineSegmentDetectorTrait for core::Ptr<crate::imgproc::LineSegmentDetector> {
		#[inline] fn as_raw_mut_LineSegmentDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::imgproc::LineSegmentDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::imgproc::LineSegmentDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::imgproc::LineSegmentDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_LineSegmentDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::imgproc::LineSegmentDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLineSegmentDetector")
				.finish()
		}
	}

}
pub use imgproc_types::*;

mod line_descriptor_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::line_descriptor::BinaryDescriptor,
		cv_PtrLcv_line_descriptor_BinaryDescriptorG_new_null_const, cv_PtrLcv_line_descriptor_BinaryDescriptorG_delete, cv_PtrLcv_line_descriptor_BinaryDescriptorG_getInnerPtr_const, cv_PtrLcv_line_descriptor_BinaryDescriptorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::line_descriptor::BinaryDescriptor, cv_PtrLcv_line_descriptor_BinaryDescriptorG_new_const_BinaryDescriptor }
	impl core::Ptr<crate::line_descriptor::BinaryDescriptor> {
		#[inline] pub fn as_raw_PtrOfBinaryDescriptor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBinaryDescriptor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::line_descriptor::BinaryDescriptorTraitConst for core::Ptr<crate::line_descriptor::BinaryDescriptor> {
		#[inline] fn as_raw_BinaryDescriptor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::line_descriptor::BinaryDescriptorTrait for core::Ptr<crate::line_descriptor::BinaryDescriptor> {
		#[inline] fn as_raw_mut_BinaryDescriptor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::line_descriptor::BinaryDescriptor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::line_descriptor::BinaryDescriptor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::line_descriptor::BinaryDescriptor>, core::Ptr<core::Algorithm>, cv_PtrLcv_line_descriptor_BinaryDescriptorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::line_descriptor::BinaryDescriptor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBinaryDescriptor")
				.finish()
		}
	}

	ptr_extern! { crate::line_descriptor::BinaryDescriptorMatcher,
		cv_PtrLcv_line_descriptor_BinaryDescriptorMatcherG_new_null_const, cv_PtrLcv_line_descriptor_BinaryDescriptorMatcherG_delete, cv_PtrLcv_line_descriptor_BinaryDescriptorMatcherG_getInnerPtr_const, cv_PtrLcv_line_descriptor_BinaryDescriptorMatcherG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::line_descriptor::BinaryDescriptorMatcher, cv_PtrLcv_line_descriptor_BinaryDescriptorMatcherG_new_const_BinaryDescriptorMatcher }
	impl core::Ptr<crate::line_descriptor::BinaryDescriptorMatcher> {
		#[inline] pub fn as_raw_PtrOfBinaryDescriptorMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBinaryDescriptorMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::line_descriptor::BinaryDescriptorMatcherTraitConst for core::Ptr<crate::line_descriptor::BinaryDescriptorMatcher> {
		#[inline] fn as_raw_BinaryDescriptorMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::line_descriptor::BinaryDescriptorMatcherTrait for core::Ptr<crate::line_descriptor::BinaryDescriptorMatcher> {
		#[inline] fn as_raw_mut_BinaryDescriptorMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::line_descriptor::BinaryDescriptorMatcher> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::line_descriptor::BinaryDescriptorMatcher> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::line_descriptor::BinaryDescriptorMatcher>, core::Ptr<core::Algorithm>, cv_PtrLcv_line_descriptor_BinaryDescriptorMatcherG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::line_descriptor::BinaryDescriptorMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBinaryDescriptorMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::line_descriptor::LSDDetector,
		cv_PtrLcv_line_descriptor_LSDDetectorG_new_null_const, cv_PtrLcv_line_descriptor_LSDDetectorG_delete, cv_PtrLcv_line_descriptor_LSDDetectorG_getInnerPtr_const, cv_PtrLcv_line_descriptor_LSDDetectorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::line_descriptor::LSDDetector, cv_PtrLcv_line_descriptor_LSDDetectorG_new_const_LSDDetector }
	impl core::Ptr<crate::line_descriptor::LSDDetector> {
		#[inline] pub fn as_raw_PtrOfLSDDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLSDDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::line_descriptor::LSDDetectorTraitConst for core::Ptr<crate::line_descriptor::LSDDetector> {
		#[inline] fn as_raw_LSDDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::line_descriptor::LSDDetectorTrait for core::Ptr<crate::line_descriptor::LSDDetector> {
		#[inline] fn as_raw_mut_LSDDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::line_descriptor::LSDDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::line_descriptor::LSDDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::line_descriptor::LSDDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_line_descriptor_LSDDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::line_descriptor::LSDDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLSDDetector")
				.finish()
		}
	}

	impl core::Vector<crate::line_descriptor::KeyLine> {
		pub fn as_raw_VectorOfKeyLine(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfKeyLine(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::line_descriptor::KeyLine,
		std_vectorLcv_line_descriptor_KeyLineG_new_const, std_vectorLcv_line_descriptor_KeyLineG_delete,
		std_vectorLcv_line_descriptor_KeyLineG_len_const, std_vectorLcv_line_descriptor_KeyLineG_isEmpty_const,
		std_vectorLcv_line_descriptor_KeyLineG_capacity_const, std_vectorLcv_line_descriptor_KeyLineG_shrinkToFit,
		std_vectorLcv_line_descriptor_KeyLineG_reserve_size_t, std_vectorLcv_line_descriptor_KeyLineG_remove_size_t,
		std_vectorLcv_line_descriptor_KeyLineG_swap_size_t_size_t, std_vectorLcv_line_descriptor_KeyLineG_clear,
		std_vectorLcv_line_descriptor_KeyLineG_get_const_size_t, std_vectorLcv_line_descriptor_KeyLineG_set_size_t_const_KeyLine,
		std_vectorLcv_line_descriptor_KeyLineG_push_const_KeyLine, std_vectorLcv_line_descriptor_KeyLineG_insert_size_t_const_KeyLine,
	}

	vector_copy_non_bool! { crate::line_descriptor::KeyLine,
		std_vectorLcv_line_descriptor_KeyLineG_data_const, std_vectorLcv_line_descriptor_KeyLineG_dataMut, cv_fromSlice_const_const_KeyLineX_size_t,
		std_vectorLcv_line_descriptor_KeyLineG_clone_const,
	}


	impl core::Vector<core::Vector<crate::line_descriptor::KeyLine>> {
		pub fn as_raw_VectorOfVectorOfKeyLine(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfVectorOfKeyLine(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Vector<crate::line_descriptor::KeyLine>,
		std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_new_const, std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_delete,
		std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_len_const, std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_isEmpty_const,
		std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_capacity_const, std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_shrinkToFit,
		std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_reserve_size_t, std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_remove_size_t,
		std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_swap_size_t_size_t, std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_clear,
		std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_get_const_size_t, std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_set_size_t_const_vectorLKeyLineG,
		std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_push_const_vectorLKeyLineG, std_vectorLstd_vectorLcv_line_descriptor_KeyLineGG_insert_size_t_const_vectorLKeyLineG,
	}

	vector_non_copy_or_bool! { clone core::Vector<crate::line_descriptor::KeyLine> }


}
pub use line_descriptor_types::*;

mod mcc_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::mcc::MCC_CChecker,
		cv_PtrLcv_mcc_CCheckerG_new_null_const, cv_PtrLcv_mcc_CCheckerG_delete, cv_PtrLcv_mcc_CCheckerG_getInnerPtr_const, cv_PtrLcv_mcc_CCheckerG_getInnerPtrMut
	}

	impl core::Ptr<crate::mcc::MCC_CChecker> {
		#[inline] pub fn as_raw_PtrOfMCC_CChecker(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMCC_CChecker(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::mcc::MCC_CCheckerTraitConst for core::Ptr<crate::mcc::MCC_CChecker> {
		#[inline] fn as_raw_MCC_CChecker(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::mcc::MCC_CCheckerTrait for core::Ptr<crate::mcc::MCC_CChecker> {
		#[inline] fn as_raw_mut_MCC_CChecker(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::mcc::MCC_CChecker> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMCC_CChecker")
				.finish()
		}
	}

	ptr_extern! { crate::mcc::MCC_CCheckerDetector,
		cv_PtrLcv_mcc_CCheckerDetectorG_new_null_const, cv_PtrLcv_mcc_CCheckerDetectorG_delete, cv_PtrLcv_mcc_CCheckerDetectorG_getInnerPtr_const, cv_PtrLcv_mcc_CCheckerDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::mcc::MCC_CCheckerDetector> {
		#[inline] pub fn as_raw_PtrOfMCC_CCheckerDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMCC_CCheckerDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::mcc::MCC_CCheckerDetectorTraitConst for core::Ptr<crate::mcc::MCC_CCheckerDetector> {
		#[inline] fn as_raw_MCC_CCheckerDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::mcc::MCC_CCheckerDetectorTrait for core::Ptr<crate::mcc::MCC_CCheckerDetector> {
		#[inline] fn as_raw_mut_MCC_CCheckerDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::mcc::MCC_CCheckerDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::mcc::MCC_CCheckerDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::mcc::MCC_CCheckerDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_mcc_CCheckerDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::mcc::MCC_CCheckerDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMCC_CCheckerDetector")
				.finish()
		}
	}

	ptr_extern! { crate::mcc::MCC_CCheckerDraw,
		cv_PtrLcv_mcc_CCheckerDrawG_new_null_const, cv_PtrLcv_mcc_CCheckerDrawG_delete, cv_PtrLcv_mcc_CCheckerDrawG_getInnerPtr_const, cv_PtrLcv_mcc_CCheckerDrawG_getInnerPtrMut
	}

	impl core::Ptr<crate::mcc::MCC_CCheckerDraw> {
		#[inline] pub fn as_raw_PtrOfMCC_CCheckerDraw(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMCC_CCheckerDraw(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::mcc::MCC_CCheckerDrawTraitConst for core::Ptr<crate::mcc::MCC_CCheckerDraw> {
		#[inline] fn as_raw_MCC_CCheckerDraw(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::mcc::MCC_CCheckerDrawTrait for core::Ptr<crate::mcc::MCC_CCheckerDraw> {
		#[inline] fn as_raw_mut_MCC_CCheckerDraw(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::mcc::MCC_CCheckerDraw> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMCC_CCheckerDraw")
				.finish()
		}
	}

	ptr_extern! { crate::mcc::MCC_DetectorParameters,
		cv_PtrLcv_mcc_DetectorParametersG_new_null_const, cv_PtrLcv_mcc_DetectorParametersG_delete, cv_PtrLcv_mcc_DetectorParametersG_getInnerPtr_const, cv_PtrLcv_mcc_DetectorParametersG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::mcc::MCC_DetectorParameters, cv_PtrLcv_mcc_DetectorParametersG_new_const_DetectorParameters }
	impl core::Ptr<crate::mcc::MCC_DetectorParameters> {
		#[inline] pub fn as_raw_PtrOfMCC_DetectorParameters(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMCC_DetectorParameters(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::mcc::MCC_DetectorParametersTraitConst for core::Ptr<crate::mcc::MCC_DetectorParameters> {
		#[inline] fn as_raw_MCC_DetectorParameters(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::mcc::MCC_DetectorParametersTrait for core::Ptr<crate::mcc::MCC_DetectorParameters> {
		#[inline] fn as_raw_mut_MCC_DetectorParameters(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::mcc::MCC_DetectorParameters> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMCC_DetectorParameters")
				.field("adaptive_thresh_win_size_min", &crate::mcc::MCC_DetectorParametersTraitConst::adaptive_thresh_win_size_min(self))
				.field("adaptive_thresh_win_size_max", &crate::mcc::MCC_DetectorParametersTraitConst::adaptive_thresh_win_size_max(self))
				.field("adaptive_thresh_win_size_step", &crate::mcc::MCC_DetectorParametersTraitConst::adaptive_thresh_win_size_step(self))
				.field("adaptive_thresh_constant", &crate::mcc::MCC_DetectorParametersTraitConst::adaptive_thresh_constant(self))
				.field("min_contours_area_rate", &crate::mcc::MCC_DetectorParametersTraitConst::min_contours_area_rate(self))
				.field("min_contours_area", &crate::mcc::MCC_DetectorParametersTraitConst::min_contours_area(self))
				.field("confidence_threshold", &crate::mcc::MCC_DetectorParametersTraitConst::confidence_threshold(self))
				.field("min_contour_solidity", &crate::mcc::MCC_DetectorParametersTraitConst::min_contour_solidity(self))
				.field("find_candidates_approx_poly_dp_eps_multiplier", &crate::mcc::MCC_DetectorParametersTraitConst::find_candidates_approx_poly_dp_eps_multiplier(self))
				.field("border_width", &crate::mcc::MCC_DetectorParametersTraitConst::border_width(self))
				.field("b0factor", &crate::mcc::MCC_DetectorParametersTraitConst::b0factor(self))
				.field("max_error", &crate::mcc::MCC_DetectorParametersTraitConst::max_error(self))
				.field("min_contour_points_allowed", &crate::mcc::MCC_DetectorParametersTraitConst::min_contour_points_allowed(self))
				.field("min_contour_length_allowed", &crate::mcc::MCC_DetectorParametersTraitConst::min_contour_length_allowed(self))
				.field("min_inter_contour_distance", &crate::mcc::MCC_DetectorParametersTraitConst::min_inter_contour_distance(self))
				.field("min_inter_checker_distance", &crate::mcc::MCC_DetectorParametersTraitConst::min_inter_checker_distance(self))
				.field("min_image_size", &crate::mcc::MCC_DetectorParametersTraitConst::min_image_size(self))
				.field("min_group_size", &crate::mcc::MCC_DetectorParametersTraitConst::min_group_size(self))
				.finish()
		}
	}

	impl core::Vector<core::Ptr<crate::mcc::MCC_CChecker>> {
		pub fn as_raw_VectorOfPtrOfMCC_CChecker(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPtrOfMCC_CChecker(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Ptr<crate::mcc::MCC_CChecker>,
		std_vectorLcv_PtrLcv_mcc_CCheckerGG_new_const, std_vectorLcv_PtrLcv_mcc_CCheckerGG_delete,
		std_vectorLcv_PtrLcv_mcc_CCheckerGG_len_const, std_vectorLcv_PtrLcv_mcc_CCheckerGG_isEmpty_const,
		std_vectorLcv_PtrLcv_mcc_CCheckerGG_capacity_const, std_vectorLcv_PtrLcv_mcc_CCheckerGG_shrinkToFit,
		std_vectorLcv_PtrLcv_mcc_CCheckerGG_reserve_size_t, std_vectorLcv_PtrLcv_mcc_CCheckerGG_remove_size_t,
		std_vectorLcv_PtrLcv_mcc_CCheckerGG_swap_size_t_size_t, std_vectorLcv_PtrLcv_mcc_CCheckerGG_clear,
		std_vectorLcv_PtrLcv_mcc_CCheckerGG_get_const_size_t, std_vectorLcv_PtrLcv_mcc_CCheckerGG_set_size_t_const_PtrLCCheckerG,
		std_vectorLcv_PtrLcv_mcc_CCheckerGG_push_const_PtrLCCheckerG, std_vectorLcv_PtrLcv_mcc_CCheckerGG_insert_size_t_const_PtrLCCheckerG,
	}

	vector_non_copy_or_bool! { core::Ptr<crate::mcc::MCC_CChecker> }


}
pub use mcc_types::*;

mod ml_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::ml::ANN_MLP,
		cv_PtrLcv_ml_ANN_MLPG_new_null_const, cv_PtrLcv_ml_ANN_MLPG_delete, cv_PtrLcv_ml_ANN_MLPG_getInnerPtr_const, cv_PtrLcv_ml_ANN_MLPG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::ANN_MLP> {
		#[inline] pub fn as_raw_PtrOfANN_MLP(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfANN_MLP(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::ANN_MLPTraitConst for core::Ptr<crate::ml::ANN_MLP> {
		#[inline] fn as_raw_ANN_MLP(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::ANN_MLPTrait for core::Ptr<crate::ml::ANN_MLP> {
		#[inline] fn as_raw_mut_ANN_MLP(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::ANN_MLP> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::ANN_MLP> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::ANN_MLP>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_ANN_MLPG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::ANN_MLP> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::ANN_MLP> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::ANN_MLP>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_ANN_MLPG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::ANN_MLP> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfANN_MLP")
				.finish()
		}
	}

	ptr_extern! { crate::ml::Boost,
		cv_PtrLcv_ml_BoostG_new_null_const, cv_PtrLcv_ml_BoostG_delete, cv_PtrLcv_ml_BoostG_getInnerPtr_const, cv_PtrLcv_ml_BoostG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::Boost> {
		#[inline] pub fn as_raw_PtrOfBoost(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBoost(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::BoostTraitConst for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_Boost(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::BoostTrait for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_mut_Boost(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::Boost>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_BoostG_to_PtrOfAlgorithm }

	impl crate::ml::DTreesTraitConst for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_DTrees(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::DTreesTrait for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_mut_DTrees(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::Boost>, core::Ptr<crate::ml::DTrees>, cv_PtrLcv_ml_BoostG_to_PtrOfDTrees }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::Boost> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::Boost>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_BoostG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::Boost> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBoost")
				.finish()
		}
	}

	ptr_extern! { crate::ml::DTrees,
		cv_PtrLcv_ml_DTreesG_new_null_const, cv_PtrLcv_ml_DTreesG_delete, cv_PtrLcv_ml_DTreesG_getInnerPtr_const, cv_PtrLcv_ml_DTreesG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::DTrees> {
		#[inline] pub fn as_raw_PtrOfDTrees(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDTrees(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::DTreesTraitConst for core::Ptr<crate::ml::DTrees> {
		#[inline] fn as_raw_DTrees(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::DTreesTrait for core::Ptr<crate::ml::DTrees> {
		#[inline] fn as_raw_mut_DTrees(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::DTrees> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::DTrees> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::DTrees>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_DTreesG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::DTrees> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::DTrees> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::DTrees>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_DTreesG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::DTrees> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDTrees")
				.finish()
		}
	}

	ptr_extern! { crate::ml::EM,
		cv_PtrLcv_ml_EMG_new_null_const, cv_PtrLcv_ml_EMG_delete, cv_PtrLcv_ml_EMG_getInnerPtr_const, cv_PtrLcv_ml_EMG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::EM> {
		#[inline] pub fn as_raw_PtrOfEM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::EMTraitConst for core::Ptr<crate::ml::EM> {
		#[inline] fn as_raw_EM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::EMTrait for core::Ptr<crate::ml::EM> {
		#[inline] fn as_raw_mut_EM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::EM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::EM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::EM>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_EMG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::EM> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::EM> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::EM>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_EMG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::EM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEM")
				.finish()
		}
	}

	ptr_extern! { crate::ml::KNearest,
		cv_PtrLcv_ml_KNearestG_new_null_const, cv_PtrLcv_ml_KNearestG_delete, cv_PtrLcv_ml_KNearestG_getInnerPtr_const, cv_PtrLcv_ml_KNearestG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::KNearest> {
		#[inline] pub fn as_raw_PtrOfKNearest(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKNearest(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::KNearestTraitConst for core::Ptr<crate::ml::KNearest> {
		#[inline] fn as_raw_KNearest(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::KNearestTrait for core::Ptr<crate::ml::KNearest> {
		#[inline] fn as_raw_mut_KNearest(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::KNearest> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::KNearest> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::KNearest>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_KNearestG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::KNearest> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::KNearest> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::KNearest>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_KNearestG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::KNearest> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKNearest")
				.finish()
		}
	}

	ptr_extern! { crate::ml::LogisticRegression,
		cv_PtrLcv_ml_LogisticRegressionG_new_null_const, cv_PtrLcv_ml_LogisticRegressionG_delete, cv_PtrLcv_ml_LogisticRegressionG_getInnerPtr_const, cv_PtrLcv_ml_LogisticRegressionG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::LogisticRegression> {
		#[inline] pub fn as_raw_PtrOfLogisticRegression(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLogisticRegression(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::LogisticRegressionTraitConst for core::Ptr<crate::ml::LogisticRegression> {
		#[inline] fn as_raw_LogisticRegression(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::LogisticRegressionTrait for core::Ptr<crate::ml::LogisticRegression> {
		#[inline] fn as_raw_mut_LogisticRegression(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::LogisticRegression> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::LogisticRegression> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::LogisticRegression>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_LogisticRegressionG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::LogisticRegression> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::LogisticRegression> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::LogisticRegression>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_LogisticRegressionG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::LogisticRegression> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLogisticRegression")
				.finish()
		}
	}

	ptr_extern! { crate::ml::NormalBayesClassifier,
		cv_PtrLcv_ml_NormalBayesClassifierG_new_null_const, cv_PtrLcv_ml_NormalBayesClassifierG_delete, cv_PtrLcv_ml_NormalBayesClassifierG_getInnerPtr_const, cv_PtrLcv_ml_NormalBayesClassifierG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline] pub fn as_raw_PtrOfNormalBayesClassifier(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfNormalBayesClassifier(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::NormalBayesClassifierTraitConst for core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline] fn as_raw_NormalBayesClassifier(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::NormalBayesClassifierTrait for core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline] fn as_raw_mut_NormalBayesClassifier(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::NormalBayesClassifier>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_NormalBayesClassifierG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::NormalBayesClassifier>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_NormalBayesClassifierG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::NormalBayesClassifier> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfNormalBayesClassifier")
				.finish()
		}
	}

	ptr_extern! { crate::ml::ParamGrid,
		cv_PtrLcv_ml_ParamGridG_new_null_const, cv_PtrLcv_ml_ParamGridG_delete, cv_PtrLcv_ml_ParamGridG_getInnerPtr_const, cv_PtrLcv_ml_ParamGridG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::ml::ParamGrid, cv_PtrLcv_ml_ParamGridG_new_const_ParamGrid }
	impl core::Ptr<crate::ml::ParamGrid> {
		#[inline] pub fn as_raw_PtrOfParamGrid(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfParamGrid(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::ParamGridTraitConst for core::Ptr<crate::ml::ParamGrid> {
		#[inline] fn as_raw_ParamGrid(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::ParamGridTrait for core::Ptr<crate::ml::ParamGrid> {
		#[inline] fn as_raw_mut_ParamGrid(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::ml::ParamGrid> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfParamGrid")
				.field("min_val", &crate::ml::ParamGridTraitConst::min_val(self))
				.field("max_val", &crate::ml::ParamGridTraitConst::max_val(self))
				.field("log_step", &crate::ml::ParamGridTraitConst::log_step(self))
				.finish()
		}
	}

	ptr_extern! { crate::ml::RTrees,
		cv_PtrLcv_ml_RTreesG_new_null_const, cv_PtrLcv_ml_RTreesG_delete, cv_PtrLcv_ml_RTreesG_getInnerPtr_const, cv_PtrLcv_ml_RTreesG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::RTrees> {
		#[inline] pub fn as_raw_PtrOfRTrees(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRTrees(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::RTreesTraitConst for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_RTrees(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::RTreesTrait for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_mut_RTrees(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::RTrees>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_RTreesG_to_PtrOfAlgorithm }

	impl crate::ml::DTreesTraitConst for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_DTrees(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::DTreesTrait for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_mut_DTrees(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::RTrees>, core::Ptr<crate::ml::DTrees>, cv_PtrLcv_ml_RTreesG_to_PtrOfDTrees }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::RTrees> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::RTrees>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_RTreesG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::RTrees> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRTrees")
				.finish()
		}
	}

	ptr_extern! { crate::ml::SVM,
		cv_PtrLcv_ml_SVMG_new_null_const, cv_PtrLcv_ml_SVMG_delete, cv_PtrLcv_ml_SVMG_getInnerPtr_const, cv_PtrLcv_ml_SVMG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::SVM> {
		#[inline] pub fn as_raw_PtrOfSVM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSVM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::SVMTraitConst for core::Ptr<crate::ml::SVM> {
		#[inline] fn as_raw_SVM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::SVMTrait for core::Ptr<crate::ml::SVM> {
		#[inline] fn as_raw_mut_SVM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::SVM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::SVM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::SVM>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_SVMG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::SVM> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::SVM> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::SVM>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_SVMG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::SVM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSVM")
				.finish()
		}
	}

	ptr_extern! { crate::ml::SVMSGD,
		cv_PtrLcv_ml_SVMSGDG_new_null_const, cv_PtrLcv_ml_SVMSGDG_delete, cv_PtrLcv_ml_SVMSGDG_getInnerPtr_const, cv_PtrLcv_ml_SVMSGDG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::SVMSGD> {
		#[inline] pub fn as_raw_PtrOfSVMSGD(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSVMSGD(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::SVMSGDTraitConst for core::Ptr<crate::ml::SVMSGD> {
		#[inline] fn as_raw_SVMSGD(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::SVMSGDTrait for core::Ptr<crate::ml::SVMSGD> {
		#[inline] fn as_raw_mut_SVMSGD(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::SVMSGD> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::SVMSGD> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::SVMSGD>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_SVMSGDG_to_PtrOfAlgorithm }

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::SVMSGD> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::SVMSGD> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::SVMSGD>, core::Ptr<crate::ml::StatModel>, cv_PtrLcv_ml_SVMSGDG_to_PtrOfStatModel }

	impl std::fmt::Debug for core::Ptr<crate::ml::SVMSGD> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSVMSGD")
				.finish()
		}
	}

	ptr_extern! { crate::ml::SVM_Kernel,
		cv_PtrLcv_ml_SVM_KernelG_new_null_const, cv_PtrLcv_ml_SVM_KernelG_delete, cv_PtrLcv_ml_SVM_KernelG_getInnerPtr_const, cv_PtrLcv_ml_SVM_KernelG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::SVM_Kernel> {
		#[inline] pub fn as_raw_PtrOfSVM_Kernel(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSVM_Kernel(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::SVM_KernelTraitConst for core::Ptr<crate::ml::SVM_Kernel> {
		#[inline] fn as_raw_SVM_Kernel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::SVM_KernelTrait for core::Ptr<crate::ml::SVM_Kernel> {
		#[inline] fn as_raw_mut_SVM_Kernel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::SVM_Kernel> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::SVM_Kernel> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::SVM_Kernel>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_SVM_KernelG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::ml::SVM_Kernel> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSVM_Kernel")
				.finish()
		}
	}

	ptr_extern! { crate::ml::StatModel,
		cv_PtrLcv_ml_StatModelG_new_null_const, cv_PtrLcv_ml_StatModelG_delete, cv_PtrLcv_ml_StatModelG_getInnerPtr_const, cv_PtrLcv_ml_StatModelG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::StatModel> {
		#[inline] pub fn as_raw_PtrOfStatModel(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStatModel(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::StatModelTraitConst for core::Ptr<crate::ml::StatModel> {
		#[inline] fn as_raw_StatModel(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::StatModelTrait for core::Ptr<crate::ml::StatModel> {
		#[inline] fn as_raw_mut_StatModel(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::ml::StatModel> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::ml::StatModel> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::ml::StatModel>, core::Ptr<core::Algorithm>, cv_PtrLcv_ml_StatModelG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::ml::StatModel> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStatModel")
				.finish()
		}
	}

	ptr_extern! { crate::ml::TrainData,
		cv_PtrLcv_ml_TrainDataG_new_null_const, cv_PtrLcv_ml_TrainDataG_delete, cv_PtrLcv_ml_TrainDataG_getInnerPtr_const, cv_PtrLcv_ml_TrainDataG_getInnerPtrMut
	}

	impl core::Ptr<crate::ml::TrainData> {
		#[inline] pub fn as_raw_PtrOfTrainData(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTrainData(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ml::TrainDataTraitConst for core::Ptr<crate::ml::TrainData> {
		#[inline] fn as_raw_TrainData(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ml::TrainDataTrait for core::Ptr<crate::ml::TrainData> {
		#[inline] fn as_raw_mut_TrainData(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::ml::TrainData> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTrainData")
				.finish()
		}
	}

	impl core::Vector<crate::ml::DTrees_Node> {
		pub fn as_raw_VectorOfDTrees_Node(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDTrees_Node(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::ml::DTrees_Node,
		std_vectorLcv_ml_DTrees_NodeG_new_const, std_vectorLcv_ml_DTrees_NodeG_delete,
		std_vectorLcv_ml_DTrees_NodeG_len_const, std_vectorLcv_ml_DTrees_NodeG_isEmpty_const,
		std_vectorLcv_ml_DTrees_NodeG_capacity_const, std_vectorLcv_ml_DTrees_NodeG_shrinkToFit,
		std_vectorLcv_ml_DTrees_NodeG_reserve_size_t, std_vectorLcv_ml_DTrees_NodeG_remove_size_t,
		std_vectorLcv_ml_DTrees_NodeG_swap_size_t_size_t, std_vectorLcv_ml_DTrees_NodeG_clear,
		std_vectorLcv_ml_DTrees_NodeG_get_const_size_t, std_vectorLcv_ml_DTrees_NodeG_set_size_t_const_Node,
		std_vectorLcv_ml_DTrees_NodeG_push_const_Node, std_vectorLcv_ml_DTrees_NodeG_insert_size_t_const_Node,
	}

	vector_non_copy_or_bool! { crate::ml::DTrees_Node }

	vector_boxed_ref! { crate::ml::DTrees_Node }

	vector_extern! { BoxedRef<'t, crate::ml::DTrees_Node>,
		std_vectorLcv_ml_DTrees_NodeG_new_const, std_vectorLcv_ml_DTrees_NodeG_delete,
		std_vectorLcv_ml_DTrees_NodeG_len_const, std_vectorLcv_ml_DTrees_NodeG_isEmpty_const,
		std_vectorLcv_ml_DTrees_NodeG_capacity_const, std_vectorLcv_ml_DTrees_NodeG_shrinkToFit,
		std_vectorLcv_ml_DTrees_NodeG_reserve_size_t, std_vectorLcv_ml_DTrees_NodeG_remove_size_t,
		std_vectorLcv_ml_DTrees_NodeG_swap_size_t_size_t, std_vectorLcv_ml_DTrees_NodeG_clear,
		std_vectorLcv_ml_DTrees_NodeG_get_const_size_t, std_vectorLcv_ml_DTrees_NodeG_set_size_t_const_Node,
		std_vectorLcv_ml_DTrees_NodeG_push_const_Node, std_vectorLcv_ml_DTrees_NodeG_insert_size_t_const_Node,
	}


	impl core::Vector<crate::ml::DTrees_Split> {
		pub fn as_raw_VectorOfDTrees_Split(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDTrees_Split(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::ml::DTrees_Split,
		std_vectorLcv_ml_DTrees_SplitG_new_const, std_vectorLcv_ml_DTrees_SplitG_delete,
		std_vectorLcv_ml_DTrees_SplitG_len_const, std_vectorLcv_ml_DTrees_SplitG_isEmpty_const,
		std_vectorLcv_ml_DTrees_SplitG_capacity_const, std_vectorLcv_ml_DTrees_SplitG_shrinkToFit,
		std_vectorLcv_ml_DTrees_SplitG_reserve_size_t, std_vectorLcv_ml_DTrees_SplitG_remove_size_t,
		std_vectorLcv_ml_DTrees_SplitG_swap_size_t_size_t, std_vectorLcv_ml_DTrees_SplitG_clear,
		std_vectorLcv_ml_DTrees_SplitG_get_const_size_t, std_vectorLcv_ml_DTrees_SplitG_set_size_t_const_Split,
		std_vectorLcv_ml_DTrees_SplitG_push_const_Split, std_vectorLcv_ml_DTrees_SplitG_insert_size_t_const_Split,
	}

	vector_non_copy_or_bool! { crate::ml::DTrees_Split }

	vector_boxed_ref! { crate::ml::DTrees_Split }

	vector_extern! { BoxedRef<'t, crate::ml::DTrees_Split>,
		std_vectorLcv_ml_DTrees_SplitG_new_const, std_vectorLcv_ml_DTrees_SplitG_delete,
		std_vectorLcv_ml_DTrees_SplitG_len_const, std_vectorLcv_ml_DTrees_SplitG_isEmpty_const,
		std_vectorLcv_ml_DTrees_SplitG_capacity_const, std_vectorLcv_ml_DTrees_SplitG_shrinkToFit,
		std_vectorLcv_ml_DTrees_SplitG_reserve_size_t, std_vectorLcv_ml_DTrees_SplitG_remove_size_t,
		std_vectorLcv_ml_DTrees_SplitG_swap_size_t_size_t, std_vectorLcv_ml_DTrees_SplitG_clear,
		std_vectorLcv_ml_DTrees_SplitG_get_const_size_t, std_vectorLcv_ml_DTrees_SplitG_set_size_t_const_Split,
		std_vectorLcv_ml_DTrees_SplitG_push_const_Split, std_vectorLcv_ml_DTrees_SplitG_insert_size_t_const_Split,
	}


}
pub use ml_types::*;

mod objdetect_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::objdetect::ArucoDetector,
		cv_PtrLcv_aruco_ArucoDetectorG_new_null_const, cv_PtrLcv_aruco_ArucoDetectorG_delete, cv_PtrLcv_aruco_ArucoDetectorG_getInnerPtr_const, cv_PtrLcv_aruco_ArucoDetectorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::objdetect::ArucoDetector, cv_PtrLcv_aruco_ArucoDetectorG_new_const_ArucoDetector }
	impl core::Ptr<crate::objdetect::ArucoDetector> {
		#[inline] pub fn as_raw_PtrOfArucoDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfArucoDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::ArucoDetectorTraitConst for core::Ptr<crate::objdetect::ArucoDetector> {
		#[inline] fn as_raw_ArucoDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::ArucoDetectorTrait for core::Ptr<crate::objdetect::ArucoDetector> {
		#[inline] fn as_raw_mut_ArucoDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::objdetect::ArucoDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::objdetect::ArucoDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::objdetect::ArucoDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_aruco_ArucoDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::objdetect::ArucoDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfArucoDetector")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::BaseCascadeClassifier,
		cv_PtrLcv_BaseCascadeClassifierG_new_null_const, cv_PtrLcv_BaseCascadeClassifierG_delete, cv_PtrLcv_BaseCascadeClassifierG_getInnerPtr_const, cv_PtrLcv_BaseCascadeClassifierG_getInnerPtrMut
	}

	impl core::Ptr<crate::objdetect::BaseCascadeClassifier> {
		#[inline] pub fn as_raw_PtrOfBaseCascadeClassifier(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBaseCascadeClassifier(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::BaseCascadeClassifierTraitConst for core::Ptr<crate::objdetect::BaseCascadeClassifier> {
		#[inline] fn as_raw_BaseCascadeClassifier(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::BaseCascadeClassifierTrait for core::Ptr<crate::objdetect::BaseCascadeClassifier> {
		#[inline] fn as_raw_mut_BaseCascadeClassifier(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::objdetect::BaseCascadeClassifier> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::objdetect::BaseCascadeClassifier> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::objdetect::BaseCascadeClassifier>, core::Ptr<core::Algorithm>, cv_PtrLcv_BaseCascadeClassifierG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::objdetect::BaseCascadeClassifier> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBaseCascadeClassifier")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::BaseCascadeClassifier_MaskGenerator,
		cv_PtrLcv_BaseCascadeClassifier_MaskGeneratorG_new_null_const, cv_PtrLcv_BaseCascadeClassifier_MaskGeneratorG_delete, cv_PtrLcv_BaseCascadeClassifier_MaskGeneratorG_getInnerPtr_const, cv_PtrLcv_BaseCascadeClassifier_MaskGeneratorG_getInnerPtrMut
	}

	impl core::Ptr<crate::objdetect::BaseCascadeClassifier_MaskGenerator> {
		#[inline] pub fn as_raw_PtrOfBaseCascadeClassifier_MaskGenerator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBaseCascadeClassifier_MaskGenerator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::BaseCascadeClassifier_MaskGeneratorTraitConst for core::Ptr<crate::objdetect::BaseCascadeClassifier_MaskGenerator> {
		#[inline] fn as_raw_BaseCascadeClassifier_MaskGenerator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::BaseCascadeClassifier_MaskGeneratorTrait for core::Ptr<crate::objdetect::BaseCascadeClassifier_MaskGenerator> {
		#[inline] fn as_raw_mut_BaseCascadeClassifier_MaskGenerator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::BaseCascadeClassifier_MaskGenerator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBaseCascadeClassifier_MaskGenerator")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::Board,
		cv_PtrLcv_aruco_BoardG_new_null_const, cv_PtrLcv_aruco_BoardG_delete, cv_PtrLcv_aruco_BoardG_getInnerPtr_const, cv_PtrLcv_aruco_BoardG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::objdetect::Board, cv_PtrLcv_aruco_BoardG_new_const_Board }
	impl core::Ptr<crate::objdetect::Board> {
		#[inline] pub fn as_raw_PtrOfBoard(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBoard(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::BoardTraitConst for core::Ptr<crate::objdetect::Board> {
		#[inline] fn as_raw_Board(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::BoardTrait for core::Ptr<crate::objdetect::Board> {
		#[inline] fn as_raw_mut_Board(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::Board> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBoard")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::CharucoBoard,
		cv_PtrLcv_aruco_CharucoBoardG_new_null_const, cv_PtrLcv_aruco_CharucoBoardG_delete, cv_PtrLcv_aruco_CharucoBoardG_getInnerPtr_const, cv_PtrLcv_aruco_CharucoBoardG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::objdetect::CharucoBoard, cv_PtrLcv_aruco_CharucoBoardG_new_const_CharucoBoard }
	impl core::Ptr<crate::objdetect::CharucoBoard> {
		#[inline] pub fn as_raw_PtrOfCharucoBoard(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCharucoBoard(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::CharucoBoardTraitConst for core::Ptr<crate::objdetect::CharucoBoard> {
		#[inline] fn as_raw_CharucoBoard(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::CharucoBoardTrait for core::Ptr<crate::objdetect::CharucoBoard> {
		#[inline] fn as_raw_mut_CharucoBoard(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::objdetect::BoardTraitConst for core::Ptr<crate::objdetect::CharucoBoard> {
		#[inline] fn as_raw_Board(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::BoardTrait for core::Ptr<crate::objdetect::CharucoBoard> {
		#[inline] fn as_raw_mut_Board(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::objdetect::CharucoBoard>, core::Ptr<crate::objdetect::Board>, cv_PtrLcv_aruco_CharucoBoardG_to_PtrOfBoard }

	impl std::fmt::Debug for core::Ptr<crate::objdetect::CharucoBoard> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCharucoBoard")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::CharucoDetector,
		cv_PtrLcv_aruco_CharucoDetectorG_new_null_const, cv_PtrLcv_aruco_CharucoDetectorG_delete, cv_PtrLcv_aruco_CharucoDetectorG_getInnerPtr_const, cv_PtrLcv_aruco_CharucoDetectorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::objdetect::CharucoDetector, cv_PtrLcv_aruco_CharucoDetectorG_new_const_CharucoDetector }
	impl core::Ptr<crate::objdetect::CharucoDetector> {
		#[inline] pub fn as_raw_PtrOfCharucoDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCharucoDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::CharucoDetectorTraitConst for core::Ptr<crate::objdetect::CharucoDetector> {
		#[inline] fn as_raw_CharucoDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::CharucoDetectorTrait for core::Ptr<crate::objdetect::CharucoDetector> {
		#[inline] fn as_raw_mut_CharucoDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::objdetect::CharucoDetector> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::objdetect::CharucoDetector> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::objdetect::CharucoDetector>, core::Ptr<core::Algorithm>, cv_PtrLcv_aruco_CharucoDetectorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::objdetect::CharucoDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCharucoDetector")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::DetectionBasedTracker_IDetector,
		cv_PtrLcv_DetectionBasedTracker_IDetectorG_new_null_const, cv_PtrLcv_DetectionBasedTracker_IDetectorG_delete, cv_PtrLcv_DetectionBasedTracker_IDetectorG_getInnerPtr_const, cv_PtrLcv_DetectionBasedTracker_IDetectorG_getInnerPtrMut
	}

	impl core::Ptr<crate::objdetect::DetectionBasedTracker_IDetector> {
		#[inline] pub fn as_raw_PtrOfDetectionBasedTracker_IDetector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetectionBasedTracker_IDetector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::DetectionBasedTracker_IDetectorTraitConst for core::Ptr<crate::objdetect::DetectionBasedTracker_IDetector> {
		#[inline] fn as_raw_DetectionBasedTracker_IDetector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::DetectionBasedTracker_IDetectorTrait for core::Ptr<crate::objdetect::DetectionBasedTracker_IDetector> {
		#[inline] fn as_raw_mut_DetectionBasedTracker_IDetector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::DetectionBasedTracker_IDetector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetectionBasedTracker_IDetector")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::DetectorParameters,
		cv_PtrLcv_aruco_DetectorParametersG_new_null_const, cv_PtrLcv_aruco_DetectorParametersG_delete, cv_PtrLcv_aruco_DetectorParametersG_getInnerPtr_const, cv_PtrLcv_aruco_DetectorParametersG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::objdetect::DetectorParameters, cv_PtrLcv_aruco_DetectorParametersG_new_const_DetectorParameters }
	impl core::Ptr<crate::objdetect::DetectorParameters> {
		#[inline] pub fn as_raw_PtrOfDetectorParameters(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetectorParameters(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::DetectorParametersTraitConst for core::Ptr<crate::objdetect::DetectorParameters> {
		#[inline] fn as_raw_DetectorParameters(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::DetectorParametersTrait for core::Ptr<crate::objdetect::DetectorParameters> {
		#[inline] fn as_raw_mut_DetectorParameters(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::DetectorParameters> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetectorParameters")
				.field("adaptive_thresh_win_size_min", &crate::objdetect::DetectorParametersTraitConst::adaptive_thresh_win_size_min(self))
				.field("adaptive_thresh_win_size_max", &crate::objdetect::DetectorParametersTraitConst::adaptive_thresh_win_size_max(self))
				.field("adaptive_thresh_win_size_step", &crate::objdetect::DetectorParametersTraitConst::adaptive_thresh_win_size_step(self))
				.field("adaptive_thresh_constant", &crate::objdetect::DetectorParametersTraitConst::adaptive_thresh_constant(self))
				.field("min_marker_perimeter_rate", &crate::objdetect::DetectorParametersTraitConst::min_marker_perimeter_rate(self))
				.field("max_marker_perimeter_rate", &crate::objdetect::DetectorParametersTraitConst::max_marker_perimeter_rate(self))
				.field("polygonal_approx_accuracy_rate", &crate::objdetect::DetectorParametersTraitConst::polygonal_approx_accuracy_rate(self))
				.field("min_corner_distance_rate", &crate::objdetect::DetectorParametersTraitConst::min_corner_distance_rate(self))
				.field("min_distance_to_border", &crate::objdetect::DetectorParametersTraitConst::min_distance_to_border(self))
				.field("min_marker_distance_rate", &crate::objdetect::DetectorParametersTraitConst::min_marker_distance_rate(self))
				.field("min_group_distance", &crate::objdetect::DetectorParametersTraitConst::min_group_distance(self))
				.field("corner_refinement_method", &crate::objdetect::DetectorParametersTraitConst::corner_refinement_method(self))
				.field("corner_refinement_win_size", &crate::objdetect::DetectorParametersTraitConst::corner_refinement_win_size(self))
				.field("relative_corner_refinment_win_size", &crate::objdetect::DetectorParametersTraitConst::relative_corner_refinment_win_size(self))
				.field("corner_refinement_max_iterations", &crate::objdetect::DetectorParametersTraitConst::corner_refinement_max_iterations(self))
				.field("corner_refinement_min_accuracy", &crate::objdetect::DetectorParametersTraitConst::corner_refinement_min_accuracy(self))
				.field("marker_border_bits", &crate::objdetect::DetectorParametersTraitConst::marker_border_bits(self))
				.field("perspective_remove_pixel_per_cell", &crate::objdetect::DetectorParametersTraitConst::perspective_remove_pixel_per_cell(self))
				.field("perspective_remove_ignored_margin_per_cell", &crate::objdetect::DetectorParametersTraitConst::perspective_remove_ignored_margin_per_cell(self))
				.field("max_erroneous_bits_in_border_rate", &crate::objdetect::DetectorParametersTraitConst::max_erroneous_bits_in_border_rate(self))
				.field("min_otsu_std_dev", &crate::objdetect::DetectorParametersTraitConst::min_otsu_std_dev(self))
				.field("error_correction_rate", &crate::objdetect::DetectorParametersTraitConst::error_correction_rate(self))
				.field("april_tag_quad_decimate", &crate::objdetect::DetectorParametersTraitConst::april_tag_quad_decimate(self))
				.field("april_tag_quad_sigma", &crate::objdetect::DetectorParametersTraitConst::april_tag_quad_sigma(self))
				.field("april_tag_min_cluster_pixels", &crate::objdetect::DetectorParametersTraitConst::april_tag_min_cluster_pixels(self))
				.field("april_tag_max_nmaxima", &crate::objdetect::DetectorParametersTraitConst::april_tag_max_nmaxima(self))
				.field("april_tag_critical_rad", &crate::objdetect::DetectorParametersTraitConst::april_tag_critical_rad(self))
				.field("april_tag_max_line_fit_mse", &crate::objdetect::DetectorParametersTraitConst::april_tag_max_line_fit_mse(self))
				.field("april_tag_min_white_black_diff", &crate::objdetect::DetectorParametersTraitConst::april_tag_min_white_black_diff(self))
				.field("april_tag_deglitch", &crate::objdetect::DetectorParametersTraitConst::april_tag_deglitch(self))
				.field("detect_inverted_marker", &crate::objdetect::DetectorParametersTraitConst::detect_inverted_marker(self))
				.field("use_aruco3_detection", &crate::objdetect::DetectorParametersTraitConst::use_aruco3_detection(self))
				.field("min_side_length_canonical_img", &crate::objdetect::DetectorParametersTraitConst::min_side_length_canonical_img(self))
				.field("min_marker_length_ratio_original_img", &crate::objdetect::DetectorParametersTraitConst::min_marker_length_ratio_original_img(self))
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::Dictionary,
		cv_PtrLcv_aruco_DictionaryG_new_null_const, cv_PtrLcv_aruco_DictionaryG_delete, cv_PtrLcv_aruco_DictionaryG_getInnerPtr_const, cv_PtrLcv_aruco_DictionaryG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::objdetect::Dictionary, cv_PtrLcv_aruco_DictionaryG_new_const_Dictionary }
	impl core::Ptr<crate::objdetect::Dictionary> {
		#[inline] pub fn as_raw_PtrOfDictionary(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDictionary(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::DictionaryTraitConst for core::Ptr<crate::objdetect::Dictionary> {
		#[inline] fn as_raw_Dictionary(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::DictionaryTrait for core::Ptr<crate::objdetect::Dictionary> {
		#[inline] fn as_raw_mut_Dictionary(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::Dictionary> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDictionary")
				.field("bytes_list", &crate::objdetect::DictionaryTraitConst::bytes_list(self))
				.field("marker_size", &crate::objdetect::DictionaryTraitConst::marker_size(self))
				.field("max_correction_bits", &crate::objdetect::DictionaryTraitConst::max_correction_bits(self))
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::FaceDetectorYN,
		cv_PtrLcv_FaceDetectorYNG_new_null_const, cv_PtrLcv_FaceDetectorYNG_delete, cv_PtrLcv_FaceDetectorYNG_getInnerPtr_const, cv_PtrLcv_FaceDetectorYNG_getInnerPtrMut
	}

	impl core::Ptr<crate::objdetect::FaceDetectorYN> {
		#[inline] pub fn as_raw_PtrOfFaceDetectorYN(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFaceDetectorYN(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::FaceDetectorYNTraitConst for core::Ptr<crate::objdetect::FaceDetectorYN> {
		#[inline] fn as_raw_FaceDetectorYN(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::FaceDetectorYNTrait for core::Ptr<crate::objdetect::FaceDetectorYN> {
		#[inline] fn as_raw_mut_FaceDetectorYN(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::FaceDetectorYN> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFaceDetectorYN")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::FaceRecognizerSF,
		cv_PtrLcv_FaceRecognizerSFG_new_null_const, cv_PtrLcv_FaceRecognizerSFG_delete, cv_PtrLcv_FaceRecognizerSFG_getInnerPtr_const, cv_PtrLcv_FaceRecognizerSFG_getInnerPtrMut
	}

	impl core::Ptr<crate::objdetect::FaceRecognizerSF> {
		#[inline] pub fn as_raw_PtrOfFaceRecognizerSF(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFaceRecognizerSF(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::FaceRecognizerSFTraitConst for core::Ptr<crate::objdetect::FaceRecognizerSF> {
		#[inline] fn as_raw_FaceRecognizerSF(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::FaceRecognizerSFTrait for core::Ptr<crate::objdetect::FaceRecognizerSF> {
		#[inline] fn as_raw_mut_FaceRecognizerSF(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::FaceRecognizerSF> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFaceRecognizerSF")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::GridBoard,
		cv_PtrLcv_aruco_GridBoardG_new_null_const, cv_PtrLcv_aruco_GridBoardG_delete, cv_PtrLcv_aruco_GridBoardG_getInnerPtr_const, cv_PtrLcv_aruco_GridBoardG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::objdetect::GridBoard, cv_PtrLcv_aruco_GridBoardG_new_const_GridBoard }
	impl core::Ptr<crate::objdetect::GridBoard> {
		#[inline] pub fn as_raw_PtrOfGridBoard(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGridBoard(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::GridBoardTraitConst for core::Ptr<crate::objdetect::GridBoard> {
		#[inline] fn as_raw_GridBoard(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::GridBoardTrait for core::Ptr<crate::objdetect::GridBoard> {
		#[inline] fn as_raw_mut_GridBoard(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::objdetect::BoardTraitConst for core::Ptr<crate::objdetect::GridBoard> {
		#[inline] fn as_raw_Board(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::BoardTrait for core::Ptr<crate::objdetect::GridBoard> {
		#[inline] fn as_raw_mut_Board(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::objdetect::GridBoard>, core::Ptr<crate::objdetect::Board>, cv_PtrLcv_aruco_GridBoardG_to_PtrOfBoard }

	impl std::fmt::Debug for core::Ptr<crate::objdetect::GridBoard> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGridBoard")
				.finish()
		}
	}

	ptr_extern! { crate::objdetect::QRCodeEncoder,
		cv_PtrLcv_QRCodeEncoderG_new_null_const, cv_PtrLcv_QRCodeEncoderG_delete, cv_PtrLcv_QRCodeEncoderG_getInnerPtr_const, cv_PtrLcv_QRCodeEncoderG_getInnerPtrMut
	}

	impl core::Ptr<crate::objdetect::QRCodeEncoder> {
		#[inline] pub fn as_raw_PtrOfQRCodeEncoder(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQRCodeEncoder(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::objdetect::QRCodeEncoderTraitConst for core::Ptr<crate::objdetect::QRCodeEncoder> {
		#[inline] fn as_raw_QRCodeEncoder(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::objdetect::QRCodeEncoderTrait for core::Ptr<crate::objdetect::QRCodeEncoder> {
		#[inline] fn as_raw_mut_QRCodeEncoder(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::objdetect::QRCodeEncoder> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQRCodeEncoder")
				.finish()
		}
	}

	impl core::Vector<crate::objdetect::DetectionBasedTracker_ExtObject> {
		pub fn as_raw_VectorOfDetectionBasedTracker_ExtObject(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDetectionBasedTracker_ExtObject(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::objdetect::DetectionBasedTracker_ExtObject,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_new_const, std_vectorLcv_DetectionBasedTracker_ExtObjectG_delete,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_len_const, std_vectorLcv_DetectionBasedTracker_ExtObjectG_isEmpty_const,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_capacity_const, std_vectorLcv_DetectionBasedTracker_ExtObjectG_shrinkToFit,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_reserve_size_t, std_vectorLcv_DetectionBasedTracker_ExtObjectG_remove_size_t,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_swap_size_t_size_t, std_vectorLcv_DetectionBasedTracker_ExtObjectG_clear,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_get_const_size_t, std_vectorLcv_DetectionBasedTracker_ExtObjectG_set_size_t_const_ExtObject,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_push_const_ExtObject, std_vectorLcv_DetectionBasedTracker_ExtObjectG_insert_size_t_const_ExtObject,
	}

	vector_non_copy_or_bool! { clone crate::objdetect::DetectionBasedTracker_ExtObject }

	vector_boxed_ref! { crate::objdetect::DetectionBasedTracker_ExtObject }

	vector_extern! { BoxedRef<'t, crate::objdetect::DetectionBasedTracker_ExtObject>,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_new_const, std_vectorLcv_DetectionBasedTracker_ExtObjectG_delete,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_len_const, std_vectorLcv_DetectionBasedTracker_ExtObjectG_isEmpty_const,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_capacity_const, std_vectorLcv_DetectionBasedTracker_ExtObjectG_shrinkToFit,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_reserve_size_t, std_vectorLcv_DetectionBasedTracker_ExtObjectG_remove_size_t,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_swap_size_t_size_t, std_vectorLcv_DetectionBasedTracker_ExtObjectG_clear,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_get_const_size_t, std_vectorLcv_DetectionBasedTracker_ExtObjectG_set_size_t_const_ExtObject,
		std_vectorLcv_DetectionBasedTracker_ExtObjectG_push_const_ExtObject, std_vectorLcv_DetectionBasedTracker_ExtObjectG_insert_size_t_const_ExtObject,
	}


	impl core::Vector<crate::objdetect::DetectionBasedTracker_Object> {
		pub fn as_raw_VectorOfDetectionBasedTracker_Object(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDetectionBasedTracker_Object(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::objdetect::DetectionBasedTracker_Object,
		std_vectorLcv_DetectionBasedTracker_ObjectG_new_const, std_vectorLcv_DetectionBasedTracker_ObjectG_delete,
		std_vectorLcv_DetectionBasedTracker_ObjectG_len_const, std_vectorLcv_DetectionBasedTracker_ObjectG_isEmpty_const,
		std_vectorLcv_DetectionBasedTracker_ObjectG_capacity_const, std_vectorLcv_DetectionBasedTracker_ObjectG_shrinkToFit,
		std_vectorLcv_DetectionBasedTracker_ObjectG_reserve_size_t, std_vectorLcv_DetectionBasedTracker_ObjectG_remove_size_t,
		std_vectorLcv_DetectionBasedTracker_ObjectG_swap_size_t_size_t, std_vectorLcv_DetectionBasedTracker_ObjectG_clear,
		std_vectorLcv_DetectionBasedTracker_ObjectG_get_const_size_t, std_vectorLcv_DetectionBasedTracker_ObjectG_set_size_t_const_Object,
		std_vectorLcv_DetectionBasedTracker_ObjectG_push_const_Object, std_vectorLcv_DetectionBasedTracker_ObjectG_insert_size_t_const_Object,
	}

	vector_non_copy_or_bool! { crate::objdetect::DetectionBasedTracker_Object }


	impl core::Vector<crate::objdetect::DetectionROI> {
		pub fn as_raw_VectorOfDetectionROI(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDetectionROI(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::objdetect::DetectionROI,
		std_vectorLcv_DetectionROIG_new_const, std_vectorLcv_DetectionROIG_delete,
		std_vectorLcv_DetectionROIG_len_const, std_vectorLcv_DetectionROIG_isEmpty_const,
		std_vectorLcv_DetectionROIG_capacity_const, std_vectorLcv_DetectionROIG_shrinkToFit,
		std_vectorLcv_DetectionROIG_reserve_size_t, std_vectorLcv_DetectionROIG_remove_size_t,
		std_vectorLcv_DetectionROIG_swap_size_t_size_t, std_vectorLcv_DetectionROIG_clear,
		std_vectorLcv_DetectionROIG_get_const_size_t, std_vectorLcv_DetectionROIG_set_size_t_const_DetectionROI,
		std_vectorLcv_DetectionROIG_push_const_DetectionROI, std_vectorLcv_DetectionROIG_insert_size_t_const_DetectionROI,
	}

	vector_non_copy_or_bool! { crate::objdetect::DetectionROI }

	vector_boxed_ref! { crate::objdetect::DetectionROI }

	vector_extern! { BoxedRef<'t, crate::objdetect::DetectionROI>,
		std_vectorLcv_DetectionROIG_new_const, std_vectorLcv_DetectionROIG_delete,
		std_vectorLcv_DetectionROIG_len_const, std_vectorLcv_DetectionROIG_isEmpty_const,
		std_vectorLcv_DetectionROIG_capacity_const, std_vectorLcv_DetectionROIG_shrinkToFit,
		std_vectorLcv_DetectionROIG_reserve_size_t, std_vectorLcv_DetectionROIG_remove_size_t,
		std_vectorLcv_DetectionROIG_swap_size_t_size_t, std_vectorLcv_DetectionROIG_clear,
		std_vectorLcv_DetectionROIG_get_const_size_t, std_vectorLcv_DetectionROIG_set_size_t_const_DetectionROI,
		std_vectorLcv_DetectionROIG_push_const_DetectionROI, std_vectorLcv_DetectionROIG_insert_size_t_const_DetectionROI,
	}


	impl core::Vector<crate::objdetect::Dictionary> {
		pub fn as_raw_VectorOfDictionary(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfDictionary(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::objdetect::Dictionary,
		std_vectorLcv_aruco_DictionaryG_new_const, std_vectorLcv_aruco_DictionaryG_delete,
		std_vectorLcv_aruco_DictionaryG_len_const, std_vectorLcv_aruco_DictionaryG_isEmpty_const,
		std_vectorLcv_aruco_DictionaryG_capacity_const, std_vectorLcv_aruco_DictionaryG_shrinkToFit,
		std_vectorLcv_aruco_DictionaryG_reserve_size_t, std_vectorLcv_aruco_DictionaryG_remove_size_t,
		std_vectorLcv_aruco_DictionaryG_swap_size_t_size_t, std_vectorLcv_aruco_DictionaryG_clear,
		std_vectorLcv_aruco_DictionaryG_get_const_size_t, std_vectorLcv_aruco_DictionaryG_set_size_t_const_Dictionary,
		std_vectorLcv_aruco_DictionaryG_push_const_Dictionary, std_vectorLcv_aruco_DictionaryG_insert_size_t_const_Dictionary,
	}

	vector_non_copy_or_bool! { clone crate::objdetect::Dictionary }

	vector_boxed_ref! { crate::objdetect::Dictionary }

	vector_extern! { BoxedRef<'t, crate::objdetect::Dictionary>,
		std_vectorLcv_aruco_DictionaryG_new_const, std_vectorLcv_aruco_DictionaryG_delete,
		std_vectorLcv_aruco_DictionaryG_len_const, std_vectorLcv_aruco_DictionaryG_isEmpty_const,
		std_vectorLcv_aruco_DictionaryG_capacity_const, std_vectorLcv_aruco_DictionaryG_shrinkToFit,
		std_vectorLcv_aruco_DictionaryG_reserve_size_t, std_vectorLcv_aruco_DictionaryG_remove_size_t,
		std_vectorLcv_aruco_DictionaryG_swap_size_t_size_t, std_vectorLcv_aruco_DictionaryG_clear,
		std_vectorLcv_aruco_DictionaryG_get_const_size_t, std_vectorLcv_aruco_DictionaryG_set_size_t_const_Dictionary,
		std_vectorLcv_aruco_DictionaryG_push_const_Dictionary, std_vectorLcv_aruco_DictionaryG_insert_size_t_const_Dictionary,
	}


}
pub use objdetect_types::*;

mod optflow_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::optflow::DenseRLOFOpticalFlow,
		cv_PtrLcv_optflow_DenseRLOFOpticalFlowG_new_null_const, cv_PtrLcv_optflow_DenseRLOFOpticalFlowG_delete, cv_PtrLcv_optflow_DenseRLOFOpticalFlowG_getInnerPtr_const, cv_PtrLcv_optflow_DenseRLOFOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfDenseRLOFOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDenseRLOFOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::DenseRLOFOpticalFlowTraitConst for core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline] fn as_raw_DenseRLOFOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::DenseRLOFOpticalFlowTrait for core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline] fn as_raw_mut_DenseRLOFOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::DenseRLOFOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_optflow_DenseRLOFOpticalFlowG_to_PtrOfAlgorithm }

	impl crate::video::DenseOpticalFlowTraitConst for core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline] fn as_raw_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::DenseOpticalFlowTrait for core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline] fn as_raw_mut_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::DenseRLOFOpticalFlow>, core::Ptr<crate::video::DenseOpticalFlow>, cv_PtrLcv_optflow_DenseRLOFOpticalFlowG_to_PtrOfDenseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::optflow::DenseRLOFOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDenseRLOFOpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::optflow::DualTVL1OpticalFlow,
		cv_PtrLcv_optflow_DualTVL1OpticalFlowG_new_null_const, cv_PtrLcv_optflow_DualTVL1OpticalFlowG_delete, cv_PtrLcv_optflow_DualTVL1OpticalFlowG_getInnerPtr_const, cv_PtrLcv_optflow_DualTVL1OpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline] pub fn as_raw_PtrOfDualTVL1OpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDualTVL1OpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::DualTVL1OpticalFlowTraitConst for core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline] fn as_raw_DualTVL1OpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::DualTVL1OpticalFlowTrait for core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline] fn as_raw_mut_DualTVL1OpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::DualTVL1OpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_optflow_DualTVL1OpticalFlowG_to_PtrOfAlgorithm }

	impl crate::video::DenseOpticalFlowTraitConst for core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline] fn as_raw_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::DenseOpticalFlowTrait for core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline] fn as_raw_mut_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::DualTVL1OpticalFlow>, core::Ptr<crate::video::DenseOpticalFlow>, cv_PtrLcv_optflow_DualTVL1OpticalFlowG_to_PtrOfDenseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::optflow::DualTVL1OpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDualTVL1OpticalFlow")
				.finish()
		}
	}

	ptr_extern! { crate::optflow::GPCTrainingSamples,
		cv_PtrLcv_optflow_GPCTrainingSamplesG_new_null_const, cv_PtrLcv_optflow_GPCTrainingSamplesG_delete, cv_PtrLcv_optflow_GPCTrainingSamplesG_getInnerPtr_const, cv_PtrLcv_optflow_GPCTrainingSamplesG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::optflow::GPCTrainingSamples, cv_PtrLcv_optflow_GPCTrainingSamplesG_new_const_GPCTrainingSamples }
	impl core::Ptr<crate::optflow::GPCTrainingSamples> {
		#[inline] pub fn as_raw_PtrOfGPCTrainingSamples(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGPCTrainingSamples(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::GPCTrainingSamplesTraitConst for core::Ptr<crate::optflow::GPCTrainingSamples> {
		#[inline] fn as_raw_GPCTrainingSamples(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::GPCTrainingSamplesTrait for core::Ptr<crate::optflow::GPCTrainingSamples> {
		#[inline] fn as_raw_mut_GPCTrainingSamples(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::optflow::GPCTrainingSamples> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGPCTrainingSamples")
				.finish()
		}
	}

	ptr_extern! { crate::optflow::GPCTree,
		cv_PtrLcv_optflow_GPCTreeG_new_null_const, cv_PtrLcv_optflow_GPCTreeG_delete, cv_PtrLcv_optflow_GPCTreeG_getInnerPtr_const, cv_PtrLcv_optflow_GPCTreeG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::optflow::GPCTree, cv_PtrLcv_optflow_GPCTreeG_new_const_GPCTree }
	impl core::Ptr<crate::optflow::GPCTree> {
		#[inline] pub fn as_raw_PtrOfGPCTree(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfGPCTree(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::GPCTreeTraitConst for core::Ptr<crate::optflow::GPCTree> {
		#[inline] fn as_raw_GPCTree(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::GPCTreeTrait for core::Ptr<crate::optflow::GPCTree> {
		#[inline] fn as_raw_mut_GPCTree(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::optflow::GPCTree> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::optflow::GPCTree> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::GPCTree>, core::Ptr<core::Algorithm>, cv_PtrLcv_optflow_GPCTreeG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::optflow::GPCTree> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfGPCTree")
				.finish()
		}
	}

	ptr_extern! { crate::optflow::OpticalFlowPCAFlow,
		cv_PtrLcv_optflow_OpticalFlowPCAFlowG_new_null_const, cv_PtrLcv_optflow_OpticalFlowPCAFlowG_delete, cv_PtrLcv_optflow_OpticalFlowPCAFlowG_getInnerPtr_const, cv_PtrLcv_optflow_OpticalFlowPCAFlowG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::optflow::OpticalFlowPCAFlow, cv_PtrLcv_optflow_OpticalFlowPCAFlowG_new_const_OpticalFlowPCAFlow }
	impl core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline] pub fn as_raw_PtrOfOpticalFlowPCAFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfOpticalFlowPCAFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::OpticalFlowPCAFlowTraitConst for core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline] fn as_raw_OpticalFlowPCAFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::OpticalFlowPCAFlowTrait for core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline] fn as_raw_mut_OpticalFlowPCAFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::OpticalFlowPCAFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_optflow_OpticalFlowPCAFlowG_to_PtrOfAlgorithm }

	impl crate::video::DenseOpticalFlowTraitConst for core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline] fn as_raw_DenseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::DenseOpticalFlowTrait for core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline] fn as_raw_mut_DenseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::OpticalFlowPCAFlow>, core::Ptr<crate::video::DenseOpticalFlow>, cv_PtrLcv_optflow_OpticalFlowPCAFlowG_to_PtrOfDenseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::optflow::OpticalFlowPCAFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfOpticalFlowPCAFlow")
				.finish()
		}
	}

	ptr_extern! { crate::optflow::PCAPrior,
		cv_PtrLcv_optflow_PCAPriorG_new_null_const, cv_PtrLcv_optflow_PCAPriorG_delete, cv_PtrLcv_optflow_PCAPriorG_getInnerPtr_const, cv_PtrLcv_optflow_PCAPriorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::optflow::PCAPrior, cv_PtrLcv_optflow_PCAPriorG_new_const_PCAPrior }
	impl core::Ptr<crate::optflow::PCAPrior> {
		#[inline] pub fn as_raw_PtrOfPCAPrior(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPCAPrior(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::PCAPriorTraitConst for core::Ptr<crate::optflow::PCAPrior> {
		#[inline] fn as_raw_PCAPrior(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::PCAPriorTrait for core::Ptr<crate::optflow::PCAPrior> {
		#[inline] fn as_raw_mut_PCAPrior(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::optflow::PCAPrior> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPCAPrior")
				.finish()
		}
	}

	ptr_extern! { crate::optflow::RLOFOpticalFlowParameter,
		cv_PtrLcv_optflow_RLOFOpticalFlowParameterG_new_null_const, cv_PtrLcv_optflow_RLOFOpticalFlowParameterG_delete, cv_PtrLcv_optflow_RLOFOpticalFlowParameterG_getInnerPtr_const, cv_PtrLcv_optflow_RLOFOpticalFlowParameterG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::optflow::RLOFOpticalFlowParameter, cv_PtrLcv_optflow_RLOFOpticalFlowParameterG_new_const_RLOFOpticalFlowParameter }
	impl core::Ptr<crate::optflow::RLOFOpticalFlowParameter> {
		#[inline] pub fn as_raw_PtrOfRLOFOpticalFlowParameter(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRLOFOpticalFlowParameter(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::RLOFOpticalFlowParameterTraitConst for core::Ptr<crate::optflow::RLOFOpticalFlowParameter> {
		#[inline] fn as_raw_RLOFOpticalFlowParameter(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::RLOFOpticalFlowParameterTrait for core::Ptr<crate::optflow::RLOFOpticalFlowParameter> {
		#[inline] fn as_raw_mut_RLOFOpticalFlowParameter(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::optflow::RLOFOpticalFlowParameter> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRLOFOpticalFlowParameter")
				.field("solver_type", &crate::optflow::RLOFOpticalFlowParameterTraitConst::solver_type(self))
				.field("support_region_type", &crate::optflow::RLOFOpticalFlowParameterTraitConst::support_region_type(self))
				.field("norm_sigma0", &crate::optflow::RLOFOpticalFlowParameterTraitConst::norm_sigma0(self))
				.field("norm_sigma1", &crate::optflow::RLOFOpticalFlowParameterTraitConst::norm_sigma1(self))
				.field("small_win_size", &crate::optflow::RLOFOpticalFlowParameterTraitConst::small_win_size(self))
				.field("large_win_size", &crate::optflow::RLOFOpticalFlowParameterTraitConst::large_win_size(self))
				.field("cross_segmentation_threshold", &crate::optflow::RLOFOpticalFlowParameterTraitConst::cross_segmentation_threshold(self))
				.field("max_level", &crate::optflow::RLOFOpticalFlowParameterTraitConst::max_level(self))
				.field("use_initial_flow", &crate::optflow::RLOFOpticalFlowParameterTraitConst::use_initial_flow(self))
				.field("use_illumination_model", &crate::optflow::RLOFOpticalFlowParameterTraitConst::use_illumination_model(self))
				.field("use_global_motion_prior", &crate::optflow::RLOFOpticalFlowParameterTraitConst::use_global_motion_prior(self))
				.field("max_iteration", &crate::optflow::RLOFOpticalFlowParameterTraitConst::max_iteration(self))
				.field("min_eigen_value", &crate::optflow::RLOFOpticalFlowParameterTraitConst::min_eigen_value(self))
				.field("global_motion_ransac_threshold", &crate::optflow::RLOFOpticalFlowParameterTraitConst::global_motion_ransac_threshold(self))
				.finish()
		}
	}

	ptr_extern! { crate::optflow::SparseRLOFOpticalFlow,
		cv_PtrLcv_optflow_SparseRLOFOpticalFlowG_new_null_const, cv_PtrLcv_optflow_SparseRLOFOpticalFlowG_delete, cv_PtrLcv_optflow_SparseRLOFOpticalFlowG_getInnerPtr_const, cv_PtrLcv_optflow_SparseRLOFOpticalFlowG_getInnerPtrMut
	}

	impl core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline] pub fn as_raw_PtrOfSparseRLOFOpticalFlow(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSparseRLOFOpticalFlow(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::optflow::SparseRLOFOpticalFlowTraitConst for core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline] fn as_raw_SparseRLOFOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::optflow::SparseRLOFOpticalFlowTrait for core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline] fn as_raw_mut_SparseRLOFOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::SparseRLOFOpticalFlow>, core::Ptr<core::Algorithm>, cv_PtrLcv_optflow_SparseRLOFOpticalFlowG_to_PtrOfAlgorithm }

	impl crate::video::SparseOpticalFlowTraitConst for core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline] fn as_raw_SparseOpticalFlow(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::video::SparseOpticalFlowTrait for core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline] fn as_raw_mut_SparseOpticalFlow(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::optflow::SparseRLOFOpticalFlow>, core::Ptr<crate::video::SparseOpticalFlow>, cv_PtrLcv_optflow_SparseRLOFOpticalFlowG_to_PtrOfSparseOpticalFlow }

	impl std::fmt::Debug for core::Ptr<crate::optflow::SparseRLOFOpticalFlow> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSparseRLOFOpticalFlow")
				.finish()
		}
	}

	impl core::Vector<crate::optflow::GPCPatchDescriptor> {
		pub fn as_raw_VectorOfGPCPatchDescriptor(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGPCPatchDescriptor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::optflow::GPCPatchDescriptor,
		std_vectorLcv_optflow_GPCPatchDescriptorG_new_const, std_vectorLcv_optflow_GPCPatchDescriptorG_delete,
		std_vectorLcv_optflow_GPCPatchDescriptorG_len_const, std_vectorLcv_optflow_GPCPatchDescriptorG_isEmpty_const,
		std_vectorLcv_optflow_GPCPatchDescriptorG_capacity_const, std_vectorLcv_optflow_GPCPatchDescriptorG_shrinkToFit,
		std_vectorLcv_optflow_GPCPatchDescriptorG_reserve_size_t, std_vectorLcv_optflow_GPCPatchDescriptorG_remove_size_t,
		std_vectorLcv_optflow_GPCPatchDescriptorG_swap_size_t_size_t, std_vectorLcv_optflow_GPCPatchDescriptorG_clear,
		std_vectorLcv_optflow_GPCPatchDescriptorG_get_const_size_t, std_vectorLcv_optflow_GPCPatchDescriptorG_set_size_t_const_GPCPatchDescriptor,
		std_vectorLcv_optflow_GPCPatchDescriptorG_push_const_GPCPatchDescriptor, std_vectorLcv_optflow_GPCPatchDescriptorG_insert_size_t_const_GPCPatchDescriptor,
	}

	vector_non_copy_or_bool! { crate::optflow::GPCPatchDescriptor }

	vector_boxed_ref! { crate::optflow::GPCPatchDescriptor }

	vector_extern! { BoxedRef<'t, crate::optflow::GPCPatchDescriptor>,
		std_vectorLcv_optflow_GPCPatchDescriptorG_new_const, std_vectorLcv_optflow_GPCPatchDescriptorG_delete,
		std_vectorLcv_optflow_GPCPatchDescriptorG_len_const, std_vectorLcv_optflow_GPCPatchDescriptorG_isEmpty_const,
		std_vectorLcv_optflow_GPCPatchDescriptorG_capacity_const, std_vectorLcv_optflow_GPCPatchDescriptorG_shrinkToFit,
		std_vectorLcv_optflow_GPCPatchDescriptorG_reserve_size_t, std_vectorLcv_optflow_GPCPatchDescriptorG_remove_size_t,
		std_vectorLcv_optflow_GPCPatchDescriptorG_swap_size_t_size_t, std_vectorLcv_optflow_GPCPatchDescriptorG_clear,
		std_vectorLcv_optflow_GPCPatchDescriptorG_get_const_size_t, std_vectorLcv_optflow_GPCPatchDescriptorG_set_size_t_const_GPCPatchDescriptor,
		std_vectorLcv_optflow_GPCPatchDescriptorG_push_const_GPCPatchDescriptor, std_vectorLcv_optflow_GPCPatchDescriptorG_insert_size_t_const_GPCPatchDescriptor,
	}


	impl core::Vector<crate::optflow::GPCPatchSample> {
		pub fn as_raw_VectorOfGPCPatchSample(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfGPCPatchSample(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::optflow::GPCPatchSample,
		std_vectorLcv_optflow_GPCPatchSampleG_new_const, std_vectorLcv_optflow_GPCPatchSampleG_delete,
		std_vectorLcv_optflow_GPCPatchSampleG_len_const, std_vectorLcv_optflow_GPCPatchSampleG_isEmpty_const,
		std_vectorLcv_optflow_GPCPatchSampleG_capacity_const, std_vectorLcv_optflow_GPCPatchSampleG_shrinkToFit,
		std_vectorLcv_optflow_GPCPatchSampleG_reserve_size_t, std_vectorLcv_optflow_GPCPatchSampleG_remove_size_t,
		std_vectorLcv_optflow_GPCPatchSampleG_swap_size_t_size_t, std_vectorLcv_optflow_GPCPatchSampleG_clear,
		std_vectorLcv_optflow_GPCPatchSampleG_get_const_size_t, std_vectorLcv_optflow_GPCPatchSampleG_set_size_t_const_GPCPatchSample,
		std_vectorLcv_optflow_GPCPatchSampleG_push_const_GPCPatchSample, std_vectorLcv_optflow_GPCPatchSampleG_insert_size_t_const_GPCPatchSample,
	}

	vector_non_copy_or_bool! { crate::optflow::GPCPatchSample }

	vector_boxed_ref! { crate::optflow::GPCPatchSample }

	vector_extern! { BoxedRef<'t, crate::optflow::GPCPatchSample>,
		std_vectorLcv_optflow_GPCPatchSampleG_new_const, std_vectorLcv_optflow_GPCPatchSampleG_delete,
		std_vectorLcv_optflow_GPCPatchSampleG_len_const, std_vectorLcv_optflow_GPCPatchSampleG_isEmpty_const,
		std_vectorLcv_optflow_GPCPatchSampleG_capacity_const, std_vectorLcv_optflow_GPCPatchSampleG_shrinkToFit,
		std_vectorLcv_optflow_GPCPatchSampleG_reserve_size_t, std_vectorLcv_optflow_GPCPatchSampleG_remove_size_t,
		std_vectorLcv_optflow_GPCPatchSampleG_swap_size_t_size_t, std_vectorLcv_optflow_GPCPatchSampleG_clear,
		std_vectorLcv_optflow_GPCPatchSampleG_get_const_size_t, std_vectorLcv_optflow_GPCPatchSampleG_set_size_t_const_GPCPatchSample,
		std_vectorLcv_optflow_GPCPatchSampleG_push_const_GPCPatchSample, std_vectorLcv_optflow_GPCPatchSampleG_insert_size_t_const_GPCPatchSample,
	}


}
pub use optflow_types::*;

mod ovis_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::ovis::WindowScene,
		cv_PtrLcv_ovis_WindowSceneG_new_null_const, cv_PtrLcv_ovis_WindowSceneG_delete, cv_PtrLcv_ovis_WindowSceneG_getInnerPtr_const, cv_PtrLcv_ovis_WindowSceneG_getInnerPtrMut
	}

	impl core::Ptr<crate::ovis::WindowScene> {
		#[inline] pub fn as_raw_PtrOfWindowScene(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfWindowScene(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::ovis::WindowSceneTraitConst for core::Ptr<crate::ovis::WindowScene> {
		#[inline] fn as_raw_WindowScene(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::ovis::WindowSceneTrait for core::Ptr<crate::ovis::WindowScene> {
		#[inline] fn as_raw_mut_WindowScene(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::ovis::WindowScene> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfWindowScene")
				.finish()
		}
	}

}
pub use ovis_types::*;

mod phase_unwrapping_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::phase_unwrapping::HistogramPhaseUnwrapping,
		cv_PtrLcv_phase_unwrapping_HistogramPhaseUnwrappingG_new_null_const, cv_PtrLcv_phase_unwrapping_HistogramPhaseUnwrappingG_delete, cv_PtrLcv_phase_unwrapping_HistogramPhaseUnwrappingG_getInnerPtr_const, cv_PtrLcv_phase_unwrapping_HistogramPhaseUnwrappingG_getInnerPtrMut
	}

	impl core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline] pub fn as_raw_PtrOfHistogramPhaseUnwrapping(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHistogramPhaseUnwrapping(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::phase_unwrapping::HistogramPhaseUnwrappingTraitConst for core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline] fn as_raw_HistogramPhaseUnwrapping(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::phase_unwrapping::HistogramPhaseUnwrappingTrait for core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline] fn as_raw_mut_HistogramPhaseUnwrapping(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping>, core::Ptr<core::Algorithm>, cv_PtrLcv_phase_unwrapping_HistogramPhaseUnwrappingG_to_PtrOfAlgorithm }

	impl crate::phase_unwrapping::PhaseUnwrappingTraitConst for core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline] fn as_raw_PhaseUnwrapping(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::phase_unwrapping::PhaseUnwrappingTrait for core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline] fn as_raw_mut_PhaseUnwrapping(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping>, core::Ptr<crate::phase_unwrapping::PhaseUnwrapping>, cv_PtrLcv_phase_unwrapping_HistogramPhaseUnwrappingG_to_PtrOfPhaseUnwrapping }

	impl std::fmt::Debug for core::Ptr<crate::phase_unwrapping::HistogramPhaseUnwrapping> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHistogramPhaseUnwrapping")
				.finish()
		}
	}

	ptr_extern! { crate::phase_unwrapping::PhaseUnwrapping,
		cv_PtrLcv_phase_unwrapping_PhaseUnwrappingG_new_null_const, cv_PtrLcv_phase_unwrapping_PhaseUnwrappingG_delete, cv_PtrLcv_phase_unwrapping_PhaseUnwrappingG_getInnerPtr_const, cv_PtrLcv_phase_unwrapping_PhaseUnwrappingG_getInnerPtrMut
	}

	impl core::Ptr<crate::phase_unwrapping::PhaseUnwrapping> {
		#[inline] pub fn as_raw_PtrOfPhaseUnwrapping(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPhaseUnwrapping(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::phase_unwrapping::PhaseUnwrappingTraitConst for core::Ptr<crate::phase_unwrapping::PhaseUnwrapping> {
		#[inline] fn as_raw_PhaseUnwrapping(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::phase_unwrapping::PhaseUnwrappingTrait for core::Ptr<crate::phase_unwrapping::PhaseUnwrapping> {
		#[inline] fn as_raw_mut_PhaseUnwrapping(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::phase_unwrapping::PhaseUnwrapping> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::phase_unwrapping::PhaseUnwrapping> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::phase_unwrapping::PhaseUnwrapping>, core::Ptr<core::Algorithm>, cv_PtrLcv_phase_unwrapping_PhaseUnwrappingG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::phase_unwrapping::PhaseUnwrapping> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPhaseUnwrapping")
				.finish()
		}
	}

}
pub use phase_unwrapping_types::*;

mod photo_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::photo::AlignExposures,
		cv_PtrLcv_AlignExposuresG_new_null_const, cv_PtrLcv_AlignExposuresG_delete, cv_PtrLcv_AlignExposuresG_getInnerPtr_const, cv_PtrLcv_AlignExposuresG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::AlignExposures> {
		#[inline] pub fn as_raw_PtrOfAlignExposures(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAlignExposures(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::AlignExposuresTraitConst for core::Ptr<crate::photo::AlignExposures> {
		#[inline] fn as_raw_AlignExposures(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::AlignExposuresTrait for core::Ptr<crate::photo::AlignExposures> {
		#[inline] fn as_raw_mut_AlignExposures(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::AlignExposures> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::AlignExposures> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::AlignExposures>, core::Ptr<core::Algorithm>, cv_PtrLcv_AlignExposuresG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::photo::AlignExposures> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAlignExposures")
				.finish()
		}
	}

	ptr_extern! { crate::photo::AlignMTB,
		cv_PtrLcv_AlignMTBG_new_null_const, cv_PtrLcv_AlignMTBG_delete, cv_PtrLcv_AlignMTBG_getInnerPtr_const, cv_PtrLcv_AlignMTBG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::AlignMTB> {
		#[inline] pub fn as_raw_PtrOfAlignMTB(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAlignMTB(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::AlignMTBTraitConst for core::Ptr<crate::photo::AlignMTB> {
		#[inline] fn as_raw_AlignMTB(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::AlignMTBTrait for core::Ptr<crate::photo::AlignMTB> {
		#[inline] fn as_raw_mut_AlignMTB(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::AlignMTB> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::AlignMTB> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::AlignMTB>, core::Ptr<core::Algorithm>, cv_PtrLcv_AlignMTBG_to_PtrOfAlgorithm }

	impl crate::photo::AlignExposuresTraitConst for core::Ptr<crate::photo::AlignMTB> {
		#[inline] fn as_raw_AlignExposures(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::AlignExposuresTrait for core::Ptr<crate::photo::AlignMTB> {
		#[inline] fn as_raw_mut_AlignExposures(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::AlignMTB>, core::Ptr<crate::photo::AlignExposures>, cv_PtrLcv_AlignMTBG_to_PtrOfAlignExposures }

	impl std::fmt::Debug for core::Ptr<crate::photo::AlignMTB> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAlignMTB")
				.finish()
		}
	}

	ptr_extern! { crate::photo::CalibrateCRF,
		cv_PtrLcv_CalibrateCRFG_new_null_const, cv_PtrLcv_CalibrateCRFG_delete, cv_PtrLcv_CalibrateCRFG_getInnerPtr_const, cv_PtrLcv_CalibrateCRFG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::CalibrateCRF> {
		#[inline] pub fn as_raw_PtrOfCalibrateCRF(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCalibrateCRF(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::CalibrateCRFTraitConst for core::Ptr<crate::photo::CalibrateCRF> {
		#[inline] fn as_raw_CalibrateCRF(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::CalibrateCRFTrait for core::Ptr<crate::photo::CalibrateCRF> {
		#[inline] fn as_raw_mut_CalibrateCRF(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::CalibrateCRF> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::CalibrateCRF> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::CalibrateCRF>, core::Ptr<core::Algorithm>, cv_PtrLcv_CalibrateCRFG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::photo::CalibrateCRF> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCalibrateCRF")
				.finish()
		}
	}

	ptr_extern! { crate::photo::CalibrateDebevec,
		cv_PtrLcv_CalibrateDebevecG_new_null_const, cv_PtrLcv_CalibrateDebevecG_delete, cv_PtrLcv_CalibrateDebevecG_getInnerPtr_const, cv_PtrLcv_CalibrateDebevecG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline] pub fn as_raw_PtrOfCalibrateDebevec(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCalibrateDebevec(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::CalibrateDebevecTraitConst for core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline] fn as_raw_CalibrateDebevec(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::CalibrateDebevecTrait for core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline] fn as_raw_mut_CalibrateDebevec(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::CalibrateDebevec>, core::Ptr<core::Algorithm>, cv_PtrLcv_CalibrateDebevecG_to_PtrOfAlgorithm }

	impl crate::photo::CalibrateCRFTraitConst for core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline] fn as_raw_CalibrateCRF(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::CalibrateCRFTrait for core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline] fn as_raw_mut_CalibrateCRF(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::CalibrateDebevec>, core::Ptr<crate::photo::CalibrateCRF>, cv_PtrLcv_CalibrateDebevecG_to_PtrOfCalibrateCRF }

	impl std::fmt::Debug for core::Ptr<crate::photo::CalibrateDebevec> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCalibrateDebevec")
				.finish()
		}
	}

	ptr_extern! { crate::photo::CalibrateRobertson,
		cv_PtrLcv_CalibrateRobertsonG_new_null_const, cv_PtrLcv_CalibrateRobertsonG_delete, cv_PtrLcv_CalibrateRobertsonG_getInnerPtr_const, cv_PtrLcv_CalibrateRobertsonG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline] pub fn as_raw_PtrOfCalibrateRobertson(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCalibrateRobertson(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::CalibrateRobertsonTraitConst for core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline] fn as_raw_CalibrateRobertson(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::CalibrateRobertsonTrait for core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline] fn as_raw_mut_CalibrateRobertson(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::CalibrateRobertson>, core::Ptr<core::Algorithm>, cv_PtrLcv_CalibrateRobertsonG_to_PtrOfAlgorithm }

	impl crate::photo::CalibrateCRFTraitConst for core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline] fn as_raw_CalibrateCRF(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::CalibrateCRFTrait for core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline] fn as_raw_mut_CalibrateCRF(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::CalibrateRobertson>, core::Ptr<crate::photo::CalibrateCRF>, cv_PtrLcv_CalibrateRobertsonG_to_PtrOfCalibrateCRF }

	impl std::fmt::Debug for core::Ptr<crate::photo::CalibrateRobertson> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCalibrateRobertson")
				.finish()
		}
	}

	ptr_extern! { crate::photo::MergeDebevec,
		cv_PtrLcv_MergeDebevecG_new_null_const, cv_PtrLcv_MergeDebevecG_delete, cv_PtrLcv_MergeDebevecG_getInnerPtr_const, cv_PtrLcv_MergeDebevecG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::MergeDebevec> {
		#[inline] pub fn as_raw_PtrOfMergeDebevec(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMergeDebevec(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::MergeDebevecTraitConst for core::Ptr<crate::photo::MergeDebevec> {
		#[inline] fn as_raw_MergeDebevec(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::MergeDebevecTrait for core::Ptr<crate::photo::MergeDebevec> {
		#[inline] fn as_raw_mut_MergeDebevec(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::MergeDebevec> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::MergeDebevec> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::MergeDebevec>, core::Ptr<core::Algorithm>, cv_PtrLcv_MergeDebevecG_to_PtrOfAlgorithm }

	impl crate::photo::MergeExposuresTraitConst for core::Ptr<crate::photo::MergeDebevec> {
		#[inline] fn as_raw_MergeExposures(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::MergeExposuresTrait for core::Ptr<crate::photo::MergeDebevec> {
		#[inline] fn as_raw_mut_MergeExposures(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::MergeDebevec>, core::Ptr<crate::photo::MergeExposures>, cv_PtrLcv_MergeDebevecG_to_PtrOfMergeExposures }

	impl std::fmt::Debug for core::Ptr<crate::photo::MergeDebevec> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMergeDebevec")
				.finish()
		}
	}

	ptr_extern! { crate::photo::MergeExposures,
		cv_PtrLcv_MergeExposuresG_new_null_const, cv_PtrLcv_MergeExposuresG_delete, cv_PtrLcv_MergeExposuresG_getInnerPtr_const, cv_PtrLcv_MergeExposuresG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::MergeExposures> {
		#[inline] pub fn as_raw_PtrOfMergeExposures(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMergeExposures(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::MergeExposuresTraitConst for core::Ptr<crate::photo::MergeExposures> {
		#[inline] fn as_raw_MergeExposures(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::MergeExposuresTrait for core::Ptr<crate::photo::MergeExposures> {
		#[inline] fn as_raw_mut_MergeExposures(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::MergeExposures> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::MergeExposures> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::MergeExposures>, core::Ptr<core::Algorithm>, cv_PtrLcv_MergeExposuresG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::photo::MergeExposures> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMergeExposures")
				.finish()
		}
	}

	ptr_extern! { crate::photo::MergeMertens,
		cv_PtrLcv_MergeMertensG_new_null_const, cv_PtrLcv_MergeMertensG_delete, cv_PtrLcv_MergeMertensG_getInnerPtr_const, cv_PtrLcv_MergeMertensG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::MergeMertens> {
		#[inline] pub fn as_raw_PtrOfMergeMertens(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMergeMertens(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::MergeMertensTraitConst for core::Ptr<crate::photo::MergeMertens> {
		#[inline] fn as_raw_MergeMertens(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::MergeMertensTrait for core::Ptr<crate::photo::MergeMertens> {
		#[inline] fn as_raw_mut_MergeMertens(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::MergeMertens> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::MergeMertens> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::MergeMertens>, core::Ptr<core::Algorithm>, cv_PtrLcv_MergeMertensG_to_PtrOfAlgorithm }

	impl crate::photo::MergeExposuresTraitConst for core::Ptr<crate::photo::MergeMertens> {
		#[inline] fn as_raw_MergeExposures(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::MergeExposuresTrait for core::Ptr<crate::photo::MergeMertens> {
		#[inline] fn as_raw_mut_MergeExposures(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::MergeMertens>, core::Ptr<crate::photo::MergeExposures>, cv_PtrLcv_MergeMertensG_to_PtrOfMergeExposures }

	impl std::fmt::Debug for core::Ptr<crate::photo::MergeMertens> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMergeMertens")
				.finish()
		}
	}

	ptr_extern! { crate::photo::MergeRobertson,
		cv_PtrLcv_MergeRobertsonG_new_null_const, cv_PtrLcv_MergeRobertsonG_delete, cv_PtrLcv_MergeRobertsonG_getInnerPtr_const, cv_PtrLcv_MergeRobertsonG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::MergeRobertson> {
		#[inline] pub fn as_raw_PtrOfMergeRobertson(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMergeRobertson(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::MergeRobertsonTraitConst for core::Ptr<crate::photo::MergeRobertson> {
		#[inline] fn as_raw_MergeRobertson(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::MergeRobertsonTrait for core::Ptr<crate::photo::MergeRobertson> {
		#[inline] fn as_raw_mut_MergeRobertson(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::MergeRobertson> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::MergeRobertson> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::MergeRobertson>, core::Ptr<core::Algorithm>, cv_PtrLcv_MergeRobertsonG_to_PtrOfAlgorithm }

	impl crate::photo::MergeExposuresTraitConst for core::Ptr<crate::photo::MergeRobertson> {
		#[inline] fn as_raw_MergeExposures(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::MergeExposuresTrait for core::Ptr<crate::photo::MergeRobertson> {
		#[inline] fn as_raw_mut_MergeExposures(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::MergeRobertson>, core::Ptr<crate::photo::MergeExposures>, cv_PtrLcv_MergeRobertsonG_to_PtrOfMergeExposures }

	impl std::fmt::Debug for core::Ptr<crate::photo::MergeRobertson> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMergeRobertson")
				.finish()
		}
	}

	ptr_extern! { crate::photo::Tonemap,
		cv_PtrLcv_TonemapG_new_null_const, cv_PtrLcv_TonemapG_delete, cv_PtrLcv_TonemapG_getInnerPtr_const, cv_PtrLcv_TonemapG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::Tonemap> {
		#[inline] pub fn as_raw_PtrOfTonemap(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTonemap(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::TonemapTraitConst for core::Ptr<crate::photo::Tonemap> {
		#[inline] fn as_raw_Tonemap(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::TonemapTrait for core::Ptr<crate::photo::Tonemap> {
		#[inline] fn as_raw_mut_Tonemap(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::Tonemap> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::Tonemap> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::Tonemap>, core::Ptr<core::Algorithm>, cv_PtrLcv_TonemapG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::photo::Tonemap> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTonemap")
				.finish()
		}
	}

	ptr_extern! { crate::photo::TonemapDrago,
		cv_PtrLcv_TonemapDragoG_new_null_const, cv_PtrLcv_TonemapDragoG_delete, cv_PtrLcv_TonemapDragoG_getInnerPtr_const, cv_PtrLcv_TonemapDragoG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::TonemapDrago> {
		#[inline] pub fn as_raw_PtrOfTonemapDrago(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTonemapDrago(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::TonemapDragoTraitConst for core::Ptr<crate::photo::TonemapDrago> {
		#[inline] fn as_raw_TonemapDrago(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::TonemapDragoTrait for core::Ptr<crate::photo::TonemapDrago> {
		#[inline] fn as_raw_mut_TonemapDrago(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::TonemapDrago> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::TonemapDrago> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::TonemapDrago>, core::Ptr<core::Algorithm>, cv_PtrLcv_TonemapDragoG_to_PtrOfAlgorithm }

	impl crate::photo::TonemapTraitConst for core::Ptr<crate::photo::TonemapDrago> {
		#[inline] fn as_raw_Tonemap(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::TonemapTrait for core::Ptr<crate::photo::TonemapDrago> {
		#[inline] fn as_raw_mut_Tonemap(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::TonemapDrago>, core::Ptr<crate::photo::Tonemap>, cv_PtrLcv_TonemapDragoG_to_PtrOfTonemap }

	impl std::fmt::Debug for core::Ptr<crate::photo::TonemapDrago> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTonemapDrago")
				.finish()
		}
	}

	ptr_extern! { crate::photo::TonemapMantiuk,
		cv_PtrLcv_TonemapMantiukG_new_null_const, cv_PtrLcv_TonemapMantiukG_delete, cv_PtrLcv_TonemapMantiukG_getInnerPtr_const, cv_PtrLcv_TonemapMantiukG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline] pub fn as_raw_PtrOfTonemapMantiuk(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTonemapMantiuk(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::TonemapMantiukTraitConst for core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline] fn as_raw_TonemapMantiuk(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::TonemapMantiukTrait for core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline] fn as_raw_mut_TonemapMantiuk(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::TonemapMantiuk>, core::Ptr<core::Algorithm>, cv_PtrLcv_TonemapMantiukG_to_PtrOfAlgorithm }

	impl crate::photo::TonemapTraitConst for core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline] fn as_raw_Tonemap(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::TonemapTrait for core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline] fn as_raw_mut_Tonemap(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::TonemapMantiuk>, core::Ptr<crate::photo::Tonemap>, cv_PtrLcv_TonemapMantiukG_to_PtrOfTonemap }

	impl std::fmt::Debug for core::Ptr<crate::photo::TonemapMantiuk> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTonemapMantiuk")
				.finish()
		}
	}

	ptr_extern! { crate::photo::TonemapReinhard,
		cv_PtrLcv_TonemapReinhardG_new_null_const, cv_PtrLcv_TonemapReinhardG_delete, cv_PtrLcv_TonemapReinhardG_getInnerPtr_const, cv_PtrLcv_TonemapReinhardG_getInnerPtrMut
	}

	impl core::Ptr<crate::photo::TonemapReinhard> {
		#[inline] pub fn as_raw_PtrOfTonemapReinhard(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfTonemapReinhard(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::photo::TonemapReinhardTraitConst for core::Ptr<crate::photo::TonemapReinhard> {
		#[inline] fn as_raw_TonemapReinhard(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::TonemapReinhardTrait for core::Ptr<crate::photo::TonemapReinhard> {
		#[inline] fn as_raw_mut_TonemapReinhard(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::photo::TonemapReinhard> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::photo::TonemapReinhard> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::TonemapReinhard>, core::Ptr<core::Algorithm>, cv_PtrLcv_TonemapReinhardG_to_PtrOfAlgorithm }

	impl crate::photo::TonemapTraitConst for core::Ptr<crate::photo::TonemapReinhard> {
		#[inline] fn as_raw_Tonemap(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::photo::TonemapTrait for core::Ptr<crate::photo::TonemapReinhard> {
		#[inline] fn as_raw_mut_Tonemap(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::photo::TonemapReinhard>, core::Ptr<crate::photo::Tonemap>, cv_PtrLcv_TonemapReinhardG_to_PtrOfTonemap }

	impl std::fmt::Debug for core::Ptr<crate::photo::TonemapReinhard> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfTonemapReinhard")
				.finish()
		}
	}

}
pub use photo_types::*;

mod plot_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::plot::Plot2d,
		cv_PtrLcv_plot_Plot2dG_new_null_const, cv_PtrLcv_plot_Plot2dG_delete, cv_PtrLcv_plot_Plot2dG_getInnerPtr_const, cv_PtrLcv_plot_Plot2dG_getInnerPtrMut
	}

	impl core::Ptr<crate::plot::Plot2d> {
		#[inline] pub fn as_raw_PtrOfPlot2d(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfPlot2d(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::plot::Plot2dTraitConst for core::Ptr<crate::plot::Plot2d> {
		#[inline] fn as_raw_Plot2d(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::plot::Plot2dTrait for core::Ptr<crate::plot::Plot2d> {
		#[inline] fn as_raw_mut_Plot2d(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::plot::Plot2d> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::plot::Plot2d> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::plot::Plot2d>, core::Ptr<core::Algorithm>, cv_PtrLcv_plot_Plot2dG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::plot::Plot2d> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfPlot2d")
				.finish()
		}
	}

}
pub use plot_types::*;

mod quality_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::quality::QualityBRISQUE,
		cv_PtrLcv_quality_QualityBRISQUEG_new_null_const, cv_PtrLcv_quality_QualityBRISQUEG_delete, cv_PtrLcv_quality_QualityBRISQUEG_getInnerPtr_const, cv_PtrLcv_quality_QualityBRISQUEG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::quality::QualityBRISQUE, cv_PtrLcv_quality_QualityBRISQUEG_new_const_QualityBRISQUE }
	impl core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline] pub fn as_raw_PtrOfQualityBRISQUE(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQualityBRISQUE(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::quality::QualityBRISQUETraitConst for core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline] fn as_raw_QualityBRISQUE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityBRISQUETrait for core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline] fn as_raw_mut_QualityBRISQUE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityBRISQUE>, core::Ptr<core::Algorithm>, cv_PtrLcv_quality_QualityBRISQUEG_to_PtrOfAlgorithm }

	impl crate::quality::QualityBaseTraitConst for core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline] fn as_raw_QualityBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityBaseTrait for core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline] fn as_raw_mut_QualityBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityBRISQUE>, core::Ptr<crate::quality::QualityBase>, cv_PtrLcv_quality_QualityBRISQUEG_to_PtrOfQualityBase }

	impl std::fmt::Debug for core::Ptr<crate::quality::QualityBRISQUE> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQualityBRISQUE")
				.finish()
		}
	}

	ptr_extern! { crate::quality::QualityBase,
		cv_PtrLcv_quality_QualityBaseG_new_null_const, cv_PtrLcv_quality_QualityBaseG_delete, cv_PtrLcv_quality_QualityBaseG_getInnerPtr_const, cv_PtrLcv_quality_QualityBaseG_getInnerPtrMut
	}

	impl core::Ptr<crate::quality::QualityBase> {
		#[inline] pub fn as_raw_PtrOfQualityBase(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQualityBase(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::quality::QualityBaseTraitConst for core::Ptr<crate::quality::QualityBase> {
		#[inline] fn as_raw_QualityBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityBaseTrait for core::Ptr<crate::quality::QualityBase> {
		#[inline] fn as_raw_mut_QualityBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::quality::QualityBase> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::quality::QualityBase> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityBase>, core::Ptr<core::Algorithm>, cv_PtrLcv_quality_QualityBaseG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::quality::QualityBase> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQualityBase")
				.finish()
		}
	}

	ptr_extern! { crate::quality::QualityGMSD,
		cv_PtrLcv_quality_QualityGMSDG_new_null_const, cv_PtrLcv_quality_QualityGMSDG_delete, cv_PtrLcv_quality_QualityGMSDG_getInnerPtr_const, cv_PtrLcv_quality_QualityGMSDG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::quality::QualityGMSD, cv_PtrLcv_quality_QualityGMSDG_new_const_QualityGMSD }
	impl core::Ptr<crate::quality::QualityGMSD> {
		#[inline] pub fn as_raw_PtrOfQualityGMSD(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQualityGMSD(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::quality::QualityGMSDTraitConst for core::Ptr<crate::quality::QualityGMSD> {
		#[inline] fn as_raw_QualityGMSD(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityGMSDTrait for core::Ptr<crate::quality::QualityGMSD> {
		#[inline] fn as_raw_mut_QualityGMSD(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::quality::QualityGMSD> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::quality::QualityGMSD> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityGMSD>, core::Ptr<core::Algorithm>, cv_PtrLcv_quality_QualityGMSDG_to_PtrOfAlgorithm }

	impl crate::quality::QualityBaseTraitConst for core::Ptr<crate::quality::QualityGMSD> {
		#[inline] fn as_raw_QualityBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityBaseTrait for core::Ptr<crate::quality::QualityGMSD> {
		#[inline] fn as_raw_mut_QualityBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityGMSD>, core::Ptr<crate::quality::QualityBase>, cv_PtrLcv_quality_QualityGMSDG_to_PtrOfQualityBase }

	impl std::fmt::Debug for core::Ptr<crate::quality::QualityGMSD> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQualityGMSD")
				.finish()
		}
	}

	ptr_extern! { crate::quality::QualityMSE,
		cv_PtrLcv_quality_QualityMSEG_new_null_const, cv_PtrLcv_quality_QualityMSEG_delete, cv_PtrLcv_quality_QualityMSEG_getInnerPtr_const, cv_PtrLcv_quality_QualityMSEG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::quality::QualityMSE, cv_PtrLcv_quality_QualityMSEG_new_const_QualityMSE }
	impl core::Ptr<crate::quality::QualityMSE> {
		#[inline] pub fn as_raw_PtrOfQualityMSE(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQualityMSE(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::quality::QualityMSETraitConst for core::Ptr<crate::quality::QualityMSE> {
		#[inline] fn as_raw_QualityMSE(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityMSETrait for core::Ptr<crate::quality::QualityMSE> {
		#[inline] fn as_raw_mut_QualityMSE(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::quality::QualityMSE> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::quality::QualityMSE> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityMSE>, core::Ptr<core::Algorithm>, cv_PtrLcv_quality_QualityMSEG_to_PtrOfAlgorithm }

	impl crate::quality::QualityBaseTraitConst for core::Ptr<crate::quality::QualityMSE> {
		#[inline] fn as_raw_QualityBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityBaseTrait for core::Ptr<crate::quality::QualityMSE> {
		#[inline] fn as_raw_mut_QualityBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityMSE>, core::Ptr<crate::quality::QualityBase>, cv_PtrLcv_quality_QualityMSEG_to_PtrOfQualityBase }

	impl std::fmt::Debug for core::Ptr<crate::quality::QualityMSE> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQualityMSE")
				.finish()
		}
	}

	ptr_extern! { crate::quality::QualityPSNR,
		cv_PtrLcv_quality_QualityPSNRG_new_null_const, cv_PtrLcv_quality_QualityPSNRG_delete, cv_PtrLcv_quality_QualityPSNRG_getInnerPtr_const, cv_PtrLcv_quality_QualityPSNRG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::quality::QualityPSNR, cv_PtrLcv_quality_QualityPSNRG_new_const_QualityPSNR }
	impl core::Ptr<crate::quality::QualityPSNR> {
		#[inline] pub fn as_raw_PtrOfQualityPSNR(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQualityPSNR(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::quality::QualityPSNRTraitConst for core::Ptr<crate::quality::QualityPSNR> {
		#[inline] fn as_raw_QualityPSNR(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityPSNRTrait for core::Ptr<crate::quality::QualityPSNR> {
		#[inline] fn as_raw_mut_QualityPSNR(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::quality::QualityPSNR> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::quality::QualityPSNR> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityPSNR>, core::Ptr<core::Algorithm>, cv_PtrLcv_quality_QualityPSNRG_to_PtrOfAlgorithm }

	impl crate::quality::QualityBaseTraitConst for core::Ptr<crate::quality::QualityPSNR> {
		#[inline] fn as_raw_QualityBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityBaseTrait for core::Ptr<crate::quality::QualityPSNR> {
		#[inline] fn as_raw_mut_QualityBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualityPSNR>, core::Ptr<crate::quality::QualityBase>, cv_PtrLcv_quality_QualityPSNRG_to_PtrOfQualityBase }

	impl std::fmt::Debug for core::Ptr<crate::quality::QualityPSNR> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQualityPSNR")
				.finish()
		}
	}

	ptr_extern! { crate::quality::QualitySSIM,
		cv_PtrLcv_quality_QualitySSIMG_new_null_const, cv_PtrLcv_quality_QualitySSIMG_delete, cv_PtrLcv_quality_QualitySSIMG_getInnerPtr_const, cv_PtrLcv_quality_QualitySSIMG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::quality::QualitySSIM, cv_PtrLcv_quality_QualitySSIMG_new_const_QualitySSIM }
	impl core::Ptr<crate::quality::QualitySSIM> {
		#[inline] pub fn as_raw_PtrOfQualitySSIM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQualitySSIM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::quality::QualitySSIMTraitConst for core::Ptr<crate::quality::QualitySSIM> {
		#[inline] fn as_raw_QualitySSIM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualitySSIMTrait for core::Ptr<crate::quality::QualitySSIM> {
		#[inline] fn as_raw_mut_QualitySSIM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::quality::QualitySSIM> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::quality::QualitySSIM> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualitySSIM>, core::Ptr<core::Algorithm>, cv_PtrLcv_quality_QualitySSIMG_to_PtrOfAlgorithm }

	impl crate::quality::QualityBaseTraitConst for core::Ptr<crate::quality::QualitySSIM> {
		#[inline] fn as_raw_QualityBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::quality::QualityBaseTrait for core::Ptr<crate::quality::QualitySSIM> {
		#[inline] fn as_raw_mut_QualityBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::quality::QualitySSIM>, core::Ptr<crate::quality::QualityBase>, cv_PtrLcv_quality_QualitySSIMG_to_PtrOfQualityBase }

	impl std::fmt::Debug for core::Ptr<crate::quality::QualitySSIM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQualitySSIM")
				.finish()
		}
	}

}
pub use quality_types::*;

mod rapid_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::rapid::Rapid_GOSTracker,
		cv_PtrLcv_rapid_GOSTrackerG_new_null_const, cv_PtrLcv_rapid_GOSTrackerG_delete, cv_PtrLcv_rapid_GOSTrackerG_getInnerPtr_const, cv_PtrLcv_rapid_GOSTrackerG_getInnerPtrMut
	}

	impl core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline] pub fn as_raw_PtrOfRapid_GOSTracker(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRapid_GOSTracker(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rapid::Rapid_GOSTrackerTraitConst for core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline] fn as_raw_Rapid_GOSTracker(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rapid::Rapid_GOSTrackerTrait for core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline] fn as_raw_mut_Rapid_GOSTracker(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rapid::Rapid_GOSTracker>, core::Ptr<core::Algorithm>, cv_PtrLcv_rapid_GOSTrackerG_to_PtrOfAlgorithm }

	impl crate::rapid::Rapid_TrackerTraitConst for core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline] fn as_raw_Rapid_Tracker(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rapid::Rapid_TrackerTrait for core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline] fn as_raw_mut_Rapid_Tracker(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rapid::Rapid_GOSTracker>, core::Ptr<crate::rapid::Rapid_Tracker>, cv_PtrLcv_rapid_GOSTrackerG_to_PtrOfRapid_Tracker }

	impl std::fmt::Debug for core::Ptr<crate::rapid::Rapid_GOSTracker> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRapid_GOSTracker")
				.finish()
		}
	}

	ptr_extern! { crate::rapid::Rapid_OLSTracker,
		cv_PtrLcv_rapid_OLSTrackerG_new_null_const, cv_PtrLcv_rapid_OLSTrackerG_delete, cv_PtrLcv_rapid_OLSTrackerG_getInnerPtr_const, cv_PtrLcv_rapid_OLSTrackerG_getInnerPtrMut
	}

	impl core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline] pub fn as_raw_PtrOfRapid_OLSTracker(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRapid_OLSTracker(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rapid::Rapid_OLSTrackerTraitConst for core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline] fn as_raw_Rapid_OLSTracker(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rapid::Rapid_OLSTrackerTrait for core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline] fn as_raw_mut_Rapid_OLSTracker(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rapid::Rapid_OLSTracker>, core::Ptr<core::Algorithm>, cv_PtrLcv_rapid_OLSTrackerG_to_PtrOfAlgorithm }

	impl crate::rapid::Rapid_TrackerTraitConst for core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline] fn as_raw_Rapid_Tracker(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rapid::Rapid_TrackerTrait for core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline] fn as_raw_mut_Rapid_Tracker(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rapid::Rapid_OLSTracker>, core::Ptr<crate::rapid::Rapid_Tracker>, cv_PtrLcv_rapid_OLSTrackerG_to_PtrOfRapid_Tracker }

	impl std::fmt::Debug for core::Ptr<crate::rapid::Rapid_OLSTracker> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRapid_OLSTracker")
				.finish()
		}
	}

	ptr_extern! { crate::rapid::Rapid_Rapid,
		cv_PtrLcv_rapid_RapidG_new_null_const, cv_PtrLcv_rapid_RapidG_delete, cv_PtrLcv_rapid_RapidG_getInnerPtr_const, cv_PtrLcv_rapid_RapidG_getInnerPtrMut
	}

	impl core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline] pub fn as_raw_PtrOfRapid_Rapid(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRapid_Rapid(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rapid::Rapid_RapidTraitConst for core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline] fn as_raw_Rapid_Rapid(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rapid::Rapid_RapidTrait for core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline] fn as_raw_mut_Rapid_Rapid(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rapid::Rapid_Rapid>, core::Ptr<core::Algorithm>, cv_PtrLcv_rapid_RapidG_to_PtrOfAlgorithm }

	impl crate::rapid::Rapid_TrackerTraitConst for core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline] fn as_raw_Rapid_Tracker(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rapid::Rapid_TrackerTrait for core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline] fn as_raw_mut_Rapid_Tracker(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rapid::Rapid_Rapid>, core::Ptr<crate::rapid::Rapid_Tracker>, cv_PtrLcv_rapid_RapidG_to_PtrOfRapid_Tracker }

	impl std::fmt::Debug for core::Ptr<crate::rapid::Rapid_Rapid> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRapid_Rapid")
				.finish()
		}
	}

	ptr_extern! { crate::rapid::Rapid_Tracker,
		cv_PtrLcv_rapid_TrackerG_new_null_const, cv_PtrLcv_rapid_TrackerG_delete, cv_PtrLcv_rapid_TrackerG_getInnerPtr_const, cv_PtrLcv_rapid_TrackerG_getInnerPtrMut
	}

	impl core::Ptr<crate::rapid::Rapid_Tracker> {
		#[inline] pub fn as_raw_PtrOfRapid_Tracker(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRapid_Tracker(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rapid::Rapid_TrackerTraitConst for core::Ptr<crate::rapid::Rapid_Tracker> {
		#[inline] fn as_raw_Rapid_Tracker(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rapid::Rapid_TrackerTrait for core::Ptr<crate::rapid::Rapid_Tracker> {
		#[inline] fn as_raw_mut_Rapid_Tracker(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rapid::Rapid_Tracker> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rapid::Rapid_Tracker> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rapid::Rapid_Tracker>, core::Ptr<core::Algorithm>, cv_PtrLcv_rapid_TrackerG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::rapid::Rapid_Tracker> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRapid_Tracker")
				.finish()
		}
	}

}
pub use rapid_types::*;

mod rgbd_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::rgbd::ColoredKinfu_ColoredKinFu,
		cv_PtrLcv_colored_kinfu_ColoredKinFuG_new_null_const, cv_PtrLcv_colored_kinfu_ColoredKinFuG_delete, cv_PtrLcv_colored_kinfu_ColoredKinFuG_getInnerPtr_const, cv_PtrLcv_colored_kinfu_ColoredKinFuG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::ColoredKinfu_ColoredKinFu> {
		#[inline] pub fn as_raw_PtrOfColoredKinfu_ColoredKinFu(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfColoredKinfu_ColoredKinFu(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::ColoredKinfu_ColoredKinFuTraitConst for core::Ptr<crate::rgbd::ColoredKinfu_ColoredKinFu> {
		#[inline] fn as_raw_ColoredKinfu_ColoredKinFu(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::ColoredKinfu_ColoredKinFuTrait for core::Ptr<crate::rgbd::ColoredKinfu_ColoredKinFu> {
		#[inline] fn as_raw_mut_ColoredKinfu_ColoredKinFu(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::ColoredKinfu_ColoredKinFu> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfColoredKinfu_ColoredKinFu")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::ColoredKinfu_Params,
		cv_PtrLcv_colored_kinfu_ParamsG_new_null_const, cv_PtrLcv_colored_kinfu_ParamsG_delete, cv_PtrLcv_colored_kinfu_ParamsG_getInnerPtr_const, cv_PtrLcv_colored_kinfu_ParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::ColoredKinfu_Params, cv_PtrLcv_colored_kinfu_ParamsG_new_const_Params }
	impl core::Ptr<crate::rgbd::ColoredKinfu_Params> {
		#[inline] pub fn as_raw_PtrOfColoredKinfu_Params(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfColoredKinfu_Params(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::ColoredKinfu_ParamsTraitConst for core::Ptr<crate::rgbd::ColoredKinfu_Params> {
		#[inline] fn as_raw_ColoredKinfu_Params(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::ColoredKinfu_ParamsTrait for core::Ptr<crate::rgbd::ColoredKinfu_Params> {
		#[inline] fn as_raw_mut_ColoredKinfu_Params(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::ColoredKinfu_Params> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfColoredKinfu_Params")
				.field("frame_size", &crate::rgbd::ColoredKinfu_ParamsTraitConst::frame_size(self))
				.field("rgb_frame_size", &crate::rgbd::ColoredKinfu_ParamsTraitConst::rgb_frame_size(self))
				.field("volume_type", &crate::rgbd::ColoredKinfu_ParamsTraitConst::volume_type(self))
				.field("intr", &crate::rgbd::ColoredKinfu_ParamsTraitConst::intr(self))
				.field("rgb_intr", &crate::rgbd::ColoredKinfu_ParamsTraitConst::rgb_intr(self))
				.field("depth_factor", &crate::rgbd::ColoredKinfu_ParamsTraitConst::depth_factor(self))
				.field("bilateral_sigma_depth", &crate::rgbd::ColoredKinfu_ParamsTraitConst::bilateral_sigma_depth(self))
				.field("bilateral_sigma_spatial", &crate::rgbd::ColoredKinfu_ParamsTraitConst::bilateral_sigma_spatial(self))
				.field("bilateral_kernel_size", &crate::rgbd::ColoredKinfu_ParamsTraitConst::bilateral_kernel_size(self))
				.field("pyramid_levels", &crate::rgbd::ColoredKinfu_ParamsTraitConst::pyramid_levels(self))
				.field("volume_dims", &crate::rgbd::ColoredKinfu_ParamsTraitConst::volume_dims(self))
				.field("voxel_size", &crate::rgbd::ColoredKinfu_ParamsTraitConst::voxel_size(self))
				.field("tsdf_min_camera_movement", &crate::rgbd::ColoredKinfu_ParamsTraitConst::tsdf_min_camera_movement(self))
				.field("volume_pose", &crate::rgbd::ColoredKinfu_ParamsTraitConst::volume_pose(self))
				.field("tsdf_trunc_dist", &crate::rgbd::ColoredKinfu_ParamsTraitConst::tsdf_trunc_dist(self))
				.field("tsdf_max_weight", &crate::rgbd::ColoredKinfu_ParamsTraitConst::tsdf_max_weight(self))
				.field("raycast_step_factor", &crate::rgbd::ColoredKinfu_ParamsTraitConst::raycast_step_factor(self))
				.field("light_pose", &crate::rgbd::ColoredKinfu_ParamsTraitConst::light_pose(self))
				.field("icp_dist_thresh", &crate::rgbd::ColoredKinfu_ParamsTraitConst::icp_dist_thresh(self))
				.field("icp_angle_thresh", &crate::rgbd::ColoredKinfu_ParamsTraitConst::icp_angle_thresh(self))
				.field("icp_iterations", &crate::rgbd::ColoredKinfu_ParamsTraitConst::icp_iterations(self))
				.field("truncate_threshold", &crate::rgbd::ColoredKinfu_ParamsTraitConst::truncate_threshold(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::DepthCleaner,
		cv_PtrLcv_rgbd_DepthCleanerG_new_null_const, cv_PtrLcv_rgbd_DepthCleanerG_delete, cv_PtrLcv_rgbd_DepthCleanerG_getInnerPtr_const, cv_PtrLcv_rgbd_DepthCleanerG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::DepthCleaner, cv_PtrLcv_rgbd_DepthCleanerG_new_const_DepthCleaner }
	impl core::Ptr<crate::rgbd::DepthCleaner> {
		#[inline] pub fn as_raw_PtrOfDepthCleaner(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDepthCleaner(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::DepthCleanerTraitConst for core::Ptr<crate::rgbd::DepthCleaner> {
		#[inline] fn as_raw_DepthCleaner(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::DepthCleanerTrait for core::Ptr<crate::rgbd::DepthCleaner> {
		#[inline] fn as_raw_mut_DepthCleaner(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::DepthCleaner> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::DepthCleaner> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::DepthCleaner>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_DepthCleanerG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::DepthCleaner> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDepthCleaner")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Dynafu_DynaFu,
		cv_PtrLcv_dynafu_DynaFuG_new_null_const, cv_PtrLcv_dynafu_DynaFuG_delete, cv_PtrLcv_dynafu_DynaFuG_getInnerPtr_const, cv_PtrLcv_dynafu_DynaFuG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::Dynafu_DynaFu> {
		#[inline] pub fn as_raw_PtrOfDynafu_DynaFu(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDynafu_DynaFu(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::Dynafu_DynaFuTraitConst for core::Ptr<crate::rgbd::Dynafu_DynaFu> {
		#[inline] fn as_raw_Dynafu_DynaFu(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::Dynafu_DynaFuTrait for core::Ptr<crate::rgbd::Dynafu_DynaFu> {
		#[inline] fn as_raw_mut_Dynafu_DynaFu(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Dynafu_DynaFu> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDynafu_DynaFu")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::FastICPOdometry,
		cv_PtrLcv_rgbd_FastICPOdometryG_new_null_const, cv_PtrLcv_rgbd_FastICPOdometryG_delete, cv_PtrLcv_rgbd_FastICPOdometryG_getInnerPtr_const, cv_PtrLcv_rgbd_FastICPOdometryG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::FastICPOdometry, cv_PtrLcv_rgbd_FastICPOdometryG_new_const_FastICPOdometry }
	impl core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline] pub fn as_raw_PtrOfFastICPOdometry(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfFastICPOdometry(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::FastICPOdometryTraitConst for core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline] fn as_raw_FastICPOdometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::FastICPOdometryTrait for core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline] fn as_raw_mut_FastICPOdometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::FastICPOdometry>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_FastICPOdometryG_to_PtrOfAlgorithm }

	impl crate::rgbd::OdometryTraitConst for core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline] fn as_raw_Odometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::OdometryTrait for core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline] fn as_raw_mut_Odometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::FastICPOdometry>, core::Ptr<crate::rgbd::Odometry>, cv_PtrLcv_rgbd_FastICPOdometryG_to_PtrOfOdometry }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::FastICPOdometry> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfFastICPOdometry")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::ICPOdometry,
		cv_PtrLcv_rgbd_ICPOdometryG_new_null_const, cv_PtrLcv_rgbd_ICPOdometryG_delete, cv_PtrLcv_rgbd_ICPOdometryG_getInnerPtr_const, cv_PtrLcv_rgbd_ICPOdometryG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::ICPOdometry, cv_PtrLcv_rgbd_ICPOdometryG_new_const_ICPOdometry }
	impl core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline] pub fn as_raw_PtrOfICPOdometry(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfICPOdometry(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::ICPOdometryTraitConst for core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline] fn as_raw_ICPOdometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::ICPOdometryTrait for core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline] fn as_raw_mut_ICPOdometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::ICPOdometry>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_ICPOdometryG_to_PtrOfAlgorithm }

	impl crate::rgbd::OdometryTraitConst for core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline] fn as_raw_Odometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::OdometryTrait for core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline] fn as_raw_mut_Odometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::ICPOdometry>, core::Ptr<crate::rgbd::Odometry>, cv_PtrLcv_rgbd_ICPOdometryG_to_PtrOfOdometry }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::ICPOdometry> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfICPOdometry")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Kinfu_Detail_PoseGraph,
		cv_PtrLcv_kinfu_detail_PoseGraphG_new_null_const, cv_PtrLcv_kinfu_detail_PoseGraphG_delete, cv_PtrLcv_kinfu_detail_PoseGraphG_getInnerPtr_const, cv_PtrLcv_kinfu_detail_PoseGraphG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::Kinfu_Detail_PoseGraph> {
		#[inline] pub fn as_raw_PtrOfKinfu_Detail_PoseGraph(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKinfu_Detail_PoseGraph(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::Kinfu_Detail_PoseGraphTraitConst for core::Ptr<crate::rgbd::Kinfu_Detail_PoseGraph> {
		#[inline] fn as_raw_Kinfu_Detail_PoseGraph(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::Kinfu_Detail_PoseGraphTrait for core::Ptr<crate::rgbd::Kinfu_Detail_PoseGraph> {
		#[inline] fn as_raw_mut_Kinfu_Detail_PoseGraph(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Kinfu_Detail_PoseGraph> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKinfu_Detail_PoseGraph")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Kinfu_KinFu,
		cv_PtrLcv_kinfu_KinFuG_new_null_const, cv_PtrLcv_kinfu_KinFuG_delete, cv_PtrLcv_kinfu_KinFuG_getInnerPtr_const, cv_PtrLcv_kinfu_KinFuG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::Kinfu_KinFu> {
		#[inline] pub fn as_raw_PtrOfKinfu_KinFu(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKinfu_KinFu(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::Kinfu_KinFuTraitConst for core::Ptr<crate::rgbd::Kinfu_KinFu> {
		#[inline] fn as_raw_Kinfu_KinFu(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::Kinfu_KinFuTrait for core::Ptr<crate::rgbd::Kinfu_KinFu> {
		#[inline] fn as_raw_mut_Kinfu_KinFu(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Kinfu_KinFu> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKinfu_KinFu")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Kinfu_Params,
		cv_PtrLcv_kinfu_ParamsG_new_null_const, cv_PtrLcv_kinfu_ParamsG_delete, cv_PtrLcv_kinfu_ParamsG_getInnerPtr_const, cv_PtrLcv_kinfu_ParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::Kinfu_Params, cv_PtrLcv_kinfu_ParamsG_new_const_Params }
	impl core::Ptr<crate::rgbd::Kinfu_Params> {
		#[inline] pub fn as_raw_PtrOfKinfu_Params(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKinfu_Params(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::Kinfu_ParamsTraitConst for core::Ptr<crate::rgbd::Kinfu_Params> {
		#[inline] fn as_raw_Kinfu_Params(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::Kinfu_ParamsTrait for core::Ptr<crate::rgbd::Kinfu_Params> {
		#[inline] fn as_raw_mut_Kinfu_Params(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Kinfu_Params> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKinfu_Params")
				.field("frame_size", &crate::rgbd::Kinfu_ParamsTraitConst::frame_size(self))
				.field("volume_type", &crate::rgbd::Kinfu_ParamsTraitConst::volume_type(self))
				.field("intr", &crate::rgbd::Kinfu_ParamsTraitConst::intr(self))
				.field("rgb_intr", &crate::rgbd::Kinfu_ParamsTraitConst::rgb_intr(self))
				.field("depth_factor", &crate::rgbd::Kinfu_ParamsTraitConst::depth_factor(self))
				.field("bilateral_sigma_depth", &crate::rgbd::Kinfu_ParamsTraitConst::bilateral_sigma_depth(self))
				.field("bilateral_sigma_spatial", &crate::rgbd::Kinfu_ParamsTraitConst::bilateral_sigma_spatial(self))
				.field("bilateral_kernel_size", &crate::rgbd::Kinfu_ParamsTraitConst::bilateral_kernel_size(self))
				.field("pyramid_levels", &crate::rgbd::Kinfu_ParamsTraitConst::pyramid_levels(self))
				.field("volume_dims", &crate::rgbd::Kinfu_ParamsTraitConst::volume_dims(self))
				.field("voxel_size", &crate::rgbd::Kinfu_ParamsTraitConst::voxel_size(self))
				.field("tsdf_min_camera_movement", &crate::rgbd::Kinfu_ParamsTraitConst::tsdf_min_camera_movement(self))
				.field("volume_pose", &crate::rgbd::Kinfu_ParamsTraitConst::volume_pose(self))
				.field("tsdf_trunc_dist", &crate::rgbd::Kinfu_ParamsTraitConst::tsdf_trunc_dist(self))
				.field("tsdf_max_weight", &crate::rgbd::Kinfu_ParamsTraitConst::tsdf_max_weight(self))
				.field("raycast_step_factor", &crate::rgbd::Kinfu_ParamsTraitConst::raycast_step_factor(self))
				.field("light_pose", &crate::rgbd::Kinfu_ParamsTraitConst::light_pose(self))
				.field("icp_dist_thresh", &crate::rgbd::Kinfu_ParamsTraitConst::icp_dist_thresh(self))
				.field("icp_angle_thresh", &crate::rgbd::Kinfu_ParamsTraitConst::icp_angle_thresh(self))
				.field("icp_iterations", &crate::rgbd::Kinfu_ParamsTraitConst::icp_iterations(self))
				.field("truncate_threshold", &crate::rgbd::Kinfu_ParamsTraitConst::truncate_threshold(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Kinfu_Volume,
		cv_PtrLcv_kinfu_VolumeG_new_null_const, cv_PtrLcv_kinfu_VolumeG_delete, cv_PtrLcv_kinfu_VolumeG_getInnerPtr_const, cv_PtrLcv_kinfu_VolumeG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::Kinfu_Volume> {
		#[inline] pub fn as_raw_PtrOfKinfu_Volume(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKinfu_Volume(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::Kinfu_VolumeTraitConst for core::Ptr<crate::rgbd::Kinfu_Volume> {
		#[inline] fn as_raw_Kinfu_Volume(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::Kinfu_VolumeTrait for core::Ptr<crate::rgbd::Kinfu_Volume> {
		#[inline] fn as_raw_mut_Kinfu_Volume(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Kinfu_Volume> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKinfu_Volume")
				.field("voxel_size", &crate::rgbd::Kinfu_VolumeTraitConst::voxel_size(self))
				.field("voxel_size_inv", &crate::rgbd::Kinfu_VolumeTraitConst::voxel_size_inv(self))
				.field("pose", &crate::rgbd::Kinfu_VolumeTraitConst::pose(self))
				.field("raycast_step_factor", &crate::rgbd::Kinfu_VolumeTraitConst::raycast_step_factor(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Kinfu_VolumeParams,
		cv_PtrLcv_kinfu_VolumeParamsG_new_null_const, cv_PtrLcv_kinfu_VolumeParamsG_delete, cv_PtrLcv_kinfu_VolumeParamsG_getInnerPtr_const, cv_PtrLcv_kinfu_VolumeParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::Kinfu_VolumeParams, cv_PtrLcv_kinfu_VolumeParamsG_new_const_VolumeParams }
	impl core::Ptr<crate::rgbd::Kinfu_VolumeParams> {
		#[inline] pub fn as_raw_PtrOfKinfu_VolumeParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfKinfu_VolumeParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::Kinfu_VolumeParamsTraitConst for core::Ptr<crate::rgbd::Kinfu_VolumeParams> {
		#[inline] fn as_raw_Kinfu_VolumeParams(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::Kinfu_VolumeParamsTrait for core::Ptr<crate::rgbd::Kinfu_VolumeParams> {
		#[inline] fn as_raw_mut_Kinfu_VolumeParams(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Kinfu_VolumeParams> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfKinfu_VolumeParams")
				.field("typ", &crate::rgbd::Kinfu_VolumeParamsTraitConst::typ(self))
				.field("resolution", &crate::rgbd::Kinfu_VolumeParamsTraitConst::resolution(self))
				.field("unit_resolution", &crate::rgbd::Kinfu_VolumeParamsTraitConst::unit_resolution(self))
				.field("pose", &crate::rgbd::Kinfu_VolumeParamsTraitConst::pose(self))
				.field("voxel_size", &crate::rgbd::Kinfu_VolumeParamsTraitConst::voxel_size(self))
				.field("tsdf_trunc_dist", &crate::rgbd::Kinfu_VolumeParamsTraitConst::tsdf_trunc_dist(self))
				.field("max_weight", &crate::rgbd::Kinfu_VolumeParamsTraitConst::max_weight(self))
				.field("depth_trunc_threshold", &crate::rgbd::Kinfu_VolumeParamsTraitConst::depth_trunc_threshold(self))
				.field("raycast_step_factor", &crate::rgbd::Kinfu_VolumeParamsTraitConst::raycast_step_factor(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::LargeKinfu,
		cv_PtrLcv_large_kinfu_LargeKinfuG_new_null_const, cv_PtrLcv_large_kinfu_LargeKinfuG_delete, cv_PtrLcv_large_kinfu_LargeKinfuG_getInnerPtr_const, cv_PtrLcv_large_kinfu_LargeKinfuG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::LargeKinfu> {
		#[inline] pub fn as_raw_PtrOfLargeKinfu(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLargeKinfu(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::LargeKinfuTraitConst for core::Ptr<crate::rgbd::LargeKinfu> {
		#[inline] fn as_raw_LargeKinfu(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LargeKinfuTrait for core::Ptr<crate::rgbd::LargeKinfu> {
		#[inline] fn as_raw_mut_LargeKinfu(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::LargeKinfu> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLargeKinfu")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::LineMod_ColorGradient,
		cv_PtrLcv_linemod_ColorGradientG_new_null_const, cv_PtrLcv_linemod_ColorGradientG_delete, cv_PtrLcv_linemod_ColorGradientG_getInnerPtr_const, cv_PtrLcv_linemod_ColorGradientG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::LineMod_ColorGradient, cv_PtrLcv_linemod_ColorGradientG_new_const_ColorGradient }
	impl core::Ptr<crate::rgbd::LineMod_ColorGradient> {
		#[inline] pub fn as_raw_PtrOfLineMod_ColorGradient(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLineMod_ColorGradient(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::LineMod_ColorGradientTraitConst for core::Ptr<crate::rgbd::LineMod_ColorGradient> {
		#[inline] fn as_raw_LineMod_ColorGradient(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LineMod_ColorGradientTrait for core::Ptr<crate::rgbd::LineMod_ColorGradient> {
		#[inline] fn as_raw_mut_LineMod_ColorGradient(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::rgbd::LineMod_ModalityTraitConst for core::Ptr<crate::rgbd::LineMod_ColorGradient> {
		#[inline] fn as_raw_LineMod_Modality(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LineMod_ModalityTrait for core::Ptr<crate::rgbd::LineMod_ColorGradient> {
		#[inline] fn as_raw_mut_LineMod_Modality(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::LineMod_ColorGradient>, core::Ptr<crate::rgbd::LineMod_Modality>, cv_PtrLcv_linemod_ColorGradientG_to_PtrOfLineMod_Modality }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::LineMod_ColorGradient> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLineMod_ColorGradient")
				.field("weak_threshold", &crate::rgbd::LineMod_ColorGradientTraitConst::weak_threshold(self))
				.field("num_features", &crate::rgbd::LineMod_ColorGradientTraitConst::num_features(self))
				.field("strong_threshold", &crate::rgbd::LineMod_ColorGradientTraitConst::strong_threshold(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::LineMod_DepthNormal,
		cv_PtrLcv_linemod_DepthNormalG_new_null_const, cv_PtrLcv_linemod_DepthNormalG_delete, cv_PtrLcv_linemod_DepthNormalG_getInnerPtr_const, cv_PtrLcv_linemod_DepthNormalG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::LineMod_DepthNormal, cv_PtrLcv_linemod_DepthNormalG_new_const_DepthNormal }
	impl core::Ptr<crate::rgbd::LineMod_DepthNormal> {
		#[inline] pub fn as_raw_PtrOfLineMod_DepthNormal(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLineMod_DepthNormal(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::LineMod_DepthNormalTraitConst for core::Ptr<crate::rgbd::LineMod_DepthNormal> {
		#[inline] fn as_raw_LineMod_DepthNormal(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LineMod_DepthNormalTrait for core::Ptr<crate::rgbd::LineMod_DepthNormal> {
		#[inline] fn as_raw_mut_LineMod_DepthNormal(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::rgbd::LineMod_ModalityTraitConst for core::Ptr<crate::rgbd::LineMod_DepthNormal> {
		#[inline] fn as_raw_LineMod_Modality(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LineMod_ModalityTrait for core::Ptr<crate::rgbd::LineMod_DepthNormal> {
		#[inline] fn as_raw_mut_LineMod_Modality(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::LineMod_DepthNormal>, core::Ptr<crate::rgbd::LineMod_Modality>, cv_PtrLcv_linemod_DepthNormalG_to_PtrOfLineMod_Modality }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::LineMod_DepthNormal> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLineMod_DepthNormal")
				.field("distance_threshold", &crate::rgbd::LineMod_DepthNormalTraitConst::distance_threshold(self))
				.field("difference_threshold", &crate::rgbd::LineMod_DepthNormalTraitConst::difference_threshold(self))
				.field("num_features", &crate::rgbd::LineMod_DepthNormalTraitConst::num_features(self))
				.field("extract_threshold", &crate::rgbd::LineMod_DepthNormalTraitConst::extract_threshold(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::LineMod_Detector,
		cv_PtrLcv_linemod_DetectorG_new_null_const, cv_PtrLcv_linemod_DetectorG_delete, cv_PtrLcv_linemod_DetectorG_getInnerPtr_const, cv_PtrLcv_linemod_DetectorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::LineMod_Detector, cv_PtrLcv_linemod_DetectorG_new_const_Detector }
	impl core::Ptr<crate::rgbd::LineMod_Detector> {
		#[inline] pub fn as_raw_PtrOfLineMod_Detector(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLineMod_Detector(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::LineMod_DetectorTraitConst for core::Ptr<crate::rgbd::LineMod_Detector> {
		#[inline] fn as_raw_LineMod_Detector(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LineMod_DetectorTrait for core::Ptr<crate::rgbd::LineMod_Detector> {
		#[inline] fn as_raw_mut_LineMod_Detector(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::LineMod_Detector> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLineMod_Detector")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::LineMod_Modality,
		cv_PtrLcv_linemod_ModalityG_new_null_const, cv_PtrLcv_linemod_ModalityG_delete, cv_PtrLcv_linemod_ModalityG_getInnerPtr_const, cv_PtrLcv_linemod_ModalityG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::LineMod_Modality> {
		#[inline] pub fn as_raw_PtrOfLineMod_Modality(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLineMod_Modality(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::LineMod_ModalityTraitConst for core::Ptr<crate::rgbd::LineMod_Modality> {
		#[inline] fn as_raw_LineMod_Modality(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LineMod_ModalityTrait for core::Ptr<crate::rgbd::LineMod_Modality> {
		#[inline] fn as_raw_mut_LineMod_Modality(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::LineMod_Modality> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLineMod_Modality")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::LineMod_QuantizedPyramid,
		cv_PtrLcv_linemod_QuantizedPyramidG_new_null_const, cv_PtrLcv_linemod_QuantizedPyramidG_delete, cv_PtrLcv_linemod_QuantizedPyramidG_getInnerPtr_const, cv_PtrLcv_linemod_QuantizedPyramidG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::LineMod_QuantizedPyramid> {
		#[inline] pub fn as_raw_PtrOfLineMod_QuantizedPyramid(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfLineMod_QuantizedPyramid(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::LineMod_QuantizedPyramidTraitConst for core::Ptr<crate::rgbd::LineMod_QuantizedPyramid> {
		#[inline] fn as_raw_LineMod_QuantizedPyramid(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::LineMod_QuantizedPyramidTrait for core::Ptr<crate::rgbd::LineMod_QuantizedPyramid> {
		#[inline] fn as_raw_mut_LineMod_QuantizedPyramid(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::LineMod_QuantizedPyramid> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfLineMod_QuantizedPyramid")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Odometry,
		cv_PtrLcv_rgbd_OdometryG_new_null_const, cv_PtrLcv_rgbd_OdometryG_delete, cv_PtrLcv_rgbd_OdometryG_getInnerPtr_const, cv_PtrLcv_rgbd_OdometryG_getInnerPtrMut
	}

	impl core::Ptr<crate::rgbd::Odometry> {
		#[inline] pub fn as_raw_PtrOfOdometry(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfOdometry(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::OdometryTraitConst for core::Ptr<crate::rgbd::Odometry> {
		#[inline] fn as_raw_Odometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::OdometryTrait for core::Ptr<crate::rgbd::Odometry> {
		#[inline] fn as_raw_mut_Odometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::Odometry> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::Odometry> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::Odometry>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_OdometryG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Odometry> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfOdometry")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::OdometryFrame,
		cv_PtrLcv_rgbd_OdometryFrameG_new_null_const, cv_PtrLcv_rgbd_OdometryFrameG_delete, cv_PtrLcv_rgbd_OdometryFrameG_getInnerPtr_const, cv_PtrLcv_rgbd_OdometryFrameG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::OdometryFrame, cv_PtrLcv_rgbd_OdometryFrameG_new_const_OdometryFrame }
	impl core::Ptr<crate::rgbd::OdometryFrame> {
		#[inline] pub fn as_raw_PtrOfOdometryFrame(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfOdometryFrame(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::OdometryFrameTraitConst for core::Ptr<crate::rgbd::OdometryFrame> {
		#[inline] fn as_raw_OdometryFrame(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::OdometryFrameTrait for core::Ptr<crate::rgbd::OdometryFrame> {
		#[inline] fn as_raw_mut_OdometryFrame(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::rgbd::RgbdFrameTraitConst for core::Ptr<crate::rgbd::OdometryFrame> {
		#[inline] fn as_raw_RgbdFrame(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::RgbdFrameTrait for core::Ptr<crate::rgbd::OdometryFrame> {
		#[inline] fn as_raw_mut_RgbdFrame(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::OdometryFrame>, core::Ptr<crate::rgbd::RgbdFrame>, cv_PtrLcv_rgbd_OdometryFrameG_to_PtrOfRgbdFrame }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::OdometryFrame> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfOdometryFrame")
				.field("pyramid_image", &crate::rgbd::OdometryFrameTraitConst::pyramid_image(self))
				.field("pyramid_depth", &crate::rgbd::OdometryFrameTraitConst::pyramid_depth(self))
				.field("pyramid_mask", &crate::rgbd::OdometryFrameTraitConst::pyramid_mask(self))
				.field("pyramid_cloud", &crate::rgbd::OdometryFrameTraitConst::pyramid_cloud(self))
				.field("pyramid_d_i_dx", &crate::rgbd::OdometryFrameTraitConst::pyramid_d_i_dx(self))
				.field("pyramid_d_i_dy", &crate::rgbd::OdometryFrameTraitConst::pyramid_d_i_dy(self))
				.field("pyramid_textured_mask", &crate::rgbd::OdometryFrameTraitConst::pyramid_textured_mask(self))
				.field("pyramid_normals", &crate::rgbd::OdometryFrameTraitConst::pyramid_normals(self))
				.field("pyramid_normals_mask", &crate::rgbd::OdometryFrameTraitConst::pyramid_normals_mask(self))
				.field("id", &crate::rgbd::RgbdFrameTraitConst::id(self))
				.field("image", &crate::rgbd::RgbdFrameTraitConst::image(self))
				.field("depth", &crate::rgbd::RgbdFrameTraitConst::depth(self))
				.field("mask", &crate::rgbd::RgbdFrameTraitConst::mask(self))
				.field("normals", &crate::rgbd::RgbdFrameTraitConst::normals(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::Params,
		cv_PtrLcv_large_kinfu_ParamsG_new_null_const, cv_PtrLcv_large_kinfu_ParamsG_delete, cv_PtrLcv_large_kinfu_ParamsG_getInnerPtr_const, cv_PtrLcv_large_kinfu_ParamsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::Params, cv_PtrLcv_large_kinfu_ParamsG_new_const_Params }
	impl core::Ptr<crate::rgbd::Params> {
		#[inline] pub fn as_raw_PtrOfParams(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfParams(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::ParamsTraitConst for core::Ptr<crate::rgbd::Params> {
		#[inline] fn as_raw_Params(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::ParamsTrait for core::Ptr<crate::rgbd::Params> {
		#[inline] fn as_raw_mut_Params(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::Params> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfParams")
				.field("frame_size", &crate::rgbd::ParamsTraitConst::frame_size(self))
				.field("intr", &crate::rgbd::ParamsTraitConst::intr(self))
				.field("rgb_intr", &crate::rgbd::ParamsTraitConst::rgb_intr(self))
				.field("depth_factor", &crate::rgbd::ParamsTraitConst::depth_factor(self))
				.field("bilateral_sigma_depth", &crate::rgbd::ParamsTraitConst::bilateral_sigma_depth(self))
				.field("bilateral_sigma_spatial", &crate::rgbd::ParamsTraitConst::bilateral_sigma_spatial(self))
				.field("bilateral_kernel_size", &crate::rgbd::ParamsTraitConst::bilateral_kernel_size(self))
				.field("pyramid_levels", &crate::rgbd::ParamsTraitConst::pyramid_levels(self))
				.field("tsdf_min_camera_movement", &crate::rgbd::ParamsTraitConst::tsdf_min_camera_movement(self))
				.field("light_pose", &crate::rgbd::ParamsTraitConst::light_pose(self))
				.field("icp_dist_thresh", &crate::rgbd::ParamsTraitConst::icp_dist_thresh(self))
				.field("icp_angle_thresh", &crate::rgbd::ParamsTraitConst::icp_angle_thresh(self))
				.field("icp_iterations", &crate::rgbd::ParamsTraitConst::icp_iterations(self))
				.field("truncate_threshold", &crate::rgbd::ParamsTraitConst::truncate_threshold(self))
				.field("volume_params", &crate::rgbd::ParamsTraitConst::volume_params(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::RgbdFrame,
		cv_PtrLcv_rgbd_RgbdFrameG_new_null_const, cv_PtrLcv_rgbd_RgbdFrameG_delete, cv_PtrLcv_rgbd_RgbdFrameG_getInnerPtr_const, cv_PtrLcv_rgbd_RgbdFrameG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::RgbdFrame, cv_PtrLcv_rgbd_RgbdFrameG_new_const_RgbdFrame }
	impl core::Ptr<crate::rgbd::RgbdFrame> {
		#[inline] pub fn as_raw_PtrOfRgbdFrame(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRgbdFrame(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::RgbdFrameTraitConst for core::Ptr<crate::rgbd::RgbdFrame> {
		#[inline] fn as_raw_RgbdFrame(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::RgbdFrameTrait for core::Ptr<crate::rgbd::RgbdFrame> {
		#[inline] fn as_raw_mut_RgbdFrame(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::rgbd::RgbdFrame> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRgbdFrame")
				.field("id", &crate::rgbd::RgbdFrameTraitConst::id(self))
				.field("image", &crate::rgbd::RgbdFrameTraitConst::image(self))
				.field("depth", &crate::rgbd::RgbdFrameTraitConst::depth(self))
				.field("mask", &crate::rgbd::RgbdFrameTraitConst::mask(self))
				.field("normals", &crate::rgbd::RgbdFrameTraitConst::normals(self))
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::RgbdICPOdometry,
		cv_PtrLcv_rgbd_RgbdICPOdometryG_new_null_const, cv_PtrLcv_rgbd_RgbdICPOdometryG_delete, cv_PtrLcv_rgbd_RgbdICPOdometryG_getInnerPtr_const, cv_PtrLcv_rgbd_RgbdICPOdometryG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::RgbdICPOdometry, cv_PtrLcv_rgbd_RgbdICPOdometryG_new_const_RgbdICPOdometry }
	impl core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline] pub fn as_raw_PtrOfRgbdICPOdometry(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRgbdICPOdometry(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::RgbdICPOdometryTraitConst for core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline] fn as_raw_RgbdICPOdometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::RgbdICPOdometryTrait for core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline] fn as_raw_mut_RgbdICPOdometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::RgbdICPOdometry>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_RgbdICPOdometryG_to_PtrOfAlgorithm }

	impl crate::rgbd::OdometryTraitConst for core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline] fn as_raw_Odometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::OdometryTrait for core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline] fn as_raw_mut_Odometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::RgbdICPOdometry>, core::Ptr<crate::rgbd::Odometry>, cv_PtrLcv_rgbd_RgbdICPOdometryG_to_PtrOfOdometry }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::RgbdICPOdometry> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRgbdICPOdometry")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::RgbdNormals,
		cv_PtrLcv_rgbd_RgbdNormalsG_new_null_const, cv_PtrLcv_rgbd_RgbdNormalsG_delete, cv_PtrLcv_rgbd_RgbdNormalsG_getInnerPtr_const, cv_PtrLcv_rgbd_RgbdNormalsG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::RgbdNormals, cv_PtrLcv_rgbd_RgbdNormalsG_new_const_RgbdNormals }
	impl core::Ptr<crate::rgbd::RgbdNormals> {
		#[inline] pub fn as_raw_PtrOfRgbdNormals(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRgbdNormals(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::RgbdNormalsTraitConst for core::Ptr<crate::rgbd::RgbdNormals> {
		#[inline] fn as_raw_RgbdNormals(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::RgbdNormalsTrait for core::Ptr<crate::rgbd::RgbdNormals> {
		#[inline] fn as_raw_mut_RgbdNormals(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::RgbdNormals> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::RgbdNormals> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::RgbdNormals>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_RgbdNormalsG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::RgbdNormals> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRgbdNormals")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::RgbdOdometry,
		cv_PtrLcv_rgbd_RgbdOdometryG_new_null_const, cv_PtrLcv_rgbd_RgbdOdometryG_delete, cv_PtrLcv_rgbd_RgbdOdometryG_getInnerPtr_const, cv_PtrLcv_rgbd_RgbdOdometryG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::RgbdOdometry, cv_PtrLcv_rgbd_RgbdOdometryG_new_const_RgbdOdometry }
	impl core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline] pub fn as_raw_PtrOfRgbdOdometry(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRgbdOdometry(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::RgbdOdometryTraitConst for core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline] fn as_raw_RgbdOdometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::RgbdOdometryTrait for core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline] fn as_raw_mut_RgbdOdometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::RgbdOdometry>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_RgbdOdometryG_to_PtrOfAlgorithm }

	impl crate::rgbd::OdometryTraitConst for core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline] fn as_raw_Odometry(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::OdometryTrait for core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline] fn as_raw_mut_Odometry(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::RgbdOdometry>, core::Ptr<crate::rgbd::Odometry>, cv_PtrLcv_rgbd_RgbdOdometryG_to_PtrOfOdometry }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::RgbdOdometry> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRgbdOdometry")
				.finish()
		}
	}

	ptr_extern! { crate::rgbd::RgbdPlane,
		cv_PtrLcv_rgbd_RgbdPlaneG_new_null_const, cv_PtrLcv_rgbd_RgbdPlaneG_delete, cv_PtrLcv_rgbd_RgbdPlaneG_getInnerPtr_const, cv_PtrLcv_rgbd_RgbdPlaneG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::rgbd::RgbdPlane, cv_PtrLcv_rgbd_RgbdPlaneG_new_const_RgbdPlane }
	impl core::Ptr<crate::rgbd::RgbdPlane> {
		#[inline] pub fn as_raw_PtrOfRgbdPlane(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfRgbdPlane(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::rgbd::RgbdPlaneTraitConst for core::Ptr<crate::rgbd::RgbdPlane> {
		#[inline] fn as_raw_RgbdPlane(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::rgbd::RgbdPlaneTrait for core::Ptr<crate::rgbd::RgbdPlane> {
		#[inline] fn as_raw_mut_RgbdPlane(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::rgbd::RgbdPlane> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::rgbd::RgbdPlane> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::rgbd::RgbdPlane>, core::Ptr<core::Algorithm>, cv_PtrLcv_rgbd_RgbdPlaneG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::rgbd::RgbdPlane> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfRgbdPlane")
				.finish()
		}
	}

	impl core::Vector<crate::rgbd::LineMod_Feature> {
		pub fn as_raw_VectorOfLineMod_Feature(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfLineMod_Feature(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::rgbd::LineMod_Feature,
		std_vectorLcv_linemod_FeatureG_new_const, std_vectorLcv_linemod_FeatureG_delete,
		std_vectorLcv_linemod_FeatureG_len_const, std_vectorLcv_linemod_FeatureG_isEmpty_const,
		std_vectorLcv_linemod_FeatureG_capacity_const, std_vectorLcv_linemod_FeatureG_shrinkToFit,
		std_vectorLcv_linemod_FeatureG_reserve_size_t, std_vectorLcv_linemod_FeatureG_remove_size_t,
		std_vectorLcv_linemod_FeatureG_swap_size_t_size_t, std_vectorLcv_linemod_FeatureG_clear,
		std_vectorLcv_linemod_FeatureG_get_const_size_t, std_vectorLcv_linemod_FeatureG_set_size_t_const_Feature,
		std_vectorLcv_linemod_FeatureG_push_const_Feature, std_vectorLcv_linemod_FeatureG_insert_size_t_const_Feature,
	}

	vector_copy_non_bool! { crate::rgbd::LineMod_Feature,
		std_vectorLcv_linemod_FeatureG_data_const, std_vectorLcv_linemod_FeatureG_dataMut, cv_fromSlice_const_const_FeatureX_size_t,
		std_vectorLcv_linemod_FeatureG_clone_const,
	}


	impl core::Vector<crate::rgbd::LineMod_Match> {
		pub fn as_raw_VectorOfLineMod_Match(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfLineMod_Match(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::rgbd::LineMod_Match,
		std_vectorLcv_linemod_MatchG_new_const, std_vectorLcv_linemod_MatchG_delete,
		std_vectorLcv_linemod_MatchG_len_const, std_vectorLcv_linemod_MatchG_isEmpty_const,
		std_vectorLcv_linemod_MatchG_capacity_const, std_vectorLcv_linemod_MatchG_shrinkToFit,
		std_vectorLcv_linemod_MatchG_reserve_size_t, std_vectorLcv_linemod_MatchG_remove_size_t,
		std_vectorLcv_linemod_MatchG_swap_size_t_size_t, std_vectorLcv_linemod_MatchG_clear,
		std_vectorLcv_linemod_MatchG_get_const_size_t, std_vectorLcv_linemod_MatchG_set_size_t_const_Match,
		std_vectorLcv_linemod_MatchG_push_const_Match, std_vectorLcv_linemod_MatchG_insert_size_t_const_Match,
	}

	vector_non_copy_or_bool! { clone crate::rgbd::LineMod_Match }

	vector_boxed_ref! { crate::rgbd::LineMod_Match }

	vector_extern! { BoxedRef<'t, crate::rgbd::LineMod_Match>,
		std_vectorLcv_linemod_MatchG_new_const, std_vectorLcv_linemod_MatchG_delete,
		std_vectorLcv_linemod_MatchG_len_const, std_vectorLcv_linemod_MatchG_isEmpty_const,
		std_vectorLcv_linemod_MatchG_capacity_const, std_vectorLcv_linemod_MatchG_shrinkToFit,
		std_vectorLcv_linemod_MatchG_reserve_size_t, std_vectorLcv_linemod_MatchG_remove_size_t,
		std_vectorLcv_linemod_MatchG_swap_size_t_size_t, std_vectorLcv_linemod_MatchG_clear,
		std_vectorLcv_linemod_MatchG_get_const_size_t, std_vectorLcv_linemod_MatchG_set_size_t_const_Match,
		std_vectorLcv_linemod_MatchG_push_const_Match, std_vectorLcv_linemod_MatchG_insert_size_t_const_Match,
	}


	impl core::Vector<crate::rgbd::LineMod_Template> {
		pub fn as_raw_VectorOfLineMod_Template(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfLineMod_Template(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::rgbd::LineMod_Template,
		std_vectorLcv_linemod_TemplateG_new_const, std_vectorLcv_linemod_TemplateG_delete,
		std_vectorLcv_linemod_TemplateG_len_const, std_vectorLcv_linemod_TemplateG_isEmpty_const,
		std_vectorLcv_linemod_TemplateG_capacity_const, std_vectorLcv_linemod_TemplateG_shrinkToFit,
		std_vectorLcv_linemod_TemplateG_reserve_size_t, std_vectorLcv_linemod_TemplateG_remove_size_t,
		std_vectorLcv_linemod_TemplateG_swap_size_t_size_t, std_vectorLcv_linemod_TemplateG_clear,
		std_vectorLcv_linemod_TemplateG_get_const_size_t, std_vectorLcv_linemod_TemplateG_set_size_t_const_Template,
		std_vectorLcv_linemod_TemplateG_push_const_Template, std_vectorLcv_linemod_TemplateG_insert_size_t_const_Template,
	}

	vector_non_copy_or_bool! { clone crate::rgbd::LineMod_Template }

	vector_boxed_ref! { crate::rgbd::LineMod_Template }

	vector_extern! { BoxedRef<'t, crate::rgbd::LineMod_Template>,
		std_vectorLcv_linemod_TemplateG_new_const, std_vectorLcv_linemod_TemplateG_delete,
		std_vectorLcv_linemod_TemplateG_len_const, std_vectorLcv_linemod_TemplateG_isEmpty_const,
		std_vectorLcv_linemod_TemplateG_capacity_const, std_vectorLcv_linemod_TemplateG_shrinkToFit,
		std_vectorLcv_linemod_TemplateG_reserve_size_t, std_vectorLcv_linemod_TemplateG_remove_size_t,
		std_vectorLcv_linemod_TemplateG_swap_size_t_size_t, std_vectorLcv_linemod_TemplateG_clear,
		std_vectorLcv_linemod_TemplateG_get_const_size_t, std_vectorLcv_linemod_TemplateG_set_size_t_const_Template,
		std_vectorLcv_linemod_TemplateG_push_const_Template, std_vectorLcv_linemod_TemplateG_insert_size_t_const_Template,
	}


	impl core::Vector<core::Ptr<crate::rgbd::LineMod_Modality>> {
		pub fn as_raw_VectorOfPtrOfLineMod_Modality(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfPtrOfLineMod_Modality(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { core::Ptr<crate::rgbd::LineMod_Modality>,
		std_vectorLcv_PtrLcv_linemod_ModalityGG_new_const, std_vectorLcv_PtrLcv_linemod_ModalityGG_delete,
		std_vectorLcv_PtrLcv_linemod_ModalityGG_len_const, std_vectorLcv_PtrLcv_linemod_ModalityGG_isEmpty_const,
		std_vectorLcv_PtrLcv_linemod_ModalityGG_capacity_const, std_vectorLcv_PtrLcv_linemod_ModalityGG_shrinkToFit,
		std_vectorLcv_PtrLcv_linemod_ModalityGG_reserve_size_t, std_vectorLcv_PtrLcv_linemod_ModalityGG_remove_size_t,
		std_vectorLcv_PtrLcv_linemod_ModalityGG_swap_size_t_size_t, std_vectorLcv_PtrLcv_linemod_ModalityGG_clear,
		std_vectorLcv_PtrLcv_linemod_ModalityGG_get_const_size_t, std_vectorLcv_PtrLcv_linemod_ModalityGG_set_size_t_const_PtrLModalityG,
		std_vectorLcv_PtrLcv_linemod_ModalityGG_push_const_PtrLModalityG, std_vectorLcv_PtrLcv_linemod_ModalityGG_insert_size_t_const_PtrLModalityG,
	}

	vector_non_copy_or_bool! { core::Ptr<crate::rgbd::LineMod_Modality> }


}
pub use rgbd_types::*;

mod saliency_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::saliency::MotionSaliency,
		cv_PtrLcv_saliency_MotionSaliencyG_new_null_const, cv_PtrLcv_saliency_MotionSaliencyG_delete, cv_PtrLcv_saliency_MotionSaliencyG_getInnerPtr_const, cv_PtrLcv_saliency_MotionSaliencyG_getInnerPtrMut
	}

	impl core::Ptr<crate::saliency::MotionSaliency> {
		#[inline] pub fn as_raw_PtrOfMotionSaliency(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMotionSaliency(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::MotionSaliencyTraitConst for core::Ptr<crate::saliency::MotionSaliency> {
		#[inline] fn as_raw_MotionSaliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::MotionSaliencyTrait for core::Ptr<crate::saliency::MotionSaliency> {
		#[inline] fn as_raw_mut_MotionSaliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::MotionSaliency> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::MotionSaliency> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::MotionSaliency>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_MotionSaliencyG_to_PtrOfAlgorithm }

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::MotionSaliency> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::MotionSaliency> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::MotionSaliency>, core::Ptr<crate::saliency::Saliency>, cv_PtrLcv_saliency_MotionSaliencyG_to_PtrOfSaliency }

	impl std::fmt::Debug for core::Ptr<crate::saliency::MotionSaliency> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMotionSaliency")
				.finish()
		}
	}

	ptr_extern! { crate::saliency::MotionSaliencyBinWangApr2014,
		cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_new_null_const, cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_delete, cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_getInnerPtr_const, cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::saliency::MotionSaliencyBinWangApr2014, cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_new_const_MotionSaliencyBinWangApr2014 }
	impl core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] pub fn as_raw_PtrOfMotionSaliencyBinWangApr2014(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfMotionSaliencyBinWangApr2014(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::MotionSaliencyBinWangApr2014TraitConst for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_MotionSaliencyBinWangApr2014(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::MotionSaliencyBinWangApr2014Trait for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_mut_MotionSaliencyBinWangApr2014(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_to_PtrOfAlgorithm }

	impl crate::saliency::MotionSaliencyTraitConst for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_MotionSaliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::MotionSaliencyTrait for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_mut_MotionSaliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014>, core::Ptr<crate::saliency::MotionSaliency>, cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_to_PtrOfMotionSaliency }

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014>, core::Ptr<crate::saliency::Saliency>, cv_PtrLcv_saliency_MotionSaliencyBinWangApr2014G_to_PtrOfSaliency }

	impl std::fmt::Debug for core::Ptr<crate::saliency::MotionSaliencyBinWangApr2014> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfMotionSaliencyBinWangApr2014")
				.finish()
		}
	}

	ptr_extern! { crate::saliency::Objectness,
		cv_PtrLcv_saliency_ObjectnessG_new_null_const, cv_PtrLcv_saliency_ObjectnessG_delete, cv_PtrLcv_saliency_ObjectnessG_getInnerPtr_const, cv_PtrLcv_saliency_ObjectnessG_getInnerPtrMut
	}

	impl core::Ptr<crate::saliency::Objectness> {
		#[inline] pub fn as_raw_PtrOfObjectness(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfObjectness(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::ObjectnessTraitConst for core::Ptr<crate::saliency::Objectness> {
		#[inline] fn as_raw_Objectness(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::ObjectnessTrait for core::Ptr<crate::saliency::Objectness> {
		#[inline] fn as_raw_mut_Objectness(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::Objectness> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::Objectness> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::Objectness>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_ObjectnessG_to_PtrOfAlgorithm }

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::Objectness> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::Objectness> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::Objectness>, core::Ptr<crate::saliency::Saliency>, cv_PtrLcv_saliency_ObjectnessG_to_PtrOfSaliency }

	impl std::fmt::Debug for core::Ptr<crate::saliency::Objectness> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfObjectness")
				.finish()
		}
	}

	ptr_extern! { crate::saliency::ObjectnessBING,
		cv_PtrLcv_saliency_ObjectnessBINGG_new_null_const, cv_PtrLcv_saliency_ObjectnessBINGG_delete, cv_PtrLcv_saliency_ObjectnessBINGG_getInnerPtr_const, cv_PtrLcv_saliency_ObjectnessBINGG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::saliency::ObjectnessBING, cv_PtrLcv_saliency_ObjectnessBINGG_new_const_ObjectnessBING }
	impl core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] pub fn as_raw_PtrOfObjectnessBING(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfObjectnessBING(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::ObjectnessBINGTraitConst for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_ObjectnessBING(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::ObjectnessBINGTrait for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_mut_ObjectnessBING(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::ObjectnessBING>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_ObjectnessBINGG_to_PtrOfAlgorithm }

	impl crate::saliency::ObjectnessTraitConst for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_Objectness(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::ObjectnessTrait for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_mut_Objectness(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::ObjectnessBING>, core::Ptr<crate::saliency::Objectness>, cv_PtrLcv_saliency_ObjectnessBINGG_to_PtrOfObjectness }

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::ObjectnessBING>, core::Ptr<crate::saliency::Saliency>, cv_PtrLcv_saliency_ObjectnessBINGG_to_PtrOfSaliency }

	impl std::fmt::Debug for core::Ptr<crate::saliency::ObjectnessBING> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfObjectnessBING")
				.finish()
		}
	}

	ptr_extern! { crate::saliency::Saliency,
		cv_PtrLcv_saliency_SaliencyG_new_null_const, cv_PtrLcv_saliency_SaliencyG_delete, cv_PtrLcv_saliency_SaliencyG_getInnerPtr_const, cv_PtrLcv_saliency_SaliencyG_getInnerPtrMut
	}

	impl core::Ptr<crate::saliency::Saliency> {
		#[inline] pub fn as_raw_PtrOfSaliency(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSaliency(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::Saliency> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::Saliency> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::Saliency> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::Saliency> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::Saliency>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_SaliencyG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::saliency::Saliency> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSaliency")
				.finish()
		}
	}

	ptr_extern! { crate::saliency::StaticSaliency,
		cv_PtrLcv_saliency_StaticSaliencyG_new_null_const, cv_PtrLcv_saliency_StaticSaliencyG_delete, cv_PtrLcv_saliency_StaticSaliencyG_getInnerPtr_const, cv_PtrLcv_saliency_StaticSaliencyG_getInnerPtrMut
	}

	impl core::Ptr<crate::saliency::StaticSaliency> {
		#[inline] pub fn as_raw_PtrOfStaticSaliency(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStaticSaliency(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::StaticSaliencyTraitConst for core::Ptr<crate::saliency::StaticSaliency> {
		#[inline] fn as_raw_StaticSaliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::StaticSaliencyTrait for core::Ptr<crate::saliency::StaticSaliency> {
		#[inline] fn as_raw_mut_StaticSaliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::StaticSaliency> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::StaticSaliency> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliency>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_StaticSaliencyG_to_PtrOfAlgorithm }

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::StaticSaliency> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::StaticSaliency> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliency>, core::Ptr<crate::saliency::Saliency>, cv_PtrLcv_saliency_StaticSaliencyG_to_PtrOfSaliency }

	impl std::fmt::Debug for core::Ptr<crate::saliency::StaticSaliency> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStaticSaliency")
				.finish()
		}
	}

	ptr_extern! { crate::saliency::StaticSaliencyFineGrained,
		cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_new_null_const, cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_delete, cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_getInnerPtr_const, cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::saliency::StaticSaliencyFineGrained, cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_new_const_StaticSaliencyFineGrained }
	impl core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] pub fn as_raw_PtrOfStaticSaliencyFineGrained(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStaticSaliencyFineGrained(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::StaticSaliencyFineGrainedTraitConst for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_StaticSaliencyFineGrained(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::StaticSaliencyFineGrainedTrait for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_mut_StaticSaliencyFineGrained(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliencyFineGrained>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_to_PtrOfAlgorithm }

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliencyFineGrained>, core::Ptr<crate::saliency::Saliency>, cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_to_PtrOfSaliency }

	impl crate::saliency::StaticSaliencyTraitConst for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_StaticSaliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::StaticSaliencyTrait for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline] fn as_raw_mut_StaticSaliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliencyFineGrained>, core::Ptr<crate::saliency::StaticSaliency>, cv_PtrLcv_saliency_StaticSaliencyFineGrainedG_to_PtrOfStaticSaliency }

	impl std::fmt::Debug for core::Ptr<crate::saliency::StaticSaliencyFineGrained> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStaticSaliencyFineGrained")
				.finish()
		}
	}

	ptr_extern! { crate::saliency::StaticSaliencySpectralResidual,
		cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_new_null_const, cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_delete, cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_getInnerPtr_const, cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::saliency::StaticSaliencySpectralResidual, cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_new_const_StaticSaliencySpectralResidual }
	impl core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] pub fn as_raw_PtrOfStaticSaliencySpectralResidual(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfStaticSaliencySpectralResidual(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::saliency::StaticSaliencySpectralResidualTraitConst for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_StaticSaliencySpectralResidual(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::StaticSaliencySpectralResidualTrait for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_mut_StaticSaliencySpectralResidual(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliencySpectralResidual>, core::Ptr<core::Algorithm>, cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_to_PtrOfAlgorithm }

	impl crate::saliency::SaliencyTraitConst for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_Saliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::SaliencyTrait for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_mut_Saliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliencySpectralResidual>, core::Ptr<crate::saliency::Saliency>, cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_to_PtrOfSaliency }

	impl crate::saliency::StaticSaliencyTraitConst for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_StaticSaliency(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::saliency::StaticSaliencyTrait for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline] fn as_raw_mut_StaticSaliency(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::saliency::StaticSaliencySpectralResidual>, core::Ptr<crate::saliency::StaticSaliency>, cv_PtrLcv_saliency_StaticSaliencySpectralResidualG_to_PtrOfStaticSaliency }

	impl std::fmt::Debug for core::Ptr<crate::saliency::StaticSaliencySpectralResidual> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfStaticSaliencySpectralResidual")
				.finish()
		}
	}

}
pub use saliency_types::*;

mod sfm_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::sfm::BaseSFM,
		cv_PtrLcv_sfm_BaseSFMG_new_null_const, cv_PtrLcv_sfm_BaseSFMG_delete, cv_PtrLcv_sfm_BaseSFMG_getInnerPtr_const, cv_PtrLcv_sfm_BaseSFMG_getInnerPtrMut
	}

	impl core::Ptr<crate::sfm::BaseSFM> {
		#[inline] pub fn as_raw_PtrOfBaseSFM(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfBaseSFM(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::sfm::BaseSFMTraitConst for core::Ptr<crate::sfm::BaseSFM> {
		#[inline] fn as_raw_BaseSFM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::sfm::BaseSFMTrait for core::Ptr<crate::sfm::BaseSFM> {
		#[inline] fn as_raw_mut_BaseSFM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::sfm::BaseSFM> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfBaseSFM")
				.finish()
		}
	}

	ptr_extern! { crate::sfm::SFMLibmvEuclideanReconstruction,
		cv_PtrLcv_sfm_SFMLibmvEuclideanReconstructionG_new_null_const, cv_PtrLcv_sfm_SFMLibmvEuclideanReconstructionG_delete, cv_PtrLcv_sfm_SFMLibmvEuclideanReconstructionG_getInnerPtr_const, cv_PtrLcv_sfm_SFMLibmvEuclideanReconstructionG_getInnerPtrMut
	}

	impl core::Ptr<crate::sfm::SFMLibmvEuclideanReconstruction> {
		#[inline] pub fn as_raw_PtrOfSFMLibmvEuclideanReconstruction(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfSFMLibmvEuclideanReconstruction(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::sfm::SFMLibmvEuclideanReconstructionTraitConst for core::Ptr<crate::sfm::SFMLibmvEuclideanReconstruction> {
		#[inline] fn as_raw_SFMLibmvEuclideanReconstruction(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::sfm::SFMLibmvEuclideanReconstructionTrait for core::Ptr<crate::sfm::SFMLibmvEuclideanReconstruction> {
		#[inline] fn as_raw_mut_SFMLibmvEuclideanReconstruction(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::sfm::BaseSFMTraitConst for core::Ptr<crate::sfm::SFMLibmvEuclideanReconstruction> {
		#[inline] fn as_raw_BaseSFM(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::sfm::BaseSFMTrait for core::Ptr<crate::sfm::SFMLibmvEuclideanReconstruction> {
		#[inline] fn as_raw_mut_BaseSFM(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::sfm::SFMLibmvEuclideanReconstruction>, core::Ptr<crate::sfm::BaseSFM>, cv_PtrLcv_sfm_SFMLibmvEuclideanReconstructionG_to_PtrOfBaseSFM }

	impl std::fmt::Debug for core::Ptr<crate::sfm::SFMLibmvEuclideanReconstruction> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfSFMLibmvEuclideanReconstruction")
				.finish()
		}
	}

}
pub use sfm_types::*;

mod shape_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::shape::AffineTransformer,
		cv_PtrLcv_AffineTransformerG_new_null_const, cv_PtrLcv_AffineTransformerG_delete, cv_PtrLcv_AffineTransformerG_getInnerPtr_const, cv_PtrLcv_AffineTransformerG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::AffineTransformer> {
		#[inline] pub fn as_raw_PtrOfAffineTransformer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAffineTransformer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::AffineTransformerTraitConst for core::Ptr<crate::shape::AffineTransformer> {
		#[inline] fn as_raw_AffineTransformer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::AffineTransformerTrait for core::Ptr<crate::shape::AffineTransformer> {
		#[inline] fn as_raw_mut_AffineTransformer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::AffineTransformer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::AffineTransformer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::AffineTransformer>, core::Ptr<core::Algorithm>, cv_PtrLcv_AffineTransformerG_to_PtrOfAlgorithm }

	impl crate::shape::ShapeTransformerTraitConst for core::Ptr<crate::shape::AffineTransformer> {
		#[inline] fn as_raw_ShapeTransformer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ShapeTransformerTrait for core::Ptr<crate::shape::AffineTransformer> {
		#[inline] fn as_raw_mut_ShapeTransformer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::AffineTransformer>, core::Ptr<crate::shape::ShapeTransformer>, cv_PtrLcv_AffineTransformerG_to_PtrOfShapeTransformer }

	impl std::fmt::Debug for core::Ptr<crate::shape::AffineTransformer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAffineTransformer")
				.finish()
		}
	}

	ptr_extern! { crate::shape::ChiHistogramCostExtractor,
		cv_PtrLcv_ChiHistogramCostExtractorG_new_null_const, cv_PtrLcv_ChiHistogramCostExtractorG_delete, cv_PtrLcv_ChiHistogramCostExtractorG_getInnerPtr_const, cv_PtrLcv_ChiHistogramCostExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline] pub fn as_raw_PtrOfChiHistogramCostExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfChiHistogramCostExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::ChiHistogramCostExtractorTraitConst for core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline] fn as_raw_ChiHistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ChiHistogramCostExtractorTrait for core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline] fn as_raw_mut_ChiHistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ChiHistogramCostExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_ChiHistogramCostExtractorG_to_PtrOfAlgorithm }

	impl crate::shape::HistogramCostExtractorTraitConst for core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline] fn as_raw_HistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::HistogramCostExtractorTrait for core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline] fn as_raw_mut_HistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ChiHistogramCostExtractor>, core::Ptr<crate::shape::HistogramCostExtractor>, cv_PtrLcv_ChiHistogramCostExtractorG_to_PtrOfHistogramCostExtractor }

	impl std::fmt::Debug for core::Ptr<crate::shape::ChiHistogramCostExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfChiHistogramCostExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::EMDHistogramCostExtractor,
		cv_PtrLcv_EMDHistogramCostExtractorG_new_null_const, cv_PtrLcv_EMDHistogramCostExtractorG_delete, cv_PtrLcv_EMDHistogramCostExtractorG_getInnerPtr_const, cv_PtrLcv_EMDHistogramCostExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline] pub fn as_raw_PtrOfEMDHistogramCostExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEMDHistogramCostExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::EMDHistogramCostExtractorTraitConst for core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline] fn as_raw_EMDHistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::EMDHistogramCostExtractorTrait for core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline] fn as_raw_mut_EMDHistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::EMDHistogramCostExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_EMDHistogramCostExtractorG_to_PtrOfAlgorithm }

	impl crate::shape::HistogramCostExtractorTraitConst for core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline] fn as_raw_HistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::HistogramCostExtractorTrait for core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline] fn as_raw_mut_HistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::EMDHistogramCostExtractor>, core::Ptr<crate::shape::HistogramCostExtractor>, cv_PtrLcv_EMDHistogramCostExtractorG_to_PtrOfHistogramCostExtractor }

	impl std::fmt::Debug for core::Ptr<crate::shape::EMDHistogramCostExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEMDHistogramCostExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::EMDL1HistogramCostExtractor,
		cv_PtrLcv_EMDL1HistogramCostExtractorG_new_null_const, cv_PtrLcv_EMDL1HistogramCostExtractorG_delete, cv_PtrLcv_EMDL1HistogramCostExtractorG_getInnerPtr_const, cv_PtrLcv_EMDL1HistogramCostExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline] pub fn as_raw_PtrOfEMDL1HistogramCostExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfEMDL1HistogramCostExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::EMDL1HistogramCostExtractorTraitConst for core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline] fn as_raw_EMDL1HistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::EMDL1HistogramCostExtractorTrait for core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline] fn as_raw_mut_EMDL1HistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::EMDL1HistogramCostExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_EMDL1HistogramCostExtractorG_to_PtrOfAlgorithm }

	impl crate::shape::HistogramCostExtractorTraitConst for core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline] fn as_raw_HistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::HistogramCostExtractorTrait for core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline] fn as_raw_mut_HistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::EMDL1HistogramCostExtractor>, core::Ptr<crate::shape::HistogramCostExtractor>, cv_PtrLcv_EMDL1HistogramCostExtractorG_to_PtrOfHistogramCostExtractor }

	impl std::fmt::Debug for core::Ptr<crate::shape::EMDL1HistogramCostExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfEMDL1HistogramCostExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::HausdorffDistanceExtractor,
		cv_PtrLcv_HausdorffDistanceExtractorG_new_null_const, cv_PtrLcv_HausdorffDistanceExtractorG_delete, cv_PtrLcv_HausdorffDistanceExtractorG_getInnerPtr_const, cv_PtrLcv_HausdorffDistanceExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline] pub fn as_raw_PtrOfHausdorffDistanceExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHausdorffDistanceExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::HausdorffDistanceExtractorTraitConst for core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline] fn as_raw_HausdorffDistanceExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::HausdorffDistanceExtractorTrait for core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline] fn as_raw_mut_HausdorffDistanceExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::HausdorffDistanceExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_HausdorffDistanceExtractorG_to_PtrOfAlgorithm }

	impl crate::shape::ShapeDistanceExtractorTraitConst for core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline] fn as_raw_ShapeDistanceExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ShapeDistanceExtractorTrait for core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline] fn as_raw_mut_ShapeDistanceExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::HausdorffDistanceExtractor>, core::Ptr<crate::shape::ShapeDistanceExtractor>, cv_PtrLcv_HausdorffDistanceExtractorG_to_PtrOfShapeDistanceExtractor }

	impl std::fmt::Debug for core::Ptr<crate::shape::HausdorffDistanceExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHausdorffDistanceExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::HistogramCostExtractor,
		cv_PtrLcv_HistogramCostExtractorG_new_null_const, cv_PtrLcv_HistogramCostExtractorG_delete, cv_PtrLcv_HistogramCostExtractorG_getInnerPtr_const, cv_PtrLcv_HistogramCostExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::HistogramCostExtractor> {
		#[inline] pub fn as_raw_PtrOfHistogramCostExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfHistogramCostExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::HistogramCostExtractorTraitConst for core::Ptr<crate::shape::HistogramCostExtractor> {
		#[inline] fn as_raw_HistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::HistogramCostExtractorTrait for core::Ptr<crate::shape::HistogramCostExtractor> {
		#[inline] fn as_raw_mut_HistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::HistogramCostExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::HistogramCostExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::HistogramCostExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_HistogramCostExtractorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::shape::HistogramCostExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfHistogramCostExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::NormHistogramCostExtractor,
		cv_PtrLcv_NormHistogramCostExtractorG_new_null_const, cv_PtrLcv_NormHistogramCostExtractorG_delete, cv_PtrLcv_NormHistogramCostExtractorG_getInnerPtr_const, cv_PtrLcv_NormHistogramCostExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline] pub fn as_raw_PtrOfNormHistogramCostExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfNormHistogramCostExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::NormHistogramCostExtractorTraitConst for core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline] fn as_raw_NormHistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::NormHistogramCostExtractorTrait for core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline] fn as_raw_mut_NormHistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::NormHistogramCostExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_NormHistogramCostExtractorG_to_PtrOfAlgorithm }

	impl crate::shape::HistogramCostExtractorTraitConst for core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline] fn as_raw_HistogramCostExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::HistogramCostExtractorTrait for core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline] fn as_raw_mut_HistogramCostExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::NormHistogramCostExtractor>, core::Ptr<crate::shape::HistogramCostExtractor>, cv_PtrLcv_NormHistogramCostExtractorG_to_PtrOfHistogramCostExtractor }

	impl std::fmt::Debug for core::Ptr<crate::shape::NormHistogramCostExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfNormHistogramCostExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::ShapeContextDistanceExtractor,
		cv_PtrLcv_ShapeContextDistanceExtractorG_new_null_const, cv_PtrLcv_ShapeContextDistanceExtractorG_delete, cv_PtrLcv_ShapeContextDistanceExtractorG_getInnerPtr_const, cv_PtrLcv_ShapeContextDistanceExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline] pub fn as_raw_PtrOfShapeContextDistanceExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfShapeContextDistanceExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::ShapeContextDistanceExtractorTraitConst for core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline] fn as_raw_ShapeContextDistanceExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ShapeContextDistanceExtractorTrait for core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline] fn as_raw_mut_ShapeContextDistanceExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ShapeContextDistanceExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_ShapeContextDistanceExtractorG_to_PtrOfAlgorithm }

	impl crate::shape::ShapeDistanceExtractorTraitConst for core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline] fn as_raw_ShapeDistanceExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ShapeDistanceExtractorTrait for core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline] fn as_raw_mut_ShapeDistanceExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ShapeContextDistanceExtractor>, core::Ptr<crate::shape::ShapeDistanceExtractor>, cv_PtrLcv_ShapeContextDistanceExtractorG_to_PtrOfShapeDistanceExtractor }

	impl std::fmt::Debug for core::Ptr<crate::shape::ShapeContextDistanceExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfShapeContextDistanceExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::ShapeDistanceExtractor,
		cv_PtrLcv_ShapeDistanceExtractorG_new_null_const, cv_PtrLcv_ShapeDistanceExtractorG_delete, cv_PtrLcv_ShapeDistanceExtractorG_getInnerPtr_const, cv_PtrLcv_ShapeDistanceExtractorG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::ShapeDistanceExtractor> {
		#[inline] pub fn as_raw_PtrOfShapeDistanceExtractor(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfShapeDistanceExtractor(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::ShapeDistanceExtractorTraitConst for core::Ptr<crate::shape::ShapeDistanceExtractor> {
		#[inline] fn as_raw_ShapeDistanceExtractor(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ShapeDistanceExtractorTrait for core::Ptr<crate::shape::ShapeDistanceExtractor> {
		#[inline] fn as_raw_mut_ShapeDistanceExtractor(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::ShapeDistanceExtractor> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::ShapeDistanceExtractor> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ShapeDistanceExtractor>, core::Ptr<core::Algorithm>, cv_PtrLcv_ShapeDistanceExtractorG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::shape::ShapeDistanceExtractor> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfShapeDistanceExtractor")
				.finish()
		}
	}

	ptr_extern! { crate::shape::ShapeTransformer,
		cv_PtrLcv_ShapeTransformerG_new_null_const, cv_PtrLcv_ShapeTransformerG_delete, cv_PtrLcv_ShapeTransformerG_getInnerPtr_const, cv_PtrLcv_ShapeTransformerG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::ShapeTransformer> {
		#[inline] pub fn as_raw_PtrOfShapeTransformer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfShapeTransformer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::ShapeTransformerTraitConst for core::Ptr<crate::shape::ShapeTransformer> {
		#[inline] fn as_raw_ShapeTransformer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ShapeTransformerTrait for core::Ptr<crate::shape::ShapeTransformer> {
		#[inline] fn as_raw_mut_ShapeTransformer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::ShapeTransformer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::ShapeTransformer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ShapeTransformer>, core::Ptr<core::Algorithm>, cv_PtrLcv_ShapeTransformerG_to_PtrOfAlgorithm }

	impl std::fmt::Debug for core::Ptr<crate::shape::ShapeTransformer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfShapeTransformer")
				.finish()
		}
	}

	ptr_extern! { crate::shape::ThinPlateSplineShapeTransformer,
		cv_PtrLcv_ThinPlateSplineShapeTransformerG_new_null_const, cv_PtrLcv_ThinPlateSplineShapeTransformerG_delete, cv_PtrLcv_ThinPlateSplineShapeTransformerG_getInnerPtr_const, cv_PtrLcv_ThinPlateSplineShapeTransformerG_getInnerPtrMut
	}

	impl core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline] pub fn as_raw_PtrOfThinPlateSplineShapeTransformer(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfThinPlateSplineShapeTransformer(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::shape::ThinPlateSplineShapeTransformerTraitConst for core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline] fn as_raw_ThinPlateSplineShapeTransformer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ThinPlateSplineShapeTransformerTrait for core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline] fn as_raw_mut_ThinPlateSplineShapeTransformer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl core::AlgorithmTraitConst for core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline] fn as_raw_Algorithm(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl core::AlgorithmTrait for core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline] fn as_raw_mut_Algorithm(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ThinPlateSplineShapeTransformer>, core::Ptr<core::Algorithm>, cv_PtrLcv_ThinPlateSplineShapeTransformerG_to_PtrOfAlgorithm }

	impl crate::shape::ShapeTransformerTraitConst for core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline] fn as_raw_ShapeTransformer(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::shape::ShapeTransformerTrait for core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline] fn as_raw_mut_ShapeTransformer(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::shape::ThinPlateSplineShapeTransformer>, core::Ptr<crate::shape::ShapeTransformer>, cv_PtrLcv_ThinPlateSplineShapeTransformerG_to_PtrOfShapeTransformer }

	impl std::fmt::Debug for core::Ptr<crate::shape::ThinPlateSplineShapeTransformer> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfThinPlateSplineShapeTransformer")
				.finish()
		}
	}

}
pub use shape_types::*;

mod stereo_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::stereo::QuasiDenseStereo,
		cv_PtrLcv_stereo_QuasiDenseStereoG_new_null_const, cv_PtrLcv_stereo_QuasiDenseStereoG_delete, cv_PtrLcv_stereo_QuasiDenseStereoG_getInnerPtr_const, cv_PtrLcv_stereo_QuasiDenseStereoG_getInnerPtrMut
	}

	impl core::Ptr<crate::stereo::QuasiDenseStereo> {
		#[inline] pub fn as_raw_PtrOfQuasiDenseStereo(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfQuasiDenseStereo(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stereo::QuasiDenseStereoTraitConst for core::Ptr<crate::stereo::QuasiDenseStereo> {
		#[inline] fn as_raw_QuasiDenseStereo(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stereo::QuasiDenseStereoTrait for core::Ptr<crate::stereo::QuasiDenseStereo> {
		#[inline] fn as_raw_mut_QuasiDenseStereo(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::stereo::QuasiDenseStereo> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfQuasiDenseStereo")
				.field("param", &crate::stereo::QuasiDenseStereoTraitConst::param(self))
				.finish()
		}
	}

	impl core::Vector<crate::stereo::MatchQuasiDense> {
		pub fn as_raw_VectorOfMatchQuasiDense(&self) -> extern_send!(Self) { self.as_raw() }
		pub fn as_raw_mut_VectorOfMatchQuasiDense(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	vector_extern! { crate::stereo::MatchQuasiDense,
		std_vectorLcv_stereo_MatchQuasiDenseG_new_const, std_vectorLcv_stereo_MatchQuasiDenseG_delete,
		std_vectorLcv_stereo_MatchQuasiDenseG_len_const, std_vectorLcv_stereo_MatchQuasiDenseG_isEmpty_const,
		std_vectorLcv_stereo_MatchQuasiDenseG_capacity_const, std_vectorLcv_stereo_MatchQuasiDenseG_shrinkToFit,
		std_vectorLcv_stereo_MatchQuasiDenseG_reserve_size_t, std_vectorLcv_stereo_MatchQuasiDenseG_remove_size_t,
		std_vectorLcv_stereo_MatchQuasiDenseG_swap_size_t_size_t, std_vectorLcv_stereo_MatchQuasiDenseG_clear,
		std_vectorLcv_stereo_MatchQuasiDenseG_get_const_size_t, std_vectorLcv_stereo_MatchQuasiDenseG_set_size_t_const_MatchQuasiDense,
		std_vectorLcv_stereo_MatchQuasiDenseG_push_const_MatchQuasiDense, std_vectorLcv_stereo_MatchQuasiDenseG_insert_size_t_const_MatchQuasiDense,
	}

	vector_copy_non_bool! { crate::stereo::MatchQuasiDense,
		std_vectorLcv_stereo_MatchQuasiDenseG_data_const, std_vectorLcv_stereo_MatchQuasiDenseG_dataMut, cv_fromSlice_const_const_MatchQuasiDenseX_size_t,
		std_vectorLcv_stereo_MatchQuasiDenseG_clone_const,
	}


}
pub use stereo_types::*;

mod stitching_types {
	use crate::{mod_prelude::*, core, types, sys};

	ptr_extern! { crate::stitching::AffineWarper,
		cv_PtrLcv_AffineWarperG_new_null_const, cv_PtrLcv_AffineWarperG_delete, cv_PtrLcv_AffineWarperG_getInnerPtr_const, cv_PtrLcv_AffineWarperG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::AffineWarper, cv_PtrLcv_AffineWarperG_new_const_AffineWarper }
	impl core::Ptr<crate::stitching::AffineWarper> {
		#[inline] pub fn as_raw_PtrOfAffineWarper(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfAffineWarper(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::AffineWarperTraitConst for core::Ptr<crate::stitching::AffineWarper> {
		#[inline] fn as_raw_AffineWarper(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::AffineWarperTrait for core::Ptr<crate::stitching::AffineWarper> {
		#[inline] fn as_raw_mut_AffineWarper(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::WarperCreatorTraitConst for core::Ptr<crate::stitching::AffineWarper> {
		#[inline] fn as_raw_WarperCreator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::WarperCreatorTrait for core::Ptr<crate::stitching::AffineWarper> {
		#[inline] fn as_raw_mut_WarperCreator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::AffineWarper>, core::Ptr<crate::stitching::WarperCreator>, cv_PtrLcv_AffineWarperG_to_PtrOfWarperCreator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::AffineWarper> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfAffineWarper")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::CompressedRectilinearPortraitWarper,
		cv_PtrLcv_CompressedRectilinearPortraitWarperG_new_null_const, cv_PtrLcv_CompressedRectilinearPortraitWarperG_delete, cv_PtrLcv_CompressedRectilinearPortraitWarperG_getInnerPtr_const, cv_PtrLcv_CompressedRectilinearPortraitWarperG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::CompressedRectilinearPortraitWarper, cv_PtrLcv_CompressedRectilinearPortraitWarperG_new_const_CompressedRectilinearPortraitWarper }
	impl core::Ptr<crate::stitching::CompressedRectilinearPortraitWarper> {
		#[inline] pub fn as_raw_PtrOfCompressedRectilinearPortraitWarper(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCompressedRectilinearPortraitWarper(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::CompressedRectilinearPortraitWarperTraitConst for core::Ptr<crate::stitching::CompressedRectilinearPortraitWarper> {
		#[inline] fn as_raw_CompressedRectilinearPortraitWarper(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::CompressedRectilinearPortraitWarperTrait for core::Ptr<crate::stitching::CompressedRectilinearPortraitWarper> {
		#[inline] fn as_raw_mut_CompressedRectilinearPortraitWarper(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::WarperCreatorTraitConst for core::Ptr<crate::stitching::CompressedRectilinearPortraitWarper> {
		#[inline] fn as_raw_WarperCreator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::WarperCreatorTrait for core::Ptr<crate::stitching::CompressedRectilinearPortraitWarper> {
		#[inline] fn as_raw_mut_WarperCreator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::CompressedRectilinearPortraitWarper>, core::Ptr<crate::stitching::WarperCreator>, cv_PtrLcv_CompressedRectilinearPortraitWarperG_to_PtrOfWarperCreator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::CompressedRectilinearPortraitWarper> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCompressedRectilinearPortraitWarper")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::CompressedRectilinearWarper,
		cv_PtrLcv_CompressedRectilinearWarperG_new_null_const, cv_PtrLcv_CompressedRectilinearWarperG_delete, cv_PtrLcv_CompressedRectilinearWarperG_getInnerPtr_const, cv_PtrLcv_CompressedRectilinearWarperG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::CompressedRectilinearWarper, cv_PtrLcv_CompressedRectilinearWarperG_new_const_CompressedRectilinearWarper }
	impl core::Ptr<crate::stitching::CompressedRectilinearWarper> {
		#[inline] pub fn as_raw_PtrOfCompressedRectilinearWarper(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCompressedRectilinearWarper(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::CompressedRectilinearWarperTraitConst for core::Ptr<crate::stitching::CompressedRectilinearWarper> {
		#[inline] fn as_raw_CompressedRectilinearWarper(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::CompressedRectilinearWarperTrait for core::Ptr<crate::stitching::CompressedRectilinearWarper> {
		#[inline] fn as_raw_mut_CompressedRectilinearWarper(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::WarperCreatorTraitConst for core::Ptr<crate::stitching::CompressedRectilinearWarper> {
		#[inline] fn as_raw_WarperCreator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::WarperCreatorTrait for core::Ptr<crate::stitching::CompressedRectilinearWarper> {
		#[inline] fn as_raw_mut_WarperCreator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::CompressedRectilinearWarper>, core::Ptr<crate::stitching::WarperCreator>, cv_PtrLcv_CompressedRectilinearWarperG_to_PtrOfWarperCreator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::CompressedRectilinearWarper> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCompressedRectilinearWarper")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::CylindricalWarper,
		cv_PtrLcv_CylindricalWarperG_new_null_const, cv_PtrLcv_CylindricalWarperG_delete, cv_PtrLcv_CylindricalWarperG_getInnerPtr_const, cv_PtrLcv_CylindricalWarperG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::CylindricalWarper, cv_PtrLcv_CylindricalWarperG_new_const_CylindricalWarper }
	impl core::Ptr<crate::stitching::CylindricalWarper> {
		#[inline] pub fn as_raw_PtrOfCylindricalWarper(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCylindricalWarper(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::CylindricalWarperTraitConst for core::Ptr<crate::stitching::CylindricalWarper> {
		#[inline] fn as_raw_CylindricalWarper(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::CylindricalWarperTrait for core::Ptr<crate::stitching::CylindricalWarper> {
		#[inline] fn as_raw_mut_CylindricalWarper(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::WarperCreatorTraitConst for core::Ptr<crate::stitching::CylindricalWarper> {
		#[inline] fn as_raw_WarperCreator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::WarperCreatorTrait for core::Ptr<crate::stitching::CylindricalWarper> {
		#[inline] fn as_raw_mut_WarperCreator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::CylindricalWarper>, core::Ptr<crate::stitching::WarperCreator>, cv_PtrLcv_CylindricalWarperG_to_PtrOfWarperCreator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::CylindricalWarper> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCylindricalWarper")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::CylindricalWarperGpu,
		cv_PtrLcv_CylindricalWarperGpuG_new_null_const, cv_PtrLcv_CylindricalWarperGpuG_delete, cv_PtrLcv_CylindricalWarperGpuG_getInnerPtr_const, cv_PtrLcv_CylindricalWarperGpuG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::CylindricalWarperGpu, cv_PtrLcv_CylindricalWarperGpuG_new_const_CylindricalWarperGpu }
	impl core::Ptr<crate::stitching::CylindricalWarperGpu> {
		#[inline] pub fn as_raw_PtrOfCylindricalWarperGpu(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfCylindricalWarperGpu(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::CylindricalWarperGpuTraitConst for core::Ptr<crate::stitching::CylindricalWarperGpu> {
		#[inline] fn as_raw_CylindricalWarperGpu(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::CylindricalWarperGpuTrait for core::Ptr<crate::stitching::CylindricalWarperGpu> {
		#[inline] fn as_raw_mut_CylindricalWarperGpu(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::WarperCreatorTraitConst for core::Ptr<crate::stitching::CylindricalWarperGpu> {
		#[inline] fn as_raw_WarperCreator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::WarperCreatorTrait for core::Ptr<crate::stitching::CylindricalWarperGpu> {
		#[inline] fn as_raw_mut_WarperCreator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::CylindricalWarperGpu>, core::Ptr<crate::stitching::WarperCreator>, cv_PtrLcv_CylindricalWarperGpuG_to_PtrOfWarperCreator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::CylindricalWarperGpu> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfCylindricalWarperGpu")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_AffineBasedEstimator,
		cv_PtrLcv_detail_AffineBasedEstimatorG_new_null_const, cv_PtrLcv_detail_AffineBasedEstimatorG_delete, cv_PtrLcv_detail_AffineBasedEstimatorG_getInnerPtr_const, cv_PtrLcv_detail_AffineBasedEstimatorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_AffineBasedEstimator, cv_PtrLcv_detail_AffineBasedEstimatorG_new_const_AffineBasedEstimator }
	impl core::Ptr<crate::stitching::Detail_AffineBasedEstimator> {
		#[inline] pub fn as_raw_PtrOfDetail_AffineBasedEstimator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_AffineBasedEstimator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_AffineBasedEstimatorTraitConst for core::Ptr<crate::stitching::Detail_AffineBasedEstimator> {
		#[inline] fn as_raw_Detail_AffineBasedEstimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_AffineBasedEstimatorTrait for core::Ptr<crate::stitching::Detail_AffineBasedEstimator> {
		#[inline] fn as_raw_mut_Detail_AffineBasedEstimator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_EstimatorTraitConst for core::Ptr<crate::stitching::Detail_AffineBasedEstimator> {
		#[inline] fn as_raw_Detail_Estimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_EstimatorTrait for core::Ptr<crate::stitching::Detail_AffineBasedEstimator> {
		#[inline] fn as_raw_mut_Detail_Estimator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_AffineBasedEstimator>, core::Ptr<crate::stitching::Detail_Estimator>, cv_PtrLcv_detail_AffineBasedEstimatorG_to_PtrOfDetail_Estimator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_AffineBasedEstimator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_AffineBasedEstimator")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_AffineBestOf2NearestMatcher,
		cv_PtrLcv_detail_AffineBestOf2NearestMatcherG_new_null_const, cv_PtrLcv_detail_AffineBestOf2NearestMatcherG_delete, cv_PtrLcv_detail_AffineBestOf2NearestMatcherG_getInnerPtr_const, cv_PtrLcv_detail_AffineBestOf2NearestMatcherG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_AffineBestOf2NearestMatcher, cv_PtrLcv_detail_AffineBestOf2NearestMatcherG_new_const_AffineBestOf2NearestMatcher }
	impl core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline] pub fn as_raw_PtrOfDetail_AffineBestOf2NearestMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_AffineBestOf2NearestMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_AffineBestOf2NearestMatcherTraitConst for core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline] fn as_raw_Detail_AffineBestOf2NearestMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_AffineBestOf2NearestMatcherTrait for core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline] fn as_raw_mut_Detail_AffineBestOf2NearestMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BestOf2NearestMatcherTraitConst for core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline] fn as_raw_Detail_BestOf2NearestMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BestOf2NearestMatcherTrait for core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline] fn as_raw_mut_Detail_BestOf2NearestMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher>, core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher>, cv_PtrLcv_detail_AffineBestOf2NearestMatcherG_to_PtrOfDetail_BestOf2NearestMatcher }

	impl crate::stitching::Detail_FeaturesMatcherTraitConst for core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline] fn as_raw_Detail_FeaturesMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_FeaturesMatcherTrait for core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline] fn as_raw_mut_Detail_FeaturesMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher>, core::Ptr<crate::stitching::Detail_FeaturesMatcher>, cv_PtrLcv_detail_AffineBestOf2NearestMatcherG_to_PtrOfDetail_FeaturesMatcher }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_AffineBestOf2NearestMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_AffineBestOf2NearestMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BestOf2NearestMatcher,
		cv_PtrLcv_detail_BestOf2NearestMatcherG_new_null_const, cv_PtrLcv_detail_BestOf2NearestMatcherG_delete, cv_PtrLcv_detail_BestOf2NearestMatcherG_getInnerPtr_const, cv_PtrLcv_detail_BestOf2NearestMatcherG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BestOf2NearestMatcher, cv_PtrLcv_detail_BestOf2NearestMatcherG_new_const_BestOf2NearestMatcher }
	impl core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher> {
		#[inline] pub fn as_raw_PtrOfDetail_BestOf2NearestMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BestOf2NearestMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BestOf2NearestMatcherTraitConst for core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher> {
		#[inline] fn as_raw_Detail_BestOf2NearestMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BestOf2NearestMatcherTrait for core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher> {
		#[inline] fn as_raw_mut_Detail_BestOf2NearestMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_FeaturesMatcherTraitConst for core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher> {
		#[inline] fn as_raw_Detail_FeaturesMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_FeaturesMatcherTrait for core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher> {
		#[inline] fn as_raw_mut_Detail_FeaturesMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher>, core::Ptr<crate::stitching::Detail_FeaturesMatcher>, cv_PtrLcv_detail_BestOf2NearestMatcherG_to_PtrOfDetail_FeaturesMatcher }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BestOf2NearestMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BestOf2NearestRangeMatcher,
		cv_PtrLcv_detail_BestOf2NearestRangeMatcherG_new_null_const, cv_PtrLcv_detail_BestOf2NearestRangeMatcherG_delete, cv_PtrLcv_detail_BestOf2NearestRangeMatcherG_getInnerPtr_const, cv_PtrLcv_detail_BestOf2NearestRangeMatcherG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BestOf2NearestRangeMatcher, cv_PtrLcv_detail_BestOf2NearestRangeMatcherG_new_const_BestOf2NearestRangeMatcher }
	impl core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline] pub fn as_raw_PtrOfDetail_BestOf2NearestRangeMatcher(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BestOf2NearestRangeMatcher(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BestOf2NearestRangeMatcherTraitConst for core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline] fn as_raw_Detail_BestOf2NearestRangeMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BestOf2NearestRangeMatcherTrait for core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline] fn as_raw_mut_Detail_BestOf2NearestRangeMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BestOf2NearestMatcherTraitConst for core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline] fn as_raw_Detail_BestOf2NearestMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BestOf2NearestMatcherTrait for core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline] fn as_raw_mut_Detail_BestOf2NearestMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher>, core::Ptr<crate::stitching::Detail_BestOf2NearestMatcher>, cv_PtrLcv_detail_BestOf2NearestRangeMatcherG_to_PtrOfDetail_BestOf2NearestMatcher }

	impl crate::stitching::Detail_FeaturesMatcherTraitConst for core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline] fn as_raw_Detail_FeaturesMatcher(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_FeaturesMatcherTrait for core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline] fn as_raw_mut_Detail_FeaturesMatcher(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher>, core::Ptr<crate::stitching::Detail_FeaturesMatcher>, cv_PtrLcv_detail_BestOf2NearestRangeMatcherG_to_PtrOfDetail_FeaturesMatcher }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BestOf2NearestRangeMatcher> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BestOf2NearestRangeMatcher")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_Blender,
		cv_PtrLcv_detail_BlenderG_new_null_const, cv_PtrLcv_detail_BlenderG_delete, cv_PtrLcv_detail_BlenderG_getInnerPtr_const, cv_PtrLcv_detail_BlenderG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_Blender, cv_PtrLcv_detail_BlenderG_new_const_Blender }
	impl core::Ptr<crate::stitching::Detail_Blender> {
		#[inline] pub fn as_raw_PtrOfDetail_Blender(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_Blender(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BlenderTraitConst for core::Ptr<crate::stitching::Detail_Blender> {
		#[inline] fn as_raw_Detail_Blender(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BlenderTrait for core::Ptr<crate::stitching::Detail_Blender> {
		#[inline] fn as_raw_mut_Detail_Blender(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_Blender> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_Blender")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BlocksChannelsCompensator,
		cv_PtrLcv_detail_BlocksChannelsCompensatorG_new_null_const, cv_PtrLcv_detail_BlocksChannelsCompensatorG_delete, cv_PtrLcv_detail_BlocksChannelsCompensatorG_getInnerPtr_const, cv_PtrLcv_detail_BlocksChannelsCompensatorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BlocksChannelsCompensator, cv_PtrLcv_detail_BlocksChannelsCompensatorG_new_const_BlocksChannelsCompensator }
	impl core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline] pub fn as_raw_PtrOfDetail_BlocksChannelsCompensator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BlocksChannelsCompensator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BlocksChannelsCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline] fn as_raw_Detail_BlocksChannelsCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BlocksChannelsCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline] fn as_raw_mut_Detail_BlocksChannelsCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BlocksCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline] fn as_raw_Detail_BlocksCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BlocksCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline] fn as_raw_mut_Detail_BlocksCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator>, core::Ptr<crate::stitching::Detail_BlocksCompensator>, cv_PtrLcv_detail_BlocksChannelsCompensatorG_to_PtrOfDetail_BlocksCompensator }

	impl crate::stitching::Detail_ExposureCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline] fn as_raw_Detail_ExposureCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_ExposureCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline] fn as_raw_mut_Detail_ExposureCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator>, core::Ptr<crate::stitching::Detail_ExposureCompensator>, cv_PtrLcv_detail_BlocksChannelsCompensatorG_to_PtrOfDetail_ExposureCompensator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BlocksChannelsCompensator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BlocksChannelsCompensator")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BlocksCompensator,
		cv_PtrLcv_detail_BlocksCompensatorG_new_null_const, cv_PtrLcv_detail_BlocksCompensatorG_delete, cv_PtrLcv_detail_BlocksCompensatorG_getInnerPtr_const, cv_PtrLcv_detail_BlocksCompensatorG_getInnerPtrMut
	}

	impl core::Ptr<crate::stitching::Detail_BlocksCompensator> {
		#[inline] pub fn as_raw_PtrOfDetail_BlocksCompensator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BlocksCompensator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BlocksCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksCompensator> {
		#[inline] fn as_raw_Detail_BlocksCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BlocksCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksCompensator> {
		#[inline] fn as_raw_mut_Detail_BlocksCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_ExposureCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksCompensator> {
		#[inline] fn as_raw_Detail_ExposureCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_ExposureCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksCompensator> {
		#[inline] fn as_raw_mut_Detail_ExposureCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BlocksCompensator>, core::Ptr<crate::stitching::Detail_ExposureCompensator>, cv_PtrLcv_detail_BlocksCompensatorG_to_PtrOfDetail_ExposureCompensator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BlocksCompensator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BlocksCompensator")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BlocksGainCompensator,
		cv_PtrLcv_detail_BlocksGainCompensatorG_new_null_const, cv_PtrLcv_detail_BlocksGainCompensatorG_delete, cv_PtrLcv_detail_BlocksGainCompensatorG_getInnerPtr_const, cv_PtrLcv_detail_BlocksGainCompensatorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BlocksGainCompensator, cv_PtrLcv_detail_BlocksGainCompensatorG_new_const_BlocksGainCompensator }
	impl core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline] pub fn as_raw_PtrOfDetail_BlocksGainCompensator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BlocksGainCompensator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BlocksGainCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline] fn as_raw_Detail_BlocksGainCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BlocksGainCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline] fn as_raw_mut_Detail_BlocksGainCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BlocksCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline] fn as_raw_Detail_BlocksCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BlocksCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline] fn as_raw_mut_Detail_BlocksCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BlocksGainCompensator>, core::Ptr<crate::stitching::Detail_BlocksCompensator>, cv_PtrLcv_detail_BlocksGainCompensatorG_to_PtrOfDetail_BlocksCompensator }

	impl crate::stitching::Detail_ExposureCompensatorTraitConst for core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline] fn as_raw_Detail_ExposureCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_ExposureCompensatorTrait for core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline] fn as_raw_mut_Detail_ExposureCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BlocksGainCompensator>, core::Ptr<crate::stitching::Detail_ExposureCompensator>, cv_PtrLcv_detail_BlocksGainCompensatorG_to_PtrOfDetail_ExposureCompensator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BlocksGainCompensator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BlocksGainCompensator")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BundleAdjusterAffine,
		cv_PtrLcv_detail_BundleAdjusterAffineG_new_null_const, cv_PtrLcv_detail_BundleAdjusterAffineG_delete, cv_PtrLcv_detail_BundleAdjusterAffineG_getInnerPtr_const, cv_PtrLcv_detail_BundleAdjusterAffineG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BundleAdjusterAffine, cv_PtrLcv_detail_BundleAdjusterAffineG_new_const_BundleAdjusterAffine }
	impl core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline] pub fn as_raw_PtrOfDetail_BundleAdjusterAffine(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BundleAdjusterAffine(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterAffineTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline] fn as_raw_Detail_BundleAdjusterAffine(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterAffineTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterAffine(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline] fn as_raw_Detail_BundleAdjusterBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterAffine>, core::Ptr<crate::stitching::Detail_BundleAdjusterBase>, cv_PtrLcv_detail_BundleAdjusterAffineG_to_PtrOfDetail_BundleAdjusterBase }

	impl crate::stitching::Detail_EstimatorTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline] fn as_raw_Detail_Estimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_EstimatorTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline] fn as_raw_mut_Detail_Estimator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterAffine>, core::Ptr<crate::stitching::Detail_Estimator>, cv_PtrLcv_detail_BundleAdjusterAffineG_to_PtrOfDetail_Estimator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BundleAdjusterAffine> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BundleAdjusterAffine")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BundleAdjusterAffinePartial,
		cv_PtrLcv_detail_BundleAdjusterAffinePartialG_new_null_const, cv_PtrLcv_detail_BundleAdjusterAffinePartialG_delete, cv_PtrLcv_detail_BundleAdjusterAffinePartialG_getInnerPtr_const, cv_PtrLcv_detail_BundleAdjusterAffinePartialG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BundleAdjusterAffinePartial, cv_PtrLcv_detail_BundleAdjusterAffinePartialG_new_const_BundleAdjusterAffinePartial }
	impl core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline] pub fn as_raw_PtrOfDetail_BundleAdjusterAffinePartial(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BundleAdjusterAffinePartial(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterAffinePartialTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline] fn as_raw_Detail_BundleAdjusterAffinePartial(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterAffinePartialTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterAffinePartial(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline] fn as_raw_Detail_BundleAdjusterBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial>, core::Ptr<crate::stitching::Detail_BundleAdjusterBase>, cv_PtrLcv_detail_BundleAdjusterAffinePartialG_to_PtrOfDetail_BundleAdjusterBase }

	impl crate::stitching::Detail_EstimatorTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline] fn as_raw_Detail_Estimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_EstimatorTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline] fn as_raw_mut_Detail_Estimator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial>, core::Ptr<crate::stitching::Detail_Estimator>, cv_PtrLcv_detail_BundleAdjusterAffinePartialG_to_PtrOfDetail_Estimator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BundleAdjusterAffinePartial> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BundleAdjusterAffinePartial")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BundleAdjusterBase,
		cv_PtrLcv_detail_BundleAdjusterBaseG_new_null_const, cv_PtrLcv_detail_BundleAdjusterBaseG_delete, cv_PtrLcv_detail_BundleAdjusterBaseG_getInnerPtr_const, cv_PtrLcv_detail_BundleAdjusterBaseG_getInnerPtrMut
	}

	impl core::Ptr<crate::stitching::Detail_BundleAdjusterBase> {
		#[inline] pub fn as_raw_PtrOfDetail_BundleAdjusterBase(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BundleAdjusterBase(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterBase> {
		#[inline] fn as_raw_Detail_BundleAdjusterBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterBase> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_EstimatorTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterBase> {
		#[inline] fn as_raw_Detail_Estimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_EstimatorTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterBase> {
		#[inline] fn as_raw_mut_Detail_Estimator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterBase>, core::Ptr<crate::stitching::Detail_Estimator>, cv_PtrLcv_detail_BundleAdjusterBaseG_to_PtrOfDetail_Estimator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BundleAdjusterBase> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BundleAdjusterBase")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BundleAdjusterRay,
		cv_PtrLcv_detail_BundleAdjusterRayG_new_null_const, cv_PtrLcv_detail_BundleAdjusterRayG_delete, cv_PtrLcv_detail_BundleAdjusterRayG_getInnerPtr_const, cv_PtrLcv_detail_BundleAdjusterRayG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BundleAdjusterRay, cv_PtrLcv_detail_BundleAdjusterRayG_new_const_BundleAdjusterRay }
	impl core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline] pub fn as_raw_PtrOfDetail_BundleAdjusterRay(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BundleAdjusterRay(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterRayTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline] fn as_raw_Detail_BundleAdjusterRay(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterRayTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterRay(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline] fn as_raw_Detail_BundleAdjusterBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterRay>, core::Ptr<crate::stitching::Detail_BundleAdjusterBase>, cv_PtrLcv_detail_BundleAdjusterRayG_to_PtrOfDetail_BundleAdjusterBase }

	impl crate::stitching::Detail_EstimatorTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline] fn as_raw_Detail_Estimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_EstimatorTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline] fn as_raw_mut_Detail_Estimator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterRay>, core::Ptr<crate::stitching::Detail_Estimator>, cv_PtrLcv_detail_BundleAdjusterRayG_to_PtrOfDetail_Estimator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BundleAdjusterRay> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BundleAdjusterRay")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_BundleAdjusterReproj,
		cv_PtrLcv_detail_BundleAdjusterReprojG_new_null_const, cv_PtrLcv_detail_BundleAdjusterReprojG_delete, cv_PtrLcv_detail_BundleAdjusterReprojG_getInnerPtr_const, cv_PtrLcv_detail_BundleAdjusterReprojG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_BundleAdjusterReproj, cv_PtrLcv_detail_BundleAdjusterReprojG_new_const_BundleAdjusterReproj }
	impl core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline] pub fn as_raw_PtrOfDetail_BundleAdjusterReproj(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_BundleAdjusterReproj(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterReprojTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline] fn as_raw_Detail_BundleAdjusterReproj(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterReprojTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterReproj(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline] fn as_raw_Detail_BundleAdjusterBase(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_BundleAdjusterBaseTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline] fn as_raw_mut_Detail_BundleAdjusterBase(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterReproj>, core::Ptr<crate::stitching::Detail_BundleAdjusterBase>, cv_PtrLcv_detail_BundleAdjusterReprojG_to_PtrOfDetail_BundleAdjusterBase }

	impl crate::stitching::Detail_EstimatorTraitConst for core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline] fn as_raw_Detail_Estimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_EstimatorTrait for core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline] fn as_raw_mut_Detail_Estimator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_BundleAdjusterReproj>, core::Ptr<crate::stitching::Detail_Estimator>, cv_PtrLcv_detail_BundleAdjusterReprojG_to_PtrOfDetail_Estimator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_BundleAdjusterReproj> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_BundleAdjusterReproj")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_ChannelsCompensator,
		cv_PtrLcv_detail_ChannelsCompensatorG_new_null_const, cv_PtrLcv_detail_ChannelsCompensatorG_delete, cv_PtrLcv_detail_ChannelsCompensatorG_getInnerPtr_const, cv_PtrLcv_detail_ChannelsCompensatorG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_ChannelsCompensator, cv_PtrLcv_detail_ChannelsCompensatorG_new_const_ChannelsCompensator }
	impl core::Ptr<crate::stitching::Detail_ChannelsCompensator> {
		#[inline] pub fn as_raw_PtrOfDetail_ChannelsCompensator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_ChannelsCompensator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_ChannelsCompensatorTraitConst for core::Ptr<crate::stitching::Detail_ChannelsCompensator> {
		#[inline] fn as_raw_Detail_ChannelsCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_ChannelsCompensatorTrait for core::Ptr<crate::stitching::Detail_ChannelsCompensator> {
		#[inline] fn as_raw_mut_Detail_ChannelsCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_ExposureCompensatorTraitConst for core::Ptr<crate::stitching::Detail_ChannelsCompensator> {
		#[inline] fn as_raw_Detail_ExposureCompensator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_ExposureCompensatorTrait for core::Ptr<crate::stitching::Detail_ChannelsCompensator> {
		#[inline] fn as_raw_mut_Detail_ExposureCompensator(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_ChannelsCompensator>, core::Ptr<crate::stitching::Detail_ExposureCompensator>, cv_PtrLcv_detail_ChannelsCompensatorG_to_PtrOfDetail_ExposureCompensator }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_ChannelsCompensator> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_ChannelsCompensator")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_DpSeamFinder,
		cv_PtrLcv_detail_DpSeamFinderG_new_null_const, cv_PtrLcv_detail_DpSeamFinderG_delete, cv_PtrLcv_detail_DpSeamFinderG_getInnerPtr_const, cv_PtrLcv_detail_DpSeamFinderG_getInnerPtrMut
	}

	ptr_extern_ctor! { crate::stitching::Detail_DpSeamFinder, cv_PtrLcv_detail_DpSeamFinderG_new_const_DpSeamFinder }
	impl core::Ptr<crate::stitching::Detail_DpSeamFinder> {
		#[inline] pub fn as_raw_PtrOfDetail_DpSeamFinder(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_DpSeamFinder(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_DpSeamFinderTraitConst for core::Ptr<crate::stitching::Detail_DpSeamFinder> {
		#[inline] fn as_raw_Detail_DpSeamFinder(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_DpSeamFinderTrait for core::Ptr<crate::stitching::Detail_DpSeamFinder> {
		#[inline] fn as_raw_mut_Detail_DpSeamFinder(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	impl crate::stitching::Detail_SeamFinderTraitConst for core::Ptr<crate::stitching::Detail_DpSeamFinder> {
		#[inline] fn as_raw_Detail_SeamFinder(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_SeamFinderTrait for core::Ptr<crate::stitching::Detail_DpSeamFinder> {
		#[inline] fn as_raw_mut_Detail_SeamFinder(&mut self) -> *mut c_void { self.inner_as_raw_mut() }
	}

	ptr_cast_base! { core::Ptr<crate::stitching::Detail_DpSeamFinder>, core::Ptr<crate::stitching::Detail_SeamFinder>, cv_PtrLcv_detail_DpSeamFinderG_to_PtrOfDetail_SeamFinder }

	impl std::fmt::Debug for core::Ptr<crate::stitching::Detail_DpSeamFinder> {
		#[inline]
		fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
			f.debug_struct("PtrOfDetail_DpSeamFinder")
				.finish()
		}
	}

	ptr_extern! { crate::stitching::Detail_Estimator,
		cv_PtrLcv_detail_EstimatorG_new_null_const, cv_PtrLcv_detail_EstimatorG_delete, cv_PtrLcv_detail_EstimatorG_getInnerPtr_const, cv_PtrLcv_detail_EstimatorG_getInnerPtrMut
	}

	impl core::Ptr<crate::stitching::Detail_Estimator> {
		#[inline] pub fn as_raw_PtrOfDetail_Estimator(&self) -> extern_send!(Self) { self.as_raw() }
		#[inline] pub fn as_raw_mut_PtrOfDetail_Estimator(&mut self) -> extern_send!(mut Self) { self.as_raw_mut() }
	}

	impl crate::stitching::Detail_EstimatorTraitConst for core::Ptr<crate::stitching::Detail_Estimator> {
		#[inline] fn as_raw_Detail_Estimator(&self) -> *const c_void { self.inner_as_raw() }
	}

	impl crate::stitching::Detail_EstimatorTrait for core::Ptr<crate::stitchi