/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;

public class FunctionBasedValidator<T>
implements Validator {
    private ValidationStatus validationStatus = new ValidationStatus();
    private Function<T, Optional<ValidationMessage>> validateFunction;

    private FunctionBasedValidator(ObservableValue<T> source) {
        source.addListener((observable, oldValue, newValue) -> this.validate(newValue));
    }

    public FunctionBasedValidator(ObservableValue<T> source, Function<T, ValidationMessage> function) {
        this(source);
        this.validateFunction = value -> Optional.ofNullable(function.apply(value));
        super.validate(source.getValue());
    }

    public FunctionBasedValidator(ObservableValue<T> source, Predicate<T> predicate, ValidationMessage message) {
        this(source);
        this.validateFunction = value -> Optional.ofNullable(predicate.test(value) ? null : message);
        super.validate(source.getValue());
    }

    private void validate(T newValue) {
        this.validationStatus.clearMessages();
        Optional<ValidationMessage> message = this.validateFunction.apply(newValue);
        message.ifPresent(this.validationStatus::addMessage);
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }
}

