/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SElement;
import de.undercouch.citeproc.csl.internal.SLayout;
import de.undercouch.citeproc.csl.internal.SSort;
import de.undercouch.citeproc.csl.internal.rendering.SNameInheritableAttributes;
import de.undercouch.citeproc.helper.NodeHelper;
import de.undercouch.citeproc.output.SecondFieldAlign;
import org.w3c.dom.Node;

public class SBibliography
implements SElement {
    private final SSort sort;
    private final SLayout layout;
    private final SecondFieldAlign secondFieldAlign;
    private final SNameInheritableAttributes inheritableNameAttributes;

    public SBibliography(Node node) {
        Node sortNode = NodeHelper.findDirectChild(node, "sort");
        this.sort = sortNode == null ? null : new SSort(sortNode);
        Node layoutNode = NodeHelper.findDirectChild(node, "layout");
        this.layout = layoutNode == null ? null : new SLayout(layoutNode);
        String strSecondFieldAlign = NodeHelper.getAttrValue(node, "second-field-align");
        this.secondFieldAlign = "flush".equals(strSecondFieldAlign) ? SecondFieldAlign.FLUSH : ("margin".equals(strSecondFieldAlign) ? SecondFieldAlign.MARGIN : SecondFieldAlign.FALSE);
        this.inheritableNameAttributes = new SNameInheritableAttributes(node);
    }

    public SSort getSort() {
        return this.sort;
    }

    public SecondFieldAlign getSecondFieldAlign() {
        return this.secondFieldAlign;
    }

    @Override
    public void render(RenderContext ctx) {
        if (this.layout != null) {
            this.inheritableNameAttributes.wrap(this.layout::render).accept(ctx);
        }
    }
}

