/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTStore;
import org.apache.lucene.util.fst.ReadWriteDataOutput;
import org.apache.lucene.util.fst.ReverseBytesReader;

public final class OnHeapFSTStore
implements FSTStore {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OnHeapFSTStore.class);
    private ReadWriteDataOutput dataOutput;
    private byte[] bytesArray;
    private final int maxBlockBits;

    public OnHeapFSTStore(int maxBlockBits) {
        if (maxBlockBits < 1 || maxBlockBits > 30) {
            throw new IllegalArgumentException("maxBlockBits should be 1 .. 30; got " + maxBlockBits);
        }
        this.maxBlockBits = maxBlockBits;
    }

    @Override
    public FSTStore init(DataInput in, long numBytes) throws IOException {
        if (numBytes > (long)(1 << this.maxBlockBits)) {
            this.dataOutput = (ReadWriteDataOutput)FSTCompiler.getOnHeapReaderWriter(this.maxBlockBits);
            this.dataOutput.copyBytes(in, numBytes);
            this.dataOutput.freeze();
        } else {
            this.bytesArray = new byte[(int)numBytes];
            in.readBytes(this.bytesArray, 0, this.bytesArray.length);
        }
        return this;
    }

    @Override
    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES_USED;
        size = this.bytesArray != null ? (size += (long)this.bytesArray.length) : (size += this.dataOutput.ramBytesUsed());
        return size;
    }

    @Override
    public FST.BytesReader getReverseBytesReader() {
        if (this.bytesArray != null) {
            return new ReverseBytesReader(this.bytesArray);
        }
        return this.dataOutput.getReverseBytesReader();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.dataOutput != null) {
            this.dataOutput.writeTo(out);
        } else {
            assert (this.bytesArray != null);
            out.writeBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }
}

