/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CalendarView;
import com.dlsc.gemsfx.daterange.DateRange;
import com.dlsc.gemsfx.daterange.DateRangePreset;
import com.dlsc.gemsfx.daterange.DateRangeView;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class DateRangeViewSkin
extends SkinBase<DateRangeView> {
    private final CalendarView startCalendarView;
    private final CalendarView endCalendarView;
    private final Label presetsTitleLabel;
    private final VBox presetsBox;
    private final Button applyButton;
    private final Button cancelButton;
    private final StackPane stackPane;
    private final HBox container;
    private final Label toLabel;
    private boolean updatingMonths;

    public DateRangeViewSkin(DateRangeView view) {
        super((Control)view);
        CalendarView.SelectionModel selectionModel = view.getSelectionModel();
        this.toLabel = new Label();
        this.toLabel.textProperty().bind((ObservableValue)view.toTextProperty());
        this.toLabel.getStyleClass().add((Object)"to-label");
        this.toLabel.setMouseTransparent(true);
        this.startCalendarView = view.getStartCalendarView();
        this.endCalendarView = view.getEndCalendarView();
        this.startCalendarView.latestDateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            YearMonth month = this.endCalendarView.getYearMonth().minusMonths(1L);
            return month.atDay(month.lengthOfMonth());
        }, (Observable[])new Observable[]{this.endCalendarView.yearMonthProperty()}));
        this.endCalendarView.earliestDateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            YearMonth month = this.startCalendarView.getYearMonth().plusMonths(1L);
            return month.atDay(1);
        }, (Observable[])new Observable[]{this.startCalendarView.yearMonthProperty()}));
        this.startCalendarView.disableNextMonthButtonProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.startCalendarView.getYearMonth().equals(this.endCalendarView.getYearMonth().minusMonths(1L)), (Observable[])new Observable[]{this.startCalendarView.yearMonthProperty(), this.endCalendarView.yearMonthProperty()}));
        this.endCalendarView.disablePreviousMonthButtonProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.startCalendarView.getYearMonth().equals(this.endCalendarView.getYearMonth().minusMonths(1L)), (Observable[])new Observable[]{this.startCalendarView.yearMonthProperty(), this.endCalendarView.yearMonthProperty()}));
        this.startCalendarView.yearMonthProperty().addListener((obs, oldStartMonth, newStartMonth) -> {
            YearMonth endMonth = this.endCalendarView.getYearMonth();
            if (!newStartMonth.isBefore(endMonth) && !this.updatingMonths) {
                this.startCalendarView.setYearMonth((YearMonth)oldStartMonth);
            }
        });
        this.endCalendarView.yearMonthProperty().addListener((obs, oldEndMonth, newEndMonth) -> {
            YearMonth startMonth = this.startCalendarView.getYearMonth();
            if (!newEndMonth.isAfter(startMonth) && !this.updatingMonths) {
                this.endCalendarView.setYearMonth((YearMonth)oldEndMonth);
            }
        });
        this.presetsTitleLabel = new Label();
        this.presetsTitleLabel.textProperty().bind((ObservableValue)view.presetTitleProperty());
        this.presetsTitleLabel.getStyleClass().add((Object)"presets-title");
        this.presetsTitleLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.presetsTitleLabel.visibleProperty().bind((ObservableValue)this.presetsTitleLabel.textProperty().isNotEmpty());
        this.presetsTitleLabel.managedProperty().bind((ObservableValue)this.presetsTitleLabel.textProperty().isNotEmpty());
        this.applyButton = new Button();
        this.applyButton.textProperty().bind((ObservableValue)view.applyTextProperty());
        this.applyButton.getStyleClass().add((Object)"apply-button");
        this.applyButton.setMinWidth(Double.NEGATIVE_INFINITY);
        this.applyButton.setMaxWidth(Double.MAX_VALUE);
        this.applyButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (!selectionModel.getSelectedDates().isEmpty() && !this.endCalendarView.getSelectionModel().getSelectedDates().isEmpty()) {
                LocalDate st = selectionModel.getSelectedDate();
                LocalDate et = selectionModel.getSelectedEndDate();
                return et.isBefore(st);
            }
            return false;
        }, (Observable[])new Observable[]{selectionModel.getSelectedDates(), this.endCalendarView.getSelectionModel().getSelectedDates()}));
        this.applyButton.setOnAction(evt -> {
            LocalDate endDate = selectionModel.getSelectedEndDate();
            DateRange selectedDateRange = endDate == null ? new DateRange(selectionModel.getSelectedDate()) : new DateRange(selectionModel.getSelectedDate(), endDate);
            boolean foundPreset = false;
            for (DateRangePreset preset : view.getPresets()) {
                DateRange dateRange = preset.getDateRangeSupplier().get();
                if (!Objects.equals(dateRange.getStartDate(), selectedDateRange.getStartDate()) || !Objects.equals(dateRange.getEndDate(), selectedDateRange.getEndDate())) continue;
                view.setValue(dateRange);
                foundPreset = true;
            }
            if (!foundPreset) {
                view.setValue(selectedDateRange);
            }
            view.getOnClose().run();
        });
        this.cancelButton = new Button();
        this.cancelButton.textProperty().bind((ObservableValue)view.cancelTextProperty());
        this.cancelButton.getStyleClass().add((Object)"cancel-button");
        this.cancelButton.setMinWidth(Double.NEGATIVE_INFINITY);
        this.cancelButton.setMaxWidth(Double.MAX_VALUE);
        this.cancelButton.setOnAction(evt -> view.getOnClose().run());
        this.presetsBox = new VBox();
        this.presetsBox.getStyleClass().add((Object)"presets-box");
        this.presetsBox.setFillWidth(true);
        this.presetsBox.visibleProperty().bind((ObservableValue)view.showPresetsProperty());
        this.presetsBox.managedProperty().bind((ObservableValue)view.showPresetsProperty());
        this.presetsBox.setMinWidth(Double.NEGATIVE_INFINITY);
        this.stackPane = new StackPane();
        this.stackPane.getStyleClass().add((Object)"stack-pane");
        this.container = new HBox();
        this.container.getStyleClass().add((Object)"range-view-container");
        this.container.setFillHeight(true);
        HBox.setHgrow((Node)this.startCalendarView, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.endCalendarView, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.presetsBox, (Priority)Priority.ALWAYS);
        view.valueProperty().addListener((obs, oldRange, newRange) -> {
            if (newRange != null) {
                this.applyRangeToMonthViews((DateRange)newRange);
            } else {
                view.setValue((DateRange)oldRange);
            }
        });
        view.getPresets().addListener(it -> this.updatePresetsView());
        view.orientationProperty().addListener(it -> this.updateCalendarLayout());
        view.presetsLocationProperty().addListener(it -> this.updateLayout());
        this.getChildren().add((Object)this.container);
        this.updatePresetsView();
        this.updateCalendarLayout();
        this.updateLayout();
        this.applyRangeToMonthViews(view.getValue());
    }

    private void updateLayout() {
        Side quickSelectPosition = ((DateRangeView)this.getSkinnable()).getPresetsLocation();
        if (quickSelectPosition.equals((Object)Side.LEFT)) {
            this.container.getChildren().setAll((Object[])new Node[]{this.presetsBox, this.stackPane});
        } else {
            this.container.getChildren().setAll((Object[])new Node[]{this.stackPane, this.presetsBox});
        }
    }

    private void updateCalendarLayout() {
        DateRangeView view = (DateRangeView)this.getSkinnable();
        if (view.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            HBox monthsBox = new HBox(new Node[]{this.startCalendarView, this.endCalendarView});
            monthsBox.getStyleClass().add((Object)"months-box");
            this.stackPane.getChildren().setAll((Object[])new Node[]{monthsBox, this.toLabel});
        } else {
            VBox monthsBox = new VBox(new Node[]{this.startCalendarView, this.endCalendarView});
            monthsBox.getStyleClass().add((Object)"months-box");
            this.stackPane.getChildren().setAll((Object[])new Node[]{monthsBox, this.toLabel});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRangeToMonthViews(DateRange newRange) {
        CalendarView.SelectionModel selectionModel = ((DateRangeView)this.getSkinnable()).getSelectionModel();
        selectionModel.clearSelection();
        if (newRange != null) {
            selectionModel.select(newRange.getStartDate());
            selectionModel.select(newRange.getEndDate());
            YearMonth fromMonth = YearMonth.from(newRange.getStartDate());
            YearMonth toMonth = YearMonth.from(newRange.getEndDate());
            try {
                this.updatingMonths = true;
                if (fromMonth.isBefore(toMonth)) {
                    this.startCalendarView.setYearMonth(fromMonth);
                    this.endCalendarView.setYearMonth(toMonth);
                } else {
                    this.startCalendarView.setYearMonth(fromMonth);
                    this.endCalendarView.setYearMonth(fromMonth.plusMonths(1L));
                }
            }
            finally {
                this.updatingMonths = false;
            }
        }
    }

    private void updatePresetsView() {
        DateRangeView view = (DateRangeView)this.getSkinnable();
        this.presetsBox.getChildren().clear();
        this.presetsBox.getChildren().add((Object)this.presetsTitleLabel);
        ObservableList<DateRangePreset> presets = view.getPresets();
        for (int i = 0; i < presets.size(); ++i) {
            DateRangePreset rangePreset = (DateRangePreset)presets.get(i);
            Label l = new Label(rangePreset.getTitle());
            l.getStyleClass().add((Object)"preset-name-label");
            l.setOnMouseClicked(evt -> this.applyRangeToMonthViews(rangePreset.getDateRangeSupplier().get()));
            this.presetsBox.getChildren().add((Object)l);
            if (i >= presets.size() - 1) continue;
            Separator separator = new Separator(Orientation.HORIZONTAL);
            this.presetsBox.getChildren().add((Object)separator);
        }
        Region filler = new Region();
        VBox.setVgrow((Node)filler, (Priority)Priority.ALWAYS);
        this.presetsBox.getChildren().add((Object)filler);
        this.applyButton.setMaxWidth(Double.MAX_VALUE);
        this.applyButton.setMinWidth(Double.NEGATIVE_INFINITY);
        this.cancelButton.setMaxWidth(Double.MAX_VALUE);
        this.cancelButton.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)this.applyButton, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.cancelButton, (Priority)Priority.ALWAYS);
        HBox buttonBar = new HBox(new Node[]{this.applyButton, this.cancelButton});
        buttonBar.visibleProperty().bind((ObservableValue)view.showCancelAndApplyButtonProperty());
        buttonBar.managedProperty().bind((ObservableValue)view.showCancelAndApplyButtonProperty());
        buttonBar.getStyleClass().add((Object)"buttons-box");
        this.presetsBox.getChildren().add((Object)buttonBar);
    }
}

