/*
 * Decompiled with CFR 0.152.
 */
package net.synedra.validatorfx;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.transform.Transform;
import net.synedra.validatorfx.Decoration;
import net.synedra.validatorfx.GraphicDecorationStackPane;

public class GraphicDecoration
implements Decoration {
    private Node decoratedNode;
    private final Node decorationNode;
    private final Pos pos;
    private final double xOffset;
    private final double yOffset;
    private final ChangeListener<Boolean> layoutListener;
    private final ChangeListener<Transform> transformListener;
    private ChangeListener<Scene> sceneChangedListener;
    private GraphicDecorationStackPane stack;

    public GraphicDecoration(Node decorationNode) {
        this(decorationNode, Pos.TOP_LEFT);
    }

    public GraphicDecoration(Node decorationNode, Pos position) {
        this(decorationNode, position, 0.0, 0.0);
    }

    public GraphicDecoration(Node decorationNode, Pos position, double xOffset, double yOffset) {
        this.decorationNode = decorationNode;
        this.decorationNode.setManaged(false);
        this.pos = position;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.layoutListener = new WeakChangeListener((observable, oldValue, newValue) -> this.layoutGraphic());
        this.transformListener = (observable, oldValue, newValue) -> this.layoutGraphic();
    }

    public static void updateDecorations(Node node) {
        GraphicDecorationStackPane decorationPane = GraphicDecoration.findDecorationPane(node);
        if (decorationPane != null) {
            decorationPane.requestLayout();
        }
    }

    @Override
    public void add(Node target) {
        this.decoratedNode = target;
        this.withStack(() -> {
            if (this.decoratedNode != null) {
                this.setListener();
                this.layoutGraphic();
            }
        }, target);
    }

    @Override
    public void remove(Node target) {
        if (this.stack != null) {
            this.stack.getChildren().remove((Object)this.decorationNode);
            this.stack.needsLayoutProperty().removeListener(this.layoutListener);
        }
        this.decoratedNode = null;
        target.localToSceneTransformProperty().removeListener(this.transformListener);
    }

    private void withStack(Runnable code, Node target) {
        this.stack = GraphicDecoration.findDecorationPane(target);
        if (this.stack == null) {
            if (target.getScene() == null) {
                this.sceneChangedListener = (observable, oldValue, newValue) -> {
                    if (oldValue == null && newValue != null) {
                        target.sceneProperty().removeListener(this.sceneChangedListener);
                        this.stack = GraphicDecoration.findDecorationPane(target);
                        if (this.stack == null) {
                            this.setupStack(target);
                        }
                        code.run();
                    }
                };
                target.sceneProperty().addListener(this.sceneChangedListener);
            } else {
                this.setupStack(target);
                code.run();
            }
        } else {
            code.run();
        }
    }

    private static GraphicDecorationStackPane findDecorationPane(Node node) {
        Parent parent;
        for (parent = node.getParent(); parent != null && !(parent instanceof GraphicDecorationStackPane); parent = parent.getParent()) {
        }
        return (GraphicDecorationStackPane)parent;
    }

    private void setupStack(Node target) {
        this.stack = new GraphicDecorationStackPane();
        Parent oldRoot = target.getScene().getRoot();
        target.getScene().setRoot((Parent)this.stack);
        this.stack.getChildren().add((Object)oldRoot);
    }

    private void setListener() {
        this.stack.needsLayoutProperty().removeListener(this.layoutListener);
        this.stack.needsLayoutProperty().addListener(this.layoutListener);
        this.decoratedNode.localToSceneTransformProperty().removeListener(this.transformListener);
        this.decoratedNode.localToSceneTransformProperty().addListener(this.transformListener);
    }

    private void layoutGraphic() {
        double targetHeight;
        this.decorationNode.autosize();
        Bounds decorationNodeLayoutBounds = this.decorationNode.getLayoutBounds();
        double decorationNodeWidth = decorationNodeLayoutBounds.getWidth();
        double decorationNodeHeight = decorationNodeLayoutBounds.getHeight();
        Bounds targetBounds = this.decoratedNode.getLayoutBounds();
        double x = targetBounds.getMinX();
        double y = targetBounds.getMinY();
        double targetWidth = targetBounds.getWidth();
        if (targetWidth <= 0.0) {
            targetWidth = this.decoratedNode.prefWidth(-1.0);
        }
        if ((targetHeight = targetBounds.getHeight()) <= 0.0) {
            targetHeight = this.decoratedNode.prefHeight(-1.0);
        }
        switch (this.pos.getHpos()) {
            case CENTER: {
                x += targetWidth / 2.0 - decorationNodeWidth / 2.0;
                break;
            }
            case LEFT: {
                x -= decorationNodeWidth / 2.0;
                break;
            }
            case RIGHT: {
                x += targetWidth - decorationNodeWidth / 2.0;
            }
        }
        switch (this.pos.getVpos()) {
            case CENTER: {
                y += targetHeight / 2.0 - decorationNodeHeight / 2.0;
                break;
            }
            case TOP: {
                y -= decorationNodeHeight / 2.0;
                break;
            }
            case BOTTOM: {
                y += targetHeight - decorationNodeHeight / 2.0;
                break;
            }
            case BASELINE: {
                y += this.decoratedNode.getBaselineOffset() - this.decorationNode.getBaselineOffset() - decorationNodeHeight / 2.0;
            }
        }
        Bounds sceneBounds = this.decoratedNode.localToScene(targetBounds);
        Bounds stackBounds = this.stack.sceneToLocal(sceneBounds);
        this.decorationNode.setLayoutX((double)Math.round(x + this.xOffset + stackBounds.getMinX()));
        this.decorationNode.setLayoutY((double)Math.round(y + this.yOffset + stackBounds.getMinY()));
        this.addOrRemoveDecorationNodeToStack();
    }

    private void addOrRemoveDecorationNodeToStack() {
        boolean isThere;
        boolean shouldBeThere;
        if (this.stack != null && (shouldBeThere = this.decoratedNode.getScene() != null && this.targetVisible()) != (isThere = this.stack.getChildren().contains((Object)this.decorationNode))) {
            if (shouldBeThere) {
                this.stack.getChildren().add((Object)this.decorationNode);
            } else {
                Platform.runLater(() -> this.stack.getChildren().remove((Object)this.decorationNode));
            }
        }
    }

    private boolean targetVisible() {
        boolean visible = true;
        for (Node node = this.decoratedNode; visible && node != null; node = node.getParent()) {
            visible = node.isVisible();
        }
        return visible;
    }
}

