/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.jeuclid;

import java.io.File;
import java.io.OutputStream;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import uk.ac.ed.ph.snuggletex.jeuclid.MathMLImageSavingCallback;

public abstract class SimpleMathMLImageSavingCallback
implements MathMLImageSavingCallback {
    public static String DEFAULT_FONT_SIZE = "16.0";
    public static String DEFAULT_CONTENT_TYPE = "image/png";
    public static boolean DEFAULT_ANTI_ALIASING = true;
    private String fontSize;
    private boolean antiAliasing;
    private String imageContentType;
    private final LayoutContextImpl layoutContext = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());

    public SimpleMathMLImageSavingCallback() {
        this.setFontSize(DEFAULT_FONT_SIZE);
        this.setImageContentType(DEFAULT_CONTENT_TYPE);
        this.setAntiAliasing(DEFAULT_ANTI_ALIASING);
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
        this.layoutContext.setParameter(Parameter.MATHSIZE, (Object)Float.valueOf(fontSize));
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
        this.layoutContext.setParameter(Parameter.ANTIALIAS, (Object)antiAliasing);
    }

    public String getImageContentType() {
        return this.imageContentType;
    }

    public void setImageContentType(String imageType) {
        this.imageContentType = imageType;
    }

    @Override
    public final String getImageContentType(int mathmlCounter) {
        return this.imageContentType;
    }

    @Override
    public final MutableLayoutContext getLayoutContext(int mathmlCounter) {
        return this.layoutContext;
    }

    @Override
    public abstract File getImageOutputFile(int var1);

    @Override
    public abstract OutputStream getImageOutputStream(int var1);

    @Override
    public abstract String getImageURL(int var1);

    @Override
    public void imageSavingSucceeded(Object imageFileOrOutputStream, int mathmlCounter, String contentType) {
    }
}

