/// <reference path="./xlib-2.0.d.ts" />
/// <reference path="./gdk-3.0.d.ts" />
/// <reference path="./cairo-1.0.d.ts" />
/// <reference path="./cairo.d.ts" />
/// <reference path="./gobject-2.0.d.ts" />
/// <reference path="./glib-2.0.d.ts" />
/// <reference path="./pango-1.0.d.ts" />
/// <reference path="./harfbuzz-0.0.d.ts" />
/// <reference path="./freetype2-2.0.d.ts" />
/// <reference path="./gio-2.0.d.ts" />
/// <reference path="./gmodule-2.0.d.ts" />
/// <reference path="./gdkpixbuf-2.0.d.ts" />
/// <reference path="./atk-1.0.d.ts" />

/**
 * Type Definitions for Gjs (https://gjs.guide/)
 *
 * These type definitions are automatically generated, do not edit them by hand.
 * If you found a bug fix it in `ts-for-gir` or create a bug report on https://github.com/gjsify/ts-for-gir
 *
 * The based EJS template file is used for the generated .d.ts file of each GIR module like Gtk-4.0, GObject-2.0, ...
 */

declare module 'gi://Gtk?version=3.0' {
    // Module dependencies
    import type xlib from 'gi://xlib?version=2.0';
    import type Gdk from 'gi://Gdk?version=3.0';
    import type cairo from 'cairo';
    import type GObject from 'gi://GObject?version=2.0';
    import type GLib from 'gi://GLib?version=2.0';
    import type Pango from 'gi://Pango?version=1.0';
    import type HarfBuzz from 'gi://HarfBuzz?version=0.0';
    import type freetype2 from 'gi://freetype2?version=2.0';
    import type Gio from 'gi://Gio?version=2.0';
    import type GModule from 'gi://GModule?version=2.0';
    import type GdkPixbuf from 'gi://GdkPixbuf?version=2.0';
    import type Atk from 'gi://Atk?version=1.0';

    export namespace Gtk {
        /**
         * Gtk-3.0
         */

        /**
         * Controls how a widget deals with extra space in a single (x or y)
         * dimension.
         *
         * Alignment only matters if the widget receives a “too large” allocation,
         * for example if you packed the widget with the #GtkWidget:expand
         * flag inside a #GtkBox, then the widget might get extra space.  If
         * you have for example a 16x16 icon inside a 32x32 space, the icon
         * could be scaled and stretched, it could be centered, or it could be
         * positioned to one side of the space.
         *
         * Note that in horizontal context `GTK_ALIGN_START` and `GTK_ALIGN_END`
         * are interpreted relative to text direction.
         *
         * GTK_ALIGN_BASELINE support for it is optional for containers and widgets, and
         * it is only supported for vertical alignment.  When its not supported by
         * a child or a container it is treated as `GTK_ALIGN_FILL`.
         */

        /**
         * Controls how a widget deals with extra space in a single (x or y)
         * dimension.
         *
         * Alignment only matters if the widget receives a “too large” allocation,
         * for example if you packed the widget with the #GtkWidget:expand
         * flag inside a #GtkBox, then the widget might get extra space.  If
         * you have for example a 16x16 icon inside a 32x32 space, the icon
         * could be scaled and stretched, it could be centered, or it could be
         * positioned to one side of the space.
         *
         * Note that in horizontal context `GTK_ALIGN_START` and `GTK_ALIGN_END`
         * are interpreted relative to text direction.
         *
         * GTK_ALIGN_BASELINE support for it is optional for containers and widgets, and
         * it is only supported for vertical alignment.  When its not supported by
         * a child or a container it is treated as `GTK_ALIGN_FILL`.
         */
        export namespace Align {
            export const $gtype: GObject.GType<Align>;
        }

        enum Align {
            /**
             * stretch to fill all space if possible, center if
             *     no meaningful way to stretch
             */
            FILL,
            /**
             * snap to left or top side, leaving space on right
             *     or bottom
             */
            START,
            /**
             * snap to right or bottom side, leaving space on left
             *     or top
             */
            END,
            /**
             * center natural width of widget inside the
             *     allocation
             */
            CENTER,
            /**
             * align the widget according to the baseline. Since 3.10.
             */
            BASELINE,
        }
        /**
         * Used to specify the placement of scroll arrows in scrolling menus.
         */

        /**
         * Used to specify the placement of scroll arrows in scrolling menus.
         */
        export namespace ArrowPlacement {
            export const $gtype: GObject.GType<ArrowPlacement>;
        }

        enum ArrowPlacement {
            /**
             * Place one arrow on each end of the menu.
             */
            BOTH,
            /**
             * Place both arrows at the top of the menu.
             */
            START,
            /**
             * Place both arrows at the bottom of the menu.
             */
            END,
        }
        /**
         * Used to indicate the direction in which an arrow should point.
         */

        /**
         * Used to indicate the direction in which an arrow should point.
         */
        export namespace ArrowType {
            export const $gtype: GObject.GType<ArrowType>;
        }

        enum ArrowType {
            /**
             * Represents an upward pointing arrow.
             */
            UP,
            /**
             * Represents a downward pointing arrow.
             */
            DOWN,
            /**
             * Represents a left pointing arrow.
             */
            LEFT,
            /**
             * Represents a right pointing arrow.
             */
            RIGHT,
            /**
             * No arrow. Since 2.10.
             */
            NONE,
        }
        /**
         * An enum for determining the page role inside the #GtkAssistant. It's
         * used to handle buttons sensitivity and visibility.
         *
         * Note that an assistant needs to end its page flow with a page of type
         * %GTK_ASSISTANT_PAGE_CONFIRM, %GTK_ASSISTANT_PAGE_SUMMARY or
         * %GTK_ASSISTANT_PAGE_PROGRESS to be correct.
         *
         * The Cancel button will only be shown if the page isn’t “committed”.
         * See gtk_assistant_commit() for details.
         */

        /**
         * An enum for determining the page role inside the #GtkAssistant. It's
         * used to handle buttons sensitivity and visibility.
         *
         * Note that an assistant needs to end its page flow with a page of type
         * %GTK_ASSISTANT_PAGE_CONFIRM, %GTK_ASSISTANT_PAGE_SUMMARY or
         * %GTK_ASSISTANT_PAGE_PROGRESS to be correct.
         *
         * The Cancel button will only be shown if the page isn’t “committed”.
         * See gtk_assistant_commit() for details.
         */
        export namespace AssistantPageType {
            export const $gtype: GObject.GType<AssistantPageType>;
        }

        enum AssistantPageType {
            /**
             * The page has regular contents. Both the
             *  Back and forward buttons will be shown.
             */
            CONTENT,
            /**
             * The page contains an introduction to the
             *  assistant task. Only the Forward button will be shown if there is a
             *   next page.
             */
            INTRO,
            /**
             * The page lets the user confirm or deny the
             *  changes. The Back and Apply buttons will be shown.
             */
            CONFIRM,
            /**
             * The page informs the user of the changes
             *  done. Only the Close button will be shown.
             */
            SUMMARY,
            /**
             * Used for tasks that take a long time to
             *  complete, blocks the assistant until the page is marked as complete.
             *   Only the back button will be shown.
             */
            PROGRESS,
            /**
             * Used for when other page types are not
             *  appropriate. No buttons will be shown, and the application must
             *  add its own buttons through gtk_assistant_add_action_widget().
             */
            CUSTOM,
        }
        /**
         * Whenever a container has some form of natural row it may align
         * children in that row along a common typographical baseline. If
         * the amount of verical space in the row is taller than the total
         * requested height of the baseline-aligned children then it can use a
         * #GtkBaselinePosition to select where to put the baseline inside the
         * extra availible space.
         */

        /**
         * Whenever a container has some form of natural row it may align
         * children in that row along a common typographical baseline. If
         * the amount of verical space in the row is taller than the total
         * requested height of the baseline-aligned children then it can use a
         * #GtkBaselinePosition to select where to put the baseline inside the
         * extra availible space.
         */
        export namespace BaselinePosition {
            export const $gtype: GObject.GType<BaselinePosition>;
        }

        enum BaselinePosition {
            /**
             * Align the baseline at the top
             */
            TOP,
            /**
             * Center the baseline
             */
            CENTER,
            /**
             * Align the baseline at the bottom
             */
            BOTTOM,
        }
        /**
         * Describes how the border of a UI element should be rendered.
         */

        /**
         * Describes how the border of a UI element should be rendered.
         */
        export namespace BorderStyle {
            export const $gtype: GObject.GType<BorderStyle>;
        }

        enum BorderStyle {
            /**
             * No visible border
             */
            NONE,
            /**
             * A single line segment
             */
            SOLID,
            /**
             * Looks as if the content is sunken into the canvas
             */
            INSET,
            /**
             * Looks as if the content is coming out of the canvas
             */
            OUTSET,
            /**
             * Same as `GTK_BORDER_STYLE_NONE`
             */
            HIDDEN,
            /**
             * A series of round dots
             */
            DOTTED,
            /**
             * A series of square-ended dashes
             */
            DASHED,
            /**
             * Two parallel lines with some space between them
             */
            DOUBLE,
            /**
             * Looks as if it were carved in the canvas
             */
            GROOVE,
            /**
             * Looks as if it were coming out of the canvas
             */
            RIDGE,
        }
        /**
         * Error codes that identify various errors that can occur while using
         * #GtkBuilder.
         */
        class BuilderError extends GLib.Error {
            static $gtype: GObject.GType<BuilderError>;

            // Static fields

            /**
             * A type-func attribute didn’t name
             *  a function that returns a #GType.
             */
            static INVALID_TYPE_FUNCTION: number;
            /**
             * The input contained a tag that #GtkBuilder
             *  can’t handle.
             */
            static UNHANDLED_TAG: number;
            /**
             * An attribute that is required by
             *  #GtkBuilder was missing.
             */
            static MISSING_ATTRIBUTE: number;
            /**
             * #GtkBuilder found an attribute that
             *  it doesn’t understand.
             */
            static INVALID_ATTRIBUTE: number;
            /**
             * #GtkBuilder found a tag that
             *  it doesn’t understand.
             */
            static INVALID_TAG: number;
            /**
             * A required property value was
             *  missing.
             */
            static MISSING_PROPERTY_VALUE: number;
            /**
             * #GtkBuilder couldn’t parse
             *  some attribute value.
             */
            static INVALID_VALUE: number;
            /**
             * The input file requires a newer version
             *  of GTK+.
             */
            static VERSION_MISMATCH: number;
            /**
             * An object id occurred twice.
             */
            static DUPLICATE_ID: number;
            /**
             * A specified object type is of the same type or
             *  derived from the type of the composite class being extended with builder XML.
             */
            static OBJECT_TYPE_REFUSED: number;
            /**
             * The wrong type was specified in a composite class’s template XML
             */
            static TEMPLATE_MISMATCH: number;
            /**
             * The specified property is unknown for the object class.
             */
            static INVALID_PROPERTY: number;
            /**
             * The specified signal is unknown for the object class.
             */
            static INVALID_SIGNAL: number;
            /**
             * An object id is unknown
             */
            static INVALID_ID: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            static quark(): GLib.Quark;
        }

        /**
         * Used to dictate the style that a #GtkButtonBox uses to layout the buttons it
         * contains.
         */

        /**
         * Used to dictate the style that a #GtkButtonBox uses to layout the buttons it
         * contains.
         */
        export namespace ButtonBoxStyle {
            export const $gtype: GObject.GType<ButtonBoxStyle>;
        }

        enum ButtonBoxStyle {
            /**
             * Buttons are evenly spread across the box.
             */
            SPREAD,
            /**
             * Buttons are placed at the edges of the box.
             */
            EDGE,
            /**
             * Buttons are grouped towards the start of the box,
             *   (on the left for a HBox, or the top for a VBox).
             */
            START,
            /**
             * Buttons are grouped towards the end of the box,
             *   (on the right for a HBox, or the bottom for a VBox).
             */
            END,
            /**
             * Buttons are centered in the box. Since 2.12.
             */
            CENTER,
            /**
             * Buttons expand to fill the box. This entails giving
             *   buttons a "linked" appearance, making button sizes homogeneous, and
             *   setting spacing to 0 (same as calling gtk_box_set_homogeneous() and
             *   gtk_box_set_spacing() manually). Since 3.12.
             */
            EXPAND,
        }
        /**
         * The role specifies the desired appearance of a #GtkModelButton.
         */

        /**
         * The role specifies the desired appearance of a #GtkModelButton.
         */
        export namespace ButtonRole {
            export const $gtype: GObject.GType<ButtonRole>;
        }

        enum ButtonRole {
            /**
             * A plain button
             */
            NORMAL,
            /**
             * A check button
             */
            CHECK,
            /**
             * A radio button
             */
            RADIO,
        }
        /**
         * Prebuilt sets of buttons for the dialog. If
         * none of these choices are appropriate, simply use %GTK_BUTTONS_NONE
         * then call gtk_dialog_add_buttons().
         *
         * > Please note that %GTK_BUTTONS_OK, %GTK_BUTTONS_YES_NO
         * > and %GTK_BUTTONS_OK_CANCEL are discouraged by the
         * > [GNOME Human Interface Guidelines](http://library.gnome.org/devel/hig-book/stable/).
         */

        /**
         * Prebuilt sets of buttons for the dialog. If
         * none of these choices are appropriate, simply use %GTK_BUTTONS_NONE
         * then call gtk_dialog_add_buttons().
         *
         * > Please note that %GTK_BUTTONS_OK, %GTK_BUTTONS_YES_NO
         * > and %GTK_BUTTONS_OK_CANCEL are discouraged by the
         * > [GNOME Human Interface Guidelines](http://library.gnome.org/devel/hig-book/stable/).
         */
        export namespace ButtonsType {
            export const $gtype: GObject.GType<ButtonsType>;
        }

        enum ButtonsType {
            /**
             * no buttons at all
             */
            NONE,
            /**
             * an OK button
             */
            OK,
            /**
             * a Close button
             */
            CLOSE,
            /**
             * a Cancel button
             */
            CANCEL,
            /**
             * Yes and No buttons
             */
            YES_NO,
            /**
             * OK and Cancel buttons
             */
            OK_CANCEL,
        }
        /**
         * Determines if the edited accelerators are GTK+ accelerators. If
         * they are, consumed modifiers are suppressed, only accelerators
         * accepted by GTK+ are allowed, and the accelerators are rendered
         * in the same way as they are in menus.
         */

        /**
         * Determines if the edited accelerators are GTK+ accelerators. If
         * they are, consumed modifiers are suppressed, only accelerators
         * accepted by GTK+ are allowed, and the accelerators are rendered
         * in the same way as they are in menus.
         */
        export namespace CellRendererAccelMode {
            export const $gtype: GObject.GType<CellRendererAccelMode>;
        }

        enum CellRendererAccelMode {
            /**
             * GTK+ accelerators mode
             */
            GTK,
            /**
             * Other accelerator mode
             */
            OTHER,
        }
        /**
         * Identifies how the user can interact with a particular cell.
         */

        /**
         * Identifies how the user can interact with a particular cell.
         */
        export namespace CellRendererMode {
            export const $gtype: GObject.GType<CellRendererMode>;
        }

        enum CellRendererMode {
            /**
             * The cell is just for display
             *  and cannot be interacted with.  Note that this doesn’t mean that eg. the
             *  row being drawn can’t be selected -- just that a particular element of
             *  it cannot be individually modified.
             */
            INERT,
            /**
             * The cell can be clicked.
             */
            ACTIVATABLE,
            /**
             * The cell can be edited or otherwise modified.
             */
            EDITABLE,
        }
        /**
         * Specifies which corner a child widget should be placed in when packed into
         * a #GtkScrolledWindow. This is effectively the opposite of where the scroll
         * bars are placed.
         */

        /**
         * Specifies which corner a child widget should be placed in when packed into
         * a #GtkScrolledWindow. This is effectively the opposite of where the scroll
         * bars are placed.
         */
        export namespace CornerType {
            export const $gtype: GObject.GType<CornerType>;
        }

        enum CornerType {
            /**
             * Place the scrollbars on the right and bottom of the
             *  widget (default behaviour).
             */
            TOP_LEFT,
            /**
             * Place the scrollbars on the top and right of the
             *  widget.
             */
            BOTTOM_LEFT,
            /**
             * Place the scrollbars on the left and bottom of the
             *  widget.
             */
            TOP_RIGHT,
            /**
             * Place the scrollbars on the top and left of the
             *  widget.
             */
            BOTTOM_RIGHT,
        }
        /**
         * Error codes for %GTK_CSS_PROVIDER_ERROR.
         */
        class CssProviderError extends GLib.Error {
            static $gtype: GObject.GType<CssProviderError>;

            // Static fields

            /**
             * Failed.
             */
            static FAILED: number;
            /**
             * Syntax error.
             */
            static SYNTAX: number;
            /**
             * Import error.
             */
            static IMPORT: number;
            /**
             * Name error.
             */
            static NAME: number;
            /**
             * Deprecation error.
             */
            static DEPRECATED: number;
            /**
             * Unknown value.
             */
            static UNKNOWN_VALUE: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            static quark(): GLib.Quark;
        }

        /**
         * The different types of sections indicate parts of a CSS document as
         * parsed by GTK’s CSS parser. They are oriented towards the
         * [CSS Grammar](http://www.w3.org/TR/CSS21/grammar.html),
         * but may contain extensions.
         *
         * More types might be added in the future as the parser incorporates
         * more features.
         */

        /**
         * The different types of sections indicate parts of a CSS document as
         * parsed by GTK’s CSS parser. They are oriented towards the
         * [CSS Grammar](http://www.w3.org/TR/CSS21/grammar.html),
         * but may contain extensions.
         *
         * More types might be added in the future as the parser incorporates
         * more features.
         */
        export namespace CssSectionType {
            export const $gtype: GObject.GType<CssSectionType>;
        }

        enum CssSectionType {
            /**
             * The section describes a complete document.
             *   This section time is the only one where gtk_css_section_get_parent()
             *   might return %NULL.
             */
            DOCUMENT,
            /**
             * The section defines an import rule.
             */
            IMPORT,
            /**
             * The section defines a color. This
             *   is a GTK extension to CSS.
             */
            COLOR_DEFINITION,
            /**
             * The section defines a binding set. This
             *   is a GTK extension to CSS.
             */
            BINDING_SET,
            /**
             * The section defines a CSS ruleset.
             */
            RULESET,
            /**
             * The section defines a CSS selector.
             */
            SELECTOR,
            /**
             * The section defines the declaration of
             *   a CSS variable.
             */
            DECLARATION,
            /**
             * The section defines the value of a CSS declaration.
             */
            VALUE,
            /**
             * The section defines keyframes. See [CSS
             *   Animations](http://dev.w3.org/csswg/css3-animations/#keyframes) for details. Since 3.6
             */
            KEYFRAMES,
        }
        /**
         * See also: #GtkEntry::delete-from-cursor.
         */

        /**
         * See also: #GtkEntry::delete-from-cursor.
         */
        export namespace DeleteType {
            export const $gtype: GObject.GType<DeleteType>;
        }

        enum DeleteType {
            /**
             * Delete characters.
             */
            CHARS,
            /**
             * Delete only the portion of the word to the
             *   left/right of cursor if we’re in the middle of a word.
             */
            WORD_ENDS,
            /**
             * Delete words.
             */
            WORDS,
            /**
             * Delete display-lines. Display-lines
             *   refers to the visible lines, with respect to to the current line
             *   breaks. As opposed to paragraphs, which are defined by line
             *   breaks in the input.
             */
            DISPLAY_LINES,
            /**
             * Delete only the portion of the
             *   display-line to the left/right of cursor.
             */
            DISPLAY_LINE_ENDS,
            /**
             * Delete to the end of the
             *   paragraph. Like C-k in Emacs (or its reverse).
             */
            PARAGRAPH_ENDS,
            /**
             * Delete entire line. Like C-k in pico.
             */
            PARAGRAPHS,
            /**
             * Delete only whitespace. Like M-\ in Emacs.
             */
            WHITESPACE,
        }
        /**
         * Focus movement types.
         */

        /**
         * Focus movement types.
         */
        export namespace DirectionType {
            export const $gtype: GObject.GType<DirectionType>;
        }

        enum DirectionType {
            /**
             * Move forward.
             */
            TAB_FORWARD,
            /**
             * Move backward.
             */
            TAB_BACKWARD,
            /**
             * Move up.
             */
            UP,
            /**
             * Move down.
             */
            DOWN,
            /**
             * Move left.
             */
            LEFT,
            /**
             * Move right.
             */
            RIGHT,
        }
        /**
         * Gives an indication why a drag operation failed.
         * The value can by obtained by connecting to the
         * #GtkWidget::drag-failed signal.
         */

        /**
         * Gives an indication why a drag operation failed.
         * The value can by obtained by connecting to the
         * #GtkWidget::drag-failed signal.
         */
        export namespace DragResult {
            export const $gtype: GObject.GType<DragResult>;
        }

        enum DragResult {
            /**
             * The drag operation was successful.
             */
            SUCCESS,
            /**
             * No suitable drag target.
             */
            NO_TARGET,
            /**
             * The user cancelled the drag operation.
             */
            USER_CANCELLED,
            /**
             * The drag operation timed out.
             */
            TIMEOUT_EXPIRED,
            /**
             * The pointer or keyboard grab used
             *  for the drag operation was broken.
             */
            GRAB_BROKEN,
            /**
             * The drag operation failed due to some
             *  unspecified error.
             */
            ERROR,
        }
        /**
         * Specifies the side of the entry at which an icon is placed.
         */

        /**
         * Specifies the side of the entry at which an icon is placed.
         */
        export namespace EntryIconPosition {
            export const $gtype: GObject.GType<EntryIconPosition>;
        }

        enum EntryIconPosition {
            /**
             * At the beginning of the entry (depending on the text direction).
             */
            PRIMARY,
            /**
             * At the end of the entry (depending on the text direction).
             */
            SECONDARY,
        }
        /**
         * Describes the state of a #GdkEventSequence in a #GtkGesture.
         */

        /**
         * Describes the state of a #GdkEventSequence in a #GtkGesture.
         */
        export namespace EventSequenceState {
            export const $gtype: GObject.GType<EventSequenceState>;
        }

        enum EventSequenceState {
            /**
             * The sequence is handled, but not grabbed.
             */
            NONE,
            /**
             * The sequence is handled and grabbed.
             */
            CLAIMED,
            /**
             * The sequence is denied.
             */
            DENIED,
        }
        /**
         * Used to specify the style of the expanders drawn by a #GtkTreeView.
         */

        /**
         * Used to specify the style of the expanders drawn by a #GtkTreeView.
         */
        export namespace ExpanderStyle {
            export const $gtype: GObject.GType<ExpanderStyle>;
        }

        enum ExpanderStyle {
            /**
             * The style used for a collapsed subtree.
             */
            COLLAPSED,
            /**
             * Intermediate style used during animation.
             */
            SEMI_COLLAPSED,
            /**
             * Intermediate style used during animation.
             */
            SEMI_EXPANDED,
            /**
             * The style used for an expanded subtree.
             */
            EXPANDED,
        }
        /**
         * Describes whether a #GtkFileChooser is being used to open existing files
         * or to save to a possibly new file.
         */

        /**
         * Describes whether a #GtkFileChooser is being used to open existing files
         * or to save to a possibly new file.
         */
        export namespace FileChooserAction {
            export const $gtype: GObject.GType<FileChooserAction>;
        }

        enum FileChooserAction {
            /**
             * Indicates open mode.  The file chooser
             *  will only let the user pick an existing file.
             */
            OPEN,
            /**
             * Indicates save mode.  The file chooser
             *  will let the user pick an existing file, or type in a new
             *  filename.
             */
            SAVE,
            /**
             * Indicates an Open mode for
             *  selecting folders.  The file chooser will let the user pick an
             *  existing folder.
             */
            SELECT_FOLDER,
            /**
             * Indicates a mode for creating a
             *  new folder.  The file chooser will let the user name an existing or
             *  new folder.
             */
            CREATE_FOLDER,
        }
        /**
         * Used as a return value of handlers for the
         * #GtkFileChooser::confirm-overwrite signal of a #GtkFileChooser. This
         * value determines whether the file chooser will present the stock
         * confirmation dialog, accept the user’s choice of a filename, or
         * let the user choose another filename.
         */

        /**
         * Used as a return value of handlers for the
         * #GtkFileChooser::confirm-overwrite signal of a #GtkFileChooser. This
         * value determines whether the file chooser will present the stock
         * confirmation dialog, accept the user’s choice of a filename, or
         * let the user choose another filename.
         */
        export namespace FileChooserConfirmation {
            export const $gtype: GObject.GType<FileChooserConfirmation>;
        }

        enum FileChooserConfirmation {
            /**
             * The file chooser will present
             *  its stock dialog to confirm about overwriting an existing file.
             */
            CONFIRM,
            /**
             * The file chooser will
             *  terminate and accept the user’s choice of a file name.
             */
            ACCEPT_FILENAME,
            /**
             * The file chooser will
             *  continue running, so as to let the user select another file name.
             */
            SELECT_AGAIN,
        }
        /**
         * These identify the various errors that can occur while calling
         * #GtkFileChooser functions.
         */
        class FileChooserError extends GLib.Error {
            static $gtype: GObject.GType<FileChooserError>;

            // Static fields

            /**
             * Indicates that a file does not exist.
             */
            static NONEXISTENT: number;
            /**
             * Indicates a malformed filename.
             */
            static BAD_FILENAME: number;
            /**
             * Indicates a duplicate path (e.g. when
             *  adding a bookmark).
             */
            static ALREADY_EXISTS: number;
            /**
             * Indicates an incomplete hostname (e.g. "http://foo" without a slash after that).
             */
            static INCOMPLETE_HOSTNAME: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for #GtkFileChooser if necessary.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Style for input method preedit. See also
         * #GtkSettings:gtk-im-preedit-style
         */

        /**
         * Style for input method preedit. See also
         * #GtkSettings:gtk-im-preedit-style
         */
        export namespace IMPreeditStyle {
            export const $gtype: GObject.GType<IMPreeditStyle>;
        }

        enum IMPreeditStyle {
            /**
             * Deprecated
             */
            NOTHING,
            /**
             * Deprecated
             */
            CALLBACK,
            /**
             * Deprecated
             */
            NONE,
        }
        /**
         * Style for input method status. See also
         * #GtkSettings:gtk-im-status-style
         */

        /**
         * Style for input method status. See also
         * #GtkSettings:gtk-im-status-style
         */
        export namespace IMStatusStyle {
            export const $gtype: GObject.GType<IMStatusStyle>;
        }

        enum IMStatusStyle {
            /**
             * Deprecated
             */
            NOTHING,
            /**
             * Deprecated
             */
            CALLBACK,
            /**
             * Deprecated
             */
            NONE,
        }
        /**
         * Built-in stock icon sizes.
         */

        /**
         * Built-in stock icon sizes.
         */
        export namespace IconSize {
            export const $gtype: GObject.GType<IconSize>;
        }

        enum IconSize {
            /**
             * Invalid size.
             */
            INVALID,
            /**
             * Size appropriate for menus (16px).
             */
            MENU,
            /**
             * Size appropriate for small toolbars (16px).
             */
            SMALL_TOOLBAR,
            /**
             * Size appropriate for large toolbars (24px)
             */
            LARGE_TOOLBAR,
            /**
             * Size appropriate for buttons (16px)
             */
            BUTTON,
            /**
             * Size appropriate for drag and drop (32px)
             */
            DND,
            /**
             * Size appropriate for dialogs (48px)
             */
            DIALOG,
        }
        /**
         * Error codes for GtkIconTheme operations.
         */
        class IconThemeError extends GLib.Error {
            static $gtype: GObject.GType<IconThemeError>;

            // Static fields

            /**
             * The icon specified does not exist in the theme
             */
            static NOT_FOUND: number;
            /**
             * An unspecified error occurred.
             */
            static FAILED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            static quark(): GLib.Quark;
        }

        /**
         * An enum for determining where a dropped item goes.
         */

        /**
         * An enum for determining where a dropped item goes.
         */
        export namespace IconViewDropPosition {
            export const $gtype: GObject.GType<IconViewDropPosition>;
        }

        enum IconViewDropPosition {
            /**
             * no drop possible
             */
            NO_DROP,
            /**
             * dropped item replaces the item
             */
            DROP_INTO,
            /**
             * droppped item is inserted to the left
             */
            DROP_LEFT,
            /**
             * dropped item is inserted to the right
             */
            DROP_RIGHT,
            /**
             * dropped item is inserted above
             */
            DROP_ABOVE,
            /**
             * dropped item is inserted below
             */
            DROP_BELOW,
        }
        /**
         * Describes the image data representation used by a #GtkImage. If you
         * want to get the image from the widget, you can only get the
         * currently-stored representation. e.g.  if the
         * gtk_image_get_storage_type() returns #GTK_IMAGE_PIXBUF, then you can
         * call gtk_image_get_pixbuf() but not gtk_image_get_stock().  For empty
         * images, you can request any storage type (call any of the "get"
         * functions), but they will all return %NULL values.
         */

        /**
         * Describes the image data representation used by a #GtkImage. If you
         * want to get the image from the widget, you can only get the
         * currently-stored representation. e.g.  if the
         * gtk_image_get_storage_type() returns #GTK_IMAGE_PIXBUF, then you can
         * call gtk_image_get_pixbuf() but not gtk_image_get_stock().  For empty
         * images, you can request any storage type (call any of the "get"
         * functions), but they will all return %NULL values.
         */
        export namespace ImageType {
            export const $gtype: GObject.GType<ImageType>;
        }

        enum ImageType {
            /**
             * there is no image displayed by the widget
             */
            EMPTY,
            /**
             * the widget contains a #GdkPixbuf
             */
            PIXBUF,
            /**
             * the widget contains a [stock item name][gtkstock]
             */
            STOCK,
            /**
             * the widget contains a #GtkIconSet
             */
            ICON_SET,
            /**
             * the widget contains a #GdkPixbufAnimation
             */
            ANIMATION,
            /**
             * the widget contains a named icon.
             *  This image type was added in GTK+ 2.6
             */
            ICON_NAME,
            /**
             * the widget contains a #GIcon.
             *  This image type was added in GTK+ 2.14
             */
            GICON,
            /**
             * the widget contains a #cairo_surface_t.
             *  This image type was added in GTK+ 3.10
             */
            SURFACE,
        }
        /**
         * Describes primary purpose of the input widget. This information is
         * useful for on-screen keyboards and similar input methods to decide
         * which keys should be presented to the user.
         *
         * Note that the purpose is not meant to impose a totally strict rule
         * about allowed characters, and does not replace input validation.
         * It is fine for an on-screen keyboard to let the user override the
         * character set restriction that is expressed by the purpose. The
         * application is expected to validate the entry contents, even if
         * it specified a purpose.
         *
         * The difference between `GTK_INPUT_PURPOSE_DIGITS` and
         * `GTK_INPUT_PURPOSE_NUMBER` is that the former accepts only digits
         * while the latter also some punctuation (like commas or points, plus,
         * minus) and “e” or “E” as in 3.14E+000.
         *
         * This enumeration may be extended in the future; input methods should
         * interpret unknown values as “free form”.
         */

        /**
         * Describes primary purpose of the input widget. This information is
         * useful for on-screen keyboards and similar input methods to decide
         * which keys should be presented to the user.
         *
         * Note that the purpose is not meant to impose a totally strict rule
         * about allowed characters, and does not replace input validation.
         * It is fine for an on-screen keyboard to let the user override the
         * character set restriction that is expressed by the purpose. The
         * application is expected to validate the entry contents, even if
         * it specified a purpose.
         *
         * The difference between `GTK_INPUT_PURPOSE_DIGITS` and
         * `GTK_INPUT_PURPOSE_NUMBER` is that the former accepts only digits
         * while the latter also some punctuation (like commas or points, plus,
         * minus) and “e” or “E” as in 3.14E+000.
         *
         * This enumeration may be extended in the future; input methods should
         * interpret unknown values as “free form”.
         */
        export namespace InputPurpose {
            export const $gtype: GObject.GType<InputPurpose>;
        }

        enum InputPurpose {
            /**
             * Allow any character
             */
            FREE_FORM,
            /**
             * Allow only alphabetic characters
             */
            ALPHA,
            /**
             * Allow only digits
             */
            DIGITS,
            /**
             * Edited field expects numbers
             */
            NUMBER,
            /**
             * Edited field expects phone number
             */
            PHONE,
            /**
             * Edited field expects URL
             */
            URL,
            /**
             * Edited field expects email address
             */
            EMAIL,
            /**
             * Edited field expects the name of a person
             */
            NAME,
            /**
             * Like `GTK_INPUT_PURPOSE_FREE_FORM,` but characters are hidden
             */
            PASSWORD,
            /**
             * Like `GTK_INPUT_PURPOSE_DIGITS,` but characters are hidden
             */
            PIN,
            /**
             * Allow any character, in addition to control codes
             */
            TERMINAL,
        }
        /**
         * Used for justifying the text inside a #GtkLabel widget. (See also
         * #GtkAlignment).
         */

        /**
         * Used for justifying the text inside a #GtkLabel widget. (See also
         * #GtkAlignment).
         */
        export namespace Justification {
            export const $gtype: GObject.GType<Justification>;
        }

        enum Justification {
            /**
             * The text is placed at the left edge of the label.
             */
            LEFT,
            /**
             * The text is placed at the right edge of the label.
             */
            RIGHT,
            /**
             * The text is placed in the center of the label.
             */
            CENTER,
            /**
             * The text is placed is distributed across the label.
             */
            FILL,
        }
        /**
         * Describes how #GtkLevelBar contents should be rendered.
         * Note that this enumeration could be extended with additional modes
         * in the future.
         */

        /**
         * Describes how #GtkLevelBar contents should be rendered.
         * Note that this enumeration could be extended with additional modes
         * in the future.
         */
        export namespace LevelBarMode {
            export const $gtype: GObject.GType<LevelBarMode>;
        }

        enum LevelBarMode {
            /**
             * the bar has a continuous mode
             */
            CONTINUOUS,
            /**
             * the bar has a discrete mode
             */
            DISCRETE,
        }
        /**
         * The type of license for an application.
         *
         * This enumeration can be expanded at later date.
         */

        /**
         * The type of license for an application.
         *
         * This enumeration can be expanded at later date.
         */
        export namespace License {
            export const $gtype: GObject.GType<License>;
        }

        enum License {
            /**
             * No license specified
             */
            UNKNOWN,
            /**
             * A license text is going to be specified by the
             *   developer
             */
            CUSTOM,
            /**
             * The GNU General Public License, version 2.0 or later
             */
            GPL_2_0,
            /**
             * The GNU General Public License, version 3.0 or later
             */
            GPL_3_0,
            /**
             * The GNU Lesser General Public License, version 2.1 or later
             */
            LGPL_2_1,
            /**
             * The GNU Lesser General Public License, version 3.0 or later
             */
            LGPL_3_0,
            /**
             * The BSD standard license
             */
            BSD,
            /**
             * The MIT/X11 standard license
             */
            MIT_X11,
            /**
             * The Artistic License, version 2.0
             */
            ARTISTIC,
            /**
             * The GNU General Public License, version 2.0 only. Since 3.12.
             */
            GPL_2_0_ONLY,
            /**
             * The GNU General Public License, version 3.0 only. Since 3.12.
             */
            GPL_3_0_ONLY,
            /**
             * The GNU Lesser General Public License, version 2.1 only. Since 3.12.
             */
            LGPL_2_1_ONLY,
            /**
             * The GNU Lesser General Public License, version 3.0 only. Since 3.12.
             */
            LGPL_3_0_ONLY,
            /**
             * The GNU Affero General Public License, version 3.0 or later. Since: 3.22.
             */
            AGPL_3_0,
            /**
             * The GNU Affero General Public License, version 3.0 only. Since: 3.22.27.
             */
            AGPL_3_0_ONLY,
            /**
             * The 3-clause BSD licence. Since: 3.24.20.
             */
            BSD_3,
            /**
             * The Apache License, version 2.0. Since: 3.24.20.
             */
            APACHE_2_0,
            /**
             * The Mozilla Public License, version 2.0. Since: 3.24.20.
             */
            MPL_2_0,
        }
        /**
         * An enumeration representing directional movements within a menu.
         */

        /**
         * An enumeration representing directional movements within a menu.
         */
        export namespace MenuDirectionType {
            export const $gtype: GObject.GType<MenuDirectionType>;
        }

        enum MenuDirectionType {
            /**
             * To the parent menu shell
             */
            PARENT,
            /**
             * To the submenu, if any, associated with the item
             */
            CHILD,
            /**
             * To the next menu item
             */
            NEXT,
            /**
             * To the previous menu item
             */
            PREV,
        }
        /**
         * The type of message being displayed in the dialog.
         */

        /**
         * The type of message being displayed in the dialog.
         */
        export namespace MessageType {
            export const $gtype: GObject.GType<MessageType>;
        }

        enum MessageType {
            /**
             * Informational message
             */
            INFO,
            /**
             * Non-fatal warning message
             */
            WARNING,
            /**
             * Question requiring a choice
             */
            QUESTION,
            /**
             * Fatal error message
             */
            ERROR,
            /**
             * None of the above
             */
            OTHER,
        }

        export namespace MovementStep {
            export const $gtype: GObject.GType<MovementStep>;
        }

        enum MovementStep {
            /**
             * Move forward or back by graphemes
             */
            LOGICAL_POSITIONS,
            /**
             * Move left or right by graphemes
             */
            VISUAL_POSITIONS,
            /**
             * Move forward or back by words
             */
            WORDS,
            /**
             * Move up or down lines (wrapped lines)
             */
            DISPLAY_LINES,
            /**
             * Move to either end of a line
             */
            DISPLAY_LINE_ENDS,
            /**
             * Move up or down paragraphs (newline-ended lines)
             */
            PARAGRAPHS,
            /**
             * Move to either end of a paragraph
             */
            PARAGRAPH_ENDS,
            /**
             * Move by pages
             */
            PAGES,
            /**
             * Move to ends of the buffer
             */
            BUFFER_ENDS,
            /**
             * Move horizontally by pages
             */
            HORIZONTAL_PAGES,
        }

        export namespace NotebookTab {
            export const $gtype: GObject.GType<NotebookTab>;
        }

        enum NotebookTab {
            FIRST,
            LAST,
        }
        /**
         * Used to determine the layout of pages on a sheet when printing
         * multiple pages per sheet.
         */

        /**
         * Used to determine the layout of pages on a sheet when printing
         * multiple pages per sheet.
         */
        export namespace NumberUpLayout {
            export const $gtype: GObject.GType<NumberUpLayout>;
        }

        enum NumberUpLayout {
            /**
             * ![](layout-lrtb.png)
             */
            LRTB,
            /**
             * ![](layout-lrbt.png)
             */
            LRBT,
            /**
             * ![](layout-rltb.png)
             */
            RLTB,
            /**
             * ![](layout-rlbt.png)
             */
            RLBT,
            /**
             * ![](layout-tblr.png)
             */
            TBLR,
            /**
             * ![](layout-tbrl.png)
             */
            TBRL,
            /**
             * ![](layout-btlr.png)
             */
            BTLR,
            /**
             * ![](layout-btrl.png)
             */
            BTRL,
        }
        /**
         * Represents the orientation of widgets and other objects which can be switched
         * between horizontal and vertical orientation on the fly, like #GtkToolbar or
         * #GtkGesturePan.
         */

        /**
         * Represents the orientation of widgets and other objects which can be switched
         * between horizontal and vertical orientation on the fly, like #GtkToolbar or
         * #GtkGesturePan.
         */
        export namespace Orientation {
            export const $gtype: GObject.GType<Orientation>;
        }

        enum Orientation {
            /**
             * The element is in horizontal orientation.
             */
            HORIZONTAL,
            /**
             * The element is in vertical orientation.
             */
            VERTICAL,
        }
        /**
         * Determines how widgets should be packed inside menubars
         * and menuitems contained in menubars.
         */

        /**
         * Determines how widgets should be packed inside menubars
         * and menuitems contained in menubars.
         */
        export namespace PackDirection {
            export const $gtype: GObject.GType<PackDirection>;
        }

        enum PackDirection {
            /**
             * Widgets are packed left-to-right
             */
            LTR,
            /**
             * Widgets are packed right-to-left
             */
            RTL,
            /**
             * Widgets are packed top-to-bottom
             */
            TTB,
            /**
             * Widgets are packed bottom-to-top
             */
            BTT,
        }
        /**
         * Represents the packing location #GtkBox children. (See: #GtkVBox,
         * #GtkHBox, and #GtkButtonBox).
         */

        /**
         * Represents the packing location #GtkBox children. (See: #GtkVBox,
         * #GtkHBox, and #GtkButtonBox).
         */
        export namespace PackType {
            export const $gtype: GObject.GType<PackType>;
        }

        enum PackType {
            /**
             * The child is packed into the start of the box
             */
            START,
            /**
             * The child is packed into the end of the box
             */
            END,
        }
        /**
         * The type of a pad action.
         */

        /**
         * The type of a pad action.
         */
        export namespace PadActionType {
            export const $gtype: GObject.GType<PadActionType>;
        }

        enum PadActionType {
            /**
             * Action is triggered by a pad button
             */
            BUTTON,
            /**
             * Action is triggered by a pad ring
             */
            RING,
            /**
             * Action is triggered by a pad strip
             */
            STRIP,
        }
        /**
         * See also gtk_print_settings_set_orientation().
         */

        /**
         * See also gtk_print_settings_set_orientation().
         */
        export namespace PageOrientation {
            export const $gtype: GObject.GType<PageOrientation>;
        }

        enum PageOrientation {
            /**
             * Portrait mode.
             */
            PORTRAIT,
            /**
             * Landscape mode.
             */
            LANDSCAPE,
            /**
             * Reverse portrait mode.
             */
            REVERSE_PORTRAIT,
            /**
             * Reverse landscape mode.
             */
            REVERSE_LANDSCAPE,
        }
        /**
         * See also gtk_print_job_set_page_set().
         */

        /**
         * See also gtk_print_job_set_page_set().
         */
        export namespace PageSet {
            export const $gtype: GObject.GType<PageSet>;
        }

        enum PageSet {
            /**
             * All pages.
             */
            ALL,
            /**
             * Even pages.
             */
            EVEN,
            /**
             * Odd pages.
             */
            ODD,
        }
        /**
         * Describes the panning direction of a #GtkGesturePan
         */

        /**
         * Describes the panning direction of a #GtkGesturePan
         */
        export namespace PanDirection {
            export const $gtype: GObject.GType<PanDirection>;
        }

        enum PanDirection {
            /**
             * panned towards the left
             */
            LEFT,
            /**
             * panned towards the right
             */
            RIGHT,
            /**
             * panned upwards
             */
            UP,
            /**
             * panned downwards
             */
            DOWN,
        }
        /**
         * Priorities for path lookups.
         * See also gtk_binding_set_add_path().
         */

        /**
         * Priorities for path lookups.
         * See also gtk_binding_set_add_path().
         */
        export namespace PathPriorityType {
            export const $gtype: GObject.GType<PathPriorityType>;
        }

        enum PathPriorityType {
            /**
             * Deprecated
             */
            LOWEST,
            /**
             * Deprecated
             */
            GTK,
            /**
             * Deprecated
             */
            APPLICATION,
            /**
             * Deprecated
             */
            THEME,
            /**
             * Deprecated
             */
            RC,
            /**
             * Deprecated
             */
            HIGHEST,
        }
        /**
         * Widget path types.
         * See also gtk_binding_set_add_path().
         */

        /**
         * Widget path types.
         * See also gtk_binding_set_add_path().
         */
        export namespace PathType {
            export const $gtype: GObject.GType<PathType>;
        }

        enum PathType {
            /**
             * Deprecated
             */
            WIDGET,
            /**
             * Deprecated
             */
            WIDGET_CLASS,
            /**
             * Deprecated
             */
            CLASS,
        }
        /**
         * Determines how the size should be computed to achieve the one of the
         * visibility mode for the scrollbars.
         */

        /**
         * Determines how the size should be computed to achieve the one of the
         * visibility mode for the scrollbars.
         */
        export namespace PolicyType {
            export const $gtype: GObject.GType<PolicyType>;
        }

        enum PolicyType {
            /**
             * The scrollbar is always visible. The view size is
             *  independent of the content.
             */
            ALWAYS,
            /**
             * The scrollbar will appear and disappear as necessary.
             *  For example, when all of a #GtkTreeView can not be seen.
             */
            AUTOMATIC,
            /**
             * The scrollbar should never appear. In this mode the
             *  content determines the size.
             */
            NEVER,
            /**
             * Don't show a scrollbar, but don't force the
             *  size to follow the content. This can be used e.g. to make multiple
             *  scrolled windows share a scrollbar. Since: 3.16
             */
            EXTERNAL,
        }
        /**
         * Describes constraints to positioning of popovers. More values
         * may be added to this enumeration in the future.
         */

        /**
         * Describes constraints to positioning of popovers. More values
         * may be added to this enumeration in the future.
         */
        export namespace PopoverConstraint {
            export const $gtype: GObject.GType<PopoverConstraint>;
        }

        enum PopoverConstraint {
            /**
             * Don't constrain the popover position
             *   beyond what is imposed by the implementation
             */
            NONE,
            /**
             * Constrain the popover to the boundaries
             *   of the window that it is attached to
             */
            WINDOW,
        }
        /**
         * Describes which edge of a widget a certain feature is positioned at, e.g. the
         * tabs of a #GtkNotebook, the handle of a #GtkHandleBox or the label of a
         * #GtkScale.
         */

        /**
         * Describes which edge of a widget a certain feature is positioned at, e.g. the
         * tabs of a #GtkNotebook, the handle of a #GtkHandleBox or the label of a
         * #GtkScale.
         */
        export namespace PositionType {
            export const $gtype: GObject.GType<PositionType>;
        }

        enum PositionType {
            /**
             * The feature is at the left edge.
             */
            LEFT,
            /**
             * The feature is at the right edge.
             */
            RIGHT,
            /**
             * The feature is at the top edge.
             */
            TOP,
            /**
             * The feature is at the bottom edge.
             */
            BOTTOM,
        }
        /**
         * See also gtk_print_settings_set_duplex().
         */

        /**
         * See also gtk_print_settings_set_duplex().
         */
        export namespace PrintDuplex {
            export const $gtype: GObject.GType<PrintDuplex>;
        }

        enum PrintDuplex {
            /**
             * No duplex.
             */
            SIMPLEX,
            /**
             * Horizontal duplex.
             */
            HORIZONTAL,
            /**
             * Vertical duplex.
             */
            VERTICAL,
        }
        /**
         * Error codes that identify various errors that can occur while
         * using the GTK+ printing support.
         */
        class PrintError extends GLib.Error {
            static $gtype: GObject.GType<PrintError>;

            // Static fields

            /**
             * An unspecified error occurred.
             */
            static GENERAL: number;
            /**
             * An internal error occurred.
             */
            static INTERNAL_ERROR: number;
            /**
             * A memory allocation failed.
             */
            static NOMEM: number;
            /**
             * An error occurred while loading a page setup
             *     or paper size from a key file.
             */
            static INVALID_FILE: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for #GtkPrintOperation if necessary.
             */
            static quark(): GLib.Quark;
        }

        /**
         * The `action` parameter to gtk_print_operation_run()
         * determines what action the print operation should perform.
         */

        /**
         * The `action` parameter to gtk_print_operation_run()
         * determines what action the print operation should perform.
         */
        export namespace PrintOperationAction {
            export const $gtype: GObject.GType<PrintOperationAction>;
        }

        enum PrintOperationAction {
            /**
             * Show the print dialog.
             */
            PRINT_DIALOG,
            /**
             * Start to print without showing
             *     the print dialog, based on the current print settings.
             */
            PRINT,
            /**
             * Show the print preview.
             */
            PREVIEW,
            /**
             * Export to a file. This requires
             *     the export-filename property to be set.
             */
            EXPORT,
        }
        /**
         * A value of this type is returned by gtk_print_operation_run().
         */

        /**
         * A value of this type is returned by gtk_print_operation_run().
         */
        export namespace PrintOperationResult {
            export const $gtype: GObject.GType<PrintOperationResult>;
        }

        enum PrintOperationResult {
            /**
             * An error has occurred.
             */
            ERROR,
            /**
             * The print settings should be stored.
             */
            APPLY,
            /**
             * The print operation has been canceled,
             *     the print settings should not be stored.
             */
            CANCEL,
            /**
             * The print operation is not complete
             *     yet. This value will only be returned when running asynchronously.
             */
            IN_PROGRESS,
        }
        /**
         * See also gtk_print_job_set_pages()
         */

        /**
         * See also gtk_print_job_set_pages()
         */
        export namespace PrintPages {
            export const $gtype: GObject.GType<PrintPages>;
        }

        enum PrintPages {
            /**
             * All pages.
             */
            ALL,
            /**
             * Current page.
             */
            CURRENT,
            /**
             * Range of pages.
             */
            RANGES,
            /**
             * Selected pages.
             */
            SELECTION,
        }
        /**
         * See also gtk_print_settings_set_quality().
         */

        /**
         * See also gtk_print_settings_set_quality().
         */
        export namespace PrintQuality {
            export const $gtype: GObject.GType<PrintQuality>;
        }

        enum PrintQuality {
            /**
             * Low quality.
             */
            LOW,
            /**
             * Normal quality.
             */
            NORMAL,
            /**
             * High quality.
             */
            HIGH,
            /**
             * Draft quality.
             */
            DRAFT,
        }
        /**
         * The status gives a rough indication of the completion of a running
         * print operation.
         */

        /**
         * The status gives a rough indication of the completion of a running
         * print operation.
         */
        export namespace PrintStatus {
            export const $gtype: GObject.GType<PrintStatus>;
        }

        enum PrintStatus {
            /**
             * The printing has not started yet; this
             *     status is set initially, and while the print dialog is shown.
             */
            INITIAL,
            /**
             * This status is set while the begin-print
             *     signal is emitted and during pagination.
             */
            PREPARING,
            /**
             * This status is set while the
             *     pages are being rendered.
             */
            GENERATING_DATA,
            /**
             * The print job is being sent off to the
             *     printer.
             */
            SENDING_DATA,
            /**
             * The print job has been sent to the printer,
             *     but is not printed for some reason, e.g. the printer may be stopped.
             */
            PENDING,
            /**
             * Some problem has occurred during
             *     printing, e.g. a paper jam.
             */
            PENDING_ISSUE,
            /**
             * The printer is processing the print job.
             */
            PRINTING,
            /**
             * The printing has been completed successfully.
             */
            FINISHED,
            /**
             * The printing has been aborted.
             */
            FINISHED_ABORTED,
        }
        /**
         * Describes the stage at which events are fed into a #GtkEventController.
         */

        /**
         * Describes the stage at which events are fed into a #GtkEventController.
         */
        export namespace PropagationPhase {
            export const $gtype: GObject.GType<PropagationPhase>;
        }

        enum PropagationPhase {
            /**
             * Events are not delivered automatically. Those can be
             *   manually fed through gtk_event_controller_handle_event(). This should
             *   only be used when full control about when, or whether the controller
             *   handles the event is needed.
             */
            NONE,
            /**
             * Events are delivered in the capture phase. The
             *   capture phase happens before the bubble phase, runs from the toplevel down
             *   to the event widget. This option should only be used on containers that
             *   might possibly handle events before their children do.
             */
            CAPTURE,
            /**
             * Events are delivered in the bubble phase. The bubble
             *   phase happens after the capture phase, and before the default handlers
             *   are run. This phase runs from the event widget, up to the toplevel.
             */
            BUBBLE,
            /**
             * Events are delivered in the default widget event handlers,
             *   note that widget implementations must chain up on button, motion, touch and
             *   grab broken handlers for controllers in this phase to be run.
             */
            TARGET,
        }
        /**
         * The #GtkRcTokenType enumeration represents the tokens
         * in the RC file. It is exposed so that theme engines
         * can reuse these tokens when parsing the theme-engine
         * specific portions of a RC file.
         */

        /**
         * The #GtkRcTokenType enumeration represents the tokens
         * in the RC file. It is exposed so that theme engines
         * can reuse these tokens when parsing the theme-engine
         * specific portions of a RC file.
         */
        export namespace RcTokenType {
            export const $gtype: GObject.GType<RcTokenType>;
        }

        enum RcTokenType {
            /**
             * Deprecated
             */
            INVALID,
            /**
             * Deprecated
             */
            INCLUDE,
            /**
             * Deprecated
             */
            NORMAL,
            /**
             * Deprecated
             */
            ACTIVE,
            /**
             * Deprecated
             */
            PRELIGHT,
            /**
             * Deprecated
             */
            SELECTED,
            /**
             * Deprecated
             */
            INSENSITIVE,
            /**
             * Deprecated
             */
            FG,
            /**
             * Deprecated
             */
            BG,
            /**
             * Deprecated
             */
            TEXT,
            /**
             * Deprecated
             */
            BASE,
            /**
             * Deprecated
             */
            XTHICKNESS,
            /**
             * Deprecated
             */
            YTHICKNESS,
            /**
             * Deprecated
             */
            FONT,
            /**
             * Deprecated
             */
            FONTSET,
            /**
             * Deprecated
             */
            FONT_NAME,
            /**
             * Deprecated
             */
            BG_PIXMAP,
            /**
             * Deprecated
             */
            PIXMAP_PATH,
            /**
             * Deprecated
             */
            STYLE,
            /**
             * Deprecated
             */
            BINDING,
            /**
             * Deprecated
             */
            BIND,
            /**
             * Deprecated
             */
            WIDGET,
            /**
             * Deprecated
             */
            WIDGET_CLASS,
            /**
             * Deprecated
             */
            CLASS,
            /**
             * Deprecated
             */
            LOWEST,
            /**
             * Deprecated
             */
            GTK,
            /**
             * Deprecated
             */
            APPLICATION,
            /**
             * Deprecated
             */
            THEME,
            /**
             * Deprecated
             */
            RC,
            /**
             * Deprecated
             */
            HIGHEST,
            /**
             * Deprecated
             */
            ENGINE,
            /**
             * Deprecated
             */
            MODULE_PATH,
            /**
             * Deprecated
             */
            IM_MODULE_PATH,
            /**
             * Deprecated
             */
            IM_MODULE_FILE,
            /**
             * Deprecated
             */
            STOCK,
            /**
             * Deprecated
             */
            LTR,
            /**
             * Deprecated
             */
            RTL,
            /**
             * Deprecated
             */
            COLOR,
            /**
             * Deprecated
             */
            UNBIND,
            /**
             * Deprecated
             */
            LAST,
        }
        /**
         * These identify the various errors that can occur while calling
         * #GtkRecentChooser functions.
         */
        class RecentChooserError extends GLib.Error {
            static $gtype: GObject.GType<RecentChooserError>;

            // Static fields

            /**
             * Indicates that a file does not exist
             */
            static NOT_FOUND: number;
            /**
             * Indicates a malformed URI
             */
            static INVALID_URI: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            static quark(): GLib.Quark;
        }

        /**
         * Error codes for #GtkRecentManager operations
         */
        class RecentManagerError extends GLib.Error {
            static $gtype: GObject.GType<RecentManagerError>;

            // Static fields

            /**
             * the URI specified does not exists in
             *   the recently used resources list.
             */
            static NOT_FOUND: number;
            /**
             * the URI specified is not valid.
             */
            static INVALID_URI: number;
            /**
             * the supplied string is not
             *   UTF-8 encoded.
             */
            static INVALID_ENCODING: number;
            /**
             * no application has registered
             *   the specified item.
             */
            static NOT_REGISTERED: number;
            /**
             * failure while reading the recently used
             *   resources file.
             */
            static READ: number;
            /**
             * failure while writing the recently used
             *   resources file.
             */
            static WRITE: number;
            /**
             * unspecified error.
             */
            static UNKNOWN: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            static quark(): GLib.Quark;
        }

        /**
         * Used to specify the sorting method to be applyed to the recently
         * used resource list.
         */

        /**
         * Used to specify the sorting method to be applyed to the recently
         * used resource list.
         */
        export namespace RecentSortType {
            export const $gtype: GObject.GType<RecentSortType>;
        }

        enum RecentSortType {
            /**
             * Do not sort the returned list of recently used
             *   resources.
             */
            NONE,
            /**
             * Sort the returned list with the most recently used
             *   items first.
             */
            MRU,
            /**
             * Sort the returned list with the least recently used
             *   items first.
             */
            LRU,
            /**
             * Sort the returned list using a custom sorting
             *   function passed using gtk_recent_chooser_set_sort_func().
             */
            CUSTOM,
        }
        /**
         * Indicated the relief to be drawn around a #GtkButton.
         */

        /**
         * Indicated the relief to be drawn around a #GtkButton.
         */
        export namespace ReliefStyle {
            export const $gtype: GObject.GType<ReliefStyle>;
        }

        enum ReliefStyle {
            /**
             * Draw a normal relief.
             */
            NORMAL,
            /**
             * A half relief. Deprecated in 3.14, does the same as `GTK_RELIEF_NORMAL`
             */
            HALF,
            /**
             * No relief.
             */
            NONE,
        }

        export namespace ResizeMode {
            export const $gtype: GObject.GType<ResizeMode>;
        }

        enum ResizeMode {
            /**
             * Pass resize request to the parent
             */
            PARENT,
            /**
             * Queue resizes on this widget
             */
            QUEUE,
            /**
             * Resize immediately. Deprecated.
             */
            IMMEDIATE,
        }
        /**
         * Predefined values for use as response ids in gtk_dialog_add_button().
         * All predefined values are negative; GTK+ leaves values of 0 or greater for
         * application-defined response ids.
         */

        /**
         * Predefined values for use as response ids in gtk_dialog_add_button().
         * All predefined values are negative; GTK+ leaves values of 0 or greater for
         * application-defined response ids.
         */
        export namespace ResponseType {
            export const $gtype: GObject.GType<ResponseType>;
        }

        enum ResponseType {
            /**
             * Returned if an action widget has no response id,
             *     or if the dialog gets programmatically hidden or destroyed
             */
            NONE,
            /**
             * Generic response id, not used by GTK+ dialogs
             */
            REJECT,
            /**
             * Generic response id, not used by GTK+ dialogs
             */
            ACCEPT,
            /**
             * Returned if the dialog is deleted
             */
            DELETE_EVENT,
            /**
             * Returned by OK buttons in GTK+ dialogs
             */
            OK,
            /**
             * Returned by Cancel buttons in GTK+ dialogs
             */
            CANCEL,
            /**
             * Returned by Close buttons in GTK+ dialogs
             */
            CLOSE,
            /**
             * Returned by Yes buttons in GTK+ dialogs
             */
            YES,
            /**
             * Returned by No buttons in GTK+ dialogs
             */
            NO,
            /**
             * Returned by Apply buttons in GTK+ dialogs
             */
            APPLY,
            /**
             * Returned by Help buttons in GTK+ dialogs
             */
            HELP,
        }
        /**
         * These enumeration values describe the possible transitions
         * when the child of a #GtkRevealer widget is shown or hidden.
         */

        /**
         * These enumeration values describe the possible transitions
         * when the child of a #GtkRevealer widget is shown or hidden.
         */
        export namespace RevealerTransitionType {
            export const $gtype: GObject.GType<RevealerTransitionType>;
        }

        enum RevealerTransitionType {
            /**
             * No transition
             */
            NONE,
            /**
             * Fade in
             */
            CROSSFADE,
            /**
             * Slide in from the left
             */
            SLIDE_RIGHT,
            /**
             * Slide in from the right
             */
            SLIDE_LEFT,
            /**
             * Slide in from the bottom
             */
            SLIDE_UP,
            /**
             * Slide in from the top
             */
            SLIDE_DOWN,
        }

        export namespace ScrollStep {
            export const $gtype: GObject.GType<ScrollStep>;
        }

        enum ScrollStep {
            /**
             * Scroll in steps.
             */
            STEPS,
            /**
             * Scroll by pages.
             */
            PAGES,
            /**
             * Scroll to ends.
             */
            ENDS,
            /**
             * Scroll in horizontal steps.
             */
            HORIZONTAL_STEPS,
            /**
             * Scroll by horizontal pages.
             */
            HORIZONTAL_PAGES,
            /**
             * Scroll to the horizontal ends.
             */
            HORIZONTAL_ENDS,
        }
        /**
         * Scrolling types.
         */

        /**
         * Scrolling types.
         */
        export namespace ScrollType {
            export const $gtype: GObject.GType<ScrollType>;
        }

        enum ScrollType {
            /**
             * No scrolling.
             */
            NONE,
            /**
             * Jump to new location.
             */
            JUMP,
            /**
             * Step backward.
             */
            STEP_BACKWARD,
            /**
             * Step forward.
             */
            STEP_FORWARD,
            /**
             * Page backward.
             */
            PAGE_BACKWARD,
            /**
             * Page forward.
             */
            PAGE_FORWARD,
            /**
             * Step up.
             */
            STEP_UP,
            /**
             * Step down.
             */
            STEP_DOWN,
            /**
             * Page up.
             */
            PAGE_UP,
            /**
             * Page down.
             */
            PAGE_DOWN,
            /**
             * Step to the left.
             */
            STEP_LEFT,
            /**
             * Step to the right.
             */
            STEP_RIGHT,
            /**
             * Page to the left.
             */
            PAGE_LEFT,
            /**
             * Page to the right.
             */
            PAGE_RIGHT,
            /**
             * Scroll to start.
             */
            START,
            /**
             * Scroll to end.
             */
            END,
        }
        /**
         * Defines the policy to be used in a scrollable widget when updating
         * the scrolled window adjustments in a given orientation.
         */

        /**
         * Defines the policy to be used in a scrollable widget when updating
         * the scrolled window adjustments in a given orientation.
         */
        export namespace ScrollablePolicy {
            export const $gtype: GObject.GType<ScrollablePolicy>;
        }

        enum ScrollablePolicy {
            /**
             * Scrollable adjustments are based on the minimum size
             */
            MINIMUM,
            /**
             * Scrollable adjustments are based on the natural size
             */
            NATURAL,
        }
        /**
         * Used to control what selections users are allowed to make.
         */

        /**
         * Used to control what selections users are allowed to make.
         */
        export namespace SelectionMode {
            export const $gtype: GObject.GType<SelectionMode>;
        }

        enum SelectionMode {
            /**
             * No selection is possible.
             */
            NONE,
            /**
             * Zero or one element may be selected.
             */
            SINGLE,
            /**
             * Exactly one element is selected.
             *     In some circumstances, such as initially or during a search
             *     operation, it’s possible for no element to be selected with
             *     %GTK_SELECTION_BROWSE. What is really enforced is that the user
             *     can’t deselect a currently selected element except by selecting
             *     another element.
             */
            BROWSE,
            /**
             * Any number of elements may be selected.
             *      The Ctrl key may be used to enlarge the selection, and Shift
             *      key to select between the focus and the child pointed to.
             *      Some widgets may also allow Click-drag to select a range of elements.
             */
            MULTIPLE,
        }
        /**
         * Determines how GTK+ handles the sensitivity of stepper arrows
         * at the end of range widgets.
         */

        /**
         * Determines how GTK+ handles the sensitivity of stepper arrows
         * at the end of range widgets.
         */
        export namespace SensitivityType {
            export const $gtype: GObject.GType<SensitivityType>;
        }

        enum SensitivityType {
            /**
             * The arrow is made insensitive if the
             *   thumb is at the end
             */
            AUTO,
            /**
             * The arrow is always sensitive
             */
            ON,
            /**
             * The arrow is always insensitive
             */
            OFF,
        }
        /**
         * Used to change the appearance of an outline typically provided by a #GtkFrame.
         *
         * Note that many themes do not differentiate the appearance of the
         * various shadow types: Either their is no visible shadow (`GTK_SHADOW_NONE)`,
         * or there is (any other value).
         */

        /**
         * Used to change the appearance of an outline typically provided by a #GtkFrame.
         *
         * Note that many themes do not differentiate the appearance of the
         * various shadow types: Either their is no visible shadow (`GTK_SHADOW_NONE)`,
         * or there is (any other value).
         */
        export namespace ShadowType {
            export const $gtype: GObject.GType<ShadowType>;
        }

        enum ShadowType {
            /**
             * No outline.
             */
            NONE,
            /**
             * The outline is bevelled inwards.
             */
            IN,
            /**
             * The outline is bevelled outwards like a button.
             */
            OUT,
            /**
             * The outline has a sunken 3d appearance.
             */
            ETCHED_IN,
            /**
             * The outline has a raised 3d appearance.
             */
            ETCHED_OUT,
        }
        /**
         * GtkShortcutType specifies the kind of shortcut that is being described.
         * More values may be added to this enumeration over time.
         */

        /**
         * GtkShortcutType specifies the kind of shortcut that is being described.
         * More values may be added to this enumeration over time.
         */
        export namespace ShortcutType {
            export const $gtype: GObject.GType<ShortcutType>;
        }

        enum ShortcutType {
            /**
             * The shortcut is a keyboard accelerator. The #GtkShortcutsShortcut:accelerator
             *   property will be used.
             */
            ACCELERATOR,
            /**
             * The shortcut is a pinch gesture. GTK+ provides an icon and subtitle.
             */
            GESTURE_PINCH,
            /**
             * The shortcut is a stretch gesture. GTK+ provides an icon and subtitle.
             */
            GESTURE_STRETCH,
            /**
             * The shortcut is a clockwise rotation gesture. GTK+ provides an icon and subtitle.
             */
            GESTURE_ROTATE_CLOCKWISE,
            /**
             * The shortcut is a counterclockwise rotation gesture. GTK+ provides an icon and subtitle.
             */
            GESTURE_ROTATE_COUNTERCLOCKWISE,
            /**
             * The shortcut is a two-finger swipe gesture. GTK+ provides an icon and subtitle.
             */
            GESTURE_TWO_FINGER_SWIPE_LEFT,
            /**
             * The shortcut is a two-finger swipe gesture. GTK+ provides an icon and subtitle.
             */
            GESTURE_TWO_FINGER_SWIPE_RIGHT,
            /**
             * The shortcut is a gesture. The #GtkShortcutsShortcut:icon property will be
             *   used.
             */
            GESTURE,
        }
        /**
         * The mode of the size group determines the directions in which the size
         * group affects the requested sizes of its component widgets.
         */

        /**
         * The mode of the size group determines the directions in which the size
         * group affects the requested sizes of its component widgets.
         */
        export namespace SizeGroupMode {
            export const $gtype: GObject.GType<SizeGroupMode>;
        }

        enum SizeGroupMode {
            /**
             * group has no effect
             */
            NONE,
            /**
             * group affects horizontal requisition
             */
            HORIZONTAL,
            /**
             * group affects vertical requisition
             */
            VERTICAL,
            /**
             * group affects both horizontal and vertical requisition
             */
            BOTH,
        }
        /**
         * Specifies a preference for height-for-width or
         * width-for-height geometry management.
         */

        /**
         * Specifies a preference for height-for-width or
         * width-for-height geometry management.
         */
        export namespace SizeRequestMode {
            export const $gtype: GObject.GType<SizeRequestMode>;
        }

        enum SizeRequestMode {
            /**
             * Prefer height-for-width geometry management
             */
            HEIGHT_FOR_WIDTH,
            /**
             * Prefer width-for-height geometry management
             */
            WIDTH_FOR_HEIGHT,
            /**
             * Don’t trade height-for-width or width-for-height
             */
            CONSTANT_SIZE,
        }
        /**
         * Determines the direction of a sort.
         */

        /**
         * Determines the direction of a sort.
         */
        export namespace SortType {
            export const $gtype: GObject.GType<SortType>;
        }

        enum SortType {
            /**
             * Sorting is in ascending order.
             */
            ASCENDING,
            /**
             * Sorting is in descending order.
             */
            DESCENDING,
        }
        /**
         * The spin button update policy determines whether the spin button displays
         * values even if they are outside the bounds of its adjustment.
         * See gtk_spin_button_set_update_policy().
         */

        /**
         * The spin button update policy determines whether the spin button displays
         * values even if they are outside the bounds of its adjustment.
         * See gtk_spin_button_set_update_policy().
         */
        export namespace SpinButtonUpdatePolicy {
            export const $gtype: GObject.GType<SpinButtonUpdatePolicy>;
        }

        enum SpinButtonUpdatePolicy {
            /**
             * When refreshing your #GtkSpinButton, the value is
             *     always displayed
             */
            ALWAYS,
            /**
             * When refreshing your #GtkSpinButton, the value is
             *     only displayed if it is valid within the bounds of the spin button's
             *     adjustment
             */
            IF_VALID,
        }
        /**
         * The values of the GtkSpinType enumeration are used to specify the
         * change to make in gtk_spin_button_spin().
         */

        /**
         * The values of the GtkSpinType enumeration are used to specify the
         * change to make in gtk_spin_button_spin().
         */
        export namespace SpinType {
            export const $gtype: GObject.GType<SpinType>;
        }

        enum SpinType {
            /**
             * Increment by the adjustments step increment.
             */
            STEP_FORWARD,
            /**
             * Decrement by the adjustments step increment.
             */
            STEP_BACKWARD,
            /**
             * Increment by the adjustments page increment.
             */
            PAGE_FORWARD,
            /**
             * Decrement by the adjustments page increment.
             */
            PAGE_BACKWARD,
            /**
             * Go to the adjustments lower bound.
             */
            HOME,
            /**
             * Go to the adjustments upper bound.
             */
            END,
            /**
             * Change by a specified amount.
             */
            USER_DEFINED,
        }
        /**
         * These enumeration values describe the possible transitions
         * between pages in a #GtkStack widget.
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * These enumeration values describe the possible transitions
         * between pages in a #GtkStack widget.
         *
         * New values may be added to this enumeration over time.
         */
        export namespace StackTransitionType {
            export const $gtype: GObject.GType<StackTransitionType>;
        }

        enum StackTransitionType {
            /**
             * No transition
             */
            NONE,
            /**
             * A cross-fade
             */
            CROSSFADE,
            /**
             * Slide from left to right
             */
            SLIDE_RIGHT,
            /**
             * Slide from right to left
             */
            SLIDE_LEFT,
            /**
             * Slide from bottom up
             */
            SLIDE_UP,
            /**
             * Slide from top down
             */
            SLIDE_DOWN,
            /**
             * Slide from left or right according to the children order
             */
            SLIDE_LEFT_RIGHT,
            /**
             * Slide from top down or bottom up according to the order
             */
            SLIDE_UP_DOWN,
            /**
             * Cover the old page by sliding up. Since 3.12
             */
            OVER_UP,
            /**
             * Cover the old page by sliding down. Since: 3.12
             */
            OVER_DOWN,
            /**
             * Cover the old page by sliding to the left. Since: 3.12
             */
            OVER_LEFT,
            /**
             * Cover the old page by sliding to the right. Since: 3.12
             */
            OVER_RIGHT,
            /**
             * Uncover the new page by sliding up. Since 3.12
             */
            UNDER_UP,
            /**
             * Uncover the new page by sliding down. Since: 3.12
             */
            UNDER_DOWN,
            /**
             * Uncover the new page by sliding to the left. Since: 3.12
             */
            UNDER_LEFT,
            /**
             * Uncover the new page by sliding to the right. Since: 3.12
             */
            UNDER_RIGHT,
            /**
             * Cover the old page sliding up or uncover the new page sliding down, according to order. Since: 3.12
             */
            OVER_UP_DOWN,
            /**
             * Cover the old page sliding down or uncover the new page sliding up, according to order. Since: 3.14
             */
            OVER_DOWN_UP,
            /**
             * Cover the old page sliding left or uncover the new page sliding right, according to order. Since: 3.14
             */
            OVER_LEFT_RIGHT,
            /**
             * Cover the old page sliding right or uncover the new page sliding left, according to order. Since: 3.14
             */
            OVER_RIGHT_LEFT,
        }
        /**
         * This type indicates the current state of a widget; the state determines how
         * the widget is drawn. The #GtkStateType enumeration is also used to
         * identify different colors in a #GtkStyle for drawing, so states can be
         * used for subparts of a widget as well as entire widgets.
         */

        /**
         * This type indicates the current state of a widget; the state determines how
         * the widget is drawn. The #GtkStateType enumeration is also used to
         * identify different colors in a #GtkStyle for drawing, so states can be
         * used for subparts of a widget as well as entire widgets.
         */
        export namespace StateType {
            export const $gtype: GObject.GType<StateType>;
        }

        enum StateType {
            /**
             * State during normal operation.
             */
            NORMAL,
            /**
             * State of a currently active widget, such as a depressed button.
             */
            ACTIVE,
            /**
             * State indicating that the mouse pointer is over
             *                      the widget and the widget will respond to mouse clicks.
             */
            PRELIGHT,
            /**
             * State of a selected item, such the selected row in a list.
             */
            SELECTED,
            /**
             * State indicating that the widget is
             *                         unresponsive to user actions.
             */
            INSENSITIVE,
            /**
             * The widget is inconsistent, such as checkbuttons
             *                          or radiobuttons that aren’t either set to %TRUE nor %FALSE,
             *                          or buttons requiring the user attention.
             */
            INCONSISTENT,
            /**
             * The widget has the keyboard focus.
             */
            FOCUSED,
        }
        /**
         * These values are used as “info” for the targets contained in the
         * lists returned by gtk_text_buffer_get_copy_target_list() and
         * gtk_text_buffer_get_paste_target_list().
         *
         * The values counts down from `-1` to avoid clashes
         * with application added drag destinations which usually start at 0.
         */

        /**
         * These values are used as “info” for the targets contained in the
         * lists returned by gtk_text_buffer_get_copy_target_list() and
         * gtk_text_buffer_get_paste_target_list().
         *
         * The values counts down from `-1` to avoid clashes
         * with application added drag destinations which usually start at 0.
         */
        export namespace TextBufferTargetInfo {
            export const $gtype: GObject.GType<TextBufferTargetInfo>;
        }

        enum TextBufferTargetInfo {
            /**
             * Buffer contents
             */
            BUFFER_CONTENTS,
            /**
             * Rich text
             */
            RICH_TEXT,
            /**
             * Text
             */
            TEXT,
        }
        /**
         * Reading directions for text.
         */

        /**
         * Reading directions for text.
         */
        export namespace TextDirection {
            export const $gtype: GObject.GType<TextDirection>;
        }

        enum TextDirection {
            /**
             * No direction.
             */
            NONE,
            /**
             * Left to right text direction.
             */
            LTR,
            /**
             * Right to left text direction.
             */
            RTL,
        }
        /**
         * Granularity types that extend the text selection. Use the
         * #GtkTextView::extend-selection signal to customize the selection.
         */

        /**
         * Granularity types that extend the text selection. Use the
         * #GtkTextView::extend-selection signal to customize the selection.
         */
        export namespace TextExtendSelection {
            export const $gtype: GObject.GType<TextExtendSelection>;
        }

        enum TextExtendSelection {
            /**
             * Selects the current word. It is triggered by
             *   a double-click for example.
             */
            WORD,
            /**
             * Selects the current line. It is triggered by
             *   a triple-click for example.
             */
            LINE,
        }
        /**
         * Used to reference the layers of #GtkTextView for the purpose of customized
         * drawing with the ::draw_layer vfunc.
         */

        /**
         * Used to reference the layers of #GtkTextView for the purpose of customized
         * drawing with the ::draw_layer vfunc.
         */
        export namespace TextViewLayer {
            export const $gtype: GObject.GType<TextViewLayer>;
        }

        enum TextViewLayer {
            /**
             * Old deprecated layer, use %GTK_TEXT_VIEW_LAYER_BELOW_TEXT instead
             */
            BELOW,
            /**
             * Old deprecated layer, use %GTK_TEXT_VIEW_LAYER_ABOVE_TEXT instead
             */
            ABOVE,
            /**
             * The layer rendered below the text (but above the background).  Since: 3.20
             */
            BELOW_TEXT,
            /**
             * The layer rendered above the text.  Since: 3.20
             */
            ABOVE_TEXT,
        }
        /**
         * Used to reference the parts of #GtkTextView.
         */

        /**
         * Used to reference the parts of #GtkTextView.
         */
        export namespace TextWindowType {
            export const $gtype: GObject.GType<TextWindowType>;
        }

        enum TextWindowType {
            /**
             * Invalid value, used as a marker
             */
            PRIVATE,
            /**
             * Window that floats over scrolling areas.
             */
            WIDGET,
            /**
             * Scrollable text window.
             */
            TEXT,
            /**
             * Left side border window.
             */
            LEFT,
            /**
             * Right side border window.
             */
            RIGHT,
            /**
             * Top border window.
             */
            TOP,
            /**
             * Bottom border window.
             */
            BOTTOM,
        }
        /**
         * Whether spacers are vertical lines or just blank.
         */

        /**
         * Whether spacers are vertical lines or just blank.
         */
        export namespace ToolbarSpaceStyle {
            export const $gtype: GObject.GType<ToolbarSpaceStyle>;
        }

        enum ToolbarSpaceStyle {
            /**
             * Use blank spacers.
             */
            EMPTY,
            /**
             * Use vertical lines for spacers.
             */
            LINE,
        }
        /**
         * Used to customize the appearance of a #GtkToolbar. Note that
         * setting the toolbar style overrides the user’s preferences
         * for the default toolbar style.  Note that if the button has only
         * a label set and GTK_TOOLBAR_ICONS is used, the label will be
         * visible, and vice versa.
         */

        /**
         * Used to customize the appearance of a #GtkToolbar. Note that
         * setting the toolbar style overrides the user’s preferences
         * for the default toolbar style.  Note that if the button has only
         * a label set and GTK_TOOLBAR_ICONS is used, the label will be
         * visible, and vice versa.
         */
        export namespace ToolbarStyle {
            export const $gtype: GObject.GType<ToolbarStyle>;
        }

        enum ToolbarStyle {
            /**
             * Buttons display only icons in the toolbar.
             */
            ICONS,
            /**
             * Buttons display only text labels in the toolbar.
             */
            TEXT,
            /**
             * Buttons display text and icons in the toolbar.
             */
            BOTH,
            /**
             * Buttons display icons and text alongside each
             *  other, rather than vertically stacked
             */
            BOTH_HORIZ,
        }
        /**
         * The sizing method the column uses to determine its width.  Please note
         * that `GTK_TREE_VIEW_COLUMN_AUTOSIZE` are inefficient for large views, and
         * can make columns appear choppy.
         */

        /**
         * The sizing method the column uses to determine its width.  Please note
         * that `GTK_TREE_VIEW_COLUMN_AUTOSIZE` are inefficient for large views, and
         * can make columns appear choppy.
         */
        export namespace TreeViewColumnSizing {
            export const $gtype: GObject.GType<TreeViewColumnSizing>;
        }

        enum TreeViewColumnSizing {
            /**
             * Columns only get bigger in reaction to changes in the model
             */
            GROW_ONLY,
            /**
             * Columns resize to be the optimal size everytime the model changes.
             */
            AUTOSIZE,
            /**
             * Columns are a fixed numbers of pixels wide.
             */
            FIXED,
        }
        /**
         * An enum for determining where a dropped row goes.
         */

        /**
         * An enum for determining where a dropped row goes.
         */
        export namespace TreeViewDropPosition {
            export const $gtype: GObject.GType<TreeViewDropPosition>;
        }

        enum TreeViewDropPosition {
            /**
             * dropped row is inserted before
             */
            BEFORE,
            /**
             * dropped row is inserted after
             */
            AFTER,
            /**
             * dropped row becomes a child or is inserted before
             */
            INTO_OR_BEFORE,
            /**
             * dropped row becomes a child or is inserted after
             */
            INTO_OR_AFTER,
        }
        /**
         * Used to indicate which grid lines to draw in a tree view.
         */

        /**
         * Used to indicate which grid lines to draw in a tree view.
         */
        export namespace TreeViewGridLines {
            export const $gtype: GObject.GType<TreeViewGridLines>;
        }

        enum TreeViewGridLines {
            /**
             * No grid lines.
             */
            NONE,
            /**
             * Horizontal grid lines.
             */
            HORIZONTAL,
            /**
             * Vertical grid lines.
             */
            VERTICAL,
            /**
             * Horizontal and vertical grid lines.
             */
            BOTH,
        }
        /**
         * See also gtk_print_settings_set_paper_width().
         */

        /**
         * See also gtk_print_settings_set_paper_width().
         */
        export namespace Unit {
            export const $gtype: GObject.GType<Unit>;
        }

        enum Unit {
            /**
             * No units.
             */
            NONE,
            /**
             * Dimensions in points.
             */
            POINTS,
            /**
             * Dimensions in inches.
             */
            INCH,
            /**
             * Dimensions in millimeters
             */
            MM,
        }
        /**
         * Kinds of widget-specific help. Used by the ::show-help signal.
         */

        /**
         * Kinds of widget-specific help. Used by the ::show-help signal.
         */
        export namespace WidgetHelpType {
            export const $gtype: GObject.GType<WidgetHelpType>;
        }

        enum WidgetHelpType {
            /**
             * Tooltip.
             */
            TOOLTIP,
            /**
             * What’s this.
             */
            WHATS_THIS,
        }
        /**
         * Window placement can be influenced using this enumeration. Note that
         * using #GTK_WIN_POS_CENTER_ALWAYS is almost always a bad idea.
         * It won’t necessarily work well with all window managers or on all windowing systems.
         */

        /**
         * Window placement can be influenced using this enumeration. Note that
         * using #GTK_WIN_POS_CENTER_ALWAYS is almost always a bad idea.
         * It won’t necessarily work well with all window managers or on all windowing systems.
         */
        export namespace WindowPosition {
            export const $gtype: GObject.GType<WindowPosition>;
        }

        enum WindowPosition {
            /**
             * No influence is made on placement.
             */
            NONE,
            /**
             * Windows should be placed in the center of the screen.
             */
            CENTER,
            /**
             * Windows should be placed at the current mouse position.
             */
            MOUSE,
            /**
             * Keep window centered as it changes size, etc.
             */
            CENTER_ALWAYS,
            /**
             * Center the window on its transient
             *  parent (see gtk_window_set_transient_for()).
             */
            CENTER_ON_PARENT,
        }
        /**
         * A #GtkWindow can be one of these types. Most things you’d consider a
         * “window” should have type #GTK_WINDOW_TOPLEVEL; windows with this type
         * are managed by the window manager and have a frame by default (call
         * gtk_window_set_decorated() to toggle the frame).  Windows with type
         * #GTK_WINDOW_POPUP are ignored by the window manager; window manager
         * keybindings won’t work on them, the window manager won’t decorate the
         * window with a frame, many GTK+ features that rely on the window
         * manager will not work (e.g. resize grips and
         * maximization/minimization). #GTK_WINDOW_POPUP is used to implement
         * widgets such as #GtkMenu or tooltips that you normally don’t think of
         * as windows per se. Nearly all windows should be #GTK_WINDOW_TOPLEVEL.
         * In particular, do not use #GTK_WINDOW_POPUP just to turn off
         * the window borders; use gtk_window_set_decorated() for that.
         */

        /**
         * A #GtkWindow can be one of these types. Most things you’d consider a
         * “window” should have type #GTK_WINDOW_TOPLEVEL; windows with this type
         * are managed by the window manager and have a frame by default (call
         * gtk_window_set_decorated() to toggle the frame).  Windows with type
         * #GTK_WINDOW_POPUP are ignored by the window manager; window manager
         * keybindings won’t work on them, the window manager won’t decorate the
         * window with a frame, many GTK+ features that rely on the window
         * manager will not work (e.g. resize grips and
         * maximization/minimization). #GTK_WINDOW_POPUP is used to implement
         * widgets such as #GtkMenu or tooltips that you normally don’t think of
         * as windows per se. Nearly all windows should be #GTK_WINDOW_TOPLEVEL.
         * In particular, do not use #GTK_WINDOW_POPUP just to turn off
         * the window borders; use gtk_window_set_decorated() for that.
         */
        export namespace WindowType {
            export const $gtype: GObject.GType<WindowType>;
        }

        enum WindowType {
            /**
             * A regular window, such as a dialog.
             */
            TOPLEVEL,
            /**
             * A special window such as a tooltip.
             */
            POPUP,
        }
        /**
         * Describes a type of line wrapping.
         */

        /**
         * Describes a type of line wrapping.
         */
        export namespace WrapMode {
            export const $gtype: GObject.GType<WrapMode>;
        }

        enum WrapMode {
            /**
             * do not wrap lines; just make the text area wider
             */
            NONE,
            /**
             * wrap text, breaking lines anywhere the cursor can
             *     appear (between characters, usually - if you want to be technical,
             *     between graphemes, see pango_get_log_attrs())
             */
            CHAR,
            /**
             * wrap text, breaking lines in between words
             */
            WORD,
            /**
             * wrap text, breaking lines in between words, or if
             *     that is not enough, also between graphemes
             */
            WORD_CHAR,
        }
        /**
         * Like gtk_get_binary_age(), but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const BINARY_AGE: number;
        /**
         * Constant to return from a signal handler for the #GtkSpinButton::input
         * signal in case of conversion failure.
         */
        const INPUT_ERROR: number;
        /**
         * Like gtk_get_interface_age(), but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const INTERFACE_AGE: number;
        /**
         * The name used for the stock full offset included by #GtkLevelBar.
         */
        const LEVEL_BAR_OFFSET_FULL: string;
        /**
         * The name used for the stock high offset included by #GtkLevelBar.
         */
        const LEVEL_BAR_OFFSET_HIGH: string;
        /**
         * The name used for the stock low offset included by #GtkLevelBar.
         */
        const LEVEL_BAR_OFFSET_LOW: string;
        /**
         * Like gtk_get_major_version(), but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const MAJOR_VERSION: number;
        /**
         * The maximum length of sequences in compose tables.
         */
        const MAX_COMPOSE_LEN: number;
        /**
         * Like gtk_get_micro_version(), but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const MICRO_VERSION: number;
        /**
         * Like gtk_get_minor_version(), but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const MINOR_VERSION: number;
        /**
         * Name for the A3 paper size.
         */
        const PAPER_NAME_A3: string;
        /**
         * Name for the A4 paper size.
         */
        const PAPER_NAME_A4: string;
        /**
         * Name for the A5 paper size.
         */
        const PAPER_NAME_A5: string;
        /**
         * Name for the B5 paper size.
         */
        const PAPER_NAME_B5: string;
        /**
         * Name for the Executive paper size.
         */
        const PAPER_NAME_EXECUTIVE: string;
        /**
         * Name for the Legal paper size.
         */
        const PAPER_NAME_LEGAL: string;
        /**
         * Name for the Letter paper size.
         */
        const PAPER_NAME_LETTER: string;
        const PATH_PRIO_MASK: number;
        const PRINT_SETTINGS_COLLATE: string;
        const PRINT_SETTINGS_DEFAULT_SOURCE: string;
        const PRINT_SETTINGS_DITHER: string;
        const PRINT_SETTINGS_DUPLEX: string;
        const PRINT_SETTINGS_FINISHINGS: string;
        const PRINT_SETTINGS_MEDIA_TYPE: string;
        const PRINT_SETTINGS_NUMBER_UP: string;
        const PRINT_SETTINGS_NUMBER_UP_LAYOUT: string;
        const PRINT_SETTINGS_N_COPIES: string;
        const PRINT_SETTINGS_ORIENTATION: string;
        /**
         * The key used by the “Print to file” printer to store the file
         * name of the output without the path to the directory and the
         * file extension.
         */
        const PRINT_SETTINGS_OUTPUT_BASENAME: string;
        const PRINT_SETTINGS_OUTPUT_BIN: string;
        /**
         * The key used by the “Print to file” printer to store the
         * directory to which the output should be written.
         */
        const PRINT_SETTINGS_OUTPUT_DIR: string;
        /**
         * The key used by the “Print to file” printer to store the format
         * of the output. The supported values are “PS” and “PDF”.
         */
        const PRINT_SETTINGS_OUTPUT_FILE_FORMAT: string;
        /**
         * The key used by the “Print to file” printer to store the URI
         * to which the output should be written. GTK+ itself supports
         * only “file://” URIs.
         */
        const PRINT_SETTINGS_OUTPUT_URI: string;
        const PRINT_SETTINGS_PAGE_RANGES: string;
        const PRINT_SETTINGS_PAGE_SET: string;
        const PRINT_SETTINGS_PAPER_FORMAT: string;
        const PRINT_SETTINGS_PAPER_HEIGHT: string;
        const PRINT_SETTINGS_PAPER_WIDTH: string;
        const PRINT_SETTINGS_PRINTER: string;
        const PRINT_SETTINGS_PRINTER_LPI: string;
        const PRINT_SETTINGS_PRINT_PAGES: string;
        const PRINT_SETTINGS_QUALITY: string;
        const PRINT_SETTINGS_RESOLUTION: string;
        const PRINT_SETTINGS_RESOLUTION_X: string;
        const PRINT_SETTINGS_RESOLUTION_Y: string;
        const PRINT_SETTINGS_REVERSE: string;
        const PRINT_SETTINGS_SCALE: string;
        const PRINT_SETTINGS_USE_COLOR: string;
        const PRINT_SETTINGS_WIN32_DRIVER_EXTRA: string;
        const PRINT_SETTINGS_WIN32_DRIVER_VERSION: string;
        /**
         * Use this priority for functionality related to size allocation.
         *
         * It is used internally by GTK+ to compute the sizes of widgets.
         * This priority is higher than %GDK_PRIORITY_REDRAW to avoid
         * resizing a widget which was just redrawn.
         */
        const PRIORITY_RESIZE: number;
        /**
         * The “About” item.
         * ![](help-about.png)
         */
        const STOCK_ABOUT: string;
        /**
         * The “Add” item and icon.
         */
        const STOCK_ADD: string;
        /**
         * The “Apply” item and icon.
         */
        const STOCK_APPLY: string;
        /**
         * The “Bold” item and icon.
         */
        const STOCK_BOLD: string;
        /**
         * The “Cancel” item and icon.
         */
        const STOCK_CANCEL: string;
        /**
         * The “Caps Lock Warning” icon.
         */
        const STOCK_CAPS_LOCK_WARNING: string;
        /**
         * The “CD-Rom” item and icon.
         */
        const STOCK_CDROM: string;
        /**
         * The “Clear” item and icon.
         */
        const STOCK_CLEAR: string;
        /**
         * The “Close” item and icon.
         */
        const STOCK_CLOSE: string;
        /**
         * The “Color Picker” item and icon.
         */
        const STOCK_COLOR_PICKER: string;
        /**
         * The “Connect” icon.
         */
        const STOCK_CONNECT: string;
        /**
         * The “Convert” item and icon.
         */
        const STOCK_CONVERT: string;
        /**
         * The “Copy” item and icon.
         */
        const STOCK_COPY: string;
        /**
         * The “Cut” item and icon.
         */
        const STOCK_CUT: string;
        /**
         * The “Delete” item and icon.
         */
        const STOCK_DELETE: string;
        /**
         * The “Authentication” item and icon.
         */
        const STOCK_DIALOG_AUTHENTICATION: string;
        /**
         * The “Error” item and icon.
         */
        const STOCK_DIALOG_ERROR: string;
        /**
         * The “Information” item and icon.
         */
        const STOCK_DIALOG_INFO: string;
        /**
         * The “Question” item and icon.
         */
        const STOCK_DIALOG_QUESTION: string;
        /**
         * The “Warning” item and icon.
         */
        const STOCK_DIALOG_WARNING: string;
        /**
         * The “Directory” icon.
         */
        const STOCK_DIRECTORY: string;
        /**
         * The “Discard” item.
         */
        const STOCK_DISCARD: string;
        /**
         * The “Disconnect” icon.
         */
        const STOCK_DISCONNECT: string;
        /**
         * The “Drag-And-Drop” icon.
         */
        const STOCK_DND: string;
        /**
         * The “Drag-And-Drop multiple” icon.
         */
        const STOCK_DND_MULTIPLE: string;
        /**
         * The “Edit” item and icon.
         */
        const STOCK_EDIT: string;
        /**
         * The “Execute” item and icon.
         */
        const STOCK_EXECUTE: string;
        /**
         * The “File” item and icon.
         *
         * Since 3.0, this item has a label, before it only had an icon.
         */
        const STOCK_FILE: string;
        /**
         * The “Find” item and icon.
         */
        const STOCK_FIND: string;
        /**
         * The “Find and Replace” item and icon.
         */
        const STOCK_FIND_AND_REPLACE: string;
        /**
         * The “Floppy” item and icon.
         */
        const STOCK_FLOPPY: string;
        /**
         * The “Fullscreen” item and icon.
         */
        const STOCK_FULLSCREEN: string;
        /**
         * The “Bottom” item and icon.
         */
        const STOCK_GOTO_BOTTOM: string;
        /**
         * The “First” item and icon. The icon has an RTL variant.
         */
        const STOCK_GOTO_FIRST: string;
        /**
         * The “Last” item and icon. The icon has an RTL variant.
         */
        const STOCK_GOTO_LAST: string;
        /**
         * The “Top” item and icon.
         */
        const STOCK_GOTO_TOP: string;
        /**
         * The “Back” item and icon. The icon has an RTL variant.
         */
        const STOCK_GO_BACK: string;
        /**
         * The “Down” item and icon.
         */
        const STOCK_GO_DOWN: string;
        /**
         * The “Forward” item and icon. The icon has an RTL variant.
         */
        const STOCK_GO_FORWARD: string;
        /**
         * The “Up” item and icon.
         */
        const STOCK_GO_UP: string;
        /**
         * The “Harddisk” item and icon.
         */
        const STOCK_HARDDISK: string;
        /**
         * The “Help” item and icon.
         */
        const STOCK_HELP: string;
        /**
         * The “Home” item and icon.
         */
        const STOCK_HOME: string;
        /**
         * The “Indent” item and icon. The icon has an RTL variant.
         */
        const STOCK_INDENT: string;
        /**
         * The “Index” item and icon.
         */
        const STOCK_INDEX: string;
        /**
         * The “Info” item and icon.
         */
        const STOCK_INFO: string;
        /**
         * The “Italic” item and icon.
         */
        const STOCK_ITALIC: string;
        /**
         * The “Jump to” item and icon. The icon has an RTL variant.
         */
        const STOCK_JUMP_TO: string;
        /**
         * The “Center” item and icon.
         */
        const STOCK_JUSTIFY_CENTER: string;
        /**
         * The “Fill” item and icon.
         */
        const STOCK_JUSTIFY_FILL: string;
        /**
         * The “Left” item and icon.
         */
        const STOCK_JUSTIFY_LEFT: string;
        /**
         * The “Right” item and icon.
         */
        const STOCK_JUSTIFY_RIGHT: string;
        /**
         * The “Leave Fullscreen” item and icon.
         */
        const STOCK_LEAVE_FULLSCREEN: string;
        /**
         * The “Media Forward” item and icon. The icon has an RTL variant.
         */
        const STOCK_MEDIA_FORWARD: string;
        /**
         * The “Media Next” item and icon. The icon has an RTL variant.
         */
        const STOCK_MEDIA_NEXT: string;
        /**
         * The “Media Pause” item and icon.
         */
        const STOCK_MEDIA_PAUSE: string;
        /**
         * The “Media Play” item and icon. The icon has an RTL variant.
         */
        const STOCK_MEDIA_PLAY: string;
        /**
         * The “Media Previous” item and icon. The icon has an RTL variant.
         */
        const STOCK_MEDIA_PREVIOUS: string;
        /**
         * The “Media Record” item and icon.
         */
        const STOCK_MEDIA_RECORD: string;
        /**
         * The “Media Rewind” item and icon. The icon has an RTL variant.
         */
        const STOCK_MEDIA_REWIND: string;
        /**
         * The “Media Stop” item and icon.
         */
        const STOCK_MEDIA_STOP: string;
        /**
         * The “Missing image” icon.
         */
        const STOCK_MISSING_IMAGE: string;
        /**
         * The “Network” item and icon.
         */
        const STOCK_NETWORK: string;
        /**
         * The “New” item and icon.
         */
        const STOCK_NEW: string;
        /**
         * The “No” item and icon.
         */
        const STOCK_NO: string;
        /**
         * The “OK” item and icon.
         */
        const STOCK_OK: string;
        /**
         * The “Open” item and icon.
         */
        const STOCK_OPEN: string;
        /**
         * The “Landscape Orientation” item and icon.
         */
        const STOCK_ORIENTATION_LANDSCAPE: string;
        /**
         * The “Portrait Orientation” item and icon.
         */
        const STOCK_ORIENTATION_PORTRAIT: string;
        /**
         * The “Reverse Landscape Orientation” item and icon.
         */
        const STOCK_ORIENTATION_REVERSE_LANDSCAPE: string;
        /**
         * The “Reverse Portrait Orientation” item and icon.
         */
        const STOCK_ORIENTATION_REVERSE_PORTRAIT: string;
        /**
         * The “Page Setup” item and icon.
         */
        const STOCK_PAGE_SETUP: string;
        /**
         * The “Paste” item and icon.
         */
        const STOCK_PASTE: string;
        /**
         * The “Preferences” item and icon.
         */
        const STOCK_PREFERENCES: string;
        /**
         * The “Print” item and icon.
         */
        const STOCK_PRINT: string;
        /**
         * The “Print Error” icon.
         */
        const STOCK_PRINT_ERROR: string;
        /**
         * The “Print Paused” icon.
         */
        const STOCK_PRINT_PAUSED: string;
        /**
         * The “Print Preview” item and icon.
         */
        const STOCK_PRINT_PREVIEW: string;
        /**
         * The “Print Report” icon.
         */
        const STOCK_PRINT_REPORT: string;
        /**
         * The “Print Warning” icon.
         */
        const STOCK_PRINT_WARNING: string;
        /**
         * The “Properties” item and icon.
         */
        const STOCK_PROPERTIES: string;
        /**
         * The “Quit” item and icon.
         */
        const STOCK_QUIT: string;
        /**
         * The “Redo” item and icon. The icon has an RTL variant.
         */
        const STOCK_REDO: string;
        /**
         * The “Refresh” item and icon.
         */
        const STOCK_REFRESH: string;
        /**
         * The “Remove” item and icon.
         */
        const STOCK_REMOVE: string;
        /**
         * The “Revert” item and icon. The icon has an RTL variant.
         */
        const STOCK_REVERT_TO_SAVED: string;
        /**
         * The “Save” item and icon.
         */
        const STOCK_SAVE: string;
        /**
         * The “Save As” item and icon.
         */
        const STOCK_SAVE_AS: string;
        /**
         * The “Select All” item and icon.
         */
        const STOCK_SELECT_ALL: string;
        /**
         * The “Color” item and icon.
         */
        const STOCK_SELECT_COLOR: string;
        /**
         * The “Font” item and icon.
         */
        const STOCK_SELECT_FONT: string;
        /**
         * The “Ascending” item and icon.
         */
        const STOCK_SORT_ASCENDING: string;
        /**
         * The “Descending” item and icon.
         */
        const STOCK_SORT_DESCENDING: string;
        /**
         * The “Spell Check” item and icon.
         */
        const STOCK_SPELL_CHECK: string;
        /**
         * The “Stop” item and icon.
         */
        const STOCK_STOP: string;
        /**
         * The “Strikethrough” item and icon.
         */
        const STOCK_STRIKETHROUGH: string;
        /**
         * The “Undelete” item and icon. The icon has an RTL variant.
         */
        const STOCK_UNDELETE: string;
        /**
         * The “Underline” item and icon.
         */
        const STOCK_UNDERLINE: string;
        /**
         * The “Undo” item and icon. The icon has an RTL variant.
         */
        const STOCK_UNDO: string;
        /**
         * The “Unindent” item and icon. The icon has an RTL variant.
         */
        const STOCK_UNINDENT: string;
        /**
         * The “Yes” item and icon.
         */
        const STOCK_YES: string;
        /**
         * The “Zoom 100%” item and icon.
         */
        const STOCK_ZOOM_100: string;
        /**
         * The “Zoom to Fit” item and icon.
         */
        const STOCK_ZOOM_FIT: string;
        /**
         * The “Zoom In” item and icon.
         */
        const STOCK_ZOOM_IN: string;
        /**
         * The “Zoom Out” item and icon.
         */
        const STOCK_ZOOM_OUT: string;
        /**
         * A CSS class to match an accelerator.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_ACCELERATOR: string;
        /**
         * A CSS class used when rendering an arrow element.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_ARROW: string;
        /**
         * A CSS class to match the window background.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_BACKGROUND: string;
        /**
         * A CSS class to indicate an area at the bottom of a widget.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_BOTTOM: string;
        /**
         * A CSS class to match buttons.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_BUTTON: string;
        /**
         * A CSS class to match calendars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_CALENDAR: string;
        /**
         * A CSS class to match content rendered in cell views.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_CELL: string;
        /**
         * A CSS class to match check boxes.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_CHECK: string;
        /**
         * A CSS class to match combobox entries.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_COMBOBOX_ENTRY: string;
        /**
         * A CSS class to match context menus.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_CONTEXT_MENU: string;
        /**
         * A CSS class that gets added to windows which have client-side decorations.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_CSD: string;
        /**
         * A CSS class used when rendering a drag handle for
         * text selection.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_CURSOR_HANDLE: string;
        /**
         * A CSS class to match the default widget.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_DEFAULT: string;
        /**
         * A CSS class used when an action (usually a button) is
         * one that is expected to remove or destroy something visible
         * to the user.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_DESTRUCTIVE_ACTION: string;
        /**
         * A CSS class to match dimmed labels.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_DIM_LABEL: string;
        /**
         * A CSS class for a drag-and-drop indicator.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_DND: string;
        /**
         * A CSS class defining a dock area.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_DOCK: string;
        /**
         * A CSS class to match text entries.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_ENTRY: string;
        /**
         * A CSS class for an area displaying an error message,
         * such as those in infobars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_ERROR: string;
        /**
         * A CSS class defining an expander, such as those in treeviews.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_EXPANDER: string;
        /**
         * A CSS class that is added when widgets that usually have
         * a frame or border (like buttons or entries) should appear
         * without it.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_FLAT: string;
        /**
         * A CSS class defining a frame delimiting content, such as
         * #GtkFrame or the scrolled window frame around the
         * scrollable area.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_FRAME: string;
        /**
         * A CSS class defining a resize grip.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_GRIP: string;
        /**
         * A CSS class to match a header element.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_HEADER: string;
        /**
         * A CSS class defining a highlighted area, such as headings in
         * assistants and calendars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_HIGHLIGHT: string;
        /**
         * A CSS class for horizontally layered widgets.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_HORIZONTAL: string;
        /**
         * A CSS class defining an image, such as the icon in an entry.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_IMAGE: string;
        /**
         * A CSS class for an area displaying an informational message,
         * such as those in infobars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_INFO: string;
        /**
         * A CSS class to match inline toolbars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_INLINE_TOOLBAR: string;
        /**
         * A CSS class used when rendering a drag handle for
         * the insertion cursor position.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_INSERTION_CURSOR: string;
        /**
         * A CSS class to match labels.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_LABEL: string;
        /**
         * A CSS class to indicate an area at the left of a widget.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_LEFT: string;
        /**
         * A CSS class used when rendering a level indicator, such
         * as a battery charge level, or a password strength.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_LEVEL_BAR: string;
        /**
         * A CSS class to match a linked area, such as a box containing buttons
         * belonging to the same control.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_LINKED: string;
        /**
         * A CSS class to match lists.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_LIST: string;
        /**
         * A CSS class to match list rows.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_LIST_ROW: string;
        /**
         * A CSS class defining marks in a widget, such as in scales.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_MARK: string;
        /**
         * A CSS class to match menus.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_MENU: string;
        /**
         * A CSS class to menubars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_MENUBAR: string;
        /**
         * A CSS class to match menu items.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_MENUITEM: string;
        /**
         * A CSS class that is added to message dialogs.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_MESSAGE_DIALOG: string;
        /**
         * A CSS class that is added to text view that should use
         * a monospace font.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_MONOSPACE: string;
        /**
         * A CSS class used when an element needs the user attention,
         * for instance a button in a stack switcher corresponding to
         * a hidden page that changed state.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_NEEDS_ATTENTION: string;
        /**
         * A CSS class defining a notebook.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_NOTEBOOK: string;
        /**
         * A CSS class used when rendering an OSD (On Screen Display) element,
         * on top of another container.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_OSD: string;
        /**
         * A CSS class that is added on the visual hints that happen
         * when scrolling is attempted past the limits of a scrollable
         * area.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_OVERSHOOT: string;
        /**
         * A CSS class for a pane separator, such as those in #GtkPaned.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_PANE_SEPARATOR: string;
        /**
         * A CSS class that is added to areas that should look like paper.
         *
         * This is used in print previews and themes are encouraged to
         * style it as black text on white background.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_PAPER: string;
        /**
         * A CSS class that matches popovers.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_POPOVER: string;
        /**
         * A CSS class that is added to the toplevel windows used for menus.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_POPUP: string;
        /**
         * A CSS class to match primary toolbars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_PRIMARY_TOOLBAR: string;
        /**
         * A CSS class to use when rendering activity as a progressbar.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_PROGRESSBAR: string;
        /**
         * A CSS class to use when rendering a pulse in an indeterminate progress bar.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_PULSE: string;
        /**
         * A CSS class for an area displaying a question to the user,
         * such as those in infobars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_QUESTION: string;
        /**
         * A CSS class to match radio buttons.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_RADIO: string;
        /**
         * A CSS class to match a raised control, such as a raised
         * button on a toolbar.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_RAISED: string;
        /**
         * A CSS class used to indicate a read-only state.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_READ_ONLY: string;
        /**
         * A CSS class to indicate an area at the right of a widget.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_RIGHT: string;
        /**
         * A CSS class to match the rubberband selection rectangle.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_RUBBERBAND: string;
        /**
         * A CSS class to match scale widgets.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SCALE: string;
        /**
         * A CSS class to match scale widgets with marks attached,
         * all the marks are above for horizontal #GtkScale.
         * left for vertical #GtkScale.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SCALE_HAS_MARKS_ABOVE: string;
        /**
         * A CSS class to match scale widgets with marks attached,
         * all the marks are below for horizontal #GtkScale,
         * right for vertical #GtkScale.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SCALE_HAS_MARKS_BELOW: string;
        /**
         * A CSS class to match scrollbars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SCROLLBAR: string;
        /**
         * A CSS class to match the junction area between an horizontal
         * and vertical scrollbar, when they’re both shown.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SCROLLBARS_JUNCTION: string;
        /**
         * A CSS class for a separator.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SEPARATOR: string;
        /**
         * A CSS class defining a sidebar, such as the left side in
         * a file chooser.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SIDEBAR: string;
        /**
         * A CSS class to match sliders.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SLIDER: string;
        /**
         * A CSS class defining an spinbutton.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SPINBUTTON: string;
        /**
         * A CSS class to use when rendering activity as a “spinner”.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SPINNER: string;
        /**
         * A CSS class to match statusbars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_STATUSBAR: string;
        /**
         * A CSS class used for the subtitle label in a titlebar in
         * a toplevel window.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SUBTITLE: string;
        /**
         * A CSS class used when an action (usually a button) is the
         * primary suggested action in a specific context.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_SUGGESTED_ACTION: string;
        /**
         * A CSS class used for the title label in a titlebar in
         * a toplevel window.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_TITLE: string;
        /**
         * A CSS class used when rendering a titlebar in a toplevel window.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_TITLEBAR: string;
        /**
         * A CSS class to match toolbars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_TOOLBAR: string;
        /**
         * A CSS class to match tooltip windows.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_TOOLTIP: string;
        /**
         * A CSS class to indicate an area at the top of a widget.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_TOP: string;
        /**
         * A CSS class for touch selection popups on entries
         * and text views.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_TOUCH_SELECTION: string;
        /**
         * A CSS class to match troughs, as in scrollbars and progressbars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_TROUGH: string;
        /**
         * A CSS class that is added on the visual hints that happen
         * where content is 'scrolled off' and can be made visible
         * by scrolling.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_UNDERSHOOT: string;
        /**
         * A CSS class for vertically layered widgets.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_VERTICAL: string;
        /**
         * A CSS class defining a view, such as iconviews or treeviews.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_VIEW: string;
        /**
         * A CSS class for an area displaying a warning message,
         * such as those in infobars.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_WARNING: string;
        /**
         * A CSS class to indicate that a UI element should be 'wide'.
         * Used by #GtkPaned.
         *
         * Refer to individual widget documentation for used style classes.
         */
        const STYLE_CLASS_WIDE: string;
        /**
         * A property holding the background color of rendered elements as a #GdkRGBA.
         */
        const STYLE_PROPERTY_BACKGROUND_COLOR: string;
        /**
         * A property holding the element’s background as a #cairo_pattern_t.
         */
        const STYLE_PROPERTY_BACKGROUND_IMAGE: string;
        /**
         * A property holding the element’s border color as a #GdkRGBA.
         */
        const STYLE_PROPERTY_BORDER_COLOR: string;
        /**
         * A property holding the rendered element’s border radius in pixels as a #gint.
         */
        const STYLE_PROPERTY_BORDER_RADIUS: string;
        /**
         * A property holding the element’s border style as a #GtkBorderStyle.
         */
        const STYLE_PROPERTY_BORDER_STYLE: string;
        /**
         * A property holding the rendered element’s border width in pixels as
         * a #GtkBorder. The border is the intermediary spacing property of the
         * padding/border/margin series.
         *
         * gtk_render_frame() uses this property to find out the frame line width,
         * so #GtkWidgets rendering frames may need to add up this padding when
         * requesting size
         */
        const STYLE_PROPERTY_BORDER_WIDTH: string;
        /**
         * A property holding the foreground color of rendered elements as a #GdkRGBA.
         */
        const STYLE_PROPERTY_COLOR: string;
        /**
         * A property holding the font properties used when rendering text
         * as a #PangoFontDescription.
         */
        const STYLE_PROPERTY_FONT: string;
        /**
         * A property holding the rendered element’s margin as a #GtkBorder. The
         * margin is defined as the spacing between the border of the element
         * and its surrounding elements. It is external to #GtkWidget's
         * size allocations, and the most external spacing property of the
         * padding/border/margin series.
         */
        const STYLE_PROPERTY_MARGIN: string;
        /**
         * A property holding the rendered element’s padding as a #GtkBorder. The
         * padding is defined as the spacing between the inner part of the element border
         * and its child. It’s the innermost spacing property of the padding/border/margin
         * series.
         */
        const STYLE_PROPERTY_PADDING: string;
        /**
         * A priority that can be used when adding a #GtkStyleProvider
         * for application-specific style information.
         */
        const STYLE_PROVIDER_PRIORITY_APPLICATION: number;
        /**
         * The priority used for default style information
         * that is used in the absence of themes.
         *
         * Note that this is not very useful for providing default
         * styling for custom style classes - themes are likely to
         * override styling provided at this priority with
         * catch-all `* {...}` rules.
         */
        const STYLE_PROVIDER_PRIORITY_FALLBACK: number;
        /**
         * The priority used for style information provided
         * via #GtkSettings.
         *
         * This priority is higher than #GTK_STYLE_PROVIDER_PRIORITY_THEME
         * to let settings override themes.
         */
        const STYLE_PROVIDER_PRIORITY_SETTINGS: number;
        /**
         * The priority used for style information provided
         * by themes.
         */
        const STYLE_PROVIDER_PRIORITY_THEME: number;
        /**
         * The priority used for the style information from
         * `XDG_CONFIG_HOME/gtk-3.0/gtk.css`.
         *
         * You should not use priorities higher than this, to
         * give the user the last word.
         */
        const STYLE_PROVIDER_PRIORITY_USER: number;
        /**
         * A widget region name to define a treeview column.
         */
        const STYLE_REGION_COLUMN: string;
        /**
         * A widget region name to define a treeview column header.
         */
        const STYLE_REGION_COLUMN_HEADER: string;
        /**
         * A widget region name to define a treeview row.
         */
        const STYLE_REGION_ROW: string;
        /**
         * A widget region name to define a notebook tab.
         */
        const STYLE_REGION_TAB: string;
        /**
         * The priority at which the text view validates onscreen lines
         * in an idle job in the background.
         */
        const TEXT_VIEW_PRIORITY_VALIDATE: number;
        /**
         * The GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID can be used to make a
         * #GtkTreeSortable use the default sort function.
         *
         * See also gtk_tree_sortable_set_sort_column_id()
         */
        const TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID: number;
        /**
         * The GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID can be used to make a
         * #GtkTreeSortable use no sorting.
         *
         * See also gtk_tree_sortable_set_sort_column_id()
         */
        const TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID: number;
        /**
         * Finds the first accelerator in any #GtkAccelGroup attached
         * to `object` that matches `accel_key` and `accel_mods,` and
         * activates that accelerator.
         * @param object the #GObject, usually a #GtkWindow, on which     to activate the accelerator
         * @param accel_key accelerator keyval from a key event
         * @param accel_mods keyboard state mask from a key event
         * @returns %TRUE if an accelerator was activated and handled     this keypress
         */
        function accel_groups_activate(
            object: GObject.Object,
            accel_key: number,
            accel_mods: Gdk.ModifierType | null,
        ): boolean;
        /**
         * Gets a list of all accel groups which are attached to `object`.
         * @param object a #GObject, usually a #GtkWindow
         * @returns a list of     all accel groups which are attached to @object
         */
        function accel_groups_from_object(object: GObject.Object): AccelGroup[];
        /**
         * Gets the modifier mask.
         *
         * The modifier mask determines which modifiers are considered significant
         * for keyboard accelerators. See gtk_accelerator_set_default_mod_mask().
         * @returns the default accelerator modifier mask
         */
        function accelerator_get_default_mod_mask(): Gdk.ModifierType;
        /**
         * Converts an accelerator keyval and modifier mask into a string
         * which can be used to represent the accelerator to the user.
         * @param accelerator_key accelerator keyval
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly-allocated string representing the accelerator.
         */
        function accelerator_get_label(accelerator_key: number, accelerator_mods: Gdk.ModifierType | null): string;
        /**
         * Converts an accelerator keyval and modifier mask
         * into a (possibly translated) string that can be displayed to
         * a user, similarly to gtk_accelerator_get_label(), but handling
         * keycodes.
         *
         * This is only useful for system-level components, applications
         * should use gtk_accelerator_parse() instead.
         * @param display a #GdkDisplay or %NULL to use the default display
         * @param accelerator_key accelerator keyval
         * @param keycode accelerator keycode
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly-allocated string representing the accelerator.
         */
        function accelerator_get_label_with_keycode(
            display: Gdk.Display | null,
            accelerator_key: number,
            keycode: number,
            accelerator_mods: Gdk.ModifierType | null,
        ): string;
        /**
         * Converts an accelerator keyval and modifier mask into a string
         * parseable by gtk_accelerator_parse(). For example, if you pass in
         * #GDK_KEY_q and #GDK_CONTROL_MASK, this function returns “<Control>q”.
         *
         * If you need to display accelerators in the user interface,
         * see gtk_accelerator_get_label().
         * @param accelerator_key accelerator keyval
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly-allocated accelerator name
         */
        function accelerator_name(accelerator_key: number, accelerator_mods: Gdk.ModifierType | null): string;
        /**
         * Converts an accelerator keyval and modifier mask
         * into a string parseable by gtk_accelerator_parse_with_keycode(),
         * similarly to gtk_accelerator_name() but handling keycodes.
         * This is only useful for system-level components, applications
         * should use gtk_accelerator_parse() instead.
         * @param display a #GdkDisplay or %NULL to use the default display
         * @param accelerator_key accelerator keyval
         * @param keycode accelerator keycode
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly allocated accelerator name.
         */
        function accelerator_name_with_keycode(
            display: Gdk.Display | null,
            accelerator_key: number,
            keycode: number,
            accelerator_mods: Gdk.ModifierType | null,
        ): string;
        /**
         * Parses a string representing an accelerator. The format looks like
         * `<Control>a` or `<Shift><Alt>F1` or `<Release>z` (the last one is
         * for key release).
         *
         * The parser is fairly liberal and allows lower or upper case, and also
         * abbreviations such as `<Ctl>` and `<Ctrl>`. Key names are parsed using
         * gdk_keyval_from_name(). For character keys the name is not the symbol,
         * but the lowercase name, e.g. one would use `<Ctrl>minus` instead of
         * `<Ctrl>-`.
         *
         * If the parse fails, `accelerator_key` and `accelerator_mods` will
         * be set to 0 (zero).
         * @param accelerator string representing an accelerator
         */
        function accelerator_parse(accelerator: string): [number, Gdk.ModifierType | null];
        /**
         * Parses a string representing an accelerator, similarly to
         * gtk_accelerator_parse() but handles keycodes as well. This is only
         * useful for system-level components, applications should use
         * gtk_accelerator_parse() instead.
         *
         * If `accelerator_codes` is given and the result stored in it is non-%NULL,
         * the result must be freed with g_free().
         *
         * If a keycode is present in the accelerator and no `accelerator_codes`
         * is given, the parse will fail.
         *
         * If the parse fails, `accelerator_key,` `accelerator_mods` and
         * `accelerator_codes` will be set to 0 (zero).
         * @param accelerator string representing an accelerator
         */
        function accelerator_parse_with_keycode(
            accelerator: string,
        ): [number, number[] | null, Gdk.ModifierType | null];
        /**
         * Sets the modifiers that will be considered significant for keyboard
         * accelerators. The default mod mask depends on the GDK backend in use,
         * but will typically include #GDK_CONTROL_MASK | #GDK_SHIFT_MASK |
         * #GDK_MOD1_MASK | #GDK_SUPER_MASK | #GDK_HYPER_MASK | #GDK_META_MASK.
         * In other words, Control, Shift, Alt, Super, Hyper and Meta. Other
         * modifiers will by default be ignored by #GtkAccelGroup.
         *
         * You must include at least the three modifiers Control, Shift
         * and Alt in any value you pass to this function.
         *
         * The default mod mask should be changed on application startup,
         * before using any accelerator groups.
         * @param default_mod_mask accelerator modifier mask
         */
        function accelerator_set_default_mod_mask(default_mod_mask: Gdk.ModifierType | null): void;
        /**
         * Determines whether a given keyval and modifier mask constitute
         * a valid keyboard accelerator. For example, the #GDK_KEY_a keyval
         * plus #GDK_CONTROL_MASK is valid - this is a “Ctrl+a” accelerator.
         * But, you can't, for instance, use the #GDK_KEY_Control_L keyval
         * as an accelerator.
         * @param keyval a GDK keyval
         * @param modifiers modifier mask
         * @returns %TRUE if the accelerator is valid
         */
        function accelerator_valid(keyval: number, modifiers: Gdk.ModifierType | null): boolean;
        /**
         * Returns %TRUE if dialogs are expected to use an alternative
         * button order on the screen `screen`. See
         * gtk_dialog_set_alternative_button_order() for more details
         * about alternative button order.
         *
         * If you need to use this function, you should probably connect
         * to the ::notify:gtk-alternative-button-order signal on the
         * #GtkSettings object associated to `screen,` in order to be
         * notified if the button order setting changes.
         * @param screen a #GdkScreen, or %NULL to use the default screen
         * @returns Whether the alternative button order should be used
         */
        function alternative_dialog_button_order(screen?: Gdk.Screen | null): boolean;
        /**
         * Parses a signal description from `signal_desc` and incorporates
         * it into `binding_set`.
         *
         * Signal descriptions may either bind a key combination to
         * one or more signals:
         *
         * ```
         *   bind "key" {
         *     "signalname" (param, ...)
         *     ...
         *   }
         * ```
         *
         *
         * Or they may also unbind a key combination:
         *
         * ```
         *   unbind "key"
         * ```
         *
         *
         * Key combinations must be in a format that can be parsed by
         * gtk_accelerator_parse().
         * @param binding_set a #GtkBindingSet
         * @param signal_desc a signal description
         * @returns %G_TOKEN_NONE if the signal was successfully parsed and added,     the expected token otherwise
         */
        function binding_entry_add_signal_from_string(binding_set: BindingSet, signal_desc: string): GLib.TokenType;
        /**
         * Override or install a new key binding for `keyval` with `modifiers` on
         * `binding_set`.
         * @param binding_set a #GtkBindingSet to add a signal to
         * @param keyval key value
         * @param modifiers key modifier
         * @param signal_name signal name to be bound
         * @param binding_args list of #GtkBindingArg signal arguments
         */
        function binding_entry_add_signall(
            binding_set: BindingSet,
            keyval: number,
            modifiers: Gdk.ModifierType | null,
            signal_name: string,
            binding_args: BindingArg[],
        ): void;
        /**
         * Remove a binding previously installed via
         * gtk_binding_entry_add_signal() on `binding_set`.
         * @param binding_set a #GtkBindingSet to remove an entry of
         * @param keyval key value of binding to remove
         * @param modifiers key modifier of binding to remove
         */
        function binding_entry_remove(
            binding_set: BindingSet,
            keyval: number,
            modifiers: Gdk.ModifierType | null,
        ): void;
        /**
         * Install a binding on `binding_set` which causes key lookups
         * to be aborted, to prevent bindings from lower priority sets
         * to be activated.
         * @param binding_set a #GtkBindingSet to skip an entry of
         * @param keyval key value of binding to skip
         * @param modifiers key modifier of binding to skip
         */
        function binding_entry_skip(binding_set: BindingSet, keyval: number, modifiers: Gdk.ModifierType | null): void;
        /**
         * Find a binding set by its globally unique name.
         *
         * The `set_name` can either be a name used for gtk_binding_set_new()
         * or the type name of a class used in gtk_binding_set_by_class().
         * @param set_name unique binding set name
         * @returns %NULL or the specified binding set
         */
        function binding_set_find(set_name: string): BindingSet | null;
        /**
         * Find a key binding matching `keyval` and `modifiers` and activate the
         * binding on `object`.
         * @param object object to activate when binding found
         * @param keyval key value of the binding
         * @param modifiers key modifier of the binding
         * @returns %TRUE if a binding was found and activated
         */
        function bindings_activate(object: GObject.Object, keyval: number, modifiers: Gdk.ModifierType | null): boolean;
        /**
         * Looks up key bindings for `object` to find one matching
         * `event,` and if one was found, activate it.
         * @param object a #GObject (generally must be a widget)
         * @param event a #GdkEventKey
         * @returns %TRUE if a matching key binding was found
         */
        function bindings_activate_event(object: GObject.Object, event: Gdk.EventKey): boolean;
        function builder_error_quark(): GLib.Quark;
        /**
         * This function is supposed to be called in #GtkWidget::draw
         * implementations for widgets that support multiple windows.
         * `cr` must be untransformed from invoking of the draw function.
         * This function will return %TRUE if the contents of the given
         * `window` are supposed to be drawn and %FALSE otherwise. Note
         * that when the drawing was not initiated by the windowing
         * system this function will return %TRUE for all windows, so
         * you need to draw the bottommost window first. Also, do not
         * use “else if” statements to check which window should be drawn.
         * @param cr a cairo context
         * @param window the window to check. @window may not be an input-only          window.
         * @returns %TRUE if @window should be drawn
         */
        function cairo_should_draw_window(cr: cairo.Context, window: Gdk.Window): boolean;
        /**
         * Transforms the given cairo context `cr` that from `widget-relative`
         * coordinates to `window-relative` coordinates.
         * If the `widget’`s window is not an ancestor of `window,` no
         * modification will be applied.
         *
         * This is the inverse to the transformation GTK applies when
         * preparing an expose event to be emitted with the #GtkWidget::draw
         * signal. It is intended to help porting multiwindow widgets from
         * GTK+ 2 to the rendering architecture of GTK+ 3.
         * @param cr the cairo context to transform
         * @param widget the widget the context is currently centered for
         * @param window the window to transform the context to
         */
        function cairo_transform_to_window(cr: cairo.Context, widget: Widget, window: Gdk.Window): void;
        /**
         * Checks that the GTK+ library in use is compatible with the
         * given version. Generally you would pass in the constants
         * #GTK_MAJOR_VERSION, #GTK_MINOR_VERSION, #GTK_MICRO_VERSION
         * as the three arguments to this function; that produces
         * a check that the library in use is compatible with
         * the version of GTK+ the application or module was compiled
         * against.
         *
         * Compatibility is defined by two things: first the version
         * of the running library is newer than the version
         * `required_major`.required_minor.`required_micro`. Second
         * the running library must be binary compatible with the
         * version `required_major`.required_minor.`required_micro`
         * (same major version.)
         *
         * This function is primarily for GTK+ modules; the module
         * can call this function to check that it wasn’t loaded
         * into an incompatible version of GTK+. However, such a
         * check isn’t completely reliable, since the module may be
         * linked against an old version of GTK+ and calling the
         * old version of gtk_check_version(), but still get loaded
         * into an application using a newer version of GTK+.
         * @param required_major the required major version
         * @param required_minor the required minor version
         * @param required_micro the required micro version
         * @returns %NULL if the GTK+ library is compatible with the   given version, or a string describing the version mismatch.   The returned string is owned by GTK+ and should not be modified   or freed.
         */
        function check_version(required_major: number, required_minor: number, required_micro: number): string | null;
        function css_provider_error_quark(): GLib.Quark;
        /**
         * Adds a GTK+ grab on `device,` so all the events on `device` and its
         * associated pointer or keyboard (if any) are delivered to `widget`.
         * If the `block_others` parameter is %TRUE, any other devices will be
         * unable to interact with `widget` during the grab.
         * @param widget a #GtkWidget
         * @param device a #GdkDevice to grab on.
         * @param block_others %TRUE to prevent other devices to interact with @widget.
         */
        function device_grab_add(widget: Widget, device: Gdk.Device, block_others: boolean): void;
        /**
         * Removes a device grab from the given widget.
         *
         * You have to pair calls to gtk_device_grab_add() and
         * gtk_device_grab_remove().
         * @param widget a #GtkWidget
         * @param device a #GdkDevice
         */
        function device_grab_remove(widget: Widget, device: Gdk.Device): void;
        /**
         * Prevents gtk_init(), gtk_init_check(), gtk_init_with_args() and
         * gtk_parse_args() from automatically
         * calling `setlocale (LC_ALL, "")`. You would
         * want to use this function if you wanted to set the locale for
         * your program to something other than the user’s locale, or if
         * you wanted to set different values for different locale categories.
         *
         * Most programs should not need to call this function.
         */
        function disable_setlocale(): void;
        /**
         * Distributes `extra_space` to child `sizes` by bringing smaller
         * children up to natural size first.
         *
         * The remaining space will be added to the `minimum_size` member of the
         * GtkRequestedSize struct. If all sizes reach their natural size then
         * the remaining space is returned.
         * @param extra_space Extra space to redistribute among children after subtracting               minimum sizes and any child padding from the overall allocation
         * @param n_requested_sizes Number of requests to fit into the allocation
         * @param sizes An array of structs with a client pointer and a minimum/natural size         in the orientation of the allocation.
         * @returns The remainder of @extra_space after redistributing space to @sizes.
         */
        function distribute_natural_allocation(
            extra_space: number,
            n_requested_sizes: number,
            sizes: RequestedSize,
        ): number;
        /**
         * Cancels an ongoing drag operation on the source side.
         *
         * If you want to be able to cancel a drag operation in this way,
         * you need to keep a pointer to the drag context, either from an
         * explicit call to gtk_drag_begin_with_coordinates(), or by
         * connecting to #GtkWidget::drag-begin.
         *
         * If `context` does not refer to an ongoing drag operation, this
         * function does nothing.
         *
         * If a drag is cancelled in this way, the `result` argument of
         * #GtkWidget::drag-failed is set to `GTK_DRAG_RESULT_ERROR`.
         * @param context a #GdkDragContext, as e.g. returned by gtk_drag_begin_with_coordinates()
         */
        function drag_cancel(context: Gdk.DragContext): void;
        /**
         * Informs the drag source that the drop is finished, and
         * that the data of the drag will no longer be required.
         * @param context the drag context
         * @param success a flag indicating whether the drop was successful
         * @param del a flag indicating whether the source should delete the   original data. (This should be %TRUE for a move)
         * @param time_ the timestamp from the #GtkWidget::drag-drop signal
         */
        function drag_finish(context: Gdk.DragContext, success: boolean, del: boolean, time_: number): void;
        /**
         * Determines the source widget for a drag.
         * @param context a (destination side) drag context
         * @returns if the drag is occurring     within a single application, a pointer to the source widget.     Otherwise, %NULL.
         */
        function drag_get_source_widget(context: Gdk.DragContext): Widget | null;
        /**
         * Sets the icon for a particular drag to the default
         * icon.
         * @param context the context for a drag (This must be called     with a  context for the source side of a drag)
         */
        function drag_set_icon_default(context: Gdk.DragContext): void;
        /**
         * Sets the icon for a given drag from the given `icon`.
         * See the documentation for gtk_drag_set_icon_name()
         * for more details about using icons in drag and drop.
         * @param context the context for a drag (This must be called     with a context for the source side of a drag)
         * @param icon a #GIcon
         * @param hot_x the X offset of the hotspot within the icon
         * @param hot_y the Y offset of the hotspot within the icon
         */
        function drag_set_icon_gicon(context: Gdk.DragContext, icon: Gio.Icon, hot_x: number, hot_y: number): void;
        /**
         * Sets the icon for a given drag from a named themed icon. See
         * the docs for #GtkIconTheme for more details. Note that the
         * size of the icon depends on the icon theme (the icon is
         * loaded at the symbolic size #GTK_ICON_SIZE_DND), thus
         * `hot_x` and `hot_y` have to be used with care.
         * @param context the context for a drag (This must be called     with a context for the source side of a drag)
         * @param icon_name name of icon to use
         * @param hot_x the X offset of the hotspot within the icon
         * @param hot_y the Y offset of the hotspot within the icon
         */
        function drag_set_icon_name(context: Gdk.DragContext, icon_name: string, hot_x: number, hot_y: number): void;
        /**
         * Sets `pixbuf` as the icon for a given drag.
         * @param context the context for a drag (This must be called            with a  context for the source side of a drag)
         * @param pixbuf the #GdkPixbuf to use as the drag icon
         * @param hot_x the X offset within @widget of the hotspot
         * @param hot_y the Y offset within @widget of the hotspot
         */
        function drag_set_icon_pixbuf(
            context: Gdk.DragContext,
            pixbuf: GdkPixbuf.Pixbuf,
            hot_x: number,
            hot_y: number,
        ): void;
        /**
         * Sets the icon for a given drag from a stock ID.
         * @param context the context for a drag (This must be called            with a  context for the source side of a drag)
         * @param stock_id the ID of the stock icon to use for the drag
         * @param hot_x the X offset within the icon of the hotspot
         * @param hot_y the Y offset within the icon of the hotspot
         */
        function drag_set_icon_stock(context: Gdk.DragContext, stock_id: string, hot_x: number, hot_y: number): void;
        /**
         * Sets `surface` as the icon for a given drag. GTK+ retains
         * references for the arguments, and will release them when
         * they are no longer needed.
         *
         * To position the surface relative to the mouse, use
         * cairo_surface_set_device_offset() on `surface`. The mouse
         * cursor will be positioned at the (0,0) coordinate of the
         * surface.
         * @param context the context for a drag (This must be called     with a context for the source side of a drag)
         * @param surface the surface to use as icon
         */
        function drag_set_icon_surface(context: Gdk.DragContext, surface: cairo.Surface): void;
        /**
         * Changes the icon for drag operation to a given widget.
         * GTK+ will not destroy the widget, so if you don’t want
         * it to persist, you should connect to the “drag-end”
         * signal and destroy it yourself.
         * @param context the context for a drag. (This must be called           with a context for the source side of a drag)
         * @param widget a widget to use as an icon
         * @param hot_x the X offset within @widget of the hotspot
         * @param hot_y the Y offset within @widget of the hotspot
         */
        function drag_set_icon_widget(context: Gdk.DragContext, widget: Widget, hot_x: number, hot_y: number): void;
        /**
         * Draws a text caret on `cr` at `location`. This is not a style function
         * but merely a convenience function for drawing the standard cursor shape.
         * @param widget a #GtkWidget
         * @param cr cairo context to draw to
         * @param location location where to draw the cursor (@location->width is ignored)
         * @param is_primary if the cursor should be the primary cursor color.
         * @param direction whether the cursor is left-to-right or             right-to-left. Should never be #GTK_TEXT_DIR_NONE
         * @param draw_arrow %TRUE to draw a directional arrow on the        cursor. Should be %FALSE unless the cursor is split.
         */
        function draw_insertion_cursor(
            widget: Widget,
            cr: cairo.Context,
            location: Gdk.Rectangle,
            is_primary: boolean,
            direction: TextDirection | null,
            draw_arrow: boolean,
        ): void;
        /**
         * Checks if any events are pending.
         *
         * This can be used to update the UI and invoke timeouts etc.
         * while doing some time intensive computation.
         *
         * ## Updating the UI during a long computation
         *
         *
         * ```c
         *  // computation going on...
         *
         *  while (gtk_events_pending ())
         *    gtk_main_iteration ();
         *
         *  // ...computation continued
         * ```
         *
         * @returns %TRUE if any events are pending, %FALSE otherwise
         */
        function events_pending(): boolean;
        /**
         * Analogical to gtk_true(), this function does nothing
         * but always returns %FALSE.
         * @returns %FALSE
         */
        function __false(): boolean;
        /**
         * Registers an error quark for #GtkFileChooser if necessary.
         * @returns The error quark used for #GtkFileChooser errors.
         */
        function file_chooser_error_quark(): GLib.Quark;
        /**
         * Returns the binary age as passed to `libtool`
         * when building the GTK+ library the process is running against.
         * If `libtool` means nothing to you, don't
         * worry about it.
         * @returns the binary age of the GTK+ library
         */
        function get_binary_age(): number;
        /**
         * Obtains a copy of the event currently being processed by GTK+.
         *
         * For example, if you are handling a #GtkButton::clicked signal,
         * the current event will be the #GdkEventButton that triggered
         * the ::clicked signal.
         * @returns a copy of the current event, or     %NULL if there is no current event. The returned event must be     freed with gdk_event_free().
         */
        function get_current_event(): Gdk.Event | null;
        /**
         * If there is a current event and it has a device, return that
         * device, otherwise return %NULL.
         * @returns a #GdkDevice, or %NULL
         */
        function get_current_event_device(): Gdk.Device | null;
        /**
         * If there is a current event and it has a state field, place
         * that state field in `state` and return %TRUE, otherwise return
         * %FALSE.
         * @returns %TRUE if there was a current event and it     had a state field
         */
        function get_current_event_state(): [boolean, Gdk.ModifierType];
        /**
         * If there is a current event and it has a timestamp,
         * return that timestamp, otherwise return %GDK_CURRENT_TIME.
         * @returns the timestamp from the current event,     or %GDK_CURRENT_TIME.
         */
        function get_current_event_time(): number;
        /**
         * Returns the GTK+ debug flags.
         *
         * This function is intended for GTK+ modules that want
         * to adjust their debug output based on GTK+ debug flags.
         * @returns the GTK+ debug flags.
         */
        function get_debug_flags(): number;
        /**
         * Returns the #PangoLanguage for the default language currently in
         * effect. (Note that this can change over the life of an
         * application.) The default language is derived from the current
         * locale. It determines, for example, whether GTK+ uses the
         * right-to-left or left-to-right text direction.
         *
         * This function is equivalent to pango_language_get_default().
         * See that function for details.
         * @returns the default language as a #PangoLanguage,     must not be freed
         */
        function get_default_language(): Pango.Language;
        /**
         * If `event` is %NULL or the event was not associated with any widget,
         * returns %NULL, otherwise returns the widget that received the event
         * originally.
         * @param event a #GdkEvent
         * @returns the widget that originally     received @event, or %NULL
         */
        function get_event_widget(event: Gdk.Event): Widget | null;
        /**
         * Returns the interface age as passed to `libtool`
         * when building the GTK+ library the process is running against.
         * If `libtool` means nothing to you, don't
         * worry about it.
         * @returns the interface age of the GTK+ library
         */
        function get_interface_age(): number;
        /**
         * Get the direction of the current locale. This is the expected
         * reading direction for text and UI.
         *
         * This function depends on the current locale being set with
         * setlocale() and will default to setting the %GTK_TEXT_DIR_LTR
         * direction otherwise. %GTK_TEXT_DIR_NONE will never be returned.
         *
         * GTK+ sets the default text direction according to the locale
         * during gtk_init(), and you should normally use
         * gtk_widget_get_direction() or gtk_widget_get_default_direction()
         * to obtain the current direcion.
         *
         * This function is only needed rare cases when the locale is
         * changed after GTK+ has already been initialized. In this case,
         * you can use it to update the default text direction as follows:
         *
         *
         * ```c
         * setlocale (LC_ALL, new_locale);
         * direction = gtk_get_locale_direction ();
         * gtk_widget_set_default_direction (direction);
         * ```
         *
         * @returns the #GtkTextDirection of the current locale
         */
        function get_locale_direction(): TextDirection;
        /**
         * Returns the major version number of the GTK+ library.
         * (e.g. in GTK+ version 3.1.5 this is 3.)
         *
         * This function is in the library, so it represents the GTK+ library
         * your code is running against. Contrast with the #GTK_MAJOR_VERSION
         * macro, which represents the major version of the GTK+ headers you
         * have included when compiling your code.
         * @returns the major version number of the GTK+ library
         */
        function get_major_version(): number;
        /**
         * Returns the micro version number of the GTK+ library.
         * (e.g. in GTK+ version 3.1.5 this is 5.)
         *
         * This function is in the library, so it represents the GTK+ library
         * your code is are running against. Contrast with the
         * #GTK_MICRO_VERSION macro, which represents the micro version of the
         * GTK+ headers you have included when compiling your code.
         * @returns the micro version number of the GTK+ library
         */
        function get_micro_version(): number;
        /**
         * Returns the minor version number of the GTK+ library.
         * (e.g. in GTK+ version 3.1.5 this is 1.)
         *
         * This function is in the library, so it represents the GTK+ library
         * your code is are running against. Contrast with the
         * #GTK_MINOR_VERSION macro, which represents the minor version of the
         * GTK+ headers you have included when compiling your code.
         * @returns the minor version number of the GTK+ library
         */
        function get_minor_version(): number;
        /**
         * Returns a #GOptionGroup for the commandline arguments recognized
         * by GTK+ and GDK.
         *
         * You should add this group to your #GOptionContext
         * with g_option_context_add_group(), if you are using
         * g_option_context_parse() to parse your commandline arguments.
         * @param open_default_display whether to open the default display     when parsing the commandline arguments
         * @returns a #GOptionGroup for the commandline     arguments recognized by GTK+
         */
        function get_option_group(open_default_display: boolean): GLib.OptionGroup;
        /**
         * Queries the current grab of the default window group.
         * @returns The widget which currently     has the grab or %NULL if no grab is active
         */
        function grab_get_current(): Widget | null;
        /**
         * Looks up the icon size associated with `name`.
         * @param name the name to look up.
         * @returns the icon size (#GtkIconSize)
         */
        function icon_size_from_name(name: string): number;
        /**
         * Gets the canonical name of the given icon size. The returned string
         * is statically allocated and should not be freed.
         * @param size a #GtkIconSize.
         * @returns the name of the given icon size.
         */
        function icon_size_get_name(size: number): string;
        /**
         * Obtains the pixel size of a semantic icon size `size:`
         * #GTK_ICON_SIZE_MENU, #GTK_ICON_SIZE_BUTTON, etc.  This function
         * isn’t normally needed, gtk_icon_theme_load_icon() is the usual
         * way to get an icon for rendering, then just look at the size of
         * the rendered pixbuf. The rendered pixbuf may not even correspond to
         * the width/height returned by gtk_icon_size_lookup(), because themes
         * are free to render the pixbuf however they like, including changing
         * the usual size.
         * @param size an icon size (#GtkIconSize)
         * @returns %TRUE if @size was a valid size
         */
        function icon_size_lookup(size: number): [boolean, number, number];
        /**
         * Obtains the pixel size of a semantic icon size, possibly
         * modified by user preferences for a particular
         * #GtkSettings. Normally `size` would be
         * #GTK_ICON_SIZE_MENU, #GTK_ICON_SIZE_BUTTON, etc.  This function
         * isn’t normally needed, gtk_widget_render_icon_pixbuf() is the usual
         * way to get an icon for rendering, then just look at the size of
         * the rendered pixbuf. The rendered pixbuf may not even correspond to
         * the width/height returned by gtk_icon_size_lookup(), because themes
         * are free to render the pixbuf however they like, including changing
         * the usual size.
         * @param settings a #GtkSettings object, used to determine   which set of user preferences to used.
         * @param size an icon size (#GtkIconSize)
         * @returns %TRUE if @size was a valid size
         */
        function icon_size_lookup_for_settings(settings: Settings, size: number): [boolean, number, number];
        /**
         * Registers a new icon size, along the same lines as #GTK_ICON_SIZE_MENU,
         * etc. Returns the integer value for the size.
         * @param name name of the icon size
         * @param width the icon width
         * @param height the icon height
         * @returns integer value representing the size (#GtkIconSize)
         */
        function icon_size_register(name: string, width: number, height: number): number;
        /**
         * Registers `alias` as another name for `target`.
         * So calling gtk_icon_size_from_name() with `alias` as argument
         * will return `target`.
         * @param alias an alias for @target
         * @param target an existing icon size (#GtkIconSize)
         */
        function icon_size_register_alias(alias: string, target: number): void;
        function icon_theme_error_quark(): GLib.Quark;
        /**
         * Call this function before using any other GTK+ functions in your GUI
         * applications.  It will initialize everything needed to operate the
         * toolkit and parses some standard command line options.
         *
         * Although you are expected to pass the `argc,` `argv` parameters from main() to
         * this function, it is possible to pass %NULL if `argv` is not available or
         * commandline handling is not required.
         *
         * `argc` and `argv` are adjusted accordingly so your own code will
         * never see those standard arguments.
         *
         * Note that there are some alternative ways to initialize GTK+:
         * if you are calling gtk_parse_args(), gtk_init_check(),
         * gtk_init_with_args() or g_option_context_parse() with
         * the option group returned by gtk_get_option_group(),
         * you don’t have to call gtk_init().
         *
         * And if you are using #GtkApplication, you don't have to call any of the
         * initialization functions either; the #GtkApplication::startup handler
         * does it for you.
         *
         * This function will terminate your program if it was unable to
         * initialize the windowing system for some reason. If you want
         * your program to fall back to a textual interface you want to
         * call gtk_init_check() instead.
         *
         * Since 2.18, GTK+ calls `signal (SIGPIPE, SIG_IGN)`
         * during initialization, to ignore SIGPIPE signals, since these are
         * almost never wanted in graphical applications. If you do need to
         * handle SIGPIPE for some reason, reset the handler after gtk_init(),
         * but notice that other libraries (e.g. libdbus or gvfs) might do
         * similar things.
         * @param argv Address of the     `argv` parameter of main(), or %NULL. Any options     understood by GTK+ are stripped before return.
         */
        function init(argv?: string[] | null): string[] | null;
        /**
         * This function does the same work as gtk_init() with only a single
         * change: It does not terminate the program if the commandline
         * arguments couldn’t be parsed or the windowing system can’t be
         * initialized. Instead it returns %FALSE on failure.
         *
         * This way the application can fall back to some other means of
         * communication with the user - for example a curses or command line
         * interface.
         *
         * Note that calling any GTK function or instantiating any GTK type after
         * this function returns %FALSE results in undefined behavior.
         * @param argv Address of the     `argv` parameter of main(), or %NULL. Any options     understood by GTK+ are stripped before return.
         * @returns %TRUE if the commandline arguments (if any) were valid and     the windowing system has been successfully initialized, %FALSE     otherwise
         */
        function init_check(argv?: string[] | null): [boolean, string[] | null];
        /**
         * This function does the same work as gtk_init_check().
         * Additionally, it allows you to add your own commandline options,
         * and it automatically generates nicely formatted
         * `--help` output. Note that your program will
         * be terminated after writing out the help output.
         * @param argv Address of the     `argv` parameter of main(), or %NULL. Any options     understood by GTK+ are stripped before return.
         * @param parameter_string a string which is displayed in    the first line of `--help` output, after    `programname [OPTION...]`
         * @param entries a %NULL-terminated array    of #GOptionEntrys describing the options of your program
         * @param translation_domain a translation domain to use for translating    the `--help` output for the options in @entries    and the @parameter_string with gettext(), or %NULL
         * @returns %TRUE if the commandline arguments (if any) were valid and     if the windowing system has been successfully initialized,     %FALSE otherwise
         */
        function init_with_args(
            argv: string[] | null,
            parameter_string: string | null,
            entries: GLib.OptionEntry[],
            translation_domain?: string | null,
        ): [boolean, string[] | null];
        /**
         * Removes the key snooper function with the given id.
         * @param snooper_handler_id Identifies the key snooper to remove
         */
        function key_snooper_remove(snooper_handler_id: number): void;
        /**
         * Runs the main loop until gtk_main_quit() is called.
         *
         * You can nest calls to gtk_main(). In that case gtk_main_quit()
         * will make the innermost invocation of the main loop return.
         */
        function main(): void;
        /**
         * Processes a single GDK event.
         *
         * This is public only to allow filtering of events between GDK and GTK+.
         * You will not usually need to call this function directly.
         *
         * While you should not call this function directly, you might want to
         * know how exactly events are handled. So here is what this function
         * does with the event:
         *
         * 1. Compress enter/leave notify events. If the event passed build an
         *    enter/leave pair together with the next event (peeked from GDK), both
         *    events are thrown away. This is to avoid a backlog of (de-)highlighting
         *    widgets crossed by the pointer.
         *
         * 2. Find the widget which got the event. If the widget can’t be determined
         *    the event is thrown away unless it belongs to a INCR transaction.
         *
         * 3. Then the event is pushed onto a stack so you can query the currently
         *    handled event with gtk_get_current_event().
         *
         * 4. The event is sent to a widget. If a grab is active all events for widgets
         *    that are not in the contained in the grab widget are sent to the latter
         *    with a few exceptions:
         *    - Deletion and destruction events are still sent to the event widget for
         *      obvious reasons.
         *    - Events which directly relate to the visual representation of the event
         *      widget.
         *    - Leave events are delivered to the event widget if there was an enter
         *      event delivered to it before without the paired leave event.
         *    - Drag events are not redirected because it is unclear what the semantics
         *      of that would be.
         *    Another point of interest might be that all key events are first passed
         *    through the key snooper functions if there are any. Read the description
         *    of gtk_key_snooper_install() if you need this feature.
         *
         * 5. After finishing the delivery the event is popped from the event stack.
         * @param event An event to process (normally passed by GDK)
         */
        function main_do_event(event: Gdk.Event): void;
        /**
         * Runs a single iteration of the mainloop.
         *
         * If no events are waiting to be processed GTK+ will block
         * until the next event is noticed. If you don’t want to block
         * look at gtk_main_iteration_do() or check if any events are
         * pending with gtk_events_pending() first.
         * @returns %TRUE if gtk_main_quit() has been called for the     innermost mainloop
         */
        function main_iteration(): boolean;
        /**
         * Runs a single iteration of the mainloop.
         * If no events are available either return or block depending on
         * the value of `blocking`.
         * @param blocking %TRUE if you want GTK+ to block if no events are pending
         * @returns %TRUE if gtk_main_quit() has been called for the     innermost mainloop
         */
        function main_iteration_do(blocking: boolean): boolean;
        /**
         * Asks for the current nesting level of the main loop.
         * @returns the nesting level of the current invocation     of the main loop
         */
        function main_level(): number;
        /**
         * Makes the innermost invocation of the main loop return
         * when it regains control.
         */
        function main_quit(): void;
        /**
         * Draws an arrow in the given rectangle on `cr` using the given
         * parameters. `arrow_type` determines the direction of the arrow.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type the type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param arrow_type the type of arrow to draw
         * @param fill %TRUE if the arrow tip should be filled
         * @param x x origin of the rectangle to draw the arrow in
         * @param y y origin of the rectangle to draw the arrow in
         * @param width width of the rectangle to draw the arrow in
         * @param height height of the rectangle to draw the arrow in
         */
        function paint_arrow(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            arrow_type: ArrowType | null,
            fill: boolean,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a box on `cr` with the given parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type the type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the box
         * @param y y origin of the box
         * @param width the width of the box
         * @param height the height of the box
         */
        function paint_box(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a box in `cr` using the given style and state and shadow type,
         * leaving a gap in one side.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the rectangle
         * @param y y origin of the rectangle
         * @param width width of the rectangle
         * @param height width of the rectangle
         * @param gap_side side in which to leave the gap
         * @param gap_x starting position of the gap
         * @param gap_width width of the gap
         */
        function paint_box_gap(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
            gap_side: PositionType | null,
            gap_x: number,
            gap_width: number,
        ): void;
        /**
         * Draws a check button indicator in the given rectangle on `cr` with
         * the given parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type the type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the rectangle to draw the check in
         * @param y y origin of the rectangle to draw the check in
         * @param width the width of the rectangle to draw the check in
         * @param height the height of the rectangle to draw the check in
         */
        function paint_check(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a diamond in the given rectangle on `window` using the given
         * parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type the type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the rectangle to draw the diamond in
         * @param y y origin of the rectangle to draw the diamond in
         * @param width width of the rectangle to draw the diamond in
         * @param height height of the rectangle to draw the diamond in
         */
        function paint_diamond(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws an expander as used in #GtkTreeView. `x` and `y` specify the
         * center the expander. The size of the expander is determined by the
         * “expander-size” style property of `widget`.  (If widget is not
         * specified or doesn’t have an “expander-size” property, an
         * unspecified default size will be used, since the caller doesn't
         * have sufficient information to position the expander, this is
         * likely not useful.) The expander is expander_size pixels tall
         * in the collapsed position and expander_size pixels wide in the
         * expanded position.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param widget the widget
         * @param detail a style detail
         * @param x the x position to draw the expander at
         * @param y the y position to draw the expander at
         * @param expander_style the style to draw the expander in; determines   whether the expander is collapsed, expanded, or in an   intermediate state.
         */
        function paint_expander(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            expander_style: ExpanderStyle | null,
        ): void;
        /**
         * Draws an extension, i.e. a notebook tab.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the extension
         * @param y y origin of the extension
         * @param width width of the extension
         * @param height width of the extension
         * @param gap_side the side on to which the extension is attached
         */
        function paint_extension(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
            gap_side: PositionType | null,
        ): void;
        /**
         * Draws a flat box on `cr` with the given parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type the type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the box
         * @param y y origin of the box
         * @param width the width of the box
         * @param height the height of the box
         */
        function paint_flat_box(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a focus indicator around the given rectangle on `cr` using the
         * given style.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param widget the widget
         * @param detail a style detail
         * @param x the x origin of the rectangle around which to draw a focus indicator
         * @param y the y origin of the rectangle around which to draw a focus indicator
         * @param width the width of the rectangle around which to draw a focus indicator
         * @param height the height of the rectangle around which to draw a focus indicator
         */
        function paint_focus(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a handle as used in #GtkHandleBox and #GtkPaned.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the handle
         * @param y y origin of the handle
         * @param width with of the handle
         * @param height height of the handle
         * @param orientation the orientation of the handle
         */
        function paint_handle(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
            orientation: Orientation | null,
        ): void;
        /**
         * Draws a horizontal line from (`x1`, `y)` to (`x2`, `y)` in `cr`
         * using the given style and state.
         * @param style a #GtkStyle
         * @param cr a #caio_t
         * @param state_type a state
         * @param widget the widget
         * @param detail a style detail
         * @param x1 the starting x coordinate
         * @param x2 the ending x coordinate
         * @param y the y coordinate
         */
        function paint_hline(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            widget: Widget | null,
            detail: string | null,
            x1: number,
            x2: number,
            y: number,
        ): void;
        /**
         * Draws a layout on `cr` using the given parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param use_text whether to use the text or foreground            graphics context of @style
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin
         * @param y y origin
         * @param layout the layout to draw
         */
        function paint_layout(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            use_text: boolean,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            layout: Pango.Layout,
        ): void;
        /**
         * Draws a radio button indicator in the given rectangle on `cr` with
         * the given parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type the type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the rectangle to draw the option in
         * @param y y origin of the rectangle to draw the option in
         * @param width the width of the rectangle to draw the option in
         * @param height the height of the rectangle to draw the option in
         */
        function paint_option(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a resize grip in the given rectangle on `cr` using the given
         * parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param widget the widget
         * @param detail a style detail
         * @param edge the edge in which to draw the resize grip
         * @param x the x origin of the rectangle in which to draw the resize grip
         * @param y the y origin of the rectangle in which to draw the resize grip
         * @param width the width of the rectangle in which to draw the resize grip
         * @param height the height of the rectangle in which to draw the resize grip
         */
        function paint_resize_grip(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            widget: Widget | null,
            detail: string | null,
            edge: Gdk.WindowEdge | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a shadow around the given rectangle in `cr`
         * using the given style and state and shadow type.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the rectangle
         * @param y y origin of the rectangle
         * @param width width of the rectangle
         * @param height width of the rectangle
         */
        function paint_shadow(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a shadow around the given rectangle in `cr`
         * using the given style and state and shadow type, leaving a
         * gap in one side.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the rectangle
         * @param y y origin of the rectangle
         * @param width width of the rectangle
         * @param height width of the rectangle
         * @param gap_side side in which to leave the gap
         * @param gap_x starting position of the gap
         * @param gap_width width of the gap
         */
        function paint_shadow_gap(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
            gap_side: PositionType | null,
            gap_x: number,
            gap_width: number,
        ): void;
        /**
         * Draws a slider in the given rectangle on `cr` using the
         * given style and orientation.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type a shadow
         * @param widget the widget
         * @param detail a style detail
         * @param x the x origin of the rectangle in which to draw a slider
         * @param y the y origin of the rectangle in which to draw a slider
         * @param width the width of the rectangle in which to draw a slider
         * @param height the height of the rectangle in which to draw a slider
         * @param orientation the orientation to be used
         */
        function paint_slider(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
            orientation: Orientation | null,
        ): void;
        /**
         * Draws a spinner on `window` using the given parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param widget the widget (may be %NULL)
         * @param detail a style detail (may be %NULL)
         * @param step the nth step
         * @param x the x origin of the rectangle in which to draw the spinner
         * @param y the y origin of the rectangle in which to draw the spinner
         * @param width the width of the rectangle in which to draw the spinner
         * @param height the height of the rectangle in which to draw the spinner
         */
        function paint_spinner(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            widget: Widget | null,
            detail: string | null,
            step: number,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws an option menu tab (i.e. the up and down pointing arrows)
         * in the given rectangle on `cr` using the given parameters.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param shadow_type the type of shadow to draw
         * @param widget the widget
         * @param detail a style detail
         * @param x x origin of the rectangle to draw the tab in
         * @param y y origin of the rectangle to draw the tab in
         * @param width the width of the rectangle to draw the tab in
         * @param height the height of the rectangle to draw the tab in
         */
        function paint_tab(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            shadow_type: ShadowType | null,
            widget: Widget | null,
            detail: string | null,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Draws a vertical line from (`x,` `y1`_) to (`x,` `y2`_) in `cr`
         * using the given style and state.
         * @param style a #GtkStyle
         * @param cr a #cairo_t
         * @param state_type a state
         * @param widget the widget
         * @param detail a style detail
         * @param y1_ the starting y coordinate
         * @param y2_ the ending y coordinate
         * @param x the x coordinate
         */
        function paint_vline(
            style: Style,
            cr: cairo.Context,
            state_type: StateType | null,
            widget: Widget | null,
            detail: string | null,
            y1_: number,
            y2_: number,
            x: number,
        ): void;
        /**
         * Returns the name of the default paper size, which
         * depends on the current locale.
         * @returns the name of the default paper size. The string is owned by GTK+ and should not be modified.
         */
        function paper_size_get_default(): string;
        /**
         * Creates a list of known paper sizes.
         * @param include_custom whether to include custom paper sizes     as defined in the page setup dialog
         * @returns a newly allocated list of newly    allocated #GtkPaperSize objects
         */
        function paper_size_get_paper_sizes(include_custom: boolean): PaperSize[];
        /**
         * Parses command line arguments, and initializes global
         * attributes of GTK+, but does not actually open a connection
         * to a display. (See gdk_display_open(), gdk_get_display_arg_name())
         *
         * Any arguments used by GTK+ or GDK are removed from the array and
         * `argc` and `argv` are updated accordingly.
         *
         * There is no need to call this function explicitly if you are using
         * gtk_init(), or gtk_init_check().
         *
         * Note that many aspects of GTK+ require a display connection to
         * function, so this way of initializing GTK+ is really only useful
         * for specialized use cases.
         * @param argv a pointer to the array of     command line arguments
         * @returns %TRUE if initialization succeeded, otherwise %FALSE
         */
        function parse_args(argv: string[]): [boolean, string[]];
        /**
         * Registers an error quark for #GtkPrintOperation if necessary.
         * @returns The error quark used for #GtkPrintOperation errors.
         */
        function print_error_quark(): GLib.Quark;
        /**
         * Runs a page setup dialog, letting the user modify the values from
         * `page_setup`. If the user cancels the dialog, the returned #GtkPageSetup
         * is identical to the passed in `page_setup,` otherwise it contains the
         * modifications done in the dialog.
         *
         * Note that this function may use a recursive mainloop to show the page
         * setup dialog. See gtk_print_run_page_setup_dialog_async() if this is
         * a problem.
         * @param parent transient parent
         * @param page_setup an existing #GtkPageSetup
         * @param settings a #GtkPrintSettings
         * @returns a new #GtkPageSetup
         */
        function print_run_page_setup_dialog(
            parent: Window | null,
            page_setup: PageSetup | null,
            settings: PrintSettings,
        ): PageSetup;
        /**
         * Runs a page setup dialog, letting the user modify the values from `page_setup`.
         *
         * In contrast to gtk_print_run_page_setup_dialog(), this function  returns after
         * showing the page setup dialog on platforms that support this, and calls `done_cb`
         * from a signal handler for the ::response signal of the dialog.
         * @param parent transient parent, or %NULL
         * @param page_setup an existing #GtkPageSetup, or %NULL
         * @param settings a #GtkPrintSettings
         * @param done_cb a function to call when the user saves           the modified page setup
         */
        function print_run_page_setup_dialog_async(
            parent: Window | null,
            page_setup: PageSetup | null,
            settings: PrintSettings,
            done_cb: PageSetupDoneFunc,
        ): void;
        /**
         * Sends an event to a widget, propagating the event to parent widgets
         * if the event remains unhandled.
         *
         * Events received by GTK+ from GDK normally begin in gtk_main_do_event().
         * Depending on the type of event, existence of modal dialogs, grabs, etc.,
         * the event may be propagated; if so, this function is used.
         *
         * gtk_propagate_event() calls gtk_widget_event() on each widget it
         * decides to send the event to. So gtk_widget_event() is the lowest-level
         * function; it simply emits the #GtkWidget::event and possibly an
         * event-specific signal on a widget. gtk_propagate_event() is a bit
         * higher-level, and gtk_main_do_event() is the highest level.
         *
         * All that said, you most likely don’t want to use any of these
         * functions; synthesizing events is rarely needed. There are almost
         * certainly better ways to achieve your goals. For example, use
         * gdk_window_invalidate_rect() or gtk_widget_queue_draw() instead
         * of making up expose events.
         * @param widget a #GtkWidget
         * @param event an event
         */
        function propagate_event(widget: Widget, event: Gdk.Event): void;
        /**
         * Adds a file to the list of files to be parsed at the
         * end of gtk_init().
         * @param filename the pathname to the file. If @filename    is not absolute, it is searched in the current directory.
         */
        function rc_add_default_file(filename: string): void;
        /**
         * Searches for a theme engine in the GTK+ search path. This function
         * is not useful for applications and should not be used.
         * @param module_file name of a theme engine
         * @returns The filename, if found (must be   freed with g_free()), otherwise %NULL.
         */
        function rc_find_module_in_path(module_file: string): string;
        /**
         * Looks up a file in pixmap path for the specified #GtkSettings.
         * If the file is not found, it outputs a warning message using
         * g_warning() and returns %NULL.
         * @param settings a #GtkSettings
         * @param scanner Scanner used to get line number information for the   warning message, or %NULL
         * @param pixmap_file name of the pixmap file to locate.
         * @returns the filename.
         */
        function rc_find_pixmap_in_path(settings: Settings, scanner: GLib.Scanner, pixmap_file: string): string;
        /**
         * Retrieves the current list of RC files that will be parsed
         * at the end of gtk_init().
         * @returns A %NULL-terminated array of filenames.  This memory is owned     by GTK+ and must not be freed by the application.  If you want     to store this information, you should make a copy.
         */
        function rc_get_default_files(): string[];
        /**
         * Obtains the path to the IM modules file. See the documentation
         * of the `GTK_IM_MODULE_FILE`
         * environment variable for more details.
         * @returns a newly-allocated string containing the    name of the file listing the IM modules available for loading
         */
        function rc_get_im_module_file(): string;
        /**
         * Obtains the path in which to look for IM modules. See the documentation
         * of the `GTK_PATH`
         * environment variable for more details about looking up modules. This
         * function is useful solely for utilities supplied with GTK+ and should
         * not be used by applications under normal circumstances.
         * @returns a newly-allocated string containing the    path in which to look for IM modules.
         */
        function rc_get_im_module_path(): string;
        /**
         * Returns a directory in which GTK+ looks for theme engines.
         * For full information about the search for theme engines,
         * see the docs for `GTK_PATH` in [Running GTK+ Applications][gtk-running].
         * @returns the directory. (Must be freed with g_free())
         */
        function rc_get_module_dir(): string;
        /**
         * Finds all matching RC styles for a given widget,
         * composites them together, and then creates a
         * #GtkStyle representing the composite appearance.
         * (GTK+ actually keeps a cache of previously
         * created styles, so a new style may not be
         * created.)
         * @param widget a #GtkWidget
         * @returns the resulting style. No refcount is added   to the returned style, so if you want to save this style around,   you should add a reference yourself.
         */
        function rc_get_style(widget: Widget): Style;
        /**
         * Creates up a #GtkStyle from styles defined in a RC file by providing
         * the raw components used in matching. This function may be useful
         * when creating pseudo-widgets that should be themed like widgets but
         * don’t actually have corresponding GTK+ widgets. An example of this
         * would be items inside a GNOME canvas widget.
         *
         * The action of gtk_rc_get_style() is similar to:
         *
         * ```c
         *  gtk_widget_path (widget, NULL, &path, NULL);
         *  gtk_widget_class_path (widget, NULL, &class_path, NULL);
         *  gtk_rc_get_style_by_paths (gtk_widget_get_settings (widget),
         *                             path, class_path,
         *                             G_OBJECT_TYPE (widget));
         * ```
         *
         * @param settings a #GtkSettings object
         * @param widget_path the widget path to use when looking up the     style, or %NULL if no matching against the widget path should be done
         * @param class_path the class path to use when looking up the style,     or %NULL if no matching against the class path should be done.
         * @param type a type that will be used along with parent types of this type     when matching against class styles, or #G_TYPE_NONE
         * @returns A style created by matching     with the supplied paths, or %NULL if nothing matching was     specified and the default style should be used. The returned     value is owned by GTK+ as part of an internal cache, so you     must call g_object_ref() on the returned value if you want to     keep a reference to it.
         */
        function rc_get_style_by_paths(
            settings: Settings,
            widget_path: string | null,
            class_path: string | null,
            type: GObject.GType,
        ): Style | null;
        /**
         * Returns the standard directory in which themes should
         * be installed. (GTK+ does not actually use this directory
         * itself.)
         * @returns The directory (must be freed with g_free()).
         */
        function rc_get_theme_dir(): string;
        /**
         * Parses a given resource file.
         * @param filename the filename of a file to parse. If @filename is not absolute, it  is searched in the current directory.
         */
        function rc_parse(filename: string): void;
        /**
         * Parses a color in the format expected
         * in a RC file.
         *
         * Note that theme engines should use gtk_rc_parse_color_full() in
         * order to support symbolic colors.
         * @param scanner a #GScanner
         * @returns %G_TOKEN_NONE if parsing succeeded, otherwise the token     that was expected but not found
         */
        function rc_parse_color(scanner: GLib.Scanner): [number, Gdk.Color];
        /**
         * Parses a color in the format expected
         * in a RC file. If `style` is not %NULL, it will be consulted to resolve
         * references to symbolic colors.
         * @param scanner a #GScanner
         * @param style a #GtkRcStyle, or %NULL
         * @returns %G_TOKEN_NONE if parsing succeeded, otherwise the token     that was expected but not found
         */
        function rc_parse_color_full(scanner: GLib.Scanner, style: RcStyle | null): [number, Gdk.Color];
        /**
         * Parses a #GtkPathPriorityType variable from the format expected
         * in a RC file.
         * @param scanner a #GScanner (must be initialized for parsing an RC file)
         * @param priority A pointer to #GtkPathPriorityType variable in which  to store the result.
         * @returns %G_TOKEN_NONE if parsing succeeded, otherwise the token   that was expected but not found.
         */
        function rc_parse_priority(scanner: GLib.Scanner, priority: PathPriorityType | null): number;
        /**
         * Parses a #GtkStateType variable from the format expected
         * in a RC file.
         * @param scanner a #GScanner (must be initialized for parsing an RC file)
         * @returns %G_TOKEN_NONE if parsing succeeded, otherwise the token   that was expected but not found.
         */
        function rc_parse_state(scanner: GLib.Scanner): [number, StateType];
        /**
         * Parses resource information directly from a string.
         * @param rc_string a string to parse.
         */
        function rc_parse_string(rc_string: string): void;
        /**
         * A #GtkRcPropertyParser for use with gtk_settings_install_property_parser()
         * or gtk_widget_class_install_style_property_parser() which parses
         * borders in the form
         * `"{ left, right, top, bottom }"` for integers
         * left, right, top and bottom.
         * @param pspec a #GParamSpec
         * @param gstring the #GString to be parsed
         * @param property_value a #GValue which must hold boxed values.
         * @returns %TRUE if @gstring could be parsed and @property_value has been set to the resulting #GtkBorder.
         */
        function rc_property_parse_border(
            pspec: GObject.ParamSpec,
            gstring: GLib.String,
            property_value: GObject.Value | any,
        ): boolean;
        /**
         * A #GtkRcPropertyParser for use with gtk_settings_install_property_parser()
         * or gtk_widget_class_install_style_property_parser() which parses a
         * color given either by its name or in the form
         * `{ red, green, blue }` where red, green and
         * blue are integers between 0 and 65535 or floating-point numbers
         * between 0 and 1.
         * @param pspec a #GParamSpec
         * @param gstring the #GString to be parsed
         * @param property_value a #GValue which must hold #GdkColor values.
         * @returns %TRUE if @gstring could be parsed and @property_value has been set to the resulting #GdkColor.
         */
        function rc_property_parse_color(
            pspec: GObject.ParamSpec,
            gstring: GLib.String,
            property_value: GObject.Value | any,
        ): boolean;
        /**
         * A #GtkRcPropertyParser for use with gtk_settings_install_property_parser()
         * or gtk_widget_class_install_style_property_parser() which parses a single
         * enumeration value.
         *
         * The enumeration value can be specified by its name, its nickname or
         * its numeric value. For consistency with flags parsing, the value
         * may be surrounded by parentheses.
         * @param pspec a #GParamSpec
         * @param gstring the #GString to be parsed
         * @param property_value a #GValue which must hold enum values.
         * @returns %TRUE if @gstring could be parsed and @property_value has been set to the resulting #GEnumValue.
         */
        function rc_property_parse_enum(
            pspec: GObject.ParamSpec,
            gstring: GLib.String,
            property_value: GObject.Value | any,
        ): boolean;
        /**
         * A #GtkRcPropertyParser for use with gtk_settings_install_property_parser()
         * or gtk_widget_class_install_style_property_parser() which parses flags.
         *
         * Flags can be specified by their name, their nickname or
         * numerically. Multiple flags can be specified in the form
         * `"( flag1 | flag2 | ... )"`.
         * @param pspec a #GParamSpec
         * @param gstring the #GString to be parsed
         * @param property_value a #GValue which must hold flags values.
         * @returns %TRUE if @gstring could be parsed and @property_value has been set to the resulting flags value.
         */
        function rc_property_parse_flags(
            pspec: GObject.ParamSpec,
            gstring: GLib.String,
            property_value: GObject.Value | any,
        ): boolean;
        /**
         * A #GtkRcPropertyParser for use with gtk_settings_install_property_parser()
         * or gtk_widget_class_install_style_property_parser() which parses a
         * requisition in the form
         * `"{ width, height }"` for integers %width and %height.
         * @param pspec a #GParamSpec
         * @param gstring the #GString to be parsed
         * @param property_value a #GValue which must hold boxed values.
         * @returns %TRUE if @gstring could be parsed and @property_value has been set to the resulting #GtkRequisition.
         */
        function rc_property_parse_requisition(
            pspec: GObject.ParamSpec,
            gstring: GLib.String,
            property_value: GObject.Value | any,
        ): boolean;
        /**
         * If the modification time on any previously read file for the
         * default #GtkSettings has changed, discard all style information
         * and then reread all previously read RC files.
         * @returns %TRUE if the files were reread.
         */
        function rc_reparse_all(): boolean;
        /**
         * If the modification time on any previously read file
         * for the given #GtkSettings has changed, discard all style information
         * and then reread all previously read RC files.
         * @param settings a #GtkSettings
         * @param force_load load whether or not anything changed
         * @returns %TRUE if the files were reread.
         */
        function rc_reparse_all_for_settings(settings: Settings, force_load: boolean): boolean;
        /**
         * This function recomputes the styles for all widgets that use a
         * particular #GtkSettings object. (There is one #GtkSettings object
         * per #GdkScreen, see gtk_settings_get_for_screen()); It is useful
         * when some global parameter has changed that affects the appearance
         * of all widgets, because when a widget gets a new style, it will
         * both redraw and recompute any cached information about its
         * appearance. As an example, it is used when the default font size
         * set by the operating system changes. Note that this function
         * doesn’t affect widgets that have a style set explicitly on them
         * with gtk_widget_set_style().
         * @param settings a #GtkSettings
         */
        function rc_reset_styles(settings: Settings): void;
        /**
         * Sets the list of files that GTK+ will read at the
         * end of gtk_init().
         * @param filenames A     %NULL-terminated list of filenames.
         */
        function rc_set_default_files(filenames: string[]): void;
        function recent_chooser_error_quark(): GLib.Quark;
        function recent_manager_error_quark(): GLib.Quark;
        /**
         * Renders an activity indicator (such as in #GtkSpinner).
         * The state %GTK_STATE_FLAG_CHECKED determines whether there is
         * activity going on.
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_activity(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders an arrow pointing to `angle`.
         *
         * Typical arrow rendering at 0, 1⁄2 π;, π; and 3⁄2 π:
         *
         * ![](arrows.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param angle arrow angle from 0 to 2 * %G_PI, being 0 the arrow pointing to the north
         * @param x X origin of the render area
         * @param y Y origin of the render area
         * @param size square side for render area
         */
        function render_arrow(
            context: StyleContext,
            cr: cairo.Context,
            angle: number,
            x: number,
            y: number,
            size: number,
        ): void;
        /**
         * Renders the background of an element.
         *
         * Typical background rendering, showing the effect of
         * `background-image`, `border-width` and `border-radius`:
         *
         * ![](background.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_background(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Returns the area that will be affected (i.e. drawn to) when
         * calling gtk_render_background() for the given `context` and
         * rectangle.
         * @param context a #GtkStyleContext
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_background_get_clip(
            context: StyleContext,
            x: number,
            y: number,
            width: number,
            height: number,
        ): Gdk.Rectangle;
        /**
         * Renders a checkmark (as in a #GtkCheckButton).
         *
         * The %GTK_STATE_FLAG_CHECKED state determines whether the check is
         * on or off, and %GTK_STATE_FLAG_INCONSISTENT determines whether it
         * should be marked as undefined.
         *
         * Typical checkmark rendering:
         *
         * ![](checks.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_check(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders an expander (as used in #GtkTreeView and #GtkExpander) in the area
         * defined by `x,` `y,` `width,` `height`. The state %GTK_STATE_FLAG_CHECKED
         * determines whether the expander is collapsed or expanded.
         *
         * Typical expander rendering:
         *
         * ![](expanders.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_expander(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a extension (as in a #GtkNotebook tab) in the rectangle
         * defined by `x,` `y,` `width,` `height`. The side where the extension
         * connects to is defined by `gap_side`.
         *
         * Typical extension rendering:
         *
         * ![](extensions.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         * @param gap_side side where the gap is
         */
        function render_extension(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
            gap_side: PositionType | null,
        ): void;
        /**
         * Renders a focus indicator on the rectangle determined by `x,` `y,` `width,` `height`.
         *
         * Typical focus rendering:
         *
         * ![](focus.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_focus(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a frame around the rectangle defined by `x,` `y,` `width,` `height`.
         *
         * Examples of frame rendering, showing the effect of `border-image`,
         * `border-color`, `border-width`, `border-radius` and junctions:
         *
         * ![](frames.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_frame(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a frame around the rectangle defined by (`x,` `y,` `width,` `height)`,
         * leaving a gap on one side. `xy0`_gap and `xy1`_gap will mean X coordinates
         * for %GTK_POS_TOP and %GTK_POS_BOTTOM gap sides, and Y coordinates for
         * %GTK_POS_LEFT and %GTK_POS_RIGHT.
         *
         * Typical rendering of a frame with a gap:
         *
         * ![](frame-gap.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         * @param gap_side side where the gap is
         * @param xy0_gap initial coordinate (X or Y depending on @gap_side) for the gap
         * @param xy1_gap end coordinate (X or Y depending on @gap_side) for the gap
         */
        function render_frame_gap(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
            gap_side: PositionType | null,
            xy0_gap: number,
            xy1_gap: number,
        ): void;
        /**
         * Renders a handle (as in #GtkHandleBox, #GtkPaned and
         * #GtkWindow’s resize grip), in the rectangle
         * determined by `x,` `y,` `width,` `height`.
         *
         * Handles rendered for the paned and grip classes:
         *
         * ![](handles.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_handle(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders the icon in `pixbuf` at the specified `x` and `y` coordinates.
         *
         * This function will render the icon in `pixbuf` at exactly its size,
         * regardless of scaling factors, which may not be appropriate when
         * drawing on displays with high pixel densities.
         *
         * You probably want to use gtk_render_icon_surface() instead, if you
         * already have a Cairo surface.
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param pixbuf a #GdkPixbuf containing the icon to draw
         * @param x X position for the @pixbuf
         * @param y Y position for the @pixbuf
         */
        function render_icon(
            context: StyleContext,
            cr: cairo.Context,
            pixbuf: GdkPixbuf.Pixbuf,
            x: number,
            y: number,
        ): void;
        /**
         * Renders the icon specified by `source` at the given `size,` returning the result
         * in a pixbuf.
         * @param context a #GtkStyleContext
         * @param source the #GtkIconSource specifying the icon to render
         * @param size the size (#GtkIconSize) to render the icon at.        A size of `(GtkIconSize) -1` means render at the size of the source        and don’t scale.
         * @returns a newly-created #GdkPixbuf containing the rendered icon
         */
        function render_icon_pixbuf(context: StyleContext, source: IconSource, size: number): GdkPixbuf.Pixbuf;
        /**
         * Renders the icon in `surface` at the specified `x` and `y` coordinates.
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param surface a #cairo_surface_t containing the icon to draw
         * @param x X position for the @icon
         * @param y Y position for the @incon
         */
        function render_icon_surface(
            context: StyleContext,
            cr: cairo.Context,
            surface: cairo.Surface,
            x: number,
            y: number,
        ): void;
        /**
         * Draws a text caret on `cr` at the specified index of `layout`.
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin
         * @param y Y origin
         * @param layout the #PangoLayout of the text
         * @param index the index in the #PangoLayout
         * @param direction the #PangoDirection of the text
         */
        function render_insertion_cursor(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            layout: Pango.Layout,
            index: number,
            direction: Pango.Direction | null,
        ): void;
        /**
         * Renders `layout` on the coordinates `x,` `y`
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin
         * @param y Y origin
         * @param layout the #PangoLayout to render
         */
        function render_layout(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            layout: Pango.Layout,
        ): void;
        /**
         * Renders a line from (x0, y0) to (x1, y1).
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x0 X coordinate for the origin of the line
         * @param y0 Y coordinate for the origin of the line
         * @param x1 X coordinate for the end of the line
         * @param y1 Y coordinate for the end of the line
         */
        function render_line(
            context: StyleContext,
            cr: cairo.Context,
            x0: number,
            y0: number,
            x1: number,
            y1: number,
        ): void;
        /**
         * Renders an option mark (as in a #GtkRadioButton), the %GTK_STATE_FLAG_CHECKED
         * state will determine whether the option is on or off, and
         * %GTK_STATE_FLAG_INCONSISTENT whether it should be marked as undefined.
         *
         * Typical option mark rendering:
         *
         * ![](options.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_option(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a slider (as in #GtkScale) in the rectangle defined by `x,` `y,`
         * `width,` `height`. `orientation` defines whether the slider is vertical
         * or horizontal.
         *
         * Typical slider rendering:
         *
         * ![](sliders.png)
         * @param context a #GtkStyleContext
         * @param cr a #cairo_t
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         * @param orientation orientation of the slider
         */
        function render_slider(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
            orientation: Orientation | null,
        ): void;
        /**
         * Converts a color from RGB space to HSV.
         *
         * Input values must be in the [0.0, 1.0] range;
         * output values will be in the same range.
         * @param r Red
         * @param g Green
         * @param b Blue
         */
        function rgb_to_hsv(r: number, g: number, b: number): [number, number, number];
        /**
         * Appends a specified target to the list of supported targets for a
         * given widget and selection.
         * @param widget a #GtkWidget
         * @param selection the selection
         * @param target target to add.
         * @param info A unsigned integer which will be passed back to the application.
         */
        function selection_add_target(widget: Widget, selection: Gdk.Atom, target: Gdk.Atom, info: number): void;
        /**
         * Prepends a table of targets to the list of supported targets
         * for a given widget and selection.
         * @param widget a #GtkWidget
         * @param selection the selection
         * @param targets a table of targets to add
         */
        function selection_add_targets(widget: Widget, selection: Gdk.Atom, targets: TargetEntry[]): void;
        /**
         * Remove all targets registered for the given selection for the
         * widget.
         * @param widget a #GtkWidget
         * @param selection an atom representing a selection
         */
        function selection_clear_targets(widget: Widget, selection: Gdk.Atom): void;
        /**
         * Requests the contents of a selection. When received,
         * a “selection-received” signal will be generated.
         * @param widget The widget which acts as requestor
         * @param selection Which selection to get
         * @param target Form of information desired (e.g., STRING)
         * @param time_ Time of request (usually of triggering event)        In emergency, you could use #GDK_CURRENT_TIME
         * @returns %TRUE if requested succeeded. %FALSE if we could not process          request. (e.g., there was already a request in process for          this widget).
         */
        function selection_convert(widget: Widget, selection: Gdk.Atom, target: Gdk.Atom, time_: number): boolean;
        /**
         * Claims ownership of a given selection for a particular widget,
         * or, if `widget` is %NULL, release ownership of the selection.
         * @param widget a #GtkWidget, or %NULL.
         * @param selection an interned atom representing the selection to claim
         * @param time_ timestamp with which to claim the selection
         * @returns %TRUE if the operation succeeded
         */
        function selection_owner_set(widget: Widget | null, selection: Gdk.Atom, time_: number): boolean;
        /**
         * Claim ownership of a given selection for a particular widget, or,
         * if `widget` is %NULL, release ownership of the selection.
         * @param display the #GdkDisplay where the selection is set
         * @param widget new selection owner (a #GtkWidget), or %NULL.
         * @param selection an interned atom representing the selection to claim.
         * @param time_ timestamp with which to claim the selection
         * @returns TRUE if the operation succeeded
         */
        function selection_owner_set_for_display(
            display: Gdk.Display,
            widget: Widget | null,
            selection: Gdk.Atom,
            time_: number,
        ): boolean;
        /**
         * Removes all handlers and unsets ownership of all
         * selections for a widget. Called when widget is being
         * destroyed. This function will not generally be
         * called by applications.
         * @param widget a #GtkWidget
         */
        function selection_remove_all(widget: Widget): void;
        /**
         * Sets the GTK+ debug flags.
         * @param flags
         */
        function set_debug_flags(flags: number): void;
        /**
         * A convenience function for launching the default application
         * to show the uri. Like gtk_show_uri_on_window(), but takes a screen
         * as transient parent instead of a window.
         *
         * Note that this function is deprecated as it does not pass the necessary
         * information for helpers to parent their dialog properly, when run from
         * sandboxed applications for example.
         * @param screen screen to show the uri on     or %NULL for the default screen
         * @param uri the uri to show
         * @param timestamp a timestamp to prevent focus stealing
         * @returns %TRUE on success, %FALSE on error
         */
        function show_uri(screen: Gdk.Screen | null, uri: string, timestamp: number): boolean;
        /**
         * This is a convenience function for launching the default application
         * to show the uri. The uri must be of a form understood by GIO (i.e. you
         * need to install gvfs to get support for uri schemes such as http://
         * or ftp://, as only local files are handled by GIO itself).
         * Typical examples are
         * - `file:///home/gnome/pict.jpg`
         * - `http://www.gnome.org`
         * - `mailto:me`gnome`.org`
         *
         * Ideally the timestamp is taken from the event triggering
         * the gtk_show_uri() call. If timestamp is not known you can take
         * %GDK_CURRENT_TIME.
         *
         * This is the recommended call to be used as it passes information
         * necessary for sandbox helpers to parent their dialogs properly.
         * @param parent parent window
         * @param uri the uri to show
         * @param timestamp a timestamp to prevent focus stealing
         * @returns %TRUE on success, %FALSE on error
         */
        function show_uri_on_window(parent: Window | null, uri: string, timestamp: number): boolean;
        /**
         * Registers each of the stock items in `items`. If an item already
         * exists with the same stock ID as one of the `items,` the old item
         * gets replaced. The stock items are copied, so GTK+ does not hold
         * any pointer into `items` and `items` can be freed. Use
         * gtk_stock_add_static() if `items` is persistent and GTK+ need not
         * copy the array.
         * @param items a #GtkStockItem or array of items
         */
        function stock_add(items: StockItem[]): void;
        /**
         * Same as gtk_stock_add(), but doesn’t copy `items,` so
         * `items` must persist until application exit.
         * @param items a #GtkStockItem or array of #GtkStockItem
         */
        function stock_add_static(items: StockItem[]): void;
        /**
         * Retrieves a list of all known stock IDs added to a #GtkIconFactory
         * or registered with gtk_stock_add(). The list must be freed with g_slist_free(),
         * and each string in the list must be freed with g_free().
         * @returns a list of known stock IDs
         */
        function stock_list_ids(): string[];
        /**
         * Fills `item` with the registered values for `stock_id,` returning %TRUE
         * if `stock_id` was known.
         * @param stock_id a stock item name
         * @returns %TRUE if @item was initialized
         */
        function stock_lookup(stock_id: string): [boolean, StockItem];
        /**
         * Sets a function to be used for translating the `label` of
         * a stock item.
         *
         * If no function is registered for a translation domain,
         * g_dgettext() is used.
         *
         * The function is used for all stock items whose
         * `translation_domain` matches `domain`. Note that it is possible
         * to use strings different from the actual gettext translation domain
         * of your application for this, as long as your #GtkTranslateFunc uses
         * the correct domain when calling dgettext(). This can be useful, e.g.
         * when dealing with message contexts:
         *
         *
         * ```c
         * GtkStockItem items[] = {
         *  { MY_ITEM1, NC_("odd items", "Item 1"), 0, 0, "odd-item-domain" },
         *  { MY_ITEM2, NC_("even items", "Item 2"), 0, 0, "even-item-domain" },
         * };
         *
         * gchar *
         * my_translate_func (const gchar *msgid,
         *                    gpointer     data)
         * {
         *   gchar *msgctxt = data;
         *
         *   return (gchar*)g_dpgettext2 (GETTEXT_PACKAGE, msgctxt, msgid);
         * }
         *
         * ...
         *
         * gtk_stock_add (items, G_N_ELEMENTS (items));
         * gtk_stock_set_translate_func ("odd-item-domain", my_translate_func, "odd items");
         * gtk_stock_set_translate_func ("even-item-domain", my_translate_func, "even items");
         * ```
         *
         * @param domain the translation domain for which @func shall be used
         * @param func a #GtkTranslateFunc
         */
        function stock_set_translate_func(domain: string, func: TranslateFunc): void;
        /**
         * This function frees a target table as returned by
         * gtk_target_table_new_from_list()
         * @param targets a #GtkTargetEntry array
         */
        function target_table_free(targets: TargetEntry[]): void;
        /**
         * This function creates an #GtkTargetEntry array that contains the
         * same targets as the passed %list. The returned table is newly
         * allocated and should be freed using gtk_target_table_free() when no
         * longer needed.
         * @param list a #GtkTargetList
         * @returns the new table.
         */
        function target_table_new_from_list(list: TargetList): TargetEntry[];
        /**
         * Determines if any of the targets in `targets` can be used to
         * provide a #GdkPixbuf.
         * @param targets an array of #GdkAtoms
         * @param writable whether to accept only targets for which GTK+ knows   how to convert a pixbuf into the format
         * @returns %TRUE if @targets include a suitable target for images,   otherwise %FALSE.
         */
        function targets_include_image(targets: Gdk.Atom[], writable: boolean): boolean;
        /**
         * Determines if any of the targets in `targets` can be used to
         * provide rich text.
         * @param targets an array of #GdkAtoms
         * @param buffer a #GtkTextBuffer
         * @returns %TRUE if @targets include a suitable target for rich text,               otherwise %FALSE.
         */
        function targets_include_rich_text(targets: Gdk.Atom[], buffer: TextBuffer): boolean;
        /**
         * Determines if any of the targets in `targets` can be used to
         * provide text.
         * @param targets an array of #GdkAtoms
         * @returns %TRUE if @targets include a suitable target for text,   otherwise %FALSE.
         */
        function targets_include_text(targets: Gdk.Atom[]): boolean;
        /**
         * Determines if any of the targets in `targets` can be used to
         * provide an uri list.
         * @param targets an array of #GdkAtoms
         * @returns %TRUE if @targets include a suitable target for uri lists,   otherwise %FALSE.
         */
        function targets_include_uri(targets: Gdk.Atom[]): boolean;
        /**
         * Create a simple window with window title `window_title` and
         * text contents `dialog_text`.
         * The window will quit any running gtk_main()-loop when destroyed, and it
         * will automatically be destroyed upon test function teardown.
         * @param window_title Title of the window to be displayed.
         * @param dialog_text Text inside the window to be displayed.
         * @returns a widget pointer to the newly created GtkWindow.
         */
        function test_create_simple_window(window_title: string, dialog_text: string): Widget;
        /**
         * This function will search `widget` and all its descendants for a GtkLabel
         * widget with a text string matching `label_pattern`.
         * The `label_pattern` may contain asterisks “*” and question marks “?” as
         * placeholders, g_pattern_match() is used for the matching.
         * Note that locales other than "C“ tend to alter (translate” label strings,
         * so this function is genrally only useful in test programs with
         * predetermined locales, see gtk_test_init() for more details.
         * @param widget Valid label or container widget.
         * @param label_pattern Shell-glob pattern to match a label string.
         * @returns a GtkLabel widget if any is found.
         */
        function test_find_label(widget: Widget, label_pattern: string): Widget;
        /**
         * This function will search siblings of `base_widget` and siblings of its
         * ancestors for all widgets matching `widget_type`.
         * Of the matching widgets, the one that is geometrically closest to
         * `base_widget` will be returned.
         * The general purpose of this function is to find the most likely “action”
         * widget, relative to another labeling widget. Such as finding a
         * button or text entry widget, given its corresponding label widget.
         * @param base_widget Valid widget, part of a widget hierarchy
         * @param widget_type Type of a aearched for sibling widget
         * @returns a widget of type @widget_type if any is found.
         */
        function test_find_sibling(base_widget: Widget, widget_type: GObject.GType): Widget;
        /**
         * This function will search the descendants of `widget` for a widget
         * of type `widget_type` that has a label matching `label_pattern` next
         * to it. This is most useful for automated GUI testing, e.g. to find
         * the “OK” button in a dialog and synthesize clicks on it.
         * However see gtk_test_find_label(), gtk_test_find_sibling() and
         * gtk_test_widget_click() for possible caveats involving the search of
         * such widgets and synthesizing widget events.
         * @param widget Container widget, usually a GtkWindow.
         * @param label_pattern Shell-glob pattern to match a label string.
         * @param widget_type Type of a aearched for label sibling widget.
         * @returns a valid widget if any is found or %NULL.
         */
        function test_find_widget(widget: Widget, label_pattern: string, widget_type: GObject.GType): Widget | null;
        /**
         * Return the type ids that have been registered after
         * calling gtk_test_register_all_types().
         * @returns 0-terminated array of type ids
         */
        function test_list_all_types(): GObject.GType[];
        /**
         * Force registration of all core Gtk+ and Gdk object types.
         * This allowes to refer to any of those object types via
         * g_type_from_name() after calling this function.
         */
        function test_register_all_types(): void;
        /**
         * Retrive the literal adjustment value for GtkRange based
         * widgets and spin buttons. Note that the value returned by
         * this function is anything between the lower and upper bounds
         * of the adjustment belonging to `widget,` and is not a percentage
         * as passed in to gtk_test_slider_set_perc().
         * @param widget valid widget pointer.
         * @returns gtk_adjustment_get_value (adjustment) for an adjustment belonging to @widget.
         */
        function test_slider_get_value(widget: Widget): number;
        /**
         * This function will adjust the slider position of all GtkRange
         * based widgets, such as scrollbars or scales, it’ll also adjust
         * spin buttons. The adjustment value of these widgets is set to
         * a value between the lower and upper limits, according to the
         * `percentage` argument.
         * @param widget valid widget pointer.
         * @param percentage value between 0 and 100.
         */
        function test_slider_set_perc(widget: Widget, percentage: number): void;
        /**
         * This function will generate a `button` click in the upwards or downwards
         * spin button arrow areas, usually leading to an increase or decrease of
         * spin button’s value.
         * @param spinner valid GtkSpinButton widget.
         * @param button Number of the pointer button for the event, usually 1, 2 or 3.
         * @param upwards %TRUE for upwards arrow click, %FALSE for downwards arrow click.
         * @returns whether all actions neccessary for the button click simulation were carried out successfully.
         */
        function test_spin_button_click(spinner: SpinButton, button: number, upwards: boolean): boolean;
        /**
         * Retrive the text string of `widget` if it is a GtkLabel,
         * GtkEditable (entry and text widgets) or GtkTextView.
         * @param widget valid widget pointer.
         * @returns new 0-terminated C string, needs to be released with g_free().
         */
        function test_text_get(widget: Widget): string;
        /**
         * Set the text string of `widget` to `string` if it is a GtkLabel,
         * GtkEditable (entry and text widgets) or GtkTextView.
         * @param widget valid widget pointer.
         * @param string a 0-terminated C string
         */
        function test_text_set(widget: Widget, string: string): void;
        /**
         * This function will generate a `button` click (button press and button
         * release event) in the middle of the first GdkWindow found that belongs
         * to `widget`.
         * For windowless widgets like #GtkButton (which returns %FALSE from
         * gtk_widget_get_has_window()), this will often be an
         * input-only event window. For other widgets, this is usually widget->window.
         * Certain caveats should be considered when using this function, in
         * particular because the mouse pointer is warped to the button click
         * location, see gdk_test_simulate_button() for details.
         * @param widget Widget to generate a button click on.
         * @param button Number of the pointer button for the event, usually 1, 2 or 3.
         * @param modifiers Keyboard modifiers the event is setup with.
         * @returns whether all actions neccessary for the button click simulation were carried out successfully.
         */
        function test_widget_click(widget: Widget, button: number, modifiers: Gdk.ModifierType | null): boolean;
        /**
         * This function will generate keyboard press and release events in
         * the middle of the first GdkWindow found that belongs to `widget`.
         * For windowless widgets like #GtkButton (which returns %FALSE from
         * gtk_widget_get_has_window()), this will often be an
         * input-only event window. For other widgets, this is usually widget->window.
         * Certain caveats should be considered when using this function, in
         * particular because the mouse pointer is warped to the key press
         * location, see gdk_test_simulate_key() for details.
         * @param widget Widget to generate a key press and release on.
         * @param keyval A Gdk keyboard value.
         * @param modifiers Keyboard modifiers the event is setup with.
         * @returns whether all actions neccessary for the key event simulation were carried out successfully.
         */
        function test_widget_send_key(widget: Widget, keyval: number, modifiers: Gdk.ModifierType | null): boolean;
        /**
         * Enters the main loop and waits for `widget` to be “drawn”. In this
         * context that means it waits for the frame clock of `widget` to have
         * run a full styling, layout and drawing cycle.
         *
         * This function is intended to be used for syncing with actions that
         * depend on `widget` relayouting or on interaction with the display
         * server.
         * @param widget the widget to wait for
         */
        function test_widget_wait_for_draw(widget: Widget): void;
        /**
         * Obtains a `tree_model` and `path` from selection data of target type
         * %GTK_TREE_MODEL_ROW. Normally called from a drag_data_received handler.
         * This function can only be used if `selection_data` originates from the same
         * process that’s calling this function, because a pointer to the tree model
         * is being passed around. If you aren’t in the same process, then you'll
         * get memory corruption. In the #GtkTreeDragDest drag_data_received handler,
         * you can assume that selection data of type %GTK_TREE_MODEL_ROW is
         * in from the current process. The returned path must be freed with
         * gtk_tree_path_free().
         * @param selection_data a #GtkSelectionData
         * @returns %TRUE if @selection_data had target type %GTK_TREE_MODEL_ROW and  is otherwise valid
         */
        function tree_get_row_drag_data(selection_data: SelectionData): [boolean, TreeModel | null, TreePath | null];
        /**
         * Lets a set of row reference created by
         * gtk_tree_row_reference_new_proxy() know that the
         * model emitted the #GtkTreeModel::row-deleted signal.
         * @param proxy a #GObject
         * @param path the path position that was deleted
         */
        function tree_row_reference_deleted(proxy: GObject.Object, path: TreePath): void;
        /**
         * Lets a set of row reference created by
         * gtk_tree_row_reference_new_proxy() know that the
         * model emitted the #GtkTreeModel::row-inserted signal.
         * @param proxy a #GObject
         * @param path the row position that was inserted
         */
        function tree_row_reference_inserted(proxy: GObject.Object, path: TreePath): void;
        /**
         * Sets selection data of target type %GTK_TREE_MODEL_ROW. Normally used
         * in a drag_data_get handler.
         * @param selection_data some #GtkSelectionData
         * @param tree_model a #GtkTreeModel
         * @param path a row in @tree_model
         * @returns %TRUE if the #GtkSelectionData had the proper target type to allow us to set a tree row
         */
        function tree_set_row_drag_data(selection_data: SelectionData, tree_model: TreeModel, path: TreePath): boolean;
        /**
         * All this function does it to return %TRUE.
         *
         * This can be useful for example if you want to inhibit the deletion
         * of a window. Of course you should not do this as the user expects
         * a reaction from clicking the close icon of the window...
         *
         * ## A persistent window
         *
         *
         * ```c
         * #include <gtk/gtk.h>
         *
         * int
         * main (int argc, char **argv)
         * {
         *   GtkWidget *win, *but;
         *   const char *text = "Close yourself. I mean it!";
         *
         *   gtk_init (&argc, &argv);
         *
         *   win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
         *   g_signal_connect (win,
         *                     "delete-event",
         *                     G_CALLBACK (gtk_true),
         *                     NULL);
         *   g_signal_connect (win, "destroy",
         *                     G_CALLBACK (gtk_main_quit),
         *                     NULL);
         *
         *   but = gtk_button_new_with_label (text);
         *   g_signal_connect_swapped (but, "clicked",
         *                             G_CALLBACK (gtk_object_destroy),
         *                             win);
         *   gtk_container_add (GTK_CONTAINER (win), but);
         *
         *   gtk_widget_show_all (win);
         *
         *   gtk_main ();
         *
         *   return 0;
         * }
         * ```
         *
         * @returns %TRUE
         */
        function __true(): boolean;
        interface AccelGroupActivate<A = GObject.Object> {
            (accel_group: AccelGroup, acceleratable: A, keyval: number, modifier: Gdk.ModifierType): boolean;
        }
        interface AccelGroupFindFunc {
            (key: AccelKey, closure: GObject.Closure): boolean;
        }
        interface AccelMapForeach {
            (
                data: any | null,
                accel_path: string,
                accel_key: number,
                accel_mods: Gdk.ModifierType,
                changed: boolean,
            ): void;
        }
        interface AssistantPageFunc {
            (current_page: number): number;
        }
        interface BuilderConnectFunc<A = GObject.Object, B = GObject.Object> {
            (
                builder: Builder,
                object: A,
                signal_name: string,
                handler_name: string,
                connect_object: B | null,
                flags: GObject.ConnectFlags,
            ): void;
        }
        interface CalendarDetailFunc {
            (calendar: Calendar, year: number, month: number, day: number): string | null;
        }
        interface Callback {
            (widget: Widget): void;
        }
        interface CellAllocCallback {
            (renderer: CellRenderer, cell_area: Gdk.Rectangle, cell_background: Gdk.Rectangle): boolean;
        }
        interface CellCallback {
            (renderer: CellRenderer): boolean;
        }
        interface CellLayoutDataFunc {
            (cell_layout: CellLayout, cell: CellRenderer, tree_model: TreeModel, iter: TreeIter): void;
        }
        interface ClipboardClearFunc {
            (clipboard: Clipboard, user_data_or_owner?: any | null): void;
        }
        interface ClipboardGetFunc {
            (clipboard: Clipboard, selection_data: SelectionData, info: number, user_data_or_owner?: any | null): void;
        }
        interface ClipboardImageReceivedFunc {
            (clipboard: Clipboard, pixbuf: GdkPixbuf.Pixbuf): void;
        }
        interface ClipboardReceivedFunc {
            (clipboard: Clipboard, selection_data: SelectionData): void;
        }
        interface ClipboardRichTextReceivedFunc {
            (clipboard: Clipboard, format: Gdk.Atom, text: string | null, length: number): void;
        }
        interface ClipboardTargetsReceivedFunc {
            (clipboard: Clipboard, atoms?: Gdk.Atom[] | null): void;
        }
        interface ClipboardTextReceivedFunc {
            (clipboard: Clipboard, text?: string | null): void;
        }
        interface ClipboardURIReceivedFunc {
            (clipboard: Clipboard, uris: string[]): void;
        }
        interface ColorSelectionChangePaletteFunc {
            (colors: Gdk.Color[]): void;
        }
        interface ColorSelectionChangePaletteWithScreenFunc {
            (screen: Gdk.Screen, colors: Gdk.Color[]): void;
        }
        interface EntryCompletionMatchFunc {
            (completion: EntryCompletion, key: string, iter: TreeIter): boolean;
        }
        interface FileFilterFunc {
            (filter_info: FileFilterInfo): boolean;
        }
        interface FlowBoxCreateWidgetFunc<A = GObject.Object> {
            (item: A): Widget;
        }
        interface FlowBoxFilterFunc {
            (child: FlowBoxChild): boolean;
        }
        interface FlowBoxForeachFunc {
            (box: FlowBox, child: FlowBoxChild): void;
        }
        interface FlowBoxSortFunc {
            (child1: FlowBoxChild, child2: FlowBoxChild): number;
        }
        interface FontFilterFunc {
            (family: Pango.FontFamily, face: Pango.FontFace): boolean;
        }
        interface IconViewForeachFunc {
            (icon_view: IconView, path: TreePath): void;
        }
        interface KeySnoopFunc {
            (grab_widget: Widget, event: Gdk.EventKey): number;
        }
        interface ListBoxCreateWidgetFunc<A = GObject.Object> {
            (item: A): Widget;
        }
        interface ListBoxFilterFunc {
            (row: ListBoxRow): boolean;
        }
        interface ListBoxForeachFunc {
            (box: ListBox, row: ListBoxRow): void;
        }
        interface ListBoxSortFunc {
            (row1: ListBoxRow, row2: ListBoxRow): number;
        }
        interface ListBoxUpdateHeaderFunc {
            (row: ListBoxRow, before?: ListBoxRow | null): void;
        }
        interface MenuDetachFunc {
            (attach_widget: Widget, menu: Menu): void;
        }
        interface MenuPositionFunc {
            (menu: Menu, x: number, y: number): void;
        }
        interface ModuleDisplayInitFunc {
            (display: Gdk.Display): void;
        }
        interface ModuleInitFunc {
            (argv?: string[] | null): void;
        }
        interface PageSetupDoneFunc {
            (page_setup: PageSetup): void;
        }
        interface PrintSettingsFunc {
            (key: string, value: string): void;
        }
        interface RcPropertyParser {
            (pspec: GObject.ParamSpec, rc_string: GLib.String, property_value: GObject.Value | any): boolean;
        }
        interface RecentFilterFunc {
            (filter_info: RecentFilterInfo): boolean;
        }
        interface RecentSortFunc {
            (a: RecentInfo, b: RecentInfo): number;
        }
        interface StylePropertyParser {
            (string: string, value: GObject.Value | any): boolean;
        }
        interface TextBufferDeserializeFunc {
            (
                register_buffer: TextBuffer,
                content_buffer: TextBuffer,
                iter: TextIter,
                data: Uint8Array | string,
                create_tags: boolean,
            ): boolean;
        }
        interface TextBufferSerializeFunc {
            (
                register_buffer: TextBuffer,
                content_buffer: TextBuffer,
                start: TextIter,
                end: TextIter,
            ): Uint8Array | null;
        }
        interface TextCharPredicate {
            (ch: number): boolean;
        }
        interface TextTagTableForeach {
            (tag: TextTag): void;
        }
        interface TickCallback {
            (widget: Widget, frame_clock: Gdk.FrameClock): boolean;
        }
        interface TranslateFunc {
            (path: string): string;
        }
        interface TreeCellDataFunc {
            (tree_column: TreeViewColumn, cell: CellRenderer, tree_model: TreeModel, iter: TreeIter): void;
        }
        interface TreeDestroyCountFunc {
            (tree_view: TreeView, path: TreePath, children: number): void;
        }
        interface TreeIterCompareFunc {
            (model: TreeModel, a: TreeIter, b: TreeIter): number;
        }
        interface TreeModelFilterModifyFunc {
            (model: TreeModel, iter: TreeIter, column: number): void;
        }
        interface TreeModelFilterVisibleFunc {
            (model: TreeModel, iter: TreeIter): boolean;
        }
        interface TreeModelForeachFunc {
            (model: TreeModel, path: TreePath, iter: TreeIter): boolean;
        }
        interface TreeSelectionForeachFunc {
            (model: TreeModel, path: TreePath, iter: TreeIter): void;
        }
        interface TreeSelectionFunc {
            (selection: TreeSelection, model: TreeModel, path: TreePath, path_currently_selected: boolean): boolean;
        }
        interface TreeViewColumnDropFunc {
            (
                tree_view: TreeView,
                column: TreeViewColumn,
                prev_column: TreeViewColumn,
                next_column: TreeViewColumn,
            ): boolean;
        }
        interface TreeViewMappingFunc {
            (tree_view: TreeView, path: TreePath): void;
        }
        interface TreeViewRowSeparatorFunc {
            (model: TreeModel, iter: TreeIter): boolean;
        }
        interface TreeViewSearchEqualFunc {
            (model: TreeModel, column: number, key: string, iter: TreeIter): boolean;
        }
        interface TreeViewSearchPositionFunc {
            (tree_view: TreeView, search_dialog: Widget): void;
        }
        /**
         * Accelerator flags used with gtk_accel_group_connect().
         */

        /**
         * Accelerator flags used with gtk_accel_group_connect().
         */
        export namespace AccelFlags {
            export const $gtype: GObject.GType<AccelFlags>;
        }

        enum AccelFlags {
            /**
             * Accelerator is visible
             */
            VISIBLE,
            /**
             * Accelerator not removable
             */
            LOCKED,
            /**
             * Mask
             */
            MASK,
        }
        /**
         * Types of user actions that may be blocked by gtk_application_inhibit().
         */

        /**
         * Types of user actions that may be blocked by gtk_application_inhibit().
         */
        export namespace ApplicationInhibitFlags {
            export const $gtype: GObject.GType<ApplicationInhibitFlags>;
        }

        enum ApplicationInhibitFlags {
            /**
             * Inhibit ending the user session
             *     by logging out or by shutting down the computer
             */
            LOGOUT,
            /**
             * Inhibit user switching
             */
            SWITCH,
            /**
             * Inhibit suspending the
             *     session or computer
             */
            SUSPEND,
            /**
             * Inhibit the session being
             *     marked as idle (and possibly locked)
             */
            IDLE,
        }
        /**
         * Denotes the expansion properties that a widget will have when it (or its
         * parent) is resized.
         */

        /**
         * Denotes the expansion properties that a widget will have when it (or its
         * parent) is resized.
         */
        export namespace AttachOptions {
            export const $gtype: GObject.GType<AttachOptions>;
        }

        enum AttachOptions {
            /**
             * the widget should expand to take up any extra space in its
             * container that has been allocated.
             */
            EXPAND,
            /**
             * the widget should shrink as and when possible.
             */
            SHRINK,
            /**
             * the widget should fill the space allocated to it.
             */
            FILL,
        }
        /**
         * These options can be used to influence the display and behaviour of a #GtkCalendar.
         */

        /**
         * These options can be used to influence the display and behaviour of a #GtkCalendar.
         */
        export namespace CalendarDisplayOptions {
            export const $gtype: GObject.GType<CalendarDisplayOptions>;
        }

        enum CalendarDisplayOptions {
            /**
             * Specifies that the month and year should be displayed.
             */
            SHOW_HEADING,
            /**
             * Specifies that three letter day descriptions should be present.
             */
            SHOW_DAY_NAMES,
            /**
             * Prevents the user from switching months with the calendar.
             */
            NO_MONTH_CHANGE,
            /**
             * Displays each week numbers of the current year, down the
             * left side of the calendar.
             */
            SHOW_WEEK_NUMBERS,
            /**
             * Just show an indicator, not the full details
             * text when details are provided. See gtk_calendar_set_detail_func().
             */
            SHOW_DETAILS,
        }
        /**
         * Tells how a cell is to be rendered.
         */

        /**
         * Tells how a cell is to be rendered.
         */
        export namespace CellRendererState {
            export const $gtype: GObject.GType<CellRendererState>;
        }

        enum CellRendererState {
            /**
             * The cell is currently selected, and
             *  probably has a selection colored background to render to.
             */
            SELECTED,
            /**
             * The mouse is hovering over the cell.
             */
            PRELIT,
            /**
             * The cell is drawn in an insensitive manner
             */
            INSENSITIVE,
            /**
             * The cell is in a sorted row
             */
            SORTED,
            /**
             * The cell is in the focus row.
             */
            FOCUSED,
            /**
             * The cell is in a row that can be expanded. Since 3.4
             */
            EXPANDABLE,
            /**
             * The cell is in a row that is expanded. Since 3.4
             */
            EXPANDED,
        }

        export namespace DebugFlag {
            export const $gtype: GObject.GType<DebugFlag>;
        }

        enum DebugFlag {
            MISC,
            PLUGSOCKET,
            TEXT,
            TREE,
            UPDATES,
            KEYBINDINGS,
            MULTIHEAD,
            MODULES,
            GEOMETRY,
            ICONTHEME,
            PRINTING,
            BUILDER,
            SIZE_REQUEST,
            NO_CSS_CACHE,
            BASELINES,
            PIXEL_CACHE,
            NO_PIXEL_CACHE,
            INTERACTIVE,
            TOUCHSCREEN,
            ACTIONS,
            RESIZE,
            LAYOUT,
        }
        /**
         * The #GtkDestDefaults enumeration specifies the various
         * types of action that will be taken on behalf
         * of the user for a drag destination site.
         */

        /**
         * The #GtkDestDefaults enumeration specifies the various
         * types of action that will be taken on behalf
         * of the user for a drag destination site.
         */
        export namespace DestDefaults {
            export const $gtype: GObject.GType<DestDefaults>;
        }

        enum DestDefaults {
            /**
             * If set for a widget, GTK+, during a drag over this
             *   widget will check if the drag matches this widget’s list of possible targets
             *   and actions.
             *   GTK+ will then call gdk_drag_status() as appropriate.
             */
            MOTION,
            /**
             * If set for a widget, GTK+ will draw a highlight on
             *   this widget as long as a drag is over this widget and the widget drag format
             *   and action are acceptable.
             */
            HIGHLIGHT,
            /**
             * If set for a widget, when a drop occurs, GTK+ will
             *   will check if the drag matches this widget’s list of possible targets and
             *   actions. If so, GTK+ will call gtk_drag_get_data() on behalf of the widget.
             *   Whether or not the drop is successful, GTK+ will call gtk_drag_finish(). If
             *   the action was a move, then if the drag was successful, then %TRUE will be
             *   passed for the `delete` parameter to gtk_drag_finish().
             */
            DROP,
            /**
             * If set, specifies that all default actions should
             *   be taken.
             */
            ALL,
        }
        /**
         * Flags used to influence dialog construction.
         */

        /**
         * Flags used to influence dialog construction.
         */
        export namespace DialogFlags {
            export const $gtype: GObject.GType<DialogFlags>;
        }

        enum DialogFlags {
            /**
             * Make the constructed dialog modal,
             *     see gtk_window_set_modal()
             */
            MODAL,
            /**
             * Destroy the dialog when its
             *     parent is destroyed, see gtk_window_set_destroy_with_parent()
             */
            DESTROY_WITH_PARENT,
            /**
             * Create dialog with actions in header
             *     bar instead of action area. Since 3.12.
             */
            USE_HEADER_BAR,
        }
        /**
         * Describes the behavior of a #GtkEventControllerScroll.
         */

        /**
         * Describes the behavior of a #GtkEventControllerScroll.
         */
        export namespace EventControllerScrollFlags {
            export const $gtype: GObject.GType<EventControllerScrollFlags>;
        }

        enum EventControllerScrollFlags {
            /**
             * Don't emit scroll.
             */
            NONE,
            /**
             * Emit scroll with vertical deltas.
             */
            VERTICAL,
            /**
             * Emit scroll with horizontal deltas.
             */
            HORIZONTAL,
            /**
             * Only emit deltas that are multiples of 1.
             */
            DISCRETE,
            /**
             * Emit #GtkEventControllerScroll::decelerate
             *   after continuous scroll finishes.
             */
            KINETIC,
            /**
             * Emit scroll on both axes.
             */
            BOTH_AXES,
        }
        /**
         * These flags indicate what parts of a #GtkFileFilterInfo struct
         * are filled or need to be filled.
         */

        /**
         * These flags indicate what parts of a #GtkFileFilterInfo struct
         * are filled or need to be filled.
         */
        export namespace FileFilterFlags {
            export const $gtype: GObject.GType<FileFilterFlags>;
        }

        enum FileFilterFlags {
            /**
             * the filename of the file being tested
             */
            FILENAME,
            /**
             * the URI for the file being tested
             */
            URI,
            /**
             * the string that will be used to
             *   display the file in the file chooser
             */
            DISPLAY_NAME,
            /**
             * the mime type of the file
             */
            MIME_TYPE,
        }
        /**
         * This enumeration specifies the granularity of font selection
         * that is desired in a font chooser.
         *
         * This enumeration may be extended in the future; applications should
         * ignore unknown values.
         */

        /**
         * This enumeration specifies the granularity of font selection
         * that is desired in a font chooser.
         *
         * This enumeration may be extended in the future; applications should
         * ignore unknown values.
         */
        export namespace FontChooserLevel {
            export const $gtype: GObject.GType<FontChooserLevel>;
        }

        enum FontChooserLevel {
            /**
             * Allow selecting a font family
             */
            FAMILY,
            /**
             * Allow selecting a specific font face
             */
            STYLE,
            /**
             * Allow selecting a specific font size
             */
            SIZE,
            VARIATIONS,
            /**
             * Allow selecting specific OpenType font features
             */
            FEATURES,
        }
        /**
         * Used to specify options for gtk_icon_theme_lookup_icon()
         */

        /**
         * Used to specify options for gtk_icon_theme_lookup_icon()
         */
        export namespace IconLookupFlags {
            export const $gtype: GObject.GType<IconLookupFlags>;
        }

        enum IconLookupFlags {
            /**
             * Never get SVG icons, even if gdk-pixbuf
             *   supports them. Cannot be used together with %GTK_ICON_LOOKUP_FORCE_SVG.
             */
            NO_SVG,
            /**
             * Get SVG icons, even if gdk-pixbuf
             *   doesn’t support them.
             *   Cannot be used together with %GTK_ICON_LOOKUP_NO_SVG.
             */
            FORCE_SVG,
            /**
             * When passed to
             *   gtk_icon_theme_lookup_icon() includes builtin icons
             *   as well as files. For a builtin icon, gtk_icon_info_get_filename()
             *   is %NULL and you need to call gtk_icon_info_get_builtin_pixbuf().
             */
            USE_BUILTIN,
            /**
             * Try to shorten icon name at '-'
             *   characters before looking at inherited themes. This flag is only
             *   supported in functions that take a single icon name. For more general
             *   fallback, see gtk_icon_theme_choose_icon(). Since 2.12.
             */
            GENERIC_FALLBACK,
            /**
             * Always get the icon scaled to the
             *   requested size. Since 2.14.
             */
            FORCE_SIZE,
            /**
             * Try to always load regular icons, even
             *   when symbolic icon names are given. Since 3.14.
             */
            FORCE_REGULAR,
            /**
             * Try to always load symbolic icons, even
             *   when regular icon names are given. Since 3.14.
             */
            FORCE_SYMBOLIC,
            /**
             * Try to load a variant of the icon for left-to-right
             *   text direction. Since 3.14.
             */
            DIR_LTR,
            /**
             * Try to load a variant of the icon for right-to-left
             *   text direction. Since 3.14.
             */
            DIR_RTL,
        }
        /**
         * Describes hints that might be taken into account by input methods
         * or applications. Note that input methods may already tailor their
         * behaviour according to the #GtkInputPurpose of the entry.
         *
         * Some common sense is expected when using these flags - mixing
         * `GTK_INPUT_HINT_LOWERCASE` with any of the uppercase hints makes no sense.
         *
         * This enumeration may be extended in the future; input methods should
         * ignore unknown values.
         */

        /**
         * Describes hints that might be taken into account by input methods
         * or applications. Note that input methods may already tailor their
         * behaviour according to the #GtkInputPurpose of the entry.
         *
         * Some common sense is expected when using these flags - mixing
         * `GTK_INPUT_HINT_LOWERCASE` with any of the uppercase hints makes no sense.
         *
         * This enumeration may be extended in the future; input methods should
         * ignore unknown values.
         */
        export namespace InputHints {
            export const $gtype: GObject.GType<InputHints>;
        }

        enum InputHints {
            /**
             * No special behaviour suggested
             */
            NONE,
            /**
             * Suggest checking for typos
             */
            SPELLCHECK,
            /**
             * Suggest not checking for typos
             */
            NO_SPELLCHECK,
            /**
             * Suggest word completion
             */
            WORD_COMPLETION,
            /**
             * Suggest to convert all text to lowercase
             */
            LOWERCASE,
            /**
             * Suggest to capitalize all text
             */
            UPPERCASE_CHARS,
            /**
             * Suggest to capitalize the first
             *     character of each word
             */
            UPPERCASE_WORDS,
            /**
             * Suggest to capitalize the
             *     first word of each sentence
             */
            UPPERCASE_SENTENCES,
            /**
             * Suggest to not show an onscreen keyboard
             *     (e.g for a calculator that already has all the keys).
             */
            INHIBIT_OSK,
            /**
             * The text is vertical. Since 3.18
             */
            VERTICAL_WRITING,
            /**
             * Suggest offering Emoji support. Since 3.22.20
             */
            EMOJI,
            /**
             * Suggest not offering Emoji support. Since 3.22.20
             */
            NO_EMOJI,
        }
        /**
         * Describes how a rendered element connects to adjacent elements.
         */

        /**
         * Describes how a rendered element connects to adjacent elements.
         */
        export namespace JunctionSides {
            export const $gtype: GObject.GType<JunctionSides>;
        }

        enum JunctionSides {
            /**
             * No junctions.
             */
            NONE,
            /**
             * Element connects on the top-left corner.
             */
            CORNER_TOPLEFT,
            /**
             * Element connects on the top-right corner.
             */
            CORNER_TOPRIGHT,
            /**
             * Element connects on the bottom-left corner.
             */
            CORNER_BOTTOMLEFT,
            /**
             * Element connects on the bottom-right corner.
             */
            CORNER_BOTTOMRIGHT,
            /**
             * Element connects on the top side.
             */
            TOP,
            /**
             * Element connects on the bottom side.
             */
            BOTTOM,
            /**
             * Element connects on the left side.
             */
            LEFT,
            /**
             * Element connects on the right side.
             */
            RIGHT,
        }
        /**
         * These flags serve two purposes.  First, the application can call gtk_places_sidebar_set_open_flags()
         * using these flags as a bitmask.  This tells the sidebar that the application is able to open
         * folders selected from the sidebar in various ways, for example, in new tabs or in new windows in
         * addition to the normal mode.
         *
         * Second, when one of these values gets passed back to the application in the
         * #GtkPlacesSidebar::open-location signal, it means that the application should
         * open the selected location in the normal way, in a new tab, or in a new
         * window.  The sidebar takes care of determining the desired way to open the location,
         * based on the modifier keys that the user is pressing at the time the selection is made.
         *
         * If the application never calls gtk_places_sidebar_set_open_flags(), then the sidebar will only
         * use #GTK_PLACES_OPEN_NORMAL in the #GtkPlacesSidebar::open-location signal.  This is the
         * default mode of operation.
         */

        /**
         * These flags serve two purposes.  First, the application can call gtk_places_sidebar_set_open_flags()
         * using these flags as a bitmask.  This tells the sidebar that the application is able to open
         * folders selected from the sidebar in various ways, for example, in new tabs or in new windows in
         * addition to the normal mode.
         *
         * Second, when one of these values gets passed back to the application in the
         * #GtkPlacesSidebar::open-location signal, it means that the application should
         * open the selected location in the normal way, in a new tab, or in a new
         * window.  The sidebar takes care of determining the desired way to open the location,
         * based on the modifier keys that the user is pressing at the time the selection is made.
         *
         * If the application never calls gtk_places_sidebar_set_open_flags(), then the sidebar will only
         * use #GTK_PLACES_OPEN_NORMAL in the #GtkPlacesSidebar::open-location signal.  This is the
         * default mode of operation.
         */
        export namespace PlacesOpenFlags {
            export const $gtype: GObject.GType<PlacesOpenFlags>;
        }

        enum PlacesOpenFlags {
            /**
             * This is the default mode that #GtkPlacesSidebar uses if no other flags
             *  are specified.  It indicates that the calling application should open the selected location
             *  in the normal way, for example, in the folder view beside the sidebar.
             */
            NORMAL,
            /**
             * When passed to gtk_places_sidebar_set_open_flags(), this indicates
             *  that the application can open folders selected from the sidebar in new tabs.  This value
             *  will be passed to the #GtkPlacesSidebar::open-location signal when the user selects
             *  that a location be opened in a new tab instead of in the standard fashion.
             */
            NEW_TAB,
            /**
             * Similar to `GTK_PLACES_OPEN_NEW_TAB,` but indicates that the application
             *  can open folders in new windows.
             */
            NEW_WINDOW,
        }
        /**
         * Deprecated
         */

        /**
         * Deprecated
         */
        export namespace RcFlags {
            export const $gtype: GObject.GType<RcFlags>;
        }

        enum RcFlags {
            /**
             * Deprecated
             */
            FG,
            /**
             * Deprecated
             */
            BG,
            /**
             * Deprecated
             */
            TEXT,
            /**
             * Deprecated
             */
            BASE,
        }
        /**
         * These flags indicate what parts of a #GtkRecentFilterInfo struct
         * are filled or need to be filled.
         */

        /**
         * These flags indicate what parts of a #GtkRecentFilterInfo struct
         * are filled or need to be filled.
         */
        export namespace RecentFilterFlags {
            export const $gtype: GObject.GType<RecentFilterFlags>;
        }

        enum RecentFilterFlags {
            /**
             * the URI of the file being tested
             */
            URI,
            /**
             * the string that will be used to
             *  display the file in the recent chooser
             */
            DISPLAY_NAME,
            /**
             * the mime type of the file
             */
            MIME_TYPE,
            /**
             * the list of applications that have
             *  registered the file
             */
            APPLICATION,
            /**
             * the groups to which the file belongs to
             */
            GROUP,
            /**
             * the number of days elapsed since the file
             *  has been registered
             */
            AGE,
        }
        /**
         * Describes a region within a widget.
         */

        /**
         * Describes a region within a widget.
         */
        export namespace RegionFlags {
            export const $gtype: GObject.GType<RegionFlags>;
        }

        enum RegionFlags {
            /**
             * Region has an even number within a set.
             */
            EVEN,
            /**
             * Region has an odd number within a set.
             */
            ODD,
            /**
             * Region is the first one within a set.
             */
            FIRST,
            /**
             * Region is the last one within a set.
             */
            LAST,
            /**
             * Region is the only one within a set.
             */
            ONLY,
            /**
             * Region is part of a sorted area.
             */
            SORTED,
        }
        /**
         * Describes a widget state. Widget states are used to match the widget
         * against CSS pseudo-classes. Note that GTK extends the regular CSS
         * classes and sometimes uses different names.
         */

        /**
         * Describes a widget state. Widget states are used to match the widget
         * against CSS pseudo-classes. Note that GTK extends the regular CSS
         * classes and sometimes uses different names.
         */
        export namespace StateFlags {
            export const $gtype: GObject.GType<StateFlags>;
        }

        enum StateFlags {
            /**
             * State during normal operation.
             */
            NORMAL,
            /**
             * Widget is active.
             */
            ACTIVE,
            /**
             * Widget has a mouse pointer over it.
             */
            PRELIGHT,
            /**
             * Widget is selected.
             */
            SELECTED,
            /**
             * Widget is insensitive.
             */
            INSENSITIVE,
            /**
             * Widget is inconsistent.
             */
            INCONSISTENT,
            /**
             * Widget has the keyboard focus.
             */
            FOCUSED,
            /**
             * Widget is in a background toplevel window.
             */
            BACKDROP,
            /**
             * Widget is in left-to-right text direction. Since 3.8
             */
            DIR_LTR,
            /**
             * Widget is in right-to-left text direction. Since 3.8
             */
            DIR_RTL,
            /**
             * Widget is a link. Since 3.12
             */
            LINK,
            /**
             * The location the widget points to has already been visited. Since 3.12
             */
            VISITED,
            /**
             * Widget is checked. Since 3.14
             */
            CHECKED,
            /**
             * Widget is highlighted as a drop target for DND. Since 3.20
             */
            DROP_ACTIVE,
        }
        /**
         * Flags that modify the behavior of gtk_style_context_to_string().
         * New values may be added to this enumeration.
         */

        /**
         * Flags that modify the behavior of gtk_style_context_to_string().
         * New values may be added to this enumeration.
         */
        export namespace StyleContextPrintFlags {
            export const $gtype: GObject.GType<StyleContextPrintFlags>;
        }

        enum StyleContextPrintFlags {
            NONE,
            /**
             * Print the entire tree of
             *     CSS nodes starting at the style context's node
             */
            RECURSE,
            /**
             * Show the values of the
             *     CSS properties for each node
             */
            SHOW_STYLE,
        }
        /**
         * The #GtkTargetFlags enumeration is used to specify
         * constraints on a #GtkTargetEntry.
         */

        /**
         * The #GtkTargetFlags enumeration is used to specify
         * constraints on a #GtkTargetEntry.
         */
        export namespace TargetFlags {
            export const $gtype: GObject.GType<TargetFlags>;
        }

        enum TargetFlags {
            /**
             * If this is set, the target will only be selected
             *   for drags within a single application.
             */
            SAME_APP,
            /**
             * If this is set, the target will only be selected
             *   for drags within a single widget.
             */
            SAME_WIDGET,
            /**
             * If this is set, the target will not be selected
             *   for drags within a single application.
             */
            OTHER_APP,
            /**
             * If this is set, the target will not be selected
             *   for drags withing a single widget.
             */
            OTHER_WIDGET,
        }
        /**
         * Flags affecting how a search is done.
         *
         * If neither #GTK_TEXT_SEARCH_VISIBLE_ONLY nor #GTK_TEXT_SEARCH_TEXT_ONLY are
         * enabled, the match must be exact; the special 0xFFFC character will match
         * embedded pixbufs or child widgets.
         */

        /**
         * Flags affecting how a search is done.
         *
         * If neither #GTK_TEXT_SEARCH_VISIBLE_ONLY nor #GTK_TEXT_SEARCH_TEXT_ONLY are
         * enabled, the match must be exact; the special 0xFFFC character will match
         * embedded pixbufs or child widgets.
         */
        export namespace TextSearchFlags {
            export const $gtype: GObject.GType<TextSearchFlags>;
        }

        enum TextSearchFlags {
            /**
             * Search only visible data. A search match may
             * have invisible text interspersed.
             */
            VISIBLE_ONLY,
            /**
             * Search only text. A match may have pixbufs or
             * child widgets mixed inside the matched range.
             */
            TEXT_ONLY,
            /**
             * The text will be matched regardless of
             * what case it is in.
             */
            CASE_INSENSITIVE,
        }
        /**
         * Flags used to specify the supported drag targets.
         */

        /**
         * Flags used to specify the supported drag targets.
         */
        export namespace ToolPaletteDragTargets {
            export const $gtype: GObject.GType<ToolPaletteDragTargets>;
        }

        enum ToolPaletteDragTargets {
            /**
             * Support drag of items.
             */
            ITEMS,
            /**
             * Support drag of groups.
             */
            GROUPS,
        }
        /**
         * These flags indicate various properties of a #GtkTreeModel.
         *
         * They are returned by gtk_tree_model_get_flags(), and must be
         * static for the lifetime of the object. A more complete description
         * of #GTK_TREE_MODEL_ITERS_PERSIST can be found in the overview of
         * this section.
         */

        /**
         * These flags indicate various properties of a #GtkTreeModel.
         *
         * They are returned by gtk_tree_model_get_flags(), and must be
         * static for the lifetime of the object. A more complete description
         * of #GTK_TREE_MODEL_ITERS_PERSIST can be found in the overview of
         * this section.
         */
        export namespace TreeModelFlags {
            export const $gtype: GObject.GType<TreeModelFlags>;
        }

        enum TreeModelFlags {
            /**
             * iterators survive all signals
             *     emitted by the tree
             */
            ITERS_PERSIST,
            /**
             * the model is a list only, and never
             *     has children
             */
            LIST_ONLY,
        }
        /**
         * These enumeration values are used by gtk_ui_manager_add_ui() to determine
         * what UI element to create.
         */

        /**
         * These enumeration values are used by gtk_ui_manager_add_ui() to determine
         * what UI element to create.
         */
        export namespace UIManagerItemType {
            export const $gtype: GObject.GType<UIManagerItemType>;
        }

        enum UIManagerItemType {
            /**
             * Pick the type of the UI element according to context.
             */
            AUTO,
            /**
             * Create a menubar.
             */
            MENUBAR,
            /**
             * Create a menu.
             */
            MENU,
            /**
             * Create a toolbar.
             */
            TOOLBAR,
            /**
             * Insert a placeholder.
             */
            PLACEHOLDER,
            /**
             * Create a popup menu.
             */
            POPUP,
            /**
             * Create a menuitem.
             */
            MENUITEM,
            /**
             * Create a toolitem.
             */
            TOOLITEM,
            /**
             * Create a separator.
             */
            SEPARATOR,
            /**
             * Install an accelerator.
             */
            ACCELERATOR,
            /**
             * Same as %GTK_UI_MANAGER_POPUP, but the
             *   actions’ accelerators are shown.
             */
            POPUP_WITH_ACCELS,
        }
        namespace AboutDialog {
            // Signal callback interfaces

            interface ActivateLink {
                (uri: string): boolean;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Dialog.ConstructorProps,
                    Atk.ImplementorIface.ConstructorProps,
                    Buildable.ConstructorProps {
                artists: string[];
                authors: string[];
                comments: string;
                copyright: string;
                documenters: string[];
                license: string;
                license_type: License;
                licenseType: License;
                logo: GdkPixbuf.Pixbuf;
                logo_icon_name: string;
                logoIconName: string;
                program_name: string;
                programName: string;
                translator_credits: string;
                translatorCredits: string;
                version: string;
                website: string;
                website_label: string;
                websiteLabel: string;
                wrap_license: boolean;
                wrapLicense: boolean;
            }
        }

        /**
         * The GtkAboutDialog offers a simple way to display information about
         * a program like its logo, name, copyright, website and license. It is
         * also possible to give credits to the authors, documenters, translators
         * and artists who have worked on the program. An about dialog is typically
         * opened when the user selects the `About` option from the `Help` menu.
         * All parts of the dialog are optional.
         *
         * About dialogs often contain links and email addresses. GtkAboutDialog
         * displays these as clickable links. By default, it calls gtk_show_uri_on_window()
         * when a user clicks one. The behaviour can be overridden with the
         * #GtkAboutDialog::activate-link signal.
         *
         * To specify a person with an email address, use a string like
         * "Edgar Allan Poe <edgar\`poe`.com>". To specify a website with a title,
         * use a string like "GTK+ team http://www.gtk.org".
         *
         * To make constructing a GtkAboutDialog as convenient as possible, you can
         * use the function gtk_show_about_dialog() which constructs and shows a dialog
         * and keeps it around so that it can be shown again.
         *
         * Note that GTK+ sets a default title of `_("About %s")` on the dialog
         * window (where \%s is replaced by the name of the application, but in
         * order to ensure proper translation of the title, applications should
         * set the title property explicitly when constructing a GtkAboutDialog,
         * as shown in the following example:
         *
         * ```c
         * GdkPixbuf *example_logo = gdk_pixbuf_new_from_file ("./logo.png", NULL);
         * gtk_show_about_dialog (NULL,
         *                        "program-name", "ExampleCode",
         *                        "logo", example_logo,
         *                        "title", _("About ExampleCode"),
         *                        NULL);
         * ```
         *
         *
         * It is also possible to show a #GtkAboutDialog like any other #GtkDialog,
         * e.g. using gtk_dialog_run(). In this case, you might need to know that
         * the “Close” button returns the #GTK_RESPONSE_CANCEL response id.
         */
        class AboutDialog extends Dialog implements Atk.ImplementorIface, Buildable {
            static $gtype: GObject.GType<AboutDialog>;

            // Properties

            /**
             * The people who contributed artwork to the program, as a %NULL-terminated
             * array of strings. Each string may contain email addresses and URLs, which
             * will be displayed as links, see the introduction for more details.
             */
            get artists(): string[];
            set artists(val: string[]);
            /**
             * The authors of the program, as a %NULL-terminated array of strings.
             * Each string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get authors(): string[];
            set authors(val: string[]);
            /**
             * Comments about the program. This string is displayed in a label
             * in the main dialog, thus it should be a short explanation of
             * the main purpose of the program, not a detailed list of features.
             */
            get comments(): string;
            set comments(val: string);
            /**
             * Copyright information for the program.
             */
            get copyright(): string;
            set copyright(val: string);
            /**
             * The people documenting the program, as a %NULL-terminated array of strings.
             * Each string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get documenters(): string[];
            set documenters(val: string[]);
            /**
             * The license of the program. This string is displayed in a
             * text view in a secondary dialog, therefore it is fine to use
             * a long multi-paragraph text. Note that the text is only wrapped
             * in the text view if the "wrap-license" property is set to %TRUE;
             * otherwise the text itself must contain the intended linebreaks.
             * When setting this property to a non-%NULL value, the
             * #GtkAboutDialog:license-type property is set to %GTK_LICENSE_CUSTOM
             * as a side effect.
             */
            get license(): string;
            set license(val: string);
            /**
             * The license of the program, as a value of the %GtkLicense enumeration.
             *
             * The #GtkAboutDialog will automatically fill out a standard disclaimer
             * and link the user to the appropriate online resource for the license
             * text.
             *
             * If %GTK_LICENSE_UNKNOWN is used, the link used will be the same
             * specified in the #GtkAboutDialog:website property.
             *
             * If %GTK_LICENSE_CUSTOM is used, the current contents of the
             * #GtkAboutDialog:license property are used.
             *
             * For any other #GtkLicense value, the contents of the
             * #GtkAboutDialog:license property are also set by this property as
             * a side effect.
             */
            get license_type(): License;
            set license_type(val: License);
            /**
             * The license of the program, as a value of the %GtkLicense enumeration.
             *
             * The #GtkAboutDialog will automatically fill out a standard disclaimer
             * and link the user to the appropriate online resource for the license
             * text.
             *
             * If %GTK_LICENSE_UNKNOWN is used, the link used will be the same
             * specified in the #GtkAboutDialog:website property.
             *
             * If %GTK_LICENSE_CUSTOM is used, the current contents of the
             * #GtkAboutDialog:license property are used.
             *
             * For any other #GtkLicense value, the contents of the
             * #GtkAboutDialog:license property are also set by this property as
             * a side effect.
             */
            get licenseType(): License;
            set licenseType(val: License);
            /**
             * A logo for the about box. If it is %NULL, the default window icon
             * set with gtk_window_set_default_icon() will be used.
             */
            get logo(): GdkPixbuf.Pixbuf;
            set logo(val: GdkPixbuf.Pixbuf);
            /**
             * A named icon to use as the logo for the about box. This property
             * overrides the #GtkAboutDialog:logo property.
             */
            get logo_icon_name(): string;
            set logo_icon_name(val: string);
            /**
             * A named icon to use as the logo for the about box. This property
             * overrides the #GtkAboutDialog:logo property.
             */
            get logoIconName(): string;
            set logoIconName(val: string);
            /**
             * The name of the program.
             * If this is not set, it defaults to g_get_application_name().
             */
            get program_name(): string;
            set program_name(val: string);
            /**
             * The name of the program.
             * If this is not set, it defaults to g_get_application_name().
             */
            get programName(): string;
            set programName(val: string);
            /**
             * Credits to the translators. This string should be marked as translatable.
             * The string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get translator_credits(): string;
            set translator_credits(val: string);
            /**
             * Credits to the translators. This string should be marked as translatable.
             * The string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get translatorCredits(): string;
            set translatorCredits(val: string);
            /**
             * The version of the program.
             */
            get version(): string;
            set version(val: string);
            /**
             * The URL for the link to the website of the program.
             * This should be a string starting with "http://.
             */
            get website(): string;
            set website(val: string);
            /**
             * The label for the link to the website of the program.
             */
            get website_label(): string;
            set website_label(val: string);
            /**
             * The label for the link to the website of the program.
             */
            get websiteLabel(): string;
            set websiteLabel(val: string);
            /**
             * Whether to wrap the text in the license dialog.
             */
            get wrap_license(): boolean;
            set wrap_license(val: boolean);
            /**
             * Whether to wrap the text in the license dialog.
             */
            get wrapLicense(): boolean;
            set wrapLicense(val: boolean);

            // Constructors

            constructor(properties?: Partial<AboutDialog.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): AboutDialog;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            connect_after(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            emit(signal: 'activate-link', uri: string): void;

            // Virtual methods

            vfunc_activate_link(uri: string): boolean;

            // Methods

            /**
             * Creates a new section in the Credits page.
             * @param section_name The name of the section
             * @param people The people who belong to that section
             */
            add_credit_section(section_name: string, people: string[]): void;
            /**
             * Returns the string which are displayed in the artists tab
             * of the secondary credits dialog.
             * @returns A  %NULL-terminated string array containing the artists. The array is  owned by the about dialog and must not be modified.
             */
            get_artists(): string[];
            /**
             * Returns the string which are displayed in the authors tab
             * of the secondary credits dialog.
             * @returns A  %NULL-terminated string array containing the authors. The array is  owned by the about dialog and must not be modified.
             */
            get_authors(): string[];
            /**
             * Returns the comments string.
             * @returns The comments. The string is owned by the about  dialog and must not be modified.
             */
            get_comments(): string;
            /**
             * Returns the copyright string.
             * @returns The copyright string. The string is owned by the about  dialog and must not be modified.
             */
            get_copyright(): string;
            /**
             * Returns the string which are displayed in the documenters
             * tab of the secondary credits dialog.
             * @returns A  %NULL-terminated string array containing the documenters. The  array is owned by the about dialog and must not be modified.
             */
            get_documenters(): string[];
            /**
             * Returns the license information.
             * @returns The license information. The string is owned by the about  dialog and must not be modified.
             */
            get_license(): string;
            /**
             * Retrieves the license set using gtk_about_dialog_set_license_type()
             * @returns a #GtkLicense value
             */
            get_license_type(): License;
            /**
             * Returns the pixbuf displayed as logo in the about dialog.
             * @returns the pixbuf displayed as logo. The   pixbuf is owned by the about dialog. If you want to keep a   reference to it, you have to call g_object_ref() on it.
             */
            get_logo(): GdkPixbuf.Pixbuf;
            /**
             * Returns the icon name displayed as logo in the about dialog.
             * @returns the icon name displayed as logo. The string is   owned by the dialog. If you want to keep a reference   to it, you have to call g_strdup() on it.
             */
            get_logo_icon_name(): string;
            /**
             * Returns the program name displayed in the about dialog.
             * @returns The program name. The string is owned by the about  dialog and must not be modified.
             */
            get_program_name(): string;
            /**
             * Returns the translator credits string which is displayed
             * in the translators tab of the secondary credits dialog.
             * @returns The translator credits string. The string is   owned by the about dialog and must not be modified.
             */
            get_translator_credits(): string;
            /**
             * Returns the version string.
             * @returns The version string. The string is owned by the about  dialog and must not be modified.
             */
            get_version(): string;
            /**
             * Returns the website URL.
             * @returns The website URL. The string is owned by the about  dialog and must not be modified.
             */
            get_website(): string;
            /**
             * Returns the label used for the website link.
             * @returns The label used for the website link. The string is     owned by the about dialog and must not be modified.
             */
            get_website_label(): string;
            /**
             * Returns whether the license text in `about` is
             * automatically wrapped.
             * @returns %TRUE if the license text is wrapped
             */
            get_wrap_license(): boolean;
            /**
             * Sets the strings which are displayed in the artists tab
             * of the secondary credits dialog.
             * @param artists a %NULL-terminated array of strings
             */
            set_artists(artists: string[]): void;
            /**
             * Sets the strings which are displayed in the authors tab
             * of the secondary credits dialog.
             * @param authors a %NULL-terminated array of strings
             */
            set_authors(authors: string[]): void;
            /**
             * Sets the comments string to display in the about dialog.
             * This should be a short string of one or two lines.
             * @param comments a comments string
             */
            set_comments(comments?: string | null): void;
            /**
             * Sets the copyright string to display in the about dialog.
             * This should be a short string of one or two lines.
             * @param copyright the copyright string
             */
            set_copyright(copyright?: string | null): void;
            /**
             * Sets the strings which are displayed in the documenters tab
             * of the secondary credits dialog.
             * @param documenters a %NULL-terminated array of strings
             */
            set_documenters(documenters: string[]): void;
            /**
             * Sets the license information to be displayed in the secondary
             * license dialog. If `license` is %NULL, the license button is
             * hidden.
             * @param license the license information or %NULL
             */
            set_license(license?: string | null): void;
            /**
             * Sets the license of the application showing the `about` dialog from a
             * list of known licenses.
             *
             * This function overrides the license set using
             * gtk_about_dialog_set_license().
             * @param license_type the type of license
             */
            set_license_type(license_type: License | null): void;
            /**
             * Sets the pixbuf to be displayed as logo in the about dialog.
             * If it is %NULL, the default window icon set with
             * gtk_window_set_default_icon() will be used.
             * @param logo a #GdkPixbuf, or %NULL
             */
            set_logo(logo?: GdkPixbuf.Pixbuf | null): void;
            /**
             * Sets the pixbuf to be displayed as logo in the about dialog.
             * If it is %NULL, the default window icon set with
             * gtk_window_set_default_icon() will be used.
             * @param icon_name an icon name, or %NULL
             */
            set_logo_icon_name(icon_name?: string | null): void;
            /**
             * Sets the name to display in the about dialog.
             * If this is not set, it defaults to g_get_application_name().
             * @param name the program name
             */
            set_program_name(name: string): void;
            /**
             * Sets the translator credits string which is displayed in
             * the translators tab of the secondary credits dialog.
             *
             * The intended use for this string is to display the translator
             * of the language which is currently used in the user interface.
             * Using gettext(), a simple way to achieve that is to mark the
             * string for translation:
             *
             * ```c
             * GtkWidget *about = gtk_about_dialog_new ();
             * gtk_about_dialog_set_translator_credits (GTK_ABOUT_DIALOG (about),
             *                                          _("translator-credits"));
             * ```
             *
             * It is a good idea to use the customary msgid “translator-credits” for this
             * purpose, since translators will already know the purpose of that msgid, and
             * since #GtkAboutDialog will detect if “translator-credits” is untranslated
             * and hide the tab.
             * @param translator_credits the translator credits
             */
            set_translator_credits(translator_credits?: string | null): void;
            /**
             * Sets the version string to display in the about dialog.
             * @param version the version string
             */
            set_version(version?: string | null): void;
            /**
             * Sets the URL to use for the website link.
             * @param website a URL string starting with "http://"
             */
            set_website(website?: string | null): void;
            /**
             * Sets the label to be used for the website link.
             * @param website_label the label used for the website link
             */
            set_website_label(website_label: string): void;
            /**
             * Sets whether the license text in `about` is
             * automatically wrapped.
             * @param wrap_license whether to wrap the license
             */
            set_wrap_license(wrap_license: boolean): void;

            // Inherited methods
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace AccelGroup {
            // Signal callback interfaces

            interface AccelActivate {
                (acceleratable: GObject.Object, keyval: number, modifier: Gdk.ModifierType): boolean;
            }

            interface AccelChanged {
                (keyval: number, modifier: Gdk.ModifierType, accel_closure: GObject.Closure): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {
                is_locked: boolean;
                isLocked: boolean;
                modifier_mask: Gdk.ModifierType;
                modifierMask: Gdk.ModifierType;
            }
        }

        /**
         * A #GtkAccelGroup represents a group of keyboard accelerators,
         * typically attached to a toplevel #GtkWindow (with
         * gtk_window_add_accel_group()). Usually you won’t need to create a
         * #GtkAccelGroup directly; instead, when using #GtkUIManager, GTK+
         * automatically sets up the accelerators for your menus in the ui
         * manager’s #GtkAccelGroup.
         *
         * Note that “accelerators” are different from
         * “mnemonics”. Accelerators are shortcuts for
         * activating a menu item; they appear alongside the menu item they’re a
         * shortcut for. For example “Ctrl+Q” might appear alongside the “Quit”
         * menu item. Mnemonics are shortcuts for GUI elements such as text
         * entries or buttons; they appear as underlined characters. See
         * gtk_label_new_with_mnemonic(). Menu items can have both accelerators
         * and mnemonics, of course.
         */
        class AccelGroup extends GObject.Object {
            static $gtype: GObject.GType<AccelGroup>;

            // Properties

            get is_locked(): boolean;
            get isLocked(): boolean;
            get modifier_mask(): Gdk.ModifierType;
            get modifierMask(): Gdk.ModifierType;

            // Constructors

            constructor(properties?: Partial<AccelGroup.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): AccelGroup;

            // Signals

            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect_after(
                signal: 'accel-activate',
                callback: (
                    _source: this,
                    acceleratable: GObject.Object,
                    keyval: number,
                    modifier: Gdk.ModifierType,
                ) => boolean,
            ): number;
            emit(
                signal: 'accel-activate',
                acceleratable: GObject.Object,
                keyval: number,
                modifier: Gdk.ModifierType,
            ): void;
            connect_after(
                signal: 'accel-changed',
                callback: (
                    _source: this,
                    keyval: number,
                    modifier: Gdk.ModifierType,
                    accel_closure: GObject.Closure,
                ) => void,
            ): number;
            emit(
                signal: 'accel-changed',
                keyval: number,
                modifier: Gdk.ModifierType,
                accel_closure: GObject.Closure,
            ): void;

            // Static methods

            /**
             * Finds the #GtkAccelGroup to which `closure` is connected;
             * see gtk_accel_group_connect().
             * @param closure a #GClosure
             */
            static from_accel_closure(closure: GObject.Closure): AccelGroup | null;

            // Virtual methods

            /**
             * Signal emitted when an entry is added to or removed
             *    from the accel group.
             * @param keyval
             * @param modifier
             * @param accel_closure
             */
            vfunc_accel_changed(keyval: number, modifier: Gdk.ModifierType, accel_closure: GObject.Closure): void;

            // Methods

            /**
             * Finds the first accelerator in `accel_group` that matches
             * `accel_key` and `accel_mods,` and activates it.
             * @param accel_quark the quark for the accelerator name
             * @param acceleratable the #GObject, usually a #GtkWindow, on which    to activate the accelerator
             * @param accel_key accelerator keyval from a key event
             * @param accel_mods keyboard state mask from a key event
             * @returns %TRUE if an accelerator was activated and handled     this keypress
             */
            activate(
                accel_quark: GLib.Quark,
                acceleratable: GObject.Object,
                accel_key: number,
                accel_mods: Gdk.ModifierType | null,
            ): boolean;
            /**
             * Installs an accelerator in this group. When `accel_group` is being
             * activated in response to a call to gtk_accel_groups_activate(),
             * `closure` will be invoked if the `accel_key` and `accel_mods` from
             * gtk_accel_groups_activate() match those of this connection.
             *
             * The signature used for the `closure` is that of #GtkAccelGroupActivate.
             *
             * Note that, due to implementation details, a single closure can
             * only be connected to one accelerator group.
             * @param accel_key key value of the accelerator
             * @param accel_mods modifier combination of the accelerator
             * @param accel_flags a flag mask to configure this accelerator
             * @param closure closure to be executed upon accelerator activation
             */
            connect(
                accel_key: number,
                accel_mods: Gdk.ModifierType | null,
                accel_flags: AccelFlags | null,
                closure: GObject.Closure,
            ): void;
            connect(...args: never[]): any;
            /**
             * Installs an accelerator in this group, using an accelerator path
             * to look up the appropriate key and modifiers (see
             * gtk_accel_map_add_entry()). When `accel_group` is being activated
             * in response to a call to gtk_accel_groups_activate(), `closure` will
             * be invoked if the `accel_key` and `accel_mods` from
             * gtk_accel_groups_activate() match the key and modifiers for the path.
             *
             * The signature used for the `closure` is that of #GtkAccelGroupActivate.
             *
             * Note that `accel_path` string will be stored in a #GQuark. Therefore,
             * if you pass a static string, you can save some memory by interning it
             * first with g_intern_static_string().
             * @param accel_path path used for determining key and modifiers
             * @param closure closure to be executed upon accelerator activation
             */
            connect_by_path(accel_path: string, closure: GObject.Closure): void;
            /**
             * Removes an accelerator previously installed through
             * gtk_accel_group_connect().
             *
             * Since 2.20 `closure` can be %NULL.
             * @param closure the closure to remove from this accelerator     group, or %NULL to remove all closures
             * @returns %TRUE if the closure was found and got disconnected
             */
            disconnect(closure?: GObject.Closure | null): boolean;
            // Conflicted with GObject.Object.disconnect
            disconnect(...args: never[]): any;
            /**
             * Removes an accelerator previously installed through
             * gtk_accel_group_connect().
             * @param accel_key key value of the accelerator
             * @param accel_mods modifier combination of the accelerator
             * @returns %TRUE if there was an accelerator which could be     removed, %FALSE otherwise
             */
            disconnect_key(accel_key: number, accel_mods: Gdk.ModifierType | null): boolean;
            /**
             * Finds the first entry in an accelerator group for which
             * `find_func` returns %TRUE and returns its #GtkAccelKey.
             * @param find_func a function to filter the entries    of @accel_group with
             * @returns the key of the first entry passing    @find_func. The key is owned by GTK+ and must not be freed.
             */
            find(find_func: AccelGroupFindFunc): AccelKey;
            /**
             * Locks are added and removed using gtk_accel_group_lock() and
             * gtk_accel_group_unlock().
             * @returns %TRUE if there are 1 or more locks on the @accel_group,     %FALSE otherwise.
             */
            get_is_locked(): boolean;
            /**
             * Gets a #GdkModifierType representing the mask for this
             * `accel_group`. For example, #GDK_CONTROL_MASK, #GDK_SHIFT_MASK, etc.
             * @returns the modifier mask for this accel group.
             */
            get_modifier_mask(): Gdk.ModifierType;
            /**
             * Locks the given accelerator group.
             *
             * Locking an acelerator group prevents the accelerators contained
             * within it to be changed during runtime. Refer to
             * gtk_accel_map_change_entry() about runtime accelerator changes.
             *
             * If called more than once, `accel_group` remains locked until
             * gtk_accel_group_unlock() has been called an equivalent number
             * of times.
             */
            lock(): void;
            /**
             * Queries an accelerator group for all entries matching `accel_key`
             * and `accel_mods`.
             * @param accel_key key value of the accelerator
             * @param accel_mods modifier combination of the accelerator
             * @returns an array of     @n_entries #GtkAccelGroupEntry elements, or %NULL. The array     is owned by GTK+ and must not be freed.
             */
            query(accel_key: number, accel_mods: Gdk.ModifierType | null): AccelGroupEntry[] | null;
            /**
             * Undoes the last call to gtk_accel_group_lock() on this `accel_group`.
             */
            unlock(): void;
        }

        namespace AccelLabel {
            // Constructor properties interface

            interface ConstructorProps
                extends Label.ConstructorProps,
                    Atk.ImplementorIface.ConstructorProps,
                    Buildable.ConstructorProps {
                accel_closure: GObject.Closure;
                accelClosure: GObject.Closure;
                accel_widget: Widget;
                accelWidget: Widget;
            }
        }

        /**
         * The #GtkAccelLabel widget is a subclass of #GtkLabel that also displays an
         * accelerator key on the right of the label text, e.g. “Ctrl+S”.
         * It is commonly used in menus to show the keyboard short-cuts for commands.
         *
         * The accelerator key to display is typically not set explicitly (although it
         * can be, with gtk_accel_label_set_accel()). Instead, the #GtkAccelLabel displays
         * the accelerators which have been added to a particular widget. This widget is
         * set by calling gtk_accel_label_set_accel_widget().
         *
         * For example, a #GtkMenuItem widget may have an accelerator added to emit
         * the “activate” signal when the “Ctrl+S” key combination is pressed.
         * A #GtkAccelLabel is created and added to the #GtkMenuItem, and
         * gtk_accel_label_set_accel_widget() is called with the #GtkMenuItem as the
         * second argument. The #GtkAccelLabel will now display “Ctrl+S” after its label.
         *
         * Note that creating a #GtkMenuItem with gtk_menu_item_new_with_label() (or
         * one of the similar functions for #GtkCheckMenuItem and #GtkRadioMenuItem)
         * automatically adds a #GtkAccelLabel to the #GtkMenuItem and calls
         * gtk_accel_label_set_accel_widget() to set it up for you.
         *
         * A #GtkAccelLabel will only display accelerators which have %GTK_ACCEL_VISIBLE
         * set (see #GtkAccelFlags).
         * A #GtkAccelLabel can display multiple accelerators and even signal names,
         * though it is almost always used to display just one accelerator key.
         *
         * ## Creating a simple menu item with an accelerator key.
         *
         *
         * ```c
         *   GtkWidget *window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
         *   GtkWidget *menu = gtk_menu_new ();
         *   GtkWidget *save_item;
         *   GtkAccelGroup *accel_group;
         *
         *   // Create a GtkAccelGroup and add it to the window.
         *   accel_group = gtk_accel_group_new ();
         *   gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
         *
         *   // Create the menu item using the convenience function.
         *   save_item = gtk_menu_item_new_with_label ("Save");
         *   gtk_widget_show (save_item);
         *   gtk_container_add (GTK_CONTAINER (menu), save_item);
         *
         *   // Now add the accelerator to the GtkMenuItem. Note that since we
         *   // called gtk_menu_item_new_with_label() to create the GtkMenuItem
         *   // the GtkAccelLabel is automatically set up to display the
         *   // GtkMenuItem accelerators. We just need to make sure we use
         *   // GTK_ACCEL_VISIBLE here.
         *   gtk_widget_add_accelerator (save_item, "activate", accel_group,
         *                               GDK_KEY_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
         * ```
         *
         *
         * # CSS nodes
         *
         *
         * ```<!-- language="plain" -->
         * label
         * ╰── accelerator
         * ```
         *
         *
         * Like #GtkLabel, GtkAccelLabel has a main CSS node with the name label.
         * It adds a subnode with name accelerator.
         */
        class AccelLabel extends Label implements Atk.ImplementorIface, Buildable {
            static $gtype: GObject.GType<AccelLabel>;

            // Properties

            get accel_closure(): GObject.Closure;
            set accel_closure(val: GObject.Closure);
            get accelClosure(): GObject.Closure;
            set accelClosure(val: GObject.Closure);
            get accel_widget(): Widget;
            set accel_widget(val: Widget);
            get accelWidget(): Widget;
            set accelWidget(val: Widget);

            // Fields

            // @ts-expect-error This property conflicts with an accessor in a parent class or interface.
            label: Label;

            // Constructors

            constructor(properties?: Partial<AccelLabel.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](string: string): AccelLabel;
            // Conflicted with Gtk.Label.new

            static ['new'](...args: never[]): any;

            // Methods

            /**
             * Gets the keyval and modifier mask set with
             * gtk_accel_label_set_accel().
             */
            get_accel(): [number, Gdk.ModifierType];
            /**
             * Fetches the widget monitored by this accelerator label. See
             * gtk_accel_label_set_accel_widget().
             * @returns the object monitored by the accelerator label, or %NULL.
             */
            get_accel_widget(): Widget | null;
            /**
             * Returns the width needed to display the accelerator key(s).
             * This is used by menus to align all of the #GtkMenuItem widgets, and shouldn't
             * be needed by applications.
             * @returns the width needed to display the accelerator key(s).
             */
            get_accel_width(): number;
            /**
             * Recreates the string representing the accelerator keys.
             * This should not be needed since the string is automatically updated whenever
             * accelerators are added or removed from the associated widget.
             * @returns always returns %FALSE.
             */
            refetch(): boolean;
            /**
             * Manually sets a keyval and modifier mask as the accelerator rendered
             * by `accel_label`.
             *
             * If a keyval and modifier are explicitly set then these values are
             * used regardless of any associated accel closure or widget.
             *
             * Providing an `accelerator_key` of 0 removes the manual setting.
             * @param accelerator_key a keyval, or 0
             * @param accelerator_mods the modifier mask for the accel
             */
            set_accel(accelerator_key: number, accelerator_mods: Gdk.ModifierType | null): void;
            /**
             * Sets the closure to be monitored by this accelerator label. The closure
             * must be connected to an accelerator group; see gtk_accel_group_connect().
             * Passing %NULL for `accel_closure` will dissociate `accel_label` from its
             * current closure, if any.
             * @param accel_closure the closure to monitor for accelerator changes, or %NULL
             */
            set_accel_closure(accel_closure?: GObject.Closure | null): void;
            /**
             * Sets the widget to be monitored by this accelerator label. Passing %NULL for
             * `accel_widget` will dissociate `accel_label` from its current widget, if any.
             * @param accel_widget the widget to be monitored, or %NULL
             */
            set_accel_widget(accel_widget?: Widget | null): void;

            // Inherited methods
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace AccelMap {
            // Signal callback interfaces

            interface Changed {
                (accel_path: string, accel_key: number, accel_mods: Gdk.ModifierType): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * Accelerator maps are used to define runtime configurable accelerators.
         * Functions for manipulating them are are usually used by higher level
         * convenience mechanisms like #GtkUIManager and are thus considered
         * “low-level”. You’ll want to use them if you’re manually creating menus that
         * should have user-configurable accelerators.
         *
         * An accelerator is uniquely defined by:
         * - accelerator path
         * - accelerator key
         * - accelerator modifiers
         *
         * The accelerator path must consist of
         * “<WINDOWTYPE>/Category1/Category2/.../Action”, where WINDOWTYPE
         * should be a unique application-specific identifier that corresponds
         * to the kind of window the accelerator is being used in, e.g.
         * “Gimp-Image”, “Abiword-Document” or “Gnumeric-Settings”.
         * The “Category1/.../Action” portion is most appropriately chosen by
         * the action the accelerator triggers, i.e. for accelerators on menu
         * items, choose the item’s menu path, e.g. “File/Save As”,
         * “Image/View/Zoom” or “Edit/Select All”. So a full valid accelerator
         * path may look like: “<Gimp-Toolbox>/File/Dialogs/Tool Options...”.
         *
         * All accelerators are stored inside one global #GtkAccelMap that can
         * be obtained using gtk_accel_map_get(). See
         * [Monitoring changes][monitoring-changes] for additional
         * details.
         *
         * # Manipulating accelerators
         *
         * New accelerators can be added using gtk_accel_map_add_entry().
         * To search for specific accelerator, use gtk_accel_map_lookup_entry().
         * Modifications of existing accelerators should be done using
         * gtk_accel_map_change_entry().
         *
         * In order to avoid having some accelerators changed, they can be
         * locked using gtk_accel_map_lock_path(). Unlocking is done using
         * gtk_accel_map_unlock_path().
         *
         * # Saving and loading accelerator maps
         *
         * Accelerator maps can be saved to and loaded from some external
         * resource. For simple saving and loading from file,
         * gtk_accel_map_save() and gtk_accel_map_load() are provided.
         * Saving and loading can also be done by providing file descriptor
         * to gtk_accel_map_save_fd() and gtk_accel_map_load_fd().
         *
         * # Monitoring changes
         *
         * #GtkAccelMap object is only useful for monitoring changes of
         * accelerators. By connecting to #GtkAccelMap::changed signal, one
         * can monitor changes of all accelerators. It is also possible to
         * monitor only single accelerator path by using it as a detail of
         * the #GtkAccelMap::changed signal.
         */
        class AccelMap extends GObject.Object {
            static $gtype: GObject.GType<AccelMap>;

            // Constructors

            constructor(properties?: Partial<AccelMap.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(
                signal: 'changed',
                callback: (_source: this, accel_path: string, accel_key: number, accel_mods: Gdk.ModifierType) => void,
            ): number;
            connect_after(
                signal: 'changed',
                callback: (_source: this, accel_path: string, accel_key: number, accel_mods: Gdk.ModifierType) => void,
            ): number;
            emit(signal: 'changed', accel_path: string, accel_key: number, accel_mods: Gdk.ModifierType): void;

            // Static methods

            /**
             * Registers a new accelerator with the global accelerator map.
             * This function should only be called once per `accel_path`
             * with the canonical `accel_key` and `accel_mods` for this path.
             * To change the accelerator during runtime programatically, use
             * gtk_accel_map_change_entry().
             *
             * Set `accel_key` and `accel_mods` to 0 to request a removal of
             * the accelerator.
             *
             * Note that `accel_path` string will be stored in a #GQuark. Therefore, if you
             * pass a static string, you can save some memory by interning it first with
             * g_intern_static_string().
             * @param accel_path valid accelerator path
             * @param accel_key the accelerator key
             * @param accel_mods the accelerator modifiers
             */
            static add_entry(accel_path: string, accel_key: number, accel_mods: Gdk.ModifierType): void;
            /**
             * Adds a filter to the global list of accel path filters.
             *
             * Accel map entries whose accel path matches one of the filters
             * are skipped by gtk_accel_map_foreach().
             *
             * This function is intended for GTK+ modules that create their own
             * menus, but don’t want them to be saved into the applications accelerator
             * map dump.
             * @param filter_pattern a pattern (see #GPatternSpec)
             */
            static add_filter(filter_pattern: string): void;
            /**
             * Changes the `accel_key` and `accel_mods` currently associated with `accel_path`.
             * Due to conflicts with other accelerators, a change may not always be possible,
             * `replace` indicates whether other accelerators may be deleted to resolve such
             * conflicts. A change will only occur if all conflicts could be resolved (which
             * might not be the case if conflicting accelerators are locked). Successful
             * changes are indicated by a %TRUE return value.
             *
             * Note that `accel_path` string will be stored in a #GQuark. Therefore, if you
             * pass a static string, you can save some memory by interning it first with
             * g_intern_static_string().
             * @param accel_path a valid accelerator path
             * @param accel_key the new accelerator key
             * @param accel_mods the new accelerator modifiers
             * @param replace %TRUE if other accelerators may be deleted upon conflicts
             */
            static change_entry(
                accel_path: string,
                accel_key: number,
                accel_mods: Gdk.ModifierType,
                replace: boolean,
            ): boolean;
            /**
             * Loops over the entries in the accelerator map whose accel path
             * doesn’t match any of the filters added with gtk_accel_map_add_filter(),
             * and execute `foreach_func` on each. The signature of `foreach_func` is
             * that of #GtkAccelMapForeach, the `changed` parameter indicates whether
             * this accelerator was changed during runtime (thus, would need
             * saving during an accelerator map dump).
             * @param data data to be passed into @foreach_func
             * @param foreach_func function to be executed for each accel                map entry which is not filtered out
             */
            static foreach(data: any | null, foreach_func: AccelMapForeach): void;
            /**
             * Loops over all entries in the accelerator map, and execute
             * `foreach_func` on each. The signature of `foreach_func` is that of
             * #GtkAccelMapForeach, the `changed` parameter indicates whether
             * this accelerator was changed during runtime (thus, would need
             * saving during an accelerator map dump).
             * @param data data to be passed into @foreach_func
             * @param foreach_func function to be executed for each accel                map entry
             */
            static foreach_unfiltered(data: any | null, foreach_func: AccelMapForeach): void;
            /**
             * Gets the singleton global #GtkAccelMap object. This object
             * is useful only for notification of changes to the accelerator
             * map via the ::changed signal; it isn’t a parameter to the
             * other accelerator map functions.
             */
            static get(): AccelMap;
            /**
             * Parses a file previously saved with gtk_accel_map_save() for
             * accelerator specifications, and propagates them accordingly.
             * @param file_name a file containing accelerator specifications,   in the GLib file name encoding
             */
            static load(file_name: string): void;
            /**
             * Filedescriptor variant of gtk_accel_map_load().
             *
             * Note that the file descriptor will not be closed by this function.
             * @param fd a valid readable file descriptor
             */
            static load_fd(fd: number): void;
            /**
             * #GScanner variant of gtk_accel_map_load().
             * @param scanner a #GScanner which has already been provided with an input file
             */
            static load_scanner(scanner: GLib.Scanner): void;
            /**
             * Locks the given accelerator path. If the accelerator map doesn’t yet contain
             * an entry for `accel_path,` a new one is created.
             *
             * Locking an accelerator path prevents its accelerator from being changed
             * during runtime. A locked accelerator path can be unlocked by
             * gtk_accel_map_unlock_path(). Refer to gtk_accel_map_change_entry()
             * for information about runtime accelerator changes.
             *
             * If called more than once, `accel_path` remains locked until
             * gtk_accel_map_unlock_path() has been called an equivalent number
             * of times.
             *
             * Note that locking of individual accelerator paths is independent from
             * locking the #GtkAccelGroup containing them. For runtime accelerator
             * changes to be possible, both the accelerator path and its #GtkAccelGroup
             * have to be unlocked.
             * @param accel_path a valid accelerator path
             */
            static lock_path(accel_path: string): void;
            /**
             * Looks up the accelerator entry for `accel_path` and fills in `key`.
             * @param accel_path a valid accelerator path
             */
            static lookup_entry(accel_path: string): [boolean, AccelKey | null];
            /**
             * Saves current accelerator specifications (accelerator path, key
             * and modifiers) to `file_name`.
             * The file is written in a format suitable to be read back in by
             * gtk_accel_map_load().
             * @param file_name the name of the file to contain   accelerator specifications, in the GLib file name encoding
             */
            static save(file_name: string): void;
            /**
             * Filedescriptor variant of gtk_accel_map_save().
             *
             * Note that the file descriptor will not be closed by this function.
             * @param fd a valid writable file descriptor
             */
            static save_fd(fd: number): void;
            /**
             * Undoes the last call to gtk_accel_map_lock_path() on this `accel_path`.
             * Refer to gtk_accel_map_lock_path() for information about accelerator path locking.
             * @param accel_path a valid accelerator path
             */
            static unlock_path(accel_path: string): void;
        }

        namespace Accessible {
            // Constructor properties interface

            interface ConstructorProps extends Atk.Object.ConstructorProps {
                widget: Widget;
            }
        }

        /**
         * The #GtkAccessible class is the base class for accessible
         * implementations for #GtkWidget subclasses. It is a thin
         * wrapper around #AtkObject, which adds facilities for associating
         * a widget with its accessible object.
         *
         * An accessible implementation for a third-party widget should
         * derive from #GtkAccessible and implement the suitable interfaces
         * from ATK, such as #AtkText or #AtkSelection. To establish
         * the connection between the widget class and its corresponding
         * acccessible implementation, override the get_accessible vfunc
         * in #GtkWidgetClass.
         */
        class Accessible extends Atk.Object {
            static $gtype: GObject.GType<Accessible>;

            // Properties

            get widget(): Widget;
            set widget(val: Widget);

            // Constructors

            constructor(properties?: Partial<Accessible.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Virtual methods

            /**
             * This function specifies the callback function to be called
             * when the widget corresponding to a GtkAccessible is destroyed.
             */
            vfunc_connect_widget_destroyed(): void;
            vfunc_widget_set(): void;
            vfunc_widget_unset(): void;

            // Methods

            /**
             * This function specifies the callback function to be called
             * when the widget corresponding to a GtkAccessible is destroyed.
             */
            connect_widget_destroyed(): void;
            /**
             * Gets the #GtkWidget corresponding to the #GtkAccessible.
             * The returned widget does not have a reference added, so
             * you do not need to unref it.
             * @returns pointer to the #GtkWidget     corresponding to the #GtkAccessible, or %NULL.
             */
            get_widget(): Widget | null;
            /**
             * Sets the #GtkWidget corresponding to the #GtkAccessible.
             *
             * `accessible` will not hold a reference to `widget`.
             * It is the caller’s responsibility to ensure that when `widget`
             * is destroyed, the widget is unset by calling this function
             * again with `widget` set to %NULL.
             * @param widget a #GtkWidget or %NULL to unset
             */
            set_widget(widget?: Widget | null): void;
        }

        namespace Action {
            // Signal callback interfaces

            interface Activate {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps, Buildable.ConstructorProps {
                action_group: ActionGroup;
                actionGroup: ActionGroup;
                always_show_image: boolean;
                alwaysShowImage: boolean;
                gicon: Gio.Icon;
                hide_if_empty: boolean;
                hideIfEmpty: boolean;
                icon_name: string;
                iconName: string;
                is_important: boolean;
                isImportant: boolean;
                label: string;
                name: string;
                sensitive: boolean;
                short_label: string;
                shortLabel: string;
                stock_id: string;
                stockId: string;
                tooltip: string;
                visible: boolean;
                visible_horizontal: boolean;
                visibleHorizontal: boolean;
                visible_overflown: boolean;
                visibleOverflown: boolean;
                visible_vertical: boolean;
                visibleVertical: boolean;
            }
        }

        /**
         * > In GTK+ 3.10, GtkAction has been deprecated. Use #GAction
         * > instead, and associate actions with #GtkActionable widgets. Use
         * > #GMenuModel for creating menus with gtk_menu_new_from_model().
         *
         * Actions represent operations that the user can be perform, along with
         * some information how it should be presented in the interface. Each action
         * provides methods to create icons, menu items and toolbar items
         * representing itself.
         *
         * As well as the callback that is called when the action gets activated,
         * the following also gets associated with the action:
         *
         * - a name (not translated, for path lookup)
         *
         * - a label (translated, for display)
         *
         * - an accelerator
         *
         * - whether label indicates a stock id
         *
         * - a tooltip (optional, translated)
         *
         * - a toolbar label (optional, shorter than label)
         *
         *
         * The action will also have some state information:
         *
         * - visible (shown/hidden)
         *
         * - sensitive (enabled/disabled)
         *
         * Apart from regular actions, there are [toggle actions][GtkToggleAction],
         * which can be toggled between two states and
         * [radio actions][GtkRadioAction], of which only one in a group
         * can be in the “active” state. Other actions can be implemented as #GtkAction
         * subclasses.
         *
         * Each action can have one or more proxy widgets. To act as an action proxy,
         * widget needs to implement #GtkActivatable interface. Proxies mirror the state
         * of the action and should change when the action’s state changes. Properties
         * that are always mirrored by proxies are #GtkAction:sensitive and
         * #GtkAction:visible. #GtkAction:gicon, #GtkAction:icon-name, #GtkAction:label,
         * #GtkAction:short-label and #GtkAction:stock-id properties are only mirorred
         * if proxy widget has #GtkActivatable:use-action-appearance property set to
         * %TRUE.
         *
         * When the proxy is activated, it should activate its action.
         */
        class Action extends GObject.Object implements Buildable {
            static $gtype: GObject.GType<Action>;

            // Properties

            /**
             * The GtkActionGroup this GtkAction is associated with, or NULL
             * (for internal use).
             */
            get action_group(): ActionGroup;
            set action_group(val: ActionGroup);
            /**
             * The GtkActionGroup this GtkAction is associated with, or NULL
             * (for internal use).
             */
            get actionGroup(): ActionGroup;
            set actionGroup(val: ActionGroup);
            /**
             * If %TRUE, the action's menu item proxies will ignore the #GtkSettings:gtk-menu-images
             * setting and always show their image, if available.
             *
             * Use this property if the menu item would be useless or hard to use
             * without their image.
             */
            get always_show_image(): boolean;
            set always_show_image(val: boolean);
            /**
             * If %TRUE, the action's menu item proxies will ignore the #GtkSettings:gtk-menu-images
             * setting and always show their image, if available.
             *
             * Use this property if the menu item would be useless or hard to use
             * without their image.
             */
            get alwaysShowImage(): boolean;
            set alwaysShowImage(val: boolean);
            /**
             * The #GIcon displayed in the #GtkAction.
             *
             * Note that the stock icon is preferred, if the #GtkAction:stock-id
             * property holds the id of an existing stock icon.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get gicon(): Gio.Icon;
            set gicon(val: Gio.Icon);
            /**
             * When TRUE, empty menu proxies for this action are hidden.
             */
            get hide_if_empty(): boolean;
            set hide_if_empty(val: boolean);
            /**
             * When TRUE, empty menu proxies for this action are hidden.
             */
            get hideIfEmpty(): boolean;
            set hideIfEmpty(val: boolean);
            /**
             * The name of the icon from the icon theme.
             *
             * Note that the stock icon is preferred, if the #GtkAction:stock-id
             * property holds the id of an existing stock icon, and the #GIcon is
             * preferred if the #GtkAction:gicon property is set.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get icon_name(): string;
            set icon_name(val: string);
            /**
             * The name of the icon from the icon theme.
             *
             * Note that the stock icon is preferred, if the #GtkAction:stock-id
             * property holds the id of an existing stock icon, and the #GIcon is
             * preferred if the #GtkAction:gicon property is set.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get iconName(): string;
            set iconName(val: string);
            /**
             * Whether the action is considered important. When TRUE, toolitem
             * proxies for this action show text in GTK_TOOLBAR_BOTH_HORIZ mode.
             */
            get is_important(): boolean;
            set is_important(val: boolean);
            /**
             * Whether the action is considered important. When TRUE, toolitem
             * proxies for this action show text in GTK_TOOLBAR_BOTH_HORIZ mode.
             */
            get isImportant(): boolean;
            set isImportant(val: boolean);
            /**
             * The label used for menu items and buttons that activate
             * this action. If the label is %NULL, GTK+ uses the stock
             * label specified via the stock-id property.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get label(): string;
            set label(val: string);
            /**
             * A unique name for the action.
             */
            get name(): string;
            /**
             * Whether the action is enabled.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * A shorter label that may be used on toolbar buttons.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get short_label(): string;
            set short_label(val: string);
            /**
             * A shorter label that may be used on toolbar buttons.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get shortLabel(): string;
            set shortLabel(val: string);
            /**
             * The stock icon displayed in widgets representing this action.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get stock_id(): string;
            set stock_id(val: string);
            /**
             * The stock icon displayed in widgets representing this action.
             *
             * This is an appearance property and thus only applies if
             * #GtkActivatable:use-action-appearance is %TRUE.
             */
            get stockId(): string;
            set stockId(val: string);
            /**
             * A tooltip for this action.
             */
            get tooltip(): string;
            set tooltip(val: string);
            /**
             * Whether the action is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
             */
            get visible_horizontal(): boolean;
            set visible_horizontal(val: boolean);
            /**
             * Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
             */
            get visibleHorizontal(): boolean;
            set visibleHorizontal(val: boolean);
            /**
             * When %TRUE, toolitem proxies for this action are represented in the
             * toolbar overflow menu.
             */
            get visible_overflown(): boolean;
            set visible_overflown(val: boolean);
            /**
             * When %TRUE, toolitem proxies for this action are represented in the
             * toolbar overflow menu.
             */
            get visibleOverflown(): boolean;
            set visibleOverflown(val: boolean);
            /**
             * Whether the toolbar item is visible when the toolbar is in a vertical orientation.
             */
            get visible_vertical(): boolean;
            set visible_vertical(val: boolean);
            /**
             * Whether the toolbar item is visible when the toolbar is in a vertical orientation.
             */
            get visibleVertical(): boolean;
            set visibleVertical(val: boolean);

            // Fields

            object: GObject.Object;

            // Constructors

            constructor(properties?: Partial<Action.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](
                name: string,
                label?: string | null,
                tooltip?: string | null,
                stock_id?: string | null,
            ): Action;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activate', callback: (_source: this) => void): number;
            connect_after(signal: 'activate', callback: (_source: this) => void): number;
            emit(signal: 'activate'): void;

            // Virtual methods

            /**
             * Emits the “activate” signal on the specified action, if it isn't
             * insensitive. This gets called by the proxy widgets when they get
             * activated.
             *
             * It can also be used to manually activate an action.
             */
            vfunc_activate(): void;
            vfunc_connect_proxy(proxy: Widget): void;
            /**
             * If `action` provides a #GtkMenu widget as a submenu for the menu
             * item or the toolbar item it creates, this function returns an
             * instance of that menu.
             */
            vfunc_create_menu(): Widget;
            /**
             * Creates a menu item widget that proxies for the given action.
             */
            vfunc_create_menu_item(): Widget;
            /**
             * Creates a toolbar item widget that proxies for the given action.
             */
            vfunc_create_tool_item(): Widget;
            vfunc_disconnect_proxy(proxy: Widget): void;

            // Methods

            /**
             * Emits the “activate” signal on the specified action, if it isn't
             * insensitive. This gets called by the proxy widgets when they get
             * activated.
             *
             * It can also be used to manually activate an action.
             */
            activate(): void;
            /**
             * Disable activation signals from the action
             *
             * This is needed when updating the state of your proxy
             * #GtkActivatable widget could result in calling gtk_action_activate(),
             * this is a convenience function to avoid recursing in those
             * cases (updating toggle state for instance).
             */
            block_activate(): void;
            /**
             * Installs the accelerator for `action` if `action` has an
             * accel path and group. See gtk_action_set_accel_path() and
             * gtk_action_set_accel_group()
             *
             * Since multiple proxies may independently trigger the installation
             * of the accelerator, the `action` counts the number of times this
             * function has been called and doesn’t remove the accelerator until
             * gtk_action_disconnect_accelerator() has been called as many times.
             */
            connect_accelerator(): void;
            /**
             * This function is intended for use by action implementations to
             * create icons displayed in the proxy widgets.
             * @param icon_size the size of the icon (#GtkIconSize) that should      be created.
             * @returns a widget that displays the icon for this action.
             */
            create_icon(icon_size: number): Widget;
            /**
             * If `action` provides a #GtkMenu widget as a submenu for the menu
             * item or the toolbar item it creates, this function returns an
             * instance of that menu.
             * @returns the menu item provided by the               action, or %NULL.
             */
            create_menu(): Widget;
            /**
             * Creates a menu item widget that proxies for the given action.
             * @returns a menu item connected to the action.
             */
            create_menu_item(): Widget;
            /**
             * Creates a toolbar item widget that proxies for the given action.
             * @returns a toolbar item connected to the action.
             */
            create_tool_item(): Widget;
            /**
             * Undoes the effect of one call to gtk_action_connect_accelerator().
             */
            disconnect_accelerator(): void;
            /**
             * Returns the accel closure for this action.
             * @returns the accel closure for this action. The          returned closure is owned by GTK+ and must not be unreffed          or modified.
             */
            get_accel_closure(): GObject.Closure;
            /**
             * Returns the accel path for this action.
             * @returns the accel path for this action, or %NULL   if none is set. The returned string is owned by GTK+   and must not be freed or modified.
             */
            get_accel_path(): string;
            /**
             * Returns whether `action'`s menu item proxies will always
             * show their image, if available.
             * @returns %TRUE if the menu item proxies will always show their image
             */
            get_always_show_image(): boolean;
            /**
             * Gets the gicon of `action`.
             * @returns The action’s #GIcon if one is set.
             */
            get_gicon(): Gio.Icon;
            /**
             * Gets the icon name of `action`.
             * @returns the icon name
             */
            get_icon_name(): string;
            /**
             * Checks whether `action` is important or not
             * @returns whether @action is important
             */
            get_is_important(): boolean;
            /**
             * Gets the label text of `action`.
             * @returns the label text
             */
            get_label(): string;
            /**
             * Returns the name of the action.
             * @returns the name of the action. The string belongs to GTK+ and should not   be freed.
             */
            get_name(): string;
            /**
             * Returns the proxy widgets for an action.
             * See also gtk_activatable_get_related_action().
             * @returns a #GSList of proxy widgets. The list is owned by GTK+ and must not be modified.
             */
            get_proxies(): Widget[];
            /**
             * Returns whether the action itself is sensitive. Note that this doesn’t
             * necessarily mean effective sensitivity. See gtk_action_is_sensitive()
             * for that.
             * @returns %TRUE if the action itself is sensitive.
             */
            get_sensitive(): boolean;
            /**
             * Gets the short label text of `action`.
             * @returns the short label text.
             */
            get_short_label(): string;
            /**
             * Gets the stock id of `action`.
             * @returns the stock id
             */
            get_stock_id(): string;
            /**
             * Gets the tooltip text of `action`.
             * @returns the tooltip text
             */
            get_tooltip(): string;
            /**
             * Returns whether the action itself is visible. Note that this doesn’t
             * necessarily mean effective visibility. See gtk_action_is_sensitive()
             * for that.
             * @returns %TRUE if the action itself is visible.
             */
            get_visible(): boolean;
            /**
             * Checks whether `action` is visible when horizontal
             * @returns whether @action is visible when horizontal
             */
            get_visible_horizontal(): boolean;
            /**
             * Checks whether `action` is visible when horizontal
             * @returns whether @action is visible when horizontal
             */
            get_visible_vertical(): boolean;
            /**
             * Returns whether the action is effectively sensitive.
             * @returns %TRUE if the action and its associated action group are both sensitive.
             */
            is_sensitive(): boolean;
            /**
             * Returns whether the action is effectively visible.
             * @returns %TRUE if the action and its associated action group are both visible.
             */
            is_visible(): boolean;
            /**
             * Sets the #GtkAccelGroup in which the accelerator for this action
             * will be installed.
             * @param accel_group a #GtkAccelGroup or %NULL
             */
            set_accel_group(accel_group?: AccelGroup | null): void;
            /**
             * Sets the accel path for this action.  All proxy widgets associated
             * with the action will have this accel path, so that their
             * accelerators are consistent.
             *
             * Note that `accel_path` string will be stored in a #GQuark. Therefore, if you
             * pass a static string, you can save some memory by interning it first with
             * g_intern_static_string().
             * @param accel_path the accelerator path
             */
            set_accel_path(accel_path: string): void;
            /**
             * Sets whether `action'`s menu item proxies will ignore the
             * #GtkSettings:gtk-menu-images setting and always show their image, if available.
             *
             * Use this if the menu item would be useless or hard to use
             * without their image.
             * @param always_show %TRUE if menuitem proxies should always show their image
             */
            set_always_show_image(always_show: boolean): void;
            /**
             * Sets the icon of `action`.
             * @param icon the #GIcon to set
             */
            set_gicon(icon: Gio.Icon): void;
            /**
             * Sets the icon name on `action`
             * @param icon_name the icon name to set
             */
            set_icon_name(icon_name: string): void;
            /**
             * Sets whether the action is important, this attribute is used
             * primarily by toolbar items to decide whether to show a label
             * or not.
             * @param is_important %TRUE to make the action important
             */
            set_is_important(is_important: boolean): void;
            /**
             * Sets the label of `action`.
             * @param label the label text to set
             */
            set_label(label: string): void;
            /**
             * Sets the :sensitive property of the action to `sensitive`. Note that
             * this doesn’t necessarily mean effective sensitivity. See
             * gtk_action_is_sensitive()
             * for that.
             * @param sensitive %TRUE to make the action sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets a shorter label text on `action`.
             * @param short_label the label text to set
             */
            set_short_label(short_label: string): void;
            /**
             * Sets the stock id on `action`
             * @param stock_id the stock id
             */
            set_stock_id(stock_id: string): void;
            /**
             * Sets the tooltip text on `action`
             * @param tooltip the tooltip text
             */
            set_tooltip(tooltip: string): void;
            /**
             * Sets the :visible property of the action to `visible`. Note that
             * this doesn’t necessarily mean effective visibility. See
             * gtk_action_is_visible()
             * for that.
             * @param visible %TRUE to make the action visible
             */
            set_visible(visible: boolean): void;
            /**
             * Sets whether `action` is visible when horizontal
             * @param visible_horizontal whether the action is visible horizontally
             */
            set_visible_horizontal(visible_horizontal: boolean): void;
            /**
             * Sets whether `action` is visible when vertical
             * @param visible_vertical whether the action is visible vertically
             */
            set_visible_vertical(visible_vertical: boolean): void;
            /**
             * Reenable activation signals from the action
             */
            unblock_activate(): void;

            // Inherited methods
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a #GtkBuilder
             * @param child child to add
             * @param type kind of child or %NULL
             */
            add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Constructs a child of `buildable` with the name `name`.
             *
             * #GtkBuilder calls this function if a “constructor” has been
             * specified in the UI definition.
             * @param builder #GtkBuilder used to construct this object
             * @param name name of child to construct
             * @returns the constructed child
             */
            construct_child<T = GObject.Object>(builder: Builder, name: string): T;
            /**
             * This is similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a #GtkBuilder
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            custom_finished(builder: Builder, child: GObject.Object | null, tagname: string, data?: any | null): void;
            /**
             * This is called at the end of each custom element handled by
             * the buildable.
             * @param builder #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            custom_tag_end(builder: Builder, child: GObject.Object | null, tagname: string, data?: any | null): void;
            /**
             * This is called for each unknown element under `<child>`.
             * @param builder a #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @returns %TRUE if a object has a custom implementation, %FALSE          if it doesn't.
             */
            custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, GLib.MarkupParser, any];
            /**
             * Get the internal child called `childname` of the `buildable` object.
             * @param builder a #GtkBuilder
             * @param childname name of child
             * @returns the internal child of the buildable object
             */
            get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Called when the builder finishes the parsing of a
             * [GtkBuilder UI definition][BUILDER-UI].
             * Note that this will be called once for each time
             * gtk_builder_add_from_file() or gtk_builder_add_from_string()
             * is called on a builder.
             * @param builder a #GtkBuilder
             */
            parser_finished(builder: Builder): void;
            /**
             * Sets the property name `name` to `value` on the `buildable` object.
             * @param builder a #GtkBuilder
             * @param name name of property
             * @param value value of property
             */
            set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Sets the name of the `buildable` object.
             * @param name name to set
             */
            set_name(name: string): void;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a #GtkBuilder
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Constructs a child of `buildable` with the name `name`.
             *
             * #GtkBuilder calls this function if a “constructor” has been
             * specified in the UI definition.
             * @param builder #GtkBuilder used to construct this object
             * @param name name of child to construct
             */
            vfunc_construct_child<T = GObject.Object>(builder: Builder, name: string): T;
            /**
             * This is similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a #GtkBuilder
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * This is called at the end of each custom element handled by
             * the buildable.
             * @param builder #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * This is called for each unknown element under `<child>`.
             * @param builder a #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, GLib.MarkupParser, any];
            /**
             * Get the internal child called `childname` of the `buildable` object.
             * @param builder a #GtkBuilder
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Gets the name of the `buildable` object.
             *
             * #GtkBuilder sets the name based on the
             * [GtkBuilder UI definition][BUILDER-UI]
             * used to construct the `buildable`.
             */
            vfunc_get_name(): string;
            /**
             * Called when the builder finishes the parsing of a
             * [GtkBuilder UI definition][BUILDER-UI].
             * Note that this will be called once for each time
             * gtk_builder_add_from_file() or gtk_builder_add_from_string()
             * is called on a builder.
             * @param builder a #GtkBuilder
             */
            vfunc_parser_finished(builder: Builder): void;
            /**
             * Sets the property name `name` to `value` on the `buildable` object.
             * @param builder a #GtkBuilder
             * @param name name of property
             * @param value value of property
             */
            vfunc_set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Sets the name of the `buildable` object.
             * @param name name to set
             */
            vfunc_set_name(name: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace ActionBar {
            // Constructor properties interface

            interface ConstructorProps
                extends Bin.ConstructorProps,
                    Atk.ImplementorIface.ConstructorProps,
                    Buildable.ConstructorProps {}
        }

        /**
         * GtkActionBar is designed to present contextual actions. It is
         * expected to be displayed below the content and expand horizontally
         * to fill the area.
         *
         * It allows placing children at the start or the end. In addition, it
         * contains an internal centered box which is centered with respect to
         * the full width of the box, even if the children at either side take
         * up different amounts of space.
         *
         * # CSS nodes
         *
         * GtkActionBar has a single CSS node with name actionbar.
         */
        class ActionBar extends Bin implements Atk.ImplementorIface, Buildable {
            static $gtype: GObject.GType<ActionBar>;

            // Constructors

            constructor(properties?: Partial<ActionBar.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): ActionBar;

            // Methods

            /**
             * Retrieves the center bar widget of the bar.
             * @returns the center #GtkWidget or %NULL.
             */
            get_center_widget(): Widget | null;
            /**
             * Adds `child` to `action_bar,` packed with reference to the
             * end of the `action_bar`.
             * @param child the #GtkWidget to be added to @action_bar
             */
            pack_end(child: Widget): void;
            /**
             * Adds `child` to `action_bar,` packed with reference to the
             * start of the `action_bar`.
             * @param child the #GtkWidget to be added to @action_bar
             */
            pack_start(child: Widget): void;
            /**
             * Sets the center widget for the #GtkActionBar.
             * @param center_widget a widget to use for the center
             */
            set_center_widget(center_widget?: Widget | null): void;

            // Inherited methods
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace ActionGroup {
            // Signal callback interfaces

            interface ConnectProxy {
                (action: Action, proxy: Widget): void;
            }

            interface DisconnectProxy {
                (action: Action, proxy: Widget): void;
            }

            interface PostActivate {
                (action: Action): void;
            }

            interface PreActivate {
                (action: Action): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps, Buildable.ConstructorProps {
                accel_group: AccelGroup;
                accelGroup: AccelGroup;
                name: string;
                sensitive: boolean;
                visible: boolean;
            }
        }

        /**
         * Actions are organised into groups. An action group is essentially a
         * map from names to #GtkAction objects.
         *
         * All actions that would make sense to use in a particular context
         * should be in a single group. Multiple action groups may be used for a
         * particular user interface. In fact, it is expected that most nontrivial
         * applications will make use of multiple groups. For example, in an
         * application that can edit multiple documents, one group holding global
         * actions (e.g. quit, about, new), and one group per document holding
         * actions that act on that document (eg. save, cut/copy/paste, etc). Each
         * window’s menus would be constructed from a combination of two action
         * groups.
         *
         * ## Accelerators ## {#Action-Accel}
         *
         * Accelerators are handled by the GTK+ accelerator map. All actions are
         * assigned an accelerator path (which normally has the form
         * `<Actions>/group-name/action-name`) and a shortcut is associated with
         * this accelerator path. All menuitems and toolitems take on this accelerator
         * path. The GTK+ accelerator map code makes sure that the correct shortcut
         * is displayed next to the menu item.
         *
         * # GtkActionGroup as GtkBuildable # {#GtkActionGroup-BUILDER-UI}
         *
         * The #GtkActionGroup implementation of the #GtkBuildable interface accepts
         * #GtkAction objects as `<child>` elements in UI definitions.
         *
         * Note that it is probably more common to define actions and action groups
         * in the code, since they are directly related to what the code can do.
         *
         * The GtkActionGroup implementation of the GtkBuildable interface supports
         * a custom `<accelerator>` element, which has attributes named “key“ and
         * “modifiers“ and allows to specify accelerators. This is similar to the
         * `<accelerator>` element of #GtkWidget, the main difference is that
         * it doesn’t allow you to specify a signal.
         *
         * ## A #GtkDialog UI definition fragment. ##
         *
         *
         * ```<!-- language="xml" -->
         * <object class="GtkActionGroup" id="actiongroup">
         *   <child>
         *       <object class="GtkAction" id="About">
         *           <property name="name">About</property>
         *           <property name="stock_id">gtk-about</property>
         *           <signal handler="about_activate" name="activate"/>
         *       </object>
         *       <accelerator key="F1" modifiers="GDK_CONTROL_MASK | GDK_SHIFT_MASK"/>
         *   </child>
         * </object>
         * ```
         *
         */
        class ActionGroup extends GObject.Object implements Buildable {
            static $gtype: GObject.GType<ActionGroup>;

            // Properties

            /**
             * The accelerator group the actions of this group should use.
             */
            get accel_group(): AccelGroup;
            set accel_group(val: AccelGroup);
            /**
             * The accelerator group the actions of this group should use.
             */
            get accelGroup(): AccelGroup;
            set accelGroup(val: AccelGroup);
            /**
             * A name for the action.
             */
            get name(): string;
            /**
             * Whether the action group is enabled.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Whether the action group is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);

            // Constructors

            constructor(properties?: Partial<ActionGroup.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](name: string): ActionGroup;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'connect-proxy', callback: (_source: this, action: Action, proxy: Widget) => void): number;
            connect_after(
                signal: 'connect-proxy',
                callback: (_source: this, action: Action, proxy: Widget) => void,
            ): number;
            emit(signal: 'connect-proxy', action: Action, proxy: Widget): void;
            connect(
                signal: 'disconnect-proxy',
                callback: (_source: this, action: Action, proxy: Widget) => void,
            ): number;
            connect_after(
                signal: 'disconnect-proxy',
                callback: (_source: this, action: Action, proxy: Widget) => void,
            ): number;
            emit(signal: 'disconnect-proxy', action: Action, proxy: Widget): void;
            connect(signal: 'post-activate', callback: (_source: this, action: Action) => void): number;
            connect_after(signal: 'post-activate', callback: (_source: this, action: Action) => void): number;
            emit(signal: 'post-activate', action: Action): void;
            connect(signal: 'pre-activate', callback: (_source: this, action: Action) => void): number;
            connect_after(signal: 'pre-activate', callback: (_source: this, action: Action) => void): number;
            emit(signal: 'pre-activate', action: Action): void;

            // Virtual methods

            /**
             * Looks up an action in the action group by name.
             * @param action_name the name of the action
             */
            vfunc_get_action(action_name: string): Action;

            // Methods

            /**
             * Adds an action object to the action group. Note that this function
             * does not set up the accel path of the action, which can lead to problems
             * if a user tries to modify the accelerator of a menuitem associated with
             * the action. Therefore you must either set the accel path yourself with
             * gtk_action_set_accel_path(), or use
             * `gtk_action_group_add_action_with_accel (..., NULL)`.
             * @param action an action
             */
            add_action(action: Action): void;
            /**
             * Adds an action object to the action group and sets up the accelerator.
             *
             * If `accelerator` is %NULL, attempts to use the accelerator associated
             * with the stock_id of the action.
             *
             * Accel paths are set to `<Actions>/group-name/action-name`.
             * @param action the action to add
             * @param accelerator the accelerator for the action, in   the format understood by gtk_accelerator_parse(), or "" for no accelerator, or   %NULL to use the stock accelerator
             */
            add_action_with_accel(action: Action, accelerator?: string | null): void;
            /**
             * Gets the accelerator group.
             * @returns the accelerator group associated with this action group or %NULL if there is none.
             */
            get_accel_group(): AccelGroup;
            /**
             * Looks up an action in the action group by name.
             * @param action_name the name of the action
             * @returns the action, or %NULL if no action by that name exists
             */
            get_action(action_name: string): Action;
            /**
             * Gets the name of the action group.
             * @returns the name of the action group.
             */
            get_name(): string;
            /**
             * Returns %TRUE if the group is sensitive.  The constituent actions
             * can only be logically sensitive (see gtk_action_is_sensitive()) if
             * they are sensitive (see gtk_action_get_sensitive()) and their group
             * is sensitive.
             * @returns %TRUE if the group is sensitive.
             */
            get_sensitive(): boolean;
            /**
             * Returns %TRUE if the group is visible.  The constituent actions
             * can only be logically visible (see gtk_action_is_visible()) if
             * they are visible (see gtk_action_get_visible()) and their group
             * is visible.
             * @returns %TRUE if the group is visible.
             */
            get_visible(): boolean;
            /**
             * Lists the actions in the action group.
             * @returns an allocated list of the action objects in the action group
             */
            list_actions(): Action[];
            /**
             * Removes an action object from the action group.
             * @param action an action
             */
            remove_action(action: Action): void;
            /**
             * Sets the accelerator group to be used by every action in this group.
             * @param accel_group a #GtkAccelGroup to set or %NULL
             */
            set_accel_group(accel_group?: AccelGroup | null): void;
            /**
             * Changes the sensitivity of `action_group`
             * @param sensitive new sensitivity
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets a function to be used for translating the `label` and `tooltip` of
             * #GtkActionEntrys added by gtk_action_group_add_actions().
             *
             * If you’re using gettext(), it is enough to set the translation domain
             * with gtk_action_group_set_translation_domain().
             * @param func a #GtkTranslateFunc
             */
            set_translate_func(func: TranslateFunc): void;
            /**
             * Sets the translation domain and uses g_dgettext() for translating the
             * `label` and `tooltip` of #GtkActionEntrys added by
             * gtk_action_group_add_actions().
             *
             * If you’re not using gettext() for localization, see
             * gtk_action_group_set_translate_func().
             * @param domain the translation domain to use for g_dgettext() calls, or %NULL to use the domain set with textdomain()
             */
            set_translation_domain(domain?: string | null): void;
            /**
             * Changes the visible of `action_group`.
             * @param visible new visiblity
             */
            set_visible(visible: boolean): void;
            /**
             * Translates a string using the function set with
             * gtk_action_group_set_translate_func(). This
             * is mainly intended for language bindings.
             * @param string a string
             * @returns the translation of @string
             */
            translate_string(string: string): string;

            // Inherited methods
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a #GtkBuilder
             * @param child child to add
             * @param type kind of child or %NULL
             */
            add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Constructs a child of `buildable` with the name `name`.
             *
             * #GtkBuilder calls this function if a “constructor” has been
             * specified in the UI definition.
             * @param builder #GtkBuilder used to construct this object
             * @param name name of child to construct
             * @returns the constructed child
             */
            construct_child<T = GObject.Object>(builder: Builder, name: string): T;
            /**
             * This is similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a #GtkBuilder
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            custom_finished(builder: Builder, child: GObject.Object | null, tagname: string, data?: any | null): void;
            /**
             * This is called at the end of each custom element handled by
             * the buildable.
             * @param builder #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            custom_tag_end(builder: Builder, child: GObject.Object | null, tagname: string, data?: any | null): void;
            /**
             * This is called for each unknown element under `<child>`.
             * @param builder a #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @returns %TRUE if a object has a custom implementation, %FALSE          if it doesn't.
             */
            custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, GLib.MarkupParser, any];
            /**
             * Get the internal child called `childname` of the `buildable` object.
             * @param builder a #GtkBuilder
             * @param childname name of child
             * @returns the internal child of the buildable object
             */
            get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Called when the builder finishes the parsing of a
             * [GtkBuilder UI definition][BUILDER-UI].
             * Note that this will be called once for each time
             * gtk_builder_add_from_file() or gtk_builder_add_from_string()
             * is called on a builder.
             * @param builder a #GtkBuilder
             */
            parser_finished(builder: Builder): void;
            /**
             * Sets the property name `name` to `value` on the `buildable` object.
             * @param builder a #GtkBuilder
             * @param name name of property
             * @param value value of property
             */
            set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Sets the name of the `buildable` object.
             * @param name name to set
             */
            set_name(name: string): void;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a #GtkBuilder
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Constructs a child of `buildable` with the name `name`.
             *
             * #GtkBuilder calls this function if a “constructor” has been
             * specified in the UI definition.
             * @param builder #GtkBuilder used to construct this object
             * @param name name of child to construct
             */
            vfunc_construct_child<T = GObject.Object>(builder: Builder, name: string): T;
            /**
             * This is similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a #GtkBuilder
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * This is called at the end of each custom element handled by
             * the buildable.
             * @param builder #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * This is called for each unknown element under `<child>`.
             * @param builder a #GtkBuilder used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, GLib.MarkupParser, any];
            /**
             * Get the internal child called `childname` of the `buildable` object.
             * @param builder a #GtkBuilder
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Gets the name of the `buildable` object.
             *
             * #GtkBuilder sets the name based on the
             * [GtkBuilder UI definition][BUILDER-UI]
             * used to construct the `buildable`.
             */
            vfunc_get_name(): string;
            /**
             * Called when the builder finishes the parsing of a
             * [GtkBuilder UI definition][BUILDER-UI].
             * Note that this will be called once for each time
             * gtk_builder_add_from_file() or gtk_builder_add_from_string()
             * is called on a builder.
             * @param builder a #GtkBuilder
             */
            vfunc_parser_finished(builder: Builder): void;
            /**
             * Sets the property name `name` to `value` on the `buildable` object.
             * @param builder a #GtkBuilder
             * @param name name of property
             * @param value value of property
             */
            vfunc_set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Sets the name of the `buildable` object.
             * @param name name to set
             */
            vfunc_set_name(name: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace Adjustment {
            // Signal callback interfaces

            interface Changed {
                (): void;
            }

            interface ValueChanged {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.InitiallyUnowned.ConstructorProps {
                lower: number;
                page_increment: number;
                pageIncrement: number;
                page_size: number;
                pageSize: number;
                step_increment: number;
                stepIncrement: number;
                upper: number;
                value: number;
            }
        }

        /**
         * The #GtkAdjustment object represents a value which has an associated lower
         * and upper bound, together with step and page increments, and a page size.
         * It is used within several GTK+ widgets, including #GtkSpinButton, #GtkViewport,
         * and #GtkRange (which is a base class for #GtkScrollbar and #GtkScale).
         *
         * The #GtkAdjustment object does not update the value itself. Instead
         * it is left up to the owner of the #GtkAdjustment to control the value.
         */
        class Adjustment extends GObject.InitiallyUnowned {
            static $gtype: GObject.GType<Adjustment>;

            // Properties

            /**
             * The minimum value of the adjustment.
             */
            get lower(): number;
            set lower(val: number);
            /**
             * The page increment of the adjustment.
             */
            get page_increment(): number;
            set page_increment(val: number);
            /**
             * The page increment of the adjustment.
             */
            get pageIncrement(): number;
            set pageIncrement(val: number);
            /**
             * The page size of the adjustment.
             * Note that the page-size is irrelevant and should be set to zero
             * if the adjustment is used for a simple scalar value, e.g. in a
             * #GtkSpinButton.
             */
            get page_size(): number;
            set page_size(val: number);
            /**
             * The page size of the adjustment.
             * Note that the page-size is irrelevant and should be set to zero
             * if the adjustment is used for a simple scalar value, e.g. in a
             * #GtkSpinButton.
             */
            get pageSize(): number;
            set pageSize(val: number);
            /**
             * The step increment of the adjustment.
             */
            get step_increment(): number;
            set step_increment(val: number);
            /**
             * The step increment of the adjustment.
             */
            get stepIncrement(): number;
            set stepIncrement(val: number);
            /**
             * The maximum value of the adjustment.
             * Note that values will be restricted by
             * `upper - page-size` if the page-size
             * property is nonzero.
             */
            get upper(): number;
            set upper(val: number);
            /**
             * The value of the adjustment.
             */
            get value(): number;
            set value(val: number);

            // Constructors

            constructor(properties?: Partial<Adjustment.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](
                value: number,
                lower: number,
                upper: number,
                step_increment: number,
                page_increment: number,
                page_size: number,
            ): Adjustment;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'changed', callback: (_source: this) => void): number;
            connect_after(signal: 'changed', callback: (_source: this) => void): number;
            emit(signal: 'changed'): void;
            connect(signal: 'value-changed', callback: (_source: this) => void): number;
            connect_after(signal: 'value-changed', callback: (_source: this) => void): number;
            emit(signal: 'value-changed'): void;

            // Virtual methods

            /**
             * Emits a #GtkAdjustment::changed signal from the #GtkAdjustment.
             * This is typically called by the owner of the #GtkAdjustment after it has
             * changed any of the #GtkAdjustment properties other than the value.
             */
            vfunc_changed(): void;
            /**
             * Emits a #GtkAdjustment::value-changed signal from the #GtkAdjustment.
             * This is typically called by the owner of the #GtkAdjustment after it has
             * changed the #GtkAdjustment:value property.
             */
            vfunc_value_changed(): void;

            // Methods

            /**
             * Emits a #GtkAdjustment::changed signal from the #GtkAdjustment.
             * This is typically called by the owner of the #GtkAdjustment after it has
             * changed any of the #GtkAdjustment properties other than the value.
             */
            changed(): void;
            /**
             * Updates the #GtkAdjustment:value property to ensure that the range
             * between `lower` and `upper` is in the current page (i.e. between
             * #GtkAdjustment:value and #GtkAdjustment:value + #GtkAdjustment:page-size).
             * If the range is larger than the page size, then only the start of it will
             * be in the current page.
             *
             * A #GtkAdjustment::value-changed signal will be emitted if the value is changed.
             * @param lower the lower value
             * @param upper the upper value
             */
            clamp_page(lower: number, upper: number): void;
            /**
             * Sets all properties of the adjustment at once.
             *
             * Use this function to avoid multiple emissions of the
             * #GtkAdjustment::changed signal. See gtk_adjustment_set_lower()
             * for an alternative way of compressing multiple emissions of
             * #GtkAdjustment::changed into one.
             * @param value the new value
             * @param lower the new minimum value
             * @param upper the new maximum value
             * @param step_increment the new step increment
             * @param page_increment the new page increment
             * @param page_size the new page size
             */
            configure(
                value: number,
                lower: number,
                upper: number,
                step_increment: number,
                page_increment: number,
                page_size: number,
            ): void;
            /**
             * Retrieves the minimum value of the adjustment.
             * @returns The current minimum value of the adjustment
             */
            get_lower(): number;
            /**
             * Gets the smaller of step increment and page increment.
             * @returns the minimum increment of @adjustment
             */
            get_minimum_increment(): number;
            /**
             * Retrieves the page increment of the adjustment.
             * @returns The current page increment of the adjustment
             */
            get_page_increment(): number;
            /**
             * Retrieves the page size of the adjustment.
             * @returns The current page size of the adjustment
             */
            get_page_size(): number;
            /**
             * Retrieves the step increment of the adjustment.
             * @returns The current step increment of the adjustment.
             */
            get_step_increment(): number;
            /**
             * Retrieves the maximum value of the adjustment.
             * @returns The current maximum value of the adjustment
             */
            get_upper(): number;
            /**
             * Gets the current value of the adjustment.
             * See gtk_adjustment_set_value().
             * @returns The current value of the adjustment
             */
            get_value(): number;
            /**
             * Sets the minimum value of the adjustment.
             *
             * When setting multiple adjustment properties via their individual
             * setters, multiple #GtkAdjustment::changed signals will be emitted.
             * However, since the emission of the #GtkAdjustment::changed signal
             * is tied to the emission of the #GObject::notify signals of the changed
             * properties, it’s possible to compress the #GtkAdjustment::changed
             * signals into one by calling g_object_freeze_notify() and
             * g_object_thaw_notify() around the calls to the individual setters.
             *
             * Alternatively, using a single g_object_set() for all the properties
             * to change, or using gtk_adjustment_configure() has the same effect
             * of compressing #GtkAdjustment::changed emissions.
             * @param lower the new minimum value
             */
            set_lower(lower: number): void;
            /**
             * Sets the page increment of the adjustment.
             *
             * See gtk_adjustment_set_lower() about how to compress multiple
             * emissions of the #GtkAdjustment::changed signal when setting
             * multiple adjustment properties.
             * @param page_increment the new page increment
             */
            set_page_increment(page_increment: number): void;
            /**
             * Sets the page size of the adjustment.
             *
             * See gtk_adjustment_set_lower() about how to compress multiple
             * emissions of the GtkAdjustment::changed signal when setting
             * multiple adjustment properties.
             * @param page_size the new page size
             */
            set_page_size(page_size: number): void;
            /**
             * Sets the step increment of the adjustment.
             *
             * See gtk_adjustment_set_lower() about how to compress multiple
             * emissions of the #GtkAdjustment::changed signal when setting
             * multiple adjustment properties.
             * @param step_increment the new step increment
             */
            set_step_increment(step_increment: number): void;
            /**
             * Sets the maximum value of the adjustment.
             *
             * Note that values will be restricted by `upper - page-size`
             * if the page-size property is nonzero.
             *
             * See gtk_adjustment_set_lower() about how to compress multiple
             * emissions of the #GtkAdjustment::changed signal when setting
             * multiple adjustment properties.
             * @param upper the new maximum value
             */
            set_upper(upper: number): void;
            /**
             * Sets the #GtkAdjustment value. The value is clamped to lie between
             * #GtkAdjustment:lower and #GtkAdjustment:upper.
             *
             * Note that for adjustments which are used in a #GtkScrollbar, the
             * effective range of allowed values goes from #GtkAdjustment:lower to
             * #GtkAdjustment:upper - #GtkAdjustment:page-size.
             * @param value the new value
             */
            set_value(value: number): void;
            /**
             * Emits a #GtkAdjustment::value-changed signal from the #GtkAdjustment.
             * This is typically called by the owner of the #GtkAdjustment after it has
             * changed the #GtkAdjustment:value property.
             */
            value_changed(): void;
        }

        namespace Alignment {
            // Constructor properties interface

            interface ConstructorProps
                extends Bin.ConstructorProps,
                    Atk.ImplementorIface.ConstructorProps,
                    Buildable.ConstructorProps {
                bottom_padding: number;
                bottomPadding: number;
                left_padding: number;
                leftPadding: number;
                right_padding: number;
                rightPadding: number;
                top_padding: number;
                topPadding: number;
                xalign: number;
                xscale: number;
                yalign: number;
                yscale: number;
            }
        }

        /**
         * The #GtkAlignment widget controls the alignment and size of its child widget.
         * It has four settings: xscale, yscale, xalign, and yalign.
         *
         * The scale settings are used to specify how much the child widget should
         * expand to fill the space allocated to the #GtkAlignment.
         * The values can range from 0 (meaning the child doesn’t expand at all) to
         * 1 (meaning the child expands to fill all of the available space).
         *
         * The align settings are used to place the child widget within the available
         * area. The values range from 0 (top or left) to 1 (bottom or right).
         * Of course, if the scale settings are both set to 1, the alignment settings
         * have no effect.
         *
         * GtkAlignment has been deprecated in 3.14 and should not be used in
         * newly-written code. The desired effect can be achieved by using the
         * #GtkWidget:halign, #GtkWidget:valign and #GtkWidget:margin properties on the
         * child widget.
         */
        class Alignment extends Bin implements Atk.ImplementorIface, Buildable {
            static $gtype: GObject.GType<Alignment>;

            // Properties

            /**
             * The padding to insert at the bottom of the widget.
             */
            get bottom_padding(): number;
            set bottom_padding(val: number);
            /**
             * The padding to insert at the bottom of the widget.
             */
            get bottomPadding(): number;
            set bottomPadding(val: number);
            /**
             * The padding to insert at the left of the widget.
             */
            get left_padding(): number;
            set left_padding(val: number);
            /**
             * The padding to insert at the left of the widget.
             */
            get leftPadding(): number;
            set leftPadding(val: number);
            /**
             * The padding to insert at the right of the widget.
             */
            get right_padding(): number;
            set right_padding(val: number);
            /**
             * The padding to insert at the right of the widget.
             */
            get rightPadding(): number;
            set rightPadding(val: number);
            /**
             * The padding to insert at the top of the widget.
             */
            get top_padding(): number;
            set top_padding(val: number);
            /**
             * The padding to insert at the top of the widget.
             */
            get topPadding(): number;
            set topPadding(val: number);
            /**
             * Horizontal position of child in available space. A value of 0.0
             * will flush the child left (or right, in RTL locales); a value
             * of 1.0 will flush the child right (or left, in RTL locales).
             */
            get xalign(): number;
            set xalign(val: number);
            /**
             * If available horizontal space is bigger than needed, how much
             * of it to use for the child. A value of 0.0 means none; a value
             * of 1.0 means all.
             */
            get xscale(): number;
            set xscale(val: number);
            /**
             * Vertical position of child in available space. A value of 0.0
             * will flush the child to the top; a value of 1.0 will flush the
             * child to the bottom.
             */
            get yalign(): number;
            set yalign(val: number);
            /**
             * If available vertical space is bigger than needed, how much
             * of it to use for the child. A value of 0.0 means none; a value
             * of 1.0 means all.
             */
            get yscale(): number;
            set yscale(val: number);

            // Fields

            bin: Bin;

            // Constructors

            constructor(properties?: Partial<Alignment.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](xalign: number, yalign: number, xscale: number, yscale: number): Alignment;

            // Methods

            /**
             * Gets the padding on the different sides of the widget.
             * See gtk_alignment_set_padding ().
             */
            get_padding(): [number, number, number, number];
            /**
             * Sets the #GtkAlignment values.
             * @param xalign the horizontal alignment of the child widget, from 0 (left) to 1  (right).
             * @param yalign the vertical alignment of the child widget, from 0 (top) to 1  (bottom).
             * @param xscale the amount that the child widget expands horizontally to fill up  unused space, from 0 to 1.  A value of 0 indicates that the child widget should never expand.  A value of 1 indicates that the child widget will expand to fill all of the  space allocated for the #GtkAlignment.
             * @param yscale the amount that the child widget expands vertically to fill up  unused space, from 0 to 1. The values are similar to @xscale.
             */
            set(xalign: number, yalign: number, xscale: number, yscale: number): void;
            // Conflicted with GObject.Object.set
            set(...args: never[]): any;
            /**
             * Sets the padding on the different sides of the widget.
             * The padding adds blank space to the sides of the widget. For instance,
             * this can be used to indent the child widget towards the right by adding
             * padding on the left.
             * @param padding_top the padding at the top of the widget
             * @param padding_bottom the padding at the bottom of the widget
             * @param padding_left the padding at the left of the widget
             * @param padding_right the padding at the right of the widget.
             */
            set_padding(padding_top: number, padding_bottom: number, padding_left: number, padding_right: number): void;

            // Inherited methods
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace AppChooserButton {
            // Signal callback interfaces

            interface CustomItemActivated {
                (item_name: string): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends ComboBox.ConstructorProps,
                    Atk.ImplementorIface.ConstructorProps,
                    AppChooser.ConstructorProps,
                    Buildable.ConstructorProps,
                    CellEditable.ConstructorProps,
                    CellLayout.ConstructorProps {
                heading: string;
                show_default_item: boolean;
                showDefaultItem: boolean;
                show_dialog_item: boolean;
                showDialogItem: boolean;
            }
        }

        /**
         * The #GtkAppChooserButton is a widget that lets the user select
         * an application. It implements the #GtkAppChooser interface.
         *
         * Initially, a #GtkAppChooserButton selects the first application
         * in its list, which will either be the most-recently used application
         * or, if #GtkAppChooserButton:show-default-item is %TRUE, the
         * default application.
         *
         * The list of applications shown in a #GtkAppChooserButton includes
         * the recommended applications for the given content type. When
         * #GtkAppChooserButton:show-default-item is set, the default application
         * is also included. To let the user chooser other applications,
         * you can set the #GtkAppChooserButton:show-dialog-item property,
         * which allows to open a full #GtkAppChooserDialog.
         *
         * It is possible to add custom items to the list, using
         * gtk_app_chooser_button_append_custom_item(). These items cause
         * the #GtkAppChooserButton::custom-item-activated signal to be
         * emitted when they are selected.
         *
         * To track changes in the selected application, use the
         * #GtkComboBox::changed signal.
         */
        class AppChooserButton
            extends ComboBox
            implements Atk.ImplementorIface, AppChooser, Buildable, CellEditable, CellLayout
        {
            static $gtype: GObject.GType<AppChooserButton>;

            // Properties

            /**
             * The text to show at the top of the dialog that can be
             * opened from the button. The string may contain Pango markup.
             */
            get heading(): string;
            set heading(val: string);
            /**
             * The #GtkAppChooserButton:show-default-item property determines
             * whether the dropdown menu should show the default application
             * on top for the provided content type.
             */
            get show_default_item(): boolean;
            set show_default_item(val: boolean);
            /**
             * The #GtkAppChooserButton:show-default-item property determines
             * whether the dropdown menu should show the default application
             * on top for the provided content type.
             */
            get showDefaultItem(): boolean;
            set showDefaultItem(val: boolean);
            /**
             * The #GtkAppChooserButton:show-dialog-item property determines
             * whether the dropdown menu should show an item that triggers
             * a #GtkAppChooserDialog when clicked.
             */
            get show_dialog_item(): boolean;
            set show_dialog_item(val: boolean);
            /**
             * The #GtkAppChooserButton:show-dialog-item property determines
             * whether the dropdown menu should show an item that triggers
             * a #GtkAppChooserDialog when clicked.
             */
            get showDialogItem(): boolean;
            set showDialogItem(val: boolean);

            // Constructors

            constructor(properties?: Partial<AppChooserButton.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](content_type: string): AppChooserButton;
            // Conflicted with Gtk.ComboBox.new

            static ['new'](...args: never[]): any;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'custom-item-activated', callback: (_source: this, item_name: string) => void): number;
            connect_after(
                signal: 'custom-item-activated',
                callback: (_source: this, item_name: string) => void,
            ): number;
            emit(signal: 'custom-item-activated', item_name: string): void;

            // Virtual methods

            /**
             * Signal emitted when a custom item,
             *    previously added with gtk_app_chooser_button_append_custom_item(),
             *    is activated from the dropdown menu.
             * @param item_name
             */
            vfunc_custom_item_activated(item_name: string): void;

            // Methods

            /**
             * Appends a custom item to the list of applications that is shown
             * in the popup; the item name must be unique per-widget.
             * Clients can use the provided name as a detail for the
             * #GtkAppChooserButton::custom-item-activated signal, to add a
             * callback for the activation of a particular custom item in the list.
             * See also gtk_app_chooser_button_append_separator().
             * @param name the name of the custom item
             * @param label the label for the custom item
             * @param icon the icon for the custom item
             */
            append_custom_item(name: string, label: string, icon: Gio.Icon): void;
            /**
             * Appends a separator to the list of applications that is shown
             * in the popup.
             */
            append_separator(): void;
            /**
             * Returns the text to display at the top of the dialog.
             * @returns the text to display at the top of the dialog,     or %NULL, in which case a default text is displayed
             */
            get_heading(): string | null;
            /**
             * Returns the current value of the #GtkAppChooserButton:show-default-item
             * property.
             * @returns the value of #GtkAppChooserButton:show-default-item
             */
            get_show_default_item(): boolean;
            /**
             * Returns the current value of the #GtkAppChooserButton:show-dialog-item
             * property.
             * @returns the value of #GtkAppChooserButton:show-dialog-item
             */
            get_show_dialog_item(): boolean;
            /**
             * Selects a custom item previously added with
             * gtk_app_chooser_button_append_custom_item().
             *
             * Use gtk_app_chooser_refresh() to bring the selection
             * to its initial state.
             * @param name the name of the custom item
             */
            set_active_custom_item(name: string): void;
            /**
             * Sets the text to display at the top of the dialog.
             * If the heading is not set, the dialog displays a default text.
             * @param heading a string containing Pango markup
             */
            set_heading(heading: string): void;
            /**
             * Sets whether the dropdown menu of this button should show the
             * default application for the given content type at top.
             * @param setting the new value for #GtkAppChooserButton:show-default-item
             */
            set_show_default_item(setting: boolean): void;
            /**
             * Sets whether the dropdown menu of this button should show an
             * entry to trigger a #GtkAppChooserDialog.
             * @param setting the new value for #GtkAppChooserButton:show-dialog-item
             */
            set_show_dialog_item(setting: boolean): void;

            // Inherited properties
            /**
             * The content type of the #GtkAppChooser object.
             *
             * See [GContentType][gio-GContentType]
             * for more information about content types.
             */
            get content_type(): string;
            /**
             * The content type of the #GtkAppChooser object.
             *
             * See [GContentType][gio-GContentType]
             * for more information about content types.
             */
            get contentType(): string;
            /**
             * Indicates whether editing on the cell has been canceled.
             */
            get editing_canceled(): boolean;
            set editing_canceled(val: boolean);
            /**
             * Indicates whether editing on the cell has been canceled.
             */
            get editingCanceled(): boolean;
            set editingCanceled(val: boolean);
            get app_paintable(): boolean;
            set app_paintable(val: boolean);
            get appPaintable(): boolean;
            set appPaintable(val: boolean);
            get can_default(): boolean;
            set can_default(val: boolean);
            get canDefault(): boolean;
            set canDefault(val: boolean);
            get can_focus(): boolean;
            set can_focus(val: boolean);
            get canFocus(): boolean;
            set canFocus(val: boolean);
            get composite_child(): boolean;
            get compositeChild(): boolean;
            /**
             * Whether the widget is double buffered.
             */
            get double_buffered(): boolean;
            set double_buffered(val: boolean);
            /**
             * Whether the widget is double buffered.
             */
            get doubleBuffered(): boolean;
            set doubleBuffered(val: boolean);
            get events(): Gdk.EventMask;
            set events(val: Gdk.EventMask);
            /**
             * Whether to expand in both directions. Setting this sets both #GtkWidget:hexpand and #GtkWidget:vexpand
             */
            get expand(): boolean;
            set expand(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             *
             * Before 3.20, several widgets (GtkButton, GtkFileChooserButton,
             * GtkComboBox) implemented this property individually.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             *
             * Before 3.20, several widgets (GtkButton, GtkFileChooserButton,
             * GtkComboBox) implemented this property individually.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space, see #GtkAlign
             */
            get halign(): Align;
            set halign(val: Align);
            get has_default(): boolean;
            set has_default(val: boolean);
            get hasDefault(): boolean;
            set hasDefault(val: boolean);
            get has_focus(): boolean;
            set has_focus(val: boolean);
            get hasFocus(): boolean;
            set hasFocus(val: boolean);
            /**
             * Enables or disables the emission of #GtkWidget::query-tooltip on `widget`.
             * A value of %TRUE indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using #GtkWidget::query-tooltip to determine
             * whether it will provide a tooltip or not.
             *
             * Note that setting this property to %TRUE for the first time will change
             * the event masks of the GdkWindows of this widget to include leave-notify
             * and motion-notify events.  This cannot and will not be undone when the
             * property is set to %FALSE again.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of #GtkWidget::query-tooltip on `widget`.
             * A value of %TRUE indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using #GtkWidget::query-tooltip to determine
             * whether it will provide a tooltip or not.
             *
             * Note that setting this property to %TRUE for the first time will change
             * the event masks of the GdkWindows of this widget to include leave-notify
             * and motion-notify events.  This cannot and will not be undone when the
             * property is set to %FALSE again.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            get height_request(): number;
            set height_request(val: number);
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally. See gtk_widget_set_hexpand().
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the #GtkWidget:hexpand property. See gtk_widget_get_hexpand_set().
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the #GtkWidget:hexpand property. See gtk_widget_get_hexpand_set().
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            get is_focus(): boolean;
            set is_focus(val: boolean);
            get isFocus(): boolean;
            set isFocus(val: boolean);
            /**
             * Sets all four sides' margin at once. If read, returns max
             * margin on any side.
             */
            get margin(): number;
            set margin(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on left side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_left(): number;
            set margin_left(val: number);
            /**
             * Margin on left side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginLeft(): number;
            set marginLeft(val: number);
            /**
             * Margin on right side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_right(): number;
            set margin_right(val: number);
            /**
             * Margin on right side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginRight(): number;
            set marginRight(val: number);
            /**
             * Margin on start of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            get name(): string;
            set name(val: string);
            get no_show_all(): boolean;
            set no_show_all(val: boolean);
            get noShowAll(): boolean;
            set noShowAll(val: boolean);
            /**
             * The requested opacity of the widget. See gtk_widget_set_opacity() for
             * more details about window opacity.
             *
             * Before 3.8 this was only available in GtkWindow
             */
            get opacity(): number;
            set opacity(val: number);
            get parent(): Container;
            set parent(val: Container);
            get receives_default(): boolean;
            set receives_default(val: boolean);
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The scale factor of the widget. See gtk_widget_get_scale_factor() for
             * more details about widget scaling.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget. See gtk_widget_get_scale_factor() for
             * more details about widget scaling.
             */
            get scaleFactor(): number;
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * The style of the widget, which contains information about how it will look (colors, etc).
             */
            get style(): Style;
            set style(val: Style);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with the [Pango text markup language][PangoMarkupFormat].
             * Also see gtk_tooltip_set_markup().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with the [Pango text markup language][PangoMarkupFormat].
             * Also see gtk_tooltip_set_markup().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see gtk_tooltip_set_text().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see gtk_tooltip_set_text().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space, see #GtkAlign
             */
            get valign(): Align;
            set valign(val: Align);
            /**
             * Whether to expand vertically. See gtk_widget_set_vexpand().
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the #GtkWidget:vexpand property. See gtk_widget_get_vexpand_set().
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the #GtkWidget:vexpand property. See gtk_widget_get_vexpand_set().
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            get visible(): boolean;
            set visible(val: boolean);
            get width_request(): number;
            set width_request(val: number);
            get widthRequest(): number;
            set widthRequest(val: number);
            /**
             * The widget's window if it is realized, %NULL otherwise.
             */
            get window(): Gdk.Window;

            // Inherited methods
            /**
             * Returns the currently selected application.
             * @returns a #GAppInfo for the currently selected     application, or %NULL if none is selected. Free with g_object_unref()
             */
            get_app_info(): Gio.AppInfo | null;
            /**
             * Returns the current value of the #GtkAppChooser:content-type property.
             * @returns the content type of @self. Free with g_free()
             */
            get_content_type(): string;
            /**
             * Reloads the list of applications.
             */
            refresh(): void;
            /**
             * Emits the #GtkCellEditable::editing-done signal.
             */
            editing_done(): void;
            /**
             * Emits the #GtkCellEditable::remove-widget signal.
             */
            remove_widget(): void;
            /**
             * Begins editing on a `cell_editable`.
             *
             * The #GtkCellRenderer for the cell creates and returns a #GtkCellEditable from
             * gtk_cell_renderer_start_editing(), configured for the #GtkCellRenderer type.
             *
             * gtk_cell_editable_start_editing() can then set up `cell_editable` suitably for
             * editing a cell, e.g. making the Esc key emit #GtkCellEditable::editing-done.
             *
             * Note that the `cell_editable` is created on-demand for the current edit; its
             * lifetime is temporary and does not persist across other edits and/or cells.
             * @param event The #GdkEvent that began the editing process, or   %NULL if editing was initiated programmatically
             */
            start_editing(event?: Gdk.Event | null): void;
            /**
             * Emits the #GtkCellEditable::editing-done signal.
             */
            vfunc_editing_done(): void;
            /**
             * Emits the #GtkCellEditable::remove-widget signal.
             */
            vfunc_remove_widget(): void;
            /**
             * Begins editing on a `cell_editable`.
             *
             * The #GtkCellRenderer for the cell creates and returns a #GtkCellEditable from
             * gtk_cell_renderer_start_editing(), configured for the #GtkCellRenderer type.
             *
             * gtk_cell_editable_start_editing() can then set up `cell_editable` suitably for
             * editing a cell, e.g. making the Esc key emit #GtkCellEditable::editing-done.
             *
             * Note that the `cell_editable` is created on-demand for the current edit; its
             * lifetime is temporary and does not persist across other edits and/or cells.
             * @param event The #GdkEvent that began the editing process, or   %NULL if editing was initiated programmatically
             */
            vfunc_start_editing(event?: Gdk.Event | null): void;
            /**
             * Adds an attribute mapping to the list in `cell_layout`.
             *
             * The `column` is the column of the model to get a value from, and the
             * `attribute` is the parameter on `cell` to be set from the value. So for
             * example if column 2 of the model contains strings, you could have the
             * “text” attribute of a #GtkCellRendererText get its values from column 2.
             * @param cell a #GtkCellRenderer
             * @param attribute an attribute on the renderer
             * @param column the column position on the model to get the attribute from
             */
            add_attribute(cell: CellRenderer, attribute: string, column: number): void;
            /**
             * Unsets all the mappings on all renderers on `cell_layout` and
             * removes all renderers from `cell_layout`.
             */
            clear(): void;
            /**
             * Clears all existing attributes previously set with
             * gtk_cell_layout_set_attributes().
             * @param cell a #GtkCellRenderer to clear the attribute mapping on
             */
            clear_attributes(cell: CellRenderer): void;
            /**
             * Returns the underlying #GtkCellArea which might be `cell_layout`
             * if called on a #GtkCellArea or might be %NULL if no #GtkCellArea
             * is used by `cell_layout`.
             * @returns the cell area used by @cell_layout, or %NULL in case no cell area is used.
             */
            get_area(): CellArea | null;
            /**
             * Returns the cell renderers which have been added to `cell_layout`.
             * @returns a list of cell renderers. The list, but not the renderers has     been newly allocated and should be freed with g_list_free()     when no longer needed.
             */
            get_cells(): CellRenderer[];
            /**
             * Adds the `cell` to the end of `cell_layout`. If `expand` is %FALSE, then the
             * `cell` is allocated no more space than it needs. Any unused space is
             * divided evenly between cells for which `expand` is %TRUE.
             *
             * Note that reusing the same cell renderer is not supported.
             * @param cell a #GtkCellRenderer
             * @param expand %TRUE if @cell is to be given extra space allocated to @cell_layout
             */
            pack_end(cell: CellRenderer, expand: boolean): void;
            /**
             * Packs the `cell` into the beginning of `cell_layout`. If `expand` is %FALSE,
             * then the `cell` is allocated no more space than it needs. Any unused space
             * is divided evenly between cells for which `expand` is %TRUE.
             *
             * Note that reusing the same cell renderer is not supported.
             * @param cell a #GtkCellRenderer
             * @param expand %TRUE if @cell is to be given extra space allocated to @cell_layout
             */
            pack_start(cell: CellRenderer, expand: boolean): void;
            /**
             * Re-inserts `cell` at `position`.
             *
             * Note that `cell` has already to be packed into `cell_layout`
             * for this to function properly.
             * @param cell a #GtkCellRenderer to reorder
             * @param position new position to insert @cell at
             */
            reorder(cell: CellRenderer, position: number): void;
            /**
             * Sets the #GtkCellLayoutDataFunc to use for `cell_layout`.
             *
             * This function is used instead of the standard attributes mapping
             * for setting the column value, and should set the value of `cell_layout’`s
             * cell renderer(s) as appropriate.
             *
             * `func` may be %NULL to remove a previously set function.
             * @param cell a #GtkCellRenderer
             * @param func the #GtkCellLayoutDataFunc to use, or %NULL
             */
            set_cell_data_func(cell: CellRenderer, func?: CellLayoutDataFunc | null): void;
            /**
             * Adds an attribute mapping to the list in `cell_layout`.
             *
             * The `column` is the column of the model to get a value from, and the
             * `attribute` is the parameter on `cell` to be set from the value. So for
             * example if column 2 of the model contains strings, you could have the
             * “text” attribute of a #GtkCellRendererText get its values from column 2.
             * @param cell a #GtkCellRenderer
             * @param attribute an attribute on the renderer
             * @param column the column position on the model to get the attribute from
             */
            vfunc_add_attribute(cell: CellRenderer, attribute: string, column: number): void;
            /**
             * Unsets all the mappings on all renderers on `cell_layout` and
             * removes all renderers from `cell_layout`.
             */
            vfunc_clear(): void;
            /**
             * Clears all existing attributes previously set with
             * gtk_cell_layout_set_attributes().
             * @param cell a #GtkCellRenderer to clear the attribute mapping on
             */
            vfunc_clear_attributes(cell: CellRenderer): void;
            /**
             * Returns the underlying #GtkCellArea which might be `cell_layout`
             * if called on a #GtkCellArea or might be %NULL if no #GtkCellArea
             * is used by `cell_layout`.
             */
            vfunc_get_area(): CellArea | null;
            /**
             * Returns the cell renderers which have been added to `cell_layout`.
             */
            vfunc_get_cells(): CellRenderer[];
            /**
             * Adds the `cell` to the end of `cell_layout`. If `expand` is %FALSE, then the
             * `cell` is allocated no more space than it needs. Any unused space is
             * divided evenly between cells for which `expand` is %TRUE.
             *
             * Note that reusing the same cell renderer is not supported.
             * @param cell a #GtkCellRenderer
             * @param expand %TRUE if @cell is to be given extra space allocated to @cell_layout
             */
            vfunc_pack_end(cell: CellRenderer, expand: boolean): void;
            /**
             * Packs the `cell` into the beginning of `cell_layout`. If `expand` is %FALSE,
             * then the `cell` is allocated no more space than it needs. Any unused space
             * is divided evenly between cells for which `expand` is %TRUE.
             *
             * Note that reusing the same cell renderer is not supported.
             * @param cell a #GtkCellRenderer
             * @param expand %TRUE if @cell is to be given extra space allocated to @cell_layout
             */
            vfunc_pack_start(cell: CellRenderer, expand: boolean): void;
            /**
             * Re-inserts `cell` at `position`.
             *
             * Note that `cell` has already to be packed into `cell_layout`
             * for this to function properly.
             * @param cell a #GtkCellRenderer to reorder
             * @param position new position to insert @cell at
             */
            vfunc_reorder(cell: CellRenderer, position: number): void;
            /**
             * Sets the #GtkCellLayoutDataFunc to use for `cell_layout`.
             *
             * This function is used instead of the standard attributes mapping
             * for setting the column value, and should set the value of `cell_layout’`s
             * cell renderer(s) as appropriate.
             *
             * `func` may be %NULL to remove a previously set function.
             * @param cell a #GtkCellRenderer
             * @param func the #GtkCellLayoutDataFunc to use, or %NULL
             */
            vfunc_set_cell_data_func(cell: CellRenderer, func?: CellLayoutDataFunc | null): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * For widgets that can be “activated” (buttons, menu items, etc.)
             * this function activates them. Activation is what happens when you
             * press Enter on a widget during key navigation. If `widget` isn't
             * activatable, the function returns %FALSE.
             * @returns %TRUE if the widget was activatable
             */
            activate(): boolean;
            /**
             * Installs an accelerator for this `widget` in `accel_group` that causes
             * `accel_signal` to be emitted if the accelerator is activated.
             * The `accel_group` needs to be added to the widget’s toplevel via
             * gtk_window_add_accel_group(), and the signal must be of type %G_SIGNAL_ACTION.
             * Accelerators added through this function are not user changeable during
             * runtime. If you want to support accelerators that can be changed by the
             * user, use gtk_accel_map_add_entry() and gtk_widget_set_accel_path() or
             * gtk_menu_item_set_accel_path() instead.
             * @param accel_signal widget signal to emit on accelerator activation
             * @param accel_group accel group for this widget, added to its toplevel
             * @param accel_key GDK keyval of the accelerator
             * @param accel_mods modifier key combination of the accelerator
             * @param accel_flags flag accelerators, e.g. %GTK_ACCEL_VISIBLE
             */
            add_accelerator(
                accel_signal: string,
                accel_group: AccelGroup,
                accel_key: number,
                accel_mods: Gdk.ModifierType | null,
                accel_flags: AccelFlags | null,
            ): void;
            /**
             * Adds the device events in the bitfield `events` to the event mask for
             * `widget`. See gtk_widget_set_device_events() for details.
             * @param device a #GdkDevice
             * @param events an event mask, see #GdkEventMask
             */
            add_device_events(device: Gdk.Device, events: Gdk.EventMask | null): void;
            /**
             * Adds the events in the bitfield `events` to the event mask for
             * `widget`. See gtk_widget_set_events() and the
             * [input handling overview][event-masks] for details.
             * @param events an event mask, see #GdkEventMask
             */
            add_events(events: number): void;
            /**
             * Adds a widget to the list of mnemonic labels for
             * this widget. (See gtk_widget_list_mnemonic_labels()). Note the
             * list of mnemonic labels for the widget is cleared when the
             * widget is destroyed, so the caller must make sure to update
             * its internal state at this point as well, by using a connection
             * to the #GtkWidget::destroy signal or a weak notifier.
             * @param label a #GtkWidget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame. Until the tick callback is removed, it will be
             * called frequently (usually at the frame rate of the output device
             * or as quickly as the application can be repainted, whichever is
             * slower). For this reason, is most suitable for handling graphics
             * that change every frame or every few frames. The tick callback does
             * not automatically imply a relayout or repaint. If you want a
             * repaint or relayout, and aren’t changing widget properties that
             * would trigger that (for example, changing the text of a #GtkLabel),
             * then you will have to call gtk_widget_queue_resize() or
             * gtk_widget_queue_draw_area() yourself.
             *
             * gdk_frame_clock_get_frame_time() should generally be used for timing
             * continuous animations and
             * gdk_frame_timings_get_predicted_presentation_time() if you are
             * trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * #GdkFrameClock::update signal of #GdkFrameClock, since you don't
             * have to worry about when a #GdkFrameClock is assigned to a widget.
             * @param callback function to call for updating animations
             * @returns an id for the connection of this callback. Remove the callback     by passing it to gtk_widget_remove_tick_callback()
             */
            add_tick_callback(callback: TickCallback): number;
            /**
             * Determines whether an accelerator that activates the signal
             * identified by `signal_id` can currently be activated.
             * This is done by emitting the #GtkWidget::can-activate-accel
             * signal on `widget;` if the signal isn’t overridden by a
             * handler or in a derived widget, then the default check is
             * that the widget must be sensitive, and the widget and all
             * its ancestors mapped.
             * @param signal_id the ID of a signal installed on @widget
             * @returns %TRUE if the accelerator can be activated.
             */
            can_activate_accel(signal_id: number): boolean;
            /**
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use gtk_widget_grab_focus() to move the focus
             * to a particular widget, and gtk_container_set_focus_chain() to
             * change the focus tab order. So you may want to investigate those
             * functions instead.
             *
             * gtk_widget_child_focus() is called by containers as the user moves
             * around the window using keyboard shortcuts. `direction` indicates
             * what kind of motion is taking place (up, down, left, right, tab
             * forward, tab backward). gtk_widget_child_focus() emits the
             * #GtkWidget::focus signal; widgets override the default handler
             * for this signal in order to implement appropriate focus behavior.
             *
             * The default ::focus handler for a widget should return %TRUE if
             * moving in `direction` left the focus on a focusable location inside
             * that widget, and %FALSE if moving in `direction` moved the focus
             * outside the widget. If returning %TRUE, widgets normally
             * call gtk_widget_grab_focus() to place the focus accordingly;
             * if returning %FALSE, they don’t modify the current focus location.
             * @param direction direction of focus movement
             * @returns %TRUE if focus ended up inside @widget
             */
            child_focus(direction: DirectionType | null): boolean;
            /**
             * Emits a #GtkWidget::child-notify signal for the
             * [child property][child-properties] `child_property`
             * on `widget`.
             *
             * This is the analogue of g_object_notify() for child properties.
             *
             * Also see gtk_container_child_notify().
             * @param child_property the name of a child property installed on the                  class of @widget’s parent
             */
            child_notify(child_property: string): void;
            // Conflicted with Gtk.Container.child_notify
            child_notify(...args: never[]): any;
            /**
             * Same as gtk_widget_path(), but always uses the name of a widget’s type,
             * never uses a custom name set with gtk_widget_set_name().
             */
            class_path(): [number, string, string];
            /**
             * Computes whether a container should give this widget extra space
             * when possible. Containers should check this, rather than
             * looking at gtk_widget_get_hexpand() or gtk_widget_get_vexpand().
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Orientation | null): boolean;
            /**
             * Creates a new #PangoContext with the appropriate font map,
             * font options, font description, and base direction for drawing
             * text for this widget. See also gtk_widget_get_pango_context().
             * @returns the new #PangoContext
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new #PangoLayout with the appropriate font map,
             * font description, and base direction for drawing text for
             * this widget.
             *
             * If you keep a #PangoLayout created in this way around, you need
             * to re-create it when the widget #PangoContext is replaced.
             * This can be tracked by using the #GtkWidget::screen-changed signal
             * on the widget.
             * @param text text to set on the layout (can be %NULL)
             * @returns the new #PangoLayout
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Destroys a widget.
             *
             * When a widget is destroyed all references it holds on other objects
             * will be released:
             *
             *  - if the widget is inside a container, it will be removed from its
             *  parent
             *  - if the widget is a container, all its children will be destroyed,
             *  recursively
             *  - if the widget is a top level, it will be removed from the list
             *  of top level widgets that GTK+ maintains internally
             *
             * It's expected that all references held on the widget will also
             * be released; you should connect to the #GtkWidget::destroy signal
             * if you hold a reference to `widget` and you wish to remove it when
             * this function is called. It is not necessary to do so if you are
             * implementing a #GtkContainer, as you'll be able to use the
             * #GtkContainerClass.remove() virtual function for that.
             *
             * It's important to notice that gtk_widget_destroy() will only cause
             * the `widget` to be finalized if no additional references, acquired
             * using g_object_ref(), are held on it. In case additional references
             * are in place, the `widget` will be in an "inert" state after calling
             * this function; `widget` will still point to valid memory, allowing you
             * to release the references you hold, but you may not query the widget's
             * own state.
             *
             * You should typically call this function on top level widgets, and
             * rarely on child widgets.
             *
             * See also: gtk_container_remove()
             */
            destroy(): void;
            /**
             * This function sets *`widget_pointer` to %NULL if `widget_pointer` !=
             * %NULL.  It’s intended to be used as a callback connected to the
             * “destroy” signal of a widget. You connect gtk_widget_destroyed()
             * as a signal handler, and pass the address of your widget variable
             * as user data. Then when the widget is destroyed, the variable will
             * be set to %NULL. Useful for example to avoid multiple copies
             * of the same dialog.
             * @param widget_pointer address of a variable that contains @widget
             */
            destroyed(widget_pointer: Widget): Widget;
            /**
             * Returns %TRUE if `device` has been shadowed by a GTK+
             * device grab on another widget, so it would stop sending
             * events to `widget`. This may be used in the
             * #GtkWidget::grab-notify signal to check for specific
             * devices. See gtk_device_grab_add().
             * @param device a #GdkDevice
             * @returns %TRUE if there is an ongoing grab on @device          by another #GtkWidget than @widget.
             */
            device_is_shadowed(device: Gdk.Device): boolean;
            /**
             * This function is equivalent to gtk_drag_begin_with_coordinates(),
             * passing -1, -1 as coordinates.
             * @param targets The targets (data formats) in which the    source can provide the data
             * @param actions A bitmask of the allowed drag actions for this drag
             * @param button The button the user clicked to start the drag
             * @param event The event that triggered the start of the drag,    or %NULL if none can be obtained.
             * @returns the context for this drag
             */
            drag_begin(
                targets: TargetList,
                actions: Gdk.DragAction | null,
                button: number,
                event?: Gdk.Event | null,
            ): Gdk.DragContext;
            /**
             * Initiates a drag on the source side. The function only needs to be used
             * when the application is starting drags itself, and is not needed when
             * gtk_drag_source_set() is used.
             *
             * The `event` is used to retrieve the timestamp that will be used internally to
             * grab the pointer.  If `event` is %NULL, then %GDK_CURRENT_TIME will be used.
             * However, you should try to pass a real event in all cases, since that can be
             * used to get information about the drag.
             *
             * Generally there are three cases when you want to start a drag by hand by
             * calling this function:
             *
             * 1. During a #GtkWidget::button-press-event handler, if you want to start a drag
             * immediately when the user presses the mouse button.  Pass the `event`
             * that you have in your #GtkWidget::button-press-event handler.
             *
             * 2. During a #GtkWidget::motion-notify-event handler, if you want to start a drag
             * when the mouse moves past a certain threshold distance after a button-press.
             * Pass the `event` that you have in your #GtkWidget::motion-notify-event handler.
             *
             * 3. During a timeout handler, if you want to start a drag after the mouse
             * button is held down for some time.  Try to save the last event that you got
             * from the mouse, using gdk_event_copy(), and pass it to this function
             * (remember to free the event with gdk_event_free() when you are done).
             * If you really cannot pass a real event, pass %NULL instead.
             * @param targets The targets (data formats) in which the    source can provide the data
             * @param actions A bitmask of the allowed drag actions for this drag
             * @param button The button the user clicked to start the drag
             * @param event The event that triggered the start of the drag,    or %NULL if none can be obtained.
             * @param x The initial x coordinate to start dragging from, in the coordinate space    of @widget. If -1 is passed, the coordinates are retrieved from @event or    the current pointer position
             * @param y The initial y coordinate to start dragging from, in the coordinate space    of @widget. If -1 is passed, the coordinates are retrieved from @event or    the current pointer position
             * @returns the context for this drag
             */
            drag_begin_with_coordinates(
                targets: TargetList,
                actions: Gdk.DragAction | null,
                button: number,
                event: Gdk.Event | null,
                x: number,
                y: number,
            ): Gdk.DragContext;
            /**
             * Checks to see if a mouse drag starting at (`start_x,` `start_y)` and ending
             * at (`current_x,` `current_y)` has passed the GTK+ drag threshold, and thus
             * should trigger the beginning of a drag-and-drop operation.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns %TRUE if the drag threshold has been passed.
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Add the image targets supported by #GtkSelectionData to
             * the target list of the drag destination. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_image_targets() and
             * gtk_drag_dest_set_target_list().
             */
            drag_dest_add_image_targets(): void;
            /**
             * Add the text targets supported by #GtkSelectionData to
             * the target list of the drag destination. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_text_targets() and
             * gtk_drag_dest_set_target_list().
             */
            drag_dest_add_text_targets(): void;
            /**
             * Add the URI targets supported by #GtkSelectionData to
             * the target list of the drag destination. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_uri_targets() and
             * gtk_drag_dest_set_target_list().
             */
            drag_dest_add_uri_targets(): void;
            /**
             * Looks for a match between the supported targets of `context` and the
             * `dest_target_list,` returning the first matching target, otherwise
             * returning %GDK_NONE. `dest_target_list` should usually be the return
             * value from gtk_drag_dest_get_target_list(), but some widgets may
             * have different valid targets for different parts of the widget; in
             * that case, they will have to implement a drag_motion handler that
             * passes the correct target list to this function.
             * @param context drag context
             * @param target_list list of droppable targets, or %NULL to use    gtk_drag_dest_get_target_list (@widget).
             * @returns first target that the source offers     and the dest can accept, or %GDK_NONE
             */
            drag_dest_find_target(context: Gdk.DragContext, target_list?: TargetList | null): Gdk.Atom;
            /**
             * Returns the list of targets this widget can accept from
             * drag-and-drop.
             * @returns the #GtkTargetList, or %NULL if none
             */
            drag_dest_get_target_list(): TargetList | null;
            /**
             * Returns whether the widget has been configured to always
             * emit #GtkWidget::drag-motion signals.
             * @returns %TRUE if the widget always emits   #GtkWidget::drag-motion events
             */
            drag_dest_get_track_motion(): boolean;
            /**
             * Sets a widget as a potential drop destination, and adds default behaviors.
             *
             * The default behaviors listed in `flags` have an effect similar
             * to installing default handlers for the widget’s drag-and-drop signals
             * (#GtkWidget::drag-motion, #GtkWidget::drag-drop, ...). They all exist
             * for convenience. When passing #GTK_DEST_DEFAULT_ALL for instance it is
             * sufficient to connect to the widget’s #GtkWidget::drag-data-received
             * signal to get primitive, but consistent drag-and-drop support.
             *
             * Things become more complicated when you try to preview the dragged data,
             * as described in the documentation for #GtkWidget::drag-motion. The default
             * behaviors described by `flags` make some assumptions, that can conflict
             * with your own signal handlers. For instance #GTK_DEST_DEFAULT_DROP causes
             * invokations of gdk_drag_status() in the context of #GtkWidget::drag-motion,
             * and invokations of gtk_drag_finish() in #GtkWidget::drag-data-received.
             * Especially the later is dramatic, when your own #GtkWidget::drag-motion
             * handler calls gtk_drag_get_data() to inspect the dragged data.
             *
             * There’s no way to set a default action here, you can use the
             * #GtkWidget::drag-motion callback for that. Here’s an example which selects
             * the action to use depending on whether the control key is pressed or not:
             *
             * ```c
             * static void
             * drag_motion (GtkWidget *widget,
             *              GdkDragContext *context,
             *              gint x,
             *              gint y,
             *              guint time)
             * {
             *   GdkModifierType mask;
             *
             *   gdk_window_get_pointer (gtk_widget_get_window (widget),
             *                           NULL, NULL, &mask);
             *   if (mask & GDK_CONTROL_MASK)
             *     gdk_drag_status (context, GDK_ACTION_COPY, time);
             *   else
             *     gdk_drag_status (context, GDK_ACTION_MOVE, time);
             * }
             * ```
             *
             * @param flags which types of default drag behavior to use
             * @param targets a pointer to an array of     #GtkTargetEntrys indicating the drop types that this @widget will     accept, or %NULL. Later you can access the list with     gtk_drag_dest_get_target_list() and gtk_drag_dest_find_target().
             * @param actions a bitmask of possible actions for a drop onto this @widget.
             */
            drag_dest_set(
                flags: DestDefaults | null,
                targets: TargetEntry[] | null,
                actions: Gdk.DragAction | null,
            ): void;
            /**
             * Sets this widget as a proxy for drops to another window.
             * @param proxy_window the window to which to forward drag events
             * @param protocol the drag protocol which the @proxy_window accepts   (You can use gdk_drag_get_protocol() to determine this)
             * @param use_coordinates If %TRUE, send the same coordinates to the   destination, because it is an embedded   subwindow.
             */
            drag_dest_set_proxy(
                proxy_window: Gdk.Window,
                protocol: Gdk.DragProtocol | null,
                use_coordinates: boolean,
            ): void;
            /**
             * Sets the target types that this widget can accept from drag-and-drop.
             * The widget must first be made into a drag destination with
             * gtk_drag_dest_set().
             * @param target_list list of droppable targets, or %NULL for none
             */
            drag_dest_set_target_list(target_list?: TargetList | null): void;
            /**
             * Tells the widget to emit #GtkWidget::drag-motion and
             * #GtkWidget::drag-leave events regardless of the targets and the
             * %GTK_DEST_DEFAULT_MOTION flag.
             *
             * This may be used when a widget wants to do generic
             * actions regardless of the targets that the source offers.
             * @param track_motion whether to accept all targets
             */
            drag_dest_set_track_motion(track_motion: boolean): void;
            /**
             * Clears information about a drop destination set with
             * gtk_drag_dest_set(). The widget will no longer receive
             * notification of drags.
             */
            drag_dest_unset(): void;
            /**
             * Gets the data associated with a drag. When the data
             * is received or the retrieval fails, GTK+ will emit a
             * #GtkWidget::drag-data-received signal. Failure of the retrieval
             * is indicated by the length field of the `selection_data`
             * signal parameter being negative. However, when gtk_drag_get_data()
             * is called implicitely because the %GTK_DEST_DEFAULT_DROP was set,
             * then the widget will not receive notification of failed
             * drops.
             * @param context the drag context
             * @param target the target (form of the data) to retrieve
             * @param time_ a timestamp for retrieving the data. This will   generally be the time received in a #GtkWidget::drag-motion   or #GtkWidget::drag-drop signal
             */
            drag_get_data(context: Gdk.DragContext, target: Gdk.Atom, time_: number): void;
            /**
             * Highlights a widget as a currently hovered drop target.
             * To end the highlight, call gtk_drag_unhighlight().
             * GTK+ calls this automatically if %GTK_DEST_DEFAULT_HIGHLIGHT is set.
             */
            drag_highlight(): void;
            /**
             * Add the writable image targets supported by #GtkSelectionData to
             * the target list of the drag source. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_image_targets() and
             * gtk_drag_source_set_target_list().
             */
            drag_source_add_image_targets(): void;
            /**
             * Add the text targets supported by #GtkSelectionData to
             * the target list of the drag source.  The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_text_targets() and
             * gtk_drag_source_set_target_list().
             */
            drag_source_add_text_targets(): void;
            /**
             * Add the URI targets supported by #GtkSelectionData to
             * the target list of the drag source.  The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_uri_targets() and
             * gtk_drag_source_set_target_list().
             */
            drag_source_add_uri_targets(): void;
            /**
             * Gets the list of targets this widget can provide for
             * drag-and-drop.
             * @returns the #GtkTargetList, or %NULL if none
             */
            drag_source_get_target_list(): TargetList | null;
            /**
             * Sets up a widget so that GTK+ will start a drag operation when the user
             * clicks and drags on the widget. The widget must have a window.
             * @param start_button_mask the bitmask of buttons that can start the drag
             * @param targets the table of targets     that the drag will support, may be %NULL
             * @param actions the bitmask of possible actions for a drag from this widget
             */
            drag_source_set(
                start_button_mask: Gdk.ModifierType | null,
                targets: TargetEntry[] | null,
                actions: Gdk.DragAction | null,
            ): void;
            /**
             * Sets the icon that will be used for drags from a particular source
             * to `icon`. See the docs for #GtkIconTheme for more details.
             * @param icon A #GIcon
             */
            drag_source_set_icon_gicon(icon: Gio.Icon): void;
            /**
             * Sets the icon that will be used for drags from a particular source
             * to a themed icon. See the docs for #GtkIconTheme for more details.
             * @param icon_name name of icon to use
             */
            drag_source_set_icon_name(icon_name: string): void;
            /**
             * Sets the icon that will be used for drags from a particular widget
             * from a #GdkPixbuf. GTK+ retains a reference for `pixbuf` and will
             * release it when it is no longer needed.
             * @param pixbuf the #GdkPixbuf for the drag icon
             */
            drag_source_set_icon_pixbuf(pixbuf: GdkPixbuf.Pixbuf): void;
            /**
             * Sets the icon that will be used for drags from a particular source
             * to a stock icon.
             * @param stock_id the ID of the stock icon to use
             */
            drag_source_set_icon_stock(stock_id: string): void;
            /**
             * Changes the target types that this widget offers for drag-and-drop.
             * The widget must first be made into a drag source with
             * gtk_drag_source_set().
             * @param target_list list of draggable targets, or %NULL for none
             */
            drag_source_set_target_list(target_list?: TargetList | null): void;
            /**
             * Undoes the effects of gtk_drag_source_set().
             */
            drag_source_unset(): void;
            /**
             * Removes a highlight set by gtk_drag_highlight() from
             * a widget.
             */
            drag_unhighlight(): void;
            /**
             * Draws `widget` to `cr`. The top left corner of the widget will be
             * drawn to the currently set origin point of `cr`.
             *
             * You should pass a cairo context as `cr` argument that is in an
             * original state. Otherwise the resulting drawing is undefined. For
             * example changing the operator using cairo_set_operator() or the
             * line width using cairo_set_line_width() might have unwanted side
             * effects.
             * You may however change the context’s transform matrix - like with
             * cairo_scale(), cairo_translate() or cairo_set_matrix() and clip
             * region with cairo_clip() prior to calling this function. Also, it
             * is fine to modify the context with cairo_save() and
             * cairo_push_group() prior to calling this function.
             *
             * Note that special-purpose widgets may contain special code for
             * rendering to the screen and might appear differently on screen
             * and when rendered using gtk_widget_draw().
             * @param cr a cairo context to draw to
             */
            draw(cr: cairo.Context): void;
            /**
             * Ensures that `widget` has a style (`widget->`style).
             *
             * Not a very useful function; most of the time, if you
             * want the style, the widget is realized, and realized
             * widgets are guaranteed to have a style already.
             */
            ensure_style(): void;
            /**
             * Notifies the user about an input-related error on this widget.
             * If the #GtkSettings:gtk-error-bell setting is %TRUE, it calls
             * gdk_window_beep(), otherwise it does nothing.
             *
             * Note that the effect of gdk_window_beep() can be configured in many
             * ways, depending on the windowing backend and the desktop environment
             * or window manager that is used.
             */
            error_bell(): void;
            /**
             * Rarely-used function. This function is used to emit
             * the event signals on a widget (those signals should never
             * be emitted without using this function to do so).
             * If you want to synthesize an event though, don’t use this function;
             * instead, use gtk_main_do_event() so the event will behave as if
             * it were in the event queue. Don’t synthesize expose events; instead,
             * use gdk_window_invalidate_rect() to invalidate a region of the
             * window.
             * @param event a #GdkEvent
             * @returns return from the event signal emission (%TRUE if               the event was handled)
             */
            event(event: Gdk.Event): boolean;
            /**
             * Stops emission of #GtkWidget::child-notify signals on `widget`. The
             * signals are queued until gtk_widget_thaw_child_notify() is called
             * on `widget`.
             *
             * This is the analogue of g_object_freeze_notify() for child properties.
             */
            freeze_child_notify(): void;
            /**
             * Returns the accessible object that describes the widget to an
             * assistive technology.
             *
             * If accessibility support is not available, this #AtkObject
             * instance may be a no-op. Likewise, if no class-specific #AtkObject
             * implementation is available for the widget instance in question,
             * it will inherit an #AtkObject implementation from the first ancestor
             * class for which such an implementation is defined.
             *
             * The documentation of the
             * [ATK](http://developer.gnome.org/atk/stable/)
             * library contains more information about accessible objects and their uses.
             * @returns the #AtkObject associated with @widget
             */
            get_accessible(): Atk.Object;
            /**
             * Retrieves the #GActionGroup that was registered using `prefix`. The resulting
             * #GActionGroup may have been registered to `widget` or any #GtkWidget in its
             * ancestry.
             *
             * If no action group was found matching `prefix,` then %NULL is returned.
             * @param prefix The “prefix” of the action group.
             * @returns A #GActionGroup or %NULL.
             */
            get_action_group(prefix: string): Gio.ActionGroup | null;
            /**
             * Returns the baseline that has currently been allocated to `widget`.
             * This function is intended to be used when implementing handlers
             * for the #GtkWidget::draw function, and when allocating child
             * widgets in #GtkWidget::size_allocate.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to `widget`.
             * This function is intended to be used when implementing handlers
             * for the #GtkWidget::draw function.
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Retrieves the widget’s allocated size.
             *
             * This function returns the last values passed to
             * gtk_widget_size_allocate_with_baseline(). The value differs from
             * the size returned in gtk_widget_get_allocation() in that functions
             * like gtk_widget_set_halign() can adjust the allocation, but not
             * the value returned by this function.
             *
             * If a widget is not visible, its allocated size is 0.
             */
            get_allocated_size(): [Allocation, number];
            /**
             * Returns the width that has currently been allocated to `widget`.
             * This function is intended to be used when implementing handlers
             * for the #GtkWidget::draw function.
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a #GtkContainer: a widget’s allocation will
             * be its “adjusted” allocation, that is, the widget’s parent
             * container typically calls gtk_widget_size_allocate() with an
             * allocation, and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * gtk_widget_get_allocation() returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * gtk_widget_size_allocate() allocation, however. So a #GtkContainer
             * is guaranteed that its children stay inside the assigned bounds,
             * but not that they have exactly the bounds the container assigned.
             * There is no way to get the original allocation assigned by
             * gtk_widget_size_allocate(), since it isn’t stored; if a container
             * implementation needs that information it will have to track it itself.
             */
            get_allocation(): Allocation;
            /**
             * Gets the first ancestor of `widget` with type `widget_type`. For example,
             * `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)` gets
             * the first #GtkBox that’s an ancestor of `widget`. No reference will be
             * added to the returned widget; it should not be unreferenced. See note
             * about checking for a toplevel #GtkWindow in the docs for
             * gtk_widget_get_toplevel().
             *
             * Note that unlike gtk_widget_is_ancestor(), gtk_widget_get_ancestor()
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget, or %NULL if not found
             */
            get_ancestor(widget_type: GObject.GType): Widget | null;
            /**
             * Determines whether the application intends to draw on the widget in
             * an #GtkWidget::draw handler.
             *
             * See gtk_widget_set_app_paintable()
             * @returns %TRUE if the widget is app paintable
             */
            get_app_paintable(): boolean;
            /**
             * Determines whether `widget` can be a default widget. See
             * gtk_widget_set_can_default().
             * @returns %TRUE if @widget can be a default widget, %FALSE otherwise
             */
            get_can_default(): boolean;
            /**
             * Determines whether `widget` can own the input focus. See
             * gtk_widget_set_can_focus().
             * @returns %TRUE if @widget can own the input focus, %FALSE otherwise
             */
            get_can_focus(): boolean;
            /**
             * This function is only for use in widget implementations. Obtains
             * `widget->`requisition, unless someone has forced a particular
             * geometry on the widget (e.g. with gtk_widget_set_size_request()),
             * in which case it returns that geometry instead of the widget's
             * requisition.
             *
             * This function differs from gtk_widget_size_request() in that
             * it retrieves the last size request value from `widget->`requisition,
             * while gtk_widget_size_request() actually calls the "size_request" method
             * on `widget` to compute the size request and fill in `widget->`requisition,
             * and only then returns `widget->`requisition.
             *
             * Because this function does not call the “size_request” method, it
             * can only be used when you know that `widget->`requisition is
             * up-to-date, that is, gtk_widget_size_request() has been called
             * since the last time a resize was queued. In general, only container
             * implementations have this information; applications should use
             * gtk_widget_size_request().
             */
            get_child_requisition(): Requisition;
            /**
             * Gets the value set with gtk_widget_set_child_visible().
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for container implementations and
             * never should be called by an application.
             * @returns %TRUE if the widget is mapped with the parent.
             */
            get_child_visible(): boolean;
            /**
             * Retrieves the widget’s clip area.
             *
             * The clip area is the area in which all of `widget'`s drawing will
             * happen. Other toolkits call it the bounding box.
             *
             * Historically, in GTK+ the clip area has been equal to the allocation
             * retrieved via gtk_widget_get_allocation().
             */
            get_clip(): Allocation;
            /**
             * Returns the clipboard object for the given selection to
             * be used with `widget`. `widget` must have a #GdkDisplay
             * associated with it, so must be attached to a toplevel
             * window.
             * @param selection a #GdkAtom which identifies the clipboard             to use. %GDK_SELECTION_CLIPBOARD gives the             default clipboard. Another common value             is %GDK_SELECTION_PRIMARY, which gives             the primary X selection.
             * @returns the appropriate clipboard object. If no             clipboard already exists, a new one will             be created. Once a clipboard object has             been created, it is persistent for all time.
             */
            get_clipboard(selection: Gdk.Atom): Clipboard;
            /**
             * Obtains the composite name of a widget.
             * @returns the composite name of @widget, or %NULL if @widget is not   a composite child. The string should be freed when it is no   longer needed.
             */
            get_composite_name(): string;
            /**
             * Returns whether `device` can interact with `widget` and its
             * children. See gtk_widget_set_device_enabled().
             * @param device a #GdkDevice
             * @returns %TRUE is @device is enabled for @widget
             */
            get_device_enabled(device: Gdk.Device): boolean;
            /**
             * Returns the events mask for the widget corresponding to an specific device. These
             * are the events that the widget will receive when `device` operates on it.
             * @param device a #GdkDevice
             * @returns device event mask for @widget
             */
            get_device_events(device: Gdk.Device): Gdk.EventMask;
            /**
             * Gets the reading direction for a particular widget. See
             * gtk_widget_set_direction().
             * @returns the reading direction for the widget.
             */
            get_direction(): TextDirection;
            /**
             * Get the #GdkDisplay for the toplevel window associated with
             * this widget. This function can only be called after the widget
             * has been added to a widget hierarchy with a #GtkWindow at the top.
             *
             * In general, you should only create display specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the #GdkDisplay for the toplevel for this widget.
             */
            get_display(): Gdk.Display;
            /**
             * Determines whether the widget is double buffered.
             *
             * See gtk_widget_set_double_buffered()
             * @returns %TRUE if the widget is double buffered
             */
            get_double_buffered(): boolean;
            /**
             * Returns the event mask (see #GdkEventMask) for the widget. These are the
             * events that the widget will receive.
             *
             * Note: Internally, the widget event mask will be the logical OR of the event
             * mask set through gtk_widget_set_events() or gtk_widget_add_events(), and the
             * event mask necessary to cater for every #GtkEventController created for the
             * widget.
             * @returns event mask for @widget
             */
            get_events(): number;
            /**
             * Returns whether the widget should grab focus when it is clicked with the mouse.
             * See gtk_widget_set_focus_on_click().
             * @returns %TRUE if the widget should grab focus when it is clicked with               the mouse.
             */
            get_focus_on_click(): boolean;
            /**
             * Gets the font map that has been set with gtk_widget_set_font_map().
             * @returns A #PangoFontMap, or %NULL
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the #cairo_font_options_t used for Pango rendering. When not set,
             * the defaults font options for the #GdkScreen will be used.
             * @returns the #cairo_font_options_t or %NULL if not set
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget. The frame clock is a global
             * “ticker” that can be used to drive animations and repaints.  The
             * most common reason to get the frame clock is to call
             * gdk_frame_clock_get_frame_time(), in order to get a time to use for
             * animating. For example you might record the start of the animation
             * with an initial value from gdk_frame_clock_get_frame_time(), and
             * then update the animation by calling
             * gdk_frame_clock_get_frame_time() again during each repaint.
             *
             * gdk_frame_clock_request_phase() will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a
             * widget, you have to use gtk_widget_queue_draw() which invalidates
             * the widget (thus scheduling it to receive a draw on the next
             * frame). gtk_widget_queue_draw() will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is
             * mapped. Reparenting a widget (which implies a temporary unmap) can
             * change the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns a #GdkFrameClock, or %NULL if widget is unrealized
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the value of the #GtkWidget:halign property.
             *
             * For backwards compatibility reasons this method will never return
             * %GTK_ALIGN_BASELINE, but instead it will convert it to
             * %GTK_ALIGN_FILL. Baselines are not supported for horizontal
             * alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Align;
            /**
             * Returns the current value of the has-tooltip property.  See
             * #GtkWidget:has-tooltip for more information.
             * @returns current value of has-tooltip on @widget.
             */
            get_has_tooltip(): boolean;
            /**
             * Determines whether `widget` has a #GdkWindow of its own. See
             * gtk_widget_set_has_window().
             * @returns %TRUE if @widget has a window, %FALSE otherwise
             */
            get_has_window(): boolean;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space. When a user resizes a #GtkWindow, widgets with expand=TRUE
             * generally receive the extra space. For example, a list or
             * scrollable area or document in your window would often be set to
             * expand.
             *
             * Containers should use gtk_widget_compute_expand() rather than
             * this function, to see whether a widget, or any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether gtk_widget_set_hexpand() has been used to
             * explicitly set the expand flag on this widget.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Whether the widget is mapped.
             * @returns %TRUE if the widget is mapped, %FALSE otherwise.
             */
            get_mapped(): boolean;
            /**
             * Gets the value of the #GtkWidget:margin-bottom property.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the value of the #GtkWidget:margin-end property.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the value of the #GtkWidget:margin-left property.
             * @returns The left margin of @widget
             */
            get_margin_left(): number;
            /**
             * Gets the value of the #GtkWidget:margin-right property.
             * @returns The right margin of @widget
             */
            get_margin_right(): number;
            /**
             * Gets the value of the #GtkWidget:margin-start property.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the value of the #GtkWidget:margin-top property.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Returns the modifier mask the `widget’`s windowing system backend
             * uses for a particular purpose.
             *
             * See gdk_keymap_get_modifier_mask().
             * @param intent the use case for the modifier mask
             * @returns the modifier mask used for @intent.
             */
            get_modifier_mask(intent: Gdk.ModifierIntent | null): Gdk.ModifierType;
            /**
             * Returns the current modifier style for the widget. (As set by
             * gtk_widget_modify_style().) If no style has previously set, a new
             * #GtkRcStyle will be created with all values unset, and set as the
             * modifier style for the widget. If you make changes to this rc
             * style, you must call gtk_widget_modify_style(), passing in the
             * returned rc style, to make sure that your changes take effect.
             *
             * Caution: passing the style back to gtk_widget_modify_style() will
             * normally end up destroying it, because gtk_widget_modify_style() copies
             * the passed-in style and sets the copy as the new modifier style,
             * thus dropping any reference to the old modifier style. Add a reference
             * to the modifier style if you want to keep it alive.
             * @returns the modifier style for the widget.     This rc style is owned by the widget. If you want to keep a     pointer to value this around, you must add a refcount using     g_object_ref().
             */
            get_modifier_style(): RcStyle;
            /**
             * Retrieves the name of a widget. See gtk_widget_set_name() for the
             * significance of widget names.
             * @returns name of the widget. This string is owned by GTK+ and should not be modified or freed
             */
            get_name(): string;
            /**
             * Returns the current value of the #GtkWidget:no-show-all property,
             * which determines whether calls to gtk_widget_show_all()
             * will affect this widget.
             * @returns the current value of the “no-show-all” property.
             */
            get_no_show_all(): boolean;
            /**
             * Fetches the requested opacity for this widget.
             * See gtk_widget_set_opacity().
             * @returns the requested opacity for this widget.
             */
            get_opacity(): number;
            /**
             * Gets a #PangoContext with the appropriate font map, font description,
             * and base direction for this widget. Unlike the context returned
             * by gtk_widget_create_pango_context(), this context is owned by
             * the widget (it can be used until the screen for the widget changes
             * or the widget is removed from its toplevel), and will be updated to
             * match any changes to the widget’s attributes. This can be tracked
             * by using the #GtkWidget::screen-changed signal on the widget.
             * @returns the #PangoContext for the widget.
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent container of `widget`.
             * @returns the parent container of @widget, or %NULL
             */
            get_parent(): Widget | null;
            /**
             * Gets `widget’`s parent window, or %NULL if it does not have one.
             * @returns the parent window of @widget, or %NULL if it does not have a parent window.
             */
            get_parent_window(): Gdk.Window | null;
            /**
             * Returns the #GtkWidgetPath representing `widget,` if the widget
             * is not connected to a toplevel widget, a partial path will be
             * created.
             * @returns The #GtkWidgetPath representing @widget
             */
            get_path(): WidgetPath;
            /**
             * Obtains the location of the mouse pointer in widget coordinates.
             * Widget coordinates are a bit odd; for historical reasons, they are
             * defined as `widget->`window coordinates for widgets that return %TRUE for
             * gtk_widget_get_has_window(); and are relative to `widget->`allocation.x,
             * `widget->`allocation.y otherwise.
             */
            get_pointer(): [number, number];
            /**
             * Retrieves a widget’s initial minimum and natural height.
             *
             * This call is specific to width-for-height requests.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             */
            get_preferred_height(): [number, number];
            /**
             * Retrieves a widget’s minimum and natural height and the corresponding baselines if it would be given
             * the specified `width,` or the default height if `width` is -1. The baselines may be -1 which means
             * that no baseline is requested for this widget.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request and GtkWidgetClass::adjust_baseline_request virtual methods
             * and by any #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param width the width which is available for allocation, or -1 if none
             */
            get_preferred_height_and_baseline_for_width(width: number): [number, number, number, number];
            /**
             * Retrieves a widget’s minimum and natural height if it would be given
             * the specified `width`.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param width the width which is available for allocation
             */
            get_preferred_height_for_width(width: number): [number, number];
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as GtkLayout.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since the required
             * height for the natural width is generally smaller than the required height for
             * the minimum width.
             *
             * Use gtk_widget_get_preferred_height_and_baseline_for_width() if you want to support
             * baseline alignment.
             */
            get_preferred_size(): [Requisition | null, Requisition | null];
            /**
             * Retrieves a widget’s initial minimum and natural width.
             *
             * This call is specific to height-for-width requests.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             */
            get_preferred_width(): [number, number];
            /**
             * Retrieves a widget’s minimum and natural width if it would be given
             * the specified `height`.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param height the height which is available for allocation
             */
            get_preferred_width_for_height(height: number): [number, number];
            /**
             * Determines whether `widget` is realized.
             * @returns %TRUE if @widget is realized, %FALSE otherwise
             */
            get_realized(): boolean;
            /**
             * Determines whether `widget` is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See gtk_widget_set_receives_default().
             * @returns %TRUE if @widget acts as the default widget when focused,               %FALSE otherwise
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * #GtkBin widgets generally propagate the preference of
             * their child, container widgets need to request something either in
             * context of their children or in context of their allocation
             * capabilities.
             * @returns The #GtkSizeRequestMode preferred by @widget.
             */
            get_request_mode(): SizeRequestMode;
            /**
             * Retrieves the widget’s requisition.
             *
             * This function should only be used by widget implementations in
             * order to figure whether the widget’s requisition has actually
             * changed after some internal state change (so that they can call
             * gtk_widget_queue_resize() instead of gtk_widget_queue_draw()).
             *
             * Normally, gtk_widget_size_request() should be used.
             */
            get_requisition(): Requisition;
            /**
             * Get the root window where this widget is located. This function can
             * only be called after the widget has been added to a widget
             * hierarchy with #GtkWindow at the top.
             *
             * The root window is useful for such purposes as creating a popup
             * #GdkWindow associated with the window. In general, you should only
             * create display specific resources when a widget has been realized,
             * and you should free those resources when the widget is unrealized.
             * @returns the #GdkWindow root window for the toplevel for this widget.
             */
            get_root_window(): Gdk.Window;
            /**
             * Retrieves the internal scale factor that maps from window coordinates
             * to the actual device pixels. On traditional systems this is 1, on
             * high density outputs, it can be a higher value (typically 2).
             *
             * See gdk_window_get_scale_factor().
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Get the #GdkScreen from the toplevel window associated with
             * this widget. This function can only be called after the widget
             * has been added to a widget hierarchy with a #GtkWindow
             * at the top.
             *
             * In general, you should only create screen specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the #GdkScreen for the toplevel for this widget.
             */
            get_screen(): Gdk.Screen;
            /**
             * Returns the widget’s sensitivity (in the sense of returning
             * the value that has been set using gtk_widget_set_sensitive()).
             *
             * The effective sensitivity of a widget is however determined by both its
             * own and its parent widget’s sensitivity. See gtk_widget_is_sensitive().
             * @returns %TRUE if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for this widget.
             *
             * Note that this function can only be called when the #GtkWidget
             * is attached to a toplevel, since the settings object is specific
             * to a particular #GdkScreen.
             * @returns the relevant #GtkSettings object
             */
            get_settings(): Settings;
            /**
             * Gets the size request that was explicitly set for the widget using
             * gtk_widget_set_size_request(). A value of -1 stored in `width` or
             * `height` indicates that that dimension has not been set explicitly
             * and the natural requisition of the widget will be used instead. See
             * gtk_widget_set_size_request(). To get the size a widget will
             * actually request, call gtk_widget_get_preferred_size() instead of
             * this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget’s state. See gtk_widget_set_state().
             * @returns the state of @widget.
             */
            get_state(): StateType;
            /**
             * Returns the widget state as a flag set. It is worth mentioning
             * that the effective %GTK_STATE_FLAG_INSENSITIVE state will be
             * returned, that is, also based on parent insensitivity, even if
             * `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * #GtkStateFlags to pass to a #GtkStyleContext method, you
             * should look at gtk_style_context_get_state().
             * @returns The state flags for widget
             */
            get_state_flags(): StateFlags;
            /**
             * Simply an accessor function that returns `widget->`style.
             * @returns the widget’s #GtkStyle
             */
            get_style(): Style;
            /**
             * Returns the style context associated to `widget`. The returned object is
             * guaranteed to be the same for the lifetime of `widget`.
             * @returns a #GtkStyleContext. This memory is owned by @widget and          must not be freed.
             */
            get_style_context(): StyleContext;
            /**
             * Returns %TRUE if `widget` is multiple pointer aware. See
             * gtk_widget_set_support_multidevice() for more information.
             * @returns %TRUE if @widget is multidevice aware.
             */
            get_support_multidevice(): boolean;
            /**
             * Fetch an object build from the template XML for `widget_type` in this `widget` instance.
             *
             * This will only report children which were previously declared with
             * gtk_widget_class_bind_template_child_full() or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private to the `widget_type` which
             * declared the child and is meant for language bindings which cannot easily make use
             * of the GObject structure offsets.
             * @param widget_type The #GType to get a template child for
             * @param name The “id” of the child defined in the template XML
             * @returns The object built in the template XML with the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for `widget`.
             * @returns the tooltip text, or %NULL. You should free the   returned string with g_free() when done.
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for `widget`.
             * @returns the tooltip text, or %NULL. You should free the   returned string with g_free() when done.
             */
            get_tooltip_text(): string | null;
            /**
             * Returns the #GtkWindow of the current tooltip. This can be the
             * GtkWindow created by default, or the custom tooltip window set
             * using gtk_widget_set_tooltip_window().
             * @returns The #GtkWindow of the current tooltip.
             */
            get_tooltip_window(): Window;
            /**
             * This function returns the topmost widget in the container hierarchy
             * `widget` is a part of. If `widget` has no parent widgets, it will be
             * returned as the topmost widget. No reference will be added to the
             * returned widget; it should not be unreferenced.
             *
             * Note the difference in behavior vs. gtk_widget_get_ancestor();
             * `gtk_widget_get_ancestor (widget, GTK_TYPE_WINDOW)`
             * would return
             * %NULL if `widget` wasn’t inside a toplevel window, and if the
             * window was inside a #GtkWindow-derived widget which was in turn
             * inside the toplevel #GtkWindow. While the second case may
             * seem unlikely, it actually happens when a #GtkPlug is embedded
             * inside a #GtkSocket within the same application.
             *
             * To reliably find the toplevel #GtkWindow, use
             * gtk_widget_get_toplevel() and call GTK_IS_WINDOW()
             * on the result. For instance, to get the title of a widget's toplevel
             * window, one might use:
             *
             * ```c
             * static const char *
             * get_widget_toplevel_title (GtkWidget *widget)
             * {
             *   GtkWidget *toplevel = gtk_widget_get_toplevel (widget);
             *   if (GTK_IS_WINDOW (toplevel))
             *     {
             *       return gtk_window_get_title (GTK_WINDOW (toplevel));
             *     }
             *
             *   return NULL;
             * }
             * ```
             *
             * @returns the topmost ancestor of @widget, or @widget itself    if there’s no ancestor.
             */
            get_toplevel(): Widget;
            /**
             * Gets the value of the #GtkWidget:valign property.
             *
             * For backwards compatibility reasons this method will never return
             * %GTK_ALIGN_BASELINE, but instead it will convert it to
             * %GTK_ALIGN_FILL. If your widget want to support baseline aligned
             * children it must use gtk_widget_get_valign_with_baseline(), or
             * `g_object_get (widget, "valign", &value, NULL)`, which will
             * also report the true value.
             * @returns the vertical alignment of @widget, ignoring baseline alignment
             */
            get_valign(): Align;
            /**
             * Gets the value of the #GtkWidget:valign property, including
             * %GTK_ALIGN_BASELINE.
             * @returns the vertical alignment of @widget
             */
            get_valign_with_baseline(): Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See gtk_widget_get_hexpand() for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether gtk_widget_set_vexpand() has been used to
             * explicitly set the expand flag on this widget.
             *
             * See gtk_widget_get_hexpand_set() for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible. If you want to
             * take into account whether the widget’s parent is also marked as
             * visible, use gtk_widget_is_visible() instead.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See gtk_widget_set_visible().
             * @returns %TRUE if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Gets the visual that will be used to render `widget`.
             * @returns the visual for @widget
             */
            get_visual(): Gdk.Visual;
            /**
             * Returns the widget’s window if it is realized, %NULL otherwise
             * @returns @widget’s window.
             */
            get_window(): Gdk.Window | null;
            /**
             * Makes `widget` the current grabbed widget.
             *
             * This means that interaction with other widgets in the same
             * application is blocked and mouse as well as keyboard events
             * are delivered to this widget.
             *
             * If `widget` is not sensitive, it is not set as the current
             * grabbed widget and this function does nothing.
             */
            grab_add(): void;
            /**
             * Causes `widget` to become the default widget. `widget` must be able to be
             * a default widget; typically you would ensure this yourself
             * by calling gtk_widget_set_can_default() with a %TRUE value.
             * The default widget is activated when
             * the user presses Enter in a window. Default widgets must be
             * activatable, that is, gtk_widget_activate() should affect them. Note
             * that #GtkEntry widgets require the “activates-default” property
             * set to %TRUE before they activate the default widget when Enter
             * is pressed and the #GtkEntry is focused.
             */
            grab_default(): void;
            /**
             * Causes `widget` to have the keyboard focus for the #GtkWindow it's
             * inside. `widget` must be a focusable widget, such as a #GtkEntry;
             * something like #GtkFrame won’t work.
             *
             * More precisely, it must have the %GTK_CAN_FOCUS flag set. Use
             * gtk_widget_set_can_focus() to modify that flag.
             *
             * The widget also needs to be realized and mapped. This is indicated by the
             * related signals. Grabbing the focus immediately after creating the widget
             * will likely fail and cause critical warnings.
             */
            grab_focus(): void;
            /**
             * Removes the grab from the given widget.
             *
             * You have to pair calls to gtk_grab_add() and gtk_grab_remove().
             *
             * If `widget` does not have the grab, this function does nothing.
             */
            grab_remove(): void;
            /**
             * Determines whether the widget is currently grabbing events, so it
             * is the only widget receiving input events (keyboard and mouse).
             *
             * See also gtk_grab_add().
             * @returns %TRUE if the widget is in the grab_widgets stack
             */
            has_grab(): boolean;
            /**
             * Determines if the widget style has been looked up through the rc mechanism.
             * @returns %TRUE if the widget has been looked up through the rc   mechanism, %FALSE otherwise.
             */
            has_rc_style(): boolean;
            /**
             * Checks whether there is a #GdkScreen is associated with
             * this widget. All toplevel widgets have an associated
             * screen, and all widgets added into a hierarchy with a toplevel
             * window at the top.
             * @returns %TRUE if there is a #GdkScreen associated   with the widget.
             */
            has_screen(): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus. This is a convenience function for
             * use in ::draw handlers that takes into account whether focus
             * indication should currently be shown in the toplevel window of
             * `widget`. See gtk_window_get_focus_visible() for more information
             * about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * gtk_widget_has_focus().
             * @returns %TRUE if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of gtk_widget_show(), causing the widget to be
             * hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Utility function; intended to be connected to the #GtkWidget::delete-event
             * signal on a #GtkWindow. The function calls gtk_widget_hide() on its
             * argument, then returns %TRUE. If connected to ::delete-event, the
             * result is that clicking the close button for a window (on the
             * window frame, top right corner usually) will hide but not destroy
             * the window. By default, GTK+ destroys windows when ::delete-event
             * is received.
             * @returns %TRUE
             */
            hide_on_delete(): boolean;
            /**
             * Returns whether the widget is currently being destroyed.
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns %TRUE if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates. This
             * function must be called in the instance initializer for any
             * class which assigned itself a template using gtk_widget_class_set_template()
             *
             * It is important to call this function in the instance initializer
             * of a #GtkWidget subclass and not in #GObject.constructed() or
             * #GObject.constructor() for two reasons.
             *
             * One reason is that generally derived widgets will assume that parent
             * class composite widgets have been created in their instance
             * initializers.
             *
             * Another reason is that when calling g_object_new() on a widget with
             * composite templates, it’s important to build the composite widgets
             * before the construct properties are set. Properties passed to g_object_new()
             * should take precedence over properties set in the private template XML.
             */
            init_template(): void;
            /**
             * Sets an input shape for this widget’s GDK window. This allows for
             * windows which react to mouse click in a nonrectangular region, see
             * gdk_window_input_shape_combine_region() for more information.
             * @param region shape to be added, or %NULL to remove an existing shape
             */
            input_shape_combine_region(region?: cairo.Region | null): void;
            /**
             * Inserts `group` into `widget`. Children of `widget` that implement
             * #GtkActionable can then be associated with actions in `group` by
             * setting their “action-name” to
             * `prefix`.`action-name`.
             *
             * If `group` is %NULL, a previously inserted group for `name` is removed
             * from `widget`.
             * @param name the prefix for actions in @group
             * @param group a #GActionGroup, or %NULL
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Computes the intersection of a `widget’`s area and `area,` storing
             * the intersection in `intersection,` and returns %TRUE if there was
             * an intersection.  `intersection` may be %NULL if you’re only
             * interested in whether there was an intersection.
             * @param area a rectangle
             * @returns %TRUE if there was an intersection
             */
            intersect(area: Gdk.Rectangle): [boolean, Gdk.Rectangle | null];
            /**
             * Determines whether `widget` is somewhere inside `ancestor,` possibly with
             * intermediate containers.
             * @param ancestor another #GtkWidget
             * @returns %TRUE if @ancestor contains @widget as a child,    grandchild, great grandchild, etc.
             */
            is_ancestor(ancestor: Widget): boolean;
            /**
             * Whether `widget` can rely on having its alpha channel
             * drawn correctly. On X11 this function returns whether a
             * compositing manager is running for `widget’`s screen.
             *
             * Please note that the semantics of this call will change
             * in the future if used on a widget that has a composited
             * window in its hierarchy (as set by gdk_window_set_composited()).
             * @returns %TRUE if the widget can rely on its alpha channel being drawn correctly.
             */
            is_composited(): boolean;
            /**
             * Determines whether `widget` can be drawn to. A widget can be drawn
             * to if it is mapped and visible.
             * @returns %TRUE if @widget is drawable, %FALSE otherwise
             */
            is_drawable(): boolean;
            /**
             * Returns the widget’s effective sensitivity, which means
             * it is sensitive itself and also its parent widget is sensitive
             * @returns %TRUE if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether `widget` is a toplevel widget.
             *
             * Currently only #GtkWindow and #GtkInvisible (and out-of-process
             * #GtkPlugs) are toplevel widgets. Toplevel widgets have no parent
             * widget.
             * @returns %TRUE if @widget is a toplevel, %FALSE otherwise
             */
            is_toplevel(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also gtk_widget_get_visible() and gtk_widget_set_visible()
             * @returns %TRUE if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * This function should be called whenever keyboard navigation within
             * a single widget hits a boundary. The function emits the
             * #GtkWidget::keynav-failed signal on the widget and its return
             * value should be interpreted in a way similar to the return value of
             * gtk_widget_child_focus():
             *
             * When %TRUE is returned, stay in the widget, the failed keyboard
             * navigation is OK and/or there is nowhere we can/should move the
             * focus to.
             *
             * When %FALSE is returned, the caller should continue with keyboard
             * navigation outside the widget, e.g. by calling
             * gtk_widget_child_focus() on the widget’s toplevel.
             *
             * The default ::keynav-failed handler returns %FALSE for
             * %GTK_DIR_TAB_FORWARD and %GTK_DIR_TAB_BACKWARD. For the other
             * values of #GtkDirectionType it returns %TRUE.
             *
             * Whenever the default handler returns %TRUE, it also calls
             * gtk_widget_error_bell() to notify the user of the failed keyboard
             * navigation.
             *
             * A use case for providing an own implementation of ::keynav-failed
             * (either by connecting to it or by overriding it) would be a row of
             * #GtkEntry widgets where the user should be able to navigate the
             * entire row with the cursor keys, as e.g. known from user interfaces
             * that require entering license keys.
             * @param direction direction of focus movement
             * @returns %TRUE if stopping keyboard navigation is fine, %FALSE               if the emitting widget should try to handle the keyboard               navigation attempt in its parent container(s).
             */
            keynav_failed(direction: DirectionType | null): boolean;
            /**
             * Lists the closures used by `widget` for accelerator group connections
             * with gtk_accel_group_connect_by_path() or gtk_accel_group_connect().
             * The closures can be used to monitor accelerator changes on `widget,`
             * by connecting to the `GtkAccelGroup:`:accel-changed signal of the
             * #GtkAccelGroup of a closure which can be found out with
             * gtk_accel_group_from_accel_closure().
             * @returns a newly allocated #GList of closures
             */
            list_accel_closures(): GObject.Closure[];
            /**
             * Retrieves a %NULL-terminated array of strings containing the prefixes of
             * #GActionGroup's available to `widget`.
             * @returns a %NULL-terminated array of strings.
             */
            list_action_prefixes(): string[];
            /**
             * Returns a newly allocated list of the widgets, normally labels, for
             * which this widget is the target of a mnemonic (see for example,
             * gtk_label_set_mnemonic_widget()).
             *
             * The widgets in the list are not individually referenced. If you
             * want to iterate through the list and perform actions involving
             * callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result,
             * (GFunc)g_object_ref, NULL)` first, and then unref all the
             * widgets afterwards.
             * @returns the list of  mnemonic labels; free this list  with g_list_free() when you are done with it.
             */
            list_mnemonic_labels(): Widget[];
            /**
             * This function is only for use in widget implementations. Causes
             * a widget to be mapped if it isn’t already.
             */
            map(): void;
            /**
             * Emits the #GtkWidget::mnemonic-activate signal.
             * @param group_cycling %TRUE if there are other widgets with the same mnemonic
             * @returns %TRUE if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Sets the base color for a widget in a particular state.
             * All other style values are left untouched. The base color
             * is the background color used along with the text color
             * (see gtk_widget_modify_text()) for widgets such as #GtkEntry
             * and #GtkTextView. See also gtk_widget_modify_style().
             *
             * > Note that “no window” widgets (which have the %GTK_NO_WINDOW
             * > flag set) draw on their parent container’s window and thus may
             * > not draw any background themselves. This is the case for e.g.
             * > #GtkLabel.
             * >
             * > To modify the background of such widgets, you have to set the
             * > base color on their parent; if you want to set the background
             * > of a rectangular area around a label, try placing the label in
             * > a #GtkEventBox widget and setting the base color on that.
             * @param state the state for which to set the base color
             * @param color the color to assign (does not need to     be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_base().
             */
            modify_base(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the background color for a widget in a particular state.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             *
             * > Note that “no window” widgets (which have the %GTK_NO_WINDOW
             * > flag set) draw on their parent container’s window and thus may
             * > not draw any background themselves. This is the case for e.g.
             * > #GtkLabel.
             * >
             * > To modify the background of such widgets, you have to set the
             * > background color on their parent; if you want to set the background
             * > of a rectangular area around a label, try placing the label in
             * > a #GtkEventBox widget and setting the background color on that.
             * @param state the state for which to set the background color
             * @param color the color to assign (does not need     to be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_bg().
             */
            modify_bg(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the cursor color to use in a widget, overriding the #GtkWidget
             * cursor-color and secondary-cursor-color
             * style properties.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             * @param primary the color to use for primary cursor (does not     need to be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_cursor().
             * @param secondary the color to use for secondary cursor (does     not need to be allocated), or %NULL to undo the effect of     previous calls to of gtk_widget_modify_cursor().
             */
            modify_cursor(primary?: Gdk.Color | null, secondary?: Gdk.Color | null): void;
            /**
             * Sets the foreground color for a widget in a particular state.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             * @param state the state for which to set the foreground color
             * @param color the color to assign (does not need to be allocated),     or %NULL to undo the effect of previous calls to     of gtk_widget_modify_fg().
             */
            modify_fg(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the font to use for a widget.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             * @param font_desc the font description to use, or %NULL     to undo the effect of previous calls to gtk_widget_modify_font()
             */
            modify_font(font_desc?: Pango.FontDescription | null): void;
            /**
             * Modifies style values on the widget.
             *
             * Modifications made using this technique take precedence over
             * style values set via an RC file, however, they will be overridden
             * if a style is explicitly set on the widget using gtk_widget_set_style().
             * The #GtkRcStyle-struct is designed so each field can either be
             * set or unset, so it is possible, using this function, to modify some
             * style values and leave the others unchanged.
             *
             * Note that modifications made with this function are not cumulative
             * with previous calls to gtk_widget_modify_style() or with such
             * functions as gtk_widget_modify_fg(). If you wish to retain
             * previous values, you must first call gtk_widget_get_modifier_style(),
             * make your modifications to the returned style, then call
             * gtk_widget_modify_style() with that style. On the other hand,
             * if you first call gtk_widget_modify_style(), subsequent calls
             * to such functions gtk_widget_modify_fg() will have a cumulative
             * effect with the initial modifications.
             * @param style the #GtkRcStyle-struct holding the style modifications
             */
            modify_style(style: RcStyle): void;
            /**
             * Sets the text color for a widget in a particular state.
             *
             * All other style values are left untouched.
             * The text color is the foreground color used along with the
             * base color (see gtk_widget_modify_base()) for widgets such
             * as #GtkEntry and #GtkTextView.
             * See also gtk_widget_modify_style().
             * @param state the state for which to set the text color
             * @param color the color to assign (does not need to     be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_text().
             */
            modify_text(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the background color to use for a widget.
             *
             * All other style values are left untouched.
             * See gtk_widget_override_color().
             * @param state the state for which to set the background color
             * @param color the color to assign, or %NULL to undo the effect     of previous calls to gtk_widget_override_background_color()
             */
            override_background_color(state: StateFlags | null, color?: Gdk.RGBA | null): void;
            /**
             * Sets the color to use for a widget.
             *
             * All other style values are left untouched.
             *
             * This function does not act recursively. Setting the color of a
             * container does not affect its children. Note that some widgets that
             * you may not think of as containers, for instance #GtkButtons,
             * are actually containers.
             *
             * This API is mostly meant as a quick way for applications to
             * change a widget appearance. If you are developing a widgets
             * library and intend this change to be themeable, it is better
             * done by setting meaningful CSS classes in your
             * widget/container implementation through gtk_style_context_add_class().
             *
             * This way, your widget library can install a #GtkCssProvider
             * with the %GTK_STYLE_PROVIDER_PRIORITY_FALLBACK priority in order
             * to provide a default styling for those widgets that need so, and
             * this theming may fully overridden by the user’s theme.
             *
             * Note that for complex widgets this may bring in undesired
             * results (such as uniform background color everywhere), in
             * these cases it is better to fully style such widgets through a
             * #GtkCssProvider with the %GTK_STYLE_PROVIDER_PRIORITY_APPLICATION
             * priority.
             * @param state the state for which to set the color
             * @param color the color to assign, or %NULL to undo the effect     of previous calls to gtk_widget_override_color()
             */
            override_color(state: StateFlags | null, color?: Gdk.RGBA | null): void;
            /**
             * Sets the cursor color to use in a widget, overriding the
             * cursor-color and secondary-cursor-color
             * style properties. All other style values are left untouched.
             * See also gtk_widget_modify_style().
             *
             * Note that the underlying properties have the #GdkColor type,
             * so the alpha value in `primary` and `secondary` will be ignored.
             * @param cursor the color to use for primary cursor (does not need to be     allocated), or %NULL to undo the effect of previous calls to     of gtk_widget_override_cursor().
             * @param secondary_cursor the color to use for secondary cursor (does not     need to be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_override_cursor().
             */
            override_cursor(cursor?: Gdk.RGBA | null, secondary_cursor?: Gdk.RGBA | null): void;
            /**
             * Sets the font to use for a widget. All other style values are
             * left untouched. See gtk_widget_override_color().
             * @param font_desc the font description to use, or %NULL to undo     the effect of previous calls to gtk_widget_override_font()
             */
            override_font(font_desc?: Pango.FontDescription | null): void;
            /**
             * Sets a symbolic color for a widget.
             *
             * All other style values are left untouched.
             * See gtk_widget_override_color() for overriding the foreground
             * or background color.
             * @param name the name of the symbolic color to modify
             * @param color the color to assign (does not need     to be allocated), or %NULL to undo the effect of previous     calls to gtk_widget_override_symbolic_color()
             */
            override_symbolic_color(name: string, color?: Gdk.RGBA | null): void;
            /**
             * Obtains the full path to `widget`. The path is simply the name of a
             * widget and all its parents in the container hierarchy, separated by
             * periods. The name of a widget comes from
             * gtk_widget_get_name(). Paths are used to apply styles to a widget
             * in gtkrc configuration files. Widget names are the type of the
             * widget by default (e.g. “GtkButton”) or can be set to an
             * application-specific value with gtk_widget_set_name(). By setting
             * the name of a widget, you allow users or theme authors to apply
             * styles to that specific widget in their gtkrc
             * file. `path_reversed_p` fills in the path in reverse order,
             * i.e. starting with `widget’`s name instead of starting with the name
             * of `widget’`s outermost ancestor.
             */
            path(): [number, string, string];
            /**
             * This function is only for use in widget implementations.
             *
             * Flags the widget for a rerun of the GtkWidgetClass::size_allocate
             * function. Use this function instead of gtk_widget_queue_resize()
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is gtk_widget_set_halign().
             */
            queue_allocate(): void;
            /**
             * Mark `widget` as needing to recompute its expand flags. Call
             * this function when setting legacy expand child properties
             * on the child of a container.
             *
             * See gtk_widget_compute_expand().
             */
            queue_compute_expand(): void;
            /**
             * Equivalent to calling gtk_widget_queue_draw_area() for the
             * entire area of a widget.
             */
            queue_draw(): void;
            /**
             * Convenience function that calls gtk_widget_queue_draw_region() on
             * the region created from the given coordinates.
             *
             * The region here is specified in widget coordinates.
             * Widget coordinates are a bit odd; for historical reasons, they are
             * defined as `widget->`window coordinates for widgets that return %TRUE for
             * gtk_widget_get_has_window(), and are relative to `widget->`allocation.x,
             * `widget->`allocation.y otherwise.
             *
             * `width` or `height` may be 0, in this case this function does
             * nothing. Negative values for `width` and `height` are not allowed.
             * @param x x coordinate of upper-left corner of rectangle to redraw
             * @param y y coordinate of upper-left corner of rectangle to redraw
             * @param width width of region to draw
             * @param height height of region to draw
             */
            queue_draw_area(x: number, y: number, width: number, height: number): void;
            /**
             * Invalidates the area of `widget` defined by `region` by calling
             * gdk_window_invalidate_region() on the widget’s window and all its
             * child windows. Once the main loop becomes idle (after the current
             * batch of events has been processed, roughly), the window will
             * receive expose events for the union of all regions that have been
             * invalidated.
             *
             * Normally you would only use this function in widget
             * implementations. You might also use it to schedule a redraw of a
             * #GtkDrawingArea or some portion thereof.
             * @param region region to draw
             */
            queue_draw_region(region: cairo.Region): void;
            /**
             * This function is only for use in widget implementations.
             * Flags a widget to have its size renegotiated; should
             * be called when a widget for some reason has a new size request.
             * For example, when you change the text in a #GtkLabel, #GtkLabel
             * queues a resize to ensure there’s enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the GtkWidgetClass::size_allocate
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * GtkWidgetClass::size_allocate will be silently ignored.
             */
            queue_resize(): void;
            /**
             * This function works like gtk_widget_queue_resize(),
             * except that the widget is not invalidated.
             */
            queue_resize_no_redraw(): void;
            /**
             * Creates the GDK (windowing system) resources associated with a
             * widget.  For example, `widget->`window will be created when a widget
             * is realized.  Normally realization happens implicitly; if you show
             * a widget and all its parent containers, then the widget will be
             * realized and mapped automatically.
             *
             * Realizing a widget requires all
             * the widget’s parent widgets to be realized; calling
             * gtk_widget_realize() realizes the widget’s parents in addition to
             * `widget` itself. If a widget is not yet inside a toplevel window
             * when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * #GtkWidget::draw. Or simply g_signal_connect () to the
             * #GtkWidget::realize signal.
             */
            realize(): void;
            /**
             * Computes the intersection of a `widget’`s area and `region,` returning
             * the intersection. The result may be empty, use cairo_region_is_empty() to
             * check.
             * @param region a #cairo_region_t, in the same coordinate system as          @widget->allocation. That is, relative to @widget->window          for widgets which return %FALSE from gtk_widget_get_has_window();          relative to the parent window of @widget->window otherwise.
             * @returns A newly allocated region holding the intersection of @widget     and @region.
             */
            region_intersect(region: cairo.Region): cairo.Region;
            /**
             * Registers a #GdkWindow with the widget and sets it up so that
             * the widget receives events for it. Call gtk_widget_unregister_window()
             * when destroying the window.
             *
             * Before 3.8 you needed to call gdk_window_set_user_data() directly to set
             * this up. This is now deprecated and you should use gtk_widget_register_window()
             * instead. Old code will keep working as is, although some new features like
             * transparency might not work perfectly.
             * @param window a #GdkWindow
             */
            register_window(window: Gdk.Window): void;
            /**
             * Removes an accelerator from `widget,` previously installed with
             * gtk_widget_add_accelerator().
             * @param accel_group accel group for this widget
             * @param accel_key GDK keyval of the accelerator
             * @param accel_mods modifier key combination of the accelerator
             * @returns whether an accelerator was installed and could be removed
             */
            remove_accelerator(
                accel_group: AccelGroup,
                accel_key: number,
                accel_mods: Gdk.ModifierType | null,
            ): boolean;
            /**
             * Removes a widget from the list of mnemonic labels for
             * this widget. (See gtk_widget_list_mnemonic_labels()). The widget
             * must have previously been added to the list with
             * gtk_widget_add_mnemonic_label().
             * @param label a #GtkWidget that was previously set as a mnemonic label for         @widget with gtk_widget_add_mnemonic_label().
             */
            remove_mnemonic_label(label: Widget): void;
            /**
             * Removes a tick callback previously registered with
             * gtk_widget_add_tick_callback().
             * @param id an id returned by gtk_widget_add_tick_callback()
             */
            remove_tick_callback(id: number): void;
            /**
             * A convenience function that uses the theme settings for `widget`
             * to look up `stock_id` and render it to a pixbuf. `stock_id` should
             * be a stock icon ID such as #GTK_STOCK_OPEN or #GTK_STOCK_OK. `size`
             * should be a size such as #GTK_ICON_SIZE_MENU. `detail` should be a
             * string that identifies the widget or code doing the rendering, so
             * that theme engines can special-case rendering for that widget or
             * code.
             *
             * The pixels in the returned #GdkPixbuf are shared with the rest of
             * the application and should not be modified. The pixbuf should be
             * freed after use with g_object_unref().
             * @param stock_id a stock ID
             * @param size a stock size (#GtkIconSize). A size of `(GtkIconSize)-1`     means render at the size of the source and don’t scale (if there are     multiple source sizes, GTK+ picks one of the available sizes).
             * @param detail render detail to pass to theme engine
             * @returns a new pixbuf, or %NULL if the     stock ID wasn’t known
             */
            render_icon(stock_id: string, size: number, detail?: string | null): GdkPixbuf.Pixbuf | null;
            /**
             * A convenience function that uses the theme engine and style
             * settings for `widget` to look up `stock_id` and render it to
             * a pixbuf. `stock_id` should be a stock icon ID such as
             * #GTK_STOCK_OPEN or #GTK_STOCK_OK. `size` should be a size
             * such as #GTK_ICON_SIZE_MENU.
             *
             * The pixels in the returned #GdkPixbuf are shared with the rest of
             * the application and should not be modified. The pixbuf should be freed
             * after use with g_object_unref().
             * @param stock_id a stock ID
             * @param size a stock size (#GtkIconSize). A size of `(GtkIconSize)-1`     means render at the size of the source and don’t scale (if there are     multiple source sizes, GTK+ picks one of the available sizes).
             * @returns a new pixbuf, or %NULL if the     stock ID wasn’t known
             */
            render_icon_pixbuf(stock_id: string, size: number): GdkPixbuf.Pixbuf | null;
            /**
             * Moves a widget from one #GtkContainer to another, handling reference
             * count issues to avoid destroying the widget.
             * @param new_parent a #GtkContainer to move the widget into
             */
            reparent(new_parent: Widget): void;
            /**
             * Reset the styles of `widget` and all descendents, so when
             * they are looked up again, they get the correct values
             * for the currently loaded RC file settings.
             *
             * This function is not useful for applications.
             */
            reset_rc_styles(): void;
            /**
             * Updates the style context of `widget` and all descendants
             * by updating its widget path. #GtkContainers may want
             * to use this on a child when reordering it in a way that a different
             * style might apply to it. See also gtk_container_get_path_for_child().
             */
            reset_style(): void;
            /**
             * Very rarely-used function. This function is used to emit
             * an expose event on a widget. This function is not normally used
             * directly. The only time it is used is when propagating an expose
             * event to a windowless child widget (gtk_widget_get_has_window() is %FALSE),
             * and that is normally done using gtk_container_propagate_draw().
             *
             * If you want to force an area of a window to be redrawn,
             * use gdk_window_invalidate_rect() or gdk_window_invalidate_region().
             * To cause the redraw to be done immediately, follow that call
             * with a call to gdk_window_process_updates().
             * @param event a expose #GdkEvent
             * @returns return from the event signal emission (%TRUE if   the event was handled)
             */
            send_expose(event: Gdk.Event): number;
            /**
             * Sends the focus change `event` to `widget`
             *
             * This function is not meant to be used by applications. The only time it
             * should be used is when it is necessary for a #GtkWidget to assign focus
             * to a widget that is semantically owned by the first widget even though
             * it’s not a direct child - for instance, a search entry in a floating
             * window similar to the quick search in #GtkTreeView.
             *
             * An example of its usage is:
             *
             *
             * ```c
             *   GdkEvent *fevent = gdk_event_new (GDK_FOCUS_CHANGE);
             *
             *   fevent->focus_change.type = GDK_FOCUS_CHANGE;
             *   fevent->focus_change.in = TRUE;
             *   fevent->focus_change.window = _gtk_widget_get_window (widget);
             *   if (fevent->focus_change.window != NULL)
             *     g_object_ref (fevent->focus_change.window);
             *
             *   gtk_widget_send_focus_change (widget, fevent);
             *
             *   gdk_event_free (event);
             * ```
             *
             * @param event a #GdkEvent of type GDK_FOCUS_CHANGE
             * @returns the return value from the event signal emission: %TRUE   if the event was handled, and %FALSE otherwise
             */
            send_focus_change(event: Gdk.Event): boolean;
            /**
             * Given an accelerator group, `accel_group,` and an accelerator path,
             * `accel_path,` sets up an accelerator in `accel_group` so whenever the
             * key binding that is defined for `accel_path` is pressed, `widget`
             * will be activated.  This removes any accelerators (for any
             * accelerator group) installed by previous calls to
             * gtk_widget_set_accel_path(). Associating accelerators with
             * paths allows them to be modified by the user and the modifications
             * to be saved for future use. (See gtk_accel_map_save().)
             *
             * This function is a low level function that would most likely
             * be used by a menu creation system like #GtkUIManager. If you
             * use #GtkUIManager, setting up accelerator paths will be done
             * automatically.
             *
             * Even when you you aren’t using #GtkUIManager, if you only want to
             * set up accelerators on menu items gtk_menu_item_set_accel_path()
             * provides a somewhat more convenient interface.
             *
             * Note that `accel_path` string will be stored in a #GQuark. Therefore, if you
             * pass a static string, you can save some memory by interning it first with
             * g_intern_static_string().
             * @param accel_path path used to look up the accelerator
             * @param accel_group a #GtkAccelGroup.
             */
            set_accel_path(accel_path?: string | null, accel_group?: AccelGroup | null): void;
            /**
             * Sets the widget’s allocation.  This should not be used
             * directly, but from within a widget’s size_allocate method.
             *
             * The allocation set should be the “adjusted” or actual
             * allocation. If you’re implementing a #GtkContainer, you want to use
             * gtk_widget_size_allocate() instead of gtk_widget_set_allocation().
             * The GtkWidgetClass::adjust_size_allocation virtual method adjusts the
             * allocation inside gtk_widget_size_allocate() to create an adjusted
             * allocation.
             * @param allocation a pointer to a #GtkAllocation to copy from
             */
            set_allocation(allocation: Allocation): void;
            /**
             * Sets whether the application intends to draw on the widget in
             * an #GtkWidget::draw handler.
             *
             * This is a hint to the widget and does not affect the behavior of
             * the GTK+ core; many widgets ignore this flag entirely. For widgets
             * that do pay attention to the flag, such as #GtkEventBox and #GtkWindow,
             * the effect is to suppress default themed drawing of the widget's
             * background. (Children of the widget will still be drawn.) The application
             * is then entirely responsible for drawing the widget background.
             *
             * Note that the background is still drawn when the widget is mapped.
             * @param app_paintable %TRUE if the application will paint on the widget
             */
            set_app_paintable(app_paintable: boolean): void;
            /**
             * Specifies whether `widget` can be a default widget. See
             * gtk_widget_grab_default() for details about the meaning of
             * “default”.
             * @param can_default whether or not @widget can be a default widget.
             */
            set_can_default(can_default: boolean): void;
            /**
             * Specifies whether `widget` can own the input focus. See
             * gtk_widget_grab_focus() for actually setting the input focus on a
             * widget.
             * @param can_focus whether or not @widget can own the input focus.
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether `widget` should be mapped along with its when its parent
             * is mapped and `widget` has been shown with gtk_widget_show().
             *
             * The child visibility can be set for widget before it is added to
             * a container with gtk_widget_set_parent(), to avoid mapping
             * children unnecessary before immediately unmapping them. However
             * it will be reset to its default state of %TRUE when the widget
             * is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for container implementations and
             * never should be called by an application.
             * @param is_visible if %TRUE, @widget should be mapped along with its parent.
             */
            set_child_visible(is_visible: boolean): void;
            /**
             * Sets the widget’s clip.  This must not be used directly,
             * but from within a widget’s size_allocate method.
             * It must be called after gtk_widget_set_allocation() (or after chaining up
             * to the parent class), because that function resets the clip.
             *
             * The clip set should be the area that `widget` draws on. If `widget` is a
             * #GtkContainer, the area must contain all children's clips.
             *
             * If this function is not called by `widget` during a ::size-allocate handler,
             * the clip will be set to `widget'`s allocation.
             * @param clip a pointer to a #GtkAllocation to copy from
             */
            set_clip(clip: Allocation): void;
            /**
             * Sets a widgets composite name. The widget must be
             * a composite child of its parent; see gtk_widget_push_composite_child().
             * @param name the name to set
             */
            set_composite_name(name: string): void;
            /**
             * Enables or disables a #GdkDevice to interact with `widget`
             * and all its children.
             *
             * It does so by descending through the #GdkWindow hierarchy
             * and enabling the same mask that is has for core events
             * (i.e. the one that gdk_window_get_events() returns).
             * @param device a #GdkDevice
             * @param enabled whether to enable the device
             */
            set_device_enabled(device: Gdk.Device, enabled: boolean): void;
            /**
             * Sets the device event mask (see #GdkEventMask) for a widget. The event
             * mask determines which events a widget will receive from `device`. Keep
             * in mind that different widgets have different default event masks, and by
             * changing the event mask you may disrupt a widget’s functionality,
             * so be careful. This function must be called while a widget is
             * unrealized. Consider gtk_widget_add_device_events() for widgets that are
             * already realized, or if you want to preserve the existing event
             * mask. This function can’t be used with windowless widgets (which return
             * %FALSE from gtk_widget_get_has_window());
             * to get events on those widgets, place them inside a #GtkEventBox
             * and receive events on the event box.
             * @param device a #GdkDevice
             * @param events event mask
             */
            set_device_events(device: Gdk.Device, events: Gdk.EventMask | null): void;
            /**
             * Sets the reading direction on a particular widget. This direction
             * controls the primary direction for widgets containing text,
             * and also the direction in which the children of a container are
             * packed. The ability to set the direction is present in order
             * so that correct localization into languages with right-to-left
             * reading directions can be done. Generally, applications will
             * let the default reading direction present, except for containers
             * where the containers are arranged in an order that is explicitly
             * visual rather than logical (such as buttons for text justification).
             *
             * If the direction is set to %GTK_TEXT_DIR_NONE, then the value
             * set by gtk_widget_set_default_direction() will be used.
             * @param dir the new direction
             */
            set_direction(dir: TextDirection | null): void;
            /**
             * Widgets are double buffered by default; you can use this function
             * to turn off the buffering. “Double buffered” simply means that
             * gdk_window_begin_draw_frame() and gdk_window_end_draw_frame() are called
             * automatically around expose events sent to the
             * widget. gdk_window_begin_draw_frame() diverts all drawing to a widget's
             * window to an offscreen buffer, and gdk_window_end_draw_frame() draws the
             * buffer to the screen. The result is that users see the window
             * update in one smooth step, and don’t see individual graphics
             * primitives being rendered.
             *
             * In very simple terms, double buffered widgets don’t flicker,
             * so you would only use this function to turn off double buffering
             * if you had special needs and really knew what you were doing.
             *
             * Note: if you turn off double-buffering, you have to handle
             * expose events, since even the clearing to the background color or
             * pixmap will not happen automatically (as it is done in
             * gdk_window_begin_draw_frame()).
             *
             * In 3.10 GTK and GDK have been restructured for translucent drawing. Since
             * then expose events for double-buffered widgets are culled into a single
             * event to the toplevel GDK window. If you now unset double buffering, you
             * will cause a separate rendering pass for every widget. This will likely
             * cause rendering problems - in particular related to stacking - and usually
             * increases rendering times significantly.
             * @param double_buffered %TRUE to double-buffer a widget
             */
            set_double_buffered(double_buffered: boolean): void;
            /**
             * Sets the event mask (see #GdkEventMask) for a widget. The event
             * mask determines which events a widget will receive. Keep in mind
             * that different widgets have different default event masks, and by
             * changing the event mask you may disrupt a widget’s functionality,
             * so be careful. This function must be called while a widget is
             * unrealized. Consider gtk_widget_add_events() for widgets that are
             * already realized, or if you want to preserve the existing event
             * mask. This function can’t be used with widgets that have no window.
             * (See gtk_widget_get_has_window()).  To get events on those widgets,
             * place them inside a #GtkEventBox and receive events on the event
             * box.
             * @param events event mask
             */
            set_events(events: number): void;
            /**
             * Sets whether the widget should grab focus when it is clicked with the mouse.
             * Making mouse clicks not grab focus is useful in places like toolbars where
             * you don’t want the keyboard focus removed from the main area of the
             * application.
             * @param focus_on_click whether the widget should grab focus when clicked with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets the font map to use for Pango rendering. When not set, the widget
             * will inherit the font map from its parent.
             * @param font_map a #PangoFontMap, or %NULL to unset any previously     set font map
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the #cairo_font_options_t used for Pango rendering in this widget.
             * When not set, the default font options for the #GdkScreen will be used.
             * @param options a #cairo_font_options_t, or %NULL to unset any   previously set default font options.
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of `widget`.
             * See the #GtkWidget:halign property.
             * @param align the horizontal alignment
             */
            set_halign(align: Align | null): void;
            /**
             * Sets the has-tooltip property on `widget` to `has_tooltip`.  See
             * #GtkWidget:has-tooltip for more information.
             * @param has_tooltip whether or not @widget has a tooltip.
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Specifies whether `widget` has a #GdkWindow of its own. Note that
             * all realized widgets have a non-%NULL “window” pointer
             * (gtk_widget_get_window() never returns a %NULL window when a widget
             * is realized), but for many of them it’s actually the #GdkWindow of
             * one of its parent widgets. Widgets that do not create a %window for
             * themselves in #GtkWidget::realize must announce this by
             * calling this function with `has_window` = %FALSE.
             *
             * This function should only be called by widget implementations,
             * and they should call it in their init() function.
             * @param has_window whether or not @widget has a window.
             */
            set_has_window(has_window: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space. When a user resizes a #GtkWindow, widgets with expand=TRUE
             * generally receive the extra space. For example, a list or
             * scrollable area or document in your window would often be set to
             * expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call gtk_widget_compute_expand(). A
             * container can decide how the expandability of children affects the
             * expansion of the container by overriding the compute_expand virtual
             * method on #GtkWidget.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children.  The override occurs because
             * gtk_widget_set_hexpand() sets the hexpand-set property (see
             * gtk_widget_set_hexpand_set()) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag (see gtk_widget_get_hexpand()) will
             * be used.
             *
             * The hexpand-set property will be set automatically when you call
             * gtk_widget_set_hexpand() to set hexpand, so the most likely
             * reason to use this function would be to unset an explicit expand
             * flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Marks the widget as being mapped.
             *
             * This function should only ever be called in a derived widget's
             * “map” or “unmap” implementation.
             * @param mapped %TRUE to mark the widget as mapped
             */
            set_mapped(mapped: boolean): void;
            /**
             * Sets the bottom margin of `widget`.
             * See the #GtkWidget:margin-bottom property.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of `widget`.
             * See the #GtkWidget:margin-end property.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the left margin of `widget`.
             * See the #GtkWidget:margin-left property.
             * @param margin the left margin
             */
            set_margin_left(margin: number): void;
            /**
             * Sets the right margin of `widget`.
             * See the #GtkWidget:margin-right property.
             * @param margin the right margin
             */
            set_margin_right(margin: number): void;
            /**
             * Sets the start margin of `widget`.
             * See the #GtkWidget:margin-start property.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of `widget`.
             * See the #GtkWidget:margin-top property.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Widgets can be named, which allows you to refer to them from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for #GtkStyleContext).
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Sets the #GtkWidget:no-show-all property, which determines whether
             * calls to gtk_widget_show_all() will affect this widget.
             *
             * This is mostly for use in constructing widget hierarchies with externally
             * controlled visibility, see #GtkUIManager.
             * @param no_show_all the new value for the “no-show-all” property
             */
            set_no_show_all(no_show_all: boolean): void;
            /**
             * Request the `widget` to be rendered partially transparent,
             * with opacity 0 being fully transparent and 1 fully opaque. (Opacity values
             * are clamped to the [0,1] range.).
             * This works on both toplevel widget, and child widgets, although there
             * are some limitations:
             *
             * For toplevel widgets this depends on the capabilities of the windowing
             * system. On X11 this has any effect only on X screens with a compositing manager
             * running. See gtk_widget_is_composited(). On Windows it should work
             * always, although setting a window’s opacity after the window has been
             * shown causes it to flicker once on Windows.
             *
             * For child widgets it doesn’t work if any affected widget has a native window, or
             * disables double buffering.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * This function is useful only when implementing subclasses of
             * #GtkContainer.
             * Sets the container as the parent of `widget,` and takes care of
             * some details such as updating the state and style of the child
             * to reflect its new location. The opposite function is
             * gtk_widget_unparent().
             * @param parent parent container
             */
            set_parent(parent: Widget): void;
            /**
             * Sets a non default parent window for `widget`.
             *
             * For #GtkWindow classes, setting a `parent_window` effects whether
             * the window is a toplevel window or can be embedded into other
             * widgets.
             *
             * For #GtkWindow classes, this needs to be called before the
             * window is realized.
             * @param parent_window the new parent window.
             */
            set_parent_window(parent_window: Gdk.Window): void;
            /**
             * Marks the widget as being realized. This function must only be
             * called after all #GdkWindows for the `widget` have been created
             * and registered.
             *
             * This function should only ever be called in a derived widget's
             * “realize” or “unrealize” implementation.
             * @param realized %TRUE to mark the widget as realized
             */
            set_realized(realized: boolean): void;
            /**
             * Specifies whether `widget` will be treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See gtk_widget_grab_default() for details about the meaning of
             * “default”.
             * @param receives_default whether or not @widget can be a default widget.
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets whether the entire widget is queued for drawing when its size
             * allocation changes. By default, this setting is %TRUE and
             * the entire widget is redrawn on every size change. If your widget
             * leaves the upper left unchanged when made bigger, turning this
             * setting off will improve performance.
             *
             * Note that for widgets where gtk_widget_get_has_window() is %FALSE
             * setting this flag to %FALSE turns off all allocation on resizing:
             * the widget will not even redraw if its position changes; this is to
             * allow containers that don’t draw anything to avoid excess
             * invalidations. If you set this flag on a widget with no window that
             * does draw on `widget->`window, you are
             * responsible for invalidating both the old and new allocation of the
             * widget when the widget is moved and responsible for invalidating
             * regions newly when the widget increases size.
             * @param redraw_on_allocate if %TRUE, the entire widget will be redrawn   when it is allocated to a new size. Otherwise, only the   new portion of the widget will be redrawn.
             */
            set_redraw_on_allocate(redraw_on_allocate: boolean): void;
            /**
             * Sets the sensitivity of a widget. A widget is sensitive if the user
             * can interact with it. Insensitive widgets are “grayed out” and the
             * user can’t interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive %TRUE to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of a widget; that is, the widget’s size
             * request will be at least `width` by `height`. You can use this
             * function to force a widget to be larger than it normally would be.
             *
             * In most cases, gtk_window_set_default_size() is a better choice for
             * toplevel windows than this function; setting the default size will
             * still allow users to shrink the window. Setting the size request
             * will force them to leave the window at least as large as the size
             * request. When dealing with window sizes,
             * gtk_window_set_geometry_hints() can be a useful function as well.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it's
             * basically impossible to hardcode a size that will always be
             * correct.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * #GtkWidget properties margin-left, margin-right, margin-top, and
             * margin-bottom, but it does include pretty much all other padding
             * or border properties set by any subclass of #GtkWidget.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * This function is for use in widget implementations. Sets the state
             * of a widget (insensitive, prelighted, etc.) Usually you should set
             * the state using wrapper functions such as gtk_widget_set_sensitive().
             * @param state new state for @widget
             */
            set_state(state: StateType | null): void;
            /**
             * This function is for use in widget implementations. Turns on flag
             * values in the current widget state (insensitive, prelighted, etc.).
             *
             * This function accepts the values %GTK_STATE_FLAG_DIR_LTR and
             * %GTK_STATE_FLAG_DIR_RTL but ignores them. If you want to set the widget's
             * direction, use gtk_widget_set_direction().
             *
             * It is worth mentioning that any other state than %GTK_STATE_FLAG_INSENSITIVE,
             * will be propagated down to all non-internal children if `widget` is a
             * #GtkContainer, while %GTK_STATE_FLAG_INSENSITIVE itself will be propagated
             * down to all #GtkContainer children by different means than turning on the
             * state flag down the hierarchy, both gtk_widget_get_state_flags() and
             * gtk_widget_is_sensitive() will make use of these.
             * @param flags State flags to turn on
             * @param clear Whether to clear state before turning on @flags
             */
            set_state_flags(flags: StateFlags | null, clear: boolean): void;
            /**
             * Used to set the #GtkStyle for a widget (`widget->`style). Since
             * GTK 3, this function does nothing, the passed in style is ignored.
             * @param style a #GtkStyle, or %NULL to remove the effect     of a previous call to gtk_widget_set_style() and go back to     the default style
             */
            set_style(style?: Style | null): void;
            /**
             * Enables or disables multiple pointer awareness. If this setting is %TRUE,
             * `widget` will start receiving multiple, per device enter/leave events. Note
             * that if custom #GdkWindows are created in #GtkWidget::realize,
             * gdk_window_set_support_multidevice() will have to be called manually on them.
             * @param support_multidevice %TRUE to support input from multiple devices.
             */
            set_support_multidevice(support_multidevice: boolean): void;
            /**
             * Sets `markup` as the contents of the tooltip, which is marked up with
             *  the [Pango text markup language][PangoMarkupFormat].
             *
             * This function will take care of setting #GtkWidget:has-tooltip to %TRUE
             * and of the default handler for the #GtkWidget::query-tooltip signal.
             *
             * See also the #GtkWidget:tooltip-markup property and
             * gtk_tooltip_set_markup().
             * @param markup the contents of the tooltip for @widget, or %NULL
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets `text` as the contents of the tooltip. This function will take
             * care of setting #GtkWidget:has-tooltip to %TRUE and of the default
             * handler for the #GtkWidget::query-tooltip signal.
             *
             * See also the #GtkWidget:tooltip-text property and gtk_tooltip_set_text().
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Replaces the default window used for displaying
             * tooltips with `custom_window`. GTK+ will take care of showing and
             * hiding `custom_window` at the right moment, to behave likewise as
             * the default tooltip window. If `custom_window` is %NULL, the default
             * tooltip window will be used.
             * @param custom_window a #GtkWindow, or %NULL
             */
            set_tooltip_window(custom_window?: Window | null): void;
            /**
             * Sets the vertical alignment of `widget`.
             * See the #GtkWidget:valign property.
             * @param align the vertical alignment
             */
            set_valign(align: Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See gtk_widget_set_hexpand() for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag (see gtk_widget_get_vexpand()) will
             * be used.
             *
             * See gtk_widget_set_hexpand_set() for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`. Note that setting this to
             * %TRUE doesn’t mean the widget is actually viewable, see
             * gtk_widget_get_visible().
             *
             * This function simply calls gtk_widget_show() or gtk_widget_hide()
             * but is nicer to use when the visibility of the widget depends on
             * some condition.
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Sets the visual that should be used for by widget and its children for
             * creating #GdkWindows. The visual must be on the same #GdkScreen as
             * returned by gtk_widget_get_screen(), so handling the
             * #GtkWidget::screen-changed signal is necessary.
             *
             * Setting a new `visual` will not cause `widget` to recreate its windows,
             * so you should call this function before `widget` is realized.
             * @param visual visual to be used or %NULL to unset a previous one
             */
            set_visual(visual?: Gdk.Visual | null): void;
            /**
             * Sets a widget’s window. This function should only be used in a
             * widget’s #GtkWidget::realize implementation. The %window passed is
             * usually either new window created with gdk_window_new(), or the
             * window of its parent widget as returned by
             * gtk_widget_get_parent_window().
             *
             * Widgets must indicate whether they will create their own #GdkWindow
             * by calling gtk_widget_set_has_window(). This is usually done in the
             * widget’s init() function.
             *
             * Note that this function does not add any reference to `window`.
             * @param window a #GdkWindow
             */
            set_window(window: Gdk.Window): void;
            /**
             * Sets a shape for this widget’s GDK window. This allows for
             * transparent windows etc., see gdk_window_shape_combine_region()
             * for more information.
             * @param region shape to be added, or %NULL to remove an existing shape
             */
            shape_combine_region(region?: cairo.Region | null): void;
            /**
             * Flags a widget to be displayed. Any widget that isn’t shown will
             * not appear on the screen. If you want to show all the widgets in a
             * container, it’s easier to call gtk_widget_show_all() on the
             * container, instead of individually showing the widgets.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel container is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel container is realized and mapped.
             */
            show(): void;
            /**
             * Recursively shows a widget, and any child widgets (if the widget is
             * a container).
             */
            show_all(): void;
            /**
             * Shows a widget. If the widget is an unmapped toplevel widget
             * (i.e. a #GtkWindow that has not yet been shown), enter the main
             * loop and wait for the window to actually be mapped. Be careful;
             * because the main loop is running, anything can happen during
             * this function.
             */
            show_now(): void;
            /**
             * This function is only used by #GtkContainer subclasses, to assign a size
             * and position to their child widgets.
             *
             * In this function, the allocation may be adjusted. It will be forced
             * to a 1x1 minimum size, and the adjust_size_allocation virtual
             * method on the child will be used to adjust the allocation. Standard
             * adjustments include removing the widget’s margins, and applying the
             * widget’s #GtkWidget:halign and #GtkWidget:valign properties.
             *
             * For baseline support in containers you need to use gtk_widget_size_allocate_with_baseline()
             * instead.
             * @param allocation position and size to be allocated to @widget
             */
            size_allocate(allocation: Allocation): void;
            /**
             * This function is only used by #GtkContainer subclasses, to assign a size,
             * position and (optionally) baseline to their child widgets.
             *
             * In this function, the allocation and baseline may be adjusted. It
             * will be forced to a 1x1 minimum size, and the
             * adjust_size_allocation virtual and adjust_baseline_allocation
             * methods on the child will be used to adjust the allocation and
             * baseline. Standard adjustments include removing the widget's
             * margins, and applying the widget’s #GtkWidget:halign and
             * #GtkWidget:valign properties.
             *
             * If the child widget does not have a valign of %GTK_ALIGN_BASELINE the
             * baseline argument is ignored and -1 is used instead.
             * @param allocation position and size to be allocated to @widget
             * @param baseline The baseline of the child, or -1
             */
            size_allocate_with_baseline(allocation: Allocation, baseline: number): void;
            /**
             * This function is typically used when implementing a #GtkContainer
             * subclass.  Obtains the preferred size of a widget. The container
             * uses this information to arrange its child widgets and decide what
             * size allocations to give them with gtk_widget_size_allocate().
             *
             * You can also call this function from an application, with some
             * caveats. Most notably, getting a size request requires the widget
             * to be associated with a screen, because font information may be
             * needed. Multihead-aware applications should keep this in mind.
             *
             * Also remember that the size request is not necessarily the size
             * a widget will actually be allocated.
             */
            size_request(): Requisition;
            /**
             * This function attaches the widget’s #GtkStyle to the widget's
             * #GdkWindow. It is a replacement for
             *
             *
             * ```
             * widget->style = gtk_style_attach (widget->style, widget->window);
             * ```
             *
             *
             * and should only ever be called in a derived widget’s “realize”
             * implementation which does not chain up to its parent class'
             * “realize” implementation, because one of the parent classes
             * (finally #GtkWidget) would attach the style itself.
             */
            style_attach(): void;
            /**
             * Gets the value of a style property of `widget`.
             * @param property_name the name of a style property
             * @param value location to return the property value
             */
            style_get_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Reverts the effect of a previous call to gtk_widget_freeze_child_notify().
             * This causes all queued #GtkWidget::child-notify signals on `widget` to be
             * emitted.
             */
            thaw_child_notify(): void;
            /**
             * Translate coordinates relative to `src_widget’`s allocation to coordinates
             * relative to `dest_widget’`s allocations. In order to perform this
             * operation, both widgets must be realized, and must share a common
             * toplevel.
             * @param dest_widget a #GtkWidget
             * @param src_x X position relative to @src_widget
             * @param src_y Y position relative to @src_widget
             * @returns %FALSE if either widget was not realized, or there   was no common ancestor. In this case, nothing is stored in   *@dest_x and *@dest_y. Otherwise %TRUE.
             */
            translate_coordinates(dest_widget: Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display where the toplevel of `widget`
             * is located. See gtk_tooltip_trigger_tooltip_query() for more
             * information.
             */
            trigger_tooltip_query(): void;
            /**
             * This function is only for use in widget implementations. Causes
             * a widget to be unmapped if it’s currently mapped.
             */
            unmap(): void;
            /**
             * This function is only for use in widget implementations.
             * Should be called by implementations of the remove method
             * on #GtkContainer, to dissociate a child from the container.
             */
            unparent(): void;
            /**
             * This function is only useful in widget implementations.
             * Causes a widget to be unrealized (frees all GDK resources
             * associated with the widget, such as `widget->`window).
             */
            unrealize(): void;
            /**
             * Unregisters a #GdkWindow from the widget that was previously set up with
             * gtk_widget_register_window(). You need to call this when the window is
             * no longer used by the widget, such as when you destroy it.
             * @param window a #GdkWindow
             */
            unregister_window(window: Gdk.Window): void;
            /**
             * This function is for use in widget implementations. Turns off flag
             * values for the current widget state (insensitive, prelighted, etc.).
             * See gtk_widget_set_state_flags().
             * @param flags State flags to turn off
             */
            unset_state_flags(flags: StateFlags | null): void;
            vfunc_adjust_baseline_allocation(baseline: number): void;
            vfunc_adjust_baseline_request(minimum_baseline: number, natural_baseline: number): void;
            /**
             * Convert an initial size allocation assigned
             *   by a #GtkContainer using gtk_widget_size_allocate(), into an actual
             *   size allocation to be used by the widget. adjust_size_allocation
             *   adjusts to a child widget’s actual allocation
             *   from what a parent container computed for the
             *   child. The adjusted allocation must be entirely within the original
             *   allocation. In any custom implementation, chain up to the default
             *   #GtkWidget implementation of this method, which applies the margin
             *   and alignment properties of #GtkWidget. Chain up
             *   before performing your own adjustments so your
             *   own adjustments remove more allocation after the #GtkWidget base
             *   class has already removed margin and alignment. The natural size
             *   passed in should be adjusted in the same way as the allocated size,
             *   which allows adjustments to perform alignments or other changes
             *   based on natural size.
             * @param orientation
             * @param minimum_size
             * @param natural_size
             * @param allocated_pos
             * @param allocated_size
             */
            vfunc_adjust_size_allocation(
                orientation: Orientation,
                minimum_size: number,
                natural_size: number,
                allocated_pos: number,
                allocated_size: number,
            ): void;
            /**
             * Convert an initial size request from a widget's
             *   #GtkSizeRequestMode virtual method implementations into a size request to
             *   be used by parent containers in laying out the widget.
             *   adjust_size_request adjusts from a child widget's
             *   original request to what a parent container should
             *   use for layout. The `for_size` argument will be -1 if the request should
             *   not be for a particular size in the opposing orientation, i.e. if the
             *   request is not height-for-width or width-for-height. If `for_size` is
             *   greater than -1, it is the proposed allocation in the opposing
             *   orientation that we need the request for. Implementations of
             *   adjust_size_request should chain up to the default implementation,
             *   which applies #GtkWidget’s margin properties and imposes any values
             *   from gtk_widget_set_size_request(). Chaining up should be last,
             *   after your subclass adjusts the request, so
             *   #GtkWidget can apply constraints and add the margin properly.
             * @param orientation
             * @param minimum_size
             * @param natural_size
             */
            vfunc_adjust_size_request(orientation: Orientation, minimum_size: number, natural_size: number): void;
            /**
             * Signal will be emitted when a button
             *   (typically from a mouse) is pressed.
             * @param event
             */
            vfunc_button_press_event(event: Gdk.EventButton): boolean;
            /**
             * Signal will be emitted when a button
             *   (typically from a mouse) is released.
             * @param event
             */
            vfunc_button_release_event(event: Gdk.EventButton): boolean;
            /**
             * Determines whether an accelerator that activates the signal
             * identified by `signal_id` can currently be activated.
             * This is done by emitting the #GtkWidget::can-activate-accel
             * signal on `widget;` if the signal isn’t overridden by a
             * handler or in a derived widget, then the default check is
             * that the widget must be sensitive, and the widget and all
             * its ancestors mapped.
             * @param signal_id the ID of a signal installed on @widget
             */
            vfunc_can_activate_accel(signal_id: number): boolean;
            /**
             * Emits a #GtkWidget::child-notify signal for the
             * [child property][child-properties] `child_property`
             * on `widget`.
             *
             * This is the analogue of g_object_notify() for child properties.
             *
             * Also see gtk_container_child_notify().
             * @param child_property the name of a child property installed on the                  class of @widget’s parent
             */
            vfunc_child_notify(child_property: GObject.ParamSpec): void;
            /**
             * Signal emitted when the composited status of
             *   widgets screen changes. See gdk_screen_is_composited().
             */
            vfunc_composited_changed(): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Signal will be emitted when the size, position or
             *   stacking of the widget’s window has changed.
             * @param event
             */
            vfunc_configure_event(event: Gdk.EventConfigure): boolean;
            /**
             * Signal emitted when a redirected window belonging to
             *   widget gets drawn into.
             * @param event
             */
            vfunc_damage_event(event: Gdk.EventExpose): boolean;
            /**
             * Signal emitted if a user requests that a toplevel
             *   window is closed.
             * @param event
             */
            vfunc_delete_event(event: Gdk.EventAny): boolean;
            /**
             * Destroys a widget.
             *
             * When a widget is destroyed all references it holds on other objects
             * will be released:
             *
             *  - if the widget is inside a container, it will be removed from its
             *  parent
             *  - if the widget is a container, all its children will be destroyed,
             *  recursively
             *  - if the widget is a top level, it will be removed from the list
             *  of top level widgets that GTK+ maintains internally
             *
             * It's expected that all references held on the widget will also
             * be released; you should connect to the #GtkWidget::destroy signal
             * if you hold a reference to `widget` and you wish to remove it when
             * this function is called. It is not necessary to do so if you are
             * implementing a #GtkContainer, as you'll be able to use the
             * #GtkContainerClass.remove() virtual function for that.
             *
             * It's important to notice that gtk_widget_destroy() will only cause
             * the `widget` to be finalized if no additional references, acquired
             * using g_object_ref(), are held on it. In case additional references
             * are in place, the `widget` will be in an "inert" state after calling
             * this function; `widget` will still point to valid memory, allowing you
             * to release the references you hold, but you may not query the widget's
             * own state.
             *
             * You should typically call this function on top level widgets, and
             * rarely on child widgets.
             *
             * See also: gtk_container_remove()
             */
            vfunc_destroy(): void;
            /**
             * Signal is emitted when a #GdkWindow is destroyed.
             * @param event
             */
            vfunc_destroy_event(event: Gdk.EventAny): boolean;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: TextDirection): void;
            /**
             * Seldomly overidden.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_child_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * Signal emitted on the drag source when a drag is
             *   started.
             * @param context
             */
            vfunc_drag_begin(context: Gdk.DragContext): void;
            /**
             * Signal emitted on the drag source when a drag
             *   with the action %GDK_ACTION_MOVE is successfully completed.
             * @param context
             */
            vfunc_drag_data_delete(context: Gdk.DragContext): void;
            /**
             * Signal emitted on the drag source when the drop
             *   site requests the data which is dragged.
             * @param context
             * @param selection_data
             * @param info
             * @param time_
             */
            vfunc_drag_data_get(
                context: Gdk.DragContext,
                selection_data: SelectionData,
                info: number,
                time_: number,
            ): void;
            /**
             * Signal emitted on the drop site when the
             *   dragged data has been received.
             * @param context
             * @param x
             * @param y
             * @param selection_data
             * @param info
             * @param time_
             */
            vfunc_drag_data_received(
                context: Gdk.DragContext,
                x: number,
                y: number,
                selection_data: SelectionData,
                info: number,
                time_: number,
            ): void;
            /**
             * Signal emitted on the drop site when the user drops the
             *   data onto the widget.
             * @param context
             * @param x
             * @param y
             * @param time_
             */
            vfunc_drag_drop(context: Gdk.DragContext, x: number, y: number, time_: number): boolean;
            /**
             * Signal emitted on the drag source when a drag is
             *   finished.
             * @param context
             */
            vfunc_drag_end(context: Gdk.DragContext): void;
            /**
             * Signal emitted on the drag source when a drag has
             *   failed.
             * @param context
             * @param result
             */
            vfunc_drag_failed(context: Gdk.DragContext, result: DragResult): boolean;
            /**
             * Signal emitted on the drop site when the cursor leaves
             *   the widget.
             * @param context
             * @param time_
             */
            vfunc_drag_leave(context: Gdk.DragContext, time_: number): void;
            /**
             * signal emitted on the drop site when the user moves
             *   the cursor over the widget during a drag.
             * @param context
             * @param x
             * @param y
             * @param time_
             */
            vfunc_drag_motion(context: Gdk.DragContext, x: number, y: number, time_: number): boolean;
            /**
             * Signal emitted when a widget is supposed to render itself.
             * @param cr
             */
            vfunc_draw(cr: cairo.Context): boolean;
            /**
             * Signal event will be emitted when the pointer
             *   enters the widget’s window.
             * @param event
             */
            vfunc_enter_notify_event(event: Gdk.EventCrossing): boolean;
            /**
             * Rarely-used function. This function is used to emit
             * the event signals on a widget (those signals should never
             * be emitted without using this function to do so).
             * If you want to synthesize an event though, don’t use this function;
             * instead, use gtk_main_do_event() so the event will behave as if
             * it were in the event queue. Don’t synthesize expose events; instead,
             * use gdk_window_invalidate_rect() to invalidate a region of the
             * window.
             * @param event a #GdkEvent
             */
            vfunc_event(event: Gdk.Event): boolean;
            vfunc_focus(direction: DirectionType): boolean;
            /**
             * Signal emitted when the keyboard focus enters the
             * widget’s window.
             * @param event
             */
            vfunc_focus_in_event(event: Gdk.EventFocus): boolean;
            /**
             * Signal emitted when the keyboard focus leaves the
             * widget’s window.
             * @param event
             */
            vfunc_focus_out_event(event: Gdk.EventFocus): boolean;
            /**
             * Returns the accessible object that describes the widget to an
             * assistive technology.
             *
             * If accessibility support is not available, this #AtkObject
             * instance may be a no-op. Likewise, if no class-specific #AtkObject
             * implementation is available for the widget instance in question,
             * it will inherit an #AtkObject implementation from the first ancestor
             * class for which such an implementation is defined.
             *
             * The documentation of the
             * [ATK](http://developer.gnome.org/atk/stable/)
             * library contains more information about accessible objects and their uses.
             */
            vfunc_get_accessible(): Atk.Object;
            /**
             * Retrieves a widget’s initial minimum and natural height.
             *
             * This call is specific to width-for-height requests.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             */
            vfunc_get_preferred_height(): [number, number];
            /**
             * Retrieves a widget’s minimum and natural height and the corresponding baselines if it would be given
             * the specified `width,` or the default height if `width` is -1. The baselines may be -1 which means
             * that no baseline is requested for this widget.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request and GtkWidgetClass::adjust_baseline_request virtual methods
             * and by any #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param width the width which is available for allocation, or -1 if none
             */
            vfunc_get_preferred_height_and_baseline_for_width(width: number): [number, number, number, number];
            /**
             * Retrieves a widget’s minimum and natural height if it would be given
             * the specified `width`.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param width the width which is available for allocation
             */
            vfunc_get_preferred_height_for_width(width: number): [number, number];
            /**
             * Retrieves a widget’s initial minimum and natural width.
             *
             * This call is specific to height-for-width requests.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             */
            vfunc_get_preferred_width(): [number, number];
            /**
             * Retrieves a widget’s minimum and natural width if it would be given
             * the specified `height`.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param height the height which is available for allocation
             */
            vfunc_get_preferred_width_for_height(height: number): [number, number];
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * #GtkBin widgets generally propagate the preference of
             * their child, container widgets need to request something either in
             * context of their children or in context of their allocation
             * capabilities.
             */
            vfunc_get_request_mode(): SizeRequestMode;
            /**
             * Signal emitted when a pointer or keyboard grab
             *   on a window belonging to widget gets broken.
             * @param event
             */
            vfunc_grab_broken_event(event: Gdk.EventGrabBroken): boolean;
            /**
             * Causes `widget` to have the keyboard focus for the #GtkWindow it's
             * inside. `widget` must be a focusable widget, such as a #GtkEntry;
             * something like #GtkFrame won’t work.
             *
             * More precisely, it must have the %GTK_CAN_FOCUS flag set. Use
             * gtk_widget_set_can_focus() to modify that flag.
             *
             * The widget also needs to be realized and mapped. This is indicated by the
             * related signals. Grabbing the focus immediately after creating the widget
             * will likely fail and cause critical warnings.
             */
            vfunc_grab_focus(): void;
            /**
             * Signal emitted when a widget becomes shadowed by a
             *   GTK+ grab (not a pointer or keyboard grab) on another widget, or
             *   when it becomes unshadowed due to a grab being removed.
             * @param was_grabbed
             */
            vfunc_grab_notify(was_grabbed: boolean): void;
            /**
             * Reverses the effects of gtk_widget_show(), causing the widget to be
             * hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Signal emitted when the anchored state of a
             *   widget changes.
             * @param previous_toplevel
             */
            vfunc_hierarchy_changed(previous_toplevel: Widget): void;
            /**
             * Signal emitted when a key is pressed.
             * @param event
             */
            vfunc_key_press_event(event: Gdk.EventKey): boolean;
            /**
             * Signal is emitted when a key is released.
             * @param event
             */
            vfunc_key_release_event(event: Gdk.EventKey): boolean;
            /**
             * This function should be called whenever keyboard navigation within
             * a single widget hits a boundary. The function emits the
             * #GtkWidget::keynav-failed signal on the widget and its return
             * value should be interpreted in a way similar to the return value of
             * gtk_widget_child_focus():
             *
             * When %TRUE is returned, stay in the widget, the failed keyboard
             * navigation is OK and/or there is nowhere we can/should move the
             * focus to.
             *
             * When %FALSE is returned, the caller should continue with keyboard
             * navigation outside the widget, e.g. by calling
             * gtk_widget_child_focus() on the widget’s toplevel.
             *
             * The default ::keynav-failed handler returns %FALSE for
             * %GTK_DIR_TAB_FORWARD and %GTK_DIR_TAB_BACKWARD. For the other
             * values of #GtkDirectionType it returns %TRUE.
             *
             * Whenever the default handler returns %TRUE, it also calls
             * gtk_widget_error_bell() to notify the user of the failed keyboard
             * navigation.
             *
             * A use case for providing an own implementation of ::keynav-failed
             * (either by connecting to it or by overriding it) would be a row of
             * #GtkEntry widgets where the user should be able to navigate the
             * entire row with the cursor keys, as e.g. known from user interfaces
             * that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: DirectionType): boolean;
            /**
             * Will be emitted when the pointer leaves the
             *   widget’s window.
             * @param event
             */
            vfunc_leave_notify_event(event: Gdk.EventCrossing): boolean;
            /**
             * This function is only for use in widget implementations. Causes
             * a widget to be mapped if it isn’t already.
             */
            vfunc_map(): void;
            /**
             * Signal emitted when the widget’s window is mapped.
             * @param event
             */
            vfunc_map_event(event: Gdk.EventAny): boolean;
            /**
             * Emits the #GtkWidget::mnemonic-activate signal.
             * @param group_cycling %TRUE if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when the pointer moves over
             *   the widget’s #GdkWindow.
             * @param event
             */
            vfunc_motion_notify_event(event: Gdk.EventMotion): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: DirectionType): void;
            /**
             * Signal emitted when a new parent has been set on a
             *   widget.
             * @param previous_parent
             */
            vfunc_parent_set(previous_parent: Widget): void;
            /**
             * Signal emitted whenever a widget should pop up a
             *   context menu.
             */
            vfunc_popup_menu(): boolean;
            /**
             * Signal will be emitted when a property on
             *   the widget’s window has been changed or deleted.
             * @param event
             */
            vfunc_property_notify_event(event: Gdk.EventProperty): boolean;
            vfunc_proximity_in_event(event: Gdk.EventProximity): boolean;
            vfunc_proximity_out_event(event: Gdk.EventProximity): boolean;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Tooltip): boolean;
            /**
             * Invalidates the area of `widget` defined by `region` by calling
             * gdk_window_invalidate_region() on the widget’s window and all its
             * child windows. Once the main loop becomes idle (after the current
             * batch of events has been processed, roughly), the window will
             * receive expose events for the union of all regions that have been
             * invalidated.
             *
             * Normally you would only use this function in widget
             * implementations. You might also use it to schedule a redraw of a
             * #GtkDrawingArea or some portion thereof.
             * @param region region to draw
             */
            vfunc_queue_draw_region(region: cairo.Region): void;
            /**
             * Creates the GDK (windowing system) resources associated with a
             * widget.  For example, `widget->`window will be created when a widget
             * is realized.  Normally realization happens implicitly; if you show
             * a widget and all its parent containers, then the widget will be
             * realized and mapped automatically.
             *
             * Realizing a widget requires all
             * the widget’s parent widgets to be realized; calling
             * gtk_widget_realize() realizes the widget’s parents in addition to
             * `widget` itself. If a widget is not yet inside a toplevel window
             * when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * #GtkWidget::draw. Or simply g_signal_connect () to the
             * #GtkWidget::realize signal.
             */
            vfunc_realize(): void;
            /**
             * Signal emitted when the screen of a widget has
             *   changed.
             * @param previous_screen
             */
            vfunc_screen_changed(previous_screen: Gdk.Screen): void;
            /**
             * Signal emitted when a button in the 4 to 7 range is
             *   pressed.
             * @param event
             */
            vfunc_scroll_event(event: Gdk.EventScroll): boolean;
            /**
             * Signal will be emitted when the the
             *   widget’s window has lost ownership of a selection.
             * @param event
             */
            vfunc_selection_clear_event(event: Gdk.EventSelection): boolean;
            vfunc_selection_get(selection_data: SelectionData, info: number, time_: number): void;
            vfunc_selection_notify_event(event: Gdk.EventSelection): boolean;
            vfunc_selection_received(selection_data: SelectionData, time_: number): void;
            /**
             * Signal will be emitted when another
             *   client requests ownership of the selection owned by the widget's
             *   window.
             * @param event
             */
            vfunc_selection_request_event(event: Gdk.EventSelection): boolean;
            /**
             * Flags a widget to be displayed. Any widget that isn’t shown will
             * not appear on the screen. If you want to show all the widgets in a
             * container, it’s easier to call gtk_widget_show_all() on the
             * container, instead of individually showing the widgets.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel container is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel container is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Recursively shows a widget, and any child widgets (if the widget is
             * a container).
             */
            vfunc_show_all(): void;
            vfunc_show_help(help_type: WidgetHelpType): boolean;
            /**
             * This function is only used by #GtkContainer subclasses, to assign a size
             * and position to their child widgets.
             *
             * In this function, the allocation may be adjusted. It will be forced
             * to a 1x1 minimum size, and the adjust_size_allocation virtual
             * method on the child will be used to adjust the allocation. Standard
             * adjustments include removing the widget’s margins, and applying the
             * widget’s #GtkWidget:halign and #GtkWidget:valign properties.
             *
             * For baseline support in containers you need to use gtk_widget_size_allocate_with_baseline()
             * instead.
             * @param allocation position and size to be allocated to @widget
             */
            vfunc_size_allocate(allocation: Allocation): void;
            /**
             * Signal emitted when the widget state
             *   changes. Deprecated: 3.0
             * @param previous_state
             */
            vfunc_state_changed(previous_state: StateType): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: StateFlags): void;
            /**
             * Signal emitted when a new style has been set on a
             * widget. Deprecated: 3.0
             * @param previous_style
             */
            vfunc_style_set(previous_style: Style): void;
            /**
             * Signal emitted when the GtkStyleContext of a widget
             *   is changed.
             */
            vfunc_style_updated(): void;
            /**
             * Signal emitted when a touch event happens
             * @param event
             */
            vfunc_touch_event(event: Gdk.EventTouch): boolean;
            /**
             * This function is only for use in widget implementations. Causes
             * a widget to be unmapped if it’s currently mapped.
             */
            vfunc_unmap(): void;
            /**
             * Signal will be emitted when the widget’s window is
             *   unmapped.
             * @param event
             */
            vfunc_unmap_event(event: Gdk.EventAny): boolean;
            /**
             * This function is only useful in widget implementations.
             * Causes a widget to be unrealized (frees all GDK resources
             * associated with the widget, such as `widget->`window).
             */
            vfunc_unrealize(): void;
            /**
             * Signal emitted when the widget’s window is
             *   obscured or unobscured.
             * @param event
             */
            vfunc_visibility_notify_event(event: Gdk.EventVisibility): boolean;
            /**
             * Signal emitted when the state of the toplevel
             *   window associated to the widget changes.
             * @param event
             */
            vfunc_window_state_event(event: Gdk.EventWindowState): boolean;
        }

        namespace AppChooserDialog {
            // Constructor properties interface

            interface ConstructorProps
                extends Dialog.ConstructorProps,
                    Atk.ImplementorIface.ConstructorProps,
                    AppChooser.ConstructorProps,
                    Buildable.ConstructorProps {
                gfile: Gio.File;
                heading: string;
            }
        }

        /**
         * #GtkAppChooserDialog shows a #GtkAppChooserWidget inside a #GtkDialog.
         *
         * Note that #GtkAppChooserDialog does not have any interesting methods
         * of its own. Instead, you should get the embedded #GtkAppChooserWidget
         * using gtk_app_chooser_dialog_get_widget() and call its methods if
         * the generic #GtkAppChooser interface is not sufficient for your needs.
         *
         * To set the heading that is shown above the #GtkAppChooserWidget,
         * use gtk_app_chooser_dialog_set_heading().
         */
        class AppChooserDialog extends Dialog implements Atk.ImplementorIface, AppChooser, Buildable {
            static $gtype: GObject.GType<AppChooserDialog>;

            // Properties

            /**
             * The GFile used by the #GtkAppChooserDialog.
             * The dialog's #GtkAppChooserWidget content type will be guessed from the
             * file, if present.
             */
            get gfile(): Gio.File;
            /**
             * The text to show at the top of the dialog.
             * The string may contain Pango markup.
             */
            get heading(): string;
            set heading(val: string);

            // Constructors

            constructor(properties?: Partial<AppChooserDialog.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](parent: Window | null, flags: DialogFlags, file: Gio.File): AppChooserDialog;
            // Conflicted with Gtk.Dialog.new

            static ['new'](...args: never[]): any;

            static new_for_content_type(
                parent: Window | null,
                flags: DialogFlags,
                content_type: string,
            ): AppChooserDialog;

            // Methods

            /**
             * Returns the text to display at the top of the dialog.
             * @returns the text to display at the top of the dialog, or %NULL, in which     case a default text is displayed
             */
            get_heading(): string | null;
            /**
             * Returns the #GtkAppChooserWidget of this dialog.
             * @returns the #GtkAppChooserWidget of @self
             */
            get_widget(): Widget;
            /**
             * Sets the text to display at the top of the dialog.
             * If the heading is not set, the dialog displays a default text.
             * @param heading a string containing Pango markup
             */
            set_heading(heading: string): void;

            // Inherited properties
            /**
             * The content type of the #GtkAppChooser object.
             *
             * See [GContentType][gio-GContentType]
             * for more information about content types.
             */
            get content_type(): string;
            /**
             * The content type of the #GtkAppChooser object.
             *
             * See [GContentType][gio-GContentType]
             * for more information about content types.
             */
            get contentType(): string;
            get app_paintable(): boolean;
            set app_paintable(val: boolean);
            get appPaintable(): boolean;
            set appPaintable(val: boolean);
            get can_default(): boolean;
            set can_default(val: boolean);
            get canDefault(): boolean;
            set canDefault(val: boolean);
            get can_focus(): boolean;
            set can_focus(val: boolean);
            get canFocus(): boolean;
            set canFocus(val: boolean);
            get composite_child(): boolean;
            get compositeChild(): boolean;
            /**
             * Whether the widget is double buffered.
             */
            get double_buffered(): boolean;
            set double_buffered(val: boolean);
            /**
             * Whether the widget is double buffered.
             */
            get doubleBuffered(): boolean;
            set doubleBuffered(val: boolean);
            get events(): Gdk.EventMask;
            set events(val: Gdk.EventMask);
            /**
             * Whether to expand in both directions. Setting this sets both #GtkWidget:hexpand and #GtkWidget:vexpand
             */
            get expand(): boolean;
            set expand(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             *
             * Before 3.20, several widgets (GtkButton, GtkFileChooserButton,
             * GtkComboBox) implemented this property individually.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             *
             * Before 3.20, several widgets (GtkButton, GtkFileChooserButton,
             * GtkComboBox) implemented this property individually.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space, see #GtkAlign
             */
            get halign(): Align;
            set halign(val: Align);
            get has_default(): boolean;
            set has_default(val: boolean);
            get hasDefault(): boolean;
            set hasDefault(val: boolean);
            get has_focus(): boolean;
            set has_focus(val: boolean);
            get hasFocus(): boolean;
            set hasFocus(val: boolean);
            /**
             * Enables or disables the emission of #GtkWidget::query-tooltip on `widget`.
             * A value of %TRUE indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using #GtkWidget::query-tooltip to determine
             * whether it will provide a tooltip or not.
             *
             * Note that setting this property to %TRUE for the first time will change
             * the event masks of the GdkWindows of this widget to include leave-notify
             * and motion-notify events.  This cannot and will not be undone when the
             * property is set to %FALSE again.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of #GtkWidget::query-tooltip on `widget`.
             * A value of %TRUE indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using #GtkWidget::query-tooltip to determine
             * whether it will provide a tooltip or not.
             *
             * Note that setting this property to %TRUE for the first time will change
             * the event masks of the GdkWindows of this widget to include leave-notify
             * and motion-notify events.  This cannot and will not be undone when the
             * property is set to %FALSE again.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            get height_request(): number;
            set height_request(val: number);
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally. See gtk_widget_set_hexpand().
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the #GtkWidget:hexpand property. See gtk_widget_get_hexpand_set().
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the #GtkWidget:hexpand property. See gtk_widget_get_hexpand_set().
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            get is_focus(): boolean;
            set is_focus(val: boolean);
            get isFocus(): boolean;
            set isFocus(val: boolean);
            /**
             * Sets all four sides' margin at once. If read, returns max
             * margin on any side.
             */
            get margin(): number;
            set margin(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on left side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_left(): number;
            set margin_left(val: number);
            /**
             * Margin on left side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginLeft(): number;
            set marginLeft(val: number);
            /**
             * Margin on right side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_right(): number;
            set margin_right(val: number);
            /**
             * Margin on right side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginRight(): number;
            set marginRight(val: number);
            /**
             * Margin on start of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally. This property supports
             * left-to-right and right-to-left text directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * gtk_widget_set_size_request() for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            get name(): string;
            set name(val: string);
            get no_show_all(): boolean;
            set no_show_all(val: boolean);
            get noShowAll(): boolean;
            set noShowAll(val: boolean);
            /**
             * The requested opacity of the widget. See gtk_widget_set_opacity() for
             * more details about window opacity.
             *
             * Before 3.8 this was only available in GtkWindow
             */
            get opacity(): number;
            set opacity(val: number);
            get parent(): Container;
            set parent(val: Container);
            get receives_default(): boolean;
            set receives_default(val: boolean);
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The scale factor of the widget. See gtk_widget_get_scale_factor() for
             * more details about widget scaling.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget. See gtk_widget_get_scale_factor() for
             * more details about widget scaling.
             */
            get scaleFactor(): number;
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * The style of the widget, which contains information about how it will look (colors, etc).
             */
            get style(): Style;
            set style(val: Style);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with the [Pango text markup language][PangoMarkupFormat].
             * Also see gtk_tooltip_set_markup().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with the [Pango text markup language][PangoMarkupFormat].
             * Also see gtk_tooltip_set_markup().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see gtk_tooltip_set_text().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see gtk_tooltip_set_text().
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not %NULL: #GtkWidget:has-tooltip
             * will automatically be set to %TRUE and there will be taken care of
             * #GtkWidget::query-tooltip in the default signal handler.
             *
             * Note that if both #GtkWidget:tooltip-text and #GtkWidget:tooltip-markup
             * are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space, see #GtkAlign
             */
            get valign(): Align;
            set valign(val: Align);
            /**
             * Whether to expand vertically. See gtk_widget_set_vexpand().
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the #GtkWidget:vexpand property. See gtk_widget_get_vexpand_set().
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the #GtkWidget:vexpand property. See gtk_widget_get_vexpand_set().
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            get visible(): boolean;
            set visible(val: boolean);
            get width_request(): number;
            set width_request(val: number);
            get widthRequest(): number;
            set widthRequest(val: number);
            /**
             * The widget's window if it is realized, %NULL otherwise.
             */
            // This accessor conflicts with a property or field in a parent class or interface.
            window: Gdk.Window | any;

            // Inherited methods
            /**
             * Returns the currently selected application.
             * @returns a #GAppInfo for the currently selected     application, or %NULL if none is selected. Free with g_object_unref()
             */
            get_app_info(): Gio.AppInfo | null;
            /**
             * Returns the current value of the #GtkAppChooser:content-type property.
             * @returns the content type of @self. Free with g_free()
             */
            get_content_type(): string;
            /**
             * Reloads the list of applications.
             */
            refresh(): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * For widgets that can be “activated” (buttons, menu items, etc.)
             * this function activates them. Activation is what happens when you
             * press Enter on a widget during key navigation. If `widget` isn't
             * activatable, the function returns %FALSE.
             * @returns %TRUE if the widget was activatable
             */
            activate(): boolean;
            /**
             * Installs an accelerator for this `widget` in `accel_group` that causes
             * `accel_signal` to be emitted if the accelerator is activated.
             * The `accel_group` needs to be added to the widget’s toplevel via
             * gtk_window_add_accel_group(), and the signal must be of type %G_SIGNAL_ACTION.
             * Accelerators added through this function are not user changeable during
             * runtime. If you want to support accelerators that can be changed by the
             * user, use gtk_accel_map_add_entry() and gtk_widget_set_accel_path() or
             * gtk_menu_item_set_accel_path() instead.
             * @param accel_signal widget signal to emit on accelerator activation
             * @param accel_group accel group for this widget, added to its toplevel
             * @param accel_key GDK keyval of the accelerator
             * @param accel_mods modifier key combination of the accelerator
             * @param accel_flags flag accelerators, e.g. %GTK_ACCEL_VISIBLE
             */
            add_accelerator(
                accel_signal: string,
                accel_group: AccelGroup,
                accel_key: number,
                accel_mods: Gdk.ModifierType | null,
                accel_flags: AccelFlags | null,
            ): void;
            /**
             * Adds the device events in the bitfield `events` to the event mask for
             * `widget`. See gtk_widget_set_device_events() for details.
             * @param device a #GdkDevice
             * @param events an event mask, see #GdkEventMask
             */
            add_device_events(device: Gdk.Device, events: Gdk.EventMask | null): void;
            /**
             * Adds the events in the bitfield `events` to the event mask for
             * `widget`. See gtk_widget_set_events() and the
             * [input handling overview][event-masks] for details.
             * @param events an event mask, see #GdkEventMask
             */
            add_events(events: number): void;
            /**
             * Adds a widget to the list of mnemonic labels for
             * this widget. (See gtk_widget_list_mnemonic_labels()). Note the
             * list of mnemonic labels for the widget is cleared when the
             * widget is destroyed, so the caller must make sure to update
             * its internal state at this point as well, by using a connection
             * to the #GtkWidget::destroy signal or a weak notifier.
             * @param label a #GtkWidget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame. Until the tick callback is removed, it will be
             * called frequently (usually at the frame rate of the output device
             * or as quickly as the application can be repainted, whichever is
             * slower). For this reason, is most suitable for handling graphics
             * that change every frame or every few frames. The tick callback does
             * not automatically imply a relayout or repaint. If you want a
             * repaint or relayout, and aren’t changing widget properties that
             * would trigger that (for example, changing the text of a #GtkLabel),
             * then you will have to call gtk_widget_queue_resize() or
             * gtk_widget_queue_draw_area() yourself.
             *
             * gdk_frame_clock_get_frame_time() should generally be used for timing
             * continuous animations and
             * gdk_frame_timings_get_predicted_presentation_time() if you are
             * trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * #GdkFrameClock::update signal of #GdkFrameClock, since you don't
             * have to worry about when a #GdkFrameClock is assigned to a widget.
             * @param callback function to call for updating animations
             * @returns an id for the connection of this callback. Remove the callback     by passing it to gtk_widget_remove_tick_callback()
             */
            add_tick_callback(callback: TickCallback): number;
            /**
             * Determines whether an accelerator that activates the signal
             * identified by `signal_id` can currently be activated.
             * This is done by emitting the #GtkWidget::can-activate-accel
             * signal on `widget;` if the signal isn’t overridden by a
             * handler or in a derived widget, then the default check is
             * that the widget must be sensitive, and the widget and all
             * its ancestors mapped.
             * @param signal_id the ID of a signal installed on @widget
             * @returns %TRUE if the accelerator can be activated.
             */
            can_activate_accel(signal_id: number): boolean;
            /**
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use gtk_widget_grab_focus() to move the focus
             * to a particular widget, and gtk_container_set_focus_chain() to
             * change the focus tab order. So you may want to investigate those
             * functions instead.
             *
             * gtk_widget_child_focus() is called by containers as the user moves
             * around the window using keyboard shortcuts. `direction` indicates
             * what kind of motion is taking place (up, down, left, right, tab
             * forward, tab backward). gtk_widget_child_focus() emits the
             * #GtkWidget::focus signal; widgets override the default handler
             * for this signal in order to implement appropriate focus behavior.
             *
             * The default ::focus handler for a widget should return %TRUE if
             * moving in `direction` left the focus on a focusable location inside
             * that widget, and %FALSE if moving in `direction` moved the focus
             * outside the widget. If returning %TRUE, widgets normally
             * call gtk_widget_grab_focus() to place the focus accordingly;
             * if returning %FALSE, they don’t modify the current focus location.
             * @param direction direction of focus movement
             * @returns %TRUE if focus ended up inside @widget
             */
            child_focus(direction: DirectionType | null): boolean;
            /**
             * Emits a #GtkWidget::child-notify signal for the
             * [child property][child-properties] `child_property`
             * on `widget`.
             *
             * This is the analogue of g_object_notify() for child properties.
             *
             * Also see gtk_container_child_notify().
             * @param child_property the name of a child property installed on the                  class of @widget’s parent
             */
            child_notify(child_property: string): void;
            // Conflicted with Gtk.Container.child_notify
            child_notify(...args: never[]): any;
            /**
             * Same as gtk_widget_path(), but always uses the name of a widget’s type,
             * never uses a custom name set with gtk_widget_set_name().
             */
            class_path(): [number, string, string];
            /**
             * Computes whether a container should give this widget extra space
             * when possible. Containers should check this, rather than
             * looking at gtk_widget_get_hexpand() or gtk_widget_get_vexpand().
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Orientation | null): boolean;
            /**
             * Creates a new #PangoContext with the appropriate font map,
             * font options, font description, and base direction for drawing
             * text for this widget. See also gtk_widget_get_pango_context().
             * @returns the new #PangoContext
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new #PangoLayout with the appropriate font map,
             * font description, and base direction for drawing text for
             * this widget.
             *
             * If you keep a #PangoLayout created in this way around, you need
             * to re-create it when the widget #PangoContext is replaced.
             * This can be tracked by using the #GtkWidget::screen-changed signal
             * on the widget.
             * @param text text to set on the layout (can be %NULL)
             * @returns the new #PangoLayout
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Destroys a widget.
             *
             * When a widget is destroyed all references it holds on other objects
             * will be released:
             *
             *  - if the widget is inside a container, it will be removed from its
             *  parent
             *  - if the widget is a container, all its children will be destroyed,
             *  recursively
             *  - if the widget is a top level, it will be removed from the list
             *  of top level widgets that GTK+ maintains internally
             *
             * It's expected that all references held on the widget will also
             * be released; you should connect to the #GtkWidget::destroy signal
             * if you hold a reference to `widget` and you wish to remove it when
             * this function is called. It is not necessary to do so if you are
             * implementing a #GtkContainer, as you'll be able to use the
             * #GtkContainerClass.remove() virtual function for that.
             *
             * It's important to notice that gtk_widget_destroy() will only cause
             * the `widget` to be finalized if no additional references, acquired
             * using g_object_ref(), are held on it. In case additional references
             * are in place, the `widget` will be in an "inert" state after calling
             * this function; `widget` will still point to valid memory, allowing you
             * to release the references you hold, but you may not query the widget's
             * own state.
             *
             * You should typically call this function on top level widgets, and
             * rarely on child widgets.
             *
             * See also: gtk_container_remove()
             */
            destroy(): void;
            /**
             * This function sets *`widget_pointer` to %NULL if `widget_pointer` !=
             * %NULL.  It’s intended to be used as a callback connected to the
             * “destroy” signal of a widget. You connect gtk_widget_destroyed()
             * as a signal handler, and pass the address of your widget variable
             * as user data. Then when the widget is destroyed, the variable will
             * be set to %NULL. Useful for example to avoid multiple copies
             * of the same dialog.
             * @param widget_pointer address of a variable that contains @widget
             */
            destroyed(widget_pointer: Widget): Widget;
            /**
             * Returns %TRUE if `device` has been shadowed by a GTK+
             * device grab on another widget, so it would stop sending
             * events to `widget`. This may be used in the
             * #GtkWidget::grab-notify signal to check for specific
             * devices. See gtk_device_grab_add().
             * @param device a #GdkDevice
             * @returns %TRUE if there is an ongoing grab on @device          by another #GtkWidget than @widget.
             */
            device_is_shadowed(device: Gdk.Device): boolean;
            /**
             * This function is equivalent to gtk_drag_begin_with_coordinates(),
             * passing -1, -1 as coordinates.
             * @param targets The targets (data formats) in which the    source can provide the data
             * @param actions A bitmask of the allowed drag actions for this drag
             * @param button The button the user clicked to start the drag
             * @param event The event that triggered the start of the drag,    or %NULL if none can be obtained.
             * @returns the context for this drag
             */
            drag_begin(
                targets: TargetList,
                actions: Gdk.DragAction | null,
                button: number,
                event?: Gdk.Event | null,
            ): Gdk.DragContext;
            /**
             * Initiates a drag on the source side. The function only needs to be used
             * when the application is starting drags itself, and is not needed when
             * gtk_drag_source_set() is used.
             *
             * The `event` is used to retrieve the timestamp that will be used internally to
             * grab the pointer.  If `event` is %NULL, then %GDK_CURRENT_TIME will be used.
             * However, you should try to pass a real event in all cases, since that can be
             * used to get information about the drag.
             *
             * Generally there are three cases when you want to start a drag by hand by
             * calling this function:
             *
             * 1. During a #GtkWidget::button-press-event handler, if you want to start a drag
             * immediately when the user presses the mouse button.  Pass the `event`
             * that you have in your #GtkWidget::button-press-event handler.
             *
             * 2. During a #GtkWidget::motion-notify-event handler, if you want to start a drag
             * when the mouse moves past a certain threshold distance after a button-press.
             * Pass the `event` that you have in your #GtkWidget::motion-notify-event handler.
             *
             * 3. During a timeout handler, if you want to start a drag after the mouse
             * button is held down for some time.  Try to save the last event that you got
             * from the mouse, using gdk_event_copy(), and pass it to this function
             * (remember to free the event with gdk_event_free() when you are done).
             * If you really cannot pass a real event, pass %NULL instead.
             * @param targets The targets (data formats) in which the    source can provide the data
             * @param actions A bitmask of the allowed drag actions for this drag
             * @param button The button the user clicked to start the drag
             * @param event The event that triggered the start of the drag,    or %NULL if none can be obtained.
             * @param x The initial x coordinate to start dragging from, in the coordinate space    of @widget. If -1 is passed, the coordinates are retrieved from @event or    the current pointer position
             * @param y The initial y coordinate to start dragging from, in the coordinate space    of @widget. If -1 is passed, the coordinates are retrieved from @event or    the current pointer position
             * @returns the context for this drag
             */
            drag_begin_with_coordinates(
                targets: TargetList,
                actions: Gdk.DragAction | null,
                button: number,
                event: Gdk.Event | null,
                x: number,
                y: number,
            ): Gdk.DragContext;
            /**
             * Checks to see if a mouse drag starting at (`start_x,` `start_y)` and ending
             * at (`current_x,` `current_y)` has passed the GTK+ drag threshold, and thus
             * should trigger the beginning of a drag-and-drop operation.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns %TRUE if the drag threshold has been passed.
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Add the image targets supported by #GtkSelectionData to
             * the target list of the drag destination. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_image_targets() and
             * gtk_drag_dest_set_target_list().
             */
            drag_dest_add_image_targets(): void;
            /**
             * Add the text targets supported by #GtkSelectionData to
             * the target list of the drag destination. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_text_targets() and
             * gtk_drag_dest_set_target_list().
             */
            drag_dest_add_text_targets(): void;
            /**
             * Add the URI targets supported by #GtkSelectionData to
             * the target list of the drag destination. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_uri_targets() and
             * gtk_drag_dest_set_target_list().
             */
            drag_dest_add_uri_targets(): void;
            /**
             * Looks for a match between the supported targets of `context` and the
             * `dest_target_list,` returning the first matching target, otherwise
             * returning %GDK_NONE. `dest_target_list` should usually be the return
             * value from gtk_drag_dest_get_target_list(), but some widgets may
             * have different valid targets for different parts of the widget; in
             * that case, they will have to implement a drag_motion handler that
             * passes the correct target list to this function.
             * @param context drag context
             * @param target_list list of droppable targets, or %NULL to use    gtk_drag_dest_get_target_list (@widget).
             * @returns first target that the source offers     and the dest can accept, or %GDK_NONE
             */
            drag_dest_find_target(context: Gdk.DragContext, target_list?: TargetList | null): Gdk.Atom;
            /**
             * Returns the list of targets this widget can accept from
             * drag-and-drop.
             * @returns the #GtkTargetList, or %NULL if none
             */
            drag_dest_get_target_list(): TargetList | null;
            /**
             * Returns whether the widget has been configured to always
             * emit #GtkWidget::drag-motion signals.
             * @returns %TRUE if the widget always emits   #GtkWidget::drag-motion events
             */
            drag_dest_get_track_motion(): boolean;
            /**
             * Sets a widget as a potential drop destination, and adds default behaviors.
             *
             * The default behaviors listed in `flags` have an effect similar
             * to installing default handlers for the widget’s drag-and-drop signals
             * (#GtkWidget::drag-motion, #GtkWidget::drag-drop, ...). They all exist
             * for convenience. When passing #GTK_DEST_DEFAULT_ALL for instance it is
             * sufficient to connect to the widget’s #GtkWidget::drag-data-received
             * signal to get primitive, but consistent drag-and-drop support.
             *
             * Things become more complicated when you try to preview the dragged data,
             * as described in the documentation for #GtkWidget::drag-motion. The default
             * behaviors described by `flags` make some assumptions, that can conflict
             * with your own signal handlers. For instance #GTK_DEST_DEFAULT_DROP causes
             * invokations of gdk_drag_status() in the context of #GtkWidget::drag-motion,
             * and invokations of gtk_drag_finish() in #GtkWidget::drag-data-received.
             * Especially the later is dramatic, when your own #GtkWidget::drag-motion
             * handler calls gtk_drag_get_data() to inspect the dragged data.
             *
             * There’s no way to set a default action here, you can use the
             * #GtkWidget::drag-motion callback for that. Here’s an example which selects
             * the action to use depending on whether the control key is pressed or not:
             *
             * ```c
             * static void
             * drag_motion (GtkWidget *widget,
             *              GdkDragContext *context,
             *              gint x,
             *              gint y,
             *              guint time)
             * {
             *   GdkModifierType mask;
             *
             *   gdk_window_get_pointer (gtk_widget_get_window (widget),
             *                           NULL, NULL, &mask);
             *   if (mask & GDK_CONTROL_MASK)
             *     gdk_drag_status (context, GDK_ACTION_COPY, time);
             *   else
             *     gdk_drag_status (context, GDK_ACTION_MOVE, time);
             * }
             * ```
             *
             * @param flags which types of default drag behavior to use
             * @param targets a pointer to an array of     #GtkTargetEntrys indicating the drop types that this @widget will     accept, or %NULL. Later you can access the list with     gtk_drag_dest_get_target_list() and gtk_drag_dest_find_target().
             * @param actions a bitmask of possible actions for a drop onto this @widget.
             */
            drag_dest_set(
                flags: DestDefaults | null,
                targets: TargetEntry[] | null,
                actions: Gdk.DragAction | null,
            ): void;
            /**
             * Sets this widget as a proxy for drops to another window.
             * @param proxy_window the window to which to forward drag events
             * @param protocol the drag protocol which the @proxy_window accepts   (You can use gdk_drag_get_protocol() to determine this)
             * @param use_coordinates If %TRUE, send the same coordinates to the   destination, because it is an embedded   subwindow.
             */
            drag_dest_set_proxy(
                proxy_window: Gdk.Window,
                protocol: Gdk.DragProtocol | null,
                use_coordinates: boolean,
            ): void;
            /**
             * Sets the target types that this widget can accept from drag-and-drop.
             * The widget must first be made into a drag destination with
             * gtk_drag_dest_set().
             * @param target_list list of droppable targets, or %NULL for none
             */
            drag_dest_set_target_list(target_list?: TargetList | null): void;
            /**
             * Tells the widget to emit #GtkWidget::drag-motion and
             * #GtkWidget::drag-leave events regardless of the targets and the
             * %GTK_DEST_DEFAULT_MOTION flag.
             *
             * This may be used when a widget wants to do generic
             * actions regardless of the targets that the source offers.
             * @param track_motion whether to accept all targets
             */
            drag_dest_set_track_motion(track_motion: boolean): void;
            /**
             * Clears information about a drop destination set with
             * gtk_drag_dest_set(). The widget will no longer receive
             * notification of drags.
             */
            drag_dest_unset(): void;
            /**
             * Gets the data associated with a drag. When the data
             * is received or the retrieval fails, GTK+ will emit a
             * #GtkWidget::drag-data-received signal. Failure of the retrieval
             * is indicated by the length field of the `selection_data`
             * signal parameter being negative. However, when gtk_drag_get_data()
             * is called implicitely because the %GTK_DEST_DEFAULT_DROP was set,
             * then the widget will not receive notification of failed
             * drops.
             * @param context the drag context
             * @param target the target (form of the data) to retrieve
             * @param time_ a timestamp for retrieving the data. This will   generally be the time received in a #GtkWidget::drag-motion   or #GtkWidget::drag-drop signal
             */
            drag_get_data(context: Gdk.DragContext, target: Gdk.Atom, time_: number): void;
            /**
             * Highlights a widget as a currently hovered drop target.
             * To end the highlight, call gtk_drag_unhighlight().
             * GTK+ calls this automatically if %GTK_DEST_DEFAULT_HIGHLIGHT is set.
             */
            drag_highlight(): void;
            /**
             * Add the writable image targets supported by #GtkSelectionData to
             * the target list of the drag source. The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_image_targets() and
             * gtk_drag_source_set_target_list().
             */
            drag_source_add_image_targets(): void;
            /**
             * Add the text targets supported by #GtkSelectionData to
             * the target list of the drag source.  The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_text_targets() and
             * gtk_drag_source_set_target_list().
             */
            drag_source_add_text_targets(): void;
            /**
             * Add the URI targets supported by #GtkSelectionData to
             * the target list of the drag source.  The targets
             * are added with `info` = 0. If you need another value,
             * use gtk_target_list_add_uri_targets() and
             * gtk_drag_source_set_target_list().
             */
            drag_source_add_uri_targets(): void;
            /**
             * Gets the list of targets this widget can provide for
             * drag-and-drop.
             * @returns the #GtkTargetList, or %NULL if none
             */
            drag_source_get_target_list(): TargetList | null;
            /**
             * Sets up a widget so that GTK+ will start a drag operation when the user
             * clicks and drags on the widget. The widget must have a window.
             * @param start_button_mask the bitmask of buttons that can start the drag
             * @param targets the table of targets     that the drag will support, may be %NULL
             * @param actions the bitmask of possible actions for a drag from this widget
             */
            drag_source_set(
                start_button_mask: Gdk.ModifierType | null,
                targets: TargetEntry[] | null,
                actions: Gdk.DragAction | null,
            ): void;
            /**
             * Sets the icon that will be used for drags from a particular source
             * to `icon`. See the docs for #GtkIconTheme for more details.
             * @param icon A #GIcon
             */
            drag_source_set_icon_gicon(icon: Gio.Icon): void;
            /**
             * Sets the icon that will be used for drags from a particular source
             * to a themed icon. See the docs for #GtkIconTheme for more details.
             * @param icon_name name of icon to use
             */
            drag_source_set_icon_name(icon_name: string): void;
            /**
             * Sets the icon that will be used for drags from a particular widget
             * from a #GdkPixbuf. GTK+ retains a reference for `pixbuf` and will
             * release it when it is no longer needed.
             * @param pixbuf the #GdkPixbuf for the drag icon
             */
            drag_source_set_icon_pixbuf(pixbuf: GdkPixbuf.Pixbuf): void;
            /**
             * Sets the icon that will be used for drags from a particular source
             * to a stock icon.
             * @param stock_id the ID of the stock icon to use
             */
            drag_source_set_icon_stock(stock_id: string): void;
            /**
             * Changes the target types that this widget offers for drag-and-drop.
             * The widget must first be made into a drag source with
             * gtk_drag_source_set().
             * @param target_list list of draggable targets, or %NULL for none
             */
            drag_source_set_target_list(target_list?: TargetList | null): void;
            /**
             * Undoes the effects of gtk_drag_source_set().
             */
            drag_source_unset(): void;
            /**
             * Removes a highlight set by gtk_drag_highlight() from
             * a widget.
             */
            drag_unhighlight(): void;
            /**
             * Draws `widget` to `cr`. The top left corner of the widget will be
             * drawn to the currently set origin point of `cr`.
             *
             * You should pass a cairo context as `cr` argument that is in an
             * original state. Otherwise the resulting drawing is undefined. For
             * example changing the operator using cairo_set_operator() or the
             * line width using cairo_set_line_width() might have unwanted side
             * effects.
             * You may however change the context’s transform matrix - like with
             * cairo_scale(), cairo_translate() or cairo_set_matrix() and clip
             * region with cairo_clip() prior to calling this function. Also, it
             * is fine to modify the context with cairo_save() and
             * cairo_push_group() prior to calling this function.
             *
             * Note that special-purpose widgets may contain special code for
             * rendering to the screen and might appear differently on screen
             * and when rendered using gtk_widget_draw().
             * @param cr a cairo context to draw to
             */
            draw(cr: cairo.Context): void;
            /**
             * Ensures that `widget` has a style (`widget->`style).
             *
             * Not a very useful function; most of the time, if you
             * want the style, the widget is realized, and realized
             * widgets are guaranteed to have a style already.
             */
            ensure_style(): void;
            /**
             * Notifies the user about an input-related error on this widget.
             * If the #GtkSettings:gtk-error-bell setting is %TRUE, it calls
             * gdk_window_beep(), otherwise it does nothing.
             *
             * Note that the effect of gdk_window_beep() can be configured in many
             * ways, depending on the windowing backend and the desktop environment
             * or window manager that is used.
             */
            error_bell(): void;
            /**
             * Rarely-used function. This function is used to emit
             * the event signals on a widget (those signals should never
             * be emitted without using this function to do so).
             * If you want to synthesize an event though, don’t use this function;
             * instead, use gtk_main_do_event() so the event will behave as if
             * it were in the event queue. Don’t synthesize expose events; instead,
             * use gdk_window_invalidate_rect() to invalidate a region of the
             * window.
             * @param event a #GdkEvent
             * @returns return from the event signal emission (%TRUE if               the event was handled)
             */
            event(event: Gdk.Event): boolean;
            /**
             * Stops emission of #GtkWidget::child-notify signals on `widget`. The
             * signals are queued until gtk_widget_thaw_child_notify() is called
             * on `widget`.
             *
             * This is the analogue of g_object_freeze_notify() for child properties.
             */
            freeze_child_notify(): void;
            /**
             * Returns the accessible object that describes the widget to an
             * assistive technology.
             *
             * If accessibility support is not available, this #AtkObject
             * instance may be a no-op. Likewise, if no class-specific #AtkObject
             * implementation is available for the widget instance in question,
             * it will inherit an #AtkObject implementation from the first ancestor
             * class for which such an implementation is defined.
             *
             * The documentation of the
             * [ATK](http://developer.gnome.org/atk/stable/)
             * library contains more information about accessible objects and their uses.
             * @returns the #AtkObject associated with @widget
             */
            get_accessible(): Atk.Object;
            /**
             * Retrieves the #GActionGroup that was registered using `prefix`. The resulting
             * #GActionGroup may have been registered to `widget` or any #GtkWidget in its
             * ancestry.
             *
             * If no action group was found matching `prefix,` then %NULL is returned.
             * @param prefix The “prefix” of the action group.
             * @returns A #GActionGroup or %NULL.
             */
            get_action_group(prefix: string): Gio.ActionGroup | null;
            /**
             * Returns the baseline that has currently been allocated to `widget`.
             * This function is intended to be used when implementing handlers
             * for the #GtkWidget::draw function, and when allocating child
             * widgets in #GtkWidget::size_allocate.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to `widget`.
             * This function is intended to be used when implementing handlers
             * for the #GtkWidget::draw function.
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Retrieves the widget’s allocated size.
             *
             * This function returns the last values passed to
             * gtk_widget_size_allocate_with_baseline(). The value differs from
             * the size returned in gtk_widget_get_allocation() in that functions
             * like gtk_widget_set_halign() can adjust the allocation, but not
             * the value returned by this function.
             *
             * If a widget is not visible, its allocated size is 0.
             */
            get_allocated_size(): [Allocation, number];
            /**
             * Returns the width that has currently been allocated to `widget`.
             * This function is intended to be used when implementing handlers
             * for the #GtkWidget::draw function.
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a #GtkContainer: a widget’s allocation will
             * be its “adjusted” allocation, that is, the widget’s parent
             * container typically calls gtk_widget_size_allocate() with an
             * allocation, and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * gtk_widget_get_allocation() returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * gtk_widget_size_allocate() allocation, however. So a #GtkContainer
             * is guaranteed that its children stay inside the assigned bounds,
             * but not that they have exactly the bounds the container assigned.
             * There is no way to get the original allocation assigned by
             * gtk_widget_size_allocate(), since it isn’t stored; if a container
             * implementation needs that information it will have to track it itself.
             */
            get_allocation(): Allocation;
            /**
             * Gets the first ancestor of `widget` with type `widget_type`. For example,
             * `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)` gets
             * the first #GtkBox that’s an ancestor of `widget`. No reference will be
             * added to the returned widget; it should not be unreferenced. See note
             * about checking for a toplevel #GtkWindow in the docs for
             * gtk_widget_get_toplevel().
             *
             * Note that unlike gtk_widget_is_ancestor(), gtk_widget_get_ancestor()
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget, or %NULL if not found
             */
            get_ancestor(widget_type: GObject.GType): Widget | null;
            /**
             * Determines whether the application intends to draw on the widget in
             * an #GtkWidget::draw handler.
             *
             * See gtk_widget_set_app_paintable()
             * @returns %TRUE if the widget is app paintable
             */
            get_app_paintable(): boolean;
            /**
             * Determines whether `widget` can be a default widget. See
             * gtk_widget_set_can_default().
             * @returns %TRUE if @widget can be a default widget, %FALSE otherwise
             */
            get_can_default(): boolean;
            /**
             * Determines whether `widget` can own the input focus. See
             * gtk_widget_set_can_focus().
             * @returns %TRUE if @widget can own the input focus, %FALSE otherwise
             */
            get_can_focus(): boolean;
            /**
             * This function is only for use in widget implementations. Obtains
             * `widget->`requisition, unless someone has forced a particular
             * geometry on the widget (e.g. with gtk_widget_set_size_request()),
             * in which case it returns that geometry instead of the widget's
             * requisition.
             *
             * This function differs from gtk_widget_size_request() in that
             * it retrieves the last size request value from `widget->`requisition,
             * while gtk_widget_size_request() actually calls the "size_request" method
             * on `widget` to compute the size request and fill in `widget->`requisition,
             * and only then returns `widget->`requisition.
             *
             * Because this function does not call the “size_request” method, it
             * can only be used when you know that `widget->`requisition is
             * up-to-date, that is, gtk_widget_size_request() has been called
             * since the last time a resize was queued. In general, only container
             * implementations have this information; applications should use
             * gtk_widget_size_request().
             */
            get_child_requisition(): Requisition;
            /**
             * Gets the value set with gtk_widget_set_child_visible().
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for container implementations and
             * never should be called by an application.
             * @returns %TRUE if the widget is mapped with the parent.
             */
            get_child_visible(): boolean;
            /**
             * Retrieves the widget’s clip area.
             *
             * The clip area is the area in which all of `widget'`s drawing will
             * happen. Other toolkits call it the bounding box.
             *
             * Historically, in GTK+ the clip area has been equal to the allocation
             * retrieved via gtk_widget_get_allocation().
             */
            get_clip(): Allocation;
            /**
             * Returns the clipboard object for the given selection to
             * be used with `widget`. `widget` must have a #GdkDisplay
             * associated with it, so must be attached to a toplevel
             * window.
             * @param selection a #GdkAtom which identifies the clipboard             to use. %GDK_SELECTION_CLIPBOARD gives the             default clipboard. Another common value             is %GDK_SELECTION_PRIMARY, which gives             the primary X selection.
             * @returns the appropriate clipboard object. If no             clipboard already exists, a new one will             be created. Once a clipboard object has             been created, it is persistent for all time.
             */
            get_clipboard(selection: Gdk.Atom): Clipboard;
            /**
             * Obtains the composite name of a widget.
             * @returns the composite name of @widget, or %NULL if @widget is not   a composite child. The string should be freed when it is no   longer needed.
             */
            get_composite_name(): string;
            /**
             * Returns whether `device` can interact with `widget` and its
             * children. See gtk_widget_set_device_enabled().
             * @param device a #GdkDevice
             * @returns %TRUE is @device is enabled for @widget
             */
            get_device_enabled(device: Gdk.Device): boolean;
            /**
             * Returns the events mask for the widget corresponding to an specific device. These
             * are the events that the widget will receive when `device` operates on it.
             * @param device a #GdkDevice
             * @returns device event mask for @widget
             */
            get_device_events(device: Gdk.Device): Gdk.EventMask;
            /**
             * Gets the reading direction for a particular widget. See
             * gtk_widget_set_direction().
             * @returns the reading direction for the widget.
             */
            get_direction(): TextDirection;
            /**
             * Get the #GdkDisplay for the toplevel window associated with
             * this widget. This function can only be called after the widget
             * has been added to a widget hierarchy with a #GtkWindow at the top.
             *
             * In general, you should only create display specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the #GdkDisplay for the toplevel for this widget.
             */
            get_display(): Gdk.Display;
            /**
             * Determines whether the widget is double buffered.
             *
             * See gtk_widget_set_double_buffered()
             * @returns %TRUE if the widget is double buffered
             */
            get_double_buffered(): boolean;
            /**
             * Returns the event mask (see #GdkEventMask) for the widget. These are the
             * events that the widget will receive.
             *
             * Note: Internally, the widget event mask will be the logical OR of the event
             * mask set through gtk_widget_set_events() or gtk_widget_add_events(), and the
             * event mask necessary to cater for every #GtkEventController created for the
             * widget.
             * @returns event mask for @widget
             */
            get_events(): number;
            /**
             * Returns whether the widget should grab focus when it is clicked with the mouse.
             * See gtk_widget_set_focus_on_click().
             * @returns %TRUE if the widget should grab focus when it is clicked with               the mouse.
             */
            get_focus_on_click(): boolean;
            /**
             * Gets the font map that has been set with gtk_widget_set_font_map().
             * @returns A #PangoFontMap, or %NULL
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the #cairo_font_options_t used for Pango rendering. When not set,
             * the defaults font options for the #GdkScreen will be used.
             * @returns the #cairo_font_options_t or %NULL if not set
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget. The frame clock is a global
             * “ticker” that can be used to drive animations and repaints.  The
             * most common reason to get the frame clock is to call
             * gdk_frame_clock_get_frame_time(), in order to get a time to use for
             * animating. For example you might record the start of the animation
             * with an initial value from gdk_frame_clock_get_frame_time(), and
             * then update the animation by calling
             * gdk_frame_clock_get_frame_time() again during each repaint.
             *
             * gdk_frame_clock_request_phase() will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a
             * widget, you have to use gtk_widget_queue_draw() which invalidates
             * the widget (thus scheduling it to receive a draw on the next
             * frame). gtk_widget_queue_draw() will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is
             * mapped. Reparenting a widget (which implies a temporary unmap) can
             * change the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns a #GdkFrameClock, or %NULL if widget is unrealized
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the value of the #GtkWidget:halign property.
             *
             * For backwards compatibility reasons this method will never return
             * %GTK_ALIGN_BASELINE, but instead it will convert it to
             * %GTK_ALIGN_FILL. Baselines are not supported for horizontal
             * alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Align;
            /**
             * Returns the current value of the has-tooltip property.  See
             * #GtkWidget:has-tooltip for more information.
             * @returns current value of has-tooltip on @widget.
             */
            get_has_tooltip(): boolean;
            /**
             * Determines whether `widget` has a #GdkWindow of its own. See
             * gtk_widget_set_has_window().
             * @returns %TRUE if @widget has a window, %FALSE otherwise
             */
            get_has_window(): boolean;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space. When a user resizes a #GtkWindow, widgets with expand=TRUE
             * generally receive the extra space. For example, a list or
             * scrollable area or document in your window would often be set to
             * expand.
             *
             * Containers should use gtk_widget_compute_expand() rather than
             * this function, to see whether a widget, or any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether gtk_widget_set_hexpand() has been used to
             * explicitly set the expand flag on this widget.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Whether the widget is mapped.
             * @returns %TRUE if the widget is mapped, %FALSE otherwise.
             */
            get_mapped(): boolean;
            /**
             * Gets the value of the #GtkWidget:margin-bottom property.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the value of the #GtkWidget:margin-end property.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the value of the #GtkWidget:margin-left property.
             * @returns The left margin of @widget
             */
            get_margin_left(): number;
            /**
             * Gets the value of the #GtkWidget:margin-right property.
             * @returns The right margin of @widget
             */
            get_margin_right(): number;
            /**
             * Gets the value of the #GtkWidget:margin-start property.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the value of the #GtkWidget:margin-top property.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Returns the modifier mask the `widget’`s windowing system backend
             * uses for a particular purpose.
             *
             * See gdk_keymap_get_modifier_mask().
             * @param intent the use case for the modifier mask
             * @returns the modifier mask used for @intent.
             */
            get_modifier_mask(intent: Gdk.ModifierIntent | null): Gdk.ModifierType;
            /**
             * Returns the current modifier style for the widget. (As set by
             * gtk_widget_modify_style().) If no style has previously set, a new
             * #GtkRcStyle will be created with all values unset, and set as the
             * modifier style for the widget. If you make changes to this rc
             * style, you must call gtk_widget_modify_style(), passing in the
             * returned rc style, to make sure that your changes take effect.
             *
             * Caution: passing the style back to gtk_widget_modify_style() will
             * normally end up destroying it, because gtk_widget_modify_style() copies
             * the passed-in style and sets the copy as the new modifier style,
             * thus dropping any reference to the old modifier style. Add a reference
             * to the modifier style if you want to keep it alive.
             * @returns the modifier style for the widget.     This rc style is owned by the widget. If you want to keep a     pointer to value this around, you must add a refcount using     g_object_ref().
             */
            get_modifier_style(): RcStyle;
            /**
             * Retrieves the name of a widget. See gtk_widget_set_name() for the
             * significance of widget names.
             * @returns name of the widget. This string is owned by GTK+ and should not be modified or freed
             */
            get_name(): string;
            /**
             * Returns the current value of the #GtkWidget:no-show-all property,
             * which determines whether calls to gtk_widget_show_all()
             * will affect this widget.
             * @returns the current value of the “no-show-all” property.
             */
            get_no_show_all(): boolean;
            /**
             * Fetches the requested opacity for this widget.
             * See gtk_widget_set_opacity().
             * @returns the requested opacity for this widget.
             */
            get_opacity(): number;
            /**
             * Gets a #PangoContext with the appropriate font map, font description,
             * and base direction for this widget. Unlike the context returned
             * by gtk_widget_create_pango_context(), this context is owned by
             * the widget (it can be used until the screen for the widget changes
             * or the widget is removed from its toplevel), and will be updated to
             * match any changes to the widget’s attributes. This can be tracked
             * by using the #GtkWidget::screen-changed signal on the widget.
             * @returns the #PangoContext for the widget.
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent container of `widget`.
             * @returns the parent container of @widget, or %NULL
             */
            get_parent(): Widget | null;
            /**
             * Gets `widget’`s parent window, or %NULL if it does not have one.
             * @returns the parent window of @widget, or %NULL if it does not have a parent window.
             */
            get_parent_window(): Gdk.Window | null;
            /**
             * Returns the #GtkWidgetPath representing `widget,` if the widget
             * is not connected to a toplevel widget, a partial path will be
             * created.
             * @returns The #GtkWidgetPath representing @widget
             */
            get_path(): WidgetPath;
            /**
             * Obtains the location of the mouse pointer in widget coordinates.
             * Widget coordinates are a bit odd; for historical reasons, they are
             * defined as `widget->`window coordinates for widgets that return %TRUE for
             * gtk_widget_get_has_window(); and are relative to `widget->`allocation.x,
             * `widget->`allocation.y otherwise.
             */
            get_pointer(): [number, number];
            /**
             * Retrieves a widget’s initial minimum and natural height.
             *
             * This call is specific to width-for-height requests.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             */
            get_preferred_height(): [number, number];
            /**
             * Retrieves a widget’s minimum and natural height and the corresponding baselines if it would be given
             * the specified `width,` or the default height if `width` is -1. The baselines may be -1 which means
             * that no baseline is requested for this widget.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request and GtkWidgetClass::adjust_baseline_request virtual methods
             * and by any #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param width the width which is available for allocation, or -1 if none
             */
            get_preferred_height_and_baseline_for_width(width: number): [number, number, number, number];
            /**
             * Retrieves a widget’s minimum and natural height if it would be given
             * the specified `width`.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param width the width which is available for allocation
             */
            get_preferred_height_for_width(width: number): [number, number];
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as GtkLayout.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since the required
             * height for the natural width is generally smaller than the required height for
             * the minimum width.
             *
             * Use gtk_widget_get_preferred_height_and_baseline_for_width() if you want to support
             * baseline alignment.
             */
            get_preferred_size(): [Requisition | null, Requisition | null];
            /**
             * Retrieves a widget’s initial minimum and natural width.
             *
             * This call is specific to height-for-width requests.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             */
            get_preferred_width(): [number, number];
            /**
             * Retrieves a widget’s minimum and natural width if it would be given
             * the specified `height`.
             *
             * The returned request will be modified by the
             * GtkWidgetClass::adjust_size_request virtual method and by any
             * #GtkSizeGroups that have been applied. That is, the returned request
             * is the one that should be used for layout, not necessarily the one
             * returned by the widget itself.
             * @param height the height which is available for allocation
             */
            get_preferred_width_for_height(height: number): [number, number];
            /**
             * Determines whether `widget` is realized.
             * @returns %TRUE if @widget is realized, %FALSE otherwise
             */
            get_realized(): boolean;
            /**
             * Determines whether `widget` is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See gtk_widget_set_receives_default().
             * @returns %TRUE if @widget acts as the default widget when focused,               %FALSE otherwise
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * #GtkBin widgets generally propagate the preference of
             * their child, container widgets need to request something either in
             * context of their children or in context of their allocation
             * capabilities.
             * @returns The #GtkSizeRequestMode preferred by @widget.
             */
            get_request_mode(): SizeRequestMode;
            /**
             * Retrieves the widget’s requisition.
             *
             * This function should only be used by widget implementations in
             * order to figure whether the widget’s requisition has actually
             * changed after some internal state change (so that they can call
             * gtk_widget_queue_resize() instead of gtk_widget_queue_draw()).
             *
             * Normally, gtk_widget_size_request() should be used.
             */
            get_requisition(): Requisition;
            /**
             * Get the root window where this widget is located. This function can
             * only be called after the widget has been added to a widget
             * hierarchy with #GtkWindow at the top.
             *
             * The root window is useful for such purposes as creating a popup
             * #GdkWindow associated with the window. In general, you should only
             * create display specific resources when a widget has been realized,
             * and you should free those resources when the widget is unrealized.
             * @returns the #GdkWindow root window for the toplevel for this widget.
             */
            get_root_window(): Gdk.Window;
            /**
             * Retrieves the internal scale factor that maps from window coordinates
             * to the actual device pixels. On traditional systems this is 1, on
             * high density outputs, it can be a higher value (typically 2).
             *
             * See gdk_window_get_scale_factor().
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Get the #GdkScreen from the toplevel window associated with
             * this widget. This function can only be called after the widget
             * has been added to a widget hierarchy with a #GtkWindow
             * at the top.
             *
             * In general, you should only create screen specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the #GdkScreen for the toplevel for this widget.
             */
            get_screen(): Gdk.Screen;
            /**
             * Returns the widget’s sensitivity (in the sense of returning
             * the value that has been set using gtk_widget_set_sensitive()).
             *
             * The effective sensitivity of a widget is however determined by both its
             * own and its parent widget’s sensitivity. See gtk_widget_is_sensitive().
             * @returns %TRUE if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for this widget.
             *
             * Note that this function can only be called when the #GtkWidget
             * is attached to a toplevel, since the settings object is specific
             * to a particular #GdkScreen.
             * @returns the relevant #GtkSettings object
             */
            get_settings(): Settings;
            /**
             * Gets the size request that was explicitly set for the widget using
             * gtk_widget_set_size_request(). A value of -1 stored in `width` or
             * `height` indicates that that dimension has not been set explicitly
             * and the natural requisition of the widget will be used instead. See
             * gtk_widget_set_size_request(). To get the size a widget will
             * actually request, call gtk_widget_get_preferred_size() instead of
             * this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget’s state. See gtk_widget_set_state().
             * @returns the state of @widget.
             */
            get_state(): StateType;
            /**
             * Returns the widget state as a flag set. It is worth mentioning
             * that the effective %GTK_STATE_FLAG_INSENSITIVE state will be
             * returned, that is, also based on parent insensitivity, even if
             * `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * #GtkStateFlags to pass to a #GtkStyleContext method, you
             * should look at gtk_style_context_get_state().
             * @returns The state flags for widget
             */
            get_state_flags(): StateFlags;
            /**
             * Simply an accessor function that returns `widget->`style.
             * @returns the widget’s #GtkStyle
             */
            get_style(): Style;
            /**
             * Returns the style context associated to `widget`. The returned object is
             * guaranteed to be the same for the lifetime of `widget`.
             * @returns a #GtkStyleContext. This memory is owned by @widget and          must not be freed.
             */
            get_style_context(): StyleContext;
            /**
             * Returns %TRUE if `widget` is multiple pointer aware. See
             * gtk_widget_set_support_multidevice() for more information.
             * @returns %TRUE if @widget is multidevice aware.
             */
            get_support_multidevice(): boolean;
            /**
             * Fetch an object build from the template XML for `widget_type` in this `widget` instance.
             *
             * This will only report children which were previously declared with
             * gtk_widget_class_bind_template_child_full() or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private to the `widget_type` which
             * declared the child and is meant for language bindings which cannot easily make use
             * of the GObject structure offsets.
             * @param widget_type The #GType to get a template child for
             * @param name The “id” of the child defined in the template XML
             * @returns The object built in the template XML with the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for `widget`.
             * @returns the tooltip text, or %NULL. You should free the   returned string with g_free() when done.
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for `widget`.
             * @returns the tooltip text, or %NULL. You should free the   returned string with g_free() when done.
             */
            get_tooltip_text(): string | null;
            /**
             * Returns the #GtkWindow of the current tooltip. This can be the
             * GtkWindow created by default, or the custom tooltip window set
             * using gtk_widget_set_tooltip_window().
             * @returns The #GtkWindow of the current tooltip.
             */
            get_tooltip_window(): Window;
            /**
             * This function returns the topmost widget in the container hierarchy
             * `widget` is a part of. If `widget` has no parent widgets, it will be
             * returned as the topmost widget. No reference will be added to the
             * returned widget; it should not be unreferenced.
             *
             * Note the difference in behavior vs. gtk_widget_get_ancestor();
             * `gtk_widget_get_ancestor (widget, GTK_TYPE_WINDOW)`
             * would return
             * %NULL if `widget` wasn’t inside a toplevel window, and if the
             * window was inside a #GtkWindow-derived widget which was in turn
             * inside the toplevel #GtkWindow. While the second case may
             * seem unlikely, it actually happens when a #GtkPlug is embedded
             * inside a #GtkSocket within the same application.
             *
             * To reliably find the toplevel #GtkWindow, use
             * gtk_widget_get_toplevel() and call GTK_IS_WINDOW()
             * on the result. For instance, to get the title of a widget's toplevel
             * window, one might use:
             *
             * ```c
             * static const char *
             * get_widget_toplevel_title (GtkWidget *widget)
             * {
             *   GtkWidget *toplevel = gtk_widget_get_toplevel (widget);
             *   if (GTK_IS_WINDOW (toplevel))
             *     {
             *       return gtk_window_get_title (GTK_WINDOW (toplevel));
             *     }
             *
             *   return NULL;
             * }
             * ```
             *
             * @returns the topmost ancestor of @widget, or @widget itself    if there’s no ancestor.
             */
            get_toplevel(): Widget;
            /**
             * Gets the value of the #GtkWidget:valign property.
             *
             * For backwards compatibility reasons this method will never return
             * %GTK_ALIGN_BASELINE, but instead it will convert it to
             * %GTK_ALIGN_FILL. If your widget want to support baseline aligned
             * children it must use gtk_widget_get_valign_with_baseline(), or
             * `g_object_get (widget, "valign", &value, NULL)`, which will
             * also report the true value.
             * @returns the vertical alignment of @widget, ignoring baseline alignment
             */
            get_valign(): Align;
            /**
             * Gets the value of the #GtkWidget:valign property, including
             * %GTK_ALIGN_BASELINE.
             * @returns the vertical alignment of @widget
             */
            get_valign_with_baseline(): Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See gtk_widget_get_hexpand() for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether gtk_widget_set_vexpand() has been used to
             * explicitly set the expand flag on this widget.
             *
             * See gtk_widget_get_hexpand_set() for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible. If you want to
             * take into account whether the widget’s parent is also marked as
             * visible, use gtk_widget_is_visible() instead.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See gtk_widget_set_visible().
             * @returns %TRUE if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Gets the visual that will be used to render `widget`.
             * @returns the visual for @widget
             */
            get_visual(): Gdk.Visual;
            /**
             * Returns the widget’s window if it is realized, %NULL otherwise
             * @returns @widget’s window.
             */
            get_window(): Gdk.Window | null;
            /**
             * Makes `widget` the current grabbed widget.
             *
             * This means that interaction with other widgets in the same
             * application is blocked and mouse as well as keyboard events
             * are delivered to this widget.
             *
             * If `widget` is not sensitive, it is not set as the current
             * grabbed widget and this function does nothing.
             */
            grab_add(): void;
            /**
             * Causes `widget` to become the default widget. `widget` must be able to be
             * a default widget; typically you would ensure this yourself
             * by calling gtk_widget_set_can_default() with a %TRUE value.
             * The default widget is activated when
             * the user presses Enter in a window. Default widgets must be
             * activatable, that is, gtk_widget_activate() should affect them. Note
             * that #GtkEntry widgets require the “activates-default” property
             * set to %TRUE before they activate the default widget when Enter
             * is pressed and the #GtkEntry is focused.
             */
            grab_default(): void;
            /**
             * Causes `widget` to have the keyboard focus for the #GtkWindow it's
             * inside. `widget` must be a focusable widget, such as a #GtkEntry;
             * something like #GtkFrame won’t work.
             *
             * More precisely, it must have the %GTK_CAN_FOCUS flag set. Use
             * gtk_widget_set_can_focus() to modify that flag.
             *
             * The widget also needs to be realized and mapped. This is indicated by the
             * related signals. Grabbing the focus immediately after creating the widget
             * will likely fail and cause critical warnings.
             */
            grab_focus(): void;
            /**
             * Removes the grab from the given widget.
             *
             * You have to pair calls to gtk_grab_add() and gtk_grab_remove().
             *
             * If `widget` does not have the grab, this function does nothing.
             */
            grab_remove(): void;
            /**
             * Determines whether the widget is currently grabbing events, so it
             * is the only widget receiving input events (keyboard and mouse).
             *
             * See also gtk_grab_add().
             * @returns %TRUE if the widget is in the grab_widgets stack
             */
            has_grab(): boolean;
            /**
             * Determines if the widget style has been looked up through the rc mechanism.
             * @returns %TRUE if the widget has been looked up through the rc   mechanism, %FALSE otherwise.
             */
            has_rc_style(): boolean;
            /**
             * Checks whether there is a #GdkScreen is associated with
             * this widget. All toplevel widgets have an associated
             * screen, and all widgets added into a hierarchy with a toplevel
             * window at the top.
             * @returns %TRUE if there is a #GdkScreen associated   with the widget.
             */
            has_screen(): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus. This is a convenience function for
             * use in ::draw handlers that takes into account whether focus
             * indication should currently be shown in the toplevel window of
             * `widget`. See gtk_window_get_focus_visible() for more information
             * about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * gtk_widget_has_focus().
             * @returns %TRUE if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of gtk_widget_show(), causing the widget to be
             * hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Utility function; intended to be connected to the #GtkWidget::delete-event
             * signal on a #GtkWindow. The function calls gtk_widget_hide() on its
             * argument, then returns %TRUE. If connected to ::delete-event, the
             * result is that clicking the close button for a window (on the
             * window frame, top right corner usually) will hide but not destroy
             * the window. By default, GTK+ destroys windows when ::delete-event
             * is received.
             * @returns %TRUE
             */
            hide_on_delete(): boolean;
            /**
             * Returns whether the widget is currently being destroyed.
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns %TRUE if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates. This
             * function must be called in the instance initializer for any
             * class which assigned itself a template using gtk_widget_class_set_template()
             *
             * It is important to call this function in the instance initializer
             * of a #GtkWidget subclass and not in #GObject.constructed() or
             * #GObject.constructor() for two reasons.
             *
             * One reason is that generally derived widgets will assume that parent
             * class composite widgets have been created in their instance
             * initializers.
             *
             * Another reason is that when calling g_object_new() on a widget with
             * composite templates, it’s important to build the composite widgets
             * before the construct properties are set. Properties passed to g_object_new()
             * should take precedence over properties set in the private template XML.
             */
            init_template(): void;
            /**
             * Sets an input shape for this widget’s GDK window. This allows for
             * windows which react to mouse click in a nonrectangular region, see
             * gdk_window_input_shape_combine_region() for more information.
             * @param region shape to be added, or %NULL to remove an existing shape
             */
            input_shape_combine_region(region?: cairo.Region | null): void;
            /**
             * Inserts `group` into `widget`. Children of `widget` that implement
             * #GtkActionable can then be associated with actions in `group` by
             * setting their “action-name” to
             * `prefix`.`action-name`.
             *
             * If `group` is %NULL, a previously inserted group for `name` is removed
             * from `widget`.
             * @param name the prefix for actions in @group
             * @param group a #GActionGroup, or %NULL
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Computes the intersection of a `widget’`s area and `area,` storing
             * the intersection in `intersection,` and returns %TRUE if there was
             * an intersection.  `intersection` may be %NULL if you’re only
             * interested in whether there was an intersection.
             * @param area a rectangle
             * @returns %TRUE if there was an intersection
             */
            intersect(area: Gdk.Rectangle): [boolean, Gdk.Rectangle | null];
            /**
             * Determines whether `widget` is somewhere inside `ancestor,` possibly with
             * intermediate containers.
             * @param ancestor another #GtkWidget
             * @returns %TRUE if @ancestor contains @widget as a child,    grandchild, great grandchild, etc.
             */
            is_ancestor(ancestor: Widget): boolean;
            /**
             * Whether `widget` can rely on having its alpha channel
             * drawn correctly. On X11 this function returns whether a
             * compositing manager is running for `widget’`s screen.
             *
             * Please note that the semantics of this call will change
             * in the future if used on a widget that has a composited
             * window in its hierarchy (as set by gdk_window_set_composited()).
             * @returns %TRUE if the widget can rely on its alpha channel being drawn correctly.
             */
            is_composited(): boolean;
            /**
             * Determines whether `widget` can be drawn to. A widget can be drawn
             * to if it is mapped and visible.
             * @returns %TRUE if @widget is drawable, %FALSE otherwise
             */
            is_drawable(): boolean;
            /**
             * Returns the widget’s effective sensitivity, which means
             * it is sensitive itself and also its parent widget is sensitive
             * @returns %TRUE if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether `widget` is a toplevel widget.
             *
             * Currently only #GtkWindow and #GtkInvisible (and out-of-process
             * #GtkPlugs) are toplevel widgets. Toplevel widgets have no parent
             * widget.
             * @returns %TRUE if @widget is a toplevel, %FALSE otherwise
             */
            is_toplevel(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also gtk_widget_get_visible() and gtk_widget_set_visible()
             * @returns %TRUE if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * This function should be called whenever keyboard navigation within
             * a single widget hits a boundary. The function emits the
             * #GtkWidget::keynav-failed signal on the widget and its return
             * value should be interpreted in a way similar to the return value of
             * gtk_widget_child_focus():
             *
             * When %TRUE is returned, stay in the widget, the failed keyboard
             * navigation is OK and/or there is nowhere we can/should move the
             * focus to.
             *
             * When %FALSE is returned, the caller should continue with keyboard
             * navigation outside the widget, e.g. by calling
             * gtk_widget_child_focus() on the widget’s toplevel.
             *
             * The default ::keynav-failed handler returns %FALSE for
             * %GTK_DIR_TAB_FORWARD and %GTK_DIR_TAB_BACKWARD. For the other
             * values of #GtkDirectionType it returns %TRUE.
             *
             * Whenever the default handler returns %TRUE, it also calls
             * gtk_widget_error_bell() to notify the user of the failed keyboard
             * navigation.
             *
             * A use case for providing an own implementation of ::keynav-failed
             * (either by connecting to it or by overriding it) would be a row of
             * #GtkEntry widgets where the user should be able to navigate the
             * entire row with the cursor keys, as e.g. known from user interfaces
             * that require entering license keys.
             * @param direction direction of focus movement
             * @returns %TRUE if stopping keyboard navigation is fine, %FALSE               if the emitting widget should try to handle the keyboard               navigation attempt in its parent container(s).
             */
            keynav_failed(direction: DirectionType | null): boolean;
            /**
             * Lists the closures used by `widget` for accelerator group connections
             * with gtk_accel_group_connect_by_path() or gtk_accel_group_connect().
             * The closures can be used to monitor accelerator changes on `widget,`
             * by connecting to the `GtkAccelGroup:`:accel-changed signal of the
             * #GtkAccelGroup of a closure which can be found out with
             * gtk_accel_group_from_accel_closure().
             * @returns a newly allocated #GList of closures
             */
            list_accel_closures(): GObject.Closure[];
            /**
             * Retrieves a %NULL-terminated array of strings containing the prefixes of
             * #GActionGroup's available to `widget`.
             * @returns a %NULL-terminated array of strings.
             */
            list_action_prefixes(): string[];
            /**
             * Returns a newly allocated list of the widgets, normally labels, for
             * which this widget is the target of a mnemonic (see for example,
             * gtk_label_set_mnemonic_widget()).
             *
             * The widgets in the list are not individually referenced. If you
             * want to iterate through the list and perform actions involving
             * callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result,
             * (GFunc)g_object_ref, NULL)` first, and then unref all the
             * widgets afterwards.
             * @returns the list of  mnemonic labels; free this list  with g_list_free() when you are done with it.
             */
            list_mnemonic_labels(): Widget[];
            /**
             * This function is only for use in widget implementations. Causes
             * a widget to be mapped if it isn’t already.
             */
            map(): void;
            /**
             * Emits the #GtkWidget::mnemonic-activate signal.
             * @param group_cycling %TRUE if there are other widgets with the same mnemonic
             * @returns %TRUE if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            // Conflicted with Gtk.Window.mnemonic_activate
            mnemonic_activate(...args: never[]): any;
            /**
             * Sets the base color for a widget in a particular state.
             * All other style values are left untouched. The base color
             * is the background color used along with the text color
             * (see gtk_widget_modify_text()) for widgets such as #GtkEntry
             * and #GtkTextView. See also gtk_widget_modify_style().
             *
             * > Note that “no window” widgets (which have the %GTK_NO_WINDOW
             * > flag set) draw on their parent container’s window and thus may
             * > not draw any background themselves. This is the case for e.g.
             * > #GtkLabel.
             * >
             * > To modify the background of such widgets, you have to set the
             * > base color on their parent; if you want to set the background
             * > of a rectangular area around a label, try placing the label in
             * > a #GtkEventBox widget and setting the base color on that.
             * @param state the state for which to set the base color
             * @param color the color to assign (does not need to     be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_base().
             */
            modify_base(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the background color for a widget in a particular state.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             *
             * > Note that “no window” widgets (which have the %GTK_NO_WINDOW
             * > flag set) draw on their parent container’s window and thus may
             * > not draw any background themselves. This is the case for e.g.
             * > #GtkLabel.
             * >
             * > To modify the background of such widgets, you have to set the
             * > background color on their parent; if you want to set the background
             * > of a rectangular area around a label, try placing the label in
             * > a #GtkEventBox widget and setting the background color on that.
             * @param state the state for which to set the background color
             * @param color the color to assign (does not need     to be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_bg().
             */
            modify_bg(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the cursor color to use in a widget, overriding the #GtkWidget
             * cursor-color and secondary-cursor-color
             * style properties.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             * @param primary the color to use for primary cursor (does not     need to be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_cursor().
             * @param secondary the color to use for secondary cursor (does     not need to be allocated), or %NULL to undo the effect of     previous calls to of gtk_widget_modify_cursor().
             */
            modify_cursor(primary?: Gdk.Color | null, secondary?: Gdk.Color | null): void;
            /**
             * Sets the foreground color for a widget in a particular state.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             * @param state the state for which to set the foreground color
             * @param color the color to assign (does not need to be allocated),     or %NULL to undo the effect of previous calls to     of gtk_widget_modify_fg().
             */
            modify_fg(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the font to use for a widget.
             *
             * All other style values are left untouched.
             * See also gtk_widget_modify_style().
             * @param font_desc the font description to use, or %NULL     to undo the effect of previous calls to gtk_widget_modify_font()
             */
            modify_font(font_desc?: Pango.FontDescription | null): void;
            /**
             * Modifies style values on the widget.
             *
             * Modifications made using this technique take precedence over
             * style values set via an RC file, however, they will be overridden
             * if a style is explicitly set on the widget using gtk_widget_set_style().
             * The #GtkRcStyle-struct is designed so each field can either be
             * set or unset, so it is possible, using this function, to modify some
             * style values and leave the others unchanged.
             *
             * Note that modifications made with this function are not cumulative
             * with previous calls to gtk_widget_modify_style() or with such
             * functions as gtk_widget_modify_fg(). If you wish to retain
             * previous values, you must first call gtk_widget_get_modifier_style(),
             * make your modifications to the returned style, then call
             * gtk_widget_modify_style() with that style. On the other hand,
             * if you first call gtk_widget_modify_style(), subsequent calls
             * to such functions gtk_widget_modify_fg() will have a cumulative
             * effect with the initial modifications.
             * @param style the #GtkRcStyle-struct holding the style modifications
             */
            modify_style(style: RcStyle): void;
            /**
             * Sets the text color for a widget in a particular state.
             *
             * All other style values are left untouched.
             * The text color is the foreground color used along with the
             * base color (see gtk_widget_modify_base()) for widgets such
             * as #GtkEntry and #GtkTextView.
             * See also gtk_widget_modify_style().
             * @param state the state for which to set the text color
             * @param color the color to assign (does not need to     be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_modify_text().
             */
            modify_text(state: StateType | null, color?: Gdk.Color | null): void;
            /**
             * Sets the background color to use for a widget.
             *
             * All other style values are left untouched.
             * See gtk_widget_override_color().
             * @param state the state for which to set the background color
             * @param color the color to assign, or %NULL to undo the effect     of previous calls to gtk_widget_override_background_color()
             */
            override_background_color(state: StateFlags | null, color?: Gdk.RGBA | null): void;
            /**
             * Sets the color to use for a widget.
             *
             * All other style values are left untouched.
             *
             * This function does not act recursively. Setting the color of a
             * container does not affect its children. Note that some widgets that
             * you may not think of as containers, for instance #GtkButtons,
             * are actually containers.
             *
             * This API is mostly meant as a quick way for applications to
             * change a widget appearance. If you are developing a widgets
             * library and intend this change to be themeable, it is better
             * done by setting meaningful CSS classes in your
             * widget/container implementation through gtk_style_context_add_class().
             *
             * This way, your widget library can install a #GtkCssProvider
             * with the %GTK_STYLE_PROVIDER_PRIORITY_FALLBACK priority in order
             * to provide a default styling for those widgets that need so, and
             * this theming may fully overridden by the user’s theme.
             *
             * Note that for complex widgets this may bring in undesired
             * results (such as uniform background color everywhere), in
             * these cases it is better to fully style such widgets through a
             * #GtkCssProvider with the %GTK_STYLE_PROVIDER_PRIORITY_APPLICATION
             * priority.
             * @param state the state for which to set the color
             * @param color the color to assign, or %NULL to undo the effect     of previous calls to gtk_widget_override_color()
             */
            override_color(state: StateFlags | null, color?: Gdk.RGBA | null): void;
            /**
             * Sets the cursor color to use in a widget, overriding the
             * cursor-color and secondary-cursor-color
             * style properties. All other style values are left untouched.
             * See also gtk_widget_modify_style().
             *
             * Note that the underlying properties have the #GdkColor type,
             * so the alpha value in `primary` and `secondary` will be ignored.
             * @param cursor the color to use for primary cursor (does not need to be     allocated), or %NULL to undo the effect of previous calls to     of gtk_widget_override_cursor().
             * @param secondary_cursor the color to use for secondary cursor (does not     need to be allocated), or %NULL to undo the effect of previous     calls to of gtk_widget_override_cursor().
             */
            override_cursor(cursor?: Gdk.RGBA | null, secondary_cursor?: Gdk.RGBA | null): void;
            /**
             * Sets the font to use for a widget. All other style values are
             * left untouched. See gtk_widget_override_color().
             * @param font_desc the font description to use, or %NULL to undo     the effect of previous calls to gtk_widget_override_font()
             */
            override_font(font_desc?: Pango.FontDescription | null): void;
            /**
             * Sets a symbolic color for a widget.
             *
             * All other style values are left untouched.
             * See gtk_widget_override_color() for overriding the foreground
             * or background color.
             * @param name the name of the symbolic color to modify
             * @param color the color to assign (does not need     to be allocated), or %NULL to undo the effect of previous     calls to gtk_widget_override_symbolic_color()
             */
            override_symbolic_color(name: string, color?: Gdk.RGBA | null): void;
            /**
             * Obtains the full path to `widget`. The path is simply the name of a
             * widget and all its parents in the container hierarchy, separated by
             * periods. The name of a widget comes from
             * gtk_widget_get_name(). Paths are used to apply styles to a widget
             * in gtkrc configuration files. Widget names are the type of the
             * widget by default (e.g. “GtkButton”) or can be set to an
             * application-specific value with gtk_widget_set_name(). By setting
             * the name of a widget, you allow users or theme authors to apply
             * styles to that specific widget in their gtkrc
             * file. `path_reversed_p` fills in the path in reverse order,
             * i.e. starting with `widget’`s name instead of starting with the name
             * of `widget’`s outermost ancestor.
             */
            path(): [number, string, string];
            /**
             * This function is only for use in widget implementations.
             *
             * Flags the widget for a rerun of the GtkWidgetClass::size_allocate
             * function. Use this function instead of gtk_widget_queue_resize()
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is gtk_widget_set_halign().
             */
            queue_allocate(): void;
            /**
             * Mark `widget` as needing to recompute its expand flags. Call
             * this function when setting legacy expand child properties
             * on the child of a container.
             *
             * See gtk_widget_compute_expand().
             */
            queue_compute_expand(): void;
            /**
             * Equivalent to calling gtk_widget_queue_draw_area() for the
             * entire area of a widget.
             */
            queue_draw(): void;
            /**
             * Convenience function that calls gtk_widget_queue_draw_region() on
             * the region created from the given coordinates.
             *
             * The region here is specified in widget coordinates.
             * Widget coordinates are a bit odd; for historical reasons, they are
             * defined as `widget->`window coordinates for widgets that return %TRUE for
             * gtk_widget_get_has_window(), and are relative to `widget->`allocation.x,
             * `widget->`allocation.y otherwise.
             *
             * `width` or `height` may be 0, in this case this function does
             * nothing. Negative values for `width` and `height` are not allowed.
             * @param x x coordinate of upper-left corner of rectangle to redraw
             * @param y y coordinate of upper-left corner of rectangle to redraw
             * @param width width of region to draw
             * @param height height of region to draw
             */
            queue_draw_area(x: number, y: number, width: number, height: number): void;
            /**
             * Invalidates the area of `widget` defined by `region` by calling
             * gdk_window_invalidate_region() on the widget’s window and all its
             * child windows. Once the main loop becomes idle (after the current
             * batch of events has been processed, roughly), the window will
             * receive expose events for the union of all regions that have been
             * invalidated.
             *
             * Normally you would only use this function in widget
             * implementations. You might also use it to schedule a redraw of a
             * #GtkDrawingArea or some portion thereof.
             * @param region region to draw
             */
            queue_draw_region(region: cairo.Region): void;
            /**
             * This function is only for use in widget implementations.
             * Flags a widget to have its size renegotiated; should
             * be called when a widget for some reason has a new size request.
             * For example, when you change the text in a #GtkLabel, #GtkLabel
             * queues a resize to ensure there’s enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the GtkWidgetClass::size_allocate
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * GtkWidgetClass::size_allocate will be silently ignored.
             */
            queue_resize(): void;
            /**
             * This function works like gtk_widget_queue_resize(),
             * except that the widget is not invalidated.
             */
            queue_resize_no_redraw(): void;
            /**
             * Creates the GDK (windowing system) resources associated with a
             * widget.  For example, `widget->`window will be created when a widget
             * is realized.  Normally realization happens implicitly; if you show
             * a widget and all its parent containers, then the widget will be
             * realized and mapped automatically.
             *
             * Realizing a widget requires all
             * the widget’s parent widgets to be realized; calling
             * gtk_widget_realize() realizes the widget’s parents in addition to
             * `widget` itself. If a widget is not yet inside a toplevel window
             * when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * #GtkWidget::draw. Or simply g_signal_connect () to the
             * #GtkWidget::realize signal.
             */
            realize(): void;
            /**
             * Computes the intersection of a `widget’`s area and `region,` returning
             * the intersection. The result may be empty, use cairo_region_is_empty() to
             * check.
             * @param region a #cairo_region_t, in the same coordinate system as          @widget->allocation. That is, relative to @widget->window          for widgets which return %FALSE from gtk_widget_get_has_window();          relative to the parent window of @widget->window otherwise.
             * @returns A newly allocated region holding the intersection of @widget     and @region.
             */
            region_intersect(region: cairo.Region): cairo.Region;
            /**
             * Registers a #GdkWindow with the widget and sets it up so that
             * the widget receives events for it. Call gtk_widget_unregister_window()
             * when destroying the window.
             *
             * Before 3.8 you needed to call gdk_window_set_user_data() directly to set
             * this up. This is now deprecated and you should use gtk_widget_register_window()
             * instead. Old code will keep working as is, although some new features like
             * transparency might not work perfectly.
             * @param window a #GdkWindow
             */
            register_window(window: Gdk.Window): void;
            /**
             * Removes an accelerator from `widget,` previously installed with
             * gtk_widget_add_accelerator().
             * @param accel_group accel group for this widget
             * @param accel_key GDK keyval of the accelerator
             * @param accel_mods modifier key combination of the accelerator
             * @returns whether an accelerator was installed and could be removed
             */
            remove_accelerator(
                accel_group: AccelGroup,
                accel_key: number,
                accel_mods: Gdk.ModifierType | null,
            ): boolean;
            /**
             * Removes a widget from the list of mnemonic labels for
             * this widget. (See gtk_widget_list_mnemonic_labels()). The widget
             * must have previously been added to the list with
             * gtk_widget_add_mnemonic_label().
             * @param label a #GtkWidget that was previously set as a mnemonic label for         @widget with gtk_widget_add_mnemonic_label().
             */
            remove_mnemonic_label(label: Widget): void;
            /**
             * Removes a tick callback previously registered with
             * gtk_widget_add_tick_callback().
             * @param id an id returned by gtk_widget_add_tick_callback()
             */
            remove_tick_callback(id: number): void;
            /**
             * A convenience function that uses the theme settings for `widget`
             * to look up `stock_id` and render it to a pixbuf. `stock_id` should
             * be a stock icon ID such as #GTK_STOCK_OPEN or #GTK_STOCK_OK. `size`
             * should be a size such as #GTK_ICON_SIZE_MENU. `detail` should be a
             * string that identifies the widget or code doing the rendering, so
             * that theme engines can special-case rendering for that widget or
             * code.
             *
             * The pixels in the returned #GdkPixbuf are shared with the rest of
             * the application and should not be modified. The pixbuf should be
             * freed after use with g_object_unref().
             * @param stock_id a stock ID
             * @param size a stock size (#GtkIconSize). A size of `(GtkIconSize)-1`     means render at the size of the source and don’t scale (if there are     multiple source sizes, GTK+ picks one of the available sizes).
             * @param detail render detail to pass to theme engine
             * @returns a new pixbuf, or %NULL if the     stock ID wasn’t known
             */
            render_icon(stock_id: string, size: number, detail?: string | null): GdkPixbuf.Pixbuf | null;
            /**
             * A convenience function that uses the theme engine and style
             * settings for `widget` to look up `stock_id` and render it to
             * a pixbuf. `stock_id` should be a stock icon ID such as
             * #GTK_STOCK_OPEN or #GTK_STOCK_OK. `size` should be a size
             * such as #GTK_ICON_SIZE_MENU.
             *
             * The pixels in the returned #GdkPixbuf are shared with the rest of
             * the application and should not be modified. The pixbuf should be freed
             * after use with g_object_unref().
             * @param stock_id a stock ID
             * @param size a stock size (#GtkIconSize). A size of `(GtkIconSize)-1`     means render at the size of the source and don’t scale (if there are     multiple source sizes, GTK+ picks one of the available sizes).
             * @returns a new pixbuf, or %NULL if the     stock ID wasn’t known
             */
            render_icon_pixbuf(stock_id: string, size: number): GdkPixbuf.Pixbuf | null;
            /**
             * Moves a widget from one #GtkContainer to another, handling reference
             * count issues to avoid destroying the widget.
             * @param new_parent a #GtkContainer to move the widget into
             */
            reparent(new_parent: Widget): void;
            /**
             * Reset the styles of `widget` and all descendents, so when
             * they are looked up again, they get the correct values
             * for the currently loaded RC file settings.
             *
             * This function is not useful for applications.
             */
            reset_rc_styles(): void;
            /**
             * Updates the style context of `widget` and all descendants
             * by updating its widget path. #GtkContainers may want
             * to use this on a child when reordering it in a way that a different
             * style might apply to it. See also gtk_container_get_path_for_child().
             */
            reset_style(): void;
            /**
             * Very rarely-used function. This function is used to emit
             * an expose event on a widget. This function is not normally used
             * directly. The only time it is used is when propagating an expose
             * event to a windowless child widget (gtk_widget_get_has_window() is %FALSE),
             * and that is normally done using gtk_container_propagate_draw().
             *
             * If you want to force an area of a window to be redrawn,
             * use gdk_window_invalidate_rect() or gdk_window_invalidate_region().
             * To cause the redraw to be done immediately, follow that call
             * with a call to gdk_window_process_updates().
             * @param event a expose #GdkEvent
             * @returns return from the event signal emission (%TRUE if   the event was handled)
             */
            send_expose(event: Gdk.Event): number;
            /**
             * Sends the focus change `event` to `widget`
             *
             * This function is not meant to be used by applications. The only time it
             * should be used is when it is necessary for a #GtkWidget to assign focus
             * to a widget that is semantically owned by the first widget even though
             * it’s not a direct child - for instance, a search entry in a floating
             * window similar to the quick search in #GtkTreeView.
             *
             * An example of its usage is:
             *
             *
             * ```c
             *   GdkEvent *fevent = gdk_event_new (GDK_FOCUS_CHANGE);
             *
             *   fevent->focus_change.type = GDK_FOCUS_CHANGE;
             *   fevent->focus_change.in = TRUE;
             *   fevent->focus_change.window = _gtk_widget_get_window (widget);
             *   if (fevent->focus_change.window != NULL)
             *     g_object_ref (fevent->focus_change.window);
             *
             *   gtk_widget_send_focus_change (widget, fevent);
             *
             *   gdk_event_free (event);
             * ```
             *
             * @param event a #GdkEvent of type GDK_FOCUS_CHANGE
             * @returns the return value from the event signal emission: %TRUE   if the event was handled, and %FALSE otherwise
             */
            send_focus_change(event: Gdk.Event): boolean;
            /**
             * Given an accelerator group, `accel_group,` and an accelerator path,
             * `accel_path,` sets up an accelerator in `accel_group` so whenever the
             * key binding that is defined for `accel_path` is pressed, `widget`
             * will be activated.  This removes any accelerators (for any
             * accelerator group) installed by previous calls to
             * gtk_widget_set_accel_path(). Associating accelerators with
             * paths allows them to be modified by the user and the modifications
             * to be saved for future use. (See gtk_accel_map_save().)
             *
             * This function is a low level function that would most likely
             * be used by a menu creation system like #GtkUIManager. If you
             * use #GtkUIManager, setting up accelerator paths will be done
             * automatically.
             *
             * Even when you you aren’t using #GtkUIManager, if you only want to
             * set up accelerators on menu items gtk_menu_item_set_accel_path()
             * provides a somewhat more convenient interface.
             *
             * Note that `accel_path` string will be stored in a #GQuark. Therefore, if you
             * pass a static string, you can save some memory by interning it first with
             * g_intern_static_string().
             * @param accel_path path used to look up the accelerator
             * @param accel_group a #GtkAccelGroup.
             */
            set_accel_path(accel_path?: string | null, accel_group?: AccelGroup | null): void;
            /**
             * Sets the widget’s allocation.  This should not be used
             * directly, but from within a widget’s size_allocate method.
             *
             * The allocation set should be the “adjusted” or actual
             * allocation. If you’re implementing a #GtkContainer, you want to use
             * gtk_widget_size_allocate() instead of gtk_widget_set_allocation().
             * The GtkWidgetClass::adjust_size_allocation virtual method adjusts the
             * allocation inside gtk_widget_size_allocate() to create an adjusted
             * allocation.
             * @param allocation a pointer to a #GtkAllocation to copy from
             */
            set_allocation(allocation: Allocation): void;
            /**
             * Sets whether the application intends to draw on the widget in
             * an #GtkWidget::draw handler.
             *
             * This is a hint to the widget and does not affect the behavior of
             * the GTK+ core; many widgets ignore this flag entirely. For widgets
             * that do pay attention to the flag, such as #GtkEventBox and #GtkWindow,
             * the effect is to suppress default themed drawing of the widget's
             * background. (Children of the widget will still be drawn.) The application
             * is then entirely responsible for drawing the widget background.
             *
             * Note that the background is still drawn when the widget is mapped.
             * @param app_paintable %TRUE if the application will paint on the widget
             */
            set_app_paintable(app_paintable: boolean): void;
            /**
             * Specifies whether `widget` can be a default widget. See
             * gtk_widget_grab_default() for details about the meaning of
             * “default”.
             * @param can_default whether or not @widget can be a default widget.
             */
            set_can_default(can_default: boolean): void;
            /**
             * Specifies whether `widget` can own the input focus. See
             * gtk_widget_grab_focus() for actually setting the input focus on a
             * widget.
             * @param can_focus whether or not @widget can own the input focus.
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether `widget` should be mapped along with its when its parent
             * is mapped and `widget` has been shown with gtk_widget_show().
             *
             * The child visibility can be set for widget before it is added to
             * a container with gtk_widget_set_parent(), to avoid mapping
             * children unnecessary before immediately unmapping them. However
             * it will be reset to its default state of %TRUE when the widget
             * is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for container implementations and
             * never should be called by an application.
             * @param is_visible if %TRUE, @widget should be mapped along with its parent.
             */
            set_child_visible(is_visible: boolean): void;
            /**
             * Sets the widget’s clip.  This must not be used directly,
             * but from within a widget’s size_allocate method.
             * It must be called after gtk_widget_set_allocation() (or after chaining up
             * to the parent class), because that function resets the clip.
             *
             * The clip set should be the area that `widget` draws on. If `widget` is a
             * #GtkContainer, the area must contain all children's clips.
             *
             * If this function is not called by `widget` during a ::size-allocate handler,
             * the clip will be set to `widget'`s allocation.
             * @param clip a pointer to a #GtkAllocation to copy from
             */
            set_clip(clip: Allocation): void;
            /**
             * Sets a widgets composite name. The widget must be
             * a composite child of its parent; see gtk_widget_push_composite_child().
             * @param name the name to set
             */
            set_composite_name(name: string): void;
            /**
             * Enables or disables a #GdkDevice to interact with `widget`
             * and all its children.
             *
             * It does so by descending through the #GdkWindow hierarchy
             * and enabling the same mask that is has for core events
             * (i.e. the one that gdk_window_get_events() returns).
             * @param device a #GdkDevice
             * @param enabled whether to enable the device
             */
            set_device_enabled(device: Gdk.Device, enabled: boolean): void;
            /**
             * Sets the device event mask (see #GdkEventMask) for a widget. The event
             * mask determines which events a widget will receive from `device`. Keep
             * in mind that different widgets have different default event masks, and by
             * changing the event mask you may disrupt a widget’s functionality,
             * so be careful. This function must be called while a widget is
             * unrealized. Consider gtk_widget_add_device_events() for widgets that are
             * already realized, or if you want to preserve the existing event
             * mask. This function can’t be used with windowless widgets (which return
             * %FALSE from gtk_widget_get_has_window());
             * to get events on those widgets, place them inside a #GtkEventBox
             * and receive events on the event box.
             * @param device a #GdkDevice
             * @param events event mask
             */
            set_device_events(device: Gdk.Device, events: Gdk.EventMask | null): void;
            /**
             * Sets the reading direction on a particular widget. This direction
             * controls the primary direction for widgets containing text,
             * and also the direction in which the children of a container are
             * packed. The ability to set the direction is present in order
             * so that correct localization into languages with right-to-left
             * reading directions can be done. Generally, applications will
             * let the default reading direction present, except for containers
             * where the containers are arranged in an order that is explicitly
             * visual rather than logical (such as buttons for text justification).
             *
             * If the direction is set to %GTK_TEXT_DIR_NONE, then the value
             * set by gtk_widget_set_default_direction() will be used.
             * @param dir the new direction
             */
            set_direction(dir: TextDirection | null): void;
            /**
             * Widgets are double buffered by default; you can use this function
             * to turn off the buffering. “Double buffered” simply means that
             * gdk_window_begin_draw_frame() and gdk_window_end_draw_frame() are called
             * automatically around expose events sent to the
    