// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Ring Ring with all it's children resources
//
// swagger:model Ring
type Ring struct {
	RingBase `json:",inline"`

	// servers
	Servers map[string]Server `json:"servers,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *Ring) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 RingBase
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.RingBase = aO0

	// AO1
	var dataAO1 struct {
		Servers map[string]Server `json:"servers,omitempty"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.Servers = dataAO1.Servers

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m Ring) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.RingBase)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)
	var dataAO1 struct {
		Servers map[string]Server `json:"servers,omitempty"`
	}

	dataAO1.Servers = m.Servers

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)
	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this ring
func (m *Ring) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with RingBase
	if err := m.RingBase.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Ring) validateServers(formats strfmt.Registry) error {

	if swag.IsZero(m.Servers) { // not required
		return nil
	}

	for k := range m.Servers {

		if err := validate.Required("servers"+"."+k, "body", m.Servers[k]); err != nil {
			return err
		}
		if val, ok := m.Servers[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("servers" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("servers" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ring based on the context it is used
func (m *Ring) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with RingBase
	if err := m.RingBase.ContextValidate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Ring) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Servers {

		if val, ok := m.Servers[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Ring) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Ring) UnmarshalBinary(b []byte) error {
	var res Ring
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
