package compute

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VirtualMachineImagesEdgeZoneClient is the compute Client
type VirtualMachineImagesEdgeZoneClient struct {
	BaseClient
}

// NewVirtualMachineImagesEdgeZoneClient creates an instance of the VirtualMachineImagesEdgeZoneClient client.
func NewVirtualMachineImagesEdgeZoneClient(subscriptionID string) VirtualMachineImagesEdgeZoneClient {
	return NewVirtualMachineImagesEdgeZoneClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVirtualMachineImagesEdgeZoneClientWithBaseURI creates an instance of the VirtualMachineImagesEdgeZoneClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewVirtualMachineImagesEdgeZoneClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineImagesEdgeZoneClient {
	return VirtualMachineImagesEdgeZoneClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets a virtual machine image in an edge zone.
// Parameters:
// location - the name of a supported Azure region.
// edgeZone - the name of the edge zone.
// publisherName - a valid image publisher.
// offer - a valid image publisher offer.
// skus - a valid image SKU.
// version - a valid image SKU version.
func (client VirtualMachineImagesEdgeZoneClient) Get(ctx context.Context, location string, edgeZone string, publisherName string, offer string, skus string, version string) (result VirtualMachineImage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImagesEdgeZoneClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, location, edgeZone, publisherName, offer, skus, version)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VirtualMachineImagesEdgeZoneClient) GetPreparer(ctx context.Context, location string, edgeZone string, publisherName string, offer string, skus string, version string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"edgeZone":       autorest.Encode("path", edgeZone),
		"location":       autorest.Encode("path", location),
		"offer":          autorest.Encode("path", offer),
		"publisherName":  autorest.Encode("path", publisherName),
		"skus":           autorest.Encode("path", skus),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"version":        autorest.Encode("path", version),
	}

	const APIVersion = "2021-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions/{version}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImagesEdgeZoneClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VirtualMachineImagesEdgeZoneClient) GetResponder(resp *http.Response) (result VirtualMachineImage, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets a list of all virtual machine image versions for the specified location, edge zone, publisher, offer, and
// SKU.
// Parameters:
// location - the name of a supported Azure region.
// edgeZone - the name of the edge zone.
// publisherName - a valid image publisher.
// offer - a valid image publisher offer.
// skus - a valid image SKU.
// expand - the expand expression to apply on the operation.
// top - an integer value specifying the number of images to return that matches supplied values.
// orderby - specifies the order of the results returned. Formatted as an OData query.
func (client VirtualMachineImagesEdgeZoneClient) List(ctx context.Context, location string, edgeZone string, publisherName string, offer string, skus string, expand string, top *int32, orderby string) (result ListVirtualMachineImageResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImagesEdgeZoneClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, location, edgeZone, publisherName, offer, skus, expand, top, orderby)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client VirtualMachineImagesEdgeZoneClient) ListPreparer(ctx context.Context, location string, edgeZone string, publisherName string, offer string, skus string, expand string, top *int32, orderby string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"edgeZone":       autorest.Encode("path", edgeZone),
		"location":       autorest.Encode("path", location),
		"offer":          autorest.Encode("path", offer),
		"publisherName":  autorest.Encode("path", publisherName),
		"skus":           autorest.Encode("path", skus),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImagesEdgeZoneClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VirtualMachineImagesEdgeZoneClient) ListResponder(resp *http.Response) (result ListVirtualMachineImageResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListOffers gets a list of virtual machine image offers for the specified location, edge zone and publisher.
// Parameters:
// location - the name of a supported Azure region.
// edgeZone - the name of the edge zone.
// publisherName - a valid image publisher.
func (client VirtualMachineImagesEdgeZoneClient) ListOffers(ctx context.Context, location string, edgeZone string, publisherName string) (result ListVirtualMachineImageResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImagesEdgeZoneClient.ListOffers")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListOffersPreparer(ctx, location, edgeZone, publisherName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListOffers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOffersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListOffers", resp, "Failure sending request")
		return
	}

	result, err = client.ListOffersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListOffers", resp, "Failure responding to request")
		return
	}

	return
}

// ListOffersPreparer prepares the ListOffers request.
func (client VirtualMachineImagesEdgeZoneClient) ListOffersPreparer(ctx context.Context, location string, edgeZone string, publisherName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"edgeZone":       autorest.Encode("path", edgeZone),
		"location":       autorest.Encode("path", location),
		"publisherName":  autorest.Encode("path", publisherName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOffersSender sends the ListOffers request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImagesEdgeZoneClient) ListOffersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListOffersResponder handles the response to the ListOffers request. The method always
// closes the http.Response Body.
func (client VirtualMachineImagesEdgeZoneClient) ListOffersResponder(resp *http.Response) (result ListVirtualMachineImageResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishers gets a list of virtual machine image publishers for the specified Azure location and edge zone.
// Parameters:
// location - the name of a supported Azure region.
// edgeZone - the name of the edge zone.
func (client VirtualMachineImagesEdgeZoneClient) ListPublishers(ctx context.Context, location string, edgeZone string) (result ListVirtualMachineImageResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImagesEdgeZoneClient.ListPublishers")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPublishersPreparer(ctx, location, edgeZone)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListPublishers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublishersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListPublishers", resp, "Failure sending request")
		return
	}

	result, err = client.ListPublishersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListPublishers", resp, "Failure responding to request")
		return
	}

	return
}

// ListPublishersPreparer prepares the ListPublishers request.
func (client VirtualMachineImagesEdgeZoneClient) ListPublishersPreparer(ctx context.Context, location string, edgeZone string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"edgeZone":       autorest.Encode("path", edgeZone),
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPublishersSender sends the ListPublishers request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImagesEdgeZoneClient) ListPublishersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPublishersResponder handles the response to the ListPublishers request. The method always
// closes the http.Response Body.
func (client VirtualMachineImagesEdgeZoneClient) ListPublishersResponder(resp *http.Response) (result ListVirtualMachineImageResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSkus gets a list of virtual machine image SKUs for the specified location, edge zone, publisher, and offer.
// Parameters:
// location - the name of a supported Azure region.
// edgeZone - the name of the edge zone.
// publisherName - a valid image publisher.
// offer - a valid image publisher offer.
func (client VirtualMachineImagesEdgeZoneClient) ListSkus(ctx context.Context, location string, edgeZone string, publisherName string, offer string) (result ListVirtualMachineImageResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImagesEdgeZoneClient.ListSkus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSkusPreparer(ctx, location, edgeZone, publisherName, offer)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListSkus", resp, "Failure sending request")
		return
	}

	result, err = client.ListSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.VirtualMachineImagesEdgeZoneClient", "ListSkus", resp, "Failure responding to request")
		return
	}

	return
}

// ListSkusPreparer prepares the ListSkus request.
func (client VirtualMachineImagesEdgeZoneClient) ListSkusPreparer(ctx context.Context, location string, edgeZone string, publisherName string, offer string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"edgeZone":       autorest.Encode("path", edgeZone),
		"location":       autorest.Encode("path", location),
		"offer":          autorest.Encode("path", offer),
		"publisherName":  autorest.Encode("path", publisherName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSkusSender sends the ListSkus request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImagesEdgeZoneClient) ListSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSkusResponder handles the response to the ListSkus request. The method always
// closes the http.Response Body.
func (client VirtualMachineImagesEdgeZoneClient) ListSkusResponder(resp *http.Response) (result ListVirtualMachineImageResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
