/**
 * The identifiers for the user. Options are restricted to the set that is currently supported.
 */

/**
 * Base client options. Does not include any options specific to providers
 * @interface BaseClientOptions
 * @property {FeatureGateEnvironment} environment - The environment for the client.
 * @property {string} targetApp - The target app for the client.
 * @property {AnalyticsWebClient} analyticsWebClient - The analytics web client.
 * @property {PerimeterType} perimeter - The perimeter for the client.
 */

/**
 * The options for the client.
 * @interface ClientOptions
 * @extends {BaseClientOptions}
 * @property {string} apiKey - The API key for the client.
 * @property {fetchTimeoutMs} fetchTimeoutMs - The timeout for the fetch request in milliseconds. Defaults to 5000.
 * @property {boolean} useGatewayURL - Whether to use the gateway URL. Defaults to false.
 */

/**
 * The custom attributes for the user.
 */

export let FeatureGateEnvironment = /*#__PURE__*/function (FeatureGateEnvironment) {
  FeatureGateEnvironment["Development"] = "development";
  FeatureGateEnvironment["Staging"] = "staging";
  FeatureGateEnvironment["Production"] = "production";
  return FeatureGateEnvironment;
}({});

// If adding new values here, please check FeatureGates.getDefaultPerimeter to make sure it still returns something sensible.
export let PerimeterType = /*#__PURE__*/function (PerimeterType) {
  PerimeterType["COMMERCIAL"] = "commercial";
  PerimeterType["FEDRAMP_MODERATE"] = "fedramp-moderate";
  return PerimeterType;
}({});
export const NON_BOOLEAN_VALUE = 'non_boolean';

// Type magic to get the JSDoc comments from the Client class methods to appear on the static
// methods in FeatureGates where the property name and function type are identical