// Source: https://github.com/atlassian/react-beautiful-dnd

import { canScrollScrollable } from './can-scroll';
import getScroll from './get-scroll';
export default (function (_ref) {
  var scrollable = _ref.scrollable,
    center = _ref.center,
    dragStartTime = _ref.dragStartTime,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening;
  var scroll = getScroll({
    dragStartTime: dragStartTime,
    container: scrollable.container,
    center: center,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
  return scroll && canScrollScrollable(scrollable, scroll) ? scroll : null;
});