/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerFieldAnalyzerWrapper
extends Analyzer {
    private Analyzer defaultAnalyzer;
    private Map<String, Analyzer> analyzerMap = new HashMap<String, Analyzer>();

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this(defaultAnalyzer, null);
    }

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer, Map<String, Analyzer> fieldAnalyzers) {
        this.defaultAnalyzer = defaultAnalyzer;
        if (fieldAnalyzers != null) {
            this.analyzerMap.putAll(fieldAnalyzers);
        }
        this.setOverridesTokenStreamMethod(PerFieldAnalyzerWrapper.class);
    }

    public void addAnalyzer(String fieldName, Analyzer analyzer) {
        this.analyzerMap.put(fieldName, analyzer);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer analyzer = this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.tokenStream(fieldName, reader);
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        Analyzer analyzer = this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.reusableTokenStream(fieldName, reader);
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        Analyzer analyzer = this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.getPositionIncrementGap(fieldName);
    }

    public String toString() {
        return "PerFieldAnalyzerWrapper(" + this.analyzerMap + ", default=" + this.defaultAnalyzer + ")";
    }
}

