/*
    SPDX-FileCopyrightText: 2008 Patrick Spendrin <ps_ml@gmx.de>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "KmlOutlineTagHandler.h"

#include "MarbleDebug.h"

#include "KmlElementDictionary.h"
#include "GeoDataPolyStyle.h"
#include "GeoParser.h"

namespace Marble
{
namespace kml
{
KML_DEFINE_TAG_HANDLER( outline )

GeoNode* KmloutlineTagHandler::parse( GeoParser& parser ) const
{
    Q_ASSERT(parser.isStartElement() && parser.isValidElement(QLatin1String(kmlTag_outline)));

    GeoStackItem parentItem = parser.parentElement();
    
    if( parentItem.represents( kmlTag_PolyStyle ) ) {
        bool outline = static_cast<bool>( parser.readElementText().trimmed().toInt() );
        
        parentItem.nodeAs<GeoDataPolyStyle>()->setOutline( outline );
    }

    return nullptr;
}

}
}
