/*
 *  SPDX-FileCopyrightText: 2015 Marco Martin <mart@kde.org>
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 */

import QtQuick
import QtQuick.Controls as Controls
import QtQuick.Layouts as Layouts

import org.kde.newstuff as NewStuff
import org.kde.kirigami as Kirigami
import org.kde.plasma.plasmoid
import org.kde.kcmutils as KCM

KCM.SimpleKCM {
    id: root

    property list<string> cfg_tabIdentifier
    property alias cfg_middleClick: middleClickCheckBox.checked
    property alias cfg_checkNewComicStripsIntervall: checkNewComicStripsInterval.value

    signal configurationChanged

    function saveConfig() {
        root.cfg_tabIdentifier = Plasmoid.availableComicsModel.checkedProviders();
    }

    Kirigami.FormLayout {
        Item {
            Kirigami.FormData.isSection: true
        }

        Layouts.ColumnLayout {
            id: providerColumn
            Kirigami.FormData.label: i18nc("@title:group", "Comics:")
            Kirigami.FormData.buddyFor: children[1] ?? null// 0 is the Repeater

            Repeater {
                model: Plasmoid.availableComicsModel
                delegate: Controls.CheckBox {
                    id: checkbox
                    text: model.display
                    checked: model.checked
                    property string plugin: model.plugin
                    onCheckedChanged: {
                        model.checked = checked
                        root.configurationChanged();
                    }
                }
            }
        }

        NewStuff.Button {
            id: ghnsButton
            text: i18nc("@action:button", "Get New Comics…")
            configFile: "comic.knsrc"
            onEntryEvent: function(entry, event) {
                if (event == 1) {
                    Plasmoid.loadProviders()
                }
            }
        }

        Controls.CheckBox {
            id: middleClickCheckBox
            text: i18nc("@option:check", "Middle-click on comic to display at original size")
        }

        Item {
            Kirigami.FormData.isSection: true
        }

        Layouts.RowLayout {
                Kirigami.FormData.label: i18nc("@label:spinbox", "Check for new comics every:")

            Controls.SpinBox {
                id: checkNewComicStripsInterval
                stepSize: 1
            }

            Controls.Label {
                text: i18ncp("@item:valuesuffix spacing to number + unit (minutes)", "minute", "minutes")
                textFormat: Text.PlainText
            }
        }
    }
}
