/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mso.generator.QtParserGenerator;
import mso.generator.utils.Choice;
import mso.generator.utils.Limitation;
import mso.generator.utils.MSO;
import mso.generator.utils.Member;
import mso.generator.utils.Option;
import mso.generator.utils.Struct;
import mso.generator.utils.Type;
import mso.generator.utils.TypeRegistry;
import org.eclipse.jdt.annotation.Nullable;

public class QtApiGenerator {
    public final QtApiConfiguration config;
    private final String generatedWarning = "/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */";
    private static final Pattern pattern1 = Pattern.compile("(?<=\\W)([a-zA-Z]\\w*)(?=\\W|$)");
    private static final Pattern pattern2 = Pattern.compile("(^[a-zA-Z]\\w*)(?=\\W|$)");

    public QtApiGenerator(@Nullable String string, String string2, String string3) {
        this.config = new QtApiConfiguration(string, string2, string3);
    }

    void generate(MSO mSO) throws IOException {
        FileWriter fileWriter = this.config.createHeader ? new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".h") : new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
        if (this.config.createHeader) {
            printWriter.println("#ifndef " + this.config.basename.toUpperCase() + "_H");
            printWriter.println("#define " + this.config.basename.toUpperCase() + "_H");
        }
        printWriter.println("#include \"leinput.h\"");
        printWriter.println("namespace " + this.config.namespace + "{");
        for (Struct struct : mSO.structs) {
            printWriter.println("class " + struct.name + ";");
        }
        for (Struct struct : mSO.structs) {
            QtApiGenerator.printStructureClassDeclaration(printWriter, struct);
        }
        if (this.config.createHeader) {
            printWriter.println("} // close namespace");
            printWriter.println("#endif");
            printWriter.close();
            fileWriter = new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
            printWriter = new PrintWriter(fileWriter);
            printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
            printWriter.println("#include \"" + this.config.basename + ".h\"");
        }
        for (Struct struct : mSO.structs) {
            this.printStructureDefinition(printWriter, struct);
        }
        if (!this.config.createHeader) {
            printWriter.println("}");
        }
        printWriter.close();
        fileWriter.close();
    }

    private static void printStructureClassDeclaration(PrintWriter printWriter, Struct struct) {
        if (struct.size == -1) {
            printWriter.println("class " + struct.name + " : public ParsedObject {");
        } else {
            printWriter.println("class " + struct.name + " : public FixedSizeParsedObject {");
        }
        printWriter.println("private:");
        if (struct.size == -1) {
            printWriter.println("public:");
            printWriter.println("    " + struct.name + "() {}");
            printWriter.println("    explicit " + struct.name + "(const char* data, const quint32 maxsize);");
        } else {
            printWriter.println("    static const quint32 _size;");
            printWriter.println("public:");
            printWriter.println("    static inline quint32 getSize() { return _size; }");
            printWriter.println("    " + struct.name + "() {}");
            printWriter.println("    " + struct.name + "(const char* data, quint32/*ignored*/ = 0);// " + struct.size / 8 + " bytes");
        }
        for (Member member : struct.members) {
            QtApiGenerator.printMemberDeclaration(printWriter, member, struct.name);
        }
        printWriter.println("};");
    }

    private String definitionPrefix() {
        String string = this.config.namespace;
        return string == null || string.length() == 0 ? "" : this.config.namespace + "::";
    }

    private void printStructureDefinition(PrintWriter printWriter, Struct struct) {
        String string = this.definitionPrefix() + struct.name + "::";
        if (struct.size == -1) {
            printWriter.println(string + struct.name + "(const char* _d, quint32 _maxsize) {");
        } else {
            printWriter.println("const quint32 " + string + "_size = " + struct.size / 8 + ";");
            printWriter.println(string + struct.name + "(const char* _d, quint32/*ignored*/) {");
        }
        printWriter.println("    quint32 _position = 0;");
        printWriter.println("    quint32 _msize;");
        int n = 0;
        for (Member member : struct.members) {
            Object object = "    ";
            int n2 = QtApiGenerator.getSize(member);
            Object object2 = member.condition;
            if (member.isSimple && object2 != null) {
                object2 = QtApiGenerator.fixForMemberName((String)object2);
                printWriter.println((String)object + "bool _has_" + member.name + " = " + (String)object2 + ";");
                object2 = "_has_" + member.name;
            }
            if (object2 != null) {
                object2 = QtApiGenerator.fixForMemberName((String)object2);
                printWriter.println((String)object + "if (" + (String)object2 + ") {");
                object = "        ";
            }
            if (n2 != -1 && struct.size == -1) {
                printWriter.print((String)object + "if (_position + " + n2);
                if (member.isOptional) {
                    object = (String)object + "    ";
                    printWriter.println(" <= _maxsize) {");
                } else {
                    printWriter.println(" > _maxsize) return;");
                }
            }
            n = QtApiGenerator.printMemberParser(printWriter, (String)object, struct, member, n);
            QtApiGenerator.printLimitationCheck(printWriter, (String)object, member.name, member);
            printWriter.println((String)object + "_position += _msize;");
            while (((String)object).length() > 4) {
                object = ((String)object).substring(((String)object).length() - 4);
                printWriter.println((String)object + "}");
            }
        }
        if (struct.size == -1) {
            printWriter.println("   ParsedObject::init(_d, _position);");
        } else {
            printWriter.println("   FixedSizeParsedObject::init(_d);");
        }
        printWriter.println("}");
        for (Member member : struct.members) {
            if (member.isArray && member.isStruct || !member.isChoice) continue;
            this.printChoiceAccessor(printWriter, struct, member);
        }
    }

    private static int printMemberParser(PrintWriter printWriter, String string, Struct struct, Member member, int n) {
        if (member.isArray) {
            if (member.isSimple) {
                QtApiGenerator.printSimpleArrayMemberParser(printWriter, string, struct, member);
            } else {
                QtApiGenerator.printStructArrayMemberParser(printWriter, string, struct, member);
            }
            if (member.isChoice) {
                throw new Error("There should be no choice in an array.");
            }
        } else {
            if (member.isSimple) {
                return QtApiGenerator.printSimpleMemberParser(printWriter, string, struct, member, n);
            }
            if (member.isStruct) {
                QtApiGenerator.printStructMemberParser(printWriter, string, struct, member);
            } else if (member.isChoice) {
                QtApiGenerator.printChoiceMemberParser(printWriter, string, struct, member);
            }
        }
        return 0;
    }

    private static int printSimpleMemberParser(PrintWriter printWriter, String string, Struct struct, Member member, int n) {
        printWriter.println(string + "m_" + member.name + " = read" + member.type().name + (String)(n > 0 ? "_" + String.valueOf(n) : "") + "(_d + _position);");
        int n2 = member.type().size / 8;
        if (n != 0 && (n + member.type().size) % 8 == 0) {
            ++n2;
        }
        n = (n + member.type().size) % 8;
        printWriter.println(string + "_msize = " + n2 + ";");
        return n;
    }

    private static int getSize(Member member) {
        int n = -1;
        if (member.count != null && member.isArray && member.type().size != -1) {
            try {
                n = member.type().size * Integer.parseInt(member.count) / 8;
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else if (member.size != null) {
            try {
                n = Integer.parseInt(member.size);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else if (!member.isArray) {
            return member.type().size / 8;
        }
        return n;
    }

    private static void printSimpleArrayMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.type().size % 8 != 0) {
            throw new Error("only arrays of types with a size of a multiple of 8 bits are allowed.");
        }
        int n = QtApiGenerator.getSize(member);
        Object object = String.valueOf(n * 8 / member.type().size);
        if (n == -1) {
            object = member.count != null ? member.count : "(" + member.size + ")/" + member.type().size / 8;
        } else if (n % (member.type().size / 8) != 0) {
            throw new Error("array size must be a multiple of the size of the type for " + member.type().name + " and size " + n);
        }
        object = QtApiGenerator.fixForMemberName((String)object);
        String string2 = QtApiGenerator.getTypeName(member.type());
        if ("quint8".equals(string2)) {
            string2 = "char";
        }
        printWriter.println(string + "m_" + member.name + " = MSOCastArray<" + string2 + ">((const " + string2 + "*)(_d + _position), " + (String)object + ");");
        printWriter.println(string + "_msize = (" + (String)object + ")*" + member.type().size / 8 + ";");
    }

    private static void printStructArrayMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        String string2 = member.count;
        if (string2 != null) {
            Object object = "_maxsize - _position, ";
            String string3 = QtApiGenerator.fixForMemberName(string2);
            if (member.type().size != -1) {
                object = member.type().size / 8 + " * " + string3 + ", ";
            }
            printWriter.println(string + "m_" + member.name + " = MSOArray<" + member.type().name + ">(_d + _position, " + (String)object + string3 + ");");
            printWriter.println(string + "if (m_" + member.name + ".getCount() != " + string3 + ") return;");
        } else if (member.size != null) {
            String string4 = QtApiGenerator.fixForMemberName(member.size);
            printWriter.println(string + "if (_maxsize - _position < " + string4 + ") return;");
            printWriter.println(string + "m_" + member.name + " = MSOArray<" + member.type().name + ">(_d + _position, " + string4 + ");");
            printWriter.println(string + "if (m_" + member.name + ".getSize() != " + string4 + ") return;");
        } else {
            printWriter.println(string + "m_" + member.name + " = MSOArray<" + member.type().name + ">(_d + _position, _maxsize - _position);");
            printWriter.println(string + "if (!m_" + member.name + ".isValid()) return;");
        }
        printWriter.println(string + "_msize = m_" + member.name + ".getSize();");
    }

    private static void printStructMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.type().size == -1) {
            printWriter.println(string + "m_" + member.name + " = " + member.type().name + "(_d + _position, _maxsize - _position);");
        } else {
            printWriter.println(string + "m_" + member.name + " = " + member.type().name + "(_d + _position);");
        }
        if (member.isOptional) {
            printWriter.println(string + "_msize = (m_" + member.name + ".isPresent()) ?m_" + member.name + ".getSize() :0;");
        } else if (member.condition != null) {
            printWriter.println(string + "if (!m_" + member.name + ".isPresent()) return;");
            printWriter.println(string + "_msize = m_" + member.name + ".getSize();");
        } else {
            printWriter.println(string + "if (!m_" + member.name + ".isValid()) return;");
            printWriter.println(string + "_msize = m_" + member.name + ".getSize();");
        }
    }

    private static void printChoiceMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        Choice choice = (Choice)member.type();
        boolean bl = true;
        Object object = string;
        for (Option option : choice.options) {
            Struct struct2 = option.type;
            if (!bl) {
                printWriter.println(string + "if (_msize == 0) {");
            }
            String string2 = "m_" + member.name + "._" + struct2.name;
            if (struct2.size == -1) {
                printWriter.println((String)object + string2 + " = " + struct2.name + "(_d + _position, _maxsize - _position);");
                printWriter.println((String)object + "_msize = " + string2 + ".getSize();");
            } else {
                printWriter.println((String)object + string2 + " = " + struct2.name + "(_d + _position);");
                printWriter.println((String)object + "_msize = (" + string2 + ".isValid()) ?" + struct2.name + "::getSize() : 0;");
            }
            if (!bl) {
                printWriter.println(string + "}");
            } else {
                object = string + "    ";
            }
            bl = false;
        }
        if (!member.isOptional) {
            printWriter.println(string + "if (_msize == 0) return;");
        }
    }

    private static String getTypeName(Type type) {
        TypeRegistry typeRegistry = type.registry;
        if (type instanceof Choice) {
            return type.name;
        }
        if (type == typeRegistry.bit) {
            return "bool";
        }
        if (type == typeRegistry.uint2 || type == typeRegistry.uint3 || type == typeRegistry.uint4 || type == typeRegistry.uint5 || type == typeRegistry.uint6 || type == typeRegistry.uint7 || type == typeRegistry.uint8) {
            return "quint8";
        }
        if (type == typeRegistry.uint9 || type == typeRegistry.uint12 || type == typeRegistry.uint13 || type == typeRegistry.uint14 || type == typeRegistry.uint15 || type == typeRegistry.uint16) {
            return "quint16";
        }
        if (type == typeRegistry.uint20 || type == typeRegistry.uint30 || type == typeRegistry.uint32) {
            return "quint32";
        }
        if (type == typeRegistry.int16) {
            return "qint16";
        }
        if (type == typeRegistry.int32) {
            return "qint32";
        }
        return type.name;
    }

    private void printChoiceAccessor(PrintWriter printWriter, Type type, Member member) {
        Choice choice = (Choice)member.type();
        printWriter.println("namespace " + this.config.namespace + " {");
        for (Option option : choice.options) {
            String string = option.type.name;
            printWriter.println("    template <> " + string + " " + type.name + "::C_" + member.name + "::get<" + string + ">() const {");
            printWriter.println("        return _" + string + ";");
            printWriter.println("    }");
            printWriter.println("    template <> bool " + type.name + "::C_" + member.name + "::is<" + string + ">() const {");
            printWriter.println("        return _" + string + ".isValid();");
            printWriter.println("    }");
        }
        printWriter.println("}");
    }

    private static void printMemberDeclaration(PrintWriter printWriter, Member member, String string) {
        Object object = QtApiGenerator.getTypeName(member.type());
        if (member.isArray) {
            if (member.isSimple) {
                if ("quint8".equals(object)) {
                    object = "char";
                }
                printWriter.println("private:");
                printWriter.println("    MSOCastArray<" + (String)object + "> m_" + member.name + ";");
                printWriter.println("public:");
                printWriter.println("    const MSOCastArray<" + (String)object + ">& " + member.name + "() const { return m_" + member.name + "; }");
            }
            if (member.isStruct || member.isChoice) {
                if (member.type().size == -1) {
                    printWriter.println("private:");
                    printWriter.println("    MSOArray<" + (String)object + "> m_" + member.name + ";");
                    printWriter.println("public:");
                    printWriter.println("    inline const MSOArray<" + (String)object + ">& " + member.name + "() const { return m_" + member.name + "; }");
                } else {
                    printWriter.println("private:");
                    printWriter.println("    MSOArray<" + (String)object + "> m_" + member.name + ";");
                    printWriter.println("public:");
                    printWriter.println("    inline const MSOArray<" + (String)object + ">& " + member.name + "() const { return m_" + member.name + "; }");
                }
            }
        } else if (member.isChoice) {
            Choice choice = (Choice)member.type();
            printWriter.println("public:");
            printWriter.println("    class C_" + member.name + " {");
            printWriter.println("    friend class " + string + ";");
            printWriter.println("    private:");
            for (Option option : choice.options) {
                Struct struct = option.type;
                printWriter.println("        " + struct.name + " _" + struct.name + ";");
            }
            printWriter.println("    public:");
            printWriter.println("        template <typename A> A get() const;");
            printWriter.println("        template <typename A> bool is() const;");
            printWriter.println("    };");
            printWriter.println("private:");
            printWriter.println("    C_" + member.name + " m_" + member.name + ";");
            printWriter.println("public:");
            printWriter.println("    C_" + member.name + " " + member.name + "() const { return m_" + member.name + "; }");
        } else {
            if (member.isOptional || member.condition != null) {
                object = member.isSimple ? "MSOBasicNullable<" + (String)object + ">" : "MSONullable<" + (String)object + ">";
            }
            printWriter.println("private:");
            printWriter.println("    " + (String)object + " m_" + member.name + ";");
            printWriter.println("public:");
            if (!member.isSimple || member.isOptional || member.condition != null) {
                object = "const " + (String)object + "&";
            }
            printWriter.println("    inline " + (String)object + " " + member.name + "() const { return m_" + member.name + "; }");
        }
    }

    private static void printLimitationCheck(PrintWriter printWriter, String string, String string2, Member member) {
        if (member.type() instanceof Choice) {
            return;
        }
        for (Limitation limitation : member.limitations) {
            Object object = limitation.name;
            object = !"".equals(object) ? string2 + "." + (String)object : string2;
            if (!member.isStruct) {
                object = member.condition == null ? "((" + QtApiGenerator.getTypeName(member.type()) + ")m_" + (String)object + ")" : "((" + QtApiGenerator.getTypeName(member.type()) + ")*m_" + (String)object + ")";
            }
            String string3 = QtParserGenerator.getLimit((String)object, limitation);
            if (member.isStruct) {
                string3 = QtApiGenerator.fixForMemberName(string3);
            }
            printWriter.println(string + "if (!(" + string3 + ")) {");
            printWriter.println(string + "     return;");
            printWriter.println(string + "}");
        }
    }

    private static boolean isNumber(String string) {
        boolean bl = true;
        try {
            Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private static String fix(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            Object object = matcher.group(1);
            if (!QtApiGenerator.isNumber((String)object)) {
                object = (String)object + "()";
            }
            matcher.appendReplacement(stringBuffer, (String)object);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String fixForMemberName(String string) {
        if (string.startsWith("_has_")) {
            return string;
        }
        string = QtApiGenerator.fix(string, pattern1);
        string = QtApiGenerator.fix(string, pattern2);
        string = string.replaceAll("false\\(\\)", "false");
        string = string.replaceAll("true\\(\\)", "true");
        return string;
    }

    public class QtApiConfiguration {
        public final @Nullable String namespace;
        public final String basename;
        public final String outputdir;
        public boolean createHeader;

        QtApiConfiguration(String string, String string2, String string3) {
            this.namespace = string;
            this.basename = string2;
            this.outputdir = string3;
        }
    }
}

