// Generated by tools/make_case_fold_inc.py

#define CF_MAX            (1 << 17)
#define CF_TABLE_SIZE     1504
#define CF_CODE_POINT(x)  ((x) & 0x1FFFF)
#define CF_REPL_IDX(x)    ((((x) >> 17) & 0xFFF) * 2)
#define CF_REPL_SIZE(x)   ((x) >> 29)

static const uint32_t cf_table[1504] = {
  0x400000B5, 0x400200C0, 0x400400C1, 0x400600C2, 0x400800C3, 0x400A00C4,
  0x400C00C5, 0x400E00C6, 0x401000C7, 0x401200C8, 0x401400C9, 0x401600CA,
  0x401800CB, 0x401A00CC, 0x401C00CD, 0x401E00CE, 0x402000CF, 0x402200D0,
  0x402400D1, 0x402600D2, 0x402800D3, 0x402A00D4, 0x402C00D5, 0x402E00D6,
  0x403000D8, 0x403200D9, 0x403400DA, 0x403600DB, 0x403800DC, 0x403A00DD,
  0x403C00DE, 0x403E00DF, 0x40400100, 0x40420102, 0x40440104, 0x40460106,
  0x40480108, 0x404A010A, 0x404C010C, 0x404E010E, 0x40500110, 0x40520112,
  0x40540114, 0x40560116, 0x40580118, 0x405A011A, 0x405C011C, 0x405E011E,
  0x40600120, 0x40620122, 0x40640124, 0x40660126, 0x40680128, 0x406A012A,
  0x406C012C, 0x406E012E, 0x60700130, 0x40740132, 0x40760134, 0x40780136,
  0x407A0139, 0x407C013B, 0x407E013D, 0x4080013F, 0x40820141, 0x40840143,
  0x40860145, 0x40880147, 0x608A0149, 0x408E014A, 0x4090014C, 0x4092014E,
  0x40940150, 0x40960152, 0x40980154, 0x409A0156, 0x409C0158, 0x409E015A,
  0x40A0015C, 0x40A2015E, 0x40A40160, 0x40A60162, 0x40A80164, 0x40AA0166,
  0x40AC0168, 0x40AE016A, 0x40B0016C, 0x40B2016E, 0x40B40170, 0x40B60172,
  0x40B80174, 0x40BA0176, 0x40BC0178, 0x40BE0179, 0x40C0017B, 0x40C2017D,
  0x20C4017F, 0x40C60181, 0x40C80182, 0x40CA0184, 0x40CC0186, 0x40CE0187,
  0x40D00189, 0x40D2018A, 0x40D4018B, 0x40D6018E, 0x40D8018F, 0x40DA0190,
  0x40DC0191, 0x40DE0193, 0x40E00194, 0x40E20196, 0x40E40197, 0x40E60198,
  0x40E8019C, 0x40EA019D, 0x40EC019F, 0x40EE01A0, 0x40F001A2, 0x40F201A4,
  0x40F401A6, 0x40F601A7, 0x40F801A9, 0x40FA01AC, 0x40FC01AE, 0x40FE01AF,
  0x410001B1, 0x410201B2, 0x410401B3, 0x410601B5, 0x410801B7, 0x410A01B8,
  0x410C01BC, 0x410E01C4, 0x411001C5, 0x411201C7, 0x411401C8, 0x411601CA,
  0x411801CB, 0x411A01CD, 0x411C01CF, 0x411E01D1, 0x412001D3, 0x412201D5,
  0x412401D7, 0x412601D9, 0x412801DB, 0x412A01DE, 0x412C01E0, 0x412E01E2,
  0x413001E4, 0x413201E6, 0x413401E8, 0x413601EA, 0x413801EC, 0x413A01EE,
  0x613C01F0, 0x414001F1, 0x414201F2, 0x414401F4, 0x414601F6, 0x414801F7,
  0x414A01F8, 0x414C01FA, 0x414E01FC, 0x415001FE, 0x41520200, 0x41540202,
  0x41560204, 0x41580206, 0x415A0208, 0x415C020A, 0x415E020C, 0x4160020E,
  0x41620210, 0x41640212, 0x41660214, 0x41680216, 0x416A0218, 0x416C021A,
  0x416E021C, 0x4170021E, 0x41720220, 0x41740222, 0x41760224, 0x41780226,
  0x417A0228, 0x417C022A, 0x417E022C, 0x4180022E, 0x41820230, 0x41840232,
  0x6186023A, 0x418A023B, 0x418C023D, 0x618E023E, 0x41920241, 0x41940243,
  0x41960244, 0x41980245, 0x419A0246, 0x419C0248, 0x419E024A, 0x41A0024C,
  0x41A2024E, 0x41A40345, 0x41A60370, 0x41A80372, 0x41AA0376, 0x41AC037F,
  0x41AE0386, 0x41B00388, 0x41B20389, 0x41B4038A, 0x41B6038C, 0x41B8038E,
  0x41BA038F, 0xC1BC0390, 0x41C20391, 0x41C40392, 0x41C60393, 0x41C80394,
  0x41CA0395, 0x41CC0396, 0x41CE0397, 0x41D00398, 0x41D20399, 0x41D4039A,
  0x41D6039B, 0x41D8039C, 0x41DA039D, 0x41DC039E, 0x41DE039F, 0x41E003A0,
  0x41E203A1, 0x41E403A3, 0x41E603A4, 0x41E803A5, 0x41EA03A6, 0x41EC03A7,
  0x41EE03A8, 0x41F003A9, 0x41F203AA, 0x41F403AB, 0xC1F603B0, 0x41FC03C2,
  0x41FE03CF, 0x420003D0, 0x420203D1, 0x420403D5, 0x420603D6, 0x420803D8,
  0x420A03DA, 0x420C03DC, 0x420E03DE, 0x421003E0, 0x421203E2, 0x421403E4,
  0x421603E6, 0x421803E8, 0x421A03EA, 0x421C03EC, 0x421E03EE, 0x422003F0,
  0x422203F1, 0x422403F4, 0x422603F5, 0x422803F7, 0x422A03F9, 0x422C03FA,
  0x422E03FD, 0x423003FE, 0x423203FF, 0x42340400, 0x42360401, 0x42380402,
  0x423A0403, 0x423C0404, 0x423E0405, 0x42400406, 0x42420407, 0x42440408,
  0x42460409, 0x4248040A, 0x424A040B, 0x424C040C, 0x424E040D, 0x4250040E,
  0x4252040F, 0x42540410, 0x42560411, 0x42580412, 0x425A0413, 0x425C0414,
  0x425E0415, 0x42600416, 0x42620417, 0x42640418, 0x42660419, 0x4268041A,
  0x426A041B, 0x426C041C, 0x426E041D, 0x4270041E, 0x4272041F, 0x42740420,
  0x42760421, 0x42780422, 0x427A0423, 0x427C0424, 0x427E0425, 0x42800426,
  0x42820427, 0x42840428, 0x42860429, 0x4288042A, 0x428A042B, 0x428C042C,
  0x428E042D, 0x4290042E, 0x4292042F, 0x42940460, 0x42960462, 0x42980464,
  0x429A0466, 0x429C0468, 0x429E046A, 0x42A0046C, 0x42A2046E, 0x42A40470,
  0x42A60472, 0x42A80474, 0x42AA0476, 0x42AC0478, 0x42AE047A, 0x42B0047C,
  0x42B2047E, 0x42B40480, 0x42B6048A, 0x42B8048C, 0x42BA048E, 0x42BC0490,
  0x42BE0492, 0x42C00494, 0x42C20496, 0x42C40498, 0x42C6049A, 0x42C8049C,
  0x42CA049E, 0x42CC04A0, 0x42CE04A2, 0x42D004A4, 0x42D204A6, 0x42D404A8,
  0x42D604AA, 0x42D804AC, 0x42DA04AE, 0x42DC04B0, 0x42DE04B2, 0x42E004B4,
  0x42E204B6, 0x42E404B8, 0x42E604BA, 0x42E804BC, 0x42EA04BE, 0x42EC04C0,
  0x42EE04C1, 0x42F004C3, 0x42F204C5, 0x42F404C7, 0x42F604C9, 0x42F804CB,
  0x42FA04CD, 0x42FC04D0, 0x42FE04D2, 0x430004D4, 0x430204D6, 0x430404D8,
  0x430604DA, 0x430804DC, 0x430A04DE, 0x430C04E0, 0x430E04E2, 0x431004E4,
  0x431204E6, 0x431404E8, 0x431604EA, 0x431804EC, 0x431A04EE, 0x431C04F0,
  0x431E04F2, 0x432004F4, 0x432204F6, 0x432404F8, 0x432604FA, 0x432804FC,
  0x432A04FE, 0x432C0500, 0x432E0502, 0x43300504, 0x43320506, 0x43340508,
  0x4336050A, 0x4338050C, 0x433A050E, 0x433C0510, 0x433E0512, 0x43400514,
  0x43420516, 0x43440518, 0x4346051A, 0x4348051C, 0x434A051E, 0x434C0520,
  0x434E0522, 0x43500524, 0x43520526, 0x43540528, 0x4356052A, 0x4358052C,
  0x435A052E, 0x435C0531, 0x435E0532, 0x43600533, 0x43620534, 0x43640535,
  0x43660536, 0x43680537, 0x436A0538, 0x436C0539, 0x436E053A, 0x4370053B,
  0x4372053C, 0x4374053D, 0x4376053E, 0x4378053F, 0x437A0540, 0x437C0541,
  0x437E0542, 0x43800543, 0x43820544, 0x43840545, 0x43860546, 0x43880547,
  0x438A0548, 0x438C0549, 0x438E054A, 0x4390054B, 0x4392054C, 0x4394054D,
  0x4396054E, 0x4398054F, 0x439A0550, 0x439C0551, 0x439E0552, 0x43A00553,
  0x43A20554, 0x43A40555, 0x43A60556, 0x83A80587, 0x63AC10A0, 0x63B010A1,
  0x63B410A2, 0x63B810A3, 0x63BC10A4, 0x63C010A5, 0x63C410A6, 0x63C810A7,
  0x63CC10A8, 0x63D010A9, 0x63D410AA, 0x63D810AB, 0x63DC10AC, 0x63E010AD,
  0x63E410AE, 0x63E810AF, 0x63EC10B0, 0x63F010B1, 0x63F410B2, 0x63F810B3,
  0x63FC10B4, 0x640010B5, 0x640410B6, 0x640810B7, 0x640C10B8, 0x641010B9,
  0x641410BA, 0x641810BB, 0x641C10BC, 0x642010BD, 0x642410BE, 0x642810BF,
  0x642C10C0, 0x643010C1, 0x643410C2, 0x643810C3, 0x643C10C4, 0x644010C5,
  0x644410C7, 0x644810CD, 0x644C13F8, 0x645013F9, 0x645413FA, 0x645813FB,
  0x645C13FC, 0x646013FD, 0x44641C80, 0x44661C81, 0x44681C82, 0x446A1C83,
  0x446C1C84, 0x446E1C85, 0x44701C86, 0x44721C87, 0x64741C88, 0x64781C90,
  0x647C1C91, 0x64801C92, 0x64841C93, 0x64881C94, 0x648C1C95, 0x64901C96,
  0x64941C97, 0x64981C98, 0x649C1C99, 0x64A01C9A, 0x64A41C9B, 0x64A81C9C,
  0x64AC1C9D, 0x64B01C9E, 0x64B41C9F, 0x64B81CA0, 0x64BC1CA1, 0x64C01CA2,
  0x64C41CA3, 0x64C81CA4, 0x64CC1CA5, 0x64D01CA6, 0x64D41CA7, 0x64D81CA8,
  0x64DC1CA9, 0x64E01CAA, 0x64E41CAB, 0x64E81CAC, 0x64EC1CAD, 0x64F01CAE,
  0x64F41CAF, 0x64F81CB0, 0x64FC1CB1, 0x65001CB2, 0x65041CB3, 0x65081CB4,
  0x650C1CB5, 0x65101CB6, 0x65141CB7, 0x65181CB8, 0x651C1CB9, 0x65201CBA,
  0x65241CBD, 0x65281CBE, 0x652C1CBF, 0x65301E00, 0x65341E02, 0x65381E04,
  0x653C1E06, 0x65401E08, 0x65441E0A, 0x65481E0C, 0x654C1E0E, 0x65501E10,
  0x65541E12, 0x65581E14, 0x655C1E16, 0x65601E18, 0x65641E1A, 0x65681E1C,
  0x656C1E1E, 0x65701E20, 0x65741E22, 0x65781E24, 0x657C1E26, 0x65801E28,
  0x65841E2A, 0x65881E2C, 0x658C1E2E, 0x65901E30, 0x65941E32, 0x65981E34,
  0x659C1E36, 0x65A01E38, 0x65A41E3A, 0x65A81E3C, 0x65AC1E3E, 0x65B01E40,
  0x65B41E42, 0x65B81E44, 0x65BC1E46, 0x65C01E48, 0x65C41E4A, 0x65C81E4C,
  0x65CC1E4E, 0x65D01E50, 0x65D41E52, 0x65D81E54, 0x65DC1E56, 0x65E01E58,
  0x65E41E5A, 0x65E81E5C, 0x65EC1E5E, 0x65F01E60, 0x65F41E62, 0x65F81E64,
  0x65FC1E66, 0x66001E68, 0x66041E6A, 0x66081E6C, 0x660C1E6E, 0x66101E70,
  0x66141E72, 0x66181E74, 0x661C1E76, 0x66201E78, 0x66241E7A, 0x66281E7C,
  0x662C1E7E, 0x66301E80, 0x66341E82, 0x66381E84, 0x663C1E86, 0x66401E88,
  0x66441E8A, 0x66481E8C, 0x664C1E8E, 0x66501E90, 0x66541E92, 0x66581E94,
  0x665C1E96, 0x66601E97, 0x66641E98, 0x66681E99, 0x666C1E9A, 0x66701E9B,
  0x46741E9E, 0x66761EA0, 0x667A1EA2, 0x667E1EA4, 0x66821EA6, 0x66861EA8,
  0x668A1EAA, 0x668E1EAC, 0x66921EAE, 0x66961EB0, 0x669A1EB2, 0x669E1EB4,
  0x66A21EB6, 0x66A61EB8, 0x66AA1EBA, 0x66AE1EBC, 0x66B21EBE, 0x66B61EC0,
  0x66BA1EC2, 0x66BE1EC4, 0x66C21EC6, 0x66C61EC8, 0x66CA1ECA, 0x66CE1ECC,
  0x66D21ECE, 0x66D61ED0, 0x66DA1ED2, 0x66DE1ED4, 0x66E21ED6, 0x66E61ED8,
  0x66EA1EDA, 0x66EE1EDC, 0x66F21EDE, 0x66F61EE0, 0x66FA1EE2, 0x66FE1EE4,
  0x67021EE6, 0x67061EE8, 0x670A1EEA, 0x670E1EEC, 0x67121EEE, 0x67161EF0,
  0x671A1EF2, 0x671E1EF4, 0x67221EF6, 0x67261EF8, 0x672A1EFA, 0x672E1EFC,
  0x67321EFE, 0x67361F08, 0x673A1F09, 0x673E1F0A, 0x67421F0B, 0x67461F0C,
  0x674A1F0D, 0x674E1F0E, 0x67521F0F, 0x67561F18, 0x675A1F19, 0x675E1F1A,
  0x67621F1B, 0x67661F1C, 0x676A1F1D, 0x676E1F28, 0x67721F29, 0x67761F2A,
  0x677A1F2B, 0x677E1F2C, 0x67821F2D, 0x67861F2E, 0x678A1F2F, 0x678E1F38,
  0x67921F39, 0x67961F3A, 0x679A1F3B, 0x679E1F3C, 0x67A21F3D, 0x67A61F3E,
  0x67AA1F3F, 0x67AE1F48, 0x67B21F49, 0x67B61F4A, 0x67BA1F4B, 0x67BE1F4C,
  0x67C21F4D, 0x87C61F50, 0xC7CA1F52, 0xC7D01F54, 0xC7D61F56, 0x67DC1F59,
  0x67E01F5B, 0x67E41F5D, 0x67E81F5F, 0x67EC1F68, 0x67F01F69, 0x67F41F6A,
  0x67F81F6B, 0x67FC1F6C, 0x68001F6D, 0x68041F6E, 0x68081F6F, 0xA80C1F80,
  0xA8121F81, 0xA8181F82, 0xA81E1F83, 0xA8241F84, 0xA82A1F85, 0xA8301F86,
  0xA8361F87, 0xA83C1F88, 0xA8421F89, 0xA8481F8A, 0xA84E1F8B, 0xA8541F8C,
  0xA85A1F8D, 0xA8601F8E, 0xA8661F8F, 0xA86C1F90, 0xA8721F91, 0xA8781F92,
  0xA87E1F93, 0xA8841F94, 0xA88A1F95, 0xA8901F96, 0xA8961F97, 0xA89C1F98,
  0xA8A21F99, 0xA8A81F9A, 0xA8AE1F9B, 0xA8B41F9C, 0xA8BA1F9D, 0xA8C01F9E,
  0xA8C61F9F, 0xA8CC1FA0, 0xA8D21FA1, 0xA8D81FA2, 0xA8DE1FA3, 0xA8E41FA4,
  0xA8EA1FA5, 0xA8F01FA6, 0xA8F61FA7, 0xA8FC1FA8, 0xA9021FA9, 0xA9081FAA,
  0xA90E1FAB, 0xA9141FAC, 0xA91A1FAD, 0xA9201FAE, 0xA9261FAF, 0xA92C1FB2,
  0x89321FB3, 0x89361FB4, 0x893A1FB6, 0xC93E1FB7, 0x69441FB8, 0x69481FB9,
  0x694C1FBA, 0x69501FBB, 0x89541FBC, 0x49581FBE, 0xA95A1FC2, 0x89601FC3,
  0x89641FC4, 0x89681FC6, 0xC96C1FC7, 0x69721FC8, 0x69761FC9, 0x697A1FCA,
  0x697E1FCB, 0x89821FCC, 0xC9861FD2, 0xC98C1FD3, 0x89921FD6, 0xC9961FD7,
  0x699C1FD8, 0x69A01FD9, 0x69A41FDA, 0x69A81FDB, 0xC9AC1FE2, 0xC9B21FE3,
  0x89B81FE4, 0x89BC1FE6, 0xC9C01FE7, 0x69C61FE8, 0x69CA1FE9, 0x69CE1FEA,
  0x69D21FEB, 0x69D61FEC, 0xA9DA1FF2, 0x89E01FF3, 0x89E41FF4, 0x89E81FF6,
  0xC9EC1FF7, 0x69F21FF8, 0x69F61FF9, 0x69FA1FFA, 0x69FE1FFB, 0x8A021FFC,
  0x4A062126, 0x2A08212A, 0x4A0A212B, 0x6A0C2132, 0x6A102160, 0x6A142161,
  0x6A182162, 0x6A1C2163, 0x6A202164, 0x6A242165, 0x6A282166, 0x6A2C2167,
  0x6A302168, 0x6A342169, 0x6A38216A, 0x6A3C216B, 0x6A40216C, 0x6A44216D,
  0x6A48216E, 0x6A4C216F, 0x6A502183, 0x6A5424B6, 0x6A5824B7, 0x6A5C24B8,
  0x6A6024B9, 0x6A6424BA, 0x6A6824BB, 0x6A6C24BC, 0x6A7024BD, 0x6A7424BE,
  0x6A7824BF, 0x6A7C24C0, 0x6A8024C1, 0x6A8424C2, 0x6A8824C3, 0x6A8C24C4,
  0x6A9024C5, 0x6A9424C6, 0x6A9824C7, 0x6A9C24C8, 0x6AA024C9, 0x6AA424CA,
  0x6AA824CB, 0x6AAC24CC, 0x6AB024CD, 0x6AB424CE, 0x6AB824CF, 0x6ABC2C00,
  0x6AC02C01, 0x6AC42C02, 0x6AC82C03, 0x6ACC2C04, 0x6AD02C05, 0x6AD42C06,
  0x6AD82C07, 0x6ADC2C08, 0x6AE02C09, 0x6AE42C0A, 0x6AE82C0B, 0x6AEC2C0C,
  0x6AF02C0D, 0x6AF42C0E, 0x6AF82C0F, 0x6AFC2C10, 0x6B002C11, 0x6B042C12,
  0x6B082C13, 0x6B0C2C14, 0x6B102C15, 0x6B142C16, 0x6B182C17, 0x6B1C2C18,
  0x6B202C19, 0x6B242C1A, 0x6B282C1B, 0x6B2C2C1C, 0x6B302C1D, 0x6B342C1E,
  0x6B382C1F, 0x6B3C2C20, 0x6B402C21, 0x6B442C22, 0x6B482C23, 0x6B4C2C24,
  0x6B502C25, 0x6B542C26, 0x6B582C27, 0x6B5C2C28, 0x6B602C29, 0x6B642C2A,
  0x6B682C2B, 0x6B6C2C2C, 0x6B702C2D, 0x6B742C2E, 0x6B782C2F, 0x6B7C2C60,
  0x4B802C62, 0x6B822C63, 0x4B862C64, 0x6B882C67, 0x6B8C2C69, 0x6B902C6B,
  0x4B942C6D, 0x4B962C6E, 0x4B982C6F, 0x4B9A2C70, 0x6B9C2C72, 0x6BA02C75,
  0x4BA42C7E, 0x4BA62C7F, 0x6BA82C80, 0x6BAC2C82, 0x6BB02C84, 0x6BB42C86,
  0x6BB82C88, 0x6BBC2C8A, 0x6BC02C8C, 0x6BC42C8E, 0x6BC82C90, 0x6BCC2C92,
  0x6BD02C94, 0x6BD42C96, 0x6BD82C98, 0x6BDC2C9A, 0x6BE02C9C, 0x6BE42C9E,
  0x6BE82CA0, 0x6BEC2CA2, 0x6BF02CA4, 0x6BF42CA6, 0x6BF82CA8, 0x6BFC2CAA,
  0x6C002CAC, 0x6C042CAE, 0x6C082CB0, 0x6C0C2CB2, 0x6C102CB4, 0x6C142CB6,
  0x6C182CB8, 0x6C1C2CBA, 0x6C202CBC, 0x6C242CBE, 0x6C282CC0, 0x6C2C2CC2,
  0x6C302CC4, 0x6C342CC6, 0x6C382CC8, 0x6C3C2CCA, 0x6C402CCC, 0x6C442CCE,
  0x6C482CD0, 0x6C4C2CD2, 0x6C502CD4, 0x6C542CD6, 0x6C582CD8, 0x6C5C2CDA,
  0x6C602CDC, 0x6C642CDE, 0x6C682CE0, 0x6C6C2CE2, 0x6C702CEB, 0x6C742CED,
  0x6C782CF2, 0x6C7CA640, 0x6C80A642, 0x6C84A644, 0x6C88A646, 0x6C8CA648,
  0x6C90A64A, 0x6C94A64C, 0x6C98A64E, 0x6C9CA650, 0x6CA0A652, 0x6CA4A654,
  0x6CA8A656, 0x6CACA658, 0x6CB0A65A, 0x6CB4A65C, 0x6CB8A65E, 0x6CBCA660,
  0x6CC0A662, 0x6CC4A664, 0x6CC8A666, 0x6CCCA668, 0x6CD0A66A, 0x6CD4A66C,
  0x6CD8A680, 0x6CDCA682, 0x6CE0A684, 0x6CE4A686, 0x6CE8A688, 0x6CECA68A,
  0x6CF0A68C, 0x6CF4A68E, 0x6CF8A690, 0x6CFCA692, 0x6D00A694, 0x6D04A696,
  0x6D08A698, 0x6D0CA69A, 0x6D10A722, 0x6D14A724, 0x6D18A726, 0x6D1CA728,
  0x6D20A72A, 0x6D24A72C, 0x6D28A72E, 0x6D2CA732, 0x6D30A734, 0x6D34A736,
  0x6D38A738, 0x6D3CA73A, 0x6D40A73C, 0x6D44A73E, 0x6D48A740, 0x6D4CA742,
  0x6D50A744, 0x6D54A746, 0x6D58A748, 0x6D5CA74A, 0x6D60A74C, 0x6D64A74E,
  0x6D68A750, 0x6D6CA752, 0x6D70A754, 0x6D74A756, 0x6D78A758, 0x6D7CA75A,
  0x6D80A75C, 0x6D84A75E, 0x6D88A760, 0x6D8CA762, 0x6D90A764, 0x6D94A766,
  0x6D98A768, 0x6D9CA76A, 0x6DA0A76C, 0x6DA4A76E, 0x6DA8A779, 0x6DACA77B,
  0x6DB0A77D, 0x6DB4A77E, 0x6DB8A780, 0x6DBCA782, 0x6DC0A784, 0x6DC4A786,
  0x6DC8A78B, 0x4DCCA78D, 0x6DCEA790, 0x6DD2A792, 0x6DD6A796, 0x6DDAA798,
  0x6DDEA79A, 0x6DE2A79C, 0x6DE6A79E, 0x6DEAA7A0, 0x6DEEA7A2, 0x6DF2A7A4,
  0x6DF6A7A6, 0x6DFAA7A8, 0x4DFEA7AA, 0x4E00A7AB, 0x4E02A7AC, 0x4E04A7AD,
  0x4E06A7AE, 0x4E08A7B0, 0x4E0AA7B1, 0x4E0CA7B2, 0x6E0EA7B3, 0x6E12A7B4,
  0x6E16A7B6, 0x6E1AA7B8, 0x6E1EA7BA, 0x6E22A7BC, 0x6E26A7BE, 0x6E2AA7C0,
  0x6E2EA7C2, 0x6E32A7C4, 0x4E36A7C5, 0x6E38A7C6, 0x6E3CA7C7, 0x6E40A7C9,
  0x6E44A7D0, 0x6E48A7D6, 0x6E4CA7D8, 0x6E50A7F5, 0x6E54AB70, 0x6E58AB71,
  0x6E5CAB72, 0x6E60AB73, 0x6E64AB74, 0x6E68AB75, 0x6E6CAB76, 0x6E70AB77,
  0x6E74AB78, 0x6E78AB79, 0x6E7CAB7A, 0x6E80AB7B, 0x6E84AB7C, 0x6E88AB7D,
  0x6E8CAB7E, 0x6E90AB7F, 0x6E94AB80, 0x6E98AB81, 0x6E9CAB82, 0x6EA0AB83,
  0x6EA4AB84, 0x6EA8AB85, 0x6EACAB86, 0x6EB0AB87, 0x6EB4AB88, 0x6EB8AB89,
  0x6EBCAB8A, 0x6EC0AB8B, 0x6EC4AB8C, 0x6EC8AB8D, 0x6ECCAB8E, 0x6ED0AB8F,
  0x6ED4AB90, 0x6ED8AB91, 0x6EDCAB92, 0x6EE0AB93, 0x6EE4AB94, 0x6EE8AB95,
  0x6EECAB96, 0x6EF0AB97, 0x6EF4AB98, 0x6EF8AB99, 0x6EFCAB9A, 0x6F00AB9B,
  0x6F04AB9C, 0x6F08AB9D, 0x6F0CAB9E, 0x6F10AB9F, 0x6F14ABA0, 0x6F18ABA1,
  0x6F1CABA2, 0x6F20ABA3, 0x6F24ABA4, 0x6F28ABA5, 0x6F2CABA6, 0x6F30ABA7,
  0x6F34ABA8, 0x6F38ABA9, 0x6F3CABAA, 0x6F40ABAB, 0x6F44ABAC, 0x6F48ABAD,
  0x6F4CABAE, 0x6F50ABAF, 0x6F54ABB0, 0x6F58ABB1, 0x6F5CABB2, 0x6F60ABB3,
  0x6F64ABB4, 0x6F68ABB5, 0x6F6CABB6, 0x6F70ABB7, 0x6F74ABB8, 0x6F78ABB9,
  0x6F7CABBA, 0x6F80ABBB, 0x6F84ABBC, 0x6F88ABBD, 0x6F8CABBE, 0x6F90ABBF,
  0x4F94FB00, 0x4F96FB01, 0x4F98FB02, 0x6F9AFB03, 0x6F9EFB04, 0x4FA2FB05,
  0x4FA4FB06, 0x8FA6FB13, 0x8FAAFB14, 0x8FAEFB15, 0x8FB2FB16, 0x8FB6FB17,
  0x6FBAFF21, 0x6FBEFF22, 0x6FC2FF23, 0x6FC6FF24, 0x6FCAFF25, 0x6FCEFF26,
  0x6FD2FF27, 0x6FD6FF28, 0x6FDAFF29, 0x6FDEFF2A, 0x6FE2FF2B, 0x6FE6FF2C,
  0x6FEAFF2D, 0x6FEEFF2E, 0x6FF2FF2F, 0x6FF6FF30, 0x6FFAFF31, 0x6FFEFF32,
  0x7002FF33, 0x7006FF34, 0x700AFF35, 0x700EFF36, 0x7012FF37, 0x7016FF38,
  0x701AFF39, 0x701EFF3A, 0x90230400, 0x90270401, 0x902B0402, 0x902F0403,
  0x90330404, 0x90370405, 0x903B0406, 0x903F0407, 0x90430408, 0x90470409,
  0x904B040A, 0x904F040B, 0x9053040C, 0x9057040D, 0x905B040E, 0x905F040F,
  0x90630410, 0x90670411, 0x906B0412, 0x906F0413, 0x90730414, 0x90770415,
  0x907B0416, 0x907F0417, 0x90830418, 0x90870419, 0x908B041A, 0x908F041B,
  0x9093041C, 0x9097041D, 0x909B041E, 0x909F041F, 0x90A30420, 0x90A70421,
  0x90AB0422, 0x90AF0423, 0x90B30424, 0x90B70425, 0x90BB0426, 0x90BF0427,
  0x90C304B0, 0x90C704B1, 0x90CB04B2, 0x90CF04B3, 0x90D304B4, 0x90D704B5,
  0x90DB04B6, 0x90DF04B7, 0x90E304B8, 0x90E704B9, 0x90EB04BA, 0x90EF04BB,
  0x90F304BC, 0x90F704BD, 0x90FB04BE, 0x90FF04BF, 0x910304C0, 0x910704C1,
  0x910B04C2, 0x910F04C3, 0x911304C4, 0x911704C5, 0x911B04C6, 0x911F04C7,
  0x912304C8, 0x912704C9, 0x912B04CA, 0x912F04CB, 0x913304CC, 0x913704CD,
  0x913B04CE, 0x913F04CF, 0x914304D0, 0x914704D1, 0x914B04D2, 0x914F04D3,
  0x91530570, 0x91570571, 0x915B0572, 0x915F0573, 0x91630574, 0x91670575,
  0x916B0576, 0x916F0577, 0x91730578, 0x91770579, 0x917B057A, 0x917F057C,
  0x9183057D, 0x9187057E, 0x918B057F, 0x918F0580, 0x91930581, 0x91970582,
  0x919B0583, 0x919F0584, 0x91A30585, 0x91A70586, 0x91AB0587, 0x91AF0588,
  0x91B30589, 0x91B7058A, 0x91BB058C, 0x91BF058D, 0x91C3058E, 0x91C7058F,
  0x91CB0590, 0x91CF0591, 0x91D30592, 0x91D70594, 0x91DB0595, 0x91DF0C80,
  0x91E30C81, 0x91E70C82, 0x91EB0C83, 0x91EF0C84, 0x91F30C85, 0x91F70C86,
  0x91FB0C87, 0x91FF0C88, 0x92030C89, 0x92070C8A, 0x920B0C8B, 0x920F0C8C,
  0x92130C8D, 0x92170C8E, 0x921B0C8F, 0x921F0C90, 0x92230C91, 0x92270C92,
  0x922B0C93, 0x922F0C94, 0x92330C95, 0x92370C96, 0x923B0C97, 0x923F0C98,
  0x92430C99, 0x92470C9A, 0x924B0C9B, 0x924F0C9C, 0x92530C9D, 0x92570C9E,
  0x925B0C9F, 0x925F0CA0, 0x92630CA1, 0x92670CA2, 0x926B0CA3, 0x926F0CA4,
  0x92730CA5, 0x92770CA6, 0x927B0CA7, 0x927F0CA8, 0x92830CA9, 0x92870CAA,
  0x928B0CAB, 0x928F0CAC, 0x92930CAD, 0x92970CAE, 0x929B0CAF, 0x929F0CB0,
  0x92A30CB1, 0x92A70CB2, 0x92AB18A0, 0x92AF18A1, 0x92B318A2, 0x92B718A3,
  0x92BB18A4, 0x92BF18A5, 0x92C318A6, 0x92C718A7, 0x92CB18A8, 0x92CF18A9,
  0x92D318AA, 0x92D718AB, 0x92DB18AC, 0x92DF18AD, 0x92E318AE, 0x92E718AF,
  0x92EB18B0, 0x92EF18B1, 0x92F318B2, 0x92F718B3, 0x92FB18B4, 0x92FF18B5,
  0x930318B6, 0x930718B7, 0x930B18B8, 0x930F18B9, 0x931318BA, 0x931718BB,
  0x931B18BC, 0x931F18BD, 0x932318BE, 0x932718BF, 0x932B6E40, 0x932F6E41,
  0x93336E42, 0x93376E43, 0x933B6E44, 0x933F6E45, 0x93436E46, 0x93476E47,
  0x934B6E48, 0x934F6E49, 0x93536E4A, 0x93576E4B, 0x935B6E4C, 0x935F6E4D,
  0x93636E4E, 0x93676E4F, 0x936B6E50, 0x936F6E51, 0x93736E52, 0x93776E53,
  0x937B6E54, 0x937F6E55, 0x93836E56, 0x93876E57, 0x938B6E58, 0x938F6E59,
  0x93936E5A, 0x93976E5B, 0x939B6E5C, 0x939F6E5D, 0x93A36E5E, 0x93A76E5F,
  0x93ABE900, 0x93AFE901, 0x93B3E902, 0x93B7E903, 0x93BBE904, 0x93BFE905,
  0x93C3E906, 0x93C7E907, 0x93CBE908, 0x93CFE909, 0x93D3E90A, 0x93D7E90B,
  0x93DBE90C, 0x93DFE90D, 0x93E3E90E, 0x93E7E90F, 0x93EBE910, 0x93EFE911,
  0x93F3E912, 0x93F7E913, 0x93FBE914, 0x93FFE915, 0x9403E916, 0x9407E917,
  0x940BE918, 0x940FE919, 0x9413E91A, 0x9417E91B, 0x941BE91C, 0x941FE91D,
  0x9423E91E, 0x9427E91F, 0x942BE920, 0x942FE921
};

static const unsigned char cf_repl[5170] = {
  0xCE, 0xBC, 0xC3, 0xA0, 0xC3, 0xA1, 0xC3, 0xA2, 0xC3, 0xA3, 0xC3, 0xA4,
  0xC3, 0xA5, 0xC3, 0xA6, 0xC3, 0xA7, 0xC3, 0xA8, 0xC3, 0xA9, 0xC3, 0xAA,
  0xC3, 0xAB, 0xC3, 0xAC, 0xC3, 0xAD, 0xC3, 0xAE, 0xC3, 0xAF, 0xC3, 0xB0,
  0xC3, 0xB1, 0xC3, 0xB2, 0xC3, 0xB3, 0xC3, 0xB4, 0xC3, 0xB5, 0xC3, 0xB6,
  0xC3, 0xB8, 0xC3, 0xB9, 0xC3, 0xBA, 0xC3, 0xBB, 0xC3, 0xBC, 0xC3, 0xBD,
  0xC3, 0xBE, 0x73, 0x73, 0xC4, 0x81, 0xC4, 0x83, 0xC4, 0x85, 0xC4, 0x87,
  0xC4, 0x89, 0xC4, 0x8B, 0xC4, 0x8D, 0xC4, 0x8F, 0xC4, 0x91, 0xC4, 0x93,
  0xC4, 0x95, 0xC4, 0x97, 0xC4, 0x99, 0xC4, 0x9B, 0xC4, 0x9D, 0xC4, 0x9F,
  0xC4, 0xA1, 0xC4, 0xA3, 0xC4, 0xA5, 0xC4, 0xA7, 0xC4, 0xA9, 0xC4, 0xAB,
  0xC4, 0xAD, 0xC4, 0xAF, 0x69, 0xCC, 0x87, 0x00, 0xC4, 0xB3, 0xC4, 0xB5,
  0xC4, 0xB7, 0xC4, 0xBA, 0xC4, 0xBC, 0xC4, 0xBE, 0xC5, 0x80, 0xC5, 0x82,
  0xC5, 0x84, 0xC5, 0x86, 0xC5, 0x88, 0xCA, 0xBC, 0x6E, 0x00, 0xC5, 0x8B,
  0xC5, 0x8D, 0xC5, 0x8F, 0xC5, 0x91, 0xC5, 0x93, 0xC5, 0x95, 0xC5, 0x97,
  0xC5, 0x99, 0xC5, 0x9B, 0xC5, 0x9D, 0xC5, 0x9F, 0xC5, 0xA1, 0xC5, 0xA3,
  0xC5, 0xA5, 0xC5, 0xA7, 0xC5, 0xA9, 0xC5, 0xAB, 0xC5, 0xAD, 0xC5, 0xAF,
  0xC5, 0xB1, 0xC5, 0xB3, 0xC5, 0xB5, 0xC5, 0xB7, 0xC3, 0xBF, 0xC5, 0xBA,
  0xC5, 0xBC, 0xC5, 0xBE, 0x73, 0x00, 0xC9, 0x93, 0xC6, 0x83, 0xC6, 0x85,
  0xC9, 0x94, 0xC6, 0x88, 0xC9, 0x96, 0xC9, 0x97, 0xC6, 0x8C, 0xC7, 0x9D,
  0xC9, 0x99, 0xC9, 0x9B, 0xC6, 0x92, 0xC9, 0xA0, 0xC9, 0xA3, 0xC9, 0xA9,
  0xC9, 0xA8, 0xC6, 0x99, 0xC9, 0xAF, 0xC9, 0xB2, 0xC9, 0xB5, 0xC6, 0xA1,
  0xC6, 0xA3, 0xC6, 0xA5, 0xCA, 0x80, 0xC6, 0xA8, 0xCA, 0x83, 0xC6, 0xAD,
  0xCA, 0x88, 0xC6, 0xB0, 0xCA, 0x8A, 0xCA, 0x8B, 0xC6, 0xB4, 0xC6, 0xB6,
  0xCA, 0x92, 0xC6, 0xB9, 0xC6, 0xBD, 0xC7, 0x86, 0xC7, 0x86, 0xC7, 0x89,
  0xC7, 0x89, 0xC7, 0x8C, 0xC7, 0x8C, 0xC7, 0x8E, 0xC7, 0x90, 0xC7, 0x92,
  0xC7, 0x94, 0xC7, 0x96, 0xC7, 0x98, 0xC7, 0x9A, 0xC7, 0x9C, 0xC7, 0x9F,
  0xC7, 0xA1, 0xC7, 0xA3, 0xC7, 0xA5, 0xC7, 0xA7, 0xC7, 0xA9, 0xC7, 0xAB,
  0xC7, 0xAD, 0xC7, 0xAF, 0x6A, 0xCC, 0x8C, 0x00, 0xC7, 0xB3, 0xC7, 0xB3,
  0xC7, 0xB5, 0xC6, 0x95, 0xC6, 0xBF, 0xC7, 0xB9, 0xC7, 0xBB, 0xC7, 0xBD,
  0xC7, 0xBF, 0xC8, 0x81, 0xC8, 0x83, 0xC8, 0x85, 0xC8, 0x87, 0xC8, 0x89,
  0xC8, 0x8B, 0xC8, 0x8D, 0xC8, 0x8F, 0xC8, 0x91, 0xC8, 0x93, 0xC8, 0x95,
  0xC8, 0x97, 0xC8, 0x99, 0xC8, 0x9B, 0xC8, 0x9D, 0xC8, 0x9F, 0xC6, 0x9E,
  0xC8, 0xA3, 0xC8, 0xA5, 0xC8, 0xA7, 0xC8, 0xA9, 0xC8, 0xAB, 0xC8, 0xAD,
  0xC8, 0xAF, 0xC8, 0xB1, 0xC8, 0xB3, 0xE2, 0xB1, 0xA5, 0x00, 0xC8, 0xBC,
  0xC6, 0x9A, 0xE2, 0xB1, 0xA6, 0x00, 0xC9, 0x82, 0xC6, 0x80, 0xCA, 0x89,
  0xCA, 0x8C, 0xC9, 0x87, 0xC9, 0x89, 0xC9, 0x8B, 0xC9, 0x8D, 0xC9, 0x8F,
  0xCE, 0xB9, 0xCD, 0xB1, 0xCD, 0xB3, 0xCD, 0xB7, 0xCF, 0xB3, 0xCE, 0xAC,
  0xCE, 0xAD, 0xCE, 0xAE, 0xCE, 0xAF, 0xCF, 0x8C, 0xCF, 0x8D, 0xCF, 0x8E,
  0xCE, 0xB9, 0xCC, 0x88, 0xCC, 0x81, 0xCE, 0xB1, 0xCE, 0xB2, 0xCE, 0xB3,
  0xCE, 0xB4, 0xCE, 0xB5, 0xCE, 0xB6, 0xCE, 0xB7, 0xCE, 0xB8, 0xCE, 0xB9,
  0xCE, 0xBA, 0xCE, 0xBB, 0xCE, 0xBC, 0xCE, 0xBD, 0xCE, 0xBE, 0xCE, 0xBF,
  0xCF, 0x80, 0xCF, 0x81, 0xCF, 0x83, 0xCF, 0x84, 0xCF, 0x85, 0xCF, 0x86,
  0xCF, 0x87, 0xCF, 0x88, 0xCF, 0x89, 0xCF, 0x8A, 0xCF, 0x8B, 0xCF, 0x85,
  0xCC, 0x88, 0xCC, 0x81, 0xCF, 0x83, 0xCF, 0x97, 0xCE, 0xB2, 0xCE, 0xB8,
  0xCF, 0x86, 0xCF, 0x80, 0xCF, 0x99, 0xCF, 0x9B, 0xCF, 0x9D, 0xCF, 0x9F,
  0xCF, 0xA1, 0xCF, 0xA3, 0xCF, 0xA5, 0xCF, 0xA7, 0xCF, 0xA9, 0xCF, 0xAB,
  0xCF, 0xAD, 0xCF, 0xAF, 0xCE, 0xBA, 0xCF, 0x81, 0xCE, 0xB8, 0xCE, 0xB5,
  0xCF, 0xB8, 0xCF, 0xB2, 0xCF, 0xBB, 0xCD, 0xBB, 0xCD, 0xBC, 0xCD, 0xBD,
  0xD1, 0x90, 0xD1, 0x91, 0xD1, 0x92, 0xD1, 0x93, 0xD1, 0x94, 0xD1, 0x95,
  0xD1, 0x96, 0xD1, 0x97, 0xD1, 0x98, 0xD1, 0x99, 0xD1, 0x9A, 0xD1, 0x9B,
  0xD1, 0x9C, 0xD1, 0x9D, 0xD1, 0x9E, 0xD1, 0x9F, 0xD0, 0xB0, 0xD0, 0xB1,
  0xD0, 0xB2, 0xD0, 0xB3, 0xD0, 0xB4, 0xD0, 0xB5, 0xD0, 0xB6, 0xD0, 0xB7,
  0xD0, 0xB8, 0xD0, 0xB9, 0xD0, 0xBA, 0xD0, 0xBB, 0xD0, 0xBC, 0xD0, 0xBD,
  0xD0, 0xBE, 0xD0, 0xBF, 0xD1, 0x80, 0xD1, 0x81, 0xD1, 0x82, 0xD1, 0x83,
  0xD1, 0x84, 0xD1, 0x85, 0xD1, 0x86, 0xD1, 0x87, 0xD1, 0x88, 0xD1, 0x89,
  0xD1, 0x8A, 0xD1, 0x8B, 0xD1, 0x8C, 0xD1, 0x8D, 0xD1, 0x8E, 0xD1, 0x8F,
  0xD1, 0xA1, 0xD1, 0xA3, 0xD1, 0xA5, 0xD1, 0xA7, 0xD1, 0xA9, 0xD1, 0xAB,
  0xD1, 0xAD, 0xD1, 0xAF, 0xD1, 0xB1, 0xD1, 0xB3, 0xD1, 0xB5, 0xD1, 0xB7,
  0xD1, 0xB9, 0xD1, 0xBB, 0xD1, 0xBD, 0xD1, 0xBF, 0xD2, 0x81, 0xD2, 0x8B,
  0xD2, 0x8D, 0xD2, 0x8F, 0xD2, 0x91, 0xD2, 0x93, 0xD2, 0x95, 0xD2, 0x97,
  0xD2, 0x99, 0xD2, 0x9B, 0xD2, 0x9D, 0xD2, 0x9F, 0xD2, 0xA1, 0xD2, 0xA3,
  0xD2, 0xA5, 0xD2, 0xA7, 0xD2, 0xA9, 0xD2, 0xAB, 0xD2, 0xAD, 0xD2, 0xAF,
  0xD2, 0xB1, 0xD2, 0xB3, 0xD2, 0xB5, 0xD2, 0xB7, 0xD2, 0xB9, 0xD2, 0xBB,
  0xD2, 0xBD, 0xD2, 0xBF, 0xD3, 0x8F, 0xD3, 0x82, 0xD3, 0x84, 0xD3, 0x86,
  0xD3, 0x88, 0xD3, 0x8A, 0xD3, 0x8C, 0xD3, 0x8E, 0xD3, 0x91, 0xD3, 0x93,
  0xD3, 0x95, 0xD3, 0x97, 0xD3, 0x99, 0xD3, 0x9B, 0xD3, 0x9D, 0xD3, 0x9F,
  0xD3, 0xA1, 0xD3, 0xA3, 0xD3, 0xA5, 0xD3, 0xA7, 0xD3, 0xA9, 0xD3, 0xAB,
  0xD3, 0xAD, 0xD3, 0xAF, 0xD3, 0xB1, 0xD3, 0xB3, 0xD3, 0xB5, 0xD3, 0xB7,
  0xD3, 0xB9, 0xD3, 0xBB, 0xD3, 0xBD, 0xD3, 0xBF, 0xD4, 0x81, 0xD4, 0x83,
  0xD4, 0x85, 0xD4, 0x87, 0xD4, 0x89, 0xD4, 0x8B, 0xD4, 0x8D, 0xD4, 0x8F,
  0xD4, 0x91, 0xD4, 0x93, 0xD4, 0x95, 0xD4, 0x97, 0xD4, 0x99, 0xD4, 0x9B,
  0xD4, 0x9D, 0xD4, 0x9F, 0xD4, 0xA1, 0xD4, 0xA3, 0xD4, 0xA5, 0xD4, 0xA7,
  0xD4, 0xA9, 0xD4, 0xAB, 0xD4, 0xAD, 0xD4, 0xAF, 0xD5, 0xA1, 0xD5, 0xA2,
  0xD5, 0xA3, 0xD5, 0xA4, 0xD5, 0xA5, 0xD5, 0xA6, 0xD5, 0xA7, 0xD5, 0xA8,
  0xD5, 0xA9, 0xD5, 0xAA, 0xD5, 0xAB, 0xD5, 0xAC, 0xD5, 0xAD, 0xD5, 0xAE,
  0xD5, 0xAF, 0xD5, 0xB0, 0xD5, 0xB1, 0xD5, 0xB2, 0xD5, 0xB3, 0xD5, 0xB4,
  0xD5, 0xB5, 0xD5, 0xB6, 0xD5, 0xB7, 0xD5, 0xB8, 0xD5, 0xB9, 0xD5, 0xBA,
  0xD5, 0xBB, 0xD5, 0xBC, 0xD5, 0xBD, 0xD5, 0xBE, 0xD5, 0xBF, 0xD6, 0x80,
  0xD6, 0x81, 0xD6, 0x82, 0xD6, 0x83, 0xD6, 0x84, 0xD6, 0x85, 0xD6, 0x86,
  0xD5, 0xA5, 0xD6, 0x82, 0xE2, 0xB4, 0x80, 0x00, 0xE2, 0xB4, 0x81, 0x00,
  0xE2, 0xB4, 0x82, 0x00, 0xE2, 0xB4, 0x83, 0x00, 0xE2, 0xB4, 0x84, 0x00,
  0xE2, 0xB4, 0x85, 0x00, 0xE2, 0xB4, 0x86, 0x00, 0xE2, 0xB4, 0x87, 0x00,
  0xE2, 0xB4, 0x88, 0x00, 0xE2, 0xB4, 0x89, 0x00, 0xE2, 0xB4, 0x8A, 0x00,
  0xE2, 0xB4, 0x8B, 0x00, 0xE2, 0xB4, 0x8C, 0x00, 0xE2, 0xB4, 0x8D, 0x00,
  0xE2, 0xB4, 0x8E, 0x00, 0xE2, 0xB4, 0x8F, 0x00, 0xE2, 0xB4, 0x90, 0x00,
  0xE2, 0xB4, 0x91, 0x00, 0xE2, 0xB4, 0x92, 0x00, 0xE2, 0xB4, 0x93, 0x00,
  0xE2, 0xB4, 0x94, 0x00, 0xE2, 0xB4, 0x95, 0x00, 0xE2, 0xB4, 0x96, 0x00,
  0xE2, 0xB4, 0x97, 0x00, 0xE2, 0xB4, 0x98, 0x00, 0xE2, 0xB4, 0x99, 0x00,
  0xE2, 0xB4, 0x9A, 0x00, 0xE2, 0xB4, 0x9B, 0x00, 0xE2, 0xB4, 0x9C, 0x00,
  0xE2, 0xB4, 0x9D, 0x00, 0xE2, 0xB4, 0x9E, 0x00, 0xE2, 0xB4, 0x9F, 0x00,
  0xE2, 0xB4, 0xA0, 0x00, 0xE2, 0xB4, 0xA1, 0x00, 0xE2, 0xB4, 0xA2, 0x00,
  0xE2, 0xB4, 0xA3, 0x00, 0xE2, 0xB4, 0xA4, 0x00, 0xE2, 0xB4, 0xA5, 0x00,
  0xE2, 0xB4, 0xA7, 0x00, 0xE2, 0xB4, 0xAD, 0x00, 0xE1, 0x8F, 0xB0, 0x00,
  0xE1, 0x8F, 0xB1, 0x00, 0xE1, 0x8F, 0xB2, 0x00, 0xE1, 0x8F, 0xB3, 0x00,
  0xE1, 0x8F, 0xB4, 0x00, 0xE1, 0x8F, 0xB5, 0x00, 0xD0, 0xB2, 0xD0, 0xB4,
  0xD0, 0xBE, 0xD1, 0x81, 0xD1, 0x82, 0xD1, 0x82, 0xD1, 0x8A, 0xD1, 0xA3,
  0xEA, 0x99, 0x8B, 0x00, 0xE1, 0x83, 0x90, 0x00, 0xE1, 0x83, 0x91, 0x00,
  0xE1, 0x83, 0x92, 0x00, 0xE1, 0x83, 0x93, 0x00, 0xE1, 0x83, 0x94, 0x00,
  0xE1, 0x83, 0x95, 0x00, 0xE1, 0x83, 0x96, 0x00, 0xE1, 0x83, 0x97, 0x00,
  0xE1, 0x83, 0x98, 0x00, 0xE1, 0x83, 0x99, 0x00, 0xE1, 0x83, 0x9A, 0x00,
  0xE1, 0x83, 0x9B, 0x00, 0xE1, 0x83, 0x9C, 0x00, 0xE1, 0x83, 0x9D, 0x00,
  0xE1, 0x83, 0x9E, 0x00, 0xE1, 0x83, 0x9F, 0x00, 0xE1, 0x83, 0xA0, 0x00,
  0xE1, 0x83, 0xA1, 0x00, 0xE1, 0x83, 0xA2, 0x00, 0xE1, 0x83, 0xA3, 0x00,
  0xE1, 0x83, 0xA4, 0x00, 0xE1, 0x83, 0xA5, 0x00, 0xE1, 0x83, 0xA6, 0x00,
  0xE1, 0x83, 0xA7, 0x00, 0xE1, 0x83, 0xA8, 0x00, 0xE1, 0x83, 0xA9, 0x00,
  0xE1, 0x83, 0xAA, 0x00, 0xE1, 0x83, 0xAB, 0x00, 0xE1, 0x83, 0xAC, 0x00,
  0xE1, 0x83, 0xAD, 0x00, 0xE1, 0x83, 0xAE, 0x00, 0xE1, 0x83, 0xAF, 0x00,
  0xE1, 0x83, 0xB0, 0x00, 0xE1, 0x83, 0xB1, 0x00, 0xE1, 0x83, 0xB2, 0x00,
  0xE1, 0x83, 0xB3, 0x00, 0xE1, 0x83, 0xB4, 0x00, 0xE1, 0x83, 0xB5, 0x00,
  0xE1, 0x83, 0xB6, 0x00, 0xE1, 0x83, 0xB7, 0x00, 0xE1, 0x83, 0xB8, 0x00,
  0xE1, 0x83, 0xB9, 0x00, 0xE1, 0x83, 0xBA, 0x00, 0xE1, 0x83, 0xBD, 0x00,
  0xE1, 0x83, 0xBE, 0x00, 0xE1, 0x83, 0xBF, 0x00, 0xE1, 0xB8, 0x81, 0x00,
  0xE1, 0xB8, 0x83, 0x00, 0xE1, 0xB8, 0x85, 0x00, 0xE1, 0xB8, 0x87, 0x00,
  0xE1, 0xB8, 0x89, 0x00, 0xE1, 0xB8, 0x8B, 0x00, 0xE1, 0xB8, 0x8D, 0x00,
  0xE1, 0xB8, 0x8F, 0x00, 0xE1, 0xB8, 0x91, 0x00, 0xE1, 0xB8, 0x93, 0x00,
  0xE1, 0xB8, 0x95, 0x00, 0xE1, 0xB8, 0x97, 0x00, 0xE1, 0xB8, 0x99, 0x00,
  0xE1, 0xB8, 0x9B, 0x00, 0xE1, 0xB8, 0x9D, 0x00, 0xE1, 0xB8, 0x9F, 0x00,
  0xE1, 0xB8, 0xA1, 0x00, 0xE1, 0xB8, 0xA3, 0x00, 0xE1, 0xB8, 0xA5, 0x00,
  0xE1, 0xB8, 0xA7, 0x00, 0xE1, 0xB8, 0xA9, 0x00, 0xE1, 0xB8, 0xAB, 0x00,
  0xE1, 0xB8, 0xAD, 0x00, 0xE1, 0xB8, 0xAF, 0x00, 0xE1, 0xB8, 0xB1, 0x00,
  0xE1, 0xB8, 0xB3, 0x00, 0xE1, 0xB8, 0xB5, 0x00, 0xE1, 0xB8, 0xB7, 0x00,
  0xE1, 0xB8, 0xB9, 0x00, 0xE1, 0xB8, 0xBB, 0x00, 0xE1, 0xB8, 0xBD, 0x00,
  0xE1, 0xB8, 0xBF, 0x00, 0xE1, 0xB9, 0x81, 0x00, 0xE1, 0xB9, 0x83, 0x00,
  0xE1, 0xB9, 0x85, 0x00, 0xE1, 0xB9, 0x87, 0x00, 0xE1, 0xB9, 0x89, 0x00,
  0xE1, 0xB9, 0x8B, 0x00, 0xE1, 0xB9, 0x8D, 0x00, 0xE1, 0xB9, 0x8F, 0x00,
  0xE1, 0xB9, 0x91, 0x00, 0xE1, 0xB9, 0x93, 0x00, 0xE1, 0xB9, 0x95, 0x00,
  0xE1, 0xB9, 0x97, 0x00, 0xE1, 0xB9, 0x99, 0x00, 0xE1, 0xB9, 0x9B, 0x00,
  0xE1, 0xB9, 0x9D, 0x00, 0xE1, 0xB9, 0x9F, 0x00, 0xE1, 0xB9, 0xA1, 0x00,
  0xE1, 0xB9, 0xA3, 0x00, 0xE1, 0xB9, 0xA5, 0x00, 0xE1, 0xB9, 0xA7, 0x00,
  0xE1, 0xB9, 0xA9, 0x00, 0xE1, 0xB9, 0xAB, 0x00, 0xE1, 0xB9, 0xAD, 0x00,
  0xE1, 0xB9, 0xAF, 0x00, 0xE1, 0xB9, 0xB1, 0x00, 0xE1, 0xB9, 0xB3, 0x00,
  0xE1, 0xB9, 0xB5, 0x00, 0xE1, 0xB9, 0xB7, 0x00, 0xE1, 0xB9, 0xB9, 0x00,
  0xE1, 0xB9, 0xBB, 0x00, 0xE1, 0xB9, 0xBD, 0x00, 0xE1, 0xB9, 0xBF, 0x00,
  0xE1, 0xBA, 0x81, 0x00, 0xE1, 0xBA, 0x83, 0x00, 0xE1, 0xBA, 0x85, 0x00,
  0xE1, 0xBA, 0x87, 0x00, 0xE1, 0xBA, 0x89, 0x00, 0xE1, 0xBA, 0x8B, 0x00,
  0xE1, 0xBA, 0x8D, 0x00, 0xE1, 0xBA, 0x8F, 0x00, 0xE1, 0xBA, 0x91, 0x00,
  0xE1, 0xBA, 0x93, 0x00, 0xE1, 0xBA, 0x95, 0x00, 0x68, 0xCC, 0xB1, 0x00,
  0x74, 0xCC, 0x88, 0x00, 0x77, 0xCC, 0x8A, 0x00, 0x79, 0xCC, 0x8A, 0x00,
  0x61, 0xCA, 0xBE, 0x00, 0xE1, 0xB9, 0xA1, 0x00, 0x73, 0x73, 0xE1, 0xBA,
  0xA1, 0x00, 0xE1, 0xBA, 0xA3, 0x00, 0xE1, 0xBA, 0xA5, 0x00, 0xE1, 0xBA,
  0xA7, 0x00, 0xE1, 0xBA, 0xA9, 0x00, 0xE1, 0xBA, 0xAB, 0x00, 0xE1, 0xBA,
  0xAD, 0x00, 0xE1, 0xBA, 0xAF, 0x00, 0xE1, 0xBA, 0xB1, 0x00, 0xE1, 0xBA,
  0xB3, 0x00, 0xE1, 0xBA, 0xB5, 0x00, 0xE1, 0xBA, 0xB7, 0x00, 0xE1, 0xBA,
  0xB9, 0x00, 0xE1, 0xBA, 0xBB, 0x00, 0xE1, 0xBA, 0xBD, 0x00, 0xE1, 0xBA,
  0xBF, 0x00, 0xE1, 0xBB, 0x81, 0x00, 0xE1, 0xBB, 0x83, 0x00, 0xE1, 0xBB,
  0x85, 0x00, 0xE1, 0xBB, 0x87, 0x00, 0xE1, 0xBB, 0x89, 0x00, 0xE1, 0xBB,
  0x8B, 0x00, 0xE1, 0xBB, 0x8D, 0x00, 0xE1, 0xBB, 0x8F, 0x00, 0xE1, 0xBB,
  0x91, 0x00, 0xE1, 0xBB, 0x93, 0x00, 0xE1, 0xBB, 0x95, 0x00, 0xE1, 0xBB,
  0x97, 0x00, 0xE1, 0xBB, 0x99, 0x00, 0xE1, 0xBB, 0x9B, 0x00, 0xE1, 0xBB,
  0x9D, 0x00, 0xE1, 0xBB, 0x9F, 0x00, 0xE1, 0xBB, 0xA1, 0x00, 0xE1, 0xBB,
  0xA3, 0x00, 0xE1, 0xBB, 0xA5, 0x00, 0xE1, 0xBB, 0xA7, 0x00, 0xE1, 0xBB,
  0xA9, 0x00, 0xE1, 0xBB, 0xAB, 0x00, 0xE1, 0xBB, 0xAD, 0x00, 0xE1, 0xBB,
  0xAF, 0x00, 0xE1, 0xBB, 0xB1, 0x00, 0xE1, 0xBB, 0xB3, 0x00, 0xE1, 0xBB,
  0xB5, 0x00, 0xE1, 0xBB, 0xB7, 0x00, 0xE1, 0xBB, 0xB9, 0x00, 0xE1, 0xBB,
  0xBB, 0x00, 0xE1, 0xBB, 0xBD, 0x00, 0xE1, 0xBB, 0xBF, 0x00, 0xE1, 0xBC,
  0x80, 0x00, 0xE1, 0xBC, 0x81, 0x00, 0xE1, 0xBC, 0x82, 0x00, 0xE1, 0xBC,
  0x83, 0x00, 0xE1, 0xBC, 0x84, 0x00, 0xE1, 0xBC, 0x85, 0x00, 0xE1, 0xBC,
  0x86, 0x00, 0xE1, 0xBC, 0x87, 0x00, 0xE1, 0xBC, 0x90, 0x00, 0xE1, 0xBC,
  0x91, 0x00, 0xE1, 0xBC, 0x92, 0x00, 0xE1, 0xBC, 0x93, 0x00, 0xE1, 0xBC,
  0x94, 0x00, 0xE1, 0xBC, 0x95, 0x00, 0xE1, 0xBC, 0xA0, 0x00, 0xE1, 0xBC,
  0xA1, 0x00, 0xE1, 0xBC, 0xA2, 0x00, 0xE1, 0xBC, 0xA3, 0x00, 0xE1, 0xBC,
  0xA4, 0x00, 0xE1, 0xBC, 0xA5, 0x00, 0xE1, 0xBC, 0xA6, 0x00, 0xE1, 0xBC,
  0xA7, 0x00, 0xE1, 0xBC, 0xB0, 0x00, 0xE1, 0xBC, 0xB1, 0x00, 0xE1, 0xBC,
  0xB2, 0x00, 0xE1, 0xBC, 0xB3, 0x00, 0xE1, 0xBC, 0xB4, 0x00, 0xE1, 0xBC,
  0xB5, 0x00, 0xE1, 0xBC, 0xB6, 0x00, 0xE1, 0xBC, 0xB7, 0x00, 0xE1, 0xBD,
  0x80, 0x00, 0xE1, 0xBD, 0x81, 0x00, 0xE1, 0xBD, 0x82, 0x00, 0xE1, 0xBD,
  0x83, 0x00, 0xE1, 0xBD, 0x84, 0x00, 0xE1, 0xBD, 0x85, 0x00, 0xCF, 0x85,
  0xCC, 0x93, 0xCF, 0x85, 0xCC, 0x93, 0xCC, 0x80, 0xCF, 0x85, 0xCC, 0x93,
  0xCC, 0x81, 0xCF, 0x85, 0xCC, 0x93, 0xCD, 0x82, 0xE1, 0xBD, 0x91, 0x00,
  0xE1, 0xBD, 0x93, 0x00, 0xE1, 0xBD, 0x95, 0x00, 0xE1, 0xBD, 0x97, 0x00,
  0xE1, 0xBD, 0xA0, 0x00, 0xE1, 0xBD, 0xA1, 0x00, 0xE1, 0xBD, 0xA2, 0x00,
  0xE1, 0xBD, 0xA3, 0x00, 0xE1, 0xBD, 0xA4, 0x00, 0xE1, 0xBD, 0xA5, 0x00,
  0xE1, 0xBD, 0xA6, 0x00, 0xE1, 0xBD, 0xA7, 0x00, 0xE1, 0xBC, 0x80, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x81, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0x82, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x83, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0x84, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x85, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0x86, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x87, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0x80, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x81, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0x82, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x83, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0x84, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x85, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0x86, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0x87, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA0, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA1, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA2, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA3, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA4, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA5, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA6, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA7, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA0, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA1, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA2, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA3, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA4, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA5, 0xCE, 0xB9, 0x00, 0xE1, 0xBC, 0xA6, 0xCE,
  0xB9, 0x00, 0xE1, 0xBC, 0xA7, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA0, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA1, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA2, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA3, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA4, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA5, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA6, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA7, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA0, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA1, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA2, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA3, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA4, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA5, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xA6, 0xCE,
  0xB9, 0x00, 0xE1, 0xBD, 0xA7, 0xCE, 0xB9, 0x00, 0xE1, 0xBD, 0xB0, 0xCE,
  0xB9, 0x00, 0xCE, 0xB1, 0xCE, 0xB9, 0xCE, 0xAC, 0xCE, 0xB9, 0xCE, 0xB1,
  0xCD, 0x82, 0xCE, 0xB1, 0xCD, 0x82, 0xCE, 0xB9, 0xE1, 0xBE, 0xB0, 0x00,
  0xE1, 0xBE, 0xB1, 0x00, 0xE1, 0xBD, 0xB0, 0x00, 0xE1, 0xBD, 0xB1, 0x00,
  0xCE, 0xB1, 0xCE, 0xB9, 0xCE, 0xB9, 0xE1, 0xBD, 0xB4, 0xCE, 0xB9, 0x00,
  0xCE, 0xB7, 0xCE, 0xB9, 0xCE, 0xAE, 0xCE, 0xB9, 0xCE, 0xB7, 0xCD, 0x82,
  0xCE, 0xB7, 0xCD, 0x82, 0xCE, 0xB9, 0xE1, 0xBD, 0xB2, 0x00, 0xE1, 0xBD,
  0xB3, 0x00, 0xE1, 0xBD, 0xB4, 0x00, 0xE1, 0xBD, 0xB5, 0x00, 0xCE, 0xB7,
  0xCE, 0xB9, 0xCE, 0xB9, 0xCC, 0x88, 0xCC, 0x80, 0xCE, 0xB9, 0xCC, 0x88,
  0xCC, 0x81, 0xCE, 0xB9, 0xCD, 0x82, 0xCE, 0xB9, 0xCC, 0x88, 0xCD, 0x82,
  0xE1, 0xBF, 0x90, 0x00, 0xE1, 0xBF, 0x91, 0x00, 0xE1, 0xBD, 0xB6, 0x00,
  0xE1, 0xBD, 0xB7, 0x00, 0xCF, 0x85, 0xCC, 0x88, 0xCC, 0x80, 0xCF, 0x85,
  0xCC, 0x88, 0xCC, 0x81, 0xCF, 0x81, 0xCC, 0x93, 0xCF, 0x85, 0xCD, 0x82,
  0xCF, 0x85, 0xCC, 0x88, 0xCD, 0x82, 0xE1, 0xBF, 0xA0, 0x00, 0xE1, 0xBF,
  0xA1, 0x00, 0xE1, 0xBD, 0xBA, 0x00, 0xE1, 0xBD, 0xBB, 0x00, 0xE1, 0xBF,
  0xA5, 0x00, 0xE1, 0xBD, 0xBC, 0xCE, 0xB9, 0x00, 0xCF, 0x89, 0xCE, 0xB9,
  0xCF, 0x8E, 0xCE, 0xB9, 0xCF, 0x89, 0xCD, 0x82, 0xCF, 0x89, 0xCD, 0x82,
  0xCE, 0xB9, 0xE1, 0xBD, 0xB8, 0x00, 0xE1, 0xBD, 0xB9, 0x00, 0xE1, 0xBD,
  0xBC, 0x00, 0xE1, 0xBD, 0xBD, 0x00, 0xCF, 0x89, 0xCE, 0xB9, 0xCF, 0x89,
  0x6B, 0x00, 0xC3, 0xA5, 0xE2, 0x85, 0x8E, 0x00, 0xE2, 0x85, 0xB0, 0x00,
  0xE2, 0x85, 0xB1, 0x00, 0xE2, 0x85, 0xB2, 0x00, 0xE2, 0x85, 0xB3, 0x00,
  0xE2, 0x85, 0xB4, 0x00, 0xE2, 0x85, 0xB5, 0x00, 0xE2, 0x85, 0xB6, 0x00,
  0xE2, 0x85, 0xB7, 0x00, 0xE2, 0x85, 0xB8, 0x00, 0xE2, 0x85, 0xB9, 0x00,
  0xE2, 0x85, 0xBA, 0x00, 0xE2, 0x85, 0xBB, 0x00, 0xE2, 0x85, 0xBC, 0x00,
  0xE2, 0x85, 0xBD, 0x00, 0xE2, 0x85, 0xBE, 0x00, 0xE2, 0x85, 0xBF, 0x00,
  0xE2, 0x86, 0x84, 0x00, 0xE2, 0x93, 0x90, 0x00, 0xE2, 0x93, 0x91, 0x00,
  0xE2, 0x93, 0x92, 0x00, 0xE2, 0x93, 0x93, 0x00, 0xE2, 0x93, 0x94, 0x00,
  0xE2, 0x93, 0x95, 0x00, 0xE2, 0x93, 0x96, 0x00, 0xE2, 0x93, 0x97, 0x00,
  0xE2, 0x93, 0x98, 0x00, 0xE2, 0x93, 0x99, 0x00, 0xE2, 0x93, 0x9A, 0x00,
  0xE2, 0x93, 0x9B, 0x00, 0xE2, 0x93, 0x9C, 0x00, 0xE2, 0x93, 0x9D, 0x00,
  0xE2, 0x93, 0x9E, 0x00, 0xE2, 0x93, 0x9F, 0x00, 0xE2, 0x93, 0xA0, 0x00,
  0xE2, 0x93, 0xA1, 0x00, 0xE2, 0x93, 0xA2, 0x00, 0xE2, 0x93, 0xA3, 0x00,
  0xE2, 0x93, 0xA4, 0x00, 0xE2, 0x93, 0xA5, 0x00, 0xE2, 0x93, 0xA6, 0x00,
  0xE2, 0x93, 0xA7, 0x00, 0xE2, 0x93, 0xA8, 0x00, 0xE2, 0x93, 0xA9, 0x00,
  0xE2, 0xB0, 0xB0, 0x00, 0xE2, 0xB0, 0xB1, 0x00, 0xE2, 0xB0, 0xB2, 0x00,
  0xE2, 0xB0, 0xB3, 0x00, 0xE2, 0xB0, 0xB4, 0x00, 0xE2, 0xB0, 0xB5, 0x00,
  0xE2, 0xB0, 0xB6, 0x00, 0xE2, 0xB0, 0xB7, 0x00, 0xE2, 0xB0, 0xB8, 0x00,
  0xE2, 0xB0, 0xB9, 0x00, 0xE2, 0xB0, 0xBA, 0x00, 0xE2, 0xB0, 0xBB, 0x00,
  0xE2, 0xB0, 0xBC, 0x00, 0xE2, 0xB0, 0xBD, 0x00, 0xE2, 0xB0, 0xBE, 0x00,
  0xE2, 0xB0, 0xBF, 0x00, 0xE2, 0xB1, 0x80, 0x00, 0xE2, 0xB1, 0x81, 0x00,
  0xE2, 0xB1, 0x82, 0x00, 0xE2, 0xB1, 0x83, 0x00, 0xE2, 0xB1, 0x84, 0x00,
  0xE2, 0xB1, 0x85, 0x00, 0xE2, 0xB1, 0x86, 0x00, 0xE2, 0xB1, 0x87, 0x00,
  0xE2, 0xB1, 0x88, 0x00, 0xE2, 0xB1, 0x89, 0x00, 0xE2, 0xB1, 0x8A, 0x00,
  0xE2, 0xB1, 0x8B, 0x00, 0xE2, 0xB1, 0x8C, 0x00, 0xE2, 0xB1, 0x8D, 0x00,
  0xE2, 0xB1, 0x8E, 0x00, 0xE2, 0xB1, 0x8F, 0x00, 0xE2, 0xB1, 0x90, 0x00,
  0xE2, 0xB1, 0x91, 0x00, 0xE2, 0xB1, 0x92, 0x00, 0xE2, 0xB1, 0x93, 0x00,
  0xE2, 0xB1, 0x94, 0x00, 0xE2, 0xB1, 0x95, 0x00, 0xE2, 0xB1, 0x96, 0x00,
  0xE2, 0xB1, 0x97, 0x00, 0xE2, 0xB1, 0x98, 0x00, 0xE2, 0xB1, 0x99, 0x00,
  0xE2, 0xB1, 0x9A, 0x00, 0xE2, 0xB1, 0x9B, 0x00, 0xE2, 0xB1, 0x9C, 0x00,
  0xE2, 0xB1, 0x9D, 0x00, 0xE2, 0xB1, 0x9E, 0x00, 0xE2, 0xB1, 0x9F, 0x00,
  0xE2, 0xB1, 0xA1, 0x00, 0xC9, 0xAB, 0xE1, 0xB5, 0xBD, 0x00, 0xC9, 0xBD,
  0xE2, 0xB1, 0xA8, 0x00, 0xE2, 0xB1, 0xAA, 0x00, 0xE2, 0xB1, 0xAC, 0x00,
  0xC9, 0x91, 0xC9, 0xB1, 0xC9, 0x90, 0xC9, 0x92, 0xE2, 0xB1, 0xB3, 0x00,
  0xE2, 0xB1, 0xB6, 0x00, 0xC8, 0xBF, 0xC9, 0x80, 0xE2, 0xB2, 0x81, 0x00,
  0xE2, 0xB2, 0x83, 0x00, 0xE2, 0xB2, 0x85, 0x00, 0xE2, 0xB2, 0x87, 0x00,
  0xE2, 0xB2, 0x89, 0x00, 0xE2, 0xB2, 0x8B, 0x00, 0xE2, 0xB2, 0x8D, 0x00,
  0xE2, 0xB2, 0x8F, 0x00, 0xE2, 0xB2, 0x91, 0x00, 0xE2, 0xB2, 0x93, 0x00,
  0xE2, 0xB2, 0x95, 0x00, 0xE2, 0xB2, 0x97, 0x00, 0xE2, 0xB2, 0x99, 0x00,
  0xE2, 0xB2, 0x9B, 0x00, 0xE2, 0xB2, 0x9D, 0x00, 0xE2, 0xB2, 0x9F, 0x00,
  0xE2, 0xB2, 0xA1, 0x00, 0xE2, 0xB2, 0xA3, 0x00, 0xE2, 0xB2, 0xA5, 0x00,
  0xE2, 0xB2, 0xA7, 0x00, 0xE2, 0xB2, 0xA9, 0x00, 0xE2, 0xB2, 0xAB, 0x00,
  0xE2, 0xB2, 0xAD, 0x00, 0xE2, 0xB2, 0xAF, 0x00, 0xE2, 0xB2, 0xB1, 0x00,
  0xE2, 0xB2, 0xB3, 0x00, 0xE2, 0xB2, 0xB5, 0x00, 0xE2, 0xB2, 0xB7, 0x00,
  0xE2, 0xB2, 0xB9, 0x00, 0xE2, 0xB2, 0xBB, 0x00, 0xE2, 0xB2, 0xBD, 0x00,
  0xE2, 0xB2, 0xBF, 0x00, 0xE2, 0xB3, 0x81, 0x00, 0xE2, 0xB3, 0x83, 0x00,
  0xE2, 0xB3, 0x85, 0x00, 0xE2, 0xB3, 0x87, 0x00, 0xE2, 0xB3, 0x89, 0x00,
  0xE2, 0xB3, 0x8B, 0x00, 0xE2, 0xB3, 0x8D, 0x00, 0xE2, 0xB3, 0x8F, 0x00,
  0xE2, 0xB3, 0x91, 0x00, 0xE2, 0xB3, 0x93, 0x00, 0xE2, 0xB3, 0x95, 0x00,
  0xE2, 0xB3, 0x97, 0x00, 0xE2, 0xB3, 0x99, 0x00, 0xE2, 0xB3, 0x9B, 0x00,
  0xE2, 0xB3, 0x9D, 0x00, 0xE2, 0xB3, 0x9F, 0x00, 0xE2, 0xB3, 0xA1, 0x00,
  0xE2, 0xB3, 0xA3, 0x00, 0xE2, 0xB3, 0xAC, 0x00, 0xE2, 0xB3, 0xAE, 0x00,
  0xE2, 0xB3, 0xB3, 0x00, 0xEA, 0x99, 0x81, 0x00, 0xEA, 0x99, 0x83, 0x00,
  0xEA, 0x99, 0x85, 0x00, 0xEA, 0x99, 0x87, 0x00, 0xEA, 0x99, 0x89, 0x00,
  0xEA, 0x99, 0x8B, 0x00, 0xEA, 0x99, 0x8D, 0x00, 0xEA, 0x99, 0x8F, 0x00,
  0xEA, 0x99, 0x91, 0x00, 0xEA, 0x99, 0x93, 0x00, 0xEA, 0x99, 0x95, 0x00,
  0xEA, 0x99, 0x97, 0x00, 0xEA, 0x99, 0x99, 0x00, 0xEA, 0x99, 0x9B, 0x00,
  0xEA, 0x99, 0x9D, 0x00, 0xEA, 0x99, 0x9F, 0x00, 0xEA, 0x99, 0xA1, 0x00,
  0xEA, 0x99, 0xA3, 0x00, 0xEA, 0x99, 0xA5, 0x00, 0xEA, 0x99, 0xA7, 0x00,
  0xEA, 0x99, 0xA9, 0x00, 0xEA, 0x99, 0xAB, 0x00, 0xEA, 0x99, 0xAD, 0x00,
  0xEA, 0x9A, 0x81, 0x00, 0xEA, 0x9A, 0x83, 0x00, 0xEA, 0x9A, 0x85, 0x00,
  0xEA, 0x9A, 0x87, 0x00, 0xEA, 0x9A, 0x89, 0x00, 0xEA, 0x9A, 0x8B, 0x00,
  0xEA, 0x9A, 0x8D, 0x00, 0xEA, 0x9A, 0x8F, 0x00, 0xEA, 0x9A, 0x91, 0x00,
  0xEA, 0x9A, 0x93, 0x00, 0xEA, 0x9A, 0x95, 0x00, 0xEA, 0x9A, 0x97, 0x00,
  0xEA, 0x9A, 0x99, 0x00, 0xEA, 0x9A, 0x9B, 0x00, 0xEA, 0x9C, 0xA3, 0x00,
  0xEA, 0x9C, 0xA5, 0x00, 0xEA, 0x9C, 0xA7, 0x00, 0xEA, 0x9C, 0xA9, 0x00,
  0xEA, 0x9C, 0xAB, 0x00, 0xEA, 0x9C, 0xAD, 0x00, 0xEA, 0x9C, 0xAF, 0x00,
  0xEA, 0x9C, 0xB3, 0x00, 0xEA, 0x9C, 0xB5, 0x00, 0xEA, 0x9C, 0xB7, 0x00,
  0xEA, 0x9C, 0xB9, 0x00, 0xEA, 0x9C, 0xBB, 0x00, 0xEA, 0x9C, 0xBD, 0x00,
  0xEA, 0x9C, 0xBF, 0x00, 0xEA, 0x9D, 0x81, 0x00, 0xEA, 0x9D, 0x83, 0x00,
  0xEA, 0x9D, 0x85, 0x00, 0xEA, 0x9D, 0x87, 0x00, 0xEA, 0x9D, 0x89, 0x00,
  0xEA, 0x9D, 0x8B, 0x00, 0xEA, 0x9D, 0x8D, 0x00, 0xEA, 0x9D, 0x8F, 0x00,
  0xEA, 0x9D, 0x91, 0x00, 0xEA, 0x9D, 0x93, 0x00, 0xEA, 0x9D, 0x95, 0x00,
  0xEA, 0x9D, 0x97, 0x00, 0xEA, 0x9D, 0x99, 0x00, 0xEA, 0x9D, 0x9B, 0x00,
  0xEA, 0x9D, 0x9D, 0x00, 0xEA, 0x9D, 0x9F, 0x00, 0xEA, 0x9D, 0xA1, 0x00,
  0xEA, 0x9D, 0xA3, 0x00, 0xEA, 0x9D, 0xA5, 0x00, 0xEA, 0x9D, 0xA7, 0x00,
  0xEA, 0x9D, 0xA9, 0x00, 0xEA, 0x9D, 0xAB, 0x00, 0xEA, 0x9D, 0xAD, 0x00,
  0xEA, 0x9D, 0xAF, 0x00, 0xEA, 0x9D, 0xBA, 0x00, 0xEA, 0x9D, 0xBC, 0x00,
  0xE1, 0xB5, 0xB9, 0x00, 0xEA, 0x9D, 0xBF, 0x00, 0xEA, 0x9E, 0x81, 0x00,
  0xEA, 0x9E, 0x83, 0x00, 0xEA, 0x9E, 0x85, 0x00, 0xEA, 0x9E, 0x87, 0x00,
  0xEA, 0x9E, 0x8C, 0x00, 0xC9, 0xA5, 0xEA, 0x9E, 0x91, 0x00, 0xEA, 0x9E,
  0x93, 0x00, 0xEA, 0x9E, 0x97, 0x00, 0xEA, 0x9E, 0x99, 0x00, 0xEA, 0x9E,
  0x9B, 0x00, 0xEA, 0x9E, 0x9D, 0x00, 0xEA, 0x9E, 0x9F, 0x00, 0xEA, 0x9E,
  0xA1, 0x00, 0xEA, 0x9E, 0xA3, 0x00, 0xEA, 0x9E, 0xA5, 0x00, 0xEA, 0x9E,
  0xA7, 0x00, 0xEA, 0x9E, 0xA9, 0x00, 0xC9, 0xA6, 0xC9, 0x9C, 0xC9, 0xA1,
  0xC9, 0xAC, 0xC9, 0xAA, 0xCA, 0x9E, 0xCA, 0x87, 0xCA, 0x9D, 0xEA, 0xAD,
  0x93, 0x00, 0xEA, 0x9E, 0xB5, 0x00, 0xEA, 0x9E, 0xB7, 0x00, 0xEA, 0x9E,
  0xB9, 0x00, 0xEA, 0x9E, 0xBB, 0x00, 0xEA, 0x9E, 0xBD, 0x00, 0xEA, 0x9E,
  0xBF, 0x00, 0xEA, 0x9F, 0x81, 0x00, 0xEA, 0x9F, 0x83, 0x00, 0xEA, 0x9E,
  0x94, 0x00, 0xCA, 0x82, 0xE1, 0xB6, 0x8E, 0x00, 0xEA, 0x9F, 0x88, 0x00,
  0xEA, 0x9F, 0x8A, 0x00, 0xEA, 0x9F, 0x91, 0x00, 0xEA, 0x9F, 0x97, 0x00,
  0xEA, 0x9F, 0x99, 0x00, 0xEA, 0x9F, 0xB6, 0x00, 0xE1, 0x8E, 0xA0, 0x00,
  0xE1, 0x8E, 0xA1, 0x00, 0xE1, 0x8E, 0xA2, 0x00, 0xE1, 0x8E, 0xA3, 0x00,
  0xE1, 0x8E, 0xA4, 0x00, 0xE1, 0x8E, 0xA5, 0x00, 0xE1, 0x8E, 0xA6, 0x00,
  0xE1, 0x8E, 0xA7, 0x00, 0xE1, 0x8E, 0xA8, 0x00, 0xE1, 0x8E, 0xA9, 0x00,
  0xE1, 0x8E, 0xAA, 0x00, 0xE1, 0x8E, 0xAB, 0x00, 0xE1, 0x8E, 0xAC, 0x00,
  0xE1, 0x8E, 0xAD, 0x00, 0xE1, 0x8E, 0xAE, 0x00, 0xE1, 0x8E, 0xAF, 0x00,
  0xE1, 0x8E, 0xB0, 0x00, 0xE1, 0x8E, 0xB1, 0x00, 0xE1, 0x8E, 0xB2, 0x00,
  0xE1, 0x8E, 0xB3, 0x00, 0xE1, 0x8E, 0xB4, 0x00, 0xE1, 0x8E, 0xB5, 0x00,
  0xE1, 0x8E, 0xB6, 0x00, 0xE1, 0x8E, 0xB7, 0x00, 0xE1, 0x8E, 0xB8, 0x00,
  0xE1, 0x8E, 0xB9, 0x00, 0xE1, 0x8E, 0xBA, 0x00, 0xE1, 0x8E, 0xBB, 0x00,
  0xE1, 0x8E, 0xBC, 0x00, 0xE1, 0x8E, 0xBD, 0x00, 0xE1, 0x8E, 0xBE, 0x00,
  0xE1, 0x8E, 0xBF, 0x00, 0xE1, 0x8F, 0x80, 0x00, 0xE1, 0x8F, 0x81, 0x00,
  0xE1, 0x8F, 0x82, 0x00, 0xE1, 0x8F, 0x83, 0x00, 0xE1, 0x8F, 0x84, 0x00,
  0xE1, 0x8F, 0x85, 0x00, 0xE1, 0x8F, 0x86, 0x00, 0xE1, 0x8F, 0x87, 0x00,
  0xE1, 0x8F, 0x88, 0x00, 0xE1, 0x8F, 0x89, 0x00, 0xE1, 0x8F, 0x8A, 0x00,
  0xE1, 0x8F, 0x8B, 0x00, 0xE1, 0x8F, 0x8C, 0x00, 0xE1, 0x8F, 0x8D, 0x00,
  0xE1, 0x8F, 0x8E, 0x00, 0xE1, 0x8F, 0x8F, 0x00, 0xE1, 0x8F, 0x90, 0x00,
  0xE1, 0x8F, 0x91, 0x00, 0xE1, 0x8F, 0x92, 0x00, 0xE1, 0x8F, 0x93, 0x00,
  0xE1, 0x8F, 0x94, 0x00, 0xE1, 0x8F, 0x95, 0x00, 0xE1, 0x8F, 0x96, 0x00,
  0xE1, 0x8F, 0x97, 0x00, 0xE1, 0x8F, 0x98, 0x00, 0xE1, 0x8F, 0x99, 0x00,
  0xE1, 0x8F, 0x9A, 0x00, 0xE1, 0x8F, 0x9B, 0x00, 0xE1, 0x8F, 0x9C, 0x00,
  0xE1, 0x8F, 0x9D, 0x00, 0xE1, 0x8F, 0x9E, 0x00, 0xE1, 0x8F, 0x9F, 0x00,
  0xE1, 0x8F, 0xA0, 0x00, 0xE1, 0x8F, 0xA1, 0x00, 0xE1, 0x8F, 0xA2, 0x00,
  0xE1, 0x8F, 0xA3, 0x00, 0xE1, 0x8F, 0xA4, 0x00, 0xE1, 0x8F, 0xA5, 0x00,
  0xE1, 0x8F, 0xA6, 0x00, 0xE1, 0x8F, 0xA7, 0x00, 0xE1, 0x8F, 0xA8, 0x00,
  0xE1, 0x8F, 0xA9, 0x00, 0xE1, 0x8F, 0xAA, 0x00, 0xE1, 0x8F, 0xAB, 0x00,
  0xE1, 0x8F, 0xAC, 0x00, 0xE1, 0x8F, 0xAD, 0x00, 0xE1, 0x8F, 0xAE, 0x00,
  0xE1, 0x8F, 0xAF, 0x00, 0x66, 0x66, 0x66, 0x69, 0x66, 0x6C, 0x66, 0x66,
  0x69, 0x00, 0x66, 0x66, 0x6C, 0x00, 0x73, 0x74, 0x73, 0x74, 0xD5, 0xB4,
  0xD5, 0xB6, 0xD5, 0xB4, 0xD5, 0xA5, 0xD5, 0xB4, 0xD5, 0xAB, 0xD5, 0xBE,
  0xD5, 0xB6, 0xD5, 0xB4, 0xD5, 0xAD, 0xEF, 0xBD, 0x81, 0x00, 0xEF, 0xBD,
  0x82, 0x00, 0xEF, 0xBD, 0x83, 0x00, 0xEF, 0xBD, 0x84, 0x00, 0xEF, 0xBD,
  0x85, 0x00, 0xEF, 0xBD, 0x86, 0x00, 0xEF, 0xBD, 0x87, 0x00, 0xEF, 0xBD,
  0x88, 0x00, 0xEF, 0xBD, 0x89, 0x00, 0xEF, 0xBD, 0x8A, 0x00, 0xEF, 0xBD,
  0x8B, 0x00, 0xEF, 0xBD, 0x8C, 0x00, 0xEF, 0xBD, 0x8D, 0x00, 0xEF, 0xBD,
  0x8E, 0x00, 0xEF, 0xBD, 0x8F, 0x00, 0xEF, 0xBD, 0x90, 0x00, 0xEF, 0xBD,
  0x91, 0x00, 0xEF, 0xBD, 0x92, 0x00, 0xEF, 0xBD, 0x93, 0x00, 0xEF, 0xBD,
  0x94, 0x00, 0xEF, 0xBD, 0x95, 0x00, 0xEF, 0xBD, 0x96, 0x00, 0xEF, 0xBD,
  0x97, 0x00, 0xEF, 0xBD, 0x98, 0x00, 0xEF, 0xBD, 0x99, 0x00, 0xEF, 0xBD,
  0x9A, 0x00, 0xF0, 0x90, 0x90, 0xA8, 0xF0, 0x90, 0x90, 0xA9, 0xF0, 0x90,
  0x90, 0xAA, 0xF0, 0x90, 0x90, 0xAB, 0xF0, 0x90, 0x90, 0xAC, 0xF0, 0x90,
  0x90, 0xAD, 0xF0, 0x90, 0x90, 0xAE, 0xF0, 0x90, 0x90, 0xAF, 0xF0, 0x90,
  0x90, 0xB0, 0xF0, 0x90, 0x90, 0xB1, 0xF0, 0x90, 0x90, 0xB2, 0xF0, 0x90,
  0x90, 0xB3, 0xF0, 0x90, 0x90, 0xB4, 0xF0, 0x90, 0x90, 0xB5, 0xF0, 0x90,
  0x90, 0xB6, 0xF0, 0x90, 0x90, 0xB7, 0xF0, 0x90, 0x90, 0xB8, 0xF0, 0x90,
  0x90, 0xB9, 0xF0, 0x90, 0x90, 0xBA, 0xF0, 0x90, 0x90, 0xBB, 0xF0, 0x90,
  0x90, 0xBC, 0xF0, 0x90, 0x90, 0xBD, 0xF0, 0x90, 0x90, 0xBE, 0xF0, 0x90,
  0x90, 0xBF, 0xF0, 0x90, 0x91, 0x80, 0xF0, 0x90, 0x91, 0x81, 0xF0, 0x90,
  0x91, 0x82, 0xF0, 0x90, 0x91, 0x83, 0xF0, 0x90, 0x91, 0x84, 0xF0, 0x90,
  0x91, 0x85, 0xF0, 0x90, 0x91, 0x86, 0xF0, 0x90, 0x91, 0x87, 0xF0, 0x90,
  0x91, 0x88, 0xF0, 0x90, 0x91, 0x89, 0xF0, 0x90, 0x91, 0x8A, 0xF0, 0x90,
  0x91, 0x8B, 0xF0, 0x90, 0x91, 0x8C, 0xF0, 0x90, 0x91, 0x8D, 0xF0, 0x90,
  0x91, 0x8E, 0xF0, 0x90, 0x91, 0x8F, 0xF0, 0x90, 0x93, 0x98, 0xF0, 0x90,
  0x93, 0x99, 0xF0, 0x90, 0x93, 0x9A, 0xF0, 0x90, 0x93, 0x9B, 0xF0, 0x90,
  0x93, 0x9C, 0xF0, 0x90, 0x93, 0x9D, 0xF0, 0x90, 0x93, 0x9E, 0xF0, 0x90,
  0x93, 0x9F, 0xF0, 0x90, 0x93, 0xA0, 0xF0, 0x90, 0x93, 0xA1, 0xF0, 0x90,
  0x93, 0xA2, 0xF0, 0x90, 0x93, 0xA3, 0xF0, 0x90, 0x93, 0xA4, 0xF0, 0x90,
  0x93, 0xA5, 0xF0, 0x90, 0x93, 0xA6, 0xF0, 0x90, 0x93, 0xA7, 0xF0, 0x90,
  0x93, 0xA8, 0xF0, 0x90, 0x93, 0xA9, 0xF0, 0x90, 0x93, 0xAA, 0xF0, 0x90,
  0x93, 0xAB, 0xF0, 0x90, 0x93, 0xAC, 0xF0, 0x90, 0x93, 0xAD, 0xF0, 0x90,
  0x93, 0xAE, 0xF0, 0x90, 0x93, 0xAF, 0xF0, 0x90, 0x93, 0xB0, 0xF0, 0x90,
  0x93, 0xB1, 0xF0, 0x90, 0x93, 0xB2, 0xF0, 0x90, 0x93, 0xB3, 0xF0, 0x90,
  0x93, 0xB4, 0xF0, 0x90, 0x93, 0xB5, 0xF0, 0x90, 0x93, 0xB6, 0xF0, 0x90,
  0x93, 0xB7, 0xF0, 0x90, 0x93, 0xB8, 0xF0, 0x90, 0x93, 0xB9, 0xF0, 0x90,
  0x93, 0xBA, 0xF0, 0x90, 0x93, 0xBB, 0xF0, 0x90, 0x96, 0x97, 0xF0, 0x90,
  0x96, 0x98, 0xF0, 0x90, 0x96, 0x99, 0xF0, 0x90, 0x96, 0x9A, 0xF0, 0x90,
  0x96, 0x9B, 0xF0, 0x90, 0x96, 0x9C, 0xF0, 0x90, 0x96, 0x9D, 0xF0, 0x90,
  0x96, 0x9E, 0xF0, 0x90, 0x96, 0x9F, 0xF0, 0x90, 0x96, 0xA0, 0xF0, 0x90,
  0x96, 0xA1, 0xF0, 0x90, 0x96, 0xA3, 0xF0, 0x90, 0x96, 0xA4, 0xF0, 0x90,
  0x96, 0xA5, 0xF0, 0x90, 0x96, 0xA6, 0xF0, 0x90, 0x96, 0xA7, 0xF0, 0x90,
  0x96, 0xA8, 0xF0, 0x90, 0x96, 0xA9, 0xF0, 0x90, 0x96, 0xAA, 0xF0, 0x90,
  0x96, 0xAB, 0xF0, 0x90, 0x96, 0xAC, 0xF0, 0x90, 0x96, 0xAD, 0xF0, 0x90,
  0x96, 0xAE, 0xF0, 0x90, 0x96, 0xAF, 0xF0, 0x90, 0x96, 0xB0, 0xF0, 0x90,
  0x96, 0xB1, 0xF0, 0x90, 0x96, 0xB3, 0xF0, 0x90, 0x96, 0xB4, 0xF0, 0x90,
  0x96, 0xB5, 0xF0, 0x90, 0x96, 0xB6, 0xF0, 0x90, 0x96, 0xB7, 0xF0, 0x90,
  0x96, 0xB8, 0xF0, 0x90, 0x96, 0xB9, 0xF0, 0x90, 0x96, 0xBB, 0xF0, 0x90,
  0x96, 0xBC, 0xF0, 0x90, 0xB3, 0x80, 0xF0, 0x90, 0xB3, 0x81, 0xF0, 0x90,
  0xB3, 0x82, 0xF0, 0x90, 0xB3, 0x83, 0xF0, 0x90, 0xB3, 0x84, 0xF0, 0x90,
  0xB3, 0x85, 0xF0, 0x90, 0xB3, 0x86, 0xF0, 0x90, 0xB3, 0x87, 0xF0, 0x90,
  0xB3, 0x88, 0xF0, 0x90, 0xB3, 0x89, 0xF0, 0x90, 0xB3, 0x8A, 0xF0, 0x90,
  0xB3, 0x8B, 0xF0, 0x90, 0xB3, 0x8C, 0xF0, 0x90, 0xB3, 0x8D, 0xF0, 0x90,
  0xB3, 0x8E, 0xF0, 0x90, 0xB3, 0x8F, 0xF0, 0x90, 0xB3, 0x90, 0xF0, 0x90,
  0xB3, 0x91, 0xF0, 0x90, 0xB3, 0x92, 0xF0, 0x90, 0xB3, 0x93, 0xF0, 0x90,
  0xB3, 0x94, 0xF0, 0x90, 0xB3, 0x95, 0xF0, 0x90, 0xB3, 0x96, 0xF0, 0x90,
  0xB3, 0x97, 0xF0, 0x90, 0xB3, 0x98, 0xF0, 0x90, 0xB3, 0x99, 0xF0, 0x90,
  0xB3, 0x9A, 0xF0, 0x90, 0xB3, 0x9B, 0xF0, 0x90, 0xB3, 0x9C, 0xF0, 0x90,
  0xB3, 0x9D, 0xF0, 0x90, 0xB3, 0x9E, 0xF0, 0x90, 0xB3, 0x9F, 0xF0, 0x90,
  0xB3, 0xA0, 0xF0, 0x90, 0xB3, 0xA1, 0xF0, 0x90, 0xB3, 0xA2, 0xF0, 0x90,
  0xB3, 0xA3, 0xF0, 0x90, 0xB3, 0xA4, 0xF0, 0x90, 0xB3, 0xA5, 0xF0, 0x90,
  0xB3, 0xA6, 0xF0, 0x90, 0xB3, 0xA7, 0xF0, 0x90, 0xB3, 0xA8, 0xF0, 0x90,
  0xB3, 0xA9, 0xF0, 0x90, 0xB3, 0xAA, 0xF0, 0x90, 0xB3, 0xAB, 0xF0, 0x90,
  0xB3, 0xAC, 0xF0, 0x90, 0xB3, 0xAD, 0xF0, 0x90, 0xB3, 0xAE, 0xF0, 0x90,
  0xB3, 0xAF, 0xF0, 0x90, 0xB3, 0xB0, 0xF0, 0x90, 0xB3, 0xB1, 0xF0, 0x90,
  0xB3, 0xB2, 0xF0, 0x91, 0xA3, 0x80, 0xF0, 0x91, 0xA3, 0x81, 0xF0, 0x91,
  0xA3, 0x82, 0xF0, 0x91, 0xA3, 0x83, 0xF0, 0x91, 0xA3, 0x84, 0xF0, 0x91,
  0xA3, 0x85, 0xF0, 0x91, 0xA3, 0x86, 0xF0, 0x91, 0xA3, 0x87, 0xF0, 0x91,
  0xA3, 0x88, 0xF0, 0x91, 0xA3, 0x89, 0xF0, 0x91, 0xA3, 0x8A, 0xF0, 0x91,
  0xA3, 0x8B, 0xF0, 0x91, 0xA3, 0x8C, 0xF0, 0x91, 0xA3, 0x8D, 0xF0, 0x91,
  0xA3, 0x8E, 0xF0, 0x91, 0xA3, 0x8F, 0xF0, 0x91, 0xA3, 0x90, 0xF0, 0x91,
  0xA3, 0x91, 0xF0, 0x91, 0xA3, 0x92, 0xF0, 0x91, 0xA3, 0x93, 0xF0, 0x91,
  0xA3, 0x94, 0xF0, 0x91, 0xA3, 0x95, 0xF0, 0x91, 0xA3, 0x96, 0xF0, 0x91,
  0xA3, 0x97, 0xF0, 0x91, 0xA3, 0x98, 0xF0, 0x91, 0xA3, 0x99, 0xF0, 0x91,
  0xA3, 0x9A, 0xF0, 0x91, 0xA3, 0x9B, 0xF0, 0x91, 0xA3, 0x9C, 0xF0, 0x91,
  0xA3, 0x9D, 0xF0, 0x91, 0xA3, 0x9E, 0xF0, 0x91, 0xA3, 0x9F, 0xF0, 0x96,
  0xB9, 0xA0, 0xF0, 0x96, 0xB9, 0xA1, 0xF0, 0x96, 0xB9, 0xA2, 0xF0, 0x96,
  0xB9, 0xA3, 0xF0, 0x96, 0xB9, 0xA4, 0xF0, 0x96, 0xB9, 0xA5, 0xF0, 0x96,
  0xB9, 0xA6, 0xF0, 0x96, 0xB9, 0xA7, 0xF0, 0x96, 0xB9, 0xA8, 0xF0, 0x96,
  0xB9, 0xA9, 0xF0, 0x96, 0xB9, 0xAA, 0xF0, 0x96, 0xB9, 0xAB, 0xF0, 0x96,
  0xB9, 0xAC, 0xF0, 0x96, 0xB9, 0xAD, 0xF0, 0x96, 0xB9, 0xAE, 0xF0, 0x96,
  0xB9, 0xAF, 0xF0, 0x96, 0xB9, 0xB0, 0xF0, 0x96, 0xB9, 0xB1, 0xF0, 0x96,
  0xB9, 0xB2, 0xF0, 0x96, 0xB9, 0xB3, 0xF0, 0x96, 0xB9, 0xB4, 0xF0, 0x96,
  0xB9, 0xB5, 0xF0, 0x96, 0xB9, 0xB6, 0xF0, 0x96, 0xB9, 0xB7, 0xF0, 0x96,
  0xB9, 0xB8, 0xF0, 0x96, 0xB9, 0xB9, 0xF0, 0x96, 0xB9, 0xBA, 0xF0, 0x96,
  0xB9, 0xBB, 0xF0, 0x96, 0xB9, 0xBC, 0xF0, 0x96, 0xB9, 0xBD, 0xF0, 0x96,
  0xB9, 0xBE, 0xF0, 0x96, 0xB9, 0xBF, 0xF0, 0x9E, 0xA4, 0xA2, 0xF0, 0x9E,
  0xA4, 0xA3, 0xF0, 0x9E, 0xA4, 0xA4, 0xF0, 0x9E, 0xA4, 0xA5, 0xF0, 0x9E,
  0xA4, 0xA6, 0xF0, 0x9E, 0xA4, 0xA7, 0xF0, 0x9E, 0xA4, 0xA8, 0xF0, 0x9E,
  0xA4, 0xA9, 0xF0, 0x9E, 0xA4, 0xAA, 0xF0, 0x9E, 0xA4, 0xAB, 0xF0, 0x9E,
  0xA4, 0xAC, 0xF0, 0x9E, 0xA4, 0xAD, 0xF0, 0x9E, 0xA4, 0xAE, 0xF0, 0x9E,
  0xA4, 0xAF, 0xF0, 0x9E, 0xA4, 0xB0, 0xF0, 0x9E, 0xA4, 0xB1, 0xF0, 0x9E,
  0xA4, 0xB2, 0xF0, 0x9E, 0xA4, 0xB3, 0xF0, 0x9E, 0xA4, 0xB4, 0xF0, 0x9E,
  0xA4, 0xB5, 0xF0, 0x9E, 0xA4, 0xB6, 0xF0, 0x9E, 0xA4, 0xB7, 0xF0, 0x9E,
  0xA4, 0xB8, 0xF0, 0x9E, 0xA4, 0xB9, 0xF0, 0x9E, 0xA4, 0xBA, 0xF0, 0x9E,
  0xA4, 0xBB, 0xF0, 0x9E, 0xA4, 0xBC, 0xF0, 0x9E, 0xA4, 0xBD, 0xF0, 0x9E,
  0xA4, 0xBE, 0xF0, 0x9E, 0xA4, 0xBF, 0xF0, 0x9E, 0xA5, 0x80, 0xF0, 0x9E,
  0xA5, 0x81, 0xF0, 0x9E, 0xA5, 0x82, 0xF0, 0x9E, 0xA5, 0x83
};
