/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "aitooltextplugineditorinterface.h"
using namespace Qt::Literals::StringLiterals;

#include <KActionCollection>
#include <KLocalizedString>
#include <QAction>
#include <TextAutoGenerateText/TextAutoGenerateDialog>

AIToolTextPluginEditorInterface::AIToolTextPluginEditorInterface(QObject *parent)
    : MessageComposer::PluginEditorInterface(parent)
{
}

AIToolTextPluginEditorInterface::~AIToolTextPluginEditorInterface() = default;

void AIToolTextPluginEditorInterface::createAction(KActionCollection *ac)
{
    auto action = new QAction(i18nc("@action", "Open AI Chat"), this);
    ac->addAction(u"open_ai_chat"_s, action);
    connect(action, &QAction::triggered, this, &AIToolTextPluginEditorInterface::slotActivated);
    MessageComposer::PluginActionType type(action, MessageComposer::PluginActionType::Tools);
    setActionType(type);
}

void AIToolTextPluginEditorInterface::slotActivated()
{
    Q_EMIT emitPluginActivated(this);
}

void AIToolTextPluginEditorInterface::exec()
{
    auto dlg = new TextAutoGenerateText::TextAutoGenerateDialog(parentWidget());
    dlg->setAttribute(Qt::WA_DeleteOnClose);
    dlg->show();
}

#include "moc_aitooltextplugineditorinterface.cpp"
