module.exports = `snippet tbl
	create table \${1:table} (
		\${2:columns}
	);
snippet col
	\${1:name}	\${2:type}	\${3:default ''}	\${4:not null}
snippet ccol
	\${1:name}	varchar2(\${2:size})	\${3:default ''}	\${4:not null}
snippet ncol
	\${1:name}	number	\${3:default 0}	\${4:not null}
snippet dcol
	\${1:name}	date	\${3:default sysdate}	\${4:not null}
snippet ind
	create index \${3:\$1_\$2} on \${1:table}(\${2:column});
snippet uind
	create unique index \${1:name} on \${2:table}(\${3:column});
snippet tblcom
	comment on table \${1:table} is '\${2:comment}';
snippet colcom
	comment on column \${1:table}.\${2:column} is '\${3:comment}';
snippet addcol
	alter table \${1:table} add (\${2:column} \${3:type});
snippet seq
	create sequence \${1:name} start with \${2:1} increment by \${3:1} minvalue \${4:1};
snippet s*
	select * from \${1:table}
`;
