/****************************************************************************
**
** Copyright (C) 2018 Klaralvdalens Datakonsult AB (KDAB).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.10
import QtQuick.Scene3D 2.0
import Qt3D.Core 2.10
import Qt3D.Render 2.13
import Qt3D.Input 2.0
import Qt3D.Extras 2.0

Item {
    width: 800
    height: 600

    Scene3D {
        anchors.fill: parent

        Entity {
            id: sceneRoot

            Camera {
                id: camera
                projectionType: CameraLens.PerspectiveProjection
                fieldOfView: 45
                aspectRatio: 16/9
                nearPlane : 0.1
                farPlane : 1000.0
                position: Qt.vector3d( 0.0, 0.0, -4.0 )
                upVector: Qt.vector3d( 0.0, 1.0, 0.0 )
                viewCenter: Qt.vector3d( 0.0, 0.0, 0.0 )
            }

            OrbitCameraController {
                camera: camera
            }

            components: [
                RenderSettings {
                    activeFrameGraph: ForwardRenderer {
                        clearColor: Qt.rgba(0, 0.5, 1, 1)
                        camera: camera
                    }
                },
                // Event Source will be set by the Qt3DQuickWindow
                InputSettings { },
                DirectionalLight {
                    intensity: 0.8
                    worldDirection: camera.viewVector
                }
            ]


            NumberAnimation {
                target: cubeTransform
                property: "rotationY"
                duration: 10000
                from: 0
                to: 360

                loops: Animation.Infinite
                running: true
            }

            SharedGLTexture {
                id: shaderGLTexture
                textureId: _textureWidget.textureId
            }

            Entity {
                id: cubeEntity
                readonly property CuboidMesh cuboid: CuboidMesh {}
                readonly property DiffuseMapMaterial material: DiffuseMapMaterial {
                    diffuse: shaderGLTexture
                }
                Transform {
                    id: cubeTransform
                    rotationX: 180
                }

                components: [ cuboid, material, cubeTransform ]
            }
        }
    }

    Grid {
        spacing: 10
        columns: 2
        Text { text: "Target: " + _nameMapper.targetName(shaderGLTexture.target) }
        Text { text: "Format: " + _nameMapper.formatName(shaderGLTexture.format) }
        Text { text: "Width: " + shaderGLTexture.width }
        Text { text: "Height: " + shaderGLTexture.height }
        Text { text: "Depth: " + shaderGLTexture.depth }
        Text { text: "Layers: " + shaderGLTexture.layers }
        Text { text: "GL Texture Id: " + shaderGLTexture.textureId }
    }

}
